/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.aai.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RelatedTo {
    private final String id;
    private final String relationshipLabel;
    private final String nodeType;
    private final String url;

    public RelatedTo(
            @JsonProperty("id") String id,
            @JsonProperty("relationship-label") String relationshipLabel,
            @JsonProperty("node-type") String nodeType,
            @JsonProperty("url") String url) {
        this.id = id;
        this.relationshipLabel = relationshipLabel;
        this.nodeType = nodeType;
        this.url = url;
    }

    public String getId() {
        return id;
    }

    public String getRelationshipLabel() {
        return relationshipLabel;
    }

    public String getNodeType() {
        return nodeType;
    }

    public String getUrl() {
        return url;
    }
}
