/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.aai;

import org.onap.osam.model.Subscriber;
import org.onap.osam.model.SubscriberList;
import org.onap.osam.roles.RoleValidator;

import java.util.ArrayList;
import java.util.List;

public class SubscriberListWithFilterData {

    public SubscriberListWithFilterData(SubscriberList subscriberList, RoleValidator roleValidator){
        List<Subscriber> subscribers = subscriberList != null ? subscriberList.customer : new ArrayList<>();
        List<SubscriberWithFilter> subscribersWithFilter = new ArrayList<>();
        for (Subscriber subscriber :subscribers){
            SubscriberWithFilter subscriberWithFilter = new SubscriberWithFilter();
            subscriberWithFilter.setIsPermitted(roleValidator.isSubscriberPermitted(subscriber.globalCustomerId));
            subscriberWithFilter.subscriberType = subscriber.subscriberType;
            subscriberWithFilter.resourceVersion = subscriber.resourceVersion;
            subscriberWithFilter.subscriberName = subscriber.subscriberName;
            subscriberWithFilter.globalCustomerId = subscriber.globalCustomerId;
            subscribersWithFilter.add(subscriberWithFilter);
        }
        this.customer = subscribersWithFilter;
     }

    public List<SubscriberWithFilter> customer;
}
