/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.services;

import org.onap.osam.job.Job;
import org.onap.osam.job.JobAdapter;
import org.onap.osam.job.JobsBrokerService;
import org.onap.osam.model.JobBulk;
import org.onap.osam.model.JobModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.NotFoundException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Service
public class BulkInstantiationServiceImpl implements IBulkInstantiationService {

    private JobsBrokerService jobsBrokerService;
    private JobAdapter jobAdapter;

    @Autowired
    public BulkInstantiationServiceImpl(JobsBrokerService jobsBrokerService, JobAdapter jobAdapter) {
        this.jobsBrokerService = jobsBrokerService;
        this.jobAdapter = jobAdapter;
    }

    @Override
    public JobBulk saveBulk(Map<String, Object> bulkRequest) {
        List<Job> jobList = jobAdapter.createBulkOfJobs(bulkRequest);
        jobList.forEach(jobsBrokerService::add);
        return jobAdapter.toModelBulk(jobList);
    }

    @Override
    public JobModel getJob(UUID uuid) {
        Job job = jobsBrokerService.peek(uuid);

        if (job == null || job.getUuid() == null) {
            throw new NotFoundException("Job with uuid " + uuid + " not found");
        }
        return jobAdapter.toModel(job);
    }


}
