/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.onap.osam.aai.AaiClient;
import org.onap.osam.aai.AaiClientInterface;
import org.onap.osam.aai.PombaClientImpl;
import org.onap.osam.aai.PombaClientInterface;
import org.onap.osam.aai.PombaRestInterface;
import org.onap.osam.aai.model.PortDetailsTranslator;
import org.onap.osam.aai.util.AAIRestInterface;
import org.onap.osam.aai.util.HttpsAuthClient;
import org.onap.osam.aai.util.SSLContextProvider;
import org.onap.osam.aai.util.ServletRequestHelper;
import org.onap.osam.aai.util.SystemPropertyHelper;
import org.onap.osam.client.SyncRestClient;
import org.onap.osam.client.SyncRestClientInterface;
import org.onap.osam.scheduler.SchedulerRestInterface;
import org.onap.osam.scheduler.SchedulerRestInterfaceIfc;
import org.onap.osam.services.AaiServiceImpl;
import org.onap.osam.services.IAaiService;
import org.onap.osam.services.IPombaService;
import org.onap.osam.services.PombaServiceImpl;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

import javax.servlet.ServletContext;
import java.io.File;

@Configuration
public class WebConfig {

    @Bean
    public ObjectMapper getObjectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public IAaiService getAaiService() {
        return new AaiServiceImpl();
    }

    @Bean
    public PortDetailsTranslator portDetailsTranslator() {
        return new PortDetailsTranslator();
    }

    @Bean
    public AaiClientInterface getAaiRestInterface(@Qualifier("aaiRestInterface") AAIRestInterface restController, PortDetailsTranslator portsDetailsTranslator) {
        return new AaiClient(restController, portsDetailsTranslator);
    }

    @Bean(name = "aaiRestInterface")
    public AAIRestInterface aaiRestInterface(HttpsAuthClient httpsAuthClientFactory, ServletRequestHelper servletRequestHelper, SystemPropertyHelper systemPropertyHelper) {
        return new AAIRestInterface(httpsAuthClientFactory, servletRequestHelper, systemPropertyHelper);
    }

    @Bean
    public PombaRestInterface getPombaRestInterface(HttpsAuthClient httpsAuthClientFactory, ServletRequestHelper servletRequestHelper, SystemPropertyHelper systemPropertyHelper) {
        return new PombaRestInterface(httpsAuthClientFactory, servletRequestHelper, systemPropertyHelper);
    }

    @Bean
    public SSLContextProvider sslContextProvider() {
        return new SSLContextProvider();
    }

    @Bean
    public SystemPropertyHelper systemPropertyHelper() {
        return new SystemPropertyHelper();
    }

    @Bean
    public ServletRequestHelper servletRequestHelper() {
        return new ServletRequestHelper();
    }

    @Bean
    public HttpsAuthClient httpsAuthClientFactory(ServletContext servletContext, SystemPropertyHelper systemPropertyHelper, SSLContextProvider sslContextProvider) {
        final String certFilePath = new File(servletContext.getRealPath("/WEB-INF/cert/")).getAbsolutePath();
        return new HttpsAuthClient(certFilePath, systemPropertyHelper, sslContextProvider);
    }

    @Bean
    public SyncRestClientInterface syncRestClient() {
        return new SyncRestClient();
    }

    @Bean
    public IPombaService getVerifyServiceInstanceService() {
        return new PombaServiceImpl();
    }

    @Bean
    public PombaClientInterface getVerifyServiceInstanceClientInterface() {
        return new PombaClientImpl();
    }

    @Bean
    public SchedulerRestInterfaceIfc getSchedulerRestInterface(){
        return new SchedulerRestInterface();
    }

	@Bean
	public RestTemplate restTemplate() {
		return new RestTemplate();
	}
}
