/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */
package org.onap.osam.controllers;

import org.onap.osam.common.dto.AccessPodDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

// TODO log
@RestController
@RequestMapping("topology")
public class OnapEnablerTopologyController extends OnapEnablerController {

	private static final String TOPOLOGY = "topology";

	@Autowired
	public OnapEnablerTopologyController(RestTemplate restTemplate) {
		this.restTemplate = restTemplate;
	}

	@RequestMapping(method = RequestMethod.GET, value = "accessPod/{pnfId}")
	public ResponseEntity<AccessPodDTO> getTopologyWithPnfId(@PathVariable String pnfId) {
		return restTemplate.getForEntity(buildRequestPath(TOPOLOGY, "accessPod", pnfId), AccessPodDTO.class);
	}
}
