/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */
package org.onap.osam.controllers;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.List;

// TODO log
@RestController
@RequestMapping("service")

// *** Return and request types should be in osam-common. Types such as SpeedProfile, TechnologyProfile that are under model.dao temporarily reduced to Object *** //
public class OnapEnablerServiceController extends OnapEnablerController {

	private static final String SERVICE = "service";
	private static final String SPEED_PROFILE = "speedProfile";
	private static final String SPEED_PROFILE_ID = "speedProfile/{id}";
	private static final String TECH_PROFILE = "technologyProfile";
	private static final String TECH_PROFILE_ID = "technologyProfile/{id}";

	@Autowired
	public OnapEnablerServiceController(RestTemplate restTemplate){
		this.restTemplate = restTemplate;
	}

	@RequestMapping(method = RequestMethod.GET, value = SPEED_PROFILE)
	public ResponseEntity<List</*SpeedProfile*/Object>> getSpeedProfiles() {
		return restTemplate.exchange(buildRequestPath(SERVICE, SPEED_PROFILE), HttpMethod.GET, HttpEntity.EMPTY, new ParameterizedTypeReference<List</*SpeedProfile*/Object>>(){});
	}

	@RequestMapping(method = RequestMethod.GET, value = SPEED_PROFILE_ID)
	public ResponseEntity</*SpeedProfile*/Object> getSpeedProfile(@PathVariable Long id) {
		return restTemplate.getForEntity(buildRequestPath(SERVICE, SPEED_PROFILE, String.valueOf(id)), /*SpeedProfile*/Object.class);
	}

	@RequestMapping(method = RequestMethod.DELETE, value = SPEED_PROFILE_ID)
	public void deleteSpeedProfile(@PathVariable Long id) {
		restTemplate.delete(buildRequestPath(SERVICE, SPEED_PROFILE, String.valueOf(id)));
	}

	@RequestMapping(method = RequestMethod.POST, value = SPEED_PROFILE)
	public ResponseEntity</*SpeedProfile*/Object> createSpeedProfile(@RequestBody /*SpeedProfile*/ Object speedProfile) {
		return restTemplate.postForEntity(buildRequestPath(SERVICE, SPEED_PROFILE), speedProfile, /*SpeedProfile*/Object.class);
	}

	@RequestMapping(method = RequestMethod.GET, value = TECH_PROFILE)
	public ResponseEntity<List</*TechnologyProfile*/Object>> getTechnologyProfiles() {
	    return restTemplate.exchange(buildRequestPath(SERVICE, TECH_PROFILE), HttpMethod.GET, HttpEntity.EMPTY, new ParameterizedTypeReference<List</*TechnologyProfile*/Object>>(){});
	}

	@RequestMapping(method = RequestMethod.GET, value = TECH_PROFILE_ID)
	public ResponseEntity</*TechnologyProfile*/Object> getTechnologyProfile(@PathVariable Long id) {
		return restTemplate.getForEntity(buildRequestPath(SERVICE, TECH_PROFILE, String.valueOf(id)), /*TechnologyProfile*/Object.class);
	}

	@RequestMapping(method = RequestMethod.DELETE, value = TECH_PROFILE_ID)
	public void deleteTechnologyProfile(@PathVariable Long id) {
		restTemplate.delete(buildRequestPath(SERVICE, TECH_PROFILE, String.valueOf(id)));
	}

	@RequestMapping(method = RequestMethod.POST, value = TECH_PROFILE)
	public ResponseEntity</*TechnologyProfile*/Object> createTechnologyProfile(@RequestBody /*TechnologyProfile*/ Object technologyProfile) {
		return restTemplate.postForEntity(buildRequestPath(SERVICE, TECH_PROFILE), technologyProfile, /*TechnologyProfile*/Object.class);
	}
}
