/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model.repository;

import org.onap.osam.model.dao.OLTPort;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.Optional;

/**
 * Created by Zafer Kaban on 18.09.2018.
 */
public interface OLTPortRepository extends JpaRepository<OLTPort, Long> {

    Optional<OLTPort> findByPortNumber(int number);

    Optional<OLTPort> findByPortNumberAndOltSlot_NumberAndOltSlot_ChassisClli(int portNumber, int slotNumber, String clli);

}
