/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model.dao;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Set;

/**
 * Created by Zafer Kaban on 18.09.2018.
 */
@Entity
@Getter
@Setter
public class OLTSlot extends BaseEntity {

    private String serialNumber;
    @Enumerated(value = EnumType.STRING)
    private ActivityState operationalState;
    @Enumerated(value = EnumType.STRING)
    private ActivityState portAuthState;
    @Enumerated(value = EnumType.STRING)
    private AdminState adminState;
    private String ipAddress;
    private String hostname;
    private String macAddress;
    private Integer port;
    private Integer number;
    @Enumerated(value = EnumType.STRING)
    private OltDriver oltDriver;
    @Enumerated(value = EnumType.STRING)
    private OltType oltType;
    private String name;
    @ManyToOne
    @JoinColumn(name="chassis_id", nullable=false)
    private Chassis chassis;
    @OneToMany(fetch = FetchType.EAGER, cascade = CascadeType.ALL, mappedBy = "oltSlot")
    private Set<OLTPort> oltPorts;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("oltSlot{");
        sb.append("serialNumber=").append(serialNumber);
        sb.append(", operationalState='").append(operationalState).append('\'');
        sb.append(", portAuthState='").append(portAuthState).append('\'');
        sb.append(", adminState='").append(adminState).append('\'');
        sb.append(", ipAddress=").append(ipAddress);
        sb.append(", hostname=").append(hostname);
        sb.append(", macAddress=").append(macAddress);
        sb.append(", port=").append(port);
        sb.append(", number=").append(number);
        sb.append(", name=").append(name);
        sb.append(", oltDriver=").append(oltDriver);
        sb.append(", oltType=").append(oltType);
        sb.append('}');
        return sb.toString();
    }
}
