/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model.dao;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * Created by cemturker on 26.09.2018.
 */
@Entity
@Getter
@Setter
public class AccessPod extends BaseEntity {

    @Column(unique = true)
    private String pnfId;
    @Column(nullable = false)
    private String coreIp;
    @Column(nullable = false)
    private String corePort;
    @Column(nullable = false)
    private String ip;
    @Column(nullable = false)
    private String port;
    private String username;
    private String password;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("AccessPod{");
        sb.append("pnfId='").append(pnfId).append('\'');
        sb.append(", coreIp='").append(coreIp).append('\'');
        sb.append(", corePort='").append(corePort).append('\'');
        sb.append(", id=").append(id);
        sb.append(", ip='").append(ip).append('\'');
        sb.append(", port='").append(port).append('\'');
        sb.append(", username='").append(username).append('\'');
        sb.append(", password='").append(password).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
