/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */
package org.onap.osam.job.impl;

import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.RandomUtils;
import org.onap.osam.job.dao.job.JobStatus;
import org.onap.osam.job.dao.job.OsamJob;
import org.onap.osam.job.IJobFactory;
import org.onap.osam.job.JobType;
import org.onap.osam.job.command.JobCommandFactoryTest;
import org.testng.annotations.Test;

import java.util.UUID;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotEquals;
import static org.testng.AssertJUnit.assertNotNull;

public class JobAdapterTest {

    @Test
    public void testCreateServiceInstantiationJob() {
        IJobFactory jobAdapter = new JobFactory();

        JobType jobType = JobType.NoOp;
        IJobFactory.AsyncJobRequest request = new JobCommandFactoryTest.MockedRequest(42,"nothing");
        String userId = "ou012t";
        String optimisticUniqueServiceInstanceName = "optimisticUniqueServiceInstanceName";
        int indexInBulk = RandomUtils.nextInt();
        OsamJob job = jobAdapter.createRootJob(
                jobType,
                request,
                userId,
                indexInBulk,
                ImmutableMap.of());

        assertEquals(job.getType(), jobType);
        assertEquals(job.getSharedData().getRequest(), request);
        assertEquals(job.getSharedData().getRequestType(), request.getClass());
        assertEquals(job.getSharedData().getUserId(), userId);
        assertEquals(job.getSharedData().getJobUuid(), job.getUuid());
        assertEquals(job.getSharedData().getRootJobId(), job.getUuid());
        assertNotNull(job.getUuid());
        assertEquals((int)job.getIndexInBulk(), indexInBulk );
        assertEquals(job.getStatus(), JobStatus.PENDING);
    }

    @Test
    public void testCreateChildJob() {

        IJobFactory jobAdapter = new JobFactory();

        String userId = "ou012t";
        String optimisticUniqueServiceInstanceName = "optimisticUniqueServiceInstanceName";
        int indexInBulk = RandomUtils.nextInt();
        OsamJob grandJob = jobAdapter.createRootJob(
                JobType.HttpCall,
                new JobCommandFactoryTest.MockedRequest(99, "anything"),
                userId,
                indexInBulk,
                ImmutableMap.of()
        );

        JobStatus jobStatus = JobStatus.PAUSE;
        JobType jobType = JobType.NoOp;
        IJobFactory.AsyncJobRequest request = new JobCommandFactoryTest.MockedRequest(42,"nothing");
        OsamJob parentJob = jobAdapter.createChildJob(jobType, jobStatus, request, grandJob.getSharedData(), ImmutableMap.of());

        assertEquals(parentJob.getType(), jobType);
        assertEquals(parentJob.getSharedData().getRequest(), request);
        assertEquals(parentJob.getSharedData().getRequestType(), request.getClass());
        assertEquals(parentJob.getSharedData().getUserId(), userId);
        assertEquals(parentJob.getSharedData().getJobUuid(), parentJob.getUuid());
        assertNotNull(parentJob.getUuid());
        assertNotEquals(parentJob.getUuid(), grandJob.getUuid());
        assertEquals(parentJob.getStatus(), jobStatus);
        assertEquals(parentJob.getSharedData().getRootJobId(), grandJob.getUuid());

        JobStatus jobStatus2 = JobStatus.IN_PROGRESS;
        JobType jobType2 = JobType.HttpCall;
        IJobFactory.AsyncJobRequest request2 = new JobCommandFactoryTest.MockedRequest(66,"abc");
        OsamJob job = jobAdapter.createChildJob(jobType2, jobStatus2, request2, parentJob.getSharedData(), ImmutableMap.of());

        assertEquals(job.getType(), jobType2);
        assertEquals(job.getSharedData().getRequest(), request2);
        assertEquals(job.getSharedData().getRequestType(), request2.getClass());
        assertEquals(job.getSharedData().getUserId(), userId);
        assertEquals(job.getSharedData().getJobUuid(), job.getUuid());
        assertNotNull(job.getUuid());
        assertNotEquals(job.getUuid(), parentJob.getUuid());
        assertEquals(job.getStatus(), jobStatus2);
        assertEquals(job.getSharedData().getRootJobId(), grandJob.getUuid());

    }
}
