/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */
package org.onap.osam.job.utils;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class TimeUtils {
    private static DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME;

    private TimeUtils() {
        // explicit private constructor, to hide the implicit public constructor
    }

    public static ZonedDateTime parseZonedDateTime(String time) {

        return ZonedDateTime.from(formatter.parse(time));
    }

    public static String zonedDateTimeToString(ZonedDateTime time) {
        return formatter.format(time);
    }
}
