/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */
package org.onap.osam.job.command;

import org.onap.osam.job.dao.job.JobStatus;
import org.onap.osam.job.NextCommand;
import org.onap.osam.job.impl.JobSharedData;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.UUID;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class WatchingCommand extends BaseWatchingCommand {

    public WatchingCommand() {}

    public WatchingCommand(JobSharedData sharedData, List<UUID> childrenJobsIds, boolean isRoot) {
        super(sharedData, childrenJobsIds, isRoot);
    }

    protected NextCommand getNextCommand(boolean isAllChildrenFinal, boolean hasFailedChild) {
        if (isAllChildrenFinal) {
            JobStatus jobStatus = hasFailedChild ?  JobStatus.COMPLETED_WITH_ERRORS : JobStatus.COMPLETED;
            return new NextCommand(jobStatus);
        } else {
            if (isRoot) {
                return new NextCommand(JobStatus.IN_PROGRESS, this);
            }
            return new NextCommand(JobStatus.RESOURCE_IN_PROGRESS, this);
        }
    }

}
