/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.common.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRootName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * Created by cemturker on 01.10.2018.
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@JsonRootName("AccessPod")
@JsonInclude(JsonInclude.Include.NON_NULL)
@ApiModel
public class AccessPodDTO {
    @ApiModelProperty(hidden = true)
    private Long id;
    @ApiModelProperty(required = true)
    private String pnfId;
    @ApiModelProperty(required = true, value="IP address of Abstract OLT for this POD")
    private String ip;
    @ApiModelProperty(required = true, value="GRPC Port of Abstract OLT for this POD")
    private String port;
    @ApiModelProperty(required = true, value="IP address of a SEBA POD")
    private String coreIp;
    @ApiModelProperty(required = true, value="Port of a SEBA POD")
    private String corePort;
    @ApiModelProperty(required = true, value="XOS Username of a SEBA POD")
    private String username;
    @ApiModelProperty(required = true, value="XOS Password of a SEBA POD")
    private String password;
    @ApiModelProperty(hidden = true)
    private List<ChassisDTO> chassises;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("AccessPodDTO{");
        sb.append("id=").append(id);
        sb.append(", pnfId='").append(pnfId).append('\'');
        sb.append(", ip='").append(ip).append('\'');
        sb.append(", port='").append(port).append('\'');
        sb.append(", coreIp='").append(coreIp).append('\'');
        sb.append(", corePort='").append(corePort).append('\'');
        sb.append(", username='").append(username).append('\'');
        sb.append(", password='").append(password).append('\'');
        sb.append(", chassises=").append(chassises);
        sb.append('}');
        return sb.toString();
    }
}
