/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.common.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRootName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonRootName("ONTDevice")
@JsonInclude(JsonInclude.Include.NON_NULL)
@ApiModel
public class ONTDTO {
    @ApiModelProperty(hidden = true)
    private Long id;
    @ApiModelProperty(required = true, value="CLLI of the chassis on top of which this ONT device is registered")
    private String clli;
    @ApiModelProperty(required = true, value="Serial number of this ONT device")
    private String serialNumber;
    @ApiModelProperty(required = true, value="OLT Slot number of this ONT device")
    private int slotNumber;
    @ApiModelProperty(required = true, value="OLT Port number of this ONT device")
    private int portNumber;
    private int ontNumber;
    private int stag;
    private int ctag;
    private String nasPortId;
    private String circuitId;
    private String technologyProfile;
    private String speedProfile;
}
