/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.common.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRootName;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
//import org.onap.osam.model.dao.ActivityState;
//import org.onap.osam.model.dao.AdminState;

import java.util.List;

/**
 * Created by cemturker on 03.10.2018.
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@JsonRootName("OLTPort")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OLTPortDTO {
    private Long id;
    private Integer portNumber;
    private /*ActivityState*/ String portAuthState;
    private /*AdminState*/ String adminState;
    private List<ONTDTO> ontDevices;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("OLTPortDTO{");
        sb.append("id=").append(id);
        sb.append(", portNumber=").append(portNumber);
        sb.append(", portAuthState=").append(portAuthState);
        sb.append(", adminState=").append(adminState);
        sb.append(", ontDevices=").append(ontDevices);
        sb.append('}');
        return sb.toString();
    }
}
