# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2019-02-21 01:31
from __future__ import unicode_literals

import core.models.xosbase_header
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0002_initial_data'),
    ]

    operations = [
        migrations.CreateModel(
            name='ONOSApp_decl',
            fields=[
                ('serviceinstance_decl_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.ServiceInstance_decl')),
                ('app_id', models.TextField()),
                ('dependencies', models.TextField(blank=True, help_text=b'Comma separated list of required applications', null=True)),
                ('url', models.TextField(blank=True, help_text=b'URL at which the application is available, if it needs to be downloaded', null=True)),
                ('version', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'ONOS Application',
            },
            bases=('core.serviceinstance',),
        ),
        migrations.CreateModel(
            name='ONOSService_decl',
            fields=[
                ('service_decl_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.Service_decl')),
                ('rest_hostname', core.models.xosbase_header.StrippedCharField(max_length=255)),
                ('rest_port', models.IntegerField(default=8181)),
                ('rest_username', core.models.xosbase_header.StrippedCharField(default=b'karaf', max_length=255)),
                ('rest_password', core.models.xosbase_header.StrippedCharField(default=b'karaf', max_length=255)),
            ],
            options={
                'verbose_name': 'ONOS Service',
            },
            bases=('core.service',),
        ),
        migrations.CreateModel(
            name='ONOSApp',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('onos.onosapp_decl',),
        ),
        migrations.CreateModel(
            name='ONOSService',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('onos.onosservice_decl',),
        ),
    ]
