# -*- makefile -*-
# -----------------------------------------------------------------------
# Copyright 2022-2024 Open Networking Foundation Contributors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# -----------------------------------------------------------------------
# SPDX-FileCopyrightText: 2022-2024 Open Networking Foundation Contributors
# SPDX-License-Identifier: Apache-2.0
# -----------------------------------------------------------------------
# Intent:
# -----------------------------------------------------------------------

##-------------------##
##---]  GLOBALS  [---##
##-------------------##
lint-robot-cmd := $(venv-name)/bin/rflint

##-------------------##
##---]  TARGETS  [---##
##-------------------##

## -----------------------------------------------------------------------
## Intent: Install rflint python virtualenv package
## -----------------------------------------------------------------------
$(lint-robot-cmd) : lint-robot-install
lint-robot-install: venv-activate-patched
    # Verify package mentioned in requirements.txt
    # grep 'robotframework-lint' requirements.txt
	$(activate) && pip freeze | grep 'robotframework-lint'

## ---------------------------------------1--------------------------------
## Intent: Display command line tool version
##   - Dependency will install when needed
## -----------------------------------------------------------------------
lint-robot-version : lint-robot-install
	$(activate) && rflint --version
	@echo

# [EOF]

