# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2019-03-12 22:30
from __future__ import unicode_literals

from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('volt', '0002_auto_20190305_1242'),
    ]

    operations = [
        migrations.AlterField(
            model_name='oltdevice_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='oltdevice_decl',
            name='device_type',
            field=models.CharField(default=b'openolt', help_text=b'Phyiscal Device Type', max_length=254),
        ),
        migrations.AlterField(
            model_name='oltdevice_decl',
            name='driver',
            field=models.TextField(default=b'voltha', help_text=b'DEPRECATED'),
        ),
        migrations.AlterField(
            model_name='oltdevice_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='oltdevice_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='oltdevice_decl',
            name='uplink',
            field=models.TextField(help_text=b'uplink port, exposed via sadis'),
        ),
        migrations.AlterField(
            model_name='onudevice_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='onudevice_decl',
            name='device_type',
            field=models.CharField(default=b'asfvolt16_olt', help_text=b'Device Type', max_length=254),
        ),
        migrations.AlterField(
            model_name='onudevice_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='onudevice_decl',
            name='serial_number',
            field=models.CharField(help_text=b'Serial number of ONU Device', max_length=254, unique=True),
        ),
        migrations.AlterField(
            model_name='onudevice_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='onudevice_decl',
            name='vendor',
            field=models.CharField(help_text=b'Vendor of ONU Device', max_length=254),
        ),
        migrations.AlterField(
            model_name='portbase_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='portbase_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='portbase_decl',
            name='name',
            field=models.TextField(db_index=True, help_text=b'Human-readable name of port'),
        ),
        migrations.AlterField(
            model_name='portbase_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='voltservice_decl',
            name='onos_voltha_pass',
            field=models.CharField(default=b'rocks', help_text=b'The ONOS Voltha password. By default rocks', max_length=254),
        ),
        migrations.AlterField(
            model_name='voltservice_decl',
            name='onos_voltha_url',
            field=models.CharField(default=b'onos-voltha-ui.voltha.svc.cluster.local', help_text=b'The ONOS Voltha address. By default onos-voltha-ui.voltha.svc.cluster.local', max_length=254),
        ),
        migrations.AlterField(
            model_name='voltservice_decl',
            name='onos_voltha_user',
            field=models.CharField(default=b'onos', help_text=b'The ONOS Voltha username. By default sdn', max_length=254),
        ),
        migrations.AlterField(
            model_name='voltservice_decl',
            name='voltha_pass',
            field=models.CharField(default=b'admin', help_text=b'The Voltha password. By default admin', max_length=254),
        ),
        migrations.AlterField(
            model_name='voltservice_decl',
            name='voltha_url',
            field=models.CharField(default=b'voltha.voltha.svc.cluster.local', help_text=b'The Voltha API address. By default voltha.voltha.svc.cluster.local', max_length=254),
        ),
        migrations.AlterField(
            model_name='voltservice_decl',
            name='voltha_user',
            field=models.CharField(default=b'voltha', help_text=b'The Voltha username. By default voltha', max_length=254),
        ),
    ]
