/*
 * Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
 * Copyright (c) 2011, 2012 Open Networking Foundation
 * Copyright 2013, Big Switch Networks, Inc. This library was generated by the LoxiGen Compiler.
 * Copyright 2018, Red Hat, Inc.
 */
// Automatically generated by LOXI from template const.go
// Do not modify

package of13

import (
	"fmt"
	"strings"
)

const (
	// Identifiers from group macro_definitions
	MaxTableNameLen    = 32         // OFP_MAX_TABLE_NAME_LEN
	MaxPortNameLen     = 16         // OFP_MAX_PORT_NAME_LEN
	TCPPort            = 6653       // OFP_TCP_PORT
	SSLPort            = 6653       // OFP_SSL_PORT
	EthAlen            = 6          // OFP_ETH_ALEN
	DefaultMissSendLen = 128        // OFP_DEFAULT_MISS_SEND_LEN
	VLANNone           = 0          // OFP_VLAN_NONE
	FlowPermanent      = 0          // OFP_FLOW_PERMANENT
	DefaultPriority    = 32768      // OFP_DEFAULT_PRIORITY
	NoBuffer           = 4294967295 // OFP_NO_BUFFER
	DescStrLen         = 256        // DESC_STR_LEN
	SerialNumLen       = 32         // SERIAL_NUM_LEN
	OFPQAll            = 4294967295 // OFPQ_ALL
	OFPQMaxRateUncfg   = 65535      // OFPQ_MAX_RATE_UNCFG
	OFPQMinRateUncfg   = 65535      // OFPQ_MIN_RATE_UNCFG
)

const (
	// Identifiers from group nx_action_controller2_prop_type
	Nxac2PtMaxLen       = 0 // NXAC2PT_MAX_LEN
	Nxac2PtControllerID = 1 // NXAC2PT_CONTROLLER_ID
	Nxac2PtReason       = 2 // NXAC2PT_REASON
	Nxac2PtUserdata     = 3 // NXAC2PT_USERDATA
	Nxac2PtPause        = 4 // NXAC2PT_PAUSE
	Nxac2PtMeterID      = 5 // NXAC2PT_METER_ID
)

type NxActionController2PropType uint16

func (self NxActionController2PropType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group nx_bd_algorithms
	NxBdAlgActiveBackup = 0 // NX_BD_ALG_ACTIVE_BACKUP
	NxBdAlgHrw          = 1 // NX_BD_ALG_HRW
)

type NxBdAlgorithms uint16

func (self NxBdAlgorithms) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self NxBdAlgorithms) String() string {
	switch self {
	case NxBdAlgActiveBackup:
		return "active_backup"
	case NxBdAlgHrw:
		return "hrw"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group nx_conntrack_flags
	NxCtFCommit = 1 // NX_CT_F_COMMIT
	NxCtFForce  = 2 // NX_CT_F_FORCE
)

type NxConntrackFlags uint16

func (self NxConntrackFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&NxCtFCommit == NxCtFCommit {
		flags = append(flags, "\"Commit\": true")
	}
	if self&NxCtFForce == NxCtFForce {
		flags = append(flags, "\"Force\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group nx_flow_monitor_flags
	NxfmfInitial = 1  // NXFMF_INITIAL
	NxfmfAdd     = 2  // NXFMF_ADD
	NxfmfDelete  = 4  // NXFMF_DELETE
	NxfmfModify  = 8  // NXFMF_MODIFY
	NxfmfActions = 16 // NXFMF_ACTIONS
	NxfmfOwn     = 32 // NXFMF_OWN
)

type NxFlowMonitorFlags uint16

func (self NxFlowMonitorFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&NxfmfInitial == NxfmfInitial {
		flags = append(flags, "\"Initial\": true")
	}
	if self&NxfmfAdd == NxfmfAdd {
		flags = append(flags, "\"Add\": true")
	}
	if self&NxfmfDelete == NxfmfDelete {
		flags = append(flags, "\"Delete\": true")
	}
	if self&NxfmfModify == NxfmfModify {
		flags = append(flags, "\"Modify\": true")
	}
	if self&NxfmfActions == NxfmfActions {
		flags = append(flags, "\"Actions\": true")
	}
	if self&NxfmfOwn == NxfmfOwn {
		flags = append(flags, "\"Own\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group nx_hash_fields
	NxHashFieldsEthSrc           = 0 // NX_HASH_FIELDS_ETH_SRC
	NxHashFieldsSymmetricL4      = 1 // NX_HASH_FIELDS_SYMMETRIC_L4
	NxHashFieldsSymmetricL3L4    = 2 // NX_HASH_FIELDS_SYMMETRIC_L3L4
	NxHashFieldsSymmetricL3L4Udp = 3 // NX_HASH_FIELDS_SYMMETRIC_L3L4_UDP
	NxHashFieldsNwSrc            = 4 // NX_HASH_FIELDS_NW_SRC
	NxHashFieldsNwDst            = 5 // NX_HASH_FIELDS_NW_DST
	NxHashFieldsSymmetricL3      = 6 // NX_HASH_FIELDS_SYMMETRIC_L3
)

type NxHashFields uint16

func (self NxHashFields) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self NxHashFields) String() string {
	switch self {
	case NxHashFieldsEthSrc:
		return "eth_src"
	case NxHashFieldsSymmetricL4:
		return "symmetric_l4"
	case NxHashFieldsSymmetricL3L4:
		return "symmetric_l3l4"
	case NxHashFieldsSymmetricL3L4Udp:
		return "symmetric_l3l4_udp"
	case NxHashFieldsNwSrc:
		return "nw_src"
	case NxHashFieldsNwDst:
		return "nw_dst"
	case NxHashFieldsSymmetricL3:
		return "symmetric_l3"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group nx_mp_algorithm
	NxMpAlgModuloN       = 0 // NX_MP_ALG_MODULO_N
	NxMpAlgHashThreshold = 1 // NX_MP_ALG_HASH_THRESHOLD
	NxMpAlgHrw           = 2 // NX_MP_ALG_HRW
	NxMpAlgIterHash      = 3 // NX_MP_ALG_ITER_HASH
)

type NxMpAlgorithm uint16

func (self NxMpAlgorithm) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self NxMpAlgorithm) String() string {
	switch self {
	case NxMpAlgModuloN:
		return "modulo_n"
	case NxMpAlgHashThreshold:
		return "hash_threshold"
	case NxMpAlgHrw:
		return "hrw"
	case NxMpAlgIterHash:
		return "iter_hash"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group of_action_nx_bundle_slave_type
	NxmOfInPort                  = 2     // NXM_OF_IN_PORT
	NxmOfJustThereToDefinePrefix = 10000 // NXM_OF_JUST_THERE_TO_DEFINE_PREFIX
)

type ActionNxBundleSlaveType uint32

func (self ActionNxBundleSlaveType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self ActionNxBundleSlaveType) String() string {
	switch self {
	case NxmOfInPort:
		return "in_port"
	case NxmOfJustThereToDefinePrefix:
		return "just_there_to_define_prefix"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group of_bsn_gentable_error_code
	OFBSNGentableErrorUnknown   = 0 // OF_BSN_GENTABLE_ERROR_UNKNOWN
	OFBSNGentableErrorParam     = 1 // OF_BSN_GENTABLE_ERROR_PARAM
	OFBSNGentableErrorTableFull = 2 // OF_BSN_GENTABLE_ERROR_TABLE_FULL
)

type BsnGentableErrorCode uint16

func (self BsnGentableErrorCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group of_bsn_hash_gtp_port_match
	OFBSNHashGtpPortMatchSrc       = 1 // OF_BSN_HASH_GTP_PORT_MATCH_SRC
	OFBSNHashGtpPortMatchDst       = 2 // OF_BSN_HASH_GTP_PORT_MATCH_DST
	OFBSNHashGtpPortMatchSrcOrDst  = 3 // OF_BSN_HASH_GTP_PORT_MATCH_SRC_OR_DST
	OFBSNHashGtpPortMatchSrcAndDst = 4 // OF_BSN_HASH_GTP_PORT_MATCH_SRC_AND_DST
)

type BsnHashGtpPortMatch uint8

func (self BsnHashGtpPortMatch) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group of_bsn_hash_packet_field
	BSNHashFieldDstMAC           = 2      // OFP_BSN_HASH_FIELD_DST_MAC
	BSNHashFieldSrcMAC           = 4      // OFP_BSN_HASH_FIELD_SRC_MAC
	BSNHashFieldEthType          = 8      // OFP_BSN_HASH_FIELD_ETH_TYPE
	BSNHashFieldVLANID           = 16     // OFP_BSN_HASH_FIELD_VLAN_ID
	BSNHashFieldInnerL2          = 32     // OFP_BSN_HASH_FIELD_INNER_L2
	BSNHashFieldInnerL3          = 64     // OFP_BSN_HASH_FIELD_INNER_L3
	BSNHashFieldSrcIp            = 128    // OFP_BSN_HASH_FIELD_SRC_IP
	BSNHashFieldDstIp            = 256    // OFP_BSN_HASH_FIELD_DST_IP
	BSNHashFieldIpProto          = 512    // OFP_BSN_HASH_FIELD_IP_PROTO
	BSNHashFieldSrcL4Port        = 1024   // OFP_BSN_HASH_FIELD_SRC_L4_PORT
	BSNHashFieldDstL4Port        = 2048   // OFP_BSN_HASH_FIELD_DST_L4_PORT
	BSNHashFieldMplsLabel1       = 4096   // OFP_BSN_HASH_FIELD_MPLS_LABEL1
	BSNHashFieldMplsLabel2       = 8192   // OFP_BSN_HASH_FIELD_MPLS_LABEL2
	BSNHashFieldMplsLabel3       = 16384  // OFP_BSN_HASH_FIELD_MPLS_LABEL3
	BSNHashFieldMplsLabelHiBits  = 32768  // OFP_BSN_HASH_FIELD_MPLS_LABEL_HI_BITS
	BSNHashFieldMplsPayloadSrcIp = 65536  // OFP_BSN_HASH_FIELD_MPLS_PAYLOAD_SRC_IP
	BSNHashFieldMplsPayloadDstIp = 131072 // OFP_BSN_HASH_FIELD_MPLS_PAYLOAD_DST_IP
	BSNHashFieldSymmetric        = 262144 // OFP_BSN_HASH_FIELD_SYMMETRIC
)

type BsnHashPacketField uint64

func (self BsnHashPacketField) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNHashFieldDstMAC == BSNHashFieldDstMAC {
		flags = append(flags, "\"DstMAC\": true")
	}
	if self&BSNHashFieldSrcMAC == BSNHashFieldSrcMAC {
		flags = append(flags, "\"SrcMAC\": true")
	}
	if self&BSNHashFieldEthType == BSNHashFieldEthType {
		flags = append(flags, "\"EthType\": true")
	}
	if self&BSNHashFieldVLANID == BSNHashFieldVLANID {
		flags = append(flags, "\"VlanID\": true")
	}
	if self&BSNHashFieldInnerL2 == BSNHashFieldInnerL2 {
		flags = append(flags, "\"InnerL2\": true")
	}
	if self&BSNHashFieldInnerL3 == BSNHashFieldInnerL3 {
		flags = append(flags, "\"InnerL3\": true")
	}
	if self&BSNHashFieldSrcIp == BSNHashFieldSrcIp {
		flags = append(flags, "\"SrcIp\": true")
	}
	if self&BSNHashFieldDstIp == BSNHashFieldDstIp {
		flags = append(flags, "\"DstIp\": true")
	}
	if self&BSNHashFieldIpProto == BSNHashFieldIpProto {
		flags = append(flags, "\"IpProto\": true")
	}
	if self&BSNHashFieldSrcL4Port == BSNHashFieldSrcL4Port {
		flags = append(flags, "\"SrcL4Port\": true")
	}
	if self&BSNHashFieldDstL4Port == BSNHashFieldDstL4Port {
		flags = append(flags, "\"DstL4Port\": true")
	}
	if self&BSNHashFieldMplsLabel1 == BSNHashFieldMplsLabel1 {
		flags = append(flags, "\"MplsLabel1\": true")
	}
	if self&BSNHashFieldMplsLabel2 == BSNHashFieldMplsLabel2 {
		flags = append(flags, "\"MplsLabel2\": true")
	}
	if self&BSNHashFieldMplsLabel3 == BSNHashFieldMplsLabel3 {
		flags = append(flags, "\"MplsLabel3\": true")
	}
	if self&BSNHashFieldMplsLabelHiBits == BSNHashFieldMplsLabelHiBits {
		flags = append(flags, "\"MplsLabelHiBits\": true")
	}
	if self&BSNHashFieldMplsPayloadSrcIp == BSNHashFieldMplsPayloadSrcIp {
		flags = append(flags, "\"MplsPayloadSrcIp\": true")
	}
	if self&BSNHashFieldMplsPayloadDstIp == BSNHashFieldMplsPayloadDstIp {
		flags = append(flags, "\"MplsPayloadDstIp\": true")
	}
	if self&BSNHashFieldSymmetric == BSNHashFieldSymmetric {
		flags = append(flags, "\"Symmetric\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group of_bsn_hash_packet_type
	OFBSNHashPacketL2        = 0 // OF_BSN_HASH_PACKET_L2
	OFBSNHashPacketL2Gre     = 1 // OF_BSN_HASH_PACKET_L2GRE
	OFBSNHashPacketIpv4      = 3 // OF_BSN_HASH_PACKET_IPV4
	OFBSNHashPacketIpv6      = 4 // OF_BSN_HASH_PACKET_IPV6
	OFBSNHashPacketMpls      = 5 // OF_BSN_HASH_PACKET_MPLS
	OFBSNHashPacketSymmetric = 6 // OF_BSN_HASH_PACKET_SYMMETRIC
)

type BsnHashPacketType uint8

func (self BsnHashPacketType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group of_bsn_hash_type
	BSNHashTypeL2       = 0 // OFP_BSN_HASH_TYPE_L2
	BSNHashTypeL3       = 1 // OFP_BSN_HASH_TYPE_L3
	BSNHashTypeEnhanced = 2 // OFP_BSN_HASH_TYPE_ENHANCED
)

type BsnHashType uint8

func (self BsnHashType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group of_bsn_lacp_convergence_status
	LacpSuccess   = 0 // LACP_SUCCESS
	LacpTimedout  = 1 // LACP_TIMEDOUT
	LacpOutOfSync = 2 // LACP_OUT_OF_SYNC
)

type BsnLacpConvergenceStatus uint8

func (self BsnLacpConvergenceStatus) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group of_bsn_pdu_slot_num
	BsnPduSlotNumAny = 255 // BSN_PDU_SLOT_NUM_ANY
)

type BsnPduSlotNum uint8

func (self BsnPduSlotNum) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group of_bsn_vlan_counter
	BSNVLANCounterRxBytes   = 0 // OFP_BSN_VLAN_COUNTER_RX_BYTES
	BSNVLANCounterRxPackets = 1 // OFP_BSN_VLAN_COUNTER_RX_PACKETS
	BSNVLANCounterTxBytes   = 2 // OFP_BSN_VLAN_COUNTER_TX_BYTES
	BSNVLANCounterTxPackets = 3 // OFP_BSN_VLAN_COUNTER_TX_PACKETS
)

type BsnVlanCounter uint8

func (self BsnVlanCounter) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group of_bsn_vrf_counter
	BSNVrfCounterBytes   = 0 // OFP_BSN_VRF_COUNTER_BYTES
	BSNVrfCounterPackets = 1 // OFP_BSN_VRF_COUNTER_PACKETS
)

type BsnVrfCounter uint8

func (self BsnVrfCounter) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group of_nx_nat_range
	NxNatRangeIpv4Min  = 1  // NX_NAT_RANGE_IPV4_MIN
	NxNatRangeIpv4Max  = 2  // NX_NAT_RANGE_IPV4_MAX
	NxNatRangeIpv6Min  = 4  // NX_NAT_RANGE_IPV6_MIN
	NxNatRangeIpv6Max  = 8  // NX_NAT_RANGE_IPV6_MAX
	NxNatRangeProtoMin = 16 // NX_NAT_RANGE_PROTO_MIN
	NxNatRangeProtoMax = 32 // NX_NAT_RANGE_PROTO_MAX
)

type NxNatRange uint16

func (self NxNatRange) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&NxNatRangeIpv4Min == NxNatRangeIpv4Min {
		flags = append(flags, "\"Ipv4Min\": true")
	}
	if self&NxNatRangeIpv4Max == NxNatRangeIpv4Max {
		flags = append(flags, "\"Ipv4Max\": true")
	}
	if self&NxNatRangeIpv6Min == NxNatRangeIpv6Min {
		flags = append(flags, "\"Ipv6Min\": true")
	}
	if self&NxNatRangeIpv6Max == NxNatRangeIpv6Max {
		flags = append(flags, "\"Ipv6Max\": true")
	}
	if self&NxNatRangeProtoMin == NxNatRangeProtoMin {
		flags = append(flags, "\"ProtoMin\": true")
	}
	if self&NxNatRangeProtoMax == NxNatRangeProtoMax {
		flags = append(flags, "\"ProtoMax\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_action_type
	OFPATOutput       = 0     // OFPAT_OUTPUT
	OFPATCopyTtlOut   = 11    // OFPAT_COPY_TTL_OUT
	OFPATCopyTtlIn    = 12    // OFPAT_COPY_TTL_IN
	OFPATSetMplsTtl   = 15    // OFPAT_SET_MPLS_TTL
	OFPATDecMplsTtl   = 16    // OFPAT_DEC_MPLS_TTL
	OFPATPushVLAN     = 17    // OFPAT_PUSH_VLAN
	OFPATPopVLAN      = 18    // OFPAT_POP_VLAN
	OFPATPushMpls     = 19    // OFPAT_PUSH_MPLS
	OFPATPopMpls      = 20    // OFPAT_POP_MPLS
	OFPATSetQueue     = 21    // OFPAT_SET_QUEUE
	OFPATGroup        = 22    // OFPAT_GROUP
	OFPATSetNwTtl     = 23    // OFPAT_SET_NW_TTL
	OFPATDecNwTtl     = 24    // OFPAT_DEC_NW_TTL
	OFPATSetField     = 25    // OFPAT_SET_FIELD
	OFPATPushPbb      = 26    // OFPAT_PUSH_PBB
	OFPATPopPbb       = 27    // OFPAT_POP_PBB
	OFPATExperimenter = 65535 // OFPAT_EXPERIMENTER
)

type ActionType uint16

func (self ActionType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bad_action_code
	OFPBACBadType             = 0  // OFPBAC_BAD_TYPE
	OFPBACBadLen              = 1  // OFPBAC_BAD_LEN
	OFPBACBadExperimenter     = 2  // OFPBAC_BAD_EXPERIMENTER
	OFPBACBadExperimenterType = 3  // OFPBAC_BAD_EXPERIMENTER_TYPE
	OFPBACBadOutPort          = 4  // OFPBAC_BAD_OUT_PORT
	OFPBACBadArgument         = 5  // OFPBAC_BAD_ARGUMENT
	OFPBACEperm               = 6  // OFPBAC_EPERM
	OFPBACTooMany             = 7  // OFPBAC_TOO_MANY
	OFPBACBadQueue            = 8  // OFPBAC_BAD_QUEUE
	OFPBACBadOutGroup         = 9  // OFPBAC_BAD_OUT_GROUP
	OFPBACMatchInconsistent   = 10 // OFPBAC_MATCH_INCONSISTENT
	OFPBACUnsupportedOrder    = 11 // OFPBAC_UNSUPPORTED_ORDER
	OFPBACBadTag              = 12 // OFPBAC_BAD_TAG
	OFPBACBadSetType          = 13 // OFPBAC_BAD_SET_TYPE
	OFPBACBadSetLen           = 14 // OFPBAC_BAD_SET_LEN
	OFPBACBadSetArgument      = 15 // OFPBAC_BAD_SET_ARGUMENT
)

type BadActionCode uint16

func (self BadActionCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bad_instruction_code
	OFPBICUnknownInst         = 0 // OFPBIC_UNKNOWN_INST
	OFPBICUnsupInst           = 1 // OFPBIC_UNSUP_INST
	OFPBICBadTableID          = 2 // OFPBIC_BAD_TABLE_ID
	OFPBICUnsupMetadata       = 3 // OFPBIC_UNSUP_METADATA
	OFPBICUnsupMetadataMask   = 4 // OFPBIC_UNSUP_METADATA_MASK
	OFPBICBadExperimenter     = 5 // OFPBIC_BAD_EXPERIMENTER
	OFPBICBadExperimenterType = 6 // OFPBIC_BAD_EXPERIMENTER_TYPE
	OFPBICBadLen              = 7 // OFPBIC_BAD_LEN
	OFPBICEperm               = 8 // OFPBIC_EPERM
)

type BadInstructionCode uint16

func (self BadInstructionCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bad_match_code
	OFPBMCBadType       = 0  // OFPBMC_BAD_TYPE
	OFPBMCBadLen        = 1  // OFPBMC_BAD_LEN
	OFPBMCBadTag        = 2  // OFPBMC_BAD_TAG
	OFPBMCBadDlAddrMask = 3  // OFPBMC_BAD_DL_ADDR_MASK
	OFPBMCBadNwAddrMask = 4  // OFPBMC_BAD_NW_ADDR_MASK
	OFPBMCBadWildcards  = 5  // OFPBMC_BAD_WILDCARDS
	OFPBMCBadField      = 6  // OFPBMC_BAD_FIELD
	OFPBMCBadValue      = 7  // OFPBMC_BAD_VALUE
	OFPBMCBadMask       = 8  // OFPBMC_BAD_MASK
	OFPBMCBadPrereq     = 9  // OFPBMC_BAD_PREREQ
	OFPBMCDupField      = 10 // OFPBMC_DUP_FIELD
	OFPBMCEperm         = 11 // OFPBMC_EPERM
)

type BadMatchCode uint16

func (self BadMatchCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bad_request_code
	OFPBRCBadVersion              = 0  // OFPBRC_BAD_VERSION
	OFPBRCBadType                 = 1  // OFPBRC_BAD_TYPE
	OFPBRCBadStat                 = 2  // OFPBRC_BAD_STAT
	OFPBRCBadExperimenter         = 3  // OFPBRC_BAD_EXPERIMENTER
	OFPBRCBadExperimenterType     = 4  // OFPBRC_BAD_EXPERIMENTER_TYPE
	OFPBRCEperm                   = 5  // OFPBRC_EPERM
	OFPBRCBadLen                  = 6  // OFPBRC_BAD_LEN
	OFPBRCBufferEmpty             = 7  // OFPBRC_BUFFER_EMPTY
	OFPBRCBufferUnknown           = 8  // OFPBRC_BUFFER_UNKNOWN
	OFPBRCBadTableID              = 9  // OFPBRC_BAD_TABLE_ID
	OFPBRCIsSlave                 = 10 // OFPBRC_IS_SLAVE
	OFPBRCBadPort                 = 11 // OFPBRC_BAD_PORT
	OFPBRCBadPacket               = 12 // OFPBRC_BAD_PACKET
	OFPBRCMultipartBufferOverflow = 13 // OFPBRC_MULTIPART_BUFFER_OVERFLOW
)

type BadRequestCode uint16

func (self BadRequestCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_anchor
	BSNAnchorPacketStart    = 0 // OFP_BSN_ANCHOR_PACKET_START
	BSNAnchorL3HeaderStart  = 1 // OFP_BSN_ANCHOR_L3_HEADER_START
	BSNAnchorL4HeaderStart  = 2 // OFP_BSN_ANCHOR_L4_HEADER_START
	BSNAnchorL4PayloadStart = 3 // OFP_BSN_ANCHOR_L4_PAYLOAD_START
)

type BsnAnchor uint16

func (self BsnAnchor) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_auto_negotiation_type
	BSNAutoNegotiationDefault = 0 // OFP_BSN_AUTO_NEGOTIATION_DEFAULT
	BSNAutoNegotiationEnable  = 1 // OFP_BSN_AUTO_NEGOTIATION_ENABLE
	BSNAutoNegotiationDisable = 2 // OFP_BSN_AUTO_NEGOTIATION_DISABLE
)

type BsnAutoNegotiationType uint8

func (self BsnAutoNegotiationType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_bfd_endpoint
	BSNBfdUnused   = 0 // OFP_BSN_BFD_UNUSED
	BSNBfdMicro    = 1 // OFP_BSN_BFD_MICRO
	BSNBfd1Hop     = 2 // OFP_BSN_BFD_1_HOP
	BSNBfdMultiHop = 3 // OFP_BSN_BFD_MULTI_HOP
)

type BsnBfdEndpoint uint8

func (self BsnBfdEndpoint) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_bfd_endpoint_state
	BSNBfdEndpointStateAdmindown  = 0 // OFP_BSN_BFD_ENDPOINT_STATE_ADMINDOWN
	BSNBfdEndpointStateDown       = 1 // OFP_BSN_BFD_ENDPOINT_STATE_DOWN
	BSNBfdEndpointStateInit       = 2 // OFP_BSN_BFD_ENDPOINT_STATE_INIT
	BSNBfdEndpointStateUp         = 3 // OFP_BSN_BFD_ENDPOINT_STATE_UP
	BSNBfdEndpointSessionError    = 4 // OFP_BSN_BFD_ENDPOINT_SESSION_ERROR
	BSNBfdEndpointRemoteAdmindown = 5 // OFP_BSN_BFD_ENDPOINT_REMOTE_ADMINDOWN
	BSNBfdEndpointParamsChange    = 6 // OFP_BSN_BFD_ENDPOINT_PARAMS_CHANGE
)

type BsnBfdEndpointState uint8

func (self BsnBfdEndpointState) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_controller_connection_state
	BSNControllerConnectionStateDisconnected = 0 // OFP_BSN_CONTROLLER_CONNECTION_STATE_DISCONNECTED
	BSNControllerConnectionStateConnected    = 1 // OFP_BSN_CONTROLLER_CONNECTION_STATE_CONNECTED
)

type BsnControllerConnectionState uint8

func (self BsnControllerConnectionState) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_controller_role_reason
	BSNControllerRoleReasonMasterRequest = 0 // OFP_BSN_CONTROLLER_ROLE_REASON_MASTER_REQUEST
	BSNControllerRoleReasonConfig        = 1 // OFP_BSN_CONTROLLER_ROLE_REASON_CONFIG
	BSNControllerRoleReasonExperimenter  = 2 // OFP_BSN_CONTROLLER_ROLE_REASON_EXPERIMENTER
)

type BsnControllerRoleReason uint8

func (self BsnControllerRoleReason) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_decap
	BSNDecapVxlan  = 0 // OFP_BSN_DECAP_VXLAN
	BSNDecapErspan = 1 // OFP_BSN_DECAP_ERSPAN
	BSNDecapL2GRE  = 2 // OFP_BSN_DECAP_L2_GRE
	BSNDecapNvgre  = 3 // OFP_BSN_DECAP_NVGRE
	BSNDecapCapwap = 4 // OFP_BSN_DECAP_CAPWAP
	BSNDecapL2Mpls = 5 // OFP_BSN_DECAP_L2_MPLS
	BSNDecapL3GRE  = 6 // OFP_BSN_DECAP_L3_GRE
	BSNDecapGtp    = 7 // OFP_BSN_DECAP_GTP
	BSNDecapL3Mpls = 8 // OFP_BSN_DECAP_L3_MPLS
)

type BsnDecap uint16

func (self BsnDecap) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_encap
	BSNEncapUnused  = 0 // OFP_BSN_ENCAP_UNUSED
	BSNEncapIpv4Udp = 1 // OFP_BSN_ENCAP_IPV4_UDP
	BSNEncapIpv6Udp = 2 // OFP_BSN_ENCAP_IPV6_UDP
)

type BsnEncap uint8

func (self BsnEncap) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_enhanced_hash_type
	BSNEnhancedHashL2        = 1  // OFP_BSN_ENHANCED_HASH_L2
	BSNEnhancedHashL3        = 2  // OFP_BSN_ENHANCED_HASH_L3
	BSNEnhancedHashL2Gre     = 4  // OFP_BSN_ENHANCED_HASH_L2GRE
	BSNEnhancedHashMpls      = 8  // OFP_BSN_ENHANCED_HASH_MPLS
	BSNEnhancedHashGtp       = 16 // OFP_BSN_ENHANCED_HASH_GTP
	BSNEnhancedHashSymmetric = 32 // OFP_BSN_ENHANCED_HASH_SYMMETRIC
)

type BsnEnhancedHashType uint64

func (self BsnEnhancedHashType) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNEnhancedHashL2 == BSNEnhancedHashL2 {
		flags = append(flags, "\"L2\": true")
	}
	if self&BSNEnhancedHashL3 == BSNEnhancedHashL3 {
		flags = append(flags, "\"L3\": true")
	}
	if self&BSNEnhancedHashL2Gre == BSNEnhancedHashL2Gre {
		flags = append(flags, "\"L2Gre\": true")
	}
	if self&BSNEnhancedHashMpls == BSNEnhancedHashMpls {
		flags = append(flags, "\"Mpls\": true")
	}
	if self&BSNEnhancedHashGtp == BSNEnhancedHashGtp {
		flags = append(flags, "\"Gtp\": true")
	}
	if self&BSNEnhancedHashSymmetric == BSNEnhancedHashSymmetric {
		flags = append(flags, "\"Symmetric\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_fabric_port_role
	BSNFabricPortRolePartitionedSpine = 1 // OFP_BSN_FABRIC_PORT_ROLE_PARTITIONED_SPINE
)

type BsnFabricPortRole uint16

func (self BsnFabricPortRole) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_flow_classifier
	BSNFlowClassifierNone        = 0 // OFP_BSN_FLOW_CLASSIFIER_NONE
	BSNFlowClassifierL2Bc        = 1 // OFP_BSN_FLOW_CLASSIFIER_L2BC
	BSNFlowClassifierL2Uc        = 2 // OFP_BSN_FLOW_CLASSIFIER_L2UC
	BSNFlowClassifierL2Unknown   = 3 // OFP_BSN_FLOW_CLASSIFIER_L2UNKNOWN
	BSNFlowClassifierL2Mcknown   = 4 // OFP_BSN_FLOW_CLASSIFIER_L2MCKNOWN
	BSNFlowClassifierL2Mcunknown = 5 // OFP_BSN_FLOW_CLASSIFIER_L2MCUNKNOWN
	BSNFlowClassifierL3Mcunknown = 6 // OFP_BSN_FLOW_CLASSIFIER_L3MCUNKNOWN
	BSNFlowClassifierL3Mcknown   = 7 // OFP_BSN_FLOW_CLASSIFIER_L3MCKNOWN
	BSNFlowClassifierL3Ucknown   = 8 // OFP_BSN_FLOW_CLASSIFIER_L3UCKNOWN
	BSNFlowClassifierL3Ucunknown = 9 // OFP_BSN_FLOW_CLASSIFIER_L3UCUNKNOWN
)

type BsnFlowClassifier uint16

func (self BsnFlowClassifier) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_forward_error_correction_type
	BSNForwardErrorCorrectionDefault = 0 // OFP_BSN_FORWARD_ERROR_CORRECTION_DEFAULT
	BSNForwardErrorCorrectionEnable  = 1 // OFP_BSN_FORWARD_ERROR_CORRECTION_ENABLE
	BSNForwardErrorCorrectionDisable = 2 // OFP_BSN_FORWARD_ERROR_CORRECTION_DISABLE
)

type BsnForwardErrorCorrectionType uint8

func (self BsnForwardErrorCorrectionType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_hash_algorithm_type
	BSNHashAlgorithmCrc16Xor8  = 0 // OFP_BSN_HASH_ALGORITHM_CRC16XOR8
	BSNHashAlgorithmCrc16Xor4  = 1 // OFP_BSN_HASH_ALGORITHM_CRC16XOR4
	BSNHashAlgorithmCrc16Xor2  = 2 // OFP_BSN_HASH_ALGORITHM_CRC16XOR2
	BSNHashAlgorithmCrc16Xor1  = 3 // OFP_BSN_HASH_ALGORITHM_CRC16XOR1
	BSNHashAlgorithmCrc16      = 4 // OFP_BSN_HASH_ALGORITHM_CRC16
	BSNHashAlgorithmXor16      = 5 // OFP_BSN_HASH_ALGORITHM_XOR16
	BSNHashAlgorithmCrc16Ccitt = 6 // OFP_BSN_HASH_ALGORITHM_CRC16CCITT
	BSNHashAlgorithmCrc32Lo    = 7 // OFP_BSN_HASH_ALGORITHM_CRC32LO
	BSNHashAlgorithmCrc32Hi    = 8 // OFP_BSN_HASH_ALGORITHM_CRC32HI
)

type BsnHashAlgorithmType uint16

func (self BsnHashAlgorithmType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_hash_select_flags
	BSNHashSelectSrcIp = 1 // OFP_BSN_HASH_SELECT_SRC_IP
	BSNHashSelectDstIp = 2 // OFP_BSN_HASH_SELECT_DST_IP
)

type BsnHashSelectFlags uint32

func (self BsnHashSelectFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNHashSelectSrcIp == BSNHashSelectSrcIp {
		flags = append(flags, "\"SrcIp\": true")
	}
	if self&BSNHashSelectDstIp == BSNHashSelectDstIp {
		flags = append(flags, "\"DstIp\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_ip_tunnel_type
	BSNIpTunnelTypeNone = 0 // OFP_BSN_IP_TUNNEL_TYPE_NONE
	BSNIpTunnelTypePim  = 1 // OFP_BSN_IP_TUNNEL_TYPE_PIM
)

type BsnIpTunnelType uint16

func (self BsnIpTunnelType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_lacp_state
	BSNLacpStateActivity        = 1   // OFP_BSN_LACP_STATE_ACTIVITY
	BSNLacpStateTimeout         = 2   // OFP_BSN_LACP_STATE_TIMEOUT
	BSNLacpStateAggregation     = 4   // OFP_BSN_LACP_STATE_AGGREGATION
	BSNLacpStateSynchronization = 8   // OFP_BSN_LACP_STATE_SYNCHRONIZATION
	BSNLacpStateCollecting      = 16  // OFP_BSN_LACP_STATE_COLLECTING
	BSNLacpStateDistributing    = 32  // OFP_BSN_LACP_STATE_DISTRIBUTING
	BSNLacpStateDefaulted       = 64  // OFP_BSN_LACP_STATE_DEFAULTED
	BSNLacpStateExpired         = 128 // OFP_BSN_LACP_STATE_EXPIRED
)

type BsnLacpState uint8

func (self BsnLacpState) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNLacpStateActivity == BSNLacpStateActivity {
		flags = append(flags, "\"Activity\": true")
	}
	if self&BSNLacpStateTimeout == BSNLacpStateTimeout {
		flags = append(flags, "\"Timeout\": true")
	}
	if self&BSNLacpStateAggregation == BSNLacpStateAggregation {
		flags = append(flags, "\"Aggregation\": true")
	}
	if self&BSNLacpStateSynchronization == BSNLacpStateSynchronization {
		flags = append(flags, "\"Synchronization\": true")
	}
	if self&BSNLacpStateCollecting == BSNLacpStateCollecting {
		flags = append(flags, "\"Collecting\": true")
	}
	if self&BSNLacpStateDistributing == BSNLacpStateDistributing {
		flags = append(flags, "\"Distributing\": true")
	}
	if self&BSNLacpStateDefaulted == BSNLacpStateDefaulted {
		flags = append(flags, "\"Defaulted\": true")
	}
	if self&BSNLacpStateExpired == BSNLacpStateExpired {
		flags = append(flags, "\"Expired\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_lag_flag
	BSNLagFlagAutoRecovery = 1 // OFP_BSN_LAG_FLAG_AUTO_RECOVERY
)

type BsnLagFlag uint16

func (self BsnLagFlag) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNLagFlagAutoRecovery == BSNLagFlagAutoRecovery {
		flags = append(flags, "\"BSNLagFlagAutoRecovery\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_loglevel
	BSNLoglevelMsg     = 0 // OFP_BSN_LOGLEVEL_MSG
	BSNLoglevelError   = 1 // OFP_BSN_LOGLEVEL_ERROR
	BSNLoglevelWarn    = 2 // OFP_BSN_LOGLEVEL_WARN
	BSNLoglevelInfo    = 3 // OFP_BSN_LOGLEVEL_INFO
	BSNLoglevelVerbose = 4 // OFP_BSN_LOGLEVEL_VERBOSE
	BSNLoglevelTrace   = 5 // OFP_BSN_LOGLEVEL_TRACE
)

type BsnLoglevel uint8

func (self BsnLoglevel) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_loopback_mode
	BSNLoopbackModeNone      = 0 // OFP_BSN_LOOPBACK_MODE_NONE
	BSNLoopbackModeMAC       = 1 // OFP_BSN_LOOPBACK_MODE_MAC
	BSNLoopbackModePhy       = 2 // OFP_BSN_LOOPBACK_MODE_PHY
	BSNLoopbackModePhyRemote = 3 // OFP_BSN_LOOPBACK_MODE_PHY_REMOTE
)

type BsnLoopbackMode uint8

func (self BsnLoopbackMode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_lua_upload_flags
	BSNLuaUploadMore  = 1 // OFP_BSN_LUA_UPLOAD_MORE
	BSNLuaUploadForce = 2 // OFP_BSN_LUA_UPLOAD_FORCE
)

type BsnLuaUploadFlags uint16

func (self BsnLuaUploadFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNLuaUploadMore == BSNLuaUploadMore {
		flags = append(flags, "\"More\": true")
	}
	if self&BSNLuaUploadForce == BSNLuaUploadForce {
		flags = append(flags, "\"Force\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_multicast_packet
	BSNMulticastPacketNone         = 0 // OFP_BSN_MULTICAST_PACKET_NONE
	BSNMulticastPacketPimHello     = 1 // OFP_BSN_MULTICAST_PACKET_PIM_HELLO
	BSNMulticastPacketPimJoinPrune = 2 // OFP_BSN_MULTICAST_PACKET_PIM_JOIN_PRUNE
	BSNMulticastPacketPimAssert    = 3 // OFP_BSN_MULTICAST_PACKET_PIM_ASSERT
)

type BsnMulticastPacket uint16

func (self BsnMulticastPacket) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_pktin_flag
	BSNPktinFlagPdu             = 1       // OFP_BSN_PKTIN_FLAG_PDU
	BSNPktinFlagNewHost         = 2       // OFP_BSN_PKTIN_FLAG_NEW_HOST
	BSNPktinFlagStationMove     = 4       // OFP_BSN_PKTIN_FLAG_STATION_MOVE
	BSNPktinFlagARP             = 8       // OFP_BSN_PKTIN_FLAG_ARP
	BSNPktinFlagDhcp            = 16      // OFP_BSN_PKTIN_FLAG_DHCP
	BSNPktinFlagL2Cpu           = 32      // OFP_BSN_PKTIN_FLAG_L2_CPU
	BSNPktinFlagDebug           = 64      // OFP_BSN_PKTIN_FLAG_DEBUG
	BSNPktinFlagTtlExpired      = 128     // OFP_BSN_PKTIN_FLAG_TTL_EXPIRED
	BSNPktinFlagL3Miss          = 256     // OFP_BSN_PKTIN_FLAG_L3_MISS
	BSNPktinFlagL3Cpu           = 512     // OFP_BSN_PKTIN_FLAG_L3_CPU
	BSNPktinFlagIngressAcl      = 1024    // OFP_BSN_PKTIN_FLAG_INGRESS_ACL
	BSNPktinFlagSflow           = 2048    // OFP_BSN_PKTIN_FLAG_SFLOW
	BSNPktinFlagARPCache        = 4096    // OFP_BSN_PKTIN_FLAG_ARP_CACHE
	BSNPktinFlagARPTarget       = 8192    // OFP_BSN_PKTIN_FLAG_ARP_TARGET
	BSNPktinFlagIgmp            = 16384   // OFP_BSN_PKTIN_FLAG_IGMP
	BSNPktinFlagPim             = 32768   // OFP_BSN_PKTIN_FLAG_PIM
	BSNPktinFlagVxlanSipMiss    = 65536   // OFP_BSN_PKTIN_FLAG_VXLAN_SIP_MISS
	BSNPktinFlagMcReserved      = 131072  // OFP_BSN_PKTIN_FLAG_MC_RESERVED
	BSNPktinFlagAnalytics       = 262144  // OFP_BSN_PKTIN_FLAG_ANALYTICS
	BSNPktinFlagIcmpv6          = 524288  // OFP_BSN_PKTIN_FLAG_ICMPV6
	BSNPktinFlagIngressAclLocal = 1048576 // OFP_BSN_PKTIN_FLAG_INGRESS_ACL_LOCAL
	BSNPktinFlagIpmcMiss        = 2097152 // OFP_BSN_PKTIN_FLAG_IPMC_MISS
	BSNPktinFlagIpmcRpfFailed   = 4194304 // OFP_BSN_PKTIN_FLAG_IPMC_RPF_FAILED
	BSNPktinFlagBfdSlowpath     = 8388608 // OFP_BSN_PKTIN_FLAG_BFD_SLOWPATH
)

type BsnPktinFlag uint64

func (self BsnPktinFlag) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNPktinFlagPdu == BSNPktinFlagPdu {
		flags = append(flags, "\"Pdu\": true")
	}
	if self&BSNPktinFlagNewHost == BSNPktinFlagNewHost {
		flags = append(flags, "\"NewHost\": true")
	}
	if self&BSNPktinFlagStationMove == BSNPktinFlagStationMove {
		flags = append(flags, "\"StationMove\": true")
	}
	if self&BSNPktinFlagARP == BSNPktinFlagARP {
		flags = append(flags, "\"Arp\": true")
	}
	if self&BSNPktinFlagDhcp == BSNPktinFlagDhcp {
		flags = append(flags, "\"Dhcp\": true")
	}
	if self&BSNPktinFlagL2Cpu == BSNPktinFlagL2Cpu {
		flags = append(flags, "\"L2Cpu\": true")
	}
	if self&BSNPktinFlagDebug == BSNPktinFlagDebug {
		flags = append(flags, "\"Debug\": true")
	}
	if self&BSNPktinFlagTtlExpired == BSNPktinFlagTtlExpired {
		flags = append(flags, "\"TtlExpired\": true")
	}
	if self&BSNPktinFlagL3Miss == BSNPktinFlagL3Miss {
		flags = append(flags, "\"L3Miss\": true")
	}
	if self&BSNPktinFlagL3Cpu == BSNPktinFlagL3Cpu {
		flags = append(flags, "\"L3Cpu\": true")
	}
	if self&BSNPktinFlagIngressAcl == BSNPktinFlagIngressAcl {
		flags = append(flags, "\"IngressAcl\": true")
	}
	if self&BSNPktinFlagSflow == BSNPktinFlagSflow {
		flags = append(flags, "\"Sflow\": true")
	}
	if self&BSNPktinFlagARPCache == BSNPktinFlagARPCache {
		flags = append(flags, "\"ArpCache\": true")
	}
	if self&BSNPktinFlagARPTarget == BSNPktinFlagARPTarget {
		flags = append(flags, "\"ArpTarget\": true")
	}
	if self&BSNPktinFlagIgmp == BSNPktinFlagIgmp {
		flags = append(flags, "\"Igmp\": true")
	}
	if self&BSNPktinFlagPim == BSNPktinFlagPim {
		flags = append(flags, "\"Pim\": true")
	}
	if self&BSNPktinFlagVxlanSipMiss == BSNPktinFlagVxlanSipMiss {
		flags = append(flags, "\"VxlanSipMiss\": true")
	}
	if self&BSNPktinFlagMcReserved == BSNPktinFlagMcReserved {
		flags = append(flags, "\"McReserved\": true")
	}
	if self&BSNPktinFlagAnalytics == BSNPktinFlagAnalytics {
		flags = append(flags, "\"Analytics\": true")
	}
	if self&BSNPktinFlagIcmpv6 == BSNPktinFlagIcmpv6 {
		flags = append(flags, "\"Icmpv6\": true")
	}
	if self&BSNPktinFlagIngressAclLocal == BSNPktinFlagIngressAclLocal {
		flags = append(flags, "\"IngressAclLocal\": true")
	}
	if self&BSNPktinFlagIpmcMiss == BSNPktinFlagIpmcMiss {
		flags = append(flags, "\"IpmcMiss\": true")
	}
	if self&BSNPktinFlagIpmcRpfFailed == BSNPktinFlagIpmcRpfFailed {
		flags = append(flags, "\"IpmcRpfFailed\": true")
	}
	if self&BSNPktinFlagBfdSlowpath == BSNPktinFlagBfdSlowpath {
		flags = append(flags, "\"BfdSlowpath\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_port_counter
	BSNPortCounterRxBytes                = 0  // OFP_BSN_PORT_COUNTER_RX_BYTES
	BSNPortCounterRxPacketsUnicast       = 1  // OFP_BSN_PORT_COUNTER_RX_PACKETS_UNICAST
	BSNPortCounterRxPacketsBroadcast     = 2  // OFP_BSN_PORT_COUNTER_RX_PACKETS_BROADCAST
	BSNPortCounterRxPacketsMulticast     = 3  // OFP_BSN_PORT_COUNTER_RX_PACKETS_MULTICAST
	BSNPortCounterRxDropped              = 4  // OFP_BSN_PORT_COUNTER_RX_DROPPED
	BSNPortCounterRxErrors               = 5  // OFP_BSN_PORT_COUNTER_RX_ERRORS
	BSNPortCounterTxBytes                = 6  // OFP_BSN_PORT_COUNTER_TX_BYTES
	BSNPortCounterTxPacketsUnicast       = 7  // OFP_BSN_PORT_COUNTER_TX_PACKETS_UNICAST
	BSNPortCounterTxPacketsBroadcast     = 8  // OFP_BSN_PORT_COUNTER_TX_PACKETS_BROADCAST
	BSNPortCounterTxPacketsMulticast     = 9  // OFP_BSN_PORT_COUNTER_TX_PACKETS_MULTICAST
	BSNPortCounterTxDropped              = 10 // OFP_BSN_PORT_COUNTER_TX_DROPPED
	BSNPortCounterTxErrors               = 11 // OFP_BSN_PORT_COUNTER_TX_ERRORS
	BSNPortCounterRxRunts                = 12 // OFP_BSN_PORT_COUNTER_RX_RUNTS
	BSNPortCounterRxGiants               = 13 // OFP_BSN_PORT_COUNTER_RX_GIANTS
	BSNPortCounterRxCrcErrors            = 14 // OFP_BSN_PORT_COUNTER_RX_CRC_ERRORS
	BSNPortCounterRxAlignmentErrors      = 15 // OFP_BSN_PORT_COUNTER_RX_ALIGNMENT_ERRORS
	BSNPortCounterRxSymbolErrors         = 16 // OFP_BSN_PORT_COUNTER_RX_SYMBOL_ERRORS
	BSNPortCounterRxPauseInput           = 17 // OFP_BSN_PORT_COUNTER_RX_PAUSE_INPUT
	BSNPortCounterTxCollisions           = 18 // OFP_BSN_PORT_COUNTER_TX_COLLISIONS
	BSNPortCounterTxLateCollisions       = 19 // OFP_BSN_PORT_COUNTER_TX_LATE_COLLISIONS
	BSNPortCounterTxDeferred             = 20 // OFP_BSN_PORT_COUNTER_TX_DEFERRED
	BSNPortCounterTxPauseOutput          = 21 // OFP_BSN_PORT_COUNTER_TX_PAUSE_OUTPUT
	BSNPortCounterRxPackets              = 22 // OFP_BSN_PORT_COUNTER_RX_PACKETS
	BSNPortCounterTxPackets              = 23 // OFP_BSN_PORT_COUNTER_TX_PACKETS
	BSNPortCounterRxLengthErrors         = 24 // OFP_BSN_PORT_COUNTER_RX_LENGTH_ERRORS
	BSNPortCounterRxOverflowErrors       = 25 // OFP_BSN_PORT_COUNTER_RX_OVERFLOW_ERRORS
	BSNPortCounterTxCarrierErrors        = 26 // OFP_BSN_PORT_COUNTER_TX_CARRIER_ERRORS
	BSNPortCounterRxPacketsBadVLAN       = 27 // OFP_BSN_PORT_COUNTER_RX_PACKETS_BAD_VLAN
	BSNPortCounterLinkUp                 = 28 // OFP_BSN_PORT_COUNTER_LINK_UP
	BSNPortCounterLinkDown               = 29 // OFP_BSN_PORT_COUNTER_LINK_DOWN
	BSNPortCounterRxPfcControlFrame      = 30 // OFP_BSN_PORT_COUNTER_RX_PFC_CONTROL_FRAME
	BSNPortCounterTxPfcControlFrame      = 31 // OFP_BSN_PORT_COUNTER_TX_PFC_CONTROL_FRAME
	BSNPortCounterRxPfcFrameXonPriority0 = 32 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_XON_PRIORITY_0
	BSNPortCounterRxPfcFrameXonPriority1 = 33 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_XON_PRIORITY_1
	BSNPortCounterRxPfcFrameXonPriority2 = 34 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_XON_PRIORITY_2
	BSNPortCounterRxPfcFrameXonPriority3 = 35 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_XON_PRIORITY_3
	BSNPortCounterRxPfcFrameXonPriority4 = 36 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_XON_PRIORITY_4
	BSNPortCounterRxPfcFrameXonPriority5 = 37 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_XON_PRIORITY_5
	BSNPortCounterRxPfcFrameXonPriority6 = 38 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_XON_PRIORITY_6
	BSNPortCounterRxPfcFrameXonPriority7 = 39 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_XON_PRIORITY_7
	BSNPortCounterRxPfcFramePriority0    = 40 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_PRIORITY_0
	BSNPortCounterRxPfcFramePriority1    = 41 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_PRIORITY_1
	BSNPortCounterRxPfcFramePriority2    = 42 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_PRIORITY_2
	BSNPortCounterRxPfcFramePriority3    = 43 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_PRIORITY_3
	BSNPortCounterRxPfcFramePriority4    = 44 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_PRIORITY_4
	BSNPortCounterRxPfcFramePriority5    = 45 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_PRIORITY_5
	BSNPortCounterRxPfcFramePriority6    = 46 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_PRIORITY_6
	BSNPortCounterRxPfcFramePriority7    = 47 // OFP_BSN_PORT_COUNTER_RX_PFC_FRAME_PRIORITY_7
	BSNPortCounterTxPfcFramePriority0    = 48 // OFP_BSN_PORT_COUNTER_TX_PFC_FRAME_PRIORITY_0
	BSNPortCounterTxPfcFramePriority1    = 49 // OFP_BSN_PORT_COUNTER_TX_PFC_FRAME_PRIORITY_1
	BSNPortCounterTxPfcFramePriority2    = 50 // OFP_BSN_PORT_COUNTER_TX_PFC_FRAME_PRIORITY_2
	BSNPortCounterTxPfcFramePriority3    = 51 // OFP_BSN_PORT_COUNTER_TX_PFC_FRAME_PRIORITY_3
	BSNPortCounterTxPfcFramePriority4    = 52 // OFP_BSN_PORT_COUNTER_TX_PFC_FRAME_PRIORITY_4
	BSNPortCounterTxPfcFramePriority5    = 53 // OFP_BSN_PORT_COUNTER_TX_PFC_FRAME_PRIORITY_5
	BSNPortCounterTxPfcFramePriority6    = 54 // OFP_BSN_PORT_COUNTER_TX_PFC_FRAME_PRIORITY_6
	BSNPortCounterTxPfcFramePriority7    = 55 // OFP_BSN_PORT_COUNTER_TX_PFC_FRAME_PRIORITY_7
)

type BsnPortCounter uint8

func (self BsnPortCounter) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_port_mode
	BSNPortModeNone  = 0  // OFP_BSN_PORT_MODE_NONE
	BSNPortMode4Xx   = 1  // OFP_BSN_PORT_MODE_4XX
	BSNPortMode4X1   = 2  // OFP_BSN_PORT_MODE_4X1
	BSNPortMode4X10  = 3  // OFP_BSN_PORT_MODE_4X10
	BSNPortMode4X25  = 4  // OFP_BSN_PORT_MODE_4X25
	BSNPortMode2X50  = 5  // OFP_BSN_PORT_MODE_2X50
	BSNPortMode1X1   = 6  // OFP_BSN_PORT_MODE_1X1
	BSNPortMode1X10  = 7  // OFP_BSN_PORT_MODE_1X10
	BSNPortMode1X25  = 8  // OFP_BSN_PORT_MODE_1X25
	BSNPortMode1X40  = 9  // OFP_BSN_PORT_MODE_1X40
	BSNPortMode1X100 = 10 // OFP_BSN_PORT_MODE_1X100
)

type BsnPortMode uint16

func (self BsnPortMode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_port_speed_gbps_type
	BSNPortSpeedGbps1   = 1   // OFP_BSN_PORT_SPEED_GBPS_1
	BSNPortSpeedGbps10  = 10  // OFP_BSN_PORT_SPEED_GBPS_10
	BSNPortSpeedGbps25  = 25  // OFP_BSN_PORT_SPEED_GBPS_25
	BSNPortSpeedGbps40  = 40  // OFP_BSN_PORT_SPEED_GBPS_40
	BSNPortSpeedGbps50  = 50  // OFP_BSN_PORT_SPEED_GBPS_50
	BSNPortSpeedGbps100 = 100 // OFP_BSN_PORT_SPEED_GBPS_100
)

type BsnPortSpeedGbpsType uint32

func (self BsnPortSpeedGbpsType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_port_usage
	BSNPortUnused       = 0 // OFP_BSN_PORT_UNUSED
	BSNPortTransmitOnly = 1 // OFP_BSN_PORT_TRANSMIT_ONLY
	BSNPortReceiveOnly  = 2 // OFP_BSN_PORT_RECEIVE_ONLY
	BSNPortBidirection  = 3 // OFP_BSN_PORT_BIDIRECTION
)

type BsnPortUsage uint16

func (self BsnPortUsage) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_port_vxlan_mode
	BSNPortVxlanRecirculationEnable = 0 // OFP_BSN_PORT_VXLAN_RECIRCULATION_ENABLE
	BSNPortVxlanTerminationEnable   = 1 // OFP_BSN_PORT_VXLAN_TERMINATION_ENABLE
)

type BsnPortVxlanMode uint8

func (self BsnPortVxlanMode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_push_vlan
	BSNPushVLANUntagged     = 1 // OFP_BSN_PUSH_VLAN_UNTAGGED
	BSNPushVLANSingleTagged = 2 // OFP_BSN_PUSH_VLAN_SINGLE_TAGGED
	BSNPushVLANDoubleTagged = 4 // OFP_BSN_PUSH_VLAN_DOUBLE_TAGGED
)

type BsnPushVlan uint8

func (self BsnPushVlan) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNPushVLANUntagged == BSNPushVLANUntagged {
		flags = append(flags, "\"Untagged\": true")
	}
	if self&BSNPushVLANSingleTagged == BSNPushVLANSingleTagged {
		flags = append(flags, "\"SingleTagged\": true")
	}
	if self&BSNPushVLANDoubleTagged == BSNPushVLANDoubleTagged {
		flags = append(flags, "\"DoubleTagged\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_rate_unit
	BSNRateUnitPps    = 0 // OFP_BSN_RATE_UNIT_PPS
	BSNRateUnitKbitps = 1 // OFP_BSN_RATE_UNIT_KBITPS
)

type BsnRateUnit uint8

func (self BsnRateUnit) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_routing_param
	BSNRoutingParamOspfUcast     = 1 // OFP_BSN_ROUTING_PARAM_OSPF_UCAST
	BSNRoutingParamOspfMcast     = 2 // OFP_BSN_ROUTING_PARAM_OSPF_MCAST
	BSNRoutingParamARPFrr        = 3 // OFP_BSN_ROUTING_PARAM_ARP_FRR
	BSNRoutingParamIpv6OspfUcast = 4 // OFP_BSN_ROUTING_PARAM_IPV6_OSPF_UCAST
	BSNRoutingParamIpv6OspfMcast = 5 // OFP_BSN_ROUTING_PARAM_IPV6_OSPF_MCAST
	BSNRoutingParamIpv6NdpFrr    = 6 // OFP_BSN_ROUTING_PARAM_IPV6_NDP_FRR
)

type BsnRoutingParam uint16

func (self BsnRoutingParam) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_status
	BSNStatusDisable = 0 // OFP_BSN_STATUS_DISABLE
	BSNStatusEnable  = 1 // OFP_BSN_STATUS_ENABLE
)

type BsnStatus uint8

func (self BsnStatus) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_strip_vlan
	BSNStripVLANFirst  = 1 // OFP_BSN_STRIP_VLAN_FIRST
	BSNStripVLANSecond = 2 // OFP_BSN_STRIP_VLAN_SECOND
	BSNStripVLANThird  = 4 // OFP_BSN_STRIP_VLAN_THIRD
)

type BsnStripVlan uint8

func (self BsnStripVlan) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNStripVLANFirst == BSNStripVLANFirst {
		flags = append(flags, "\"First\": true")
	}
	if self&BSNStripVLANSecond == BSNStripVLANSecond {
		flags = append(flags, "\"Second\": true")
	}
	if self&BSNStripVLANThird == BSNStripVLANThird {
		flags = append(flags, "\"Third\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_tcp_flag
	BSNTCPFlagFin = 1   // OFP_BSN_TCP_FLAG_FIN
	BSNTCPFlagSyn = 2   // OFP_BSN_TCP_FLAG_SYN
	BSNTCPFlagRst = 4   // OFP_BSN_TCP_FLAG_RST
	BSNTCPFlagPsh = 8   // OFP_BSN_TCP_FLAG_PSH
	BSNTCPFlagAck = 16  // OFP_BSN_TCP_FLAG_ACK
	BSNTCPFlagUrg = 32  // OFP_BSN_TCP_FLAG_URG
	BSNTCPFlagEce = 64  // OFP_BSN_TCP_FLAG_ECE
	BSNTCPFlagCwr = 128 // OFP_BSN_TCP_FLAG_CWR
	BSNTCPFlagNs  = 256 // OFP_BSN_TCP_FLAG_NS
)

type BsnTcpFlag uint16

func (self BsnTcpFlag) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNTCPFlagFin == BSNTCPFlagFin {
		flags = append(flags, "\"Fin\": true")
	}
	if self&BSNTCPFlagSyn == BSNTCPFlagSyn {
		flags = append(flags, "\"Syn\": true")
	}
	if self&BSNTCPFlagRst == BSNTCPFlagRst {
		flags = append(flags, "\"Rst\": true")
	}
	if self&BSNTCPFlagPsh == BSNTCPFlagPsh {
		flags = append(flags, "\"Psh\": true")
	}
	if self&BSNTCPFlagAck == BSNTCPFlagAck {
		flags = append(flags, "\"Ack\": true")
	}
	if self&BSNTCPFlagUrg == BSNTCPFlagUrg {
		flags = append(flags, "\"Urg\": true")
	}
	if self&BSNTCPFlagEce == BSNTCPFlagEce {
		flags = append(flags, "\"Ece\": true")
	}
	if self&BSNTCPFlagCwr == BSNTCPFlagCwr {
		flags = append(flags, "\"Cwr\": true")
	}
	if self&BSNTCPFlagNs == BSNTCPFlagNs {
		flags = append(flags, "\"Ns\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_tunnel_type
	BSNTunnelL2Gre = 1 // OFP_BSN_TUNNEL_L2GRE
)

type BsnTunnelType uint64

func (self BsnTunnelType) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNTunnelL2Gre == BSNTunnelL2Gre {
		flags = append(flags, "\"BSNTunnelL2Gre\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_udf_anchor
	BSNUdfAnchorPacketStart   = 0 // OFP_BSN_UDF_ANCHOR_PACKET_START
	BSNUdfAnchorL3HeaderStart = 1 // OFP_BSN_UDF_ANCHOR_L3_HEADER_START
	BSNUdfAnchorL4HeaderStart = 2 // OFP_BSN_UDF_ANCHOR_L4_HEADER_START
)

type BsnUdfAnchor uint16

func (self BsnUdfAnchor) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_udf_mode
	BSNUdf8X2Bytes = 1 // OFP_BSN_UDF_8X2_BYTES
)

type BsnUdfMode uint8

func (self BsnUdfMode) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&BSNUdf8X2Bytes == BSNUdf8X2Bytes {
		flags = append(flags, "\"BSNUdf8X2Bytes\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_upgrade
	BSNUpgradeInvalid    = 0 // OFP_BSN_UPGRADE_INVALID
	BSNUpgradeInProgress = 1 // OFP_BSN_UPGRADE_IN_PROGRESS
)

type BsnUpgrade uint16

func (self BsnUpgrade) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_vlan_counter_constants
	BSNVLANAll = 65535 // OFP_BSN_VLAN_ALL
)

const (
	// Identifiers from group ofp_bsn_vport_l2gre_flags
	OFBSNVportL2GreLocalMACIsValid  = 1  // OF_BSN_VPORT_L2GRE_LOCAL_MAC_IS_VALID
	OFBSNVportL2GreDSCPAssign       = 2  // OF_BSN_VPORT_L2GRE_DSCP_ASSIGN
	OFBSNVportL2GreDSCPCopy         = 4  // OF_BSN_VPORT_L2GRE_DSCP_COPY
	OFBSNVportL2GreLoopbackIsValid  = 8  // OF_BSN_VPORT_L2GRE_LOOPBACK_IS_VALID
	OFBSNVportL2GreRateLimitIsValid = 16 // OF_BSN_VPORT_L2GRE_RATE_LIMIT_IS_VALID
)

type BsnVportL2GreFlags uint32

func (self BsnVportL2GreFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFBSNVportL2GreLocalMACIsValid == OFBSNVportL2GreLocalMACIsValid {
		flags = append(flags, "\"LocalMACIsValid\": true")
	}
	if self&OFBSNVportL2GreDSCPAssign == OFBSNVportL2GreDSCPAssign {
		flags = append(flags, "\"DscpAssign\": true")
	}
	if self&OFBSNVportL2GreDSCPCopy == OFBSNVportL2GreDSCPCopy {
		flags = append(flags, "\"DscpCopy\": true")
	}
	if self&OFBSNVportL2GreLoopbackIsValid == OFBSNVportL2GreLoopbackIsValid {
		flags = append(flags, "\"LoopbackIsValid\": true")
	}
	if self&OFBSNVportL2GreRateLimitIsValid == OFBSNVportL2GreRateLimitIsValid {
		flags = append(flags, "\"RateLimitIsValid\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_bsn_vport_q_in_q_untagged
	OFBSNVportQInQUntagged = 65535 // OF_BSN_VPORT_Q_IN_Q_UNTAGGED
)

type BsnVportQInQUntagged uint16

func (self BsnVportQInQUntagged) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_bsn_vport_status
	OFBSNVportStatusOk     = 0 // OF_BSN_VPORT_STATUS_OK
	OFBSNVportStatusFailed = 1 // OF_BSN_VPORT_STATUS_FAILED
)

const (
	// Identifiers from group ofp_bsn_vrf_counter_constants
	BSNVrfAll = 4294967295 // OFP_BSN_VRF_ALL
)

type BsnVrfCounterConstants uint32

func (self BsnVrfCounterConstants) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_capabilities
	OFPCFlowStats   = 1   // OFPC_FLOW_STATS
	OFPCTableStats  = 2   // OFPC_TABLE_STATS
	OFPCPortStats   = 4   // OFPC_PORT_STATS
	OFPCGroupStats  = 8   // OFPC_GROUP_STATS
	OFPCIpReasm     = 32  // OFPC_IP_REASM
	OFPCQueueStats  = 64  // OFPC_QUEUE_STATS
	OFPCPortBlocked = 256 // OFPC_PORT_BLOCKED
)

type Capabilities uint32

func (self Capabilities) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPCFlowStats == OFPCFlowStats {
		flags = append(flags, "\"FlowStats\": true")
	}
	if self&OFPCTableStats == OFPCTableStats {
		flags = append(flags, "\"TableStats\": true")
	}
	if self&OFPCPortStats == OFPCPortStats {
		flags = append(flags, "\"PortStats\": true")
	}
	if self&OFPCGroupStats == OFPCGroupStats {
		flags = append(flags, "\"GroupStats\": true")
	}
	if self&OFPCIpReasm == OFPCIpReasm {
		flags = append(flags, "\"IpReasm\": true")
	}
	if self&OFPCQueueStats == OFPCQueueStats {
		flags = append(flags, "\"QueueStats\": true")
	}
	if self&OFPCPortBlocked == OFPCPortBlocked {
		flags = append(flags, "\"PortBlocked\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_config_flags
	OFPCFragNormal = 0 // OFPC_FRAG_NORMAL
	OFPCFragDrop   = 1 // OFPC_FRAG_DROP
	OFPCFragReasm  = 2 // OFPC_FRAG_REASM
	OFPCFragMask   = 3 // OFPC_FRAG_MASK
)

type ConfigFlags uint16

func (self ConfigFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPCFragNormal == OFPCFragNormal {
		flags = append(flags, "\"Normal\": true")
	}
	if self&OFPCFragDrop == OFPCFragDrop {
		flags = append(flags, "\"Drop\": true")
	}
	if self&OFPCFragReasm == OFPCFragReasm {
		flags = append(flags, "\"Reasm\": true")
	}
	if self&OFPCFragMask == OFPCFragMask {
		flags = append(flags, "\"Mask\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_controller_max_len
	OFPCMLMax      = 65509 // OFPCML_MAX
	OFPCMLNoBuffer = 65535 // OFPCML_NO_BUFFER
)

type ControllerMaxLen uint16

func (self ControllerMaxLen) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_controller_role
	OFPCRRoleNochange = 0 // OFPCR_ROLE_NOCHANGE
	OFPCRRoleEqual    = 1 // OFPCR_ROLE_EQUAL
	OFPCRRoleMaster   = 2 // OFPCR_ROLE_MASTER
	OFPCRRoleSlave    = 3 // OFPCR_ROLE_SLAVE
)

type ControllerRole uint32

func (self ControllerRole) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_cs_states
	CsNew         = 1   // OFP_CS_NEW
	CsEstablished = 2   // OFP_CS_ESTABLISHED
	CsRelated     = 4   // OFP_CS_RELATED
	CsReplyDir    = 8   // OFP_CS_REPLY_DIR
	CsInvalid     = 16  // OFP_CS_INVALID
	CsTracked     = 32  // OFP_CS_TRACKED
	CsSrcNat      = 64  // OFP_CS_SRC_NAT
	CsDstNat      = 128 // OFP_CS_DST_NAT
)

type CsStates uint32

func (self CsStates) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&CsNew == CsNew {
		flags = append(flags, "\"New\": true")
	}
	if self&CsEstablished == CsEstablished {
		flags = append(flags, "\"Established\": true")
	}
	if self&CsRelated == CsRelated {
		flags = append(flags, "\"Related\": true")
	}
	if self&CsReplyDir == CsReplyDir {
		flags = append(flags, "\"ReplyDir\": true")
	}
	if self&CsInvalid == CsInvalid {
		flags = append(flags, "\"Invalid\": true")
	}
	if self&CsTracked == CsTracked {
		flags = append(flags, "\"Tracked\": true")
	}
	if self&CsSrcNat == CsSrcNat {
		flags = append(flags, "\"SrcNat\": true")
	}
	if self&CsDstNat == CsDstNat {
		flags = append(flags, "\"DstNat\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_ed_nsh_prop_type
	OFPPPTPropNshNone   = 0 // OFPPPT_PROP_NSH_NONE
	OFPPPTPropNshMdtype = 1 // OFPPPT_PROP_NSH_MDTYPE
	OFPPPTPropNshTlv    = 2 // OFPPPT_PROP_NSH_TLV
)

type EdNshPropType uint8

func (self EdNshPropType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_ed_prop_class
	OFPPPCBasic        = 0     // OFPPPC_BASIC
	OFPPPCMpls         = 1     // OFPPPC_MPLS
	OFPPPCGRE          = 2     // OFPPPC_GRE
	OFPPPCGtp          = 3     // OFPPPC_GTP
	OFPPPCNsh          = 4     // OFPPPC_NSH
	OFPPPCExperimenter = 65535 // OFPPPC_EXPERIMENTER
)

type EdPropClass uint16

func (self EdPropClass) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_error_type
	OFPETHelloFailed         = 0     // OFPET_HELLO_FAILED
	OFPETBadRequest          = 1     // OFPET_BAD_REQUEST
	OFPETBadAction           = 2     // OFPET_BAD_ACTION
	OFPETBadInstruction      = 3     // OFPET_BAD_INSTRUCTION
	OFPETBadMatch            = 4     // OFPET_BAD_MATCH
	OFPETFlowModFailed       = 5     // OFPET_FLOW_MOD_FAILED
	OFPETGroupModFailed      = 6     // OFPET_GROUP_MOD_FAILED
	OFPETPortModFailed       = 7     // OFPET_PORT_MOD_FAILED
	OFPETTableModFailed      = 8     // OFPET_TABLE_MOD_FAILED
	OFPETQueueOpFailed       = 9     // OFPET_QUEUE_OP_FAILED
	OFPETSwitchConfigFailed  = 10    // OFPET_SWITCH_CONFIG_FAILED
	OFPETRoleRequestFailed   = 11    // OFPET_ROLE_REQUEST_FAILED
	OFPETMeterModFailed      = 12    // OFPET_METER_MOD_FAILED
	OFPETTableFeaturesFailed = 13    // OFPET_TABLE_FEATURES_FAILED
	OFPETExperimenter        = 65535 // OFPET_EXPERIMENTER
)

type ErrorType uint16

func (self ErrorType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_ethernet_type
	EthPLoop      = 96    // ETH_P_LOOP
	EthPPup       = 512   // ETH_P_PUP
	EthPPupat     = 513   // ETH_P_PUPAT
	EthPIp        = 2048  // ETH_P_IP
	EthPX25       = 2053  // ETH_P_X25
	EthPARP       = 2054  // ETH_P_ARP
	EthPBpq       = 2303  // ETH_P_BPQ
	EthPIeeepup   = 2560  // ETH_P_IEEEPUP
	EthPIeeepupat = 2561  // ETH_P_IEEEPUPAT
	EthPDec       = 24576 // ETH_P_DEC
	EthPDnaDl     = 24577 // ETH_P_DNA_DL
	EthPDnaRc     = 24578 // ETH_P_DNA_RC
	EthPDnaRt     = 24579 // ETH_P_DNA_RT
	EthPLat       = 24580 // ETH_P_LAT
	EthPDiag      = 24581 // ETH_P_DIAG
	EthPCust      = 24582 // ETH_P_CUST
	EthPSca       = 24583 // ETH_P_SCA
	EthPTeb       = 25944 // ETH_P_TEB
	EthPRarp      = 32821 // ETH_P_RARP
	EthPAtalk     = 32923 // ETH_P_ATALK
	EthPAarp      = 33011 // ETH_P_AARP
	EthP8021Q     = 33024 // ETH_P_8021Q
	EthPIpx       = 33079 // ETH_P_IPX
	EthPIpv6      = 34525 // ETH_P_IPV6
	EthPPause     = 34824 // ETH_P_PAUSE
	EthPSlow      = 34825 // ETH_P_SLOW
	EthPWccp      = 34878 // ETH_P_WCCP
	EthPPppDisc   = 34915 // ETH_P_PPP_DISC
	EthPPppSes    = 34916 // ETH_P_PPP_SES
	EthPMplsUc    = 34887 // ETH_P_MPLS_UC
	EthPMplsMc    = 34888 // ETH_P_MPLS_MC
	EthPAtmmpoa   = 34892 // ETH_P_ATMMPOA
	EthPAtmfate   = 34948 // ETH_P_ATMFATE
	EthPPae       = 34958 // ETH_P_PAE
	EthPAoe       = 34978 // ETH_P_AOE
	EthPTipc      = 35018 // ETH_P_TIPC
	EthP1588      = 35063 // ETH_P_1588
	EthPFcoe      = 35078 // ETH_P_FCOE
	EthPFip       = 35092 // ETH_P_FIP
	EthPEdsa      = 56026 // ETH_P_EDSA
)

type EthernetType uint16

func (self EthernetType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self EthernetType) String() string {
	switch self {
	case EthPLoop:
		return "loop"
	case EthPPup:
		return "pup"
	case EthPPupat:
		return "pupat"
	case EthPIp:
		return "ip"
	case EthPX25:
		return "x25"
	case EthPARP:
		return "arp"
	case EthPBpq:
		return "bpq"
	case EthPIeeepup:
		return "ieeepup"
	case EthPIeeepupat:
		return "ieeepupat"
	case EthPDec:
		return "dec"
	case EthPDnaDl:
		return "dna_dl"
	case EthPDnaRc:
		return "dna_rc"
	case EthPDnaRt:
		return "dna_rt"
	case EthPLat:
		return "lat"
	case EthPDiag:
		return "diag"
	case EthPCust:
		return "cust"
	case EthPSca:
		return "sca"
	case EthPTeb:
		return "teb"
	case EthPRarp:
		return "rarp"
	case EthPAtalk:
		return "atalk"
	case EthPAarp:
		return "aarp"
	case EthP8021Q:
		return "8021q"
	case EthPIpx:
		return "ipx"
	case EthPIpv6:
		return "ipv6"
	case EthPPause:
		return "pause"
	case EthPSlow:
		return "slow"
	case EthPWccp:
		return "wccp"
	case EthPPppDisc:
		return "ppp_disc"
	case EthPPppSes:
		return "ppp_ses"
	case EthPMplsUc:
		return "mpls_uc"
	case EthPMplsMc:
		return "mpls_mc"
	case EthPAtmmpoa:
		return "atmmpoa"
	case EthPAtmfate:
		return "atmfate"
	case EthPPae:
		return "pae"
	case EthPAoe:
		return "aoe"
	case EthPTipc:
		return "tipc"
	case EthP1588:
		return "1588"
	case EthPFcoe:
		return "fcoe"
	case EthPFip:
		return "fip"
	case EthPEdsa:
		return "edsa"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group ofp_flow_mod_command
	OFPFCAdd          = 0 // OFPFC_ADD
	OFPFCModify       = 1 // OFPFC_MODIFY
	OFPFCModifyStrict = 2 // OFPFC_MODIFY_STRICT
	OFPFCDelete       = 3 // OFPFC_DELETE
	OFPFCDeleteStrict = 4 // OFPFC_DELETE_STRICT
)

type FlowModCommand uint8

func (self FlowModCommand) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_flow_mod_failed_code
	OFPFMFCUnknown    = 0 // OFPFMFC_UNKNOWN
	OFPFMFCTableFull  = 1 // OFPFMFC_TABLE_FULL
	OFPFMFCBadTableID = 2 // OFPFMFC_BAD_TABLE_ID
	OFPFMFCOverlap    = 3 // OFPFMFC_OVERLAP
	OFPFMFCEperm      = 4 // OFPFMFC_EPERM
	OFPFMFCBadTimeout = 5 // OFPFMFC_BAD_TIMEOUT
	OFPFMFCBadCommand = 6 // OFPFMFC_BAD_COMMAND
	OFPFMFCBadFlags   = 7 // OFPFMFC_BAD_FLAGS
)

type FlowModFailedCode uint16

func (self FlowModFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_flow_mod_flags
	OFPFFSendFlowRem  = 1   // OFPFF_SEND_FLOW_REM
	OFPFFCheckOverlap = 2   // OFPFF_CHECK_OVERLAP
	OFPFFResetCounts  = 4   // OFPFF_RESET_COUNTS
	OFPFFNoPktCounts  = 8   // OFPFF_NO_PKT_COUNTS
	OFPFFNoBytCounts  = 16  // OFPFF_NO_BYT_COUNTS
	OFPFFBSNSendIdle  = 128 // OFPFF_BSN_SEND_IDLE
)

type FlowModFlags uint16

func (self FlowModFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPFFSendFlowRem == OFPFFSendFlowRem {
		flags = append(flags, "\"SendFlowRem\": true")
	}
	if self&OFPFFCheckOverlap == OFPFFCheckOverlap {
		flags = append(flags, "\"CheckOverlap\": true")
	}
	if self&OFPFFResetCounts == OFPFFResetCounts {
		flags = append(flags, "\"ResetCounts\": true")
	}
	if self&OFPFFNoPktCounts == OFPFFNoPktCounts {
		flags = append(flags, "\"NoPktCounts\": true")
	}
	if self&OFPFFNoBytCounts == OFPFFNoBytCounts {
		flags = append(flags, "\"NoBytCounts\": true")
	}
	if self&OFPFFBSNSendIdle == OFPFFBSNSendIdle {
		flags = append(flags, "\"BsnSendIdle\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_flow_removed_reason
	OFPRRIdleTimeout = 0 // OFPRR_IDLE_TIMEOUT
	OFPRRHardTimeout = 1 // OFPRR_HARD_TIMEOUT
	OFPRRDelete      = 2 // OFPRR_DELETE
	OFPRRGroupDelete = 3 // OFPRR_GROUP_DELETE
)

type FlowRemovedReason uint8

func (self FlowRemovedReason) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_group
	OFPGMax = 4294967040 // OFPG_MAX
	OFPGAll = 4294967292 // OFPG_ALL
	OFPGAny = 4294967295 // OFPG_ANY
)

type Group uint32

func (self Group) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_group_capabilities
	OFPGFCSelectWeight   = 1 // OFPGFC_SELECT_WEIGHT
	OFPGFCSelectLiveness = 2 // OFPGFC_SELECT_LIVENESS
	OFPGFCChaining       = 4 // OFPGFC_CHAINING
	OFPGFCChainingChecks = 8 // OFPGFC_CHAINING_CHECKS
)

type GroupCapabilities uint32

func (self GroupCapabilities) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPGFCSelectWeight == OFPGFCSelectWeight {
		flags = append(flags, "\"SelectWeight\": true")
	}
	if self&OFPGFCSelectLiveness == OFPGFCSelectLiveness {
		flags = append(flags, "\"SelectLiveness\": true")
	}
	if self&OFPGFCChaining == OFPGFCChaining {
		flags = append(flags, "\"Chaining\": true")
	}
	if self&OFPGFCChainingChecks == OFPGFCChainingChecks {
		flags = append(flags, "\"ChainingChecks\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_group_mod_command
	OFPGCAdd    = 0 // OFPGC_ADD
	OFPGCModify = 1 // OFPGC_MODIFY
	OFPGCDelete = 2 // OFPGC_DELETE
)

type GroupModCommand uint16

func (self GroupModCommand) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_group_mod_failed_code
	OFPGMFCGroupExists         = 0  // OFPGMFC_GROUP_EXISTS
	OFPGMFCInvalidGroup        = 1  // OFPGMFC_INVALID_GROUP
	OFPGMFCWeightUnsupported   = 2  // OFPGMFC_WEIGHT_UNSUPPORTED
	OFPGMFCOutOfGroups         = 3  // OFPGMFC_OUT_OF_GROUPS
	OFPGMFCOutOfBuckets        = 4  // OFPGMFC_OUT_OF_BUCKETS
	OFPGMFCChainingUnsupported = 5  // OFPGMFC_CHAINING_UNSUPPORTED
	OFPGMFCWatchUnsupported    = 6  // OFPGMFC_WATCH_UNSUPPORTED
	OFPGMFCLoop                = 7  // OFPGMFC_LOOP
	OFPGMFCUnknownGroup        = 8  // OFPGMFC_UNKNOWN_GROUP
	OFPGMFCChainedGroup        = 9  // OFPGMFC_CHAINED_GROUP
	OFPGMFCBadType             = 10 // OFPGMFC_BAD_TYPE
	OFPGMFCBadCommand          = 11 // OFPGMFC_BAD_COMMAND
	OFPGMFCBadBucket           = 12 // OFPGMFC_BAD_BUCKET
	OFPGMFCBadWatch            = 13 // OFPGMFC_BAD_WATCH
	OFPGMFCEperm               = 14 // OFPGMFC_EPERM
)

type GroupModFailedCode uint16

func (self GroupModFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_group_type
	OFPGTAll      = 0 // OFPGT_ALL
	OFPGTSelect   = 1 // OFPGT_SELECT
	OFPGTIndirect = 2 // OFPGT_INDIRECT
	OFPGTFf       = 3 // OFPGT_FF
)

type GroupType uint8

func (self GroupType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self GroupType) String() string {
	switch self {
	case OFPGTAll:
		return "all"
	case OFPGTSelect:
		return "select"
	case OFPGTIndirect:
		return "indirect"
	case OFPGTFf:
		return "ff"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group ofp_hello_elem_type
	OFPHETVersionbitmap = 1 // OFPHET_VERSIONBITMAP
)

type HelloElemType uint16

func (self HelloElemType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_hello_failed_code
	OFPHFCIncompatible = 0 // OFPHFC_INCOMPATIBLE
	OFPHFCEperm        = 1 // OFPHFC_EPERM
)

type HelloFailedCode uint16

func (self HelloFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_icmp_type
	IcmpEchoreply      = 0  // ICMP_ECHOREPLY
	IcmpDestUnreach    = 3  // ICMP_DEST_UNREACH
	IcmpSourceQuench   = 4  // ICMP_SOURCE_QUENCH
	IcmpRedirect       = 5  // ICMP_REDIRECT
	IcmpEcho           = 8  // ICMP_ECHO
	IcmpTimeExceeded   = 11 // ICMP_TIME_EXCEEDED
	IcmpParameterprob  = 12 // ICMP_PARAMETERPROB
	IcmpTimestamp      = 13 // ICMP_TIMESTAMP
	IcmpTimestampreply = 14 // ICMP_TIMESTAMPREPLY
	IcmpInfoRequest    = 15 // ICMP_INFO_REQUEST
	IcmpInfoReply      = 16 // ICMP_INFO_REPLY
	IcmpAddress        = 17 // ICMP_ADDRESS
	IcmpAddressreply   = 18 // ICMP_ADDRESSREPLY
)

type IcmpType uint8

func (self IcmpType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self IcmpType) String() string {
	switch self {
	case IcmpEchoreply:
		return "echoreply"
	case IcmpDestUnreach:
		return "dest_unreach"
	case IcmpSourceQuench:
		return "source_quench"
	case IcmpRedirect:
		return "redirect"
	case IcmpEcho:
		return "echo"
	case IcmpTimeExceeded:
		return "time_exceeded"
	case IcmpParameterprob:
		return "parameterprob"
	case IcmpTimestamp:
		return "timestamp"
	case IcmpTimestampreply:
		return "timestampreply"
	case IcmpInfoRequest:
		return "info_request"
	case IcmpInfoReply:
		return "info_reply"
	case IcmpAddress:
		return "address"
	case IcmpAddressreply:
		return "addressreply"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group ofp_icmpv6_type
	Icmpv6EchoRequest     = 128 // ICMPV6_ECHO_REQUEST
	Icmpv6EchoReply       = 129 // ICMPV6_ECHO_REPLY
	Icmpv6MgmQuery        = 130 // ICMPV6_MGM_QUERY
	Icmpv6MgmReport       = 131 // ICMPV6_MGM_REPORT
	Icmpv6MgmReduction    = 132 // ICMPV6_MGM_REDUCTION
	Icmpv6NiQuery         = 139 // ICMPV6_NI_QUERY
	Icmpv6NiReply         = 140 // ICMPV6_NI_REPLY
	Icmpv6Mld2Report      = 143 // ICMPV6_MLD2_REPORT
	Icmpv6DhaadRequest    = 144 // ICMPV6_DHAAD_REQUEST
	Icmpv6DhaadReply      = 145 // ICMPV6_DHAAD_REPLY
	Icmpv6MobilePrefixSol = 146 // ICMPV6_MOBILE_PREFIX_SOL
	Icmpv6MobilePrefixAdv = 147 // ICMPV6_MOBILE_PREFIX_ADV
)

type Icmpv6Type uint8

func (self Icmpv6Type) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self Icmpv6Type) String() string {
	switch self {
	case Icmpv6EchoRequest:
		return "echo_request"
	case Icmpv6EchoReply:
		return "echo_reply"
	case Icmpv6MgmQuery:
		return "mgm_query"
	case Icmpv6MgmReport:
		return "mgm_report"
	case Icmpv6MgmReduction:
		return "mgm_reduction"
	case Icmpv6NiQuery:
		return "ni_query"
	case Icmpv6NiReply:
		return "ni_reply"
	case Icmpv6Mld2Report:
		return "mld2_report"
	case Icmpv6DhaadRequest:
		return "dhaad_request"
	case Icmpv6DhaadReply:
		return "dhaad_reply"
	case Icmpv6MobilePrefixSol:
		return "mobile_prefix_sol"
	case Icmpv6MobilePrefixAdv:
		return "mobile_prefix_adv"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group ofp_instruction_type
	OFPITGotoTable     = 1     // OFPIT_GOTO_TABLE
	OFPITWriteMetadata = 2     // OFPIT_WRITE_METADATA
	OFPITWriteActions  = 3     // OFPIT_WRITE_ACTIONS
	OFPITApplyActions  = 4     // OFPIT_APPLY_ACTIONS
	OFPITClearActions  = 5     // OFPIT_CLEAR_ACTIONS
	OFPITMeter         = 6     // OFPIT_METER
	OFPITExperimenter  = 65535 // OFPIT_EXPERIMENTER
)

type InstructionType uint16

func (self InstructionType) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPITGotoTable == OFPITGotoTable {
		flags = append(flags, "\"GotoTable\": true")
	}
	if self&OFPITWriteMetadata == OFPITWriteMetadata {
		flags = append(flags, "\"WriteMetadata\": true")
	}
	if self&OFPITWriteActions == OFPITWriteActions {
		flags = append(flags, "\"WriteActions\": true")
	}
	if self&OFPITApplyActions == OFPITApplyActions {
		flags = append(flags, "\"ApplyActions\": true")
	}
	if self&OFPITClearActions == OFPITClearActions {
		flags = append(flags, "\"ClearActions\": true")
	}
	if self&OFPITMeter == OFPITMeter {
		flags = append(flags, "\"Meter\": true")
	}
	if self&OFPITExperimenter == OFPITExperimenter {
		flags = append(flags, "\"Experimenter\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_ip_prototype
	IpprotoIp       = 0   // IPPROTO_IP
	IpprotoICMP     = 1   // IPPROTO_ICMP
	IpprotoIgmp     = 2   // IPPROTO_IGMP
	IpprotoIpip     = 4   // IPPROTO_IPIP
	IpprotoTCP      = 6   // IPPROTO_TCP
	IpprotoEgp      = 8   // IPPROTO_EGP
	IpprotoPup      = 12  // IPPROTO_PUP
	IpprotoUdp      = 17  // IPPROTO_UDP
	IpprotoIdp      = 22  // IPPROTO_IDP
	IpprotoTp       = 29  // IPPROTO_TP
	IpprotoDccp     = 33  // IPPROTO_DCCP
	IpprotoIpv6     = 41  // IPPROTO_IPV6
	IpprotoRsvp     = 46  // IPPROTO_RSVP
	IpprotoGRE      = 47  // IPPROTO_GRE
	IpprotoEsp      = 50  // IPPROTO_ESP
	IpprotoAh       = 51  // IPPROTO_AH
	IpprotoMtp      = 92  // IPPROTO_MTP
	IpprotoBeetph   = 94  // IPPROTO_BEETPH
	IpprotoEncap    = 98  // IPPROTO_ENCAP
	IpprotoPim      = 103 // IPPROTO_PIM
	IpprotoComp     = 108 // IPPROTO_COMP
	IpprotoSctp     = 132 // IPPROTO_SCTP
	IpprotoUdplite  = 136 // IPPROTO_UDPLITE
	IpprotoMpls     = 137 // IPPROTO_MPLS
	IpprotoRaw      = 255 // IPPROTO_RAW
	IpprotoRouting  = 43  // IPPROTO_ROUTING
	IpprotoFragment = 44  // IPPROTO_FRAGMENT
	IpprotoIcmpv6   = 58  // IPPROTO_ICMPV6
	IpprotoNone     = 59  // IPPROTO_NONE
	IpprotoDstopts  = 60  // IPPROTO_DSTOPTS
	IpprotoMh       = 135 // IPPROTO_MH
	IpprotoL2Tp     = 115 // IPPROTO_L2TP
)

type IpPrototype uint8

func (self IpPrototype) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self IpPrototype) String() string {
	switch self {
	case IpprotoIp:
		return "ip"
	case IpprotoICMP:
		return "icmp"
	case IpprotoIgmp:
		return "igmp"
	case IpprotoIpip:
		return "ipip"
	case IpprotoTCP:
		return "tcp"
	case IpprotoEgp:
		return "egp"
	case IpprotoPup:
		return "pup"
	case IpprotoUdp:
		return "udp"
	case IpprotoIdp:
		return "idp"
	case IpprotoTp:
		return "tp"
	case IpprotoDccp:
		return "dccp"
	case IpprotoIpv6:
		return "ipv6"
	case IpprotoRsvp:
		return "rsvp"
	case IpprotoGRE:
		return "gre"
	case IpprotoEsp:
		return "esp"
	case IpprotoAh:
		return "ah"
	case IpprotoMtp:
		return "mtp"
	case IpprotoBeetph:
		return "beetph"
	case IpprotoEncap:
		return "encap"
	case IpprotoPim:
		return "pim"
	case IpprotoComp:
		return "comp"
	case IpprotoSctp:
		return "sctp"
	case IpprotoUdplite:
		return "udplite"
	case IpprotoMpls:
		return "mpls"
	case IpprotoRaw:
		return "raw"
	case IpprotoRouting:
		return "routing"
	case IpprotoFragment:
		return "fragment"
	case IpprotoIcmpv6:
		return "icmpv6"
	case IpprotoNone:
		return "none"
	case IpprotoDstopts:
		return "dstopts"
	case IpprotoMh:
		return "mh"
	case IpprotoL2Tp:
		return "l2tp"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group ofp_ipv6exthdr_flags
	OFPIEHNonext = 1   // OFPIEH_NONEXT
	OFPIEHEsp    = 2   // OFPIEH_ESP
	OFPIEHAuth   = 4   // OFPIEH_AUTH
	OFPIEHDest   = 8   // OFPIEH_DEST
	OFPIEHFrag   = 16  // OFPIEH_FRAG
	OFPIEHRouter = 32  // OFPIEH_ROUTER
	OFPIEHHop    = 64  // OFPIEH_HOP
	OFPIEHUnrep  = 128 // OFPIEH_UNREP
	OFPIEHUnseq  = 256 // OFPIEH_UNSEQ
)

type Ipv6ExthdrFlags uint16

func (self Ipv6ExthdrFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPIEHNonext == OFPIEHNonext {
		flags = append(flags, "\"Nonext\": true")
	}
	if self&OFPIEHEsp == OFPIEHEsp {
		flags = append(flags, "\"Esp\": true")
	}
	if self&OFPIEHAuth == OFPIEHAuth {
		flags = append(flags, "\"Auth\": true")
	}
	if self&OFPIEHDest == OFPIEHDest {
		flags = append(flags, "\"Dest\": true")
	}
	if self&OFPIEHFrag == OFPIEHFrag {
		flags = append(flags, "\"Frag\": true")
	}
	if self&OFPIEHRouter == OFPIEHRouter {
		flags = append(flags, "\"Router\": true")
	}
	if self&OFPIEHHop == OFPIEHHop {
		flags = append(flags, "\"Hop\": true")
	}
	if self&OFPIEHUnrep == OFPIEHUnrep {
		flags = append(flags, "\"Unrep\": true")
	}
	if self&OFPIEHUnseq == OFPIEHUnseq {
		flags = append(flags, "\"Unseq\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_match_type
	OFPMTStandard = 0 // OFPMT_STANDARD
	OFPMTOXM      = 1 // OFPMT_OXM
)

type MatchType uint16

func (self MatchType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_meter
	OFPMMax        = 4294901760 // OFPM_MAX
	OFPMSlowpath   = 4294967293 // OFPM_SLOWPATH
	OFPMController = 4294967294 // OFPM_CONTROLLER
	OFPMAll        = 4294967295 // OFPM_ALL
)

type Meter uint32

func (self Meter) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_meter_band_type
	OFPMBTDrop         = 1     // OFPMBT_DROP
	OFPMBTDSCPRemark   = 2     // OFPMBT_DSCP_REMARK
	OFPMBTExperimenter = 65535 // OFPMBT_EXPERIMENTER
)

type MeterBandType uint16

func (self MeterBandType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_meter_flags
	OFPMFKbps  = 1 // OFPMF_KBPS
	OFPMFPktps = 2 // OFPMF_PKTPS
	OFPMFBurst = 4 // OFPMF_BURST
	OFPMFStats = 8 // OFPMF_STATS
)

type MeterFlags uint16

func (self MeterFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPMFKbps == OFPMFKbps {
		flags = append(flags, "\"Kbps\": true")
	}
	if self&OFPMFPktps == OFPMFPktps {
		flags = append(flags, "\"Pktps\": true")
	}
	if self&OFPMFBurst == OFPMFBurst {
		flags = append(flags, "\"Burst\": true")
	}
	if self&OFPMFStats == OFPMFStats {
		flags = append(flags, "\"Stats\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_meter_mod_command
	OFPMCAdd    = 0 // OFPMC_ADD
	OFPMCModify = 1 // OFPMC_MODIFY
	OFPMCDelete = 2 // OFPMC_DELETE
)

type MeterModCommand uint16

func (self MeterModCommand) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_meter_mod_failed_code
	OFPMMFCUnknown      = 0  // OFPMMFC_UNKNOWN
	OFPMMFCMeterExists  = 1  // OFPMMFC_METER_EXISTS
	OFPMMFCInvalidMeter = 2  // OFPMMFC_INVALID_METER
	OFPMMFCUnknownMeter = 3  // OFPMMFC_UNKNOWN_METER
	OFPMMFCBadCommand   = 4  // OFPMMFC_BAD_COMMAND
	OFPMMFCBadFlags     = 5  // OFPMMFC_BAD_FLAGS
	OFPMMFCBadRate      = 6  // OFPMMFC_BAD_RATE
	OFPMMFCBadBurst     = 7  // OFPMMFC_BAD_BURST
	OFPMMFCBadBand      = 8  // OFPMMFC_BAD_BAND
	OFPMMFCBadBandValue = 9  // OFPMMFC_BAD_BAND_VALUE
	OFPMMFCOutOfMeters  = 10 // OFPMMFC_OUT_OF_METERS
	OFPMMFCOutOfBands   = 11 // OFPMMFC_OUT_OF_BANDS
)

type MeterModFailedCode uint16

func (self MeterModFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_ovs_tcp_flag
	OvsTCPFlagFin = 1   // OFP_OVS_TCP_FLAG_FIN
	OvsTCPFlagSyn = 2   // OFP_OVS_TCP_FLAG_SYN
	OvsTCPFlagRst = 4   // OFP_OVS_TCP_FLAG_RST
	OvsTCPFlagPsh = 8   // OFP_OVS_TCP_FLAG_PSH
	OvsTCPFlagAck = 16  // OFP_OVS_TCP_FLAG_ACK
	OvsTCPFlagUrg = 32  // OFP_OVS_TCP_FLAG_URG
	OvsTCPFlagEce = 64  // OFP_OVS_TCP_FLAG_ECE
	OvsTCPFlagCwr = 128 // OFP_OVS_TCP_FLAG_CWR
	OvsTCPFlagNs  = 256 // OFP_OVS_TCP_FLAG_NS
)

type OvsTcpFlag uint16

func (self OvsTcpFlag) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OvsTCPFlagFin == OvsTCPFlagFin {
		flags = append(flags, "\"Fin\": true")
	}
	if self&OvsTCPFlagSyn == OvsTCPFlagSyn {
		flags = append(flags, "\"Syn\": true")
	}
	if self&OvsTCPFlagRst == OvsTCPFlagRst {
		flags = append(flags, "\"Rst\": true")
	}
	if self&OvsTCPFlagPsh == OvsTCPFlagPsh {
		flags = append(flags, "\"Psh\": true")
	}
	if self&OvsTCPFlagAck == OvsTCPFlagAck {
		flags = append(flags, "\"Ack\": true")
	}
	if self&OvsTCPFlagUrg == OvsTCPFlagUrg {
		flags = append(flags, "\"Urg\": true")
	}
	if self&OvsTCPFlagEce == OvsTCPFlagEce {
		flags = append(flags, "\"Ece\": true")
	}
	if self&OvsTCPFlagCwr == OvsTCPFlagCwr {
		flags = append(flags, "\"Cwr\": true")
	}
	if self&OvsTCPFlagNs == OvsTCPFlagNs {
		flags = append(flags, "\"Ns\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_oxm_class
	OFPXMCNxm0          = 0     // OFPXMC_NXM_0
	OFPXMCNxm1          = 1     // OFPXMC_NXM_1
	OFPXMCOpenflowBasic = 32768 // OFPXMC_OPENFLOW_BASIC
	OFPXMCExperimenter  = 65535 // OFPXMC_EXPERIMENTER
)

type OxmClass uint16

func (self OxmClass) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_packet_in_reason
	OFPRNoMatch                     = 0   // OFPR_NO_MATCH
	OFPRAction                      = 1   // OFPR_ACTION
	OFPRInvalidTtl                  = 2   // OFPR_INVALID_TTL
	OFPRBSNNewHost                  = 128 // OFPR_BSN_NEW_HOST
	OFPRBSNStationMove              = 129 // OFPR_BSN_STATION_MOVE
	OFPRBSNBadVLAN                  = 130 // OFPR_BSN_BAD_VLAN
	OFPRBSNDestinationLookupFailure = 131 // OFPR_BSN_DESTINATION_LOOKUP_FAILURE
	OFPRBSNNoRoute                  = 132 // OFPR_BSN_NO_ROUTE
	OFPRBSNICMPEchoRequest          = 133 // OFPR_BSN_ICMP_ECHO_REQUEST
	OFPRBSNDestNetworkUnreachable   = 134 // OFPR_BSN_DEST_NETWORK_UNREACHABLE
	OFPRBSNDestHostUnreachable      = 135 // OFPR_BSN_DEST_HOST_UNREACHABLE
	OFPRBSNDestPortUnreachable      = 136 // OFPR_BSN_DEST_PORT_UNREACHABLE
	OFPRBSNFragmentationRequired    = 137 // OFPR_BSN_FRAGMENTATION_REQUIRED
	OFPRBSNARP                      = 139 // OFPR_BSN_ARP
	OFPRBSNDhcp                     = 140 // OFPR_BSN_DHCP
	OFPRBSNDebug                    = 141 // OFPR_BSN_DEBUG
	OFPRBSNPacketOfDeath            = 142 // OFPR_BSN_PACKET_OF_DEATH
)

type PacketInReason uint8

func (self PacketInReason) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_packet_type
	PtEthernet     = 0          // OFP_PT_ETHERNET
	PtUseNextProto = 65534      // OFP_PT_USE_NEXT_PROTO
	PtIpv4         = 67584      // OFP_PT_IPV4
	PtMpls         = 100423     // OFP_PT_MPLS
	PtMplsMc       = 100424     // OFP_PT_MPLS_MC
	PtNsh          = 100687     // OFP_PT_NSH
	PtUnknown      = 4294967295 // OFP_PT_UNKNOWN
)

type PacketType uint32

func (self PacketType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self PacketType) String() string {
	switch self {
	case PtEthernet:
		return "ethernet"
	case PtUseNextProto:
		return "use_next_proto"
	case PtIpv4:
		return "ipv4"
	case PtMpls:
		return "mpls"
	case PtMplsMc:
		return "mpls_mc"
	case PtNsh:
		return "nsh"
	case PtUnknown:
		return "unknown"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group ofp_port
	OFPPMax        = 4294967040 // OFPP_MAX
	OFPPInPort     = 4294967288 // OFPP_IN_PORT
	OFPPTable      = 4294967289 // OFPP_TABLE
	OFPPNormal     = 4294967290 // OFPP_NORMAL
	OFPPFlood      = 4294967291 // OFPP_FLOOD
	OFPPAll        = 4294967292 // OFPP_ALL
	OFPPController = 4294967293 // OFPP_CONTROLLER
	OFPPLocal      = 4294967294 // OFPP_LOCAL
	OFPPAny        = 4294967295 // OFPP_ANY
)

type Port uint32

func (self Port) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_port_config
	OFPPCPortDown      = 1          // OFPPC_PORT_DOWN
	OFPPCNoRecv        = 4          // OFPPC_NO_RECV
	OFPPCNoFwd         = 32         // OFPPC_NO_FWD
	OFPPCNoPacketIn    = 64         // OFPPC_NO_PACKET_IN
	OFPPCBSNMirrorDest = 2147483648 // OFPPC_BSN_MIRROR_DEST
)

type PortConfig uint32

func (self PortConfig) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPPCPortDown == OFPPCPortDown {
		flags = append(flags, "\"PortDown\": true")
	}
	if self&OFPPCNoRecv == OFPPCNoRecv {
		flags = append(flags, "\"NoRecv\": true")
	}
	if self&OFPPCNoFwd == OFPPCNoFwd {
		flags = append(flags, "\"NoFwd\": true")
	}
	if self&OFPPCNoPacketIn == OFPPCNoPacketIn {
		flags = append(flags, "\"NoPacketIn\": true")
	}
	if self&OFPPCBSNMirrorDest == OFPPCBSNMirrorDest {
		flags = append(flags, "\"BsnMirrorDest\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_port_features
	OFPPF10MbHd             = 1          // OFPPF_10MB_HD
	OFPPF10MbFd             = 2          // OFPPF_10MB_FD
	OFPPF100MbHd            = 4          // OFPPF_100MB_HD
	OFPPF100MbFd            = 8          // OFPPF_100MB_FD
	OFPPF1GbHd              = 16         // OFPPF_1GB_HD
	OFPPF1GbFd              = 32         // OFPPF_1GB_FD
	OFPPF10GbFd             = 64         // OFPPF_10GB_FD
	OFPPF40GbFd             = 128        // OFPPF_40GB_FD
	OFPPF100GbFd            = 256        // OFPPF_100GB_FD
	OFPPF1TbFd              = 512        // OFPPF_1TB_FD
	OFPPFOther              = 1024       // OFPPF_OTHER
	OFPPFCopper             = 2048       // OFPPF_COPPER
	OFPPFFiber              = 4096       // OFPPF_FIBER
	OFPPFAutoneg            = 8192       // OFPPF_AUTONEG
	OFPPFPause              = 16384      // OFPPF_PAUSE
	OFPPFPauseAsym          = 32768      // OFPPF_PAUSE_ASYM
	OFPPFBSNBreakoutCapable = 2147483648 // OFPPF_BSN_BREAKOUT_CAPABLE
)

type PortFeatures uint32

func (self PortFeatures) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPPF10MbHd == OFPPF10MbHd {
		flags = append(flags, "\"10MbHd\": true")
	}
	if self&OFPPF10MbFd == OFPPF10MbFd {
		flags = append(flags, "\"10MbFd\": true")
	}
	if self&OFPPF100MbHd == OFPPF100MbHd {
		flags = append(flags, "\"100MbHd\": true")
	}
	if self&OFPPF100MbFd == OFPPF100MbFd {
		flags = append(flags, "\"100MbFd\": true")
	}
	if self&OFPPF1GbHd == OFPPF1GbHd {
		flags = append(flags, "\"1GbHd\": true")
	}
	if self&OFPPF1GbFd == OFPPF1GbFd {
		flags = append(flags, "\"1GbFd\": true")
	}
	if self&OFPPF10GbFd == OFPPF10GbFd {
		flags = append(flags, "\"10GbFd\": true")
	}
	if self&OFPPF40GbFd == OFPPF40GbFd {
		flags = append(flags, "\"40GbFd\": true")
	}
	if self&OFPPF100GbFd == OFPPF100GbFd {
		flags = append(flags, "\"100GbFd\": true")
	}
	if self&OFPPF1TbFd == OFPPF1TbFd {
		flags = append(flags, "\"1TbFd\": true")
	}
	if self&OFPPFOther == OFPPFOther {
		flags = append(flags, "\"Other\": true")
	}
	if self&OFPPFCopper == OFPPFCopper {
		flags = append(flags, "\"Copper\": true")
	}
	if self&OFPPFFiber == OFPPFFiber {
		flags = append(flags, "\"Fiber\": true")
	}
	if self&OFPPFAutoneg == OFPPFAutoneg {
		flags = append(flags, "\"Autoneg\": true")
	}
	if self&OFPPFPause == OFPPFPause {
		flags = append(flags, "\"Pause\": true")
	}
	if self&OFPPFPauseAsym == OFPPFPauseAsym {
		flags = append(flags, "\"PauseAsym\": true")
	}
	if self&OFPPFBSNBreakoutCapable == OFPPFBSNBreakoutCapable {
		flags = append(flags, "\"BsnBreakoutCapable\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_port_mod_failed_code
	OFPPMFCBadPort      = 0 // OFPPMFC_BAD_PORT
	OFPPMFCBadHwAddr    = 1 // OFPPMFC_BAD_HW_ADDR
	OFPPMFCBadConfig    = 2 // OFPPMFC_BAD_CONFIG
	OFPPMFCBadAdvertise = 3 // OFPPMFC_BAD_ADVERTISE
	OFPPMFCEperm        = 4 // OFPPMFC_EPERM
)

type PortModFailedCode uint16

func (self PortModFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_port_reason
	OFPPRAdd    = 0 // OFPPR_ADD
	OFPPRDelete = 1 // OFPPR_DELETE
	OFPPRModify = 2 // OFPPR_MODIFY
)

type PortReason uint8

func (self PortReason) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_port_state
	OFPPSLinkDown = 1 // OFPPS_LINK_DOWN
	OFPPSBlocked  = 2 // OFPPS_BLOCKED
	OFPPSLive     = 4 // OFPPS_LIVE
)

type PortState uint32

func (self PortState) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPPSLinkDown == OFPPSLinkDown {
		flags = append(flags, "\"LinkDown\": true")
	}
	if self&OFPPSBlocked == OFPPSBlocked {
		flags = append(flags, "\"Blocked\": true")
	}
	if self&OFPPSLive == OFPPSLive {
		flags = append(flags, "\"Live\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_queue_op_failed_code
	OFPQOFCBadPort  = 0 // OFPQOFC_BAD_PORT
	OFPQOFCBadQueue = 1 // OFPQOFC_BAD_QUEUE
	OFPQOFCEperm    = 2 // OFPQOFC_EPERM
)

type QueueOpFailedCode uint16

func (self QueueOpFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_queue_properties
	OFPQTMinRate      = 1     // OFPQT_MIN_RATE
	OFPQTMaxRate      = 2     // OFPQT_MAX_RATE
	OFPQTExperimenter = 65535 // OFPQT_EXPERIMENTER
)

type QueueProperties uint16

func (self QueueProperties) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_role_request_failed_code
	OFPRRFCStale   = 0 // OFPRRFC_STALE
	OFPRRFCUnsup   = 1 // OFPRRFC_UNSUP
	OFPRRFCBadRole = 2 // OFPRRFC_BAD_ROLE
)

type RoleRequestFailedCode uint16

func (self RoleRequestFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_stats_reply_flags
	OFPSFReplyMore = 1 // OFPSF_REPLY_MORE
)

type StatsReplyFlags uint16

func (self StatsReplyFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPSFReplyMore == OFPSFReplyMore {
		flags = append(flags, "\"OFPSFReplyMore\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_stats_request_flags
	OFPSFReqMore = 1 // OFPSF_REQ_MORE
)

type StatsRequestFlags uint16

func (self StatsRequestFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPSFReqMore == OFPSFReqMore {
		flags = append(flags, "\"OFPSFReqMore\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_stats_type
	OFPSTDesc          = 0     // OFPST_DESC
	OFPSTFlow          = 1     // OFPST_FLOW
	OFPSTAggregate     = 2     // OFPST_AGGREGATE
	OFPSTTable         = 3     // OFPST_TABLE
	OFPSTPort          = 4     // OFPST_PORT
	OFPSTQueue         = 5     // OFPST_QUEUE
	OFPSTGroup         = 6     // OFPST_GROUP
	OFPSTGroupDesc     = 7     // OFPST_GROUP_DESC
	OFPSTGroupFeatures = 8     // OFPST_GROUP_FEATURES
	OFPSTMeter         = 9     // OFPST_METER
	OFPSTMeterConfig   = 10    // OFPST_METER_CONFIG
	OFPSTMeterFeatures = 11    // OFPST_METER_FEATURES
	OFPSTTableFeatures = 12    // OFPST_TABLE_FEATURES
	OFPSTPortDesc      = 13    // OFPST_PORT_DESC
	OFPSTExperimenter  = 65535 // OFPST_EXPERIMENTER
)

type StatsType uint16

func (self StatsType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_switch_config_failed_code
	OFPSCFCBadFlags = 0 // OFPSCFC_BAD_FLAGS
	OFPSCFCBadLen   = 1 // OFPSCFC_BAD_LEN
	OFPSCFCEperm    = 2 // OFPSCFC_EPERM
)

type SwitchConfigFailedCode uint16

func (self SwitchConfigFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_table
	OFPTTMax = 254 // OFPTT_MAX
	OFPTTAll = 255 // OFPTT_ALL
)

type Table uint8

func (self Table) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_table_config
	OFPTCDeprecatedMask = 3 // OFPTC_DEPRECATED_MASK
)

type TableConfig uint32

func (self TableConfig) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&OFPTCDeprecatedMask == OFPTCDeprecatedMask {
		flags = append(flags, "\"OFPTCDeprecatedMask\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_table_feature_prop_type
	OFPTFPTInstructions      = 0     // OFPTFPT_INSTRUCTIONS
	OFPTFPTInstructionsMiss  = 1     // OFPTFPT_INSTRUCTIONS_MISS
	OFPTFPTNextTables        = 2     // OFPTFPT_NEXT_TABLES
	OFPTFPTNextTablesMiss    = 3     // OFPTFPT_NEXT_TABLES_MISS
	OFPTFPTWriteActions      = 4     // OFPTFPT_WRITE_ACTIONS
	OFPTFPTWriteActionsMiss  = 5     // OFPTFPT_WRITE_ACTIONS_MISS
	OFPTFPTApplyActions      = 6     // OFPTFPT_APPLY_ACTIONS
	OFPTFPTApplyActionsMiss  = 7     // OFPTFPT_APPLY_ACTIONS_MISS
	OFPTFPTMatch             = 8     // OFPTFPT_MATCH
	OFPTFPTWildcards         = 10    // OFPTFPT_WILDCARDS
	OFPTFPTWriteSetfield     = 12    // OFPTFPT_WRITE_SETFIELD
	OFPTFPTWriteSetfieldMiss = 13    // OFPTFPT_WRITE_SETFIELD_MISS
	OFPTFPTApplySetfield     = 14    // OFPTFPT_APPLY_SETFIELD
	OFPTFPTApplySetfieldMiss = 15    // OFPTFPT_APPLY_SETFIELD_MISS
	OFPTFPTExperimenter      = 65534 // OFPTFPT_EXPERIMENTER
	OFPTFPTExperimenterMiss  = 65535 // OFPTFPT_EXPERIMENTER_MISS
)

type TableFeaturePropType uint16

func (self TableFeaturePropType) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_table_features_failed_code
	OFPTFFCBadTable    = 0 // OFPTFFC_BAD_TABLE
	OFPTFFCBadMetadata = 1 // OFPTFFC_BAD_METADATA
	OFPTFFCBadType     = 2 // OFPTFFC_BAD_TYPE
	OFPTFFCBadLen      = 3 // OFPTFFC_BAD_LEN
	OFPTFFCBadArgument = 4 // OFPTFFC_BAD_ARGUMENT
	OFPTFFCEperm       = 5 // OFPTFFC_EPERM
)

type TableFeaturesFailedCode uint16

func (self TableFeaturesFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_table_mod_failed_code
	OFPTMFCBadTable  = 0 // OFPTMFC_BAD_TABLE
	OFPTMFCBadConfig = 1 // OFPTMFC_BAD_CONFIG
	OFPTMFCEperm     = 2 // OFPTMFC_EPERM
)

type TableModFailedCode uint16

func (self TableModFailedCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}

const (
	// Identifiers from group ofp_tcp_flags
	TcpFlagCwr = 128 // TCP_FLAG_CWR
	TcpFlagEce = 64  // TCP_FLAG_ECE
	TcpFlagUrg = 32  // TCP_FLAG_URG
	TcpFlagAck = 16  // TCP_FLAG_ACK
	TcpFlagPsh = 8   // TCP_FLAG_PSH
	TcpFlagRst = 4   // TCP_FLAG_RST
	TcpFlagSyn = 2   // TCP_FLAG_SYN
	TcpFlagFin = 1   // TCP_FLAG_FIN
)

type TcpFlags uint16

func (self TcpFlags) MarshalJSON() ([]byte, error) {
	var flags []string
	if self&TcpFlagCwr == TcpFlagCwr {
		flags = append(flags, "\"Cwr\": true")
	}
	if self&TcpFlagEce == TcpFlagEce {
		flags = append(flags, "\"Ece\": true")
	}
	if self&TcpFlagUrg == TcpFlagUrg {
		flags = append(flags, "\"Urg\": true")
	}
	if self&TcpFlagAck == TcpFlagAck {
		flags = append(flags, "\"Ack\": true")
	}
	if self&TcpFlagPsh == TcpFlagPsh {
		flags = append(flags, "\"Psh\": true")
	}
	if self&TcpFlagRst == TcpFlagRst {
		flags = append(flags, "\"Rst\": true")
	}
	if self&TcpFlagSyn == TcpFlagSyn {
		flags = append(flags, "\"Syn\": true")
	}
	if self&TcpFlagFin == TcpFlagFin {
		flags = append(flags, "\"Fin\": true")
	}
	return []byte("{" + strings.Join(flags, ", ") + "}"), nil
}

const (
	// Identifiers from group ofp_type
	OFPTHello                 = 0  // OFPT_HELLO
	OFPTError                 = 1  // OFPT_ERROR
	OFPTEchoRequest           = 2  // OFPT_ECHO_REQUEST
	OFPTEchoReply             = 3  // OFPT_ECHO_REPLY
	OFPTExperimenter          = 4  // OFPT_EXPERIMENTER
	OFPTFeaturesRequest       = 5  // OFPT_FEATURES_REQUEST
	OFPTFeaturesReply         = 6  // OFPT_FEATURES_REPLY
	OFPTGetConfigRequest      = 7  // OFPT_GET_CONFIG_REQUEST
	OFPTGetConfigReply        = 8  // OFPT_GET_CONFIG_REPLY
	OFPTSetConfig             = 9  // OFPT_SET_CONFIG
	OFPTPacketIn              = 10 // OFPT_PACKET_IN
	OFPTFlowRemoved           = 11 // OFPT_FLOW_REMOVED
	OFPTPortStatus            = 12 // OFPT_PORT_STATUS
	OFPTPacketOut             = 13 // OFPT_PACKET_OUT
	OFPTFlowMod               = 14 // OFPT_FLOW_MOD
	OFPTGroupMod              = 15 // OFPT_GROUP_MOD
	OFPTPortMod               = 16 // OFPT_PORT_MOD
	OFPTTableMod              = 17 // OFPT_TABLE_MOD
	OFPTStatsRequest          = 18 // OFPT_STATS_REQUEST
	OFPTStatsReply            = 19 // OFPT_STATS_REPLY
	OFPTBarrierRequest        = 20 // OFPT_BARRIER_REQUEST
	OFPTBarrierReply          = 21 // OFPT_BARRIER_REPLY
	OFPTQueueGetConfigRequest = 22 // OFPT_QUEUE_GET_CONFIG_REQUEST
	OFPTQueueGetConfigReply   = 23 // OFPT_QUEUE_GET_CONFIG_REPLY
	OFPTRoleRequest           = 24 // OFPT_ROLE_REQUEST
	OFPTRoleReply             = 25 // OFPT_ROLE_REPLY
	OFPTGetAsyncRequest       = 26 // OFPT_GET_ASYNC_REQUEST
	OFPTGetAsyncReply         = 27 // OFPT_GET_ASYNC_REPLY
	OFPTSetAsync              = 28 // OFPT_SET_ASYNC
	OFPTMeterMod              = 29 // OFPT_METER_MOD
)

type Type uint8

func (self Type) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("\"%s\"", self)), nil
}

func (self Type) String() string {
	switch self {
	case OFPTHello:
		return "hello"
	case OFPTError:
		return "error"
	case OFPTEchoRequest:
		return "echo_request"
	case OFPTEchoReply:
		return "echo_reply"
	case OFPTExperimenter:
		return "experimenter"
	case OFPTFeaturesRequest:
		return "features_request"
	case OFPTFeaturesReply:
		return "features_reply"
	case OFPTGetConfigRequest:
		return "get_config_request"
	case OFPTGetConfigReply:
		return "get_config_reply"
	case OFPTSetConfig:
		return "set_config"
	case OFPTPacketIn:
		return "packet_in"
	case OFPTFlowRemoved:
		return "flow_removed"
	case OFPTPortStatus:
		return "port_status"
	case OFPTPacketOut:
		return "packet_out"
	case OFPTFlowMod:
		return "flow_mod"
	case OFPTGroupMod:
		return "group_mod"
	case OFPTPortMod:
		return "port_mod"
	case OFPTTableMod:
		return "table_mod"
	case OFPTStatsRequest:
		return "stats_request"
	case OFPTStatsReply:
		return "stats_reply"
	case OFPTBarrierRequest:
		return "barrier_request"
	case OFPTBarrierReply:
		return "barrier_reply"
	case OFPTQueueGetConfigRequest:
		return "queue_get_config_request"
	case OFPTQueueGetConfigReply:
		return "queue_get_config_reply"
	case OFPTRoleRequest:
		return "role_request"
	case OFPTRoleReply:
		return "role_reply"
	case OFPTGetAsyncRequest:
		return "get_async_request"
	case OFPTGetAsyncReply:
		return "get_async_reply"
	case OFPTSetAsync:
		return "set_async"
	case OFPTMeterMod:
		return "meter_mod"
	default:
		return fmt.Sprintf("%d", self)
	}
}

const (
	// Identifiers from group ofp_vlan_id
	OFPVIDNone    = 0    // OFPVID_NONE
	OFPVIDPresent = 4096 // OFPVID_PRESENT
)

type VlanId uint16

func (self VlanId) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%d", self)), nil
}
