/*
 * Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
 * Copyright (c) 2011, 2012 Open Networking Foundation
 * Copyright 2013, Big Switch Networks, Inc. This library was generated by the LoxiGen Compiler.
 * Copyright 2018, Red Hat, Inc.
 */
// Automatically generated by LOXI from template module.go
// Do not modify

package of13

import (
	"fmt"
	"net"

	"github.com/opencord/goloxi"
)

type Oxm struct {
	TypeLen uint32
}

type IOxm interface {
	goloxi.Serializable
	GetTypeLen() uint32
	GetOXMName() string
	GetOXMValue() interface{}
}

func (self *Oxm) GetTypeLen() uint32 {
	return self.TypeLen
}

func (self *Oxm) SetTypeLen(v uint32) {
	self.TypeLen = v
}

func (self *Oxm) Serialize(encoder *goloxi.Encoder) error {

	encoder.PutUint32(uint32(self.TypeLen))

	return nil
}

func DecodeOxm(decoder *goloxi.Decoder) (goloxi.IOxm, error) {
	_oxm := &Oxm{}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("Oxm packet too short: %d < 4", decoder.Length())
	}
	_oxm.TypeLen = uint32(decoder.ReadUint32())

	switch _oxm.TypeLen {
	case 110204:
		return DecodeNxmTunMetadata47(_oxm, decoder)
	case 129026:
		return DecodeOxmConnTrackingTpSrc(_oxm, decoder)
	case 65540:
		return DecodeNxmReg0(_oxm, decoder)
	case 77830:
		return DecodeNxmNdSll(_oxm, decoder)
	case 2147499009:
		return DecodeOxmIcmpv6Code(_oxm, decoder)
	case 73736:
		return DecodeNxmTunId(_oxm, decoder)
	case 2:
		return DecodeNxmInPort(_oxm, decoder)
	case 120848:
		return DecodeOxmConnTrackingLabel(_oxm, decoder)
	case 203780:
		return DecodeOxmBsnUdf6(_oxm, decoder)
	case 111228:
		return DecodeNxmTunMetadata49(_oxm, decoder)
	case 74758:
		return DecodeNxmArpTha(_oxm, decoder)
	case 2147503112:
		return DecodeOxmTunnelId(_oxm, decoder)
	case 112252:
		return DecodeNxmTunMetadata51(_oxm, decoder)
	case 108024:
		return DecodeNxmTunMetadata42Masked(_oxm, decoder)
	case 2147495176:
		return DecodeOxmArpSpaMasked(_oxm, decoder)
	case 113276:
		return DecodeNxmTunMetadata53(_oxm, decoder)
	case 109048:
		return DecodeNxmTunMetadata44Masked(_oxm, decoder)
	case 94332:
		return DecodeNxmTunMetadata16(_oxm, decoder)
	case 2147483652:
		return DecodeOxmInPort(_oxm, decoder)
	case 114300:
		return DecodeNxmTunMetadata55(_oxm, decoder)
	case 2050:
		return DecodeNxmVlanTci(_oxm, decoder)
	case 3073:
		return DecodeNxmNwProto(_oxm, decoder)
	case 110072:
		return DecodeNxmTunMetadata46Masked(_oxm, decoder)
	case 2147502338:
		return DecodeOxmMplsBosMasked(_oxm, decoder)
	case 66564:
		return DecodeNxmReg2(_oxm, decoder)
	case 115324:
		return DecodeNxmTunMetadata57(_oxm, decoder)
	case 2147486722:
		return DecodeOxmVlanVid(_oxm, decoder)
	case 2147487745:
		return DecodeOxmIpDscp(_oxm, decoder)
	case 111096:
		return DecodeNxmTunMetadata48Masked(_oxm, decoder)
	case 83204:
		return DecodeNxmTcpFlagsMasked(_oxm, decoder)
	case 3588:
		return DecodeNxmIpSrc(_oxm, decoder)
	case 198660:
		return DecodeOxmBsnL3InterfaceClassId(_oxm, decoder)
	case 2147488769:
		return DecodeOxmIpProto(_oxm, decoder)
	case 112120:
		return DecodeNxmTunMetadata50Masked(_oxm, decoder)
	case 121872:
		return DecodeNxmTunIpv6Dst(_oxm, decoder)
	case 199172:
		return DecodeOxmBsnL3SrcClassId(_oxm, decoder)
	case 1030:
		return DecodeNxmEthSrc(_oxm, decoder)
	case 68612:
		return DecodeNxmReg6(_oxm, decoder)
	case 117372:
		return DecodeNxmTunMetadata61(_oxm, decoder)
	case 5122:
		return DecodeNxmTcpDst(_oxm, decoder)
	case 113144:
		return DecodeNxmTunMetadata52Masked(_oxm, decoder)
	case 122896:
		return DecodeNxmXxreg1(_oxm, decoder)
	case 209156:
		return DecodeOxmBsnInnerVlanVidMasked(_oxm, decoder)
	case 124192:
		return DecodeNxmXxreg3Masked(_oxm, decoder)
	case 81672:
		return DecodeOxmTunnelIpv4SrcMasked(_oxm, decoder)
	case 2147485702:
		return DecodeOxmEthSrc(_oxm, decoder)
	case 4100:
		return DecodeNxmIpDst(_oxm, decoder)
	case 118396:
		return DecodeNxmTunMetadata63(_oxm, decoder)
	case 2147494146:
		return DecodeOxmIcmpv4CodeMasked(_oxm, decoder)
	case 129284:
		return DecodeOxmConnTrackingTpSrcMasked(_oxm, decoder)
	case 114168:
		return DecodeNxmTunMetadata54Masked(_oxm, decoder)
	case 123920:
		return DecodeNxmXxreg3(_oxm, decoder)
	case 200968:
		return DecodeOxmBsnUdf0Masked(_oxm, decoder)
	case 78091:
		return DecodeNxmNdSllMasked(_oxm, decoder)
	case 2147496204:
		return DecodeOxmArpShaMasked(_oxm, decoder)
	case 74000:
		return DecodeNxmTunIdMasked(_oxm, decoder)
	case 86140:
		return DecodeNxmTunMetadata0(_oxm, decoder)
	case 70660:
		return DecodeNxmReg10(_oxm, decoder)
	case 121120:
		return DecodeOxmConnTrackingLabelMasked(_oxm, decoder)
	case 107000:
		return DecodeNxmTunMetadata40Masked(_oxm, decoder)
	case 3848:
		return DecodeNxmIpSrcMasked(_oxm, decoder)
	case 87164:
		return DecodeNxmTunMetadata2(_oxm, decoder)
	case 202756:
		return DecodeOxmBsnUdf4(_oxm, decoder)
	case 204802:
		return DecodeOxmBsnTcpFlags(_oxm, decoder)
	case 205825:
		return DecodeOxmBsnL2CacheHit(_oxm, decoder)
	case 116216:
		return DecodeNxmTunMetadata58Masked(_oxm, decoder)
	case 199432:
		return DecodeOxmBsnL3SrcClassIdMasked(_oxm, decoder)
	case 88188:
		return DecodeNxmTunMetadata4(_oxm, decoder)
	case 72708:
		return DecodeNxmReg14(_oxm, decoder)
	case 2147492866:
		return DecodeOxmSctpDst(_oxm, decoder)
	case 2147493889:
		return DecodeOxmIcmpv4Code(_oxm, decoder)
	case 117240:
		return DecodeNxmTunMetadata60Masked(_oxm, decoder)
	case 200196:
		return DecodeOxmBsnEgrPortGroupId(_oxm, decoder)
	case 128288:
		return DecodeOxmConnTrackingIpv6SrcMasked(_oxm, decoder)
	case 89212:
		return DecodeNxmTunMetadata6(_oxm, decoder)
	case 2147500300:
		return DecodeOxmIpv6NdSllMasked(_oxm, decoder)
	case 8196:
		return DecodeNxmArpSpa(_oxm, decoder)
	case 76801:
		return DecodeNxmIcmpv6Code(_oxm, decoder)
	case 118264:
		return DecodeNxmTunMetadata62Masked(_oxm, decoder)
	case 70148:
		return DecodeNxmReg9(_oxm, decoder)
	case 119560:
		return DecodeOxmConnTrackingStateMasked(_oxm, decoder)
	case 90236:
		return DecodeNxmTunMetadata8(_oxm, decoder)
	case 119044:
		return DecodeNxmTunFlagsMasked(_oxm, decoder)
	case 82696:
		return DecodeNxmPktMarkMasked(_oxm, decoder)
	case 4294923528:
		return DecodeOxmOvsTcpFlagsMasked(_oxm, decoder)
	case 120584:
		return DecodeOxmConnTrackingMarkMasked(_oxm, decoder)
	case 91260:
		return DecodeNxmTunMetadata10(_oxm, decoder)
	case 87032:
		return DecodeNxmTunMetadata1Masked(_oxm, decoder)
	case 126722:
		return DecodeOxmConnTrackingNwProtoMasked(_oxm, decoder)
	case 206852:
		return DecodeOxmBsnIngressPortGroupId(_oxm, decoder)
	case 208898:
		return DecodeOxmBsnInnerVlanVid(_oxm, decoder)
	case 209921:
		return DecodeOxmBsnIpFragmentation(_oxm, decoder)
	case 196896:
		return DecodeOxmBsnInPorts128Masked(_oxm, decoder)
	case 92284:
		return DecodeNxmTunMetadata12(_oxm, decoder)
	case 88056:
		return DecodeNxmTunMetadata3Masked(_oxm, decoder)
	case 2147494916:
		return DecodeOxmArpSpa(_oxm, decoder)
	case 79873:
		return DecodeNxmNwEcn(_oxm, decoder)
	case 196624:
		return DecodeOxmBsnInPorts128(_oxm, decoder)
	case 200456:
		return DecodeOxmBsnEgrPortGroupIdMasked(_oxm, decoder)
	case 2147489284:
		return DecodeOxmIpv4Src(_oxm, decoder)
	case 93308:
		return DecodeNxmTunMetadata14(_oxm, decoder)
	case 115192:
		return DecodeNxmTunMetadata56Masked(_oxm, decoder)
	case 2561:
		return DecodeNxmNwTos(_oxm, decoder)
	case 129538:
		return DecodeOxmConnTrackingTpDst(_oxm, decoder)
	case 2147500550:
		return DecodeOxmIpv6NdTll(_oxm, decoder)
	case 84484:
		return DecodeNxmConjId(_oxm, decoder)
	case 74246:
		return DecodeNxmArpSha(_oxm, decoder)
	case 198402:
		return DecodeOxmBsnGlobalVrfAllowedMasked(_oxm, decoder)
	case 123408:
		return DecodeNxmXxreg2(_oxm, decoder)
	case 90104:
		return DecodeNxmTunMetadata7Masked(_oxm, decoder)
	case 2147486468:
		return DecodeOxmEthTypeMasked(_oxm, decoder)
	case 204552:
		return DecodeOxmBsnUdf7Masked(_oxm, decoder)
	case 91128:
		return DecodeNxmTunMetadata9Masked(_oxm, decoder)
	case 83720:
		return DecodeNxmDpHashMasked(_oxm, decoder)
	case 2147495942:
		return DecodeOxmArpSha(_oxm, decoder)
	case 2147497988:
		return DecodeOxmIpv6Flabel(_oxm, decoder)
	case 78603:
		return DecodeNxmNdTllMasked(_oxm, decoder)
	case 208652:
		return DecodeOxmBsnInnerEthSrcMasked(_oxm, decoder)
	case 2147503376:
		return DecodeOxmTunnelIdMasked(_oxm, decoder)
	case 96380:
		return DecodeNxmTunMetadata20(_oxm, decoder)
	case 92152:
		return DecodeNxmTunMetadata11Masked(_oxm, decoder)
	case 129796:
		return DecodeOxmConnTrackingTpDstMasked(_oxm, decoder)
	case 80897:
		return DecodeNxmMplsTtl(_oxm, decoder)
	case 2147489544:
		return DecodeOxmIpv4SrcMasked(_oxm, decoder)
	case 97404:
		return DecodeNxmTunMetadata22(_oxm, decoder)
	case 93176:
		return DecodeNxmTunMetadata13Masked(_oxm, decoder)
	case 94844:
		return DecodeNxmTunMetadata17(_oxm, decoder)
	case 81924:
		return DecodeOxmTunnelIpv4Dst(_oxm, decoder)
	case 127752:
		return DecodeOxmConnTrackingNwDstMasked(_oxm, decoder)
	case 98428:
		return DecodeNxmTunMetadata24(_oxm, decoder)
	case 94200:
		return DecodeNxmTunMetadata15Masked(_oxm, decoder)
	case 2147489026:
		return DecodeOxmIpProtoMasked(_oxm, decoder)
	case 2147501060:
		return DecodeOxmMplsLabel(_oxm, decoder)
	case 84994:
		return DecodeNxmTunGbpId(_oxm, decoder)
	case 99452:
		return DecodeNxmTunMetadata26(_oxm, decoder)
	case 95224:
		return DecodeNxmTunMetadata17Masked(_oxm, decoder)
	case 2147500038:
		return DecodeOxmIpv6NdSll(_oxm, decoder)
	case 83972:
		return DecodeNxmRecircId(_oxm, decoder)
	case 128800:
		return DecodeOxmConnTrackingIpv6DstMasked(_oxm, decoder)
	case 72196:
		return DecodeNxmReg13(_oxm, decoder)
	case 100476:
		return DecodeNxmTunMetadata28(_oxm, decoder)
	case 96248:
		return DecodeNxmTunMetadata19Masked(_oxm, decoder)
	case 2147488514:
		return DecodeOxmIpEcnMasked(_oxm, decoder)
	case 112764:
		return DecodeNxmTunMetadata52(_oxm, decoder)
	case 101500:
		return DecodeNxmTunMetadata30(_oxm, decoder)
	case 97272:
		return DecodeNxmTunMetadata21Masked(_oxm, decoder)
	case 2147483912:
		return DecodeOxmInPortMasked(_oxm, decoder)
	case 2147498754:
		return DecodeOxmIcmpv6TypeMasked(_oxm, decoder)
	case 209668:
		return DecodeOxmBsnVfiMasked(_oxm, decoder)
	case 70408:
		return DecodeNxmReg9Masked(_oxm, decoder)
	case 74507:
		return DecodeNxmArpShaMasked(_oxm, decoder)
	case 2147496716:
		return DecodeOxmArpThaMasked(_oxm, decoder)
	case 197384:
		return DecodeOxmBsnLagIdMasked(_oxm, decoder)
	case 76064:
		return DecodeNxmIpv6DstMasked(_oxm, decoder)
	case 102524:
		return DecodeNxmTunMetadata32(_oxm, decoder)
	case 98296:
		return DecodeNxmTunMetadata23Masked(_oxm, decoder)
	case 4868:
		return DecodeNxmTcpSrcMasked(_oxm, decoder)
	case 121632:
		return DecodeNxmTunIpv6SrcMasked(_oxm, decoder)
	case 75792:
		return DecodeNxmIpv6Dst(_oxm, decoder)
	case 202504:
		return DecodeOxmBsnUdf3Masked(_oxm, decoder)
	case 120324:
		return DecodeOxmConnTrackingMark(_oxm, decoder)
	case 99320:
		return DecodeNxmTunMetadata25Masked(_oxm, decoder)
	case 66824:
		return DecodeNxmReg2Masked(_oxm, decoder)
	case 72456:
		return DecodeNxmReg13Masked(_oxm, decoder)
	case 68360:
		return DecodeNxmReg5Masked(_oxm, decoder)
	case 104572:
		return DecodeNxmTunMetadata36(_oxm, decoder)
	case 95356:
		return DecodeNxmTunMetadata18(_oxm, decoder)
	case 100344:
		return DecodeNxmTunMetadata27Masked(_oxm, decoder)
	case 2147490564:
		return DecodeOxmTcpSrcMasked(_oxm, decoder)
	case 4294923270:
		return DecodeOxmOvsTcpFlags(_oxm, decoder)
	case 779:
		return DecodeNxmEthDstMasked(_oxm, decoder)
	case 69384:
		return DecodeNxmReg7Masked(_oxm, decoder)
	case 2147497248:
		return DecodeOxmIpv6SrcMasked(_oxm, decoder)
	case 105596:
		return DecodeNxmTunMetadata38(_oxm, decoder)
	case 101368:
		return DecodeNxmTunMetadata29Masked(_oxm, decoder)
	case 2147491588:
		return DecodeOxmUdpSrcMasked(_oxm, decoder)
	case 108668:
		return DecodeNxmTunMetadata44(_oxm, decoder)
	case 2147496976:
		return DecodeOxmIpv6Src(_oxm, decoder)
	case 201480:
		return DecodeOxmBsnUdf1Masked(_oxm, decoder)
	case 106620:
		return DecodeNxmTunMetadata40(_oxm, decoder)
	case 102392:
		return DecodeNxmTunMetadata31Masked(_oxm, decoder)
	case 2147492612:
		return DecodeOxmSctpSrcMasked(_oxm, decoder)
	case 204292:
		return DecodeOxmBsnUdf7(_oxm, decoder)
	case 71432:
		return DecodeNxmReg11Masked(_oxm, decoder)
	case 107644:
		return DecodeNxmTunMetadata42(_oxm, decoder)
	case 103416:
		return DecodeNxmTunMetadata33Masked(_oxm, decoder)
	case 2147498248:
		return DecodeOxmIpv6FlabelMasked(_oxm, decoder)
	case 203528:
		return DecodeOxmBsnUdf5Masked(_oxm, decoder)
	case 89592:
		return DecodeNxmTunMetadata6Masked(_oxm, decoder)
	case 104440:
		return DecodeNxmTunMetadata35Masked(_oxm, decoder)
	case 2147494660:
		return DecodeOxmArpOpMasked(_oxm, decoder)
	case 197636:
		return DecodeOxmBsnVrf(_oxm, decoder)
	case 73480:
		return DecodeNxmReg15Masked(_oxm, decoder)
	case 109692:
		return DecodeNxmTunMetadata46(_oxm, decoder)
	case 105464:
		return DecodeNxmTunMetadata37Masked(_oxm, decoder)
	case 89080:
		return DecodeNxmTunMetadata5Masked(_oxm, decoder)
	case 67588:
		return DecodeNxmReg4(_oxm, decoder)
	case 7169:
		return DecodeNxmIcmpCode(_oxm, decoder)
	case 82946:
		return DecodeNxmTcpFlags(_oxm, decoder)
	case 199684:
		return DecodeOxmBsnL3DstClassId(_oxm, decoder)
	case 207878:
		return DecodeOxmBsnInnerEthDst(_oxm, decoder)
	case 198145:
		return DecodeOxmBsnGlobalVrfAllowed(_oxm, decoder)
	case 2147484680:
		return DecodeOxmMetadata(_oxm, decoder)
	case 1538:
		return DecodeNxmEthType(_oxm, decoder)
	case 8968:
		return DecodeNxmArpTpaMasked(_oxm, decoder)
	case 128016:
		return DecodeOxmConnTrackingIpv6Src(_oxm, decoder)
	case 110716:
		return DecodeNxmTunMetadata48(_oxm, decoder)
	case 127492:
		return DecodeOxmConnTrackingNwDst(_oxm, decoder)
	case 2147502081:
		return DecodeOxmMplsBos(_oxm, decoder)
	case 78342:
		return DecodeNxmNdTll(_oxm, decoder)
	case 111740:
		return DecodeNxmTunMetadata50(_oxm, decoder)
	case 107512:
		return DecodeNxmTunMetadata41Masked(_oxm, decoder)
	case 207624:
		return DecodeOxmBsnVxlanNetworkIdMasked(_oxm, decoder)
	case 121360:
		return DecodeNxmTunIpv6Src(_oxm, decoder)
	case 2147495688:
		return DecodeOxmArpTpaMasked(_oxm, decoder)
	case 113788:
		return DecodeNxmTunMetadata54(_oxm, decoder)
	case 109560:
		return DecodeNxmTunMetadata45Masked(_oxm, decoder)
	case 2147501826:
		return DecodeOxmMplsTcMasked(_oxm, decoder)
	case 103548:
		return DecodeNxmTunMetadata34(_oxm, decoder)
	case 66052:
		return DecodeNxmReg1(_oxm, decoder)
	case 205316:
		return DecodeOxmBsnVlanXlatePortGroupId(_oxm, decoder)
	case 114812:
		return DecodeNxmTunMetadata56(_oxm, decoder)
	case 2147486210:
		return DecodeOxmEthType(_oxm, decoder)
	case 2147487233:
		return DecodeOxmVlanPcp(_oxm, decoder)
	case 110584:
		return DecodeNxmTunMetadata47Masked(_oxm, decoder)
	case 79624:
		return DecodeNxmIpv6LabelMasked(_oxm, decoder)
	case 115836:
		return DecodeNxmTunMetadata58(_oxm, decoder)
	case 2147488257:
		return DecodeOxmIpEcn(_oxm, decoder)
	case 111608:
		return DecodeNxmTunMetadata49Masked(_oxm, decoder)
	case 85762:
		return DecodeNxmTunGbpFlagsMasked(_oxm, decoder)
	case 518:
		return DecodeNxmEthDst(_oxm, decoder)
	case 68100:
		return DecodeNxmReg5(_oxm, decoder)
	case 116860:
		return DecodeNxmTunMetadata60(_oxm, decoder)
	case 4610:
		return DecodeNxmTcpSrc(_oxm, decoder)
	case 112632:
		return DecodeNxmTunMetadata51Masked(_oxm, decoder)
	case 122384:
		return DecodeNxmXxreg0(_oxm, decoder)
	case 123680:
		return DecodeNxmXxreg2Masked(_oxm, decoder)
	case 2147485190:
		return DecodeOxmEthDst(_oxm, decoder)
	case 69124:
		return DecodeNxmReg7(_oxm, decoder)
	case 117884:
		return DecodeNxmTunMetadata62(_oxm, decoder)
	case 5634:
		return DecodeNxmUdpSrc(_oxm, decoder)
	case 6657:
		return DecodeNxmIcmpType(_oxm, decoder)
	case 113656:
		return DecodeNxmTunMetadata53Masked(_oxm, decoder)
	case 2147503876:
		return DecodeOxmIpv6ExthdrMasked(_oxm, decoder)
	case 198920:
		return DecodeOxmBsnL3InterfaceClassIdMasked(_oxm, decoder)
	case 210178:
		return DecodeOxmBsnIpFragmentationMasked(_oxm, decoder)
	case 120068:
		return DecodeOxmConnTrackingZoneMasked(_oxm, decoder)
	case 1286:
		return DecodeNxmEthSrcMasked(_oxm, decoder)
	case 204040:
		return DecodeOxmBsnUdf6Masked(_oxm, decoder)
	case 75019:
		return DecodeNxmArpThaMasked(_oxm, decoder)
	case 208140:
		return DecodeOxmBsnInnerEthDstMasked(_oxm, decoder)
	case 201220:
		return DecodeOxmBsnUdf1(_oxm, decoder)
	case 205576:
		return DecodeOxmBsnVlanXlatePortGroupIdMasked(_oxm, decoder)
	case 2147484944:
		return DecodeOxmMetadataMasked(_oxm, decoder)
	case 6146:
		return DecodeNxmUdpDst(_oxm, decoder)
	case 2147490306:
		return DecodeOxmTcpSrc(_oxm, decoder)
	case 114680:
		return DecodeNxmTunMetadata55Masked(_oxm, decoder)
	case 122144:
		return DecodeNxmTunIpv6DstMasked(_oxm, decoder)
	case 86652:
		return DecodeNxmTunMetadata1(_oxm, decoder)
	case 202244:
		return DecodeOxmBsnUdf3(_oxm, decoder)
	case 2147491330:
		return DecodeOxmUdpSrc(_oxm, decoder)
	case 115704:
		return DecodeNxmTunMetadata57Masked(_oxm, decoder)
	case 69636:
		return DecodeNxmReg8(_oxm, decoder)
	case 87676:
		return DecodeNxmTunMetadata3(_oxm, decoder)
	case 82184:
		return DecodeOxmTunnelIpv4DstMasked(_oxm, decoder)
	case 203268:
		return DecodeOxmBsnUdf5(_oxm, decoder)
	case 2147492354:
		return DecodeOxmSctpSrc(_oxm, decoder)
	case 2147493377:
		return DecodeOxmIcmpv4Type(_oxm, decoder)
	case 116728:
		return DecodeNxmTunMetadata59Masked(_oxm, decoder)
	case 88700:
		return DecodeNxmTunMetadata5(_oxm, decoder)
	case 73220:
		return DecodeNxmReg15(_oxm, decoder)
	case 76289:
		return DecodeNxmIcmpv6Type(_oxm, decoder)
	case 117752:
		return DecodeNxmTunMetadata61Masked(_oxm, decoder)
	case 4360:
		return DecodeNxmIpDstMasked(_oxm, decoder)
	case 89724:
		return DecodeNxmTunMetadata7(_oxm, decoder)
	case 2147500812:
		return DecodeOxmIpv6NdTllMasked(_oxm, decoder)
	case 8708:
		return DecodeNxmArpTpa(_oxm, decoder)
	case 2147494402:
		return DecodeOxmArpOp(_oxm, decoder)
	case 118776:
		return DecodeNxmTunMetadata63Masked(_oxm, decoder)
	case 199944:
		return DecodeOxmBsnL3DstClassIdMasked(_oxm, decoder)
	case 90748:
		return DecodeNxmTunMetadata9(_oxm, decoder)
	case 86520:
		return DecodeNxmTunMetadata0Masked(_oxm, decoder)
	case 2147487490:
		return DecodeOxmVlanPcpMasked(_oxm, decoder)
	case 2147492100:
		return DecodeOxmUdpDstMasked(_oxm, decoder)
	case 2147501320:
		return DecodeOxmMplsLabelMasked(_oxm, decoder)
	case 197124:
		return DecodeOxmBsnLagId(_oxm, decoder)
	case 78849:
		return DecodeNxmIpFrag(_oxm, decoder)
	case 2147490818:
		return DecodeOxmTcpDst(_oxm, decoder)
	case 200708:
		return DecodeOxmBsnUdf0(_oxm, decoder)
	case 91772:
		return DecodeNxmTunMetadata11(_oxm, decoder)
	case 87544:
		return DecodeNxmTunMetadata2Masked(_oxm, decoder)
	case 207364:
		return DecodeOxmBsnVxlanNetworkId(_oxm, decoder)
	case 209410:
		return DecodeOxmBsnVfi(_oxm, decoder)
	case 2147498497:
		return DecodeOxmIcmpv6Type(_oxm, decoder)
	case 92796:
		return DecodeNxmTunMetadata13(_oxm, decoder)
	case 88568:
		return DecodeNxmTunMetadata4Masked(_oxm, decoder)
	case 2147495428:
		return DecodeOxmArpTpa(_oxm, decoder)
	case 80385:
		return DecodeNxmNwTtl(_oxm, decoder)
	case 105976:
		return DecodeNxmTunMetadata38Masked(_oxm, decoder)
	case 126465:
		return DecodeOxmConnTrackingNwProto(_oxm, decoder)
	case 7682:
		return DecodeNxmArpOp(_oxm, decoder)
	case 71172:
		return DecodeNxmReg11(_oxm, decoder)
	case 208390:
		return DecodeOxmBsnInnerEthSrc(_oxm, decoder)
	case 2147499266:
		return DecodeOxmIcmpv6CodeMasked(_oxm, decoder)
	case 128528:
		return DecodeOxmConnTrackingIpv6Dst(_oxm, decoder)
	case 85252:
		return DecodeNxmTunGbpIdMasked(_oxm, decoder)
	case 90616:
		return DecodeNxmTunMetadata8Masked(_oxm, decoder)
	case 79364:
		return DecodeNxmIpv6Label(_oxm, decoder)
	case 207112:
		return DecodeOxmBsnIngressPortGroupIdMasked(_oxm, decoder)
	case 2147489796:
		return DecodeOxmIpv4Dst(_oxm, decoder)
	case 206400:
		return DecodeOxmBsnInPorts512(_oxm, decoder)
	case 95868:
		return DecodeNxmTunMetadata19(_oxm, decoder)
	case 91640:
		return DecodeNxmTunMetadata10Masked(_oxm, decoder)
	case 2147485964:
		return DecodeOxmEthSrcMasked(_oxm, decoder)
	case 2147496454:
		return DecodeOxmArpTha(_oxm, decoder)
	case 2147491842:
		return DecodeOxmUdpDst(_oxm, decoder)
	case 2147501569:
		return DecodeOxmMplsTc(_oxm, decoder)
	case 70920:
		return DecodeNxmReg10Masked(_oxm, decoder)
	case 96892:
		return DecodeNxmTunMetadata21(_oxm, decoder)
	case 92664:
		return DecodeNxmTunMetadata12Masked(_oxm, decoder)
	case 205060:
		return DecodeOxmBsnTcpFlagsMasked(_oxm, decoder)
	case 81412:
		return DecodeOxmTunnelIpv4Src(_oxm, decoder)
	case 99964:
		return DecodeNxmTunMetadata27(_oxm, decoder)
	case 71684:
		return DecodeNxmReg12(_oxm, decoder)
	case 127240:
		return DecodeOxmConnTrackingNwSrcMasked(_oxm, decoder)
	case 97916:
		return DecodeNxmTunMetadata23(_oxm, decoder)
	case 93688:
		return DecodeNxmTunMetadata14Masked(_oxm, decoder)
	case 82436:
		return DecodeNxmPktMark(_oxm, decoder)
	case 85505:
		return DecodeNxmTunGbpFlags(_oxm, decoder)
	case 98940:
		return DecodeNxmTunMetadata25(_oxm, decoder)
	case 94712:
		return DecodeNxmTunMetadata16Masked(_oxm, decoder)
	case 83460:
		return DecodeNxmDpHash(_oxm, decoder)
	case 2147503618:
		return DecodeOxmIpv6Exthdr(_oxm, decoder)
	case 2147490056:
		return DecodeOxmIpv4DstMasked(_oxm, decoder)
	case 123168:
		return DecodeNxmXxreg1Masked(_oxm, decoder)
	case 118786:
		return DecodeNxmTunFlags(_oxm, decoder)
	case 95736:
		return DecodeNxmTunMetadata18Masked(_oxm, decoder)
	case 2308:
		return DecodeNxmVlanTciMasked(_oxm, decoder)
	case 2147484164:
		return DecodeOxmInPhyPort(_oxm, decoder)
	case 2147488002:
		return DecodeOxmIpDscpMasked(_oxm, decoder)
	case 100988:
		return DecodeNxmTunMetadata29(_oxm, decoder)
	case 119810:
		return DecodeOxmConnTrackingZone(_oxm, decoder)
	case 96760:
		return DecodeNxmTunMetadata20Masked(_oxm, decoder)
	case 2147486980:
		return DecodeOxmVlanVidMasked(_oxm, decoder)
	case 116348:
		return DecodeNxmTunMetadata59(_oxm, decoder)
	case 5378:
		return DecodeNxmTcpDstMasked(_oxm, decoder)
	case 71944:
		return DecodeNxmReg12Masked(_oxm, decoder)
	case 65800:
		return DecodeNxmReg0Masked(_oxm, decoder)
	case 75552:
		return DecodeNxmIpv6SrcMasked(_oxm, decoder)
	case 102012:
		return DecodeNxmTunMetadata31(_oxm, decoder)
	case 2147493634:
		return DecodeOxmIcmpv4TypeMasked(_oxm, decoder)
	case 5892:
		return DecodeNxmUdpSrcMasked(_oxm, decoder)
	case 97784:
		return DecodeNxmTunMetadata22Masked(_oxm, decoder)
	case 67336:
		return DecodeNxmReg3Masked(_oxm, decoder)
	case 2147485452:
		return DecodeOxmEthDstMasked(_oxm, decoder)
	case 75280:
		return DecodeNxmIpv6Src(_oxm, decoder)
	case 197896:
		return DecodeOxmBsnVrfMasked(_oxm, decoder)
	case 122656:
		return DecodeNxmXxreg0Masked(_oxm, decoder)
	case 103036:
		return DecodeNxmTunMetadata33(_oxm, decoder)
	case 98808:
		return DecodeNxmTunMetadata24Masked(_oxm, decoder)
	case 67848:
		return DecodeNxmReg4Masked(_oxm, decoder)
	case 77600:
		return DecodeNxmNdTargetMasked(_oxm, decoder)
	case 104060:
		return DecodeNxmTunMetadata35(_oxm, decoder)
	case 99832:
		return DecodeNxmTunMetadata26Masked(_oxm, decoder)
	case 6404:
		return DecodeNxmUdpDstMasked(_oxm, decoder)
	case 2147484424:
		return DecodeOxmInPhyPortMasked(_oxm, decoder)
	case 77328:
		return DecodeNxmNdTarget(_oxm, decoder)
	case 68872:
		return DecodeNxmReg6Masked(_oxm, decoder)
	case 105084:
		return DecodeNxmTunMetadata37(_oxm, decoder)
	case 100856:
		return DecodeNxmTunMetadata28Masked(_oxm, decoder)
	case 2147491076:
		return DecodeOxmTcpDstMasked(_oxm, decoder)
	case 206082:
		return DecodeOxmBsnL2CacheHitMasked(_oxm, decoder)
	case 69896:
		return DecodeNxmReg8Masked(_oxm, decoder)
	case 2147497760:
		return DecodeOxmIpv6DstMasked(_oxm, decoder)
	case 206720:
		return DecodeOxmBsnInPorts512Masked(_oxm, decoder)
	case 106108:
		return DecodeNxmTunMetadata39(_oxm, decoder)
	case 101880:
		return DecodeNxmTunMetadata30Masked(_oxm, decoder)
	case 8452:
		return DecodeNxmArpSpaMasked(_oxm, decoder)
	case 66312:
		return DecodeNxmReg1Masked(_oxm, decoder)
	case 2147497488:
		return DecodeOxmIpv6Dst(_oxm, decoder)
	case 201992:
		return DecodeOxmBsnUdf2Masked(_oxm, decoder)
	case 107132:
		return DecodeNxmTunMetadata41(_oxm, decoder)
	case 102904:
		return DecodeNxmTunMetadata32Masked(_oxm, decoder)
	case 2147493124:
		return DecodeOxmSctpDstMasked(_oxm, decoder)
	case 67076:
		return DecodeNxmReg3(_oxm, decoder)
	case 119300:
		return DecodeOxmConnTrackingState(_oxm, decoder)
	case 203016:
		return DecodeOxmBsnUdf4Masked(_oxm, decoder)
	case 2147499808:
		return DecodeOxmIpv6NdTargetMasked(_oxm, decoder)
	case 108156:
		return DecodeNxmTunMetadata43(_oxm, decoder)
	case 103928:
		return DecodeNxmTunMetadata34Masked(_oxm, decoder)
	case 106488:
		return DecodeNxmTunMetadata39Masked(_oxm, decoder)
	case 201732:
		return DecodeOxmBsnUdf2(_oxm, decoder)
	case 2147499536:
		return DecodeOxmIpv6NdTarget(_oxm, decoder)
	case 72968:
		return DecodeNxmReg14Masked(_oxm, decoder)
	case 109180:
		return DecodeNxmTunMetadata45(_oxm, decoder)
	case 104952:
		return DecodeNxmTunMetadata36Masked(_oxm, decoder)
	case 93820:
		return DecodeNxmTunMetadata15(_oxm, decoder)
	case 79106:
		return DecodeNxmIpFragMasked(_oxm, decoder)
	case 108536:
		return DecodeNxmTunMetadata43Masked(_oxm, decoder)
	case 126980:
		return DecodeOxmConnTrackingNwSrc(_oxm, decoder)
	default:
		return nil, nil
	}
}

func NewOxm(_type_len uint32) *Oxm {
	obj := &Oxm{}
	obj.TypeLen = _type_len
	return obj
}

type NxmArpOp struct {
	*Oxm
	Value uint16
}

type INxmArpOp interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmArpOp) GetValue() uint16 {
	return self.Value
}

func (self *NxmArpOp) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmArpOp) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmArpOp(parent *Oxm, decoder *goloxi.Decoder) (*NxmArpOp, error) {
	_nxmarpop := &NxmArpOp{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmArpOp packet too short: %d < 2", decoder.Length())
	}
	_nxmarpop.Value = uint16(decoder.ReadUint16())
	return _nxmarpop, nil
}

func NewNxmArpOp() *NxmArpOp {
	obj := &NxmArpOp{
		Oxm: NewOxm(7682),
	}
	return obj
}
func (self *NxmArpOp) GetOXMName() string {
	return "arp_op"
}

func (self *NxmArpOp) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmArpOp) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmArpSha struct {
	*Oxm
	Value net.HardwareAddr
}

type INxmArpSha interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *NxmArpSha) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmArpSha) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmArpSha) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmArpSha(parent *Oxm, decoder *goloxi.Decoder) (*NxmArpSha, error) {
	_nxmarpsha := &NxmArpSha{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("NxmArpSha packet too short: %d < 6", decoder.Length())
	}
	_nxmarpsha.Value = net.HardwareAddr(decoder.Read(6))
	return _nxmarpsha, nil
}

func NewNxmArpSha() *NxmArpSha {
	obj := &NxmArpSha{
		Oxm: NewOxm(74246),
	}
	return obj
}
func (self *NxmArpSha) GetOXMName() string {
	return "arp_sha"
}

func (self *NxmArpSha) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmArpSha) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmArpShaMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type INxmArpShaMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *NxmArpShaMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmArpShaMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmArpShaMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *NxmArpShaMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *NxmArpShaMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmArpShaMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmArpShaMasked, error) {
	_nxmarpshamasked := &NxmArpShaMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("NxmArpShaMasked packet too short: %d < 12", decoder.Length())
	}
	_nxmarpshamasked.Value = net.HardwareAddr(decoder.Read(6))
	_nxmarpshamasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _nxmarpshamasked, nil
}

func NewNxmArpShaMasked() *NxmArpShaMasked {
	obj := &NxmArpShaMasked{
		Oxm: NewOxm(74507),
	}
	return obj
}
func (self *NxmArpShaMasked) GetOXMName() string {
	return "arp_sha_masked"
}

func (self *NxmArpShaMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmArpShaMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmArpShaMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmArpSpa struct {
	*Oxm
	Value net.IP
}

type INxmArpSpa interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmArpSpa) GetValue() net.IP {
	return self.Value
}

func (self *NxmArpSpa) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmArpSpa) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeNxmArpSpa(parent *Oxm, decoder *goloxi.Decoder) (*NxmArpSpa, error) {
	_nxmarpspa := &NxmArpSpa{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmArpSpa packet too short: %d < 4", decoder.Length())
	}
	_nxmarpspa.Value = net.IP(decoder.Read(4))
	return _nxmarpspa, nil
}

func NewNxmArpSpa() *NxmArpSpa {
	obj := &NxmArpSpa{
		Oxm: NewOxm(8196),
	}
	return obj
}
func (self *NxmArpSpa) GetOXMName() string {
	return "arp_spa"
}

func (self *NxmArpSpa) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmArpSpa) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmArpSpaMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmArpSpaMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmArpSpaMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmArpSpaMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmArpSpaMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmArpSpaMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmArpSpaMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeNxmArpSpaMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmArpSpaMasked, error) {
	_nxmarpspamasked := &NxmArpSpaMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmArpSpaMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmarpspamasked.Value = net.IP(decoder.Read(4))
	_nxmarpspamasked.ValueMask = net.IP(decoder.Read(4))
	return _nxmarpspamasked, nil
}

func NewNxmArpSpaMasked() *NxmArpSpaMasked {
	obj := &NxmArpSpaMasked{
		Oxm: NewOxm(8452),
	}
	return obj
}
func (self *NxmArpSpaMasked) GetOXMName() string {
	return "arp_spa_masked"
}

func (self *NxmArpSpaMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmArpSpaMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmArpSpaMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmArpTha struct {
	*Oxm
	Value net.HardwareAddr
}

type INxmArpTha interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *NxmArpTha) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmArpTha) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmArpTha) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmArpTha(parent *Oxm, decoder *goloxi.Decoder) (*NxmArpTha, error) {
	_nxmarptha := &NxmArpTha{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("NxmArpTha packet too short: %d < 6", decoder.Length())
	}
	_nxmarptha.Value = net.HardwareAddr(decoder.Read(6))
	return _nxmarptha, nil
}

func NewNxmArpTha() *NxmArpTha {
	obj := &NxmArpTha{
		Oxm: NewOxm(74758),
	}
	return obj
}
func (self *NxmArpTha) GetOXMName() string {
	return "arp_tha"
}

func (self *NxmArpTha) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmArpTha) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmArpThaMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type INxmArpThaMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *NxmArpThaMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmArpThaMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmArpThaMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *NxmArpThaMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *NxmArpThaMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmArpThaMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmArpThaMasked, error) {
	_nxmarpthamasked := &NxmArpThaMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("NxmArpThaMasked packet too short: %d < 12", decoder.Length())
	}
	_nxmarpthamasked.Value = net.HardwareAddr(decoder.Read(6))
	_nxmarpthamasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _nxmarpthamasked, nil
}

func NewNxmArpThaMasked() *NxmArpThaMasked {
	obj := &NxmArpThaMasked{
		Oxm: NewOxm(75019),
	}
	return obj
}
func (self *NxmArpThaMasked) GetOXMName() string {
	return "arp_tha_masked"
}

func (self *NxmArpThaMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmArpThaMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmArpThaMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmArpTpa struct {
	*Oxm
	Value net.IP
}

type INxmArpTpa interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmArpTpa) GetValue() net.IP {
	return self.Value
}

func (self *NxmArpTpa) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmArpTpa) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeNxmArpTpa(parent *Oxm, decoder *goloxi.Decoder) (*NxmArpTpa, error) {
	_nxmarptpa := &NxmArpTpa{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmArpTpa packet too short: %d < 4", decoder.Length())
	}
	_nxmarptpa.Value = net.IP(decoder.Read(4))
	return _nxmarptpa, nil
}

func NewNxmArpTpa() *NxmArpTpa {
	obj := &NxmArpTpa{
		Oxm: NewOxm(8708),
	}
	return obj
}
func (self *NxmArpTpa) GetOXMName() string {
	return "arp_tpa"
}

func (self *NxmArpTpa) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmArpTpa) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmArpTpaMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmArpTpaMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmArpTpaMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmArpTpaMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmArpTpaMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmArpTpaMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmArpTpaMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeNxmArpTpaMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmArpTpaMasked, error) {
	_nxmarptpamasked := &NxmArpTpaMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmArpTpaMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmarptpamasked.Value = net.IP(decoder.Read(4))
	_nxmarptpamasked.ValueMask = net.IP(decoder.Read(4))
	return _nxmarptpamasked, nil
}

func NewNxmArpTpaMasked() *NxmArpTpaMasked {
	obj := &NxmArpTpaMasked{
		Oxm: NewOxm(8968),
	}
	return obj
}
func (self *NxmArpTpaMasked) GetOXMName() string {
	return "arp_tpa_masked"
}

func (self *NxmArpTpaMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmArpTpaMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmArpTpaMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmConjId struct {
	*Oxm
	Value uint32
}

type INxmConjId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmConjId) GetValue() uint32 {
	return self.Value
}

func (self *NxmConjId) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmConjId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmConjId(parent *Oxm, decoder *goloxi.Decoder) (*NxmConjId, error) {
	_nxmconjid := &NxmConjId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmConjId packet too short: %d < 4", decoder.Length())
	}
	_nxmconjid.Value = uint32(decoder.ReadUint32())
	return _nxmconjid, nil
}

func NewNxmConjId() *NxmConjId {
	obj := &NxmConjId{
		Oxm: NewOxm(84484),
	}
	return obj
}
func (self *NxmConjId) GetOXMName() string {
	return "conj_id"
}

func (self *NxmConjId) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmConjId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtIpv6Dst struct {
	*Oxm
	Value net.IP
}

type INxmCtIpv6Dst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmCtIpv6Dst) GetValue() net.IP {
	return self.Value
}

func (self *NxmCtIpv6Dst) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmCtIpv6Dst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeNxmCtIpv6Dst(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtIpv6Dst, error) {
	_nxmctipv6dst := &NxmCtIpv6Dst{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmCtIpv6Dst packet too short: %d < 16", decoder.Length())
	}
	_nxmctipv6dst.Value = net.IP(decoder.Read(16))
	return _nxmctipv6dst, nil
}

func NewNxmCtIpv6Dst() *NxmCtIpv6Dst {
	obj := &NxmCtIpv6Dst{
		Oxm: NewOxm(128528),
	}
	return obj
}
func (self *NxmCtIpv6Dst) GetOXMName() string {
	return "ct_ipv6_dst"
}

func (self *NxmCtIpv6Dst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtIpv6Dst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtIpv6DstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmCtIpv6DstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmCtIpv6DstMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmCtIpv6DstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmCtIpv6DstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmCtIpv6DstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmCtIpv6DstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeNxmCtIpv6DstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtIpv6DstMasked, error) {
	_nxmctipv6dstmasked := &NxmCtIpv6DstMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmCtIpv6DstMasked packet too short: %d < 32", decoder.Length())
	}
	_nxmctipv6dstmasked.Value = net.IP(decoder.Read(16))
	_nxmctipv6dstmasked.ValueMask = net.IP(decoder.Read(16))
	return _nxmctipv6dstmasked, nil
}

func NewNxmCtIpv6DstMasked() *NxmCtIpv6DstMasked {
	obj := &NxmCtIpv6DstMasked{
		Oxm: NewOxm(128800),
	}
	return obj
}
func (self *NxmCtIpv6DstMasked) GetOXMName() string {
	return "ct_ipv6_dst_masked"
}

func (self *NxmCtIpv6DstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtIpv6DstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmCtIpv6DstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmCtIpv6Src struct {
	*Oxm
	Value net.IP
}

type INxmCtIpv6Src interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmCtIpv6Src) GetValue() net.IP {
	return self.Value
}

func (self *NxmCtIpv6Src) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmCtIpv6Src) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeNxmCtIpv6Src(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtIpv6Src, error) {
	_nxmctipv6src := &NxmCtIpv6Src{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmCtIpv6Src packet too short: %d < 16", decoder.Length())
	}
	_nxmctipv6src.Value = net.IP(decoder.Read(16))
	return _nxmctipv6src, nil
}

func NewNxmCtIpv6Src() *NxmCtIpv6Src {
	obj := &NxmCtIpv6Src{
		Oxm: NewOxm(128016),
	}
	return obj
}
func (self *NxmCtIpv6Src) GetOXMName() string {
	return "ct_ipv6_src"
}

func (self *NxmCtIpv6Src) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtIpv6Src) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtIpv6SrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmCtIpv6SrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmCtIpv6SrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmCtIpv6SrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmCtIpv6SrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmCtIpv6SrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmCtIpv6SrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeNxmCtIpv6SrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtIpv6SrcMasked, error) {
	_nxmctipv6srcmasked := &NxmCtIpv6SrcMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmCtIpv6SrcMasked packet too short: %d < 32", decoder.Length())
	}
	_nxmctipv6srcmasked.Value = net.IP(decoder.Read(16))
	_nxmctipv6srcmasked.ValueMask = net.IP(decoder.Read(16))
	return _nxmctipv6srcmasked, nil
}

func NewNxmCtIpv6SrcMasked() *NxmCtIpv6SrcMasked {
	obj := &NxmCtIpv6SrcMasked{
		Oxm: NewOxm(128288),
	}
	return obj
}
func (self *NxmCtIpv6SrcMasked) GetOXMName() string {
	return "ct_ipv6_src_masked"
}

func (self *NxmCtIpv6SrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtIpv6SrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmCtIpv6SrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmCtLabel struct {
	*Oxm
	Value uint128
}

type INxmCtLabel interface {
	goloxi.IOxm
	GetValue() uint128
}

func (self *NxmCtLabel) GetValue() uint128 {
	return self.Value
}

func (self *NxmCtLabel) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmCtLabel) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))

	return nil
}

func DecodeNxmCtLabel(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtLabel, error) {
	_nxmctlabel := &NxmCtLabel{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmCtLabel packet too short: %d < 16", decoder.Length())
	}
	_nxmctlabel.Value = uint128(decoder.ReadUint128())
	return _nxmctlabel, nil
}

func NewNxmCtLabel() *NxmCtLabel {
	obj := &NxmCtLabel{
		Oxm: NewOxm(120848),
	}
	return obj
}
func (self *NxmCtLabel) GetOXMName() string {
	return "ct_label"
}

func (self *NxmCtLabel) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtLabel) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtLabelMasked struct {
	*Oxm
	Value     uint128
	ValueMask uint128
}

type INxmCtLabelMasked interface {
	goloxi.IOxm
	GetValue() uint128
	GetValueMask() uint128
}

func (self *NxmCtLabelMasked) GetValue() uint128 {
	return self.Value
}

func (self *NxmCtLabelMasked) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmCtLabelMasked) GetValueMask() uint128 {
	return self.ValueMask
}

func (self *NxmCtLabelMasked) SetValueMask(v uint128) {
	self.ValueMask = v
}

func (self *NxmCtLabelMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))
	encoder.PutUint128(uint128(self.ValueMask))

	return nil
}

func DecodeNxmCtLabelMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtLabelMasked, error) {
	_nxmctlabelmasked := &NxmCtLabelMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmCtLabelMasked packet too short: %d < 32", decoder.Length())
	}
	_nxmctlabelmasked.Value = uint128(decoder.ReadUint128())
	_nxmctlabelmasked.ValueMask = uint128(decoder.ReadUint128())
	return _nxmctlabelmasked, nil
}

func NewNxmCtLabelMasked() *NxmCtLabelMasked {
	obj := &NxmCtLabelMasked{
		Oxm: NewOxm(121120),
	}
	return obj
}
func (self *NxmCtLabelMasked) GetOXMName() string {
	return "ct_label_masked"
}

func (self *NxmCtLabelMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtLabelMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmCtLabelMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmCtMark struct {
	*Oxm
	Value uint32
}

type INxmCtMark interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmCtMark) GetValue() uint32 {
	return self.Value
}

func (self *NxmCtMark) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmCtMark) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmCtMark(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtMark, error) {
	_nxmctmark := &NxmCtMark{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmCtMark packet too short: %d < 4", decoder.Length())
	}
	_nxmctmark.Value = uint32(decoder.ReadUint32())
	return _nxmctmark, nil
}

func NewNxmCtMark() *NxmCtMark {
	obj := &NxmCtMark{
		Oxm: NewOxm(120324),
	}
	return obj
}
func (self *NxmCtMark) GetOXMName() string {
	return "ct_mark"
}

func (self *NxmCtMark) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtMark) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtMarkMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmCtMarkMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmCtMarkMasked) GetValue() uint32 {
	return self.Value
}

func (self *NxmCtMarkMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmCtMarkMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmCtMarkMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmCtMarkMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmCtMarkMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtMarkMasked, error) {
	_nxmctmarkmasked := &NxmCtMarkMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmCtMarkMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmctmarkmasked.Value = uint32(decoder.ReadUint32())
	_nxmctmarkmasked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmctmarkmasked, nil
}

func NewNxmCtMarkMasked() *NxmCtMarkMasked {
	obj := &NxmCtMarkMasked{
		Oxm: NewOxm(120584),
	}
	return obj
}
func (self *NxmCtMarkMasked) GetOXMName() string {
	return "ct_mark_masked"
}

func (self *NxmCtMarkMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtMarkMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmCtMarkMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmCtNwDst struct {
	*Oxm
	Value net.IP
}

type INxmCtNwDst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmCtNwDst) GetValue() net.IP {
	return self.Value
}

func (self *NxmCtNwDst) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmCtNwDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeNxmCtNwDst(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtNwDst, error) {
	_nxmctnwdst := &NxmCtNwDst{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmCtNwDst packet too short: %d < 4", decoder.Length())
	}
	_nxmctnwdst.Value = net.IP(decoder.Read(4))
	return _nxmctnwdst, nil
}

func NewNxmCtNwDst() *NxmCtNwDst {
	obj := &NxmCtNwDst{
		Oxm: NewOxm(127492),
	}
	return obj
}
func (self *NxmCtNwDst) GetOXMName() string {
	return "ct_nw_dst"
}

func (self *NxmCtNwDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtNwDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtNwDstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmCtNwDstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmCtNwDstMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmCtNwDstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmCtNwDstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmCtNwDstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmCtNwDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeNxmCtNwDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtNwDstMasked, error) {
	_nxmctnwdstmasked := &NxmCtNwDstMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmCtNwDstMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmctnwdstmasked.Value = net.IP(decoder.Read(4))
	_nxmctnwdstmasked.ValueMask = net.IP(decoder.Read(4))
	return _nxmctnwdstmasked, nil
}

func NewNxmCtNwDstMasked() *NxmCtNwDstMasked {
	obj := &NxmCtNwDstMasked{
		Oxm: NewOxm(127752),
	}
	return obj
}
func (self *NxmCtNwDstMasked) GetOXMName() string {
	return "ct_nw_dst_masked"
}

func (self *NxmCtNwDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtNwDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmCtNwDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmCtNwProto struct {
	*Oxm
	Value uint8
}

type INxmCtNwProto interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmCtNwProto) GetValue() uint8 {
	return self.Value
}

func (self *NxmCtNwProto) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmCtNwProto) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmCtNwProto(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtNwProto, error) {
	_nxmctnwproto := &NxmCtNwProto{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmCtNwProto packet too short: %d < 1", decoder.Length())
	}
	_nxmctnwproto.Value = uint8(decoder.ReadByte())
	return _nxmctnwproto, nil
}

func NewNxmCtNwProto() *NxmCtNwProto {
	obj := &NxmCtNwProto{
		Oxm: NewOxm(126465),
	}
	return obj
}
func (self *NxmCtNwProto) GetOXMName() string {
	return "ct_nw_proto"
}

func (self *NxmCtNwProto) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtNwProto) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtNwSrc struct {
	*Oxm
	Value net.IP
}

type INxmCtNwSrc interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmCtNwSrc) GetValue() net.IP {
	return self.Value
}

func (self *NxmCtNwSrc) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmCtNwSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeNxmCtNwSrc(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtNwSrc, error) {
	_nxmctnwsrc := &NxmCtNwSrc{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmCtNwSrc packet too short: %d < 4", decoder.Length())
	}
	_nxmctnwsrc.Value = net.IP(decoder.Read(4))
	return _nxmctnwsrc, nil
}

func NewNxmCtNwSrc() *NxmCtNwSrc {
	obj := &NxmCtNwSrc{
		Oxm: NewOxm(126980),
	}
	return obj
}
func (self *NxmCtNwSrc) GetOXMName() string {
	return "ct_nw_src"
}

func (self *NxmCtNwSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtNwSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtNwSrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmCtNwSrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmCtNwSrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmCtNwSrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmCtNwSrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmCtNwSrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmCtNwSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeNxmCtNwSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtNwSrcMasked, error) {
	_nxmctnwsrcmasked := &NxmCtNwSrcMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmCtNwSrcMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmctnwsrcmasked.Value = net.IP(decoder.Read(4))
	_nxmctnwsrcmasked.ValueMask = net.IP(decoder.Read(4))
	return _nxmctnwsrcmasked, nil
}

func NewNxmCtNwSrcMasked() *NxmCtNwSrcMasked {
	obj := &NxmCtNwSrcMasked{
		Oxm: NewOxm(127240),
	}
	return obj
}
func (self *NxmCtNwSrcMasked) GetOXMName() string {
	return "ct_nw_src_masked"
}

func (self *NxmCtNwSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtNwSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmCtNwSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmCtState struct {
	*Oxm
	Value []byte
}

type INxmCtState interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmCtState) GetValue() []byte {
	return self.Value
}

func (self *NxmCtState) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmCtState) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmCtState(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtState, error) {
	_nxmctstate := &NxmCtState{Oxm: parent}
	_nxmctstate.Value = decoder.Read(int(_nxmctstate.TypeLen & 0xFF))
	return _nxmctstate, nil
}

func NewNxmCtState() *NxmCtState {
	obj := &NxmCtState{
		Oxm: NewOxm(119300),
	}
	return obj
}
func (self *NxmCtState) GetOXMName() string {
	return "ct_state"
}

func (self *NxmCtState) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtState) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtStateMasked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmCtStateMasked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmCtStateMasked) GetValue() []byte {
	return self.Value
}

func (self *NxmCtStateMasked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmCtStateMasked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmCtStateMasked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmCtStateMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmCtStateMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtStateMasked, error) {
	_nxmctstatemasked := &NxmCtStateMasked{Oxm: parent}
	_nxmctstatemasked.Value = decoder.Read(int(_nxmctstatemasked.TypeLen & 0xFF))
	_nxmctstatemasked.ValueMask = decoder.Read(int(_nxmctstatemasked.TypeLen & 0xFF))
	return _nxmctstatemasked, nil
}

func NewNxmCtStateMasked() *NxmCtStateMasked {
	obj := &NxmCtStateMasked{
		Oxm: NewOxm(119560),
	}
	return obj
}
func (self *NxmCtStateMasked) GetOXMName() string {
	return "ct_state_masked"
}

func (self *NxmCtStateMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtStateMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmCtStateMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmCtTpDst struct {
	*Oxm
	Value uint16
}

type INxmCtTpDst interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmCtTpDst) GetValue() uint16 {
	return self.Value
}

func (self *NxmCtTpDst) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmCtTpDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmCtTpDst(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtTpDst, error) {
	_nxmcttpdst := &NxmCtTpDst{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmCtTpDst packet too short: %d < 2", decoder.Length())
	}
	_nxmcttpdst.Value = uint16(decoder.ReadUint16())
	return _nxmcttpdst, nil
}

func NewNxmCtTpDst() *NxmCtTpDst {
	obj := &NxmCtTpDst{
		Oxm: NewOxm(129538),
	}
	return obj
}
func (self *NxmCtTpDst) GetOXMName() string {
	return "ct_tp_dst"
}

func (self *NxmCtTpDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtTpDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtTpDstMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type INxmCtTpDstMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *NxmCtTpDstMasked) GetValue() uint16 {
	return self.Value
}

func (self *NxmCtTpDstMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmCtTpDstMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmCtTpDstMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmCtTpDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmCtTpDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtTpDstMasked, error) {
	_nxmcttpdstmasked := &NxmCtTpDstMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmCtTpDstMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmcttpdstmasked.Value = uint16(decoder.ReadUint16())
	_nxmcttpdstmasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmcttpdstmasked, nil
}

func NewNxmCtTpDstMasked() *NxmCtTpDstMasked {
	obj := &NxmCtTpDstMasked{
		Oxm: NewOxm(129796),
	}
	return obj
}
func (self *NxmCtTpDstMasked) GetOXMName() string {
	return "ct_tp_dst_masked"
}

func (self *NxmCtTpDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtTpDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmCtTpDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmCtTpSrc struct {
	*Oxm
	Value uint16
}

type INxmCtTpSrc interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmCtTpSrc) GetValue() uint16 {
	return self.Value
}

func (self *NxmCtTpSrc) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmCtTpSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmCtTpSrc(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtTpSrc, error) {
	_nxmcttpsrc := &NxmCtTpSrc{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmCtTpSrc packet too short: %d < 2", decoder.Length())
	}
	_nxmcttpsrc.Value = uint16(decoder.ReadUint16())
	return _nxmcttpsrc, nil
}

func NewNxmCtTpSrc() *NxmCtTpSrc {
	obj := &NxmCtTpSrc{
		Oxm: NewOxm(129026),
	}
	return obj
}
func (self *NxmCtTpSrc) GetOXMName() string {
	return "ct_tp_src"
}

func (self *NxmCtTpSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtTpSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmCtTpSrcMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type INxmCtTpSrcMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *NxmCtTpSrcMasked) GetValue() uint16 {
	return self.Value
}

func (self *NxmCtTpSrcMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmCtTpSrcMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmCtTpSrcMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmCtTpSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmCtTpSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtTpSrcMasked, error) {
	_nxmcttpsrcmasked := &NxmCtTpSrcMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmCtTpSrcMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmcttpsrcmasked.Value = uint16(decoder.ReadUint16())
	_nxmcttpsrcmasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmcttpsrcmasked, nil
}

func NewNxmCtTpSrcMasked() *NxmCtTpSrcMasked {
	obj := &NxmCtTpSrcMasked{
		Oxm: NewOxm(129284),
	}
	return obj
}
func (self *NxmCtTpSrcMasked) GetOXMName() string {
	return "ct_tp_src_masked"
}

func (self *NxmCtTpSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtTpSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmCtTpSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmCtZone struct {
	*Oxm
	Value uint16
}

type INxmCtZone interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmCtZone) GetValue() uint16 {
	return self.Value
}

func (self *NxmCtZone) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmCtZone) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmCtZone(parent *Oxm, decoder *goloxi.Decoder) (*NxmCtZone, error) {
	_nxmctzone := &NxmCtZone{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmCtZone packet too short: %d < 2", decoder.Length())
	}
	_nxmctzone.Value = uint16(decoder.ReadUint16())
	return _nxmctzone, nil
}

func NewNxmCtZone() *NxmCtZone {
	obj := &NxmCtZone{
		Oxm: NewOxm(119810),
	}
	return obj
}
func (self *NxmCtZone) GetOXMName() string {
	return "ct_zone"
}

func (self *NxmCtZone) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmCtZone) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmDpHash struct {
	*Oxm
	Value uint32
}

type INxmDpHash interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmDpHash) GetValue() uint32 {
	return self.Value
}

func (self *NxmDpHash) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmDpHash) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmDpHash(parent *Oxm, decoder *goloxi.Decoder) (*NxmDpHash, error) {
	_nxmdphash := &NxmDpHash{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmDpHash packet too short: %d < 4", decoder.Length())
	}
	_nxmdphash.Value = uint32(decoder.ReadUint32())
	return _nxmdphash, nil
}

func NewNxmDpHash() *NxmDpHash {
	obj := &NxmDpHash{
		Oxm: NewOxm(83460),
	}
	return obj
}
func (self *NxmDpHash) GetOXMName() string {
	return "dp_hash"
}

func (self *NxmDpHash) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmDpHash) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmDpHashMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmDpHashMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmDpHashMasked) GetValue() uint32 {
	return self.Value
}

func (self *NxmDpHashMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmDpHashMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmDpHashMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmDpHashMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmDpHashMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmDpHashMasked, error) {
	_nxmdphashmasked := &NxmDpHashMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmDpHashMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmdphashmasked.Value = uint32(decoder.ReadUint32())
	_nxmdphashmasked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmdphashmasked, nil
}

func NewNxmDpHashMasked() *NxmDpHashMasked {
	obj := &NxmDpHashMasked{
		Oxm: NewOxm(83720),
	}
	return obj
}
func (self *NxmDpHashMasked) GetOXMName() string {
	return "dp_hash_masked"
}

func (self *NxmDpHashMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmDpHashMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmDpHashMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmEthDst struct {
	*Oxm
	Value net.HardwareAddr
}

type INxmEthDst interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *NxmEthDst) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmEthDst) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmEthDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmEthDst(parent *Oxm, decoder *goloxi.Decoder) (*NxmEthDst, error) {
	_nxmethdst := &NxmEthDst{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("NxmEthDst packet too short: %d < 6", decoder.Length())
	}
	_nxmethdst.Value = net.HardwareAddr(decoder.Read(6))
	return _nxmethdst, nil
}

func NewNxmEthDst() *NxmEthDst {
	obj := &NxmEthDst{
		Oxm: NewOxm(518),
	}
	return obj
}
func (self *NxmEthDst) GetOXMName() string {
	return "eth_dst"
}

func (self *NxmEthDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmEthDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmEthDstMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type INxmEthDstMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *NxmEthDstMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmEthDstMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmEthDstMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *NxmEthDstMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *NxmEthDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmEthDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmEthDstMasked, error) {
	_nxmethdstmasked := &NxmEthDstMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("NxmEthDstMasked packet too short: %d < 12", decoder.Length())
	}
	_nxmethdstmasked.Value = net.HardwareAddr(decoder.Read(6))
	_nxmethdstmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _nxmethdstmasked, nil
}

func NewNxmEthDstMasked() *NxmEthDstMasked {
	obj := &NxmEthDstMasked{
		Oxm: NewOxm(779),
	}
	return obj
}
func (self *NxmEthDstMasked) GetOXMName() string {
	return "eth_dst_masked"
}

func (self *NxmEthDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmEthDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmEthDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmEthSrc struct {
	*Oxm
	Value net.HardwareAddr
}

type INxmEthSrc interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *NxmEthSrc) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmEthSrc) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmEthSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmEthSrc(parent *Oxm, decoder *goloxi.Decoder) (*NxmEthSrc, error) {
	_nxmethsrc := &NxmEthSrc{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("NxmEthSrc packet too short: %d < 6", decoder.Length())
	}
	_nxmethsrc.Value = net.HardwareAddr(decoder.Read(6))
	return _nxmethsrc, nil
}

func NewNxmEthSrc() *NxmEthSrc {
	obj := &NxmEthSrc{
		Oxm: NewOxm(1030),
	}
	return obj
}
func (self *NxmEthSrc) GetOXMName() string {
	return "eth_src"
}

func (self *NxmEthSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmEthSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmEthSrcMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type INxmEthSrcMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *NxmEthSrcMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmEthSrcMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmEthSrcMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *NxmEthSrcMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *NxmEthSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmEthSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmEthSrcMasked, error) {
	_nxmethsrcmasked := &NxmEthSrcMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("NxmEthSrcMasked packet too short: %d < 12", decoder.Length())
	}
	_nxmethsrcmasked.Value = net.HardwareAddr(decoder.Read(6))
	_nxmethsrcmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _nxmethsrcmasked, nil
}

func NewNxmEthSrcMasked() *NxmEthSrcMasked {
	obj := &NxmEthSrcMasked{
		Oxm: NewOxm(1286),
	}
	return obj
}
func (self *NxmEthSrcMasked) GetOXMName() string {
	return "eth_src_masked"
}

func (self *NxmEthSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmEthSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmEthSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmEthType struct {
	*Oxm
	Value uint16
}

type INxmEthType interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmEthType) GetValue() uint16 {
	return self.Value
}

func (self *NxmEthType) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmEthType) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmEthType(parent *Oxm, decoder *goloxi.Decoder) (*NxmEthType, error) {
	_nxmethtype := &NxmEthType{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmEthType packet too short: %d < 2", decoder.Length())
	}
	_nxmethtype.Value = uint16(decoder.ReadUint16())
	return _nxmethtype, nil
}

func NewNxmEthType() *NxmEthType {
	obj := &NxmEthType{
		Oxm: NewOxm(1538),
	}
	return obj
}
func (self *NxmEthType) GetOXMName() string {
	return "eth_type"
}

func (self *NxmEthType) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmEthType) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIcmpCode struct {
	*Oxm
	Value uint8
}

type INxmIcmpCode interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmIcmpCode) GetValue() uint8 {
	return self.Value
}

func (self *NxmIcmpCode) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmIcmpCode) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmIcmpCode(parent *Oxm, decoder *goloxi.Decoder) (*NxmIcmpCode, error) {
	_nxmicmpcode := &NxmIcmpCode{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmIcmpCode packet too short: %d < 1", decoder.Length())
	}
	_nxmicmpcode.Value = uint8(decoder.ReadByte())
	return _nxmicmpcode, nil
}

func NewNxmIcmpCode() *NxmIcmpCode {
	obj := &NxmIcmpCode{
		Oxm: NewOxm(7169),
	}
	return obj
}
func (self *NxmIcmpCode) GetOXMName() string {
	return "icmp_code"
}

func (self *NxmIcmpCode) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIcmpCode) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIcmpType struct {
	*Oxm
	Value uint8
}

type INxmIcmpType interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmIcmpType) GetValue() uint8 {
	return self.Value
}

func (self *NxmIcmpType) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmIcmpType) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmIcmpType(parent *Oxm, decoder *goloxi.Decoder) (*NxmIcmpType, error) {
	_nxmicmptype := &NxmIcmpType{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmIcmpType packet too short: %d < 1", decoder.Length())
	}
	_nxmicmptype.Value = uint8(decoder.ReadByte())
	return _nxmicmptype, nil
}

func NewNxmIcmpType() *NxmIcmpType {
	obj := &NxmIcmpType{
		Oxm: NewOxm(6657),
	}
	return obj
}
func (self *NxmIcmpType) GetOXMName() string {
	return "icmp_type"
}

func (self *NxmIcmpType) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIcmpType) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIcmpv6Code struct {
	*Oxm
	Value uint8
}

type INxmIcmpv6Code interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmIcmpv6Code) GetValue() uint8 {
	return self.Value
}

func (self *NxmIcmpv6Code) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmIcmpv6Code) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmIcmpv6Code(parent *Oxm, decoder *goloxi.Decoder) (*NxmIcmpv6Code, error) {
	_nxmicmpv6code := &NxmIcmpv6Code{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmIcmpv6Code packet too short: %d < 1", decoder.Length())
	}
	_nxmicmpv6code.Value = uint8(decoder.ReadByte())
	return _nxmicmpv6code, nil
}

func NewNxmIcmpv6Code() *NxmIcmpv6Code {
	obj := &NxmIcmpv6Code{
		Oxm: NewOxm(76801),
	}
	return obj
}
func (self *NxmIcmpv6Code) GetOXMName() string {
	return "icmpv6_code"
}

func (self *NxmIcmpv6Code) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIcmpv6Code) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIcmpv6Type struct {
	*Oxm
	Value uint8
}

type INxmIcmpv6Type interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmIcmpv6Type) GetValue() uint8 {
	return self.Value
}

func (self *NxmIcmpv6Type) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmIcmpv6Type) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmIcmpv6Type(parent *Oxm, decoder *goloxi.Decoder) (*NxmIcmpv6Type, error) {
	_nxmicmpv6type := &NxmIcmpv6Type{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmIcmpv6Type packet too short: %d < 1", decoder.Length())
	}
	_nxmicmpv6type.Value = uint8(decoder.ReadByte())
	return _nxmicmpv6type, nil
}

func NewNxmIcmpv6Type() *NxmIcmpv6Type {
	obj := &NxmIcmpv6Type{
		Oxm: NewOxm(76289),
	}
	return obj
}
func (self *NxmIcmpv6Type) GetOXMName() string {
	return "icmpv6_type"
}

func (self *NxmIcmpv6Type) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIcmpv6Type) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmInPort struct {
	*Oxm
	Value Port
}

type INxmInPort interface {
	goloxi.IOxm
	GetValue() Port
}

func (self *NxmInPort) GetValue() Port {
	return self.Value
}

func (self *NxmInPort) SetValue(v Port) {
	self.Value = v
}

func (self *NxmInPort) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	self.Value.Serialize(encoder)

	return nil
}

func DecodeNxmInPort(parent *Oxm, decoder *goloxi.Decoder) (*NxmInPort, error) {
	_nxminport := &NxmInPort{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmInPort packet too short: %d < 4", decoder.Length())
	}
	_nxminport.Value.Decode(decoder)
	return _nxminport, nil
}

func NewNxmInPort() *NxmInPort {
	obj := &NxmInPort{
		Oxm: NewOxm(2),
	}
	return obj
}
func (self *NxmInPort) GetOXMName() string {
	return "in_port"
}

func (self *NxmInPort) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmInPort) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIpDst struct {
	*Oxm
	Value net.IP
}

type INxmIpDst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmIpDst) GetValue() net.IP {
	return self.Value
}

func (self *NxmIpDst) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmIpDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeNxmIpDst(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpDst, error) {
	_nxmipdst := &NxmIpDst{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmIpDst packet too short: %d < 4", decoder.Length())
	}
	_nxmipdst.Value = net.IP(decoder.Read(4))
	return _nxmipdst, nil
}

func NewNxmIpDst() *NxmIpDst {
	obj := &NxmIpDst{
		Oxm: NewOxm(4100),
	}
	return obj
}
func (self *NxmIpDst) GetOXMName() string {
	return "ip_dst"
}

func (self *NxmIpDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIpDstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmIpDstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmIpDstMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmIpDstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmIpDstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmIpDstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmIpDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeNxmIpDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpDstMasked, error) {
	_nxmipdstmasked := &NxmIpDstMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmIpDstMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmipdstmasked.Value = net.IP(decoder.Read(4))
	_nxmipdstmasked.ValueMask = net.IP(decoder.Read(4))
	return _nxmipdstmasked, nil
}

func NewNxmIpDstMasked() *NxmIpDstMasked {
	obj := &NxmIpDstMasked{
		Oxm: NewOxm(4360),
	}
	return obj
}
func (self *NxmIpDstMasked) GetOXMName() string {
	return "ip_dst_masked"
}

func (self *NxmIpDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmIpDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmIpFrag struct {
	*Oxm
	Value []byte
}

type INxmIpFrag interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmIpFrag) GetValue() []byte {
	return self.Value
}

func (self *NxmIpFrag) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmIpFrag) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmIpFrag(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpFrag, error) {
	_nxmipfrag := &NxmIpFrag{Oxm: parent}
	_nxmipfrag.Value = decoder.Read(int(_nxmipfrag.TypeLen & 0xFF))
	return _nxmipfrag, nil
}

func NewNxmIpFrag() *NxmIpFrag {
	obj := &NxmIpFrag{
		Oxm: NewOxm(78849),
	}
	return obj
}
func (self *NxmIpFrag) GetOXMName() string {
	return "ip_frag"
}

func (self *NxmIpFrag) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpFrag) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIpFragMasked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmIpFragMasked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmIpFragMasked) GetValue() []byte {
	return self.Value
}

func (self *NxmIpFragMasked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmIpFragMasked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmIpFragMasked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmIpFragMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmIpFragMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpFragMasked, error) {
	_nxmipfragmasked := &NxmIpFragMasked{Oxm: parent}
	_nxmipfragmasked.Value = decoder.Read(int(_nxmipfragmasked.TypeLen & 0xFF))
	_nxmipfragmasked.ValueMask = decoder.Read(int(_nxmipfragmasked.TypeLen & 0xFF))
	return _nxmipfragmasked, nil
}

func NewNxmIpFragMasked() *NxmIpFragMasked {
	obj := &NxmIpFragMasked{
		Oxm: NewOxm(79106),
	}
	return obj
}
func (self *NxmIpFragMasked) GetOXMName() string {
	return "ip_frag_masked"
}

func (self *NxmIpFragMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpFragMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmIpFragMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmIpSrc struct {
	*Oxm
	Value net.IP
}

type INxmIpSrc interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmIpSrc) GetValue() net.IP {
	return self.Value
}

func (self *NxmIpSrc) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmIpSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeNxmIpSrc(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpSrc, error) {
	_nxmipsrc := &NxmIpSrc{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmIpSrc packet too short: %d < 4", decoder.Length())
	}
	_nxmipsrc.Value = net.IP(decoder.Read(4))
	return _nxmipsrc, nil
}

func NewNxmIpSrc() *NxmIpSrc {
	obj := &NxmIpSrc{
		Oxm: NewOxm(3588),
	}
	return obj
}
func (self *NxmIpSrc) GetOXMName() string {
	return "ip_src"
}

func (self *NxmIpSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIpSrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmIpSrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmIpSrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmIpSrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmIpSrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmIpSrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmIpSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeNxmIpSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpSrcMasked, error) {
	_nxmipsrcmasked := &NxmIpSrcMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmIpSrcMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmipsrcmasked.Value = net.IP(decoder.Read(4))
	_nxmipsrcmasked.ValueMask = net.IP(decoder.Read(4))
	return _nxmipsrcmasked, nil
}

func NewNxmIpSrcMasked() *NxmIpSrcMasked {
	obj := &NxmIpSrcMasked{
		Oxm: NewOxm(3848),
	}
	return obj
}
func (self *NxmIpSrcMasked) GetOXMName() string {
	return "ip_src_masked"
}

func (self *NxmIpSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmIpSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmIpv6Dst struct {
	*Oxm
	Value net.IP
}

type INxmIpv6Dst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmIpv6Dst) GetValue() net.IP {
	return self.Value
}

func (self *NxmIpv6Dst) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmIpv6Dst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeNxmIpv6Dst(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpv6Dst, error) {
	_nxmipv6dst := &NxmIpv6Dst{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmIpv6Dst packet too short: %d < 16", decoder.Length())
	}
	_nxmipv6dst.Value = net.IP(decoder.Read(16))
	return _nxmipv6dst, nil
}

func NewNxmIpv6Dst() *NxmIpv6Dst {
	obj := &NxmIpv6Dst{
		Oxm: NewOxm(75792),
	}
	return obj
}
func (self *NxmIpv6Dst) GetOXMName() string {
	return "ipv6_dst"
}

func (self *NxmIpv6Dst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpv6Dst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIpv6DstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmIpv6DstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmIpv6DstMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmIpv6DstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmIpv6DstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmIpv6DstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmIpv6DstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeNxmIpv6DstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpv6DstMasked, error) {
	_nxmipv6dstmasked := &NxmIpv6DstMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmIpv6DstMasked packet too short: %d < 32", decoder.Length())
	}
	_nxmipv6dstmasked.Value = net.IP(decoder.Read(16))
	_nxmipv6dstmasked.ValueMask = net.IP(decoder.Read(16))
	return _nxmipv6dstmasked, nil
}

func NewNxmIpv6DstMasked() *NxmIpv6DstMasked {
	obj := &NxmIpv6DstMasked{
		Oxm: NewOxm(76064),
	}
	return obj
}
func (self *NxmIpv6DstMasked) GetOXMName() string {
	return "ipv6_dst_masked"
}

func (self *NxmIpv6DstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpv6DstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmIpv6DstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmIpv6Label struct {
	*Oxm
	Value uint32
}

type INxmIpv6Label interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmIpv6Label) GetValue() uint32 {
	return self.Value
}

func (self *NxmIpv6Label) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmIpv6Label) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmIpv6Label(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpv6Label, error) {
	_nxmipv6label := &NxmIpv6Label{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmIpv6Label packet too short: %d < 4", decoder.Length())
	}
	_nxmipv6label.Value = uint32(decoder.ReadUint32())
	return _nxmipv6label, nil
}

func NewNxmIpv6Label() *NxmIpv6Label {
	obj := &NxmIpv6Label{
		Oxm: NewOxm(79364),
	}
	return obj
}
func (self *NxmIpv6Label) GetOXMName() string {
	return "ipv6_label"
}

func (self *NxmIpv6Label) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpv6Label) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIpv6LabelMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmIpv6LabelMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmIpv6LabelMasked) GetValue() uint32 {
	return self.Value
}

func (self *NxmIpv6LabelMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmIpv6LabelMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmIpv6LabelMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmIpv6LabelMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmIpv6LabelMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpv6LabelMasked, error) {
	_nxmipv6labelmasked := &NxmIpv6LabelMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmIpv6LabelMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmipv6labelmasked.Value = uint32(decoder.ReadUint32())
	_nxmipv6labelmasked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmipv6labelmasked, nil
}

func NewNxmIpv6LabelMasked() *NxmIpv6LabelMasked {
	obj := &NxmIpv6LabelMasked{
		Oxm: NewOxm(79624),
	}
	return obj
}
func (self *NxmIpv6LabelMasked) GetOXMName() string {
	return "ipv6_label_masked"
}

func (self *NxmIpv6LabelMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpv6LabelMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmIpv6LabelMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmIpv6Src struct {
	*Oxm
	Value net.IP
}

type INxmIpv6Src interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmIpv6Src) GetValue() net.IP {
	return self.Value
}

func (self *NxmIpv6Src) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmIpv6Src) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeNxmIpv6Src(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpv6Src, error) {
	_nxmipv6src := &NxmIpv6Src{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmIpv6Src packet too short: %d < 16", decoder.Length())
	}
	_nxmipv6src.Value = net.IP(decoder.Read(16))
	return _nxmipv6src, nil
}

func NewNxmIpv6Src() *NxmIpv6Src {
	obj := &NxmIpv6Src{
		Oxm: NewOxm(75280),
	}
	return obj
}
func (self *NxmIpv6Src) GetOXMName() string {
	return "ipv6_src"
}

func (self *NxmIpv6Src) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpv6Src) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmIpv6SrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmIpv6SrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmIpv6SrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmIpv6SrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmIpv6SrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmIpv6SrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmIpv6SrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeNxmIpv6SrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmIpv6SrcMasked, error) {
	_nxmipv6srcmasked := &NxmIpv6SrcMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmIpv6SrcMasked packet too short: %d < 32", decoder.Length())
	}
	_nxmipv6srcmasked.Value = net.IP(decoder.Read(16))
	_nxmipv6srcmasked.ValueMask = net.IP(decoder.Read(16))
	return _nxmipv6srcmasked, nil
}

func NewNxmIpv6SrcMasked() *NxmIpv6SrcMasked {
	obj := &NxmIpv6SrcMasked{
		Oxm: NewOxm(75552),
	}
	return obj
}
func (self *NxmIpv6SrcMasked) GetOXMName() string {
	return "ipv6_src_masked"
}

func (self *NxmIpv6SrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmIpv6SrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmIpv6SrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmMplsTtl struct {
	*Oxm
	Value uint8
}

type INxmMplsTtl interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmMplsTtl) GetValue() uint8 {
	return self.Value
}

func (self *NxmMplsTtl) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmMplsTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmMplsTtl(parent *Oxm, decoder *goloxi.Decoder) (*NxmMplsTtl, error) {
	_nxmmplsttl := &NxmMplsTtl{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmMplsTtl packet too short: %d < 1", decoder.Length())
	}
	_nxmmplsttl.Value = uint8(decoder.ReadByte())
	return _nxmmplsttl, nil
}

func NewNxmMplsTtl() *NxmMplsTtl {
	obj := &NxmMplsTtl{
		Oxm: NewOxm(80897),
	}
	return obj
}
func (self *NxmMplsTtl) GetOXMName() string {
	return "mpls_ttl"
}

func (self *NxmMplsTtl) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmMplsTtl) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmNdSll struct {
	*Oxm
	Value net.HardwareAddr
}

type INxmNdSll interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *NxmNdSll) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmNdSll) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmNdSll) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmNdSll(parent *Oxm, decoder *goloxi.Decoder) (*NxmNdSll, error) {
	_nxmndsll := &NxmNdSll{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("NxmNdSll packet too short: %d < 6", decoder.Length())
	}
	_nxmndsll.Value = net.HardwareAddr(decoder.Read(6))
	return _nxmndsll, nil
}

func NewNxmNdSll() *NxmNdSll {
	obj := &NxmNdSll{
		Oxm: NewOxm(77830),
	}
	return obj
}
func (self *NxmNdSll) GetOXMName() string {
	return "nd_sll"
}

func (self *NxmNdSll) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNdSll) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmNdSllMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type INxmNdSllMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *NxmNdSllMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmNdSllMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmNdSllMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *NxmNdSllMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *NxmNdSllMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmNdSllMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmNdSllMasked, error) {
	_nxmndsllmasked := &NxmNdSllMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("NxmNdSllMasked packet too short: %d < 12", decoder.Length())
	}
	_nxmndsllmasked.Value = net.HardwareAddr(decoder.Read(6))
	_nxmndsllmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _nxmndsllmasked, nil
}

func NewNxmNdSllMasked() *NxmNdSllMasked {
	obj := &NxmNdSllMasked{
		Oxm: NewOxm(78091),
	}
	return obj
}
func (self *NxmNdSllMasked) GetOXMName() string {
	return "nd_sll_masked"
}

func (self *NxmNdSllMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNdSllMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmNdSllMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmNdTarget struct {
	*Oxm
	Value net.IP
}

type INxmNdTarget interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmNdTarget) GetValue() net.IP {
	return self.Value
}

func (self *NxmNdTarget) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmNdTarget) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeNxmNdTarget(parent *Oxm, decoder *goloxi.Decoder) (*NxmNdTarget, error) {
	_nxmndtarget := &NxmNdTarget{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmNdTarget packet too short: %d < 16", decoder.Length())
	}
	_nxmndtarget.Value = net.IP(decoder.Read(16))
	return _nxmndtarget, nil
}

func NewNxmNdTarget() *NxmNdTarget {
	obj := &NxmNdTarget{
		Oxm: NewOxm(77328),
	}
	return obj
}
func (self *NxmNdTarget) GetOXMName() string {
	return "nd_target"
}

func (self *NxmNdTarget) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNdTarget) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmNdTargetMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmNdTargetMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmNdTargetMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmNdTargetMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmNdTargetMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmNdTargetMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmNdTargetMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeNxmNdTargetMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmNdTargetMasked, error) {
	_nxmndtargetmasked := &NxmNdTargetMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmNdTargetMasked packet too short: %d < 32", decoder.Length())
	}
	_nxmndtargetmasked.Value = net.IP(decoder.Read(16))
	_nxmndtargetmasked.ValueMask = net.IP(decoder.Read(16))
	return _nxmndtargetmasked, nil
}

func NewNxmNdTargetMasked() *NxmNdTargetMasked {
	obj := &NxmNdTargetMasked{
		Oxm: NewOxm(77600),
	}
	return obj
}
func (self *NxmNdTargetMasked) GetOXMName() string {
	return "nd_target_masked"
}

func (self *NxmNdTargetMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNdTargetMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmNdTargetMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmNdTll struct {
	*Oxm
	Value net.HardwareAddr
}

type INxmNdTll interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *NxmNdTll) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmNdTll) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmNdTll) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmNdTll(parent *Oxm, decoder *goloxi.Decoder) (*NxmNdTll, error) {
	_nxmndtll := &NxmNdTll{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("NxmNdTll packet too short: %d < 6", decoder.Length())
	}
	_nxmndtll.Value = net.HardwareAddr(decoder.Read(6))
	return _nxmndtll, nil
}

func NewNxmNdTll() *NxmNdTll {
	obj := &NxmNdTll{
		Oxm: NewOxm(78342),
	}
	return obj
}
func (self *NxmNdTll) GetOXMName() string {
	return "nd_tll"
}

func (self *NxmNdTll) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNdTll) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmNdTllMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type INxmNdTllMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *NxmNdTllMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *NxmNdTllMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *NxmNdTllMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *NxmNdTllMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *NxmNdTllMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmNdTllMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmNdTllMasked, error) {
	_nxmndtllmasked := &NxmNdTllMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("NxmNdTllMasked packet too short: %d < 12", decoder.Length())
	}
	_nxmndtllmasked.Value = net.HardwareAddr(decoder.Read(6))
	_nxmndtllmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _nxmndtllmasked, nil
}

func NewNxmNdTllMasked() *NxmNdTllMasked {
	obj := &NxmNdTllMasked{
		Oxm: NewOxm(78603),
	}
	return obj
}
func (self *NxmNdTllMasked) GetOXMName() string {
	return "nd_tll_masked"
}

func (self *NxmNdTllMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNdTllMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmNdTllMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmNwEcn struct {
	*Oxm
	Value uint8
}

type INxmNwEcn interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmNwEcn) GetValue() uint8 {
	return self.Value
}

func (self *NxmNwEcn) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmNwEcn) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmNwEcn(parent *Oxm, decoder *goloxi.Decoder) (*NxmNwEcn, error) {
	_nxmnwecn := &NxmNwEcn{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmNwEcn packet too short: %d < 1", decoder.Length())
	}
	_nxmnwecn.Value = uint8(decoder.ReadByte())
	return _nxmnwecn, nil
}

func NewNxmNwEcn() *NxmNwEcn {
	obj := &NxmNwEcn{
		Oxm: NewOxm(79873),
	}
	return obj
}
func (self *NxmNwEcn) GetOXMName() string {
	return "nw_ecn"
}

func (self *NxmNwEcn) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNwEcn) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmNwProto struct {
	*Oxm
	Value uint8
}

type INxmNwProto interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmNwProto) GetValue() uint8 {
	return self.Value
}

func (self *NxmNwProto) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmNwProto) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmNwProto(parent *Oxm, decoder *goloxi.Decoder) (*NxmNwProto, error) {
	_nxmnwproto := &NxmNwProto{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmNwProto packet too short: %d < 1", decoder.Length())
	}
	_nxmnwproto.Value = uint8(decoder.ReadByte())
	return _nxmnwproto, nil
}

func NewNxmNwProto() *NxmNwProto {
	obj := &NxmNwProto{
		Oxm: NewOxm(3073),
	}
	return obj
}
func (self *NxmNwProto) GetOXMName() string {
	return "nw_proto"
}

func (self *NxmNwProto) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNwProto) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmNwTos struct {
	*Oxm
	Value uint8
}

type INxmNwTos interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmNwTos) GetValue() uint8 {
	return self.Value
}

func (self *NxmNwTos) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmNwTos) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmNwTos(parent *Oxm, decoder *goloxi.Decoder) (*NxmNwTos, error) {
	_nxmnwtos := &NxmNwTos{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmNwTos packet too short: %d < 1", decoder.Length())
	}
	_nxmnwtos.Value = uint8(decoder.ReadByte())
	return _nxmnwtos, nil
}

func NewNxmNwTos() *NxmNwTos {
	obj := &NxmNwTos{
		Oxm: NewOxm(2561),
	}
	return obj
}
func (self *NxmNwTos) GetOXMName() string {
	return "nw_tos"
}

func (self *NxmNwTos) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNwTos) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmNwTtl struct {
	*Oxm
	Value uint8
}

type INxmNwTtl interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmNwTtl) GetValue() uint8 {
	return self.Value
}

func (self *NxmNwTtl) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmNwTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmNwTtl(parent *Oxm, decoder *goloxi.Decoder) (*NxmNwTtl, error) {
	_nxmnwttl := &NxmNwTtl{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmNwTtl packet too short: %d < 1", decoder.Length())
	}
	_nxmnwttl.Value = uint8(decoder.ReadByte())
	return _nxmnwttl, nil
}

func NewNxmNwTtl() *NxmNwTtl {
	obj := &NxmNwTtl{
		Oxm: NewOxm(80385),
	}
	return obj
}
func (self *NxmNwTtl) GetOXMName() string {
	return "nw_ttl"
}

func (self *NxmNwTtl) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmNwTtl) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmPktMark struct {
	*Oxm
	Value uint32
}

type INxmPktMark interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmPktMark) GetValue() uint32 {
	return self.Value
}

func (self *NxmPktMark) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmPktMark) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmPktMark(parent *Oxm, decoder *goloxi.Decoder) (*NxmPktMark, error) {
	_nxmpktmark := &NxmPktMark{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmPktMark packet too short: %d < 4", decoder.Length())
	}
	_nxmpktmark.Value = uint32(decoder.ReadUint32())
	return _nxmpktmark, nil
}

func NewNxmPktMark() *NxmPktMark {
	obj := &NxmPktMark{
		Oxm: NewOxm(82436),
	}
	return obj
}
func (self *NxmPktMark) GetOXMName() string {
	return "pkt_mark"
}

func (self *NxmPktMark) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmPktMark) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmPktMarkMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmPktMarkMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmPktMarkMasked) GetValue() uint32 {
	return self.Value
}

func (self *NxmPktMarkMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmPktMarkMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmPktMarkMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmPktMarkMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmPktMarkMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmPktMarkMasked, error) {
	_nxmpktmarkmasked := &NxmPktMarkMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmPktMarkMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmpktmarkmasked.Value = uint32(decoder.ReadUint32())
	_nxmpktmarkmasked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmpktmarkmasked, nil
}

func NewNxmPktMarkMasked() *NxmPktMarkMasked {
	obj := &NxmPktMarkMasked{
		Oxm: NewOxm(82696),
	}
	return obj
}
func (self *NxmPktMarkMasked) GetOXMName() string {
	return "pkt_mark_masked"
}

func (self *NxmPktMarkMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmPktMarkMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmPktMarkMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmRecircId struct {
	*Oxm
	Value uint32
}

type INxmRecircId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmRecircId) GetValue() uint32 {
	return self.Value
}

func (self *NxmRecircId) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmRecircId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmRecircId(parent *Oxm, decoder *goloxi.Decoder) (*NxmRecircId, error) {
	_nxmrecircid := &NxmRecircId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmRecircId packet too short: %d < 4", decoder.Length())
	}
	_nxmrecircid.Value = uint32(decoder.ReadUint32())
	return _nxmrecircid, nil
}

func NewNxmRecircId() *NxmRecircId {
	obj := &NxmRecircId{
		Oxm: NewOxm(83972),
	}
	return obj
}
func (self *NxmRecircId) GetOXMName() string {
	return "recirc_id"
}

func (self *NxmRecircId) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmRecircId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg0 struct {
	*Oxm
	Value uint32
}

type INxmReg0 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg0) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg0) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg0) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg0(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg0, error) {
	_nxmreg0 := &NxmReg0{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg0 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg0.Value = uint32(decoder.ReadUint32())
	return _nxmreg0, nil
}

func NewNxmReg0() *NxmReg0 {
	obj := &NxmReg0{
		Oxm: NewOxm(65540),
	}
	return obj
}
func (self *NxmReg0) GetOXMName() string {
	return "reg0"
}

func (self *NxmReg0) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg0) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg0Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg0Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg0Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg0Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg0Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg0Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg0Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg0Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg0Masked, error) {
	_nxmreg0masked := &NxmReg0Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg0Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg0masked.Value = uint32(decoder.ReadUint32())
	_nxmreg0masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg0masked, nil
}

func NewNxmReg0Masked() *NxmReg0Masked {
	obj := &NxmReg0Masked{
		Oxm: NewOxm(65800),
	}
	return obj
}
func (self *NxmReg0Masked) GetOXMName() string {
	return "reg0_masked"
}

func (self *NxmReg0Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg0Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg0Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg1 struct {
	*Oxm
	Value uint32
}

type INxmReg1 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg1) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg1) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg1) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg1(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg1, error) {
	_nxmreg1 := &NxmReg1{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg1 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg1.Value = uint32(decoder.ReadUint32())
	return _nxmreg1, nil
}

func NewNxmReg1() *NxmReg1 {
	obj := &NxmReg1{
		Oxm: NewOxm(66052),
	}
	return obj
}
func (self *NxmReg1) GetOXMName() string {
	return "reg1"
}

func (self *NxmReg1) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg1) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg10 struct {
	*Oxm
	Value uint32
}

type INxmReg10 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg10) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg10) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg10) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg10(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg10, error) {
	_nxmreg10 := &NxmReg10{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg10 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg10.Value = uint32(decoder.ReadUint32())
	return _nxmreg10, nil
}

func NewNxmReg10() *NxmReg10 {
	obj := &NxmReg10{
		Oxm: NewOxm(70660),
	}
	return obj
}
func (self *NxmReg10) GetOXMName() string {
	return "reg10"
}

func (self *NxmReg10) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg10) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg10Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg10Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg10Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg10Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg10Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg10Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg10Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg10Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg10Masked, error) {
	_nxmreg10masked := &NxmReg10Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg10Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg10masked.Value = uint32(decoder.ReadUint32())
	_nxmreg10masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg10masked, nil
}

func NewNxmReg10Masked() *NxmReg10Masked {
	obj := &NxmReg10Masked{
		Oxm: NewOxm(70920),
	}
	return obj
}
func (self *NxmReg10Masked) GetOXMName() string {
	return "reg10_masked"
}

func (self *NxmReg10Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg10Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg10Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg11 struct {
	*Oxm
	Value uint32
}

type INxmReg11 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg11) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg11) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg11) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg11(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg11, error) {
	_nxmreg11 := &NxmReg11{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg11 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg11.Value = uint32(decoder.ReadUint32())
	return _nxmreg11, nil
}

func NewNxmReg11() *NxmReg11 {
	obj := &NxmReg11{
		Oxm: NewOxm(71172),
	}
	return obj
}
func (self *NxmReg11) GetOXMName() string {
	return "reg11"
}

func (self *NxmReg11) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg11) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg11Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg11Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg11Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg11Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg11Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg11Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg11Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg11Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg11Masked, error) {
	_nxmreg11masked := &NxmReg11Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg11Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg11masked.Value = uint32(decoder.ReadUint32())
	_nxmreg11masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg11masked, nil
}

func NewNxmReg11Masked() *NxmReg11Masked {
	obj := &NxmReg11Masked{
		Oxm: NewOxm(71432),
	}
	return obj
}
func (self *NxmReg11Masked) GetOXMName() string {
	return "reg11_masked"
}

func (self *NxmReg11Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg11Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg11Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg12 struct {
	*Oxm
	Value uint32
}

type INxmReg12 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg12) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg12) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg12) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg12(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg12, error) {
	_nxmreg12 := &NxmReg12{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg12 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg12.Value = uint32(decoder.ReadUint32())
	return _nxmreg12, nil
}

func NewNxmReg12() *NxmReg12 {
	obj := &NxmReg12{
		Oxm: NewOxm(71684),
	}
	return obj
}
func (self *NxmReg12) GetOXMName() string {
	return "reg12"
}

func (self *NxmReg12) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg12) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg12Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg12Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg12Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg12Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg12Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg12Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg12Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg12Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg12Masked, error) {
	_nxmreg12masked := &NxmReg12Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg12Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg12masked.Value = uint32(decoder.ReadUint32())
	_nxmreg12masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg12masked, nil
}

func NewNxmReg12Masked() *NxmReg12Masked {
	obj := &NxmReg12Masked{
		Oxm: NewOxm(71944),
	}
	return obj
}
func (self *NxmReg12Masked) GetOXMName() string {
	return "reg12_masked"
}

func (self *NxmReg12Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg12Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg12Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg13 struct {
	*Oxm
	Value uint32
}

type INxmReg13 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg13) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg13) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg13) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg13(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg13, error) {
	_nxmreg13 := &NxmReg13{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg13 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg13.Value = uint32(decoder.ReadUint32())
	return _nxmreg13, nil
}

func NewNxmReg13() *NxmReg13 {
	obj := &NxmReg13{
		Oxm: NewOxm(72196),
	}
	return obj
}
func (self *NxmReg13) GetOXMName() string {
	return "reg13"
}

func (self *NxmReg13) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg13) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg13Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg13Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg13Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg13Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg13Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg13Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg13Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg13Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg13Masked, error) {
	_nxmreg13masked := &NxmReg13Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg13Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg13masked.Value = uint32(decoder.ReadUint32())
	_nxmreg13masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg13masked, nil
}

func NewNxmReg13Masked() *NxmReg13Masked {
	obj := &NxmReg13Masked{
		Oxm: NewOxm(72456),
	}
	return obj
}
func (self *NxmReg13Masked) GetOXMName() string {
	return "reg13_masked"
}

func (self *NxmReg13Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg13Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg13Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg14 struct {
	*Oxm
	Value uint32
}

type INxmReg14 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg14) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg14) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg14) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg14(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg14, error) {
	_nxmreg14 := &NxmReg14{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg14 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg14.Value = uint32(decoder.ReadUint32())
	return _nxmreg14, nil
}

func NewNxmReg14() *NxmReg14 {
	obj := &NxmReg14{
		Oxm: NewOxm(72708),
	}
	return obj
}
func (self *NxmReg14) GetOXMName() string {
	return "reg14"
}

func (self *NxmReg14) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg14) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg14Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg14Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg14Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg14Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg14Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg14Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg14Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg14Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg14Masked, error) {
	_nxmreg14masked := &NxmReg14Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg14Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg14masked.Value = uint32(decoder.ReadUint32())
	_nxmreg14masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg14masked, nil
}

func NewNxmReg14Masked() *NxmReg14Masked {
	obj := &NxmReg14Masked{
		Oxm: NewOxm(72968),
	}
	return obj
}
func (self *NxmReg14Masked) GetOXMName() string {
	return "reg14_masked"
}

func (self *NxmReg14Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg14Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg14Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg15 struct {
	*Oxm
	Value uint32
}

type INxmReg15 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg15) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg15) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg15) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg15(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg15, error) {
	_nxmreg15 := &NxmReg15{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg15 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg15.Value = uint32(decoder.ReadUint32())
	return _nxmreg15, nil
}

func NewNxmReg15() *NxmReg15 {
	obj := &NxmReg15{
		Oxm: NewOxm(73220),
	}
	return obj
}
func (self *NxmReg15) GetOXMName() string {
	return "reg15"
}

func (self *NxmReg15) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg15) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg15Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg15Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg15Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg15Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg15Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg15Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg15Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg15Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg15Masked, error) {
	_nxmreg15masked := &NxmReg15Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg15Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg15masked.Value = uint32(decoder.ReadUint32())
	_nxmreg15masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg15masked, nil
}

func NewNxmReg15Masked() *NxmReg15Masked {
	obj := &NxmReg15Masked{
		Oxm: NewOxm(73480),
	}
	return obj
}
func (self *NxmReg15Masked) GetOXMName() string {
	return "reg15_masked"
}

func (self *NxmReg15Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg15Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg15Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg1Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg1Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg1Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg1Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg1Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg1Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg1Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg1Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg1Masked, error) {
	_nxmreg1masked := &NxmReg1Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg1Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg1masked.Value = uint32(decoder.ReadUint32())
	_nxmreg1masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg1masked, nil
}

func NewNxmReg1Masked() *NxmReg1Masked {
	obj := &NxmReg1Masked{
		Oxm: NewOxm(66312),
	}
	return obj
}
func (self *NxmReg1Masked) GetOXMName() string {
	return "reg1_masked"
}

func (self *NxmReg1Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg1Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg1Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg2 struct {
	*Oxm
	Value uint32
}

type INxmReg2 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg2) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg2) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg2) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg2(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg2, error) {
	_nxmreg2 := &NxmReg2{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg2 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg2.Value = uint32(decoder.ReadUint32())
	return _nxmreg2, nil
}

func NewNxmReg2() *NxmReg2 {
	obj := &NxmReg2{
		Oxm: NewOxm(66564),
	}
	return obj
}
func (self *NxmReg2) GetOXMName() string {
	return "reg2"
}

func (self *NxmReg2) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg2) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg2Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg2Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg2Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg2Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg2Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg2Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg2Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg2Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg2Masked, error) {
	_nxmreg2masked := &NxmReg2Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg2Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg2masked.Value = uint32(decoder.ReadUint32())
	_nxmreg2masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg2masked, nil
}

func NewNxmReg2Masked() *NxmReg2Masked {
	obj := &NxmReg2Masked{
		Oxm: NewOxm(66824),
	}
	return obj
}
func (self *NxmReg2Masked) GetOXMName() string {
	return "reg2_masked"
}

func (self *NxmReg2Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg2Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg2Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg3 struct {
	*Oxm
	Value uint32
}

type INxmReg3 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg3) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg3) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg3) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg3(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg3, error) {
	_nxmreg3 := &NxmReg3{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg3 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg3.Value = uint32(decoder.ReadUint32())
	return _nxmreg3, nil
}

func NewNxmReg3() *NxmReg3 {
	obj := &NxmReg3{
		Oxm: NewOxm(67076),
	}
	return obj
}
func (self *NxmReg3) GetOXMName() string {
	return "reg3"
}

func (self *NxmReg3) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg3) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg3Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg3Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg3Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg3Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg3Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg3Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg3Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg3Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg3Masked, error) {
	_nxmreg3masked := &NxmReg3Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg3Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg3masked.Value = uint32(decoder.ReadUint32())
	_nxmreg3masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg3masked, nil
}

func NewNxmReg3Masked() *NxmReg3Masked {
	obj := &NxmReg3Masked{
		Oxm: NewOxm(67336),
	}
	return obj
}
func (self *NxmReg3Masked) GetOXMName() string {
	return "reg3_masked"
}

func (self *NxmReg3Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg3Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg3Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg4 struct {
	*Oxm
	Value uint32
}

type INxmReg4 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg4) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg4) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg4) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg4(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg4, error) {
	_nxmreg4 := &NxmReg4{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg4 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg4.Value = uint32(decoder.ReadUint32())
	return _nxmreg4, nil
}

func NewNxmReg4() *NxmReg4 {
	obj := &NxmReg4{
		Oxm: NewOxm(67588),
	}
	return obj
}
func (self *NxmReg4) GetOXMName() string {
	return "reg4"
}

func (self *NxmReg4) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg4) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg4Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg4Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg4Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg4Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg4Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg4Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg4Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg4Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg4Masked, error) {
	_nxmreg4masked := &NxmReg4Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg4Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg4masked.Value = uint32(decoder.ReadUint32())
	_nxmreg4masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg4masked, nil
}

func NewNxmReg4Masked() *NxmReg4Masked {
	obj := &NxmReg4Masked{
		Oxm: NewOxm(67848),
	}
	return obj
}
func (self *NxmReg4Masked) GetOXMName() string {
	return "reg4_masked"
}

func (self *NxmReg4Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg4Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg4Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg5 struct {
	*Oxm
	Value uint32
}

type INxmReg5 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg5) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg5) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg5) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg5(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg5, error) {
	_nxmreg5 := &NxmReg5{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg5 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg5.Value = uint32(decoder.ReadUint32())
	return _nxmreg5, nil
}

func NewNxmReg5() *NxmReg5 {
	obj := &NxmReg5{
		Oxm: NewOxm(68100),
	}
	return obj
}
func (self *NxmReg5) GetOXMName() string {
	return "reg5"
}

func (self *NxmReg5) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg5) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg5Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg5Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg5Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg5Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg5Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg5Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg5Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg5Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg5Masked, error) {
	_nxmreg5masked := &NxmReg5Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg5Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg5masked.Value = uint32(decoder.ReadUint32())
	_nxmreg5masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg5masked, nil
}

func NewNxmReg5Masked() *NxmReg5Masked {
	obj := &NxmReg5Masked{
		Oxm: NewOxm(68360),
	}
	return obj
}
func (self *NxmReg5Masked) GetOXMName() string {
	return "reg5_masked"
}

func (self *NxmReg5Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg5Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg5Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg6 struct {
	*Oxm
	Value uint32
}

type INxmReg6 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg6) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg6) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg6) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg6(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg6, error) {
	_nxmreg6 := &NxmReg6{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg6 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg6.Value = uint32(decoder.ReadUint32())
	return _nxmreg6, nil
}

func NewNxmReg6() *NxmReg6 {
	obj := &NxmReg6{
		Oxm: NewOxm(68612),
	}
	return obj
}
func (self *NxmReg6) GetOXMName() string {
	return "reg6"
}

func (self *NxmReg6) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg6) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg6Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg6Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg6Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg6Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg6Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg6Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg6Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg6Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg6Masked, error) {
	_nxmreg6masked := &NxmReg6Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg6Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg6masked.Value = uint32(decoder.ReadUint32())
	_nxmreg6masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg6masked, nil
}

func NewNxmReg6Masked() *NxmReg6Masked {
	obj := &NxmReg6Masked{
		Oxm: NewOxm(68872),
	}
	return obj
}
func (self *NxmReg6Masked) GetOXMName() string {
	return "reg6_masked"
}

func (self *NxmReg6Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg6Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg6Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg7 struct {
	*Oxm
	Value uint32
}

type INxmReg7 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg7) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg7) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg7) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg7(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg7, error) {
	_nxmreg7 := &NxmReg7{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg7 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg7.Value = uint32(decoder.ReadUint32())
	return _nxmreg7, nil
}

func NewNxmReg7() *NxmReg7 {
	obj := &NxmReg7{
		Oxm: NewOxm(69124),
	}
	return obj
}
func (self *NxmReg7) GetOXMName() string {
	return "reg7"
}

func (self *NxmReg7) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg7) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg7Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg7Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg7Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg7Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg7Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg7Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg7Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg7Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg7Masked, error) {
	_nxmreg7masked := &NxmReg7Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg7Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg7masked.Value = uint32(decoder.ReadUint32())
	_nxmreg7masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg7masked, nil
}

func NewNxmReg7Masked() *NxmReg7Masked {
	obj := &NxmReg7Masked{
		Oxm: NewOxm(69384),
	}
	return obj
}
func (self *NxmReg7Masked) GetOXMName() string {
	return "reg7_masked"
}

func (self *NxmReg7Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg7Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg7Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg8 struct {
	*Oxm
	Value uint32
}

type INxmReg8 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg8) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg8) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg8) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg8(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg8, error) {
	_nxmreg8 := &NxmReg8{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg8 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg8.Value = uint32(decoder.ReadUint32())
	return _nxmreg8, nil
}

func NewNxmReg8() *NxmReg8 {
	obj := &NxmReg8{
		Oxm: NewOxm(69636),
	}
	return obj
}
func (self *NxmReg8) GetOXMName() string {
	return "reg8"
}

func (self *NxmReg8) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg8) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg8Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg8Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg8Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg8Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg8Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg8Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg8Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg8Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg8Masked, error) {
	_nxmreg8masked := &NxmReg8Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg8Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg8masked.Value = uint32(decoder.ReadUint32())
	_nxmreg8masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg8masked, nil
}

func NewNxmReg8Masked() *NxmReg8Masked {
	obj := &NxmReg8Masked{
		Oxm: NewOxm(69896),
	}
	return obj
}
func (self *NxmReg8Masked) GetOXMName() string {
	return "reg8_masked"
}

func (self *NxmReg8Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg8Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg8Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmReg9 struct {
	*Oxm
	Value uint32
}

type INxmReg9 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *NxmReg9) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg9) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg9) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeNxmReg9(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg9, error) {
	_nxmreg9 := &NxmReg9{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmReg9 packet too short: %d < 4", decoder.Length())
	}
	_nxmreg9.Value = uint32(decoder.ReadUint32())
	return _nxmreg9, nil
}

func NewNxmReg9() *NxmReg9 {
	obj := &NxmReg9{
		Oxm: NewOxm(70148),
	}
	return obj
}
func (self *NxmReg9) GetOXMName() string {
	return "reg9"
}

func (self *NxmReg9) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg9) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmReg9Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type INxmReg9Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *NxmReg9Masked) GetValue() uint32 {
	return self.Value
}

func (self *NxmReg9Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *NxmReg9Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *NxmReg9Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *NxmReg9Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeNxmReg9Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmReg9Masked, error) {
	_nxmreg9masked := &NxmReg9Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmReg9Masked packet too short: %d < 8", decoder.Length())
	}
	_nxmreg9masked.Value = uint32(decoder.ReadUint32())
	_nxmreg9masked.ValueMask = uint32(decoder.ReadUint32())
	return _nxmreg9masked, nil
}

func NewNxmReg9Masked() *NxmReg9Masked {
	obj := &NxmReg9Masked{
		Oxm: NewOxm(70408),
	}
	return obj
}
func (self *NxmReg9Masked) GetOXMName() string {
	return "reg9_masked"
}

func (self *NxmReg9Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmReg9Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmReg9Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTcpDst struct {
	*Oxm
	Value uint16
}

type INxmTcpDst interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmTcpDst) GetValue() uint16 {
	return self.Value
}

func (self *NxmTcpDst) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmTcpDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmTcpDst(parent *Oxm, decoder *goloxi.Decoder) (*NxmTcpDst, error) {
	_nxmtcpdst := &NxmTcpDst{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmTcpDst packet too short: %d < 2", decoder.Length())
	}
	_nxmtcpdst.Value = uint16(decoder.ReadUint16())
	return _nxmtcpdst, nil
}

func NewNxmTcpDst() *NxmTcpDst {
	obj := &NxmTcpDst{
		Oxm: NewOxm(5122),
	}
	return obj
}
func (self *NxmTcpDst) GetOXMName() string {
	return "tcp_dst"
}

func (self *NxmTcpDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTcpDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTcpDstMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type INxmTcpDstMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *NxmTcpDstMasked) GetValue() uint16 {
	return self.Value
}

func (self *NxmTcpDstMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmTcpDstMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmTcpDstMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmTcpDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmTcpDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTcpDstMasked, error) {
	_nxmtcpdstmasked := &NxmTcpDstMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmTcpDstMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmtcpdstmasked.Value = uint16(decoder.ReadUint16())
	_nxmtcpdstmasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmtcpdstmasked, nil
}

func NewNxmTcpDstMasked() *NxmTcpDstMasked {
	obj := &NxmTcpDstMasked{
		Oxm: NewOxm(5378),
	}
	return obj
}
func (self *NxmTcpDstMasked) GetOXMName() string {
	return "tcp_dst_masked"
}

func (self *NxmTcpDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTcpDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTcpDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTcpFlags struct {
	*Oxm
	Value TcpFlags
}

type INxmTcpFlags interface {
	goloxi.IOxm
	GetValue() TcpFlags
}

func (self *NxmTcpFlags) GetValue() TcpFlags {
	return self.Value
}

func (self *NxmTcpFlags) SetValue(v TcpFlags) {
	self.Value = v
}

func (self *NxmTcpFlags) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmTcpFlags(parent *Oxm, decoder *goloxi.Decoder) (*NxmTcpFlags, error) {
	_nxmtcpflags := &NxmTcpFlags{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmTcpFlags packet too short: %d < 2", decoder.Length())
	}
	_nxmtcpflags.Value = TcpFlags(decoder.ReadUint16())
	return _nxmtcpflags, nil
}

func NewNxmTcpFlags() *NxmTcpFlags {
	obj := &NxmTcpFlags{
		Oxm: NewOxm(82946),
	}
	return obj
}
func (self *NxmTcpFlags) GetOXMName() string {
	return "tcp_flags"
}

func (self *NxmTcpFlags) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTcpFlags) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTcpFlagsMasked struct {
	*Oxm
	Value     TcpFlags
	ValueMask uint16
}

type INxmTcpFlagsMasked interface {
	goloxi.IOxm
	GetValue() TcpFlags
	GetValueMask() uint16
}

func (self *NxmTcpFlagsMasked) GetValue() TcpFlags {
	return self.Value
}

func (self *NxmTcpFlagsMasked) SetValue(v TcpFlags) {
	self.Value = v
}

func (self *NxmTcpFlagsMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmTcpFlagsMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmTcpFlagsMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmTcpFlagsMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTcpFlagsMasked, error) {
	_nxmtcpflagsmasked := &NxmTcpFlagsMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmTcpFlagsMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmtcpflagsmasked.Value = TcpFlags(decoder.ReadUint16())
	_nxmtcpflagsmasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmtcpflagsmasked, nil
}

func NewNxmTcpFlagsMasked() *NxmTcpFlagsMasked {
	obj := &NxmTcpFlagsMasked{
		Oxm: NewOxm(83204),
	}
	return obj
}
func (self *NxmTcpFlagsMasked) GetOXMName() string {
	return "tcp_flags_masked"
}

func (self *NxmTcpFlagsMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTcpFlagsMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTcpFlagsMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTcpSrc struct {
	*Oxm
	Value uint16
}

type INxmTcpSrc interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmTcpSrc) GetValue() uint16 {
	return self.Value
}

func (self *NxmTcpSrc) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmTcpSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmTcpSrc(parent *Oxm, decoder *goloxi.Decoder) (*NxmTcpSrc, error) {
	_nxmtcpsrc := &NxmTcpSrc{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmTcpSrc packet too short: %d < 2", decoder.Length())
	}
	_nxmtcpsrc.Value = uint16(decoder.ReadUint16())
	return _nxmtcpsrc, nil
}

func NewNxmTcpSrc() *NxmTcpSrc {
	obj := &NxmTcpSrc{
		Oxm: NewOxm(4610),
	}
	return obj
}
func (self *NxmTcpSrc) GetOXMName() string {
	return "tcp_src"
}

func (self *NxmTcpSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTcpSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTcpSrcMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type INxmTcpSrcMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *NxmTcpSrcMasked) GetValue() uint16 {
	return self.Value
}

func (self *NxmTcpSrcMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmTcpSrcMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmTcpSrcMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmTcpSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmTcpSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTcpSrcMasked, error) {
	_nxmtcpsrcmasked := &NxmTcpSrcMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmTcpSrcMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmtcpsrcmasked.Value = uint16(decoder.ReadUint16())
	_nxmtcpsrcmasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmtcpsrcmasked, nil
}

func NewNxmTcpSrcMasked() *NxmTcpSrcMasked {
	obj := &NxmTcpSrcMasked{
		Oxm: NewOxm(4868),
	}
	return obj
}
func (self *NxmTcpSrcMasked) GetOXMName() string {
	return "tcp_src_masked"
}

func (self *NxmTcpSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTcpSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTcpSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunDst struct {
	*Oxm
	Value net.IP
}

type INxmTunDst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmTunDst) GetValue() net.IP {
	return self.Value
}

func (self *NxmTunDst) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmTunDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeNxmTunDst(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunDst, error) {
	_nxmtundst := &NxmTunDst{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmTunDst packet too short: %d < 4", decoder.Length())
	}
	_nxmtundst.Value = net.IP(decoder.Read(4))
	return _nxmtundst, nil
}

func NewNxmTunDst() *NxmTunDst {
	obj := &NxmTunDst{
		Oxm: NewOxm(81924),
	}
	return obj
}
func (self *NxmTunDst) GetOXMName() string {
	return "tun_dst"
}

func (self *NxmTunDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunDstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmTunDstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmTunDstMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmTunDstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmTunDstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmTunDstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmTunDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeNxmTunDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunDstMasked, error) {
	_nxmtundstmasked := &NxmTunDstMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmTunDstMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmtundstmasked.Value = net.IP(decoder.Read(4))
	_nxmtundstmasked.ValueMask = net.IP(decoder.Read(4))
	return _nxmtundstmasked, nil
}

func NewNxmTunDstMasked() *NxmTunDstMasked {
	obj := &NxmTunDstMasked{
		Oxm: NewOxm(82184),
	}
	return obj
}
func (self *NxmTunDstMasked) GetOXMName() string {
	return "tun_dst_masked"
}

func (self *NxmTunDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunFlags struct {
	*Oxm
	Value uint16
}

type INxmTunFlags interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmTunFlags) GetValue() uint16 {
	return self.Value
}

func (self *NxmTunFlags) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmTunFlags) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmTunFlags(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunFlags, error) {
	_nxmtunflags := &NxmTunFlags{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmTunFlags packet too short: %d < 2", decoder.Length())
	}
	_nxmtunflags.Value = uint16(decoder.ReadUint16())
	return _nxmtunflags, nil
}

func NewNxmTunFlags() *NxmTunFlags {
	obj := &NxmTunFlags{
		Oxm: NewOxm(118786),
	}
	return obj
}
func (self *NxmTunFlags) GetOXMName() string {
	return "tun_flags"
}

func (self *NxmTunFlags) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunFlags) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunFlagsMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type INxmTunFlagsMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *NxmTunFlagsMasked) GetValue() uint16 {
	return self.Value
}

func (self *NxmTunFlagsMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmTunFlagsMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmTunFlagsMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmTunFlagsMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmTunFlagsMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunFlagsMasked, error) {
	_nxmtunflagsmasked := &NxmTunFlagsMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmTunFlagsMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmtunflagsmasked.Value = uint16(decoder.ReadUint16())
	_nxmtunflagsmasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmtunflagsmasked, nil
}

func NewNxmTunFlagsMasked() *NxmTunFlagsMasked {
	obj := &NxmTunFlagsMasked{
		Oxm: NewOxm(119044),
	}
	return obj
}
func (self *NxmTunFlagsMasked) GetOXMName() string {
	return "tun_flags_masked"
}

func (self *NxmTunFlagsMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunFlagsMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunFlagsMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunGbpFlags struct {
	*Oxm
	Value uint8
}

type INxmTunGbpFlags interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *NxmTunGbpFlags) GetValue() uint8 {
	return self.Value
}

func (self *NxmTunGbpFlags) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmTunGbpFlags) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeNxmTunGbpFlags(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunGbpFlags, error) {
	_nxmtungbpflags := &NxmTunGbpFlags{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("NxmTunGbpFlags packet too short: %d < 1", decoder.Length())
	}
	_nxmtungbpflags.Value = uint8(decoder.ReadByte())
	return _nxmtungbpflags, nil
}

func NewNxmTunGbpFlags() *NxmTunGbpFlags {
	obj := &NxmTunGbpFlags{
		Oxm: NewOxm(85505),
	}
	return obj
}
func (self *NxmTunGbpFlags) GetOXMName() string {
	return "tun_gbp_flags"
}

func (self *NxmTunGbpFlags) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunGbpFlags) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunGbpFlagsMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type INxmTunGbpFlagsMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *NxmTunGbpFlagsMasked) GetValue() uint8 {
	return self.Value
}

func (self *NxmTunGbpFlagsMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *NxmTunGbpFlagsMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *NxmTunGbpFlagsMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *NxmTunGbpFlagsMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeNxmTunGbpFlagsMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunGbpFlagsMasked, error) {
	_nxmtungbpflagsmasked := &NxmTunGbpFlagsMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmTunGbpFlagsMasked packet too short: %d < 2", decoder.Length())
	}
	_nxmtungbpflagsmasked.Value = uint8(decoder.ReadByte())
	_nxmtungbpflagsmasked.ValueMask = uint8(decoder.ReadByte())
	return _nxmtungbpflagsmasked, nil
}

func NewNxmTunGbpFlagsMasked() *NxmTunGbpFlagsMasked {
	obj := &NxmTunGbpFlagsMasked{
		Oxm: NewOxm(85762),
	}
	return obj
}
func (self *NxmTunGbpFlagsMasked) GetOXMName() string {
	return "tun_gbp_flags_masked"
}

func (self *NxmTunGbpFlagsMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunGbpFlagsMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunGbpFlagsMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunGbpId struct {
	*Oxm
	Value uint16
}

type INxmTunGbpId interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmTunGbpId) GetValue() uint16 {
	return self.Value
}

func (self *NxmTunGbpId) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmTunGbpId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmTunGbpId(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunGbpId, error) {
	_nxmtungbpid := &NxmTunGbpId{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmTunGbpId packet too short: %d < 2", decoder.Length())
	}
	_nxmtungbpid.Value = uint16(decoder.ReadUint16())
	return _nxmtungbpid, nil
}

func NewNxmTunGbpId() *NxmTunGbpId {
	obj := &NxmTunGbpId{
		Oxm: NewOxm(84994),
	}
	return obj
}
func (self *NxmTunGbpId) GetOXMName() string {
	return "tun_gbp_id"
}

func (self *NxmTunGbpId) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunGbpId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunGbpIdMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type INxmTunGbpIdMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *NxmTunGbpIdMasked) GetValue() uint16 {
	return self.Value
}

func (self *NxmTunGbpIdMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmTunGbpIdMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmTunGbpIdMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmTunGbpIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmTunGbpIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunGbpIdMasked, error) {
	_nxmtungbpidmasked := &NxmTunGbpIdMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmTunGbpIdMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmtungbpidmasked.Value = uint16(decoder.ReadUint16())
	_nxmtungbpidmasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmtungbpidmasked, nil
}

func NewNxmTunGbpIdMasked() *NxmTunGbpIdMasked {
	obj := &NxmTunGbpIdMasked{
		Oxm: NewOxm(85252),
	}
	return obj
}
func (self *NxmTunGbpIdMasked) GetOXMName() string {
	return "tun_gbp_id_masked"
}

func (self *NxmTunGbpIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunGbpIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunGbpIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunId struct {
	*Oxm
	Value uint64
}

type INxmTunId interface {
	goloxi.IOxm
	GetValue() uint64
}

func (self *NxmTunId) GetValue() uint64 {
	return self.Value
}

func (self *NxmTunId) SetValue(v uint64) {
	self.Value = v
}

func (self *NxmTunId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint64(uint64(self.Value))

	return nil
}

func DecodeNxmTunId(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunId, error) {
	_nxmtunid := &NxmTunId{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmTunId packet too short: %d < 8", decoder.Length())
	}
	_nxmtunid.Value = uint64(decoder.ReadUint64())
	return _nxmtunid, nil
}

func NewNxmTunId() *NxmTunId {
	obj := &NxmTunId{
		Oxm: NewOxm(73736),
	}
	return obj
}
func (self *NxmTunId) GetOXMName() string {
	return "tun_id"
}

func (self *NxmTunId) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunIdMasked struct {
	*Oxm
	Value     uint64
	ValueMask uint64
}

type INxmTunIdMasked interface {
	goloxi.IOxm
	GetValue() uint64
	GetValueMask() uint64
}

func (self *NxmTunIdMasked) GetValue() uint64 {
	return self.Value
}

func (self *NxmTunIdMasked) SetValue(v uint64) {
	self.Value = v
}

func (self *NxmTunIdMasked) GetValueMask() uint64 {
	return self.ValueMask
}

func (self *NxmTunIdMasked) SetValueMask(v uint64) {
	self.ValueMask = v
}

func (self *NxmTunIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint64(uint64(self.Value))
	encoder.PutUint64(uint64(self.ValueMask))

	return nil
}

func DecodeNxmTunIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunIdMasked, error) {
	_nxmtunidmasked := &NxmTunIdMasked{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmTunIdMasked packet too short: %d < 16", decoder.Length())
	}
	_nxmtunidmasked.Value = uint64(decoder.ReadUint64())
	_nxmtunidmasked.ValueMask = uint64(decoder.ReadUint64())
	return _nxmtunidmasked, nil
}

func NewNxmTunIdMasked() *NxmTunIdMasked {
	obj := &NxmTunIdMasked{
		Oxm: NewOxm(74000),
	}
	return obj
}
func (self *NxmTunIdMasked) GetOXMName() string {
	return "tun_id_masked"
}

func (self *NxmTunIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunIpv6Dst struct {
	*Oxm
	Value net.IP
}

type INxmTunIpv6Dst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmTunIpv6Dst) GetValue() net.IP {
	return self.Value
}

func (self *NxmTunIpv6Dst) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmTunIpv6Dst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeNxmTunIpv6Dst(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunIpv6Dst, error) {
	_nxmtunipv6dst := &NxmTunIpv6Dst{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmTunIpv6Dst packet too short: %d < 16", decoder.Length())
	}
	_nxmtunipv6dst.Value = net.IP(decoder.Read(16))
	return _nxmtunipv6dst, nil
}

func NewNxmTunIpv6Dst() *NxmTunIpv6Dst {
	obj := &NxmTunIpv6Dst{
		Oxm: NewOxm(121872),
	}
	return obj
}
func (self *NxmTunIpv6Dst) GetOXMName() string {
	return "tun_ipv6_dst"
}

func (self *NxmTunIpv6Dst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunIpv6Dst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunIpv6DstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmTunIpv6DstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmTunIpv6DstMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmTunIpv6DstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmTunIpv6DstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmTunIpv6DstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmTunIpv6DstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeNxmTunIpv6DstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunIpv6DstMasked, error) {
	_nxmtunipv6dstmasked := &NxmTunIpv6DstMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmTunIpv6DstMasked packet too short: %d < 32", decoder.Length())
	}
	_nxmtunipv6dstmasked.Value = net.IP(decoder.Read(16))
	_nxmtunipv6dstmasked.ValueMask = net.IP(decoder.Read(16))
	return _nxmtunipv6dstmasked, nil
}

func NewNxmTunIpv6DstMasked() *NxmTunIpv6DstMasked {
	obj := &NxmTunIpv6DstMasked{
		Oxm: NewOxm(122144),
	}
	return obj
}
func (self *NxmTunIpv6DstMasked) GetOXMName() string {
	return "tun_ipv6_dst_masked"
}

func (self *NxmTunIpv6DstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunIpv6DstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunIpv6DstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunIpv6Src struct {
	*Oxm
	Value net.IP
}

type INxmTunIpv6Src interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmTunIpv6Src) GetValue() net.IP {
	return self.Value
}

func (self *NxmTunIpv6Src) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmTunIpv6Src) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeNxmTunIpv6Src(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunIpv6Src, error) {
	_nxmtunipv6src := &NxmTunIpv6Src{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmTunIpv6Src packet too short: %d < 16", decoder.Length())
	}
	_nxmtunipv6src.Value = net.IP(decoder.Read(16))
	return _nxmtunipv6src, nil
}

func NewNxmTunIpv6Src() *NxmTunIpv6Src {
	obj := &NxmTunIpv6Src{
		Oxm: NewOxm(121360),
	}
	return obj
}
func (self *NxmTunIpv6Src) GetOXMName() string {
	return "tun_ipv6_src"
}

func (self *NxmTunIpv6Src) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunIpv6Src) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunIpv6SrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmTunIpv6SrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmTunIpv6SrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmTunIpv6SrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmTunIpv6SrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmTunIpv6SrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmTunIpv6SrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeNxmTunIpv6SrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunIpv6SrcMasked, error) {
	_nxmtunipv6srcmasked := &NxmTunIpv6SrcMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmTunIpv6SrcMasked packet too short: %d < 32", decoder.Length())
	}
	_nxmtunipv6srcmasked.Value = net.IP(decoder.Read(16))
	_nxmtunipv6srcmasked.ValueMask = net.IP(decoder.Read(16))
	return _nxmtunipv6srcmasked, nil
}

func NewNxmTunIpv6SrcMasked() *NxmTunIpv6SrcMasked {
	obj := &NxmTunIpv6SrcMasked{
		Oxm: NewOxm(121632),
	}
	return obj
}
func (self *NxmTunIpv6SrcMasked) GetOXMName() string {
	return "tun_ipv6_src_masked"
}

func (self *NxmTunIpv6SrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunIpv6SrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunIpv6SrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata0 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata0 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata0) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata0) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata0) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata0(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata0, error) {
	_nxmtunmetadata0 := &NxmTunMetadata0{Oxm: parent}
	_nxmtunmetadata0.Value = decoder.Read(int(_nxmtunmetadata0.TypeLen & 0xFF))
	return _nxmtunmetadata0, nil
}

func NewNxmTunMetadata0() *NxmTunMetadata0 {
	obj := &NxmTunMetadata0{
		Oxm: NewOxm(86140),
	}
	return obj
}
func (self *NxmTunMetadata0) GetOXMName() string {
	return "tun_metadata0"
}

func (self *NxmTunMetadata0) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata0) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata0Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata0Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata0Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata0Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata0Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata0Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata0Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata0Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata0Masked, error) {
	_nxmtunmetadata0masked := &NxmTunMetadata0Masked{Oxm: parent}
	_nxmtunmetadata0masked.Value = decoder.Read(int(_nxmtunmetadata0masked.TypeLen & 0xFF))
	_nxmtunmetadata0masked.ValueMask = decoder.Read(int(_nxmtunmetadata0masked.TypeLen & 0xFF))
	return _nxmtunmetadata0masked, nil
}

func NewNxmTunMetadata0Masked() *NxmTunMetadata0Masked {
	obj := &NxmTunMetadata0Masked{
		Oxm: NewOxm(86520),
	}
	return obj
}
func (self *NxmTunMetadata0Masked) GetOXMName() string {
	return "tun_metadata0_masked"
}

func (self *NxmTunMetadata0Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata0Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata0Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata1 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata1 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata1) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata1) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata1) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata1(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata1, error) {
	_nxmtunmetadata1 := &NxmTunMetadata1{Oxm: parent}
	_nxmtunmetadata1.Value = decoder.Read(int(_nxmtunmetadata1.TypeLen & 0xFF))
	return _nxmtunmetadata1, nil
}

func NewNxmTunMetadata1() *NxmTunMetadata1 {
	obj := &NxmTunMetadata1{
		Oxm: NewOxm(86652),
	}
	return obj
}
func (self *NxmTunMetadata1) GetOXMName() string {
	return "tun_metadata1"
}

func (self *NxmTunMetadata1) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata1) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata10 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata10 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata10) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata10) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata10) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata10(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata10, error) {
	_nxmtunmetadata10 := &NxmTunMetadata10{Oxm: parent}
	_nxmtunmetadata10.Value = decoder.Read(int(_nxmtunmetadata10.TypeLen & 0xFF))
	return _nxmtunmetadata10, nil
}

func NewNxmTunMetadata10() *NxmTunMetadata10 {
	obj := &NxmTunMetadata10{
		Oxm: NewOxm(91260),
	}
	return obj
}
func (self *NxmTunMetadata10) GetOXMName() string {
	return "tun_metadata10"
}

func (self *NxmTunMetadata10) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata10) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata10Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata10Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata10Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata10Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata10Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata10Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata10Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata10Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata10Masked, error) {
	_nxmtunmetadata10masked := &NxmTunMetadata10Masked{Oxm: parent}
	_nxmtunmetadata10masked.Value = decoder.Read(int(_nxmtunmetadata10masked.TypeLen & 0xFF))
	_nxmtunmetadata10masked.ValueMask = decoder.Read(int(_nxmtunmetadata10masked.TypeLen & 0xFF))
	return _nxmtunmetadata10masked, nil
}

func NewNxmTunMetadata10Masked() *NxmTunMetadata10Masked {
	obj := &NxmTunMetadata10Masked{
		Oxm: NewOxm(91640),
	}
	return obj
}
func (self *NxmTunMetadata10Masked) GetOXMName() string {
	return "tun_metadata10_masked"
}

func (self *NxmTunMetadata10Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata10Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata10Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata11 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata11 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata11) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata11) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata11) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata11(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata11, error) {
	_nxmtunmetadata11 := &NxmTunMetadata11{Oxm: parent}
	_nxmtunmetadata11.Value = decoder.Read(int(_nxmtunmetadata11.TypeLen & 0xFF))
	return _nxmtunmetadata11, nil
}

func NewNxmTunMetadata11() *NxmTunMetadata11 {
	obj := &NxmTunMetadata11{
		Oxm: NewOxm(91772),
	}
	return obj
}
func (self *NxmTunMetadata11) GetOXMName() string {
	return "tun_metadata11"
}

func (self *NxmTunMetadata11) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata11) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata11Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata11Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata11Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata11Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata11Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata11Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata11Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata11Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata11Masked, error) {
	_nxmtunmetadata11masked := &NxmTunMetadata11Masked{Oxm: parent}
	_nxmtunmetadata11masked.Value = decoder.Read(int(_nxmtunmetadata11masked.TypeLen & 0xFF))
	_nxmtunmetadata11masked.ValueMask = decoder.Read(int(_nxmtunmetadata11masked.TypeLen & 0xFF))
	return _nxmtunmetadata11masked, nil
}

func NewNxmTunMetadata11Masked() *NxmTunMetadata11Masked {
	obj := &NxmTunMetadata11Masked{
		Oxm: NewOxm(92152),
	}
	return obj
}
func (self *NxmTunMetadata11Masked) GetOXMName() string {
	return "tun_metadata11_masked"
}

func (self *NxmTunMetadata11Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata11Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata11Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata12 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata12 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata12) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata12) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata12) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata12(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata12, error) {
	_nxmtunmetadata12 := &NxmTunMetadata12{Oxm: parent}
	_nxmtunmetadata12.Value = decoder.Read(int(_nxmtunmetadata12.TypeLen & 0xFF))
	return _nxmtunmetadata12, nil
}

func NewNxmTunMetadata12() *NxmTunMetadata12 {
	obj := &NxmTunMetadata12{
		Oxm: NewOxm(92284),
	}
	return obj
}
func (self *NxmTunMetadata12) GetOXMName() string {
	return "tun_metadata12"
}

func (self *NxmTunMetadata12) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata12) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata12Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata12Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata12Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata12Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata12Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata12Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata12Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata12Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata12Masked, error) {
	_nxmtunmetadata12masked := &NxmTunMetadata12Masked{Oxm: parent}
	_nxmtunmetadata12masked.Value = decoder.Read(int(_nxmtunmetadata12masked.TypeLen & 0xFF))
	_nxmtunmetadata12masked.ValueMask = decoder.Read(int(_nxmtunmetadata12masked.TypeLen & 0xFF))
	return _nxmtunmetadata12masked, nil
}

func NewNxmTunMetadata12Masked() *NxmTunMetadata12Masked {
	obj := &NxmTunMetadata12Masked{
		Oxm: NewOxm(92664),
	}
	return obj
}
func (self *NxmTunMetadata12Masked) GetOXMName() string {
	return "tun_metadata12_masked"
}

func (self *NxmTunMetadata12Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata12Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata12Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata13 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata13 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata13) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata13) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata13) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata13(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata13, error) {
	_nxmtunmetadata13 := &NxmTunMetadata13{Oxm: parent}
	_nxmtunmetadata13.Value = decoder.Read(int(_nxmtunmetadata13.TypeLen & 0xFF))
	return _nxmtunmetadata13, nil
}

func NewNxmTunMetadata13() *NxmTunMetadata13 {
	obj := &NxmTunMetadata13{
		Oxm: NewOxm(92796),
	}
	return obj
}
func (self *NxmTunMetadata13) GetOXMName() string {
	return "tun_metadata13"
}

func (self *NxmTunMetadata13) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata13) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata13Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata13Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata13Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata13Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata13Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata13Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata13Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata13Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata13Masked, error) {
	_nxmtunmetadata13masked := &NxmTunMetadata13Masked{Oxm: parent}
	_nxmtunmetadata13masked.Value = decoder.Read(int(_nxmtunmetadata13masked.TypeLen & 0xFF))
	_nxmtunmetadata13masked.ValueMask = decoder.Read(int(_nxmtunmetadata13masked.TypeLen & 0xFF))
	return _nxmtunmetadata13masked, nil
}

func NewNxmTunMetadata13Masked() *NxmTunMetadata13Masked {
	obj := &NxmTunMetadata13Masked{
		Oxm: NewOxm(93176),
	}
	return obj
}
func (self *NxmTunMetadata13Masked) GetOXMName() string {
	return "tun_metadata13_masked"
}

func (self *NxmTunMetadata13Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata13Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata13Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata14 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata14 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata14) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata14) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata14) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata14(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata14, error) {
	_nxmtunmetadata14 := &NxmTunMetadata14{Oxm: parent}
	_nxmtunmetadata14.Value = decoder.Read(int(_nxmtunmetadata14.TypeLen & 0xFF))
	return _nxmtunmetadata14, nil
}

func NewNxmTunMetadata14() *NxmTunMetadata14 {
	obj := &NxmTunMetadata14{
		Oxm: NewOxm(93308),
	}
	return obj
}
func (self *NxmTunMetadata14) GetOXMName() string {
	return "tun_metadata14"
}

func (self *NxmTunMetadata14) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata14) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata14Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata14Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata14Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata14Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata14Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata14Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata14Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata14Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata14Masked, error) {
	_nxmtunmetadata14masked := &NxmTunMetadata14Masked{Oxm: parent}
	_nxmtunmetadata14masked.Value = decoder.Read(int(_nxmtunmetadata14masked.TypeLen & 0xFF))
	_nxmtunmetadata14masked.ValueMask = decoder.Read(int(_nxmtunmetadata14masked.TypeLen & 0xFF))
	return _nxmtunmetadata14masked, nil
}

func NewNxmTunMetadata14Masked() *NxmTunMetadata14Masked {
	obj := &NxmTunMetadata14Masked{
		Oxm: NewOxm(93688),
	}
	return obj
}
func (self *NxmTunMetadata14Masked) GetOXMName() string {
	return "tun_metadata14_masked"
}

func (self *NxmTunMetadata14Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata14Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata14Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata15 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata15 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata15) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata15) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata15) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata15(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata15, error) {
	_nxmtunmetadata15 := &NxmTunMetadata15{Oxm: parent}
	_nxmtunmetadata15.Value = decoder.Read(int(_nxmtunmetadata15.TypeLen & 0xFF))
	return _nxmtunmetadata15, nil
}

func NewNxmTunMetadata15() *NxmTunMetadata15 {
	obj := &NxmTunMetadata15{
		Oxm: NewOxm(93820),
	}
	return obj
}
func (self *NxmTunMetadata15) GetOXMName() string {
	return "tun_metadata15"
}

func (self *NxmTunMetadata15) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata15) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata15Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata15Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata15Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata15Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata15Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata15Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata15Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata15Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata15Masked, error) {
	_nxmtunmetadata15masked := &NxmTunMetadata15Masked{Oxm: parent}
	_nxmtunmetadata15masked.Value = decoder.Read(int(_nxmtunmetadata15masked.TypeLen & 0xFF))
	_nxmtunmetadata15masked.ValueMask = decoder.Read(int(_nxmtunmetadata15masked.TypeLen & 0xFF))
	return _nxmtunmetadata15masked, nil
}

func NewNxmTunMetadata15Masked() *NxmTunMetadata15Masked {
	obj := &NxmTunMetadata15Masked{
		Oxm: NewOxm(94200),
	}
	return obj
}
func (self *NxmTunMetadata15Masked) GetOXMName() string {
	return "tun_metadata15_masked"
}

func (self *NxmTunMetadata15Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata15Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata15Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata16 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata16 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata16) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata16) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata16) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata16(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata16, error) {
	_nxmtunmetadata16 := &NxmTunMetadata16{Oxm: parent}
	_nxmtunmetadata16.Value = decoder.Read(int(_nxmtunmetadata16.TypeLen & 0xFF))
	return _nxmtunmetadata16, nil
}

func NewNxmTunMetadata16() *NxmTunMetadata16 {
	obj := &NxmTunMetadata16{
		Oxm: NewOxm(94332),
	}
	return obj
}
func (self *NxmTunMetadata16) GetOXMName() string {
	return "tun_metadata16"
}

func (self *NxmTunMetadata16) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata16) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata16Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata16Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata16Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata16Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata16Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata16Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata16Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata16Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata16Masked, error) {
	_nxmtunmetadata16masked := &NxmTunMetadata16Masked{Oxm: parent}
	_nxmtunmetadata16masked.Value = decoder.Read(int(_nxmtunmetadata16masked.TypeLen & 0xFF))
	_nxmtunmetadata16masked.ValueMask = decoder.Read(int(_nxmtunmetadata16masked.TypeLen & 0xFF))
	return _nxmtunmetadata16masked, nil
}

func NewNxmTunMetadata16Masked() *NxmTunMetadata16Masked {
	obj := &NxmTunMetadata16Masked{
		Oxm: NewOxm(94712),
	}
	return obj
}
func (self *NxmTunMetadata16Masked) GetOXMName() string {
	return "tun_metadata16_masked"
}

func (self *NxmTunMetadata16Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata16Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata16Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata17 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata17 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata17) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata17) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata17) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata17(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata17, error) {
	_nxmtunmetadata17 := &NxmTunMetadata17{Oxm: parent}
	_nxmtunmetadata17.Value = decoder.Read(int(_nxmtunmetadata17.TypeLen & 0xFF))
	return _nxmtunmetadata17, nil
}

func NewNxmTunMetadata17() *NxmTunMetadata17 {
	obj := &NxmTunMetadata17{
		Oxm: NewOxm(94844),
	}
	return obj
}
func (self *NxmTunMetadata17) GetOXMName() string {
	return "tun_metadata17"
}

func (self *NxmTunMetadata17) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata17) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata17Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata17Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata17Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata17Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata17Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata17Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata17Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata17Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata17Masked, error) {
	_nxmtunmetadata17masked := &NxmTunMetadata17Masked{Oxm: parent}
	_nxmtunmetadata17masked.Value = decoder.Read(int(_nxmtunmetadata17masked.TypeLen & 0xFF))
	_nxmtunmetadata17masked.ValueMask = decoder.Read(int(_nxmtunmetadata17masked.TypeLen & 0xFF))
	return _nxmtunmetadata17masked, nil
}

func NewNxmTunMetadata17Masked() *NxmTunMetadata17Masked {
	obj := &NxmTunMetadata17Masked{
		Oxm: NewOxm(95224),
	}
	return obj
}
func (self *NxmTunMetadata17Masked) GetOXMName() string {
	return "tun_metadata17_masked"
}

func (self *NxmTunMetadata17Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata17Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata17Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata18 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata18 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata18) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata18) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata18) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata18(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata18, error) {
	_nxmtunmetadata18 := &NxmTunMetadata18{Oxm: parent}
	_nxmtunmetadata18.Value = decoder.Read(int(_nxmtunmetadata18.TypeLen & 0xFF))
	return _nxmtunmetadata18, nil
}

func NewNxmTunMetadata18() *NxmTunMetadata18 {
	obj := &NxmTunMetadata18{
		Oxm: NewOxm(95356),
	}
	return obj
}
func (self *NxmTunMetadata18) GetOXMName() string {
	return "tun_metadata18"
}

func (self *NxmTunMetadata18) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata18) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata18Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata18Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata18Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata18Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata18Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata18Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata18Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata18Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata18Masked, error) {
	_nxmtunmetadata18masked := &NxmTunMetadata18Masked{Oxm: parent}
	_nxmtunmetadata18masked.Value = decoder.Read(int(_nxmtunmetadata18masked.TypeLen & 0xFF))
	_nxmtunmetadata18masked.ValueMask = decoder.Read(int(_nxmtunmetadata18masked.TypeLen & 0xFF))
	return _nxmtunmetadata18masked, nil
}

func NewNxmTunMetadata18Masked() *NxmTunMetadata18Masked {
	obj := &NxmTunMetadata18Masked{
		Oxm: NewOxm(95736),
	}
	return obj
}
func (self *NxmTunMetadata18Masked) GetOXMName() string {
	return "tun_metadata18_masked"
}

func (self *NxmTunMetadata18Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata18Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata18Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata19 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata19 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata19) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata19) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata19) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata19(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata19, error) {
	_nxmtunmetadata19 := &NxmTunMetadata19{Oxm: parent}
	_nxmtunmetadata19.Value = decoder.Read(int(_nxmtunmetadata19.TypeLen & 0xFF))
	return _nxmtunmetadata19, nil
}

func NewNxmTunMetadata19() *NxmTunMetadata19 {
	obj := &NxmTunMetadata19{
		Oxm: NewOxm(95868),
	}
	return obj
}
func (self *NxmTunMetadata19) GetOXMName() string {
	return "tun_metadata19"
}

func (self *NxmTunMetadata19) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata19) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata19Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata19Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata19Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata19Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata19Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata19Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata19Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata19Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata19Masked, error) {
	_nxmtunmetadata19masked := &NxmTunMetadata19Masked{Oxm: parent}
	_nxmtunmetadata19masked.Value = decoder.Read(int(_nxmtunmetadata19masked.TypeLen & 0xFF))
	_nxmtunmetadata19masked.ValueMask = decoder.Read(int(_nxmtunmetadata19masked.TypeLen & 0xFF))
	return _nxmtunmetadata19masked, nil
}

func NewNxmTunMetadata19Masked() *NxmTunMetadata19Masked {
	obj := &NxmTunMetadata19Masked{
		Oxm: NewOxm(96248),
	}
	return obj
}
func (self *NxmTunMetadata19Masked) GetOXMName() string {
	return "tun_metadata19_masked"
}

func (self *NxmTunMetadata19Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata19Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata19Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata1Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata1Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata1Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata1Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata1Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata1Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata1Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata1Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata1Masked, error) {
	_nxmtunmetadata1masked := &NxmTunMetadata1Masked{Oxm: parent}
	_nxmtunmetadata1masked.Value = decoder.Read(int(_nxmtunmetadata1masked.TypeLen & 0xFF))
	_nxmtunmetadata1masked.ValueMask = decoder.Read(int(_nxmtunmetadata1masked.TypeLen & 0xFF))
	return _nxmtunmetadata1masked, nil
}

func NewNxmTunMetadata1Masked() *NxmTunMetadata1Masked {
	obj := &NxmTunMetadata1Masked{
		Oxm: NewOxm(87032),
	}
	return obj
}
func (self *NxmTunMetadata1Masked) GetOXMName() string {
	return "tun_metadata1_masked"
}

func (self *NxmTunMetadata1Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata1Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata1Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata2 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata2 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata2) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata2) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata2) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata2(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata2, error) {
	_nxmtunmetadata2 := &NxmTunMetadata2{Oxm: parent}
	_nxmtunmetadata2.Value = decoder.Read(int(_nxmtunmetadata2.TypeLen & 0xFF))
	return _nxmtunmetadata2, nil
}

func NewNxmTunMetadata2() *NxmTunMetadata2 {
	obj := &NxmTunMetadata2{
		Oxm: NewOxm(87164),
	}
	return obj
}
func (self *NxmTunMetadata2) GetOXMName() string {
	return "tun_metadata2"
}

func (self *NxmTunMetadata2) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata2) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata20 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata20 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata20) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata20) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata20) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata20(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata20, error) {
	_nxmtunmetadata20 := &NxmTunMetadata20{Oxm: parent}
	_nxmtunmetadata20.Value = decoder.Read(int(_nxmtunmetadata20.TypeLen & 0xFF))
	return _nxmtunmetadata20, nil
}

func NewNxmTunMetadata20() *NxmTunMetadata20 {
	obj := &NxmTunMetadata20{
		Oxm: NewOxm(96380),
	}
	return obj
}
func (self *NxmTunMetadata20) GetOXMName() string {
	return "tun_metadata20"
}

func (self *NxmTunMetadata20) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata20) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata20Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata20Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata20Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata20Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata20Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata20Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata20Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata20Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata20Masked, error) {
	_nxmtunmetadata20masked := &NxmTunMetadata20Masked{Oxm: parent}
	_nxmtunmetadata20masked.Value = decoder.Read(int(_nxmtunmetadata20masked.TypeLen & 0xFF))
	_nxmtunmetadata20masked.ValueMask = decoder.Read(int(_nxmtunmetadata20masked.TypeLen & 0xFF))
	return _nxmtunmetadata20masked, nil
}

func NewNxmTunMetadata20Masked() *NxmTunMetadata20Masked {
	obj := &NxmTunMetadata20Masked{
		Oxm: NewOxm(96760),
	}
	return obj
}
func (self *NxmTunMetadata20Masked) GetOXMName() string {
	return "tun_metadata20_masked"
}

func (self *NxmTunMetadata20Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata20Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata20Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata21 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata21 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata21) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata21) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata21) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata21(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata21, error) {
	_nxmtunmetadata21 := &NxmTunMetadata21{Oxm: parent}
	_nxmtunmetadata21.Value = decoder.Read(int(_nxmtunmetadata21.TypeLen & 0xFF))
	return _nxmtunmetadata21, nil
}

func NewNxmTunMetadata21() *NxmTunMetadata21 {
	obj := &NxmTunMetadata21{
		Oxm: NewOxm(96892),
	}
	return obj
}
func (self *NxmTunMetadata21) GetOXMName() string {
	return "tun_metadata21"
}

func (self *NxmTunMetadata21) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata21) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata21Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata21Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata21Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata21Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata21Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata21Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata21Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata21Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata21Masked, error) {
	_nxmtunmetadata21masked := &NxmTunMetadata21Masked{Oxm: parent}
	_nxmtunmetadata21masked.Value = decoder.Read(int(_nxmtunmetadata21masked.TypeLen & 0xFF))
	_nxmtunmetadata21masked.ValueMask = decoder.Read(int(_nxmtunmetadata21masked.TypeLen & 0xFF))
	return _nxmtunmetadata21masked, nil
}

func NewNxmTunMetadata21Masked() *NxmTunMetadata21Masked {
	obj := &NxmTunMetadata21Masked{
		Oxm: NewOxm(97272),
	}
	return obj
}
func (self *NxmTunMetadata21Masked) GetOXMName() string {
	return "tun_metadata21_masked"
}

func (self *NxmTunMetadata21Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata21Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata21Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata22 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata22 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata22) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata22) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata22) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata22(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata22, error) {
	_nxmtunmetadata22 := &NxmTunMetadata22{Oxm: parent}
	_nxmtunmetadata22.Value = decoder.Read(int(_nxmtunmetadata22.TypeLen & 0xFF))
	return _nxmtunmetadata22, nil
}

func NewNxmTunMetadata22() *NxmTunMetadata22 {
	obj := &NxmTunMetadata22{
		Oxm: NewOxm(97404),
	}
	return obj
}
func (self *NxmTunMetadata22) GetOXMName() string {
	return "tun_metadata22"
}

func (self *NxmTunMetadata22) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata22) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata22Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata22Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata22Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata22Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata22Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata22Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata22Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata22Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata22Masked, error) {
	_nxmtunmetadata22masked := &NxmTunMetadata22Masked{Oxm: parent}
	_nxmtunmetadata22masked.Value = decoder.Read(int(_nxmtunmetadata22masked.TypeLen & 0xFF))
	_nxmtunmetadata22masked.ValueMask = decoder.Read(int(_nxmtunmetadata22masked.TypeLen & 0xFF))
	return _nxmtunmetadata22masked, nil
}

func NewNxmTunMetadata22Masked() *NxmTunMetadata22Masked {
	obj := &NxmTunMetadata22Masked{
		Oxm: NewOxm(97784),
	}
	return obj
}
func (self *NxmTunMetadata22Masked) GetOXMName() string {
	return "tun_metadata22_masked"
}

func (self *NxmTunMetadata22Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata22Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata22Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata23 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata23 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata23) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata23) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata23) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata23(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata23, error) {
	_nxmtunmetadata23 := &NxmTunMetadata23{Oxm: parent}
	_nxmtunmetadata23.Value = decoder.Read(int(_nxmtunmetadata23.TypeLen & 0xFF))
	return _nxmtunmetadata23, nil
}

func NewNxmTunMetadata23() *NxmTunMetadata23 {
	obj := &NxmTunMetadata23{
		Oxm: NewOxm(97916),
	}
	return obj
}
func (self *NxmTunMetadata23) GetOXMName() string {
	return "tun_metadata23"
}

func (self *NxmTunMetadata23) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata23) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata23Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata23Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata23Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata23Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata23Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata23Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata23Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata23Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata23Masked, error) {
	_nxmtunmetadata23masked := &NxmTunMetadata23Masked{Oxm: parent}
	_nxmtunmetadata23masked.Value = decoder.Read(int(_nxmtunmetadata23masked.TypeLen & 0xFF))
	_nxmtunmetadata23masked.ValueMask = decoder.Read(int(_nxmtunmetadata23masked.TypeLen & 0xFF))
	return _nxmtunmetadata23masked, nil
}

func NewNxmTunMetadata23Masked() *NxmTunMetadata23Masked {
	obj := &NxmTunMetadata23Masked{
		Oxm: NewOxm(98296),
	}
	return obj
}
func (self *NxmTunMetadata23Masked) GetOXMName() string {
	return "tun_metadata23_masked"
}

func (self *NxmTunMetadata23Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata23Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata23Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata24 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata24 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata24) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata24) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata24) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata24(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata24, error) {
	_nxmtunmetadata24 := &NxmTunMetadata24{Oxm: parent}
	_nxmtunmetadata24.Value = decoder.Read(int(_nxmtunmetadata24.TypeLen & 0xFF))
	return _nxmtunmetadata24, nil
}

func NewNxmTunMetadata24() *NxmTunMetadata24 {
	obj := &NxmTunMetadata24{
		Oxm: NewOxm(98428),
	}
	return obj
}
func (self *NxmTunMetadata24) GetOXMName() string {
	return "tun_metadata24"
}

func (self *NxmTunMetadata24) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata24) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata24Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata24Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata24Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata24Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata24Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata24Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata24Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata24Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata24Masked, error) {
	_nxmtunmetadata24masked := &NxmTunMetadata24Masked{Oxm: parent}
	_nxmtunmetadata24masked.Value = decoder.Read(int(_nxmtunmetadata24masked.TypeLen & 0xFF))
	_nxmtunmetadata24masked.ValueMask = decoder.Read(int(_nxmtunmetadata24masked.TypeLen & 0xFF))
	return _nxmtunmetadata24masked, nil
}

func NewNxmTunMetadata24Masked() *NxmTunMetadata24Masked {
	obj := &NxmTunMetadata24Masked{
		Oxm: NewOxm(98808),
	}
	return obj
}
func (self *NxmTunMetadata24Masked) GetOXMName() string {
	return "tun_metadata24_masked"
}

func (self *NxmTunMetadata24Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata24Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata24Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata25 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata25 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata25) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata25) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata25) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata25(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata25, error) {
	_nxmtunmetadata25 := &NxmTunMetadata25{Oxm: parent}
	_nxmtunmetadata25.Value = decoder.Read(int(_nxmtunmetadata25.TypeLen & 0xFF))
	return _nxmtunmetadata25, nil
}

func NewNxmTunMetadata25() *NxmTunMetadata25 {
	obj := &NxmTunMetadata25{
		Oxm: NewOxm(98940),
	}
	return obj
}
func (self *NxmTunMetadata25) GetOXMName() string {
	return "tun_metadata25"
}

func (self *NxmTunMetadata25) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata25) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata25Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata25Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata25Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata25Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata25Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata25Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata25Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata25Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata25Masked, error) {
	_nxmtunmetadata25masked := &NxmTunMetadata25Masked{Oxm: parent}
	_nxmtunmetadata25masked.Value = decoder.Read(int(_nxmtunmetadata25masked.TypeLen & 0xFF))
	_nxmtunmetadata25masked.ValueMask = decoder.Read(int(_nxmtunmetadata25masked.TypeLen & 0xFF))
	return _nxmtunmetadata25masked, nil
}

func NewNxmTunMetadata25Masked() *NxmTunMetadata25Masked {
	obj := &NxmTunMetadata25Masked{
		Oxm: NewOxm(99320),
	}
	return obj
}
func (self *NxmTunMetadata25Masked) GetOXMName() string {
	return "tun_metadata25_masked"
}

func (self *NxmTunMetadata25Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata25Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata25Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata26 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata26 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata26) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata26) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata26) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata26(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata26, error) {
	_nxmtunmetadata26 := &NxmTunMetadata26{Oxm: parent}
	_nxmtunmetadata26.Value = decoder.Read(int(_nxmtunmetadata26.TypeLen & 0xFF))
	return _nxmtunmetadata26, nil
}

func NewNxmTunMetadata26() *NxmTunMetadata26 {
	obj := &NxmTunMetadata26{
		Oxm: NewOxm(99452),
	}
	return obj
}
func (self *NxmTunMetadata26) GetOXMName() string {
	return "tun_metadata26"
}

func (self *NxmTunMetadata26) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata26) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata26Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata26Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata26Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata26Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata26Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata26Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata26Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata26Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata26Masked, error) {
	_nxmtunmetadata26masked := &NxmTunMetadata26Masked{Oxm: parent}
	_nxmtunmetadata26masked.Value = decoder.Read(int(_nxmtunmetadata26masked.TypeLen & 0xFF))
	_nxmtunmetadata26masked.ValueMask = decoder.Read(int(_nxmtunmetadata26masked.TypeLen & 0xFF))
	return _nxmtunmetadata26masked, nil
}

func NewNxmTunMetadata26Masked() *NxmTunMetadata26Masked {
	obj := &NxmTunMetadata26Masked{
		Oxm: NewOxm(99832),
	}
	return obj
}
func (self *NxmTunMetadata26Masked) GetOXMName() string {
	return "tun_metadata26_masked"
}

func (self *NxmTunMetadata26Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata26Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata26Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata27 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata27 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata27) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata27) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata27) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata27(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata27, error) {
	_nxmtunmetadata27 := &NxmTunMetadata27{Oxm: parent}
	_nxmtunmetadata27.Value = decoder.Read(int(_nxmtunmetadata27.TypeLen & 0xFF))
	return _nxmtunmetadata27, nil
}

func NewNxmTunMetadata27() *NxmTunMetadata27 {
	obj := &NxmTunMetadata27{
		Oxm: NewOxm(99964),
	}
	return obj
}
func (self *NxmTunMetadata27) GetOXMName() string {
	return "tun_metadata27"
}

func (self *NxmTunMetadata27) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata27) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata27Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata27Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata27Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata27Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata27Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata27Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata27Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata27Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata27Masked, error) {
	_nxmtunmetadata27masked := &NxmTunMetadata27Masked{Oxm: parent}
	_nxmtunmetadata27masked.Value = decoder.Read(int(_nxmtunmetadata27masked.TypeLen & 0xFF))
	_nxmtunmetadata27masked.ValueMask = decoder.Read(int(_nxmtunmetadata27masked.TypeLen & 0xFF))
	return _nxmtunmetadata27masked, nil
}

func NewNxmTunMetadata27Masked() *NxmTunMetadata27Masked {
	obj := &NxmTunMetadata27Masked{
		Oxm: NewOxm(100344),
	}
	return obj
}
func (self *NxmTunMetadata27Masked) GetOXMName() string {
	return "tun_metadata27_masked"
}

func (self *NxmTunMetadata27Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata27Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata27Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata28 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata28 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata28) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata28) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata28) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata28(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata28, error) {
	_nxmtunmetadata28 := &NxmTunMetadata28{Oxm: parent}
	_nxmtunmetadata28.Value = decoder.Read(int(_nxmtunmetadata28.TypeLen & 0xFF))
	return _nxmtunmetadata28, nil
}

func NewNxmTunMetadata28() *NxmTunMetadata28 {
	obj := &NxmTunMetadata28{
		Oxm: NewOxm(100476),
	}
	return obj
}
func (self *NxmTunMetadata28) GetOXMName() string {
	return "tun_metadata28"
}

func (self *NxmTunMetadata28) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata28) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata28Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata28Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata28Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata28Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata28Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata28Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata28Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata28Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata28Masked, error) {
	_nxmtunmetadata28masked := &NxmTunMetadata28Masked{Oxm: parent}
	_nxmtunmetadata28masked.Value = decoder.Read(int(_nxmtunmetadata28masked.TypeLen & 0xFF))
	_nxmtunmetadata28masked.ValueMask = decoder.Read(int(_nxmtunmetadata28masked.TypeLen & 0xFF))
	return _nxmtunmetadata28masked, nil
}

func NewNxmTunMetadata28Masked() *NxmTunMetadata28Masked {
	obj := &NxmTunMetadata28Masked{
		Oxm: NewOxm(100856),
	}
	return obj
}
func (self *NxmTunMetadata28Masked) GetOXMName() string {
	return "tun_metadata28_masked"
}

func (self *NxmTunMetadata28Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata28Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata28Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata29 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata29 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata29) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata29) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata29) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata29(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata29, error) {
	_nxmtunmetadata29 := &NxmTunMetadata29{Oxm: parent}
	_nxmtunmetadata29.Value = decoder.Read(int(_nxmtunmetadata29.TypeLen & 0xFF))
	return _nxmtunmetadata29, nil
}

func NewNxmTunMetadata29() *NxmTunMetadata29 {
	obj := &NxmTunMetadata29{
		Oxm: NewOxm(100988),
	}
	return obj
}
func (self *NxmTunMetadata29) GetOXMName() string {
	return "tun_metadata29"
}

func (self *NxmTunMetadata29) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata29) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata29Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata29Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata29Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata29Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata29Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata29Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata29Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata29Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata29Masked, error) {
	_nxmtunmetadata29masked := &NxmTunMetadata29Masked{Oxm: parent}
	_nxmtunmetadata29masked.Value = decoder.Read(int(_nxmtunmetadata29masked.TypeLen & 0xFF))
	_nxmtunmetadata29masked.ValueMask = decoder.Read(int(_nxmtunmetadata29masked.TypeLen & 0xFF))
	return _nxmtunmetadata29masked, nil
}

func NewNxmTunMetadata29Masked() *NxmTunMetadata29Masked {
	obj := &NxmTunMetadata29Masked{
		Oxm: NewOxm(101368),
	}
	return obj
}
func (self *NxmTunMetadata29Masked) GetOXMName() string {
	return "tun_metadata29_masked"
}

func (self *NxmTunMetadata29Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata29Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata29Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata2Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata2Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata2Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata2Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata2Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata2Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata2Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata2Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata2Masked, error) {
	_nxmtunmetadata2masked := &NxmTunMetadata2Masked{Oxm: parent}
	_nxmtunmetadata2masked.Value = decoder.Read(int(_nxmtunmetadata2masked.TypeLen & 0xFF))
	_nxmtunmetadata2masked.ValueMask = decoder.Read(int(_nxmtunmetadata2masked.TypeLen & 0xFF))
	return _nxmtunmetadata2masked, nil
}

func NewNxmTunMetadata2Masked() *NxmTunMetadata2Masked {
	obj := &NxmTunMetadata2Masked{
		Oxm: NewOxm(87544),
	}
	return obj
}
func (self *NxmTunMetadata2Masked) GetOXMName() string {
	return "tun_metadata2_masked"
}

func (self *NxmTunMetadata2Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata2Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata2Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata3 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata3 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata3) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata3) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata3) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata3(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata3, error) {
	_nxmtunmetadata3 := &NxmTunMetadata3{Oxm: parent}
	_nxmtunmetadata3.Value = decoder.Read(int(_nxmtunmetadata3.TypeLen & 0xFF))
	return _nxmtunmetadata3, nil
}

func NewNxmTunMetadata3() *NxmTunMetadata3 {
	obj := &NxmTunMetadata3{
		Oxm: NewOxm(87676),
	}
	return obj
}
func (self *NxmTunMetadata3) GetOXMName() string {
	return "tun_metadata3"
}

func (self *NxmTunMetadata3) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata3) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata30 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata30 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata30) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata30) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata30) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata30(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata30, error) {
	_nxmtunmetadata30 := &NxmTunMetadata30{Oxm: parent}
	_nxmtunmetadata30.Value = decoder.Read(int(_nxmtunmetadata30.TypeLen & 0xFF))
	return _nxmtunmetadata30, nil
}

func NewNxmTunMetadata30() *NxmTunMetadata30 {
	obj := &NxmTunMetadata30{
		Oxm: NewOxm(101500),
	}
	return obj
}
func (self *NxmTunMetadata30) GetOXMName() string {
	return "tun_metadata30"
}

func (self *NxmTunMetadata30) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata30) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata30Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata30Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata30Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata30Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata30Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata30Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata30Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata30Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata30Masked, error) {
	_nxmtunmetadata30masked := &NxmTunMetadata30Masked{Oxm: parent}
	_nxmtunmetadata30masked.Value = decoder.Read(int(_nxmtunmetadata30masked.TypeLen & 0xFF))
	_nxmtunmetadata30masked.ValueMask = decoder.Read(int(_nxmtunmetadata30masked.TypeLen & 0xFF))
	return _nxmtunmetadata30masked, nil
}

func NewNxmTunMetadata30Masked() *NxmTunMetadata30Masked {
	obj := &NxmTunMetadata30Masked{
		Oxm: NewOxm(101880),
	}
	return obj
}
func (self *NxmTunMetadata30Masked) GetOXMName() string {
	return "tun_metadata30_masked"
}

func (self *NxmTunMetadata30Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata30Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata30Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata31 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata31 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata31) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata31) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata31) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata31(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata31, error) {
	_nxmtunmetadata31 := &NxmTunMetadata31{Oxm: parent}
	_nxmtunmetadata31.Value = decoder.Read(int(_nxmtunmetadata31.TypeLen & 0xFF))
	return _nxmtunmetadata31, nil
}

func NewNxmTunMetadata31() *NxmTunMetadata31 {
	obj := &NxmTunMetadata31{
		Oxm: NewOxm(102012),
	}
	return obj
}
func (self *NxmTunMetadata31) GetOXMName() string {
	return "tun_metadata31"
}

func (self *NxmTunMetadata31) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata31) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata31Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata31Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata31Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata31Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata31Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata31Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata31Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata31Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata31Masked, error) {
	_nxmtunmetadata31masked := &NxmTunMetadata31Masked{Oxm: parent}
	_nxmtunmetadata31masked.Value = decoder.Read(int(_nxmtunmetadata31masked.TypeLen & 0xFF))
	_nxmtunmetadata31masked.ValueMask = decoder.Read(int(_nxmtunmetadata31masked.TypeLen & 0xFF))
	return _nxmtunmetadata31masked, nil
}

func NewNxmTunMetadata31Masked() *NxmTunMetadata31Masked {
	obj := &NxmTunMetadata31Masked{
		Oxm: NewOxm(102392),
	}
	return obj
}
func (self *NxmTunMetadata31Masked) GetOXMName() string {
	return "tun_metadata31_masked"
}

func (self *NxmTunMetadata31Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata31Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata31Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata32 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata32 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata32) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata32) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata32) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata32(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata32, error) {
	_nxmtunmetadata32 := &NxmTunMetadata32{Oxm: parent}
	_nxmtunmetadata32.Value = decoder.Read(int(_nxmtunmetadata32.TypeLen & 0xFF))
	return _nxmtunmetadata32, nil
}

func NewNxmTunMetadata32() *NxmTunMetadata32 {
	obj := &NxmTunMetadata32{
		Oxm: NewOxm(102524),
	}
	return obj
}
func (self *NxmTunMetadata32) GetOXMName() string {
	return "tun_metadata32"
}

func (self *NxmTunMetadata32) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata32) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata32Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata32Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata32Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata32Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata32Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata32Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata32Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata32Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata32Masked, error) {
	_nxmtunmetadata32masked := &NxmTunMetadata32Masked{Oxm: parent}
	_nxmtunmetadata32masked.Value = decoder.Read(int(_nxmtunmetadata32masked.TypeLen & 0xFF))
	_nxmtunmetadata32masked.ValueMask = decoder.Read(int(_nxmtunmetadata32masked.TypeLen & 0xFF))
	return _nxmtunmetadata32masked, nil
}

func NewNxmTunMetadata32Masked() *NxmTunMetadata32Masked {
	obj := &NxmTunMetadata32Masked{
		Oxm: NewOxm(102904),
	}
	return obj
}
func (self *NxmTunMetadata32Masked) GetOXMName() string {
	return "tun_metadata32_masked"
}

func (self *NxmTunMetadata32Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata32Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata32Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata33 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata33 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata33) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata33) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata33) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata33(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata33, error) {
	_nxmtunmetadata33 := &NxmTunMetadata33{Oxm: parent}
	_nxmtunmetadata33.Value = decoder.Read(int(_nxmtunmetadata33.TypeLen & 0xFF))
	return _nxmtunmetadata33, nil
}

func NewNxmTunMetadata33() *NxmTunMetadata33 {
	obj := &NxmTunMetadata33{
		Oxm: NewOxm(103036),
	}
	return obj
}
func (self *NxmTunMetadata33) GetOXMName() string {
	return "tun_metadata33"
}

func (self *NxmTunMetadata33) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata33) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata33Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata33Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata33Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata33Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata33Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata33Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata33Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata33Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata33Masked, error) {
	_nxmtunmetadata33masked := &NxmTunMetadata33Masked{Oxm: parent}
	_nxmtunmetadata33masked.Value = decoder.Read(int(_nxmtunmetadata33masked.TypeLen & 0xFF))
	_nxmtunmetadata33masked.ValueMask = decoder.Read(int(_nxmtunmetadata33masked.TypeLen & 0xFF))
	return _nxmtunmetadata33masked, nil
}

func NewNxmTunMetadata33Masked() *NxmTunMetadata33Masked {
	obj := &NxmTunMetadata33Masked{
		Oxm: NewOxm(103416),
	}
	return obj
}
func (self *NxmTunMetadata33Masked) GetOXMName() string {
	return "tun_metadata33_masked"
}

func (self *NxmTunMetadata33Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata33Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata33Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata34 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata34 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata34) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata34) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata34) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata34(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata34, error) {
	_nxmtunmetadata34 := &NxmTunMetadata34{Oxm: parent}
	_nxmtunmetadata34.Value = decoder.Read(int(_nxmtunmetadata34.TypeLen & 0xFF))
	return _nxmtunmetadata34, nil
}

func NewNxmTunMetadata34() *NxmTunMetadata34 {
	obj := &NxmTunMetadata34{
		Oxm: NewOxm(103548),
	}
	return obj
}
func (self *NxmTunMetadata34) GetOXMName() string {
	return "tun_metadata34"
}

func (self *NxmTunMetadata34) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata34) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata34Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata34Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata34Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata34Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata34Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata34Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata34Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata34Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata34Masked, error) {
	_nxmtunmetadata34masked := &NxmTunMetadata34Masked{Oxm: parent}
	_nxmtunmetadata34masked.Value = decoder.Read(int(_nxmtunmetadata34masked.TypeLen & 0xFF))
	_nxmtunmetadata34masked.ValueMask = decoder.Read(int(_nxmtunmetadata34masked.TypeLen & 0xFF))
	return _nxmtunmetadata34masked, nil
}

func NewNxmTunMetadata34Masked() *NxmTunMetadata34Masked {
	obj := &NxmTunMetadata34Masked{
		Oxm: NewOxm(103928),
	}
	return obj
}
func (self *NxmTunMetadata34Masked) GetOXMName() string {
	return "tun_metadata34_masked"
}

func (self *NxmTunMetadata34Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata34Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata34Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata35 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata35 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata35) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata35) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata35) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata35(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata35, error) {
	_nxmtunmetadata35 := &NxmTunMetadata35{Oxm: parent}
	_nxmtunmetadata35.Value = decoder.Read(int(_nxmtunmetadata35.TypeLen & 0xFF))
	return _nxmtunmetadata35, nil
}

func NewNxmTunMetadata35() *NxmTunMetadata35 {
	obj := &NxmTunMetadata35{
		Oxm: NewOxm(104060),
	}
	return obj
}
func (self *NxmTunMetadata35) GetOXMName() string {
	return "tun_metadata35"
}

func (self *NxmTunMetadata35) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata35) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata35Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata35Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata35Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata35Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata35Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata35Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata35Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata35Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata35Masked, error) {
	_nxmtunmetadata35masked := &NxmTunMetadata35Masked{Oxm: parent}
	_nxmtunmetadata35masked.Value = decoder.Read(int(_nxmtunmetadata35masked.TypeLen & 0xFF))
	_nxmtunmetadata35masked.ValueMask = decoder.Read(int(_nxmtunmetadata35masked.TypeLen & 0xFF))
	return _nxmtunmetadata35masked, nil
}

func NewNxmTunMetadata35Masked() *NxmTunMetadata35Masked {
	obj := &NxmTunMetadata35Masked{
		Oxm: NewOxm(104440),
	}
	return obj
}
func (self *NxmTunMetadata35Masked) GetOXMName() string {
	return "tun_metadata35_masked"
}

func (self *NxmTunMetadata35Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata35Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata35Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata36 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata36 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata36) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata36) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata36) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata36(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata36, error) {
	_nxmtunmetadata36 := &NxmTunMetadata36{Oxm: parent}
	_nxmtunmetadata36.Value = decoder.Read(int(_nxmtunmetadata36.TypeLen & 0xFF))
	return _nxmtunmetadata36, nil
}

func NewNxmTunMetadata36() *NxmTunMetadata36 {
	obj := &NxmTunMetadata36{
		Oxm: NewOxm(104572),
	}
	return obj
}
func (self *NxmTunMetadata36) GetOXMName() string {
	return "tun_metadata36"
}

func (self *NxmTunMetadata36) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata36) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata36Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata36Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata36Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata36Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata36Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata36Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata36Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata36Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata36Masked, error) {
	_nxmtunmetadata36masked := &NxmTunMetadata36Masked{Oxm: parent}
	_nxmtunmetadata36masked.Value = decoder.Read(int(_nxmtunmetadata36masked.TypeLen & 0xFF))
	_nxmtunmetadata36masked.ValueMask = decoder.Read(int(_nxmtunmetadata36masked.TypeLen & 0xFF))
	return _nxmtunmetadata36masked, nil
}

func NewNxmTunMetadata36Masked() *NxmTunMetadata36Masked {
	obj := &NxmTunMetadata36Masked{
		Oxm: NewOxm(104952),
	}
	return obj
}
func (self *NxmTunMetadata36Masked) GetOXMName() string {
	return "tun_metadata36_masked"
}

func (self *NxmTunMetadata36Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata36Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata36Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata37 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata37 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata37) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata37) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata37) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata37(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata37, error) {
	_nxmtunmetadata37 := &NxmTunMetadata37{Oxm: parent}
	_nxmtunmetadata37.Value = decoder.Read(int(_nxmtunmetadata37.TypeLen & 0xFF))
	return _nxmtunmetadata37, nil
}

func NewNxmTunMetadata37() *NxmTunMetadata37 {
	obj := &NxmTunMetadata37{
		Oxm: NewOxm(105084),
	}
	return obj
}
func (self *NxmTunMetadata37) GetOXMName() string {
	return "tun_metadata37"
}

func (self *NxmTunMetadata37) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata37) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata37Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata37Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata37Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata37Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata37Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata37Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata37Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata37Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata37Masked, error) {
	_nxmtunmetadata37masked := &NxmTunMetadata37Masked{Oxm: parent}
	_nxmtunmetadata37masked.Value = decoder.Read(int(_nxmtunmetadata37masked.TypeLen & 0xFF))
	_nxmtunmetadata37masked.ValueMask = decoder.Read(int(_nxmtunmetadata37masked.TypeLen & 0xFF))
	return _nxmtunmetadata37masked, nil
}

func NewNxmTunMetadata37Masked() *NxmTunMetadata37Masked {
	obj := &NxmTunMetadata37Masked{
		Oxm: NewOxm(105464),
	}
	return obj
}
func (self *NxmTunMetadata37Masked) GetOXMName() string {
	return "tun_metadata37_masked"
}

func (self *NxmTunMetadata37Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata37Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata37Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata38 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata38 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata38) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata38) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata38) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata38(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata38, error) {
	_nxmtunmetadata38 := &NxmTunMetadata38{Oxm: parent}
	_nxmtunmetadata38.Value = decoder.Read(int(_nxmtunmetadata38.TypeLen & 0xFF))
	return _nxmtunmetadata38, nil
}

func NewNxmTunMetadata38() *NxmTunMetadata38 {
	obj := &NxmTunMetadata38{
		Oxm: NewOxm(105596),
	}
	return obj
}
func (self *NxmTunMetadata38) GetOXMName() string {
	return "tun_metadata38"
}

func (self *NxmTunMetadata38) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata38) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata38Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata38Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata38Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata38Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata38Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata38Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata38Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata38Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata38Masked, error) {
	_nxmtunmetadata38masked := &NxmTunMetadata38Masked{Oxm: parent}
	_nxmtunmetadata38masked.Value = decoder.Read(int(_nxmtunmetadata38masked.TypeLen & 0xFF))
	_nxmtunmetadata38masked.ValueMask = decoder.Read(int(_nxmtunmetadata38masked.TypeLen & 0xFF))
	return _nxmtunmetadata38masked, nil
}

func NewNxmTunMetadata38Masked() *NxmTunMetadata38Masked {
	obj := &NxmTunMetadata38Masked{
		Oxm: NewOxm(105976),
	}
	return obj
}
func (self *NxmTunMetadata38Masked) GetOXMName() string {
	return "tun_metadata38_masked"
}

func (self *NxmTunMetadata38Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata38Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata38Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata39 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata39 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata39) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata39) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata39) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata39(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata39, error) {
	_nxmtunmetadata39 := &NxmTunMetadata39{Oxm: parent}
	_nxmtunmetadata39.Value = decoder.Read(int(_nxmtunmetadata39.TypeLen & 0xFF))
	return _nxmtunmetadata39, nil
}

func NewNxmTunMetadata39() *NxmTunMetadata39 {
	obj := &NxmTunMetadata39{
		Oxm: NewOxm(106108),
	}
	return obj
}
func (self *NxmTunMetadata39) GetOXMName() string {
	return "tun_metadata39"
}

func (self *NxmTunMetadata39) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata39) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata39Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata39Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata39Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata39Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata39Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata39Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata39Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata39Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata39Masked, error) {
	_nxmtunmetadata39masked := &NxmTunMetadata39Masked{Oxm: parent}
	_nxmtunmetadata39masked.Value = decoder.Read(int(_nxmtunmetadata39masked.TypeLen & 0xFF))
	_nxmtunmetadata39masked.ValueMask = decoder.Read(int(_nxmtunmetadata39masked.TypeLen & 0xFF))
	return _nxmtunmetadata39masked, nil
}

func NewNxmTunMetadata39Masked() *NxmTunMetadata39Masked {
	obj := &NxmTunMetadata39Masked{
		Oxm: NewOxm(106488),
	}
	return obj
}
func (self *NxmTunMetadata39Masked) GetOXMName() string {
	return "tun_metadata39_masked"
}

func (self *NxmTunMetadata39Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata39Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata39Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata3Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata3Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata3Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata3Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata3Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata3Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata3Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata3Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata3Masked, error) {
	_nxmtunmetadata3masked := &NxmTunMetadata3Masked{Oxm: parent}
	_nxmtunmetadata3masked.Value = decoder.Read(int(_nxmtunmetadata3masked.TypeLen & 0xFF))
	_nxmtunmetadata3masked.ValueMask = decoder.Read(int(_nxmtunmetadata3masked.TypeLen & 0xFF))
	return _nxmtunmetadata3masked, nil
}

func NewNxmTunMetadata3Masked() *NxmTunMetadata3Masked {
	obj := &NxmTunMetadata3Masked{
		Oxm: NewOxm(88056),
	}
	return obj
}
func (self *NxmTunMetadata3Masked) GetOXMName() string {
	return "tun_metadata3_masked"
}

func (self *NxmTunMetadata3Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata3Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata3Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata4 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata4 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata4) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata4) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata4) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata4(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata4, error) {
	_nxmtunmetadata4 := &NxmTunMetadata4{Oxm: parent}
	_nxmtunmetadata4.Value = decoder.Read(int(_nxmtunmetadata4.TypeLen & 0xFF))
	return _nxmtunmetadata4, nil
}

func NewNxmTunMetadata4() *NxmTunMetadata4 {
	obj := &NxmTunMetadata4{
		Oxm: NewOxm(88188),
	}
	return obj
}
func (self *NxmTunMetadata4) GetOXMName() string {
	return "tun_metadata4"
}

func (self *NxmTunMetadata4) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata4) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata40 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata40 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata40) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata40) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata40) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata40(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata40, error) {
	_nxmtunmetadata40 := &NxmTunMetadata40{Oxm: parent}
	_nxmtunmetadata40.Value = decoder.Read(int(_nxmtunmetadata40.TypeLen & 0xFF))
	return _nxmtunmetadata40, nil
}

func NewNxmTunMetadata40() *NxmTunMetadata40 {
	obj := &NxmTunMetadata40{
		Oxm: NewOxm(106620),
	}
	return obj
}
func (self *NxmTunMetadata40) GetOXMName() string {
	return "tun_metadata40"
}

func (self *NxmTunMetadata40) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata40) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata40Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata40Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata40Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata40Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata40Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata40Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata40Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata40Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata40Masked, error) {
	_nxmtunmetadata40masked := &NxmTunMetadata40Masked{Oxm: parent}
	_nxmtunmetadata40masked.Value = decoder.Read(int(_nxmtunmetadata40masked.TypeLen & 0xFF))
	_nxmtunmetadata40masked.ValueMask = decoder.Read(int(_nxmtunmetadata40masked.TypeLen & 0xFF))
	return _nxmtunmetadata40masked, nil
}

func NewNxmTunMetadata40Masked() *NxmTunMetadata40Masked {
	obj := &NxmTunMetadata40Masked{
		Oxm: NewOxm(107000),
	}
	return obj
}
func (self *NxmTunMetadata40Masked) GetOXMName() string {
	return "tun_metadata40_masked"
}

func (self *NxmTunMetadata40Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata40Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata40Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata41 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata41 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata41) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata41) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata41) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata41(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata41, error) {
	_nxmtunmetadata41 := &NxmTunMetadata41{Oxm: parent}
	_nxmtunmetadata41.Value = decoder.Read(int(_nxmtunmetadata41.TypeLen & 0xFF))
	return _nxmtunmetadata41, nil
}

func NewNxmTunMetadata41() *NxmTunMetadata41 {
	obj := &NxmTunMetadata41{
		Oxm: NewOxm(107132),
	}
	return obj
}
func (self *NxmTunMetadata41) GetOXMName() string {
	return "tun_metadata41"
}

func (self *NxmTunMetadata41) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata41) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata41Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata41Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata41Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata41Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata41Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata41Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata41Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata41Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata41Masked, error) {
	_nxmtunmetadata41masked := &NxmTunMetadata41Masked{Oxm: parent}
	_nxmtunmetadata41masked.Value = decoder.Read(int(_nxmtunmetadata41masked.TypeLen & 0xFF))
	_nxmtunmetadata41masked.ValueMask = decoder.Read(int(_nxmtunmetadata41masked.TypeLen & 0xFF))
	return _nxmtunmetadata41masked, nil
}

func NewNxmTunMetadata41Masked() *NxmTunMetadata41Masked {
	obj := &NxmTunMetadata41Masked{
		Oxm: NewOxm(107512),
	}
	return obj
}
func (self *NxmTunMetadata41Masked) GetOXMName() string {
	return "tun_metadata41_masked"
}

func (self *NxmTunMetadata41Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata41Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata41Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata42 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata42 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata42) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata42) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata42) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata42(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata42, error) {
	_nxmtunmetadata42 := &NxmTunMetadata42{Oxm: parent}
	_nxmtunmetadata42.Value = decoder.Read(int(_nxmtunmetadata42.TypeLen & 0xFF))
	return _nxmtunmetadata42, nil
}

func NewNxmTunMetadata42() *NxmTunMetadata42 {
	obj := &NxmTunMetadata42{
		Oxm: NewOxm(107644),
	}
	return obj
}
func (self *NxmTunMetadata42) GetOXMName() string {
	return "tun_metadata42"
}

func (self *NxmTunMetadata42) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata42) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata42Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata42Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata42Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata42Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata42Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata42Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata42Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata42Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata42Masked, error) {
	_nxmtunmetadata42masked := &NxmTunMetadata42Masked{Oxm: parent}
	_nxmtunmetadata42masked.Value = decoder.Read(int(_nxmtunmetadata42masked.TypeLen & 0xFF))
	_nxmtunmetadata42masked.ValueMask = decoder.Read(int(_nxmtunmetadata42masked.TypeLen & 0xFF))
	return _nxmtunmetadata42masked, nil
}

func NewNxmTunMetadata42Masked() *NxmTunMetadata42Masked {
	obj := &NxmTunMetadata42Masked{
		Oxm: NewOxm(108024),
	}
	return obj
}
func (self *NxmTunMetadata42Masked) GetOXMName() string {
	return "tun_metadata42_masked"
}

func (self *NxmTunMetadata42Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata42Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata42Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata43 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata43 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata43) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata43) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata43) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata43(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata43, error) {
	_nxmtunmetadata43 := &NxmTunMetadata43{Oxm: parent}
	_nxmtunmetadata43.Value = decoder.Read(int(_nxmtunmetadata43.TypeLen & 0xFF))
	return _nxmtunmetadata43, nil
}

func NewNxmTunMetadata43() *NxmTunMetadata43 {
	obj := &NxmTunMetadata43{
		Oxm: NewOxm(108156),
	}
	return obj
}
func (self *NxmTunMetadata43) GetOXMName() string {
	return "tun_metadata43"
}

func (self *NxmTunMetadata43) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata43) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata43Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata43Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata43Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata43Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata43Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata43Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata43Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata43Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata43Masked, error) {
	_nxmtunmetadata43masked := &NxmTunMetadata43Masked{Oxm: parent}
	_nxmtunmetadata43masked.Value = decoder.Read(int(_nxmtunmetadata43masked.TypeLen & 0xFF))
	_nxmtunmetadata43masked.ValueMask = decoder.Read(int(_nxmtunmetadata43masked.TypeLen & 0xFF))
	return _nxmtunmetadata43masked, nil
}

func NewNxmTunMetadata43Masked() *NxmTunMetadata43Masked {
	obj := &NxmTunMetadata43Masked{
		Oxm: NewOxm(108536),
	}
	return obj
}
func (self *NxmTunMetadata43Masked) GetOXMName() string {
	return "tun_metadata43_masked"
}

func (self *NxmTunMetadata43Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata43Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata43Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata44 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata44 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata44) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata44) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata44) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata44(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata44, error) {
	_nxmtunmetadata44 := &NxmTunMetadata44{Oxm: parent}
	_nxmtunmetadata44.Value = decoder.Read(int(_nxmtunmetadata44.TypeLen & 0xFF))
	return _nxmtunmetadata44, nil
}

func NewNxmTunMetadata44() *NxmTunMetadata44 {
	obj := &NxmTunMetadata44{
		Oxm: NewOxm(108668),
	}
	return obj
}
func (self *NxmTunMetadata44) GetOXMName() string {
	return "tun_metadata44"
}

func (self *NxmTunMetadata44) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata44) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata44Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata44Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata44Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata44Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata44Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata44Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata44Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata44Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata44Masked, error) {
	_nxmtunmetadata44masked := &NxmTunMetadata44Masked{Oxm: parent}
	_nxmtunmetadata44masked.Value = decoder.Read(int(_nxmtunmetadata44masked.TypeLen & 0xFF))
	_nxmtunmetadata44masked.ValueMask = decoder.Read(int(_nxmtunmetadata44masked.TypeLen & 0xFF))
	return _nxmtunmetadata44masked, nil
}

func NewNxmTunMetadata44Masked() *NxmTunMetadata44Masked {
	obj := &NxmTunMetadata44Masked{
		Oxm: NewOxm(109048),
	}
	return obj
}
func (self *NxmTunMetadata44Masked) GetOXMName() string {
	return "tun_metadata44_masked"
}

func (self *NxmTunMetadata44Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata44Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata44Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata45 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata45 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata45) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata45) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata45) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata45(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata45, error) {
	_nxmtunmetadata45 := &NxmTunMetadata45{Oxm: parent}
	_nxmtunmetadata45.Value = decoder.Read(int(_nxmtunmetadata45.TypeLen & 0xFF))
	return _nxmtunmetadata45, nil
}

func NewNxmTunMetadata45() *NxmTunMetadata45 {
	obj := &NxmTunMetadata45{
		Oxm: NewOxm(109180),
	}
	return obj
}
func (self *NxmTunMetadata45) GetOXMName() string {
	return "tun_metadata45"
}

func (self *NxmTunMetadata45) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata45) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata45Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata45Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata45Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata45Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata45Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata45Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata45Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata45Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata45Masked, error) {
	_nxmtunmetadata45masked := &NxmTunMetadata45Masked{Oxm: parent}
	_nxmtunmetadata45masked.Value = decoder.Read(int(_nxmtunmetadata45masked.TypeLen & 0xFF))
	_nxmtunmetadata45masked.ValueMask = decoder.Read(int(_nxmtunmetadata45masked.TypeLen & 0xFF))
	return _nxmtunmetadata45masked, nil
}

func NewNxmTunMetadata45Masked() *NxmTunMetadata45Masked {
	obj := &NxmTunMetadata45Masked{
		Oxm: NewOxm(109560),
	}
	return obj
}
func (self *NxmTunMetadata45Masked) GetOXMName() string {
	return "tun_metadata45_masked"
}

func (self *NxmTunMetadata45Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata45Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata45Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata46 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata46 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata46) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata46) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata46) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata46(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata46, error) {
	_nxmtunmetadata46 := &NxmTunMetadata46{Oxm: parent}
	_nxmtunmetadata46.Value = decoder.Read(int(_nxmtunmetadata46.TypeLen & 0xFF))
	return _nxmtunmetadata46, nil
}

func NewNxmTunMetadata46() *NxmTunMetadata46 {
	obj := &NxmTunMetadata46{
		Oxm: NewOxm(109692),
	}
	return obj
}
func (self *NxmTunMetadata46) GetOXMName() string {
	return "tun_metadata46"
}

func (self *NxmTunMetadata46) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata46) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata46Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata46Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata46Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata46Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata46Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata46Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata46Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata46Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata46Masked, error) {
	_nxmtunmetadata46masked := &NxmTunMetadata46Masked{Oxm: parent}
	_nxmtunmetadata46masked.Value = decoder.Read(int(_nxmtunmetadata46masked.TypeLen & 0xFF))
	_nxmtunmetadata46masked.ValueMask = decoder.Read(int(_nxmtunmetadata46masked.TypeLen & 0xFF))
	return _nxmtunmetadata46masked, nil
}

func NewNxmTunMetadata46Masked() *NxmTunMetadata46Masked {
	obj := &NxmTunMetadata46Masked{
		Oxm: NewOxm(110072),
	}
	return obj
}
func (self *NxmTunMetadata46Masked) GetOXMName() string {
	return "tun_metadata46_masked"
}

func (self *NxmTunMetadata46Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata46Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata46Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata47 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata47 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata47) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata47) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata47) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata47(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata47, error) {
	_nxmtunmetadata47 := &NxmTunMetadata47{Oxm: parent}
	_nxmtunmetadata47.Value = decoder.Read(int(_nxmtunmetadata47.TypeLen & 0xFF))
	return _nxmtunmetadata47, nil
}

func NewNxmTunMetadata47() *NxmTunMetadata47 {
	obj := &NxmTunMetadata47{
		Oxm: NewOxm(110204),
	}
	return obj
}
func (self *NxmTunMetadata47) GetOXMName() string {
	return "tun_metadata47"
}

func (self *NxmTunMetadata47) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata47) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata47Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata47Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata47Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata47Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata47Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata47Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata47Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata47Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata47Masked, error) {
	_nxmtunmetadata47masked := &NxmTunMetadata47Masked{Oxm: parent}
	_nxmtunmetadata47masked.Value = decoder.Read(int(_nxmtunmetadata47masked.TypeLen & 0xFF))
	_nxmtunmetadata47masked.ValueMask = decoder.Read(int(_nxmtunmetadata47masked.TypeLen & 0xFF))
	return _nxmtunmetadata47masked, nil
}

func NewNxmTunMetadata47Masked() *NxmTunMetadata47Masked {
	obj := &NxmTunMetadata47Masked{
		Oxm: NewOxm(110584),
	}
	return obj
}
func (self *NxmTunMetadata47Masked) GetOXMName() string {
	return "tun_metadata47_masked"
}

func (self *NxmTunMetadata47Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata47Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata47Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata48 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata48 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata48) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata48) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata48) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata48(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata48, error) {
	_nxmtunmetadata48 := &NxmTunMetadata48{Oxm: parent}
	_nxmtunmetadata48.Value = decoder.Read(int(_nxmtunmetadata48.TypeLen & 0xFF))
	return _nxmtunmetadata48, nil
}

func NewNxmTunMetadata48() *NxmTunMetadata48 {
	obj := &NxmTunMetadata48{
		Oxm: NewOxm(110716),
	}
	return obj
}
func (self *NxmTunMetadata48) GetOXMName() string {
	return "tun_metadata48"
}

func (self *NxmTunMetadata48) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata48) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata48Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata48Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata48Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata48Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata48Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata48Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata48Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata48Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata48Masked, error) {
	_nxmtunmetadata48masked := &NxmTunMetadata48Masked{Oxm: parent}
	_nxmtunmetadata48masked.Value = decoder.Read(int(_nxmtunmetadata48masked.TypeLen & 0xFF))
	_nxmtunmetadata48masked.ValueMask = decoder.Read(int(_nxmtunmetadata48masked.TypeLen & 0xFF))
	return _nxmtunmetadata48masked, nil
}

func NewNxmTunMetadata48Masked() *NxmTunMetadata48Masked {
	obj := &NxmTunMetadata48Masked{
		Oxm: NewOxm(111096),
	}
	return obj
}
func (self *NxmTunMetadata48Masked) GetOXMName() string {
	return "tun_metadata48_masked"
}

func (self *NxmTunMetadata48Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata48Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata48Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata49 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata49 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata49) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata49) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata49) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata49(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata49, error) {
	_nxmtunmetadata49 := &NxmTunMetadata49{Oxm: parent}
	_nxmtunmetadata49.Value = decoder.Read(int(_nxmtunmetadata49.TypeLen & 0xFF))
	return _nxmtunmetadata49, nil
}

func NewNxmTunMetadata49() *NxmTunMetadata49 {
	obj := &NxmTunMetadata49{
		Oxm: NewOxm(111228),
	}
	return obj
}
func (self *NxmTunMetadata49) GetOXMName() string {
	return "tun_metadata49"
}

func (self *NxmTunMetadata49) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata49) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata49Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata49Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata49Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata49Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata49Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata49Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata49Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata49Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata49Masked, error) {
	_nxmtunmetadata49masked := &NxmTunMetadata49Masked{Oxm: parent}
	_nxmtunmetadata49masked.Value = decoder.Read(int(_nxmtunmetadata49masked.TypeLen & 0xFF))
	_nxmtunmetadata49masked.ValueMask = decoder.Read(int(_nxmtunmetadata49masked.TypeLen & 0xFF))
	return _nxmtunmetadata49masked, nil
}

func NewNxmTunMetadata49Masked() *NxmTunMetadata49Masked {
	obj := &NxmTunMetadata49Masked{
		Oxm: NewOxm(111608),
	}
	return obj
}
func (self *NxmTunMetadata49Masked) GetOXMName() string {
	return "tun_metadata49_masked"
}

func (self *NxmTunMetadata49Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata49Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata49Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata4Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata4Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata4Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata4Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata4Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata4Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata4Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata4Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata4Masked, error) {
	_nxmtunmetadata4masked := &NxmTunMetadata4Masked{Oxm: parent}
	_nxmtunmetadata4masked.Value = decoder.Read(int(_nxmtunmetadata4masked.TypeLen & 0xFF))
	_nxmtunmetadata4masked.ValueMask = decoder.Read(int(_nxmtunmetadata4masked.TypeLen & 0xFF))
	return _nxmtunmetadata4masked, nil
}

func NewNxmTunMetadata4Masked() *NxmTunMetadata4Masked {
	obj := &NxmTunMetadata4Masked{
		Oxm: NewOxm(88568),
	}
	return obj
}
func (self *NxmTunMetadata4Masked) GetOXMName() string {
	return "tun_metadata4_masked"
}

func (self *NxmTunMetadata4Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata4Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata4Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata5 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata5 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata5) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata5) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata5) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata5(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata5, error) {
	_nxmtunmetadata5 := &NxmTunMetadata5{Oxm: parent}
	_nxmtunmetadata5.Value = decoder.Read(int(_nxmtunmetadata5.TypeLen & 0xFF))
	return _nxmtunmetadata5, nil
}

func NewNxmTunMetadata5() *NxmTunMetadata5 {
	obj := &NxmTunMetadata5{
		Oxm: NewOxm(88700),
	}
	return obj
}
func (self *NxmTunMetadata5) GetOXMName() string {
	return "tun_metadata5"
}

func (self *NxmTunMetadata5) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata5) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata50 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata50 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata50) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata50) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata50) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata50(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata50, error) {
	_nxmtunmetadata50 := &NxmTunMetadata50{Oxm: parent}
	_nxmtunmetadata50.Value = decoder.Read(int(_nxmtunmetadata50.TypeLen & 0xFF))
	return _nxmtunmetadata50, nil
}

func NewNxmTunMetadata50() *NxmTunMetadata50 {
	obj := &NxmTunMetadata50{
		Oxm: NewOxm(111740),
	}
	return obj
}
func (self *NxmTunMetadata50) GetOXMName() string {
	return "tun_metadata50"
}

func (self *NxmTunMetadata50) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata50) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata50Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata50Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata50Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata50Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata50Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata50Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata50Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata50Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata50Masked, error) {
	_nxmtunmetadata50masked := &NxmTunMetadata50Masked{Oxm: parent}
	_nxmtunmetadata50masked.Value = decoder.Read(int(_nxmtunmetadata50masked.TypeLen & 0xFF))
	_nxmtunmetadata50masked.ValueMask = decoder.Read(int(_nxmtunmetadata50masked.TypeLen & 0xFF))
	return _nxmtunmetadata50masked, nil
}

func NewNxmTunMetadata50Masked() *NxmTunMetadata50Masked {
	obj := &NxmTunMetadata50Masked{
		Oxm: NewOxm(112120),
	}
	return obj
}
func (self *NxmTunMetadata50Masked) GetOXMName() string {
	return "tun_metadata50_masked"
}

func (self *NxmTunMetadata50Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata50Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata50Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata51 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata51 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata51) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata51) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata51) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata51(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata51, error) {
	_nxmtunmetadata51 := &NxmTunMetadata51{Oxm: parent}
	_nxmtunmetadata51.Value = decoder.Read(int(_nxmtunmetadata51.TypeLen & 0xFF))
	return _nxmtunmetadata51, nil
}

func NewNxmTunMetadata51() *NxmTunMetadata51 {
	obj := &NxmTunMetadata51{
		Oxm: NewOxm(112252),
	}
	return obj
}
func (self *NxmTunMetadata51) GetOXMName() string {
	return "tun_metadata51"
}

func (self *NxmTunMetadata51) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata51) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata51Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata51Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata51Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata51Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata51Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata51Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata51Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata51Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata51Masked, error) {
	_nxmtunmetadata51masked := &NxmTunMetadata51Masked{Oxm: parent}
	_nxmtunmetadata51masked.Value = decoder.Read(int(_nxmtunmetadata51masked.TypeLen & 0xFF))
	_nxmtunmetadata51masked.ValueMask = decoder.Read(int(_nxmtunmetadata51masked.TypeLen & 0xFF))
	return _nxmtunmetadata51masked, nil
}

func NewNxmTunMetadata51Masked() *NxmTunMetadata51Masked {
	obj := &NxmTunMetadata51Masked{
		Oxm: NewOxm(112632),
	}
	return obj
}
func (self *NxmTunMetadata51Masked) GetOXMName() string {
	return "tun_metadata51_masked"
}

func (self *NxmTunMetadata51Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata51Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata51Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata52 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata52 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata52) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata52) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata52) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata52(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata52, error) {
	_nxmtunmetadata52 := &NxmTunMetadata52{Oxm: parent}
	_nxmtunmetadata52.Value = decoder.Read(int(_nxmtunmetadata52.TypeLen & 0xFF))
	return _nxmtunmetadata52, nil
}

func NewNxmTunMetadata52() *NxmTunMetadata52 {
	obj := &NxmTunMetadata52{
		Oxm: NewOxm(112764),
	}
	return obj
}
func (self *NxmTunMetadata52) GetOXMName() string {
	return "tun_metadata52"
}

func (self *NxmTunMetadata52) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata52) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata52Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata52Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata52Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata52Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata52Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata52Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata52Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata52Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata52Masked, error) {
	_nxmtunmetadata52masked := &NxmTunMetadata52Masked{Oxm: parent}
	_nxmtunmetadata52masked.Value = decoder.Read(int(_nxmtunmetadata52masked.TypeLen & 0xFF))
	_nxmtunmetadata52masked.ValueMask = decoder.Read(int(_nxmtunmetadata52masked.TypeLen & 0xFF))
	return _nxmtunmetadata52masked, nil
}

func NewNxmTunMetadata52Masked() *NxmTunMetadata52Masked {
	obj := &NxmTunMetadata52Masked{
		Oxm: NewOxm(113144),
	}
	return obj
}
func (self *NxmTunMetadata52Masked) GetOXMName() string {
	return "tun_metadata52_masked"
}

func (self *NxmTunMetadata52Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata52Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata52Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata53 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata53 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata53) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata53) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata53) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata53(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata53, error) {
	_nxmtunmetadata53 := &NxmTunMetadata53{Oxm: parent}
	_nxmtunmetadata53.Value = decoder.Read(int(_nxmtunmetadata53.TypeLen & 0xFF))
	return _nxmtunmetadata53, nil
}

func NewNxmTunMetadata53() *NxmTunMetadata53 {
	obj := &NxmTunMetadata53{
		Oxm: NewOxm(113276),
	}
	return obj
}
func (self *NxmTunMetadata53) GetOXMName() string {
	return "tun_metadata53"
}

func (self *NxmTunMetadata53) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata53) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata53Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata53Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata53Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata53Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata53Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata53Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata53Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata53Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata53Masked, error) {
	_nxmtunmetadata53masked := &NxmTunMetadata53Masked{Oxm: parent}
	_nxmtunmetadata53masked.Value = decoder.Read(int(_nxmtunmetadata53masked.TypeLen & 0xFF))
	_nxmtunmetadata53masked.ValueMask = decoder.Read(int(_nxmtunmetadata53masked.TypeLen & 0xFF))
	return _nxmtunmetadata53masked, nil
}

func NewNxmTunMetadata53Masked() *NxmTunMetadata53Masked {
	obj := &NxmTunMetadata53Masked{
		Oxm: NewOxm(113656),
	}
	return obj
}
func (self *NxmTunMetadata53Masked) GetOXMName() string {
	return "tun_metadata53_masked"
}

func (self *NxmTunMetadata53Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata53Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata53Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata54 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata54 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata54) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata54) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata54) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata54(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata54, error) {
	_nxmtunmetadata54 := &NxmTunMetadata54{Oxm: parent}
	_nxmtunmetadata54.Value = decoder.Read(int(_nxmtunmetadata54.TypeLen & 0xFF))
	return _nxmtunmetadata54, nil
}

func NewNxmTunMetadata54() *NxmTunMetadata54 {
	obj := &NxmTunMetadata54{
		Oxm: NewOxm(113788),
	}
	return obj
}
func (self *NxmTunMetadata54) GetOXMName() string {
	return "tun_metadata54"
}

func (self *NxmTunMetadata54) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata54) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata54Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata54Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata54Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata54Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata54Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata54Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata54Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata54Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata54Masked, error) {
	_nxmtunmetadata54masked := &NxmTunMetadata54Masked{Oxm: parent}
	_nxmtunmetadata54masked.Value = decoder.Read(int(_nxmtunmetadata54masked.TypeLen & 0xFF))
	_nxmtunmetadata54masked.ValueMask = decoder.Read(int(_nxmtunmetadata54masked.TypeLen & 0xFF))
	return _nxmtunmetadata54masked, nil
}

func NewNxmTunMetadata54Masked() *NxmTunMetadata54Masked {
	obj := &NxmTunMetadata54Masked{
		Oxm: NewOxm(114168),
	}
	return obj
}
func (self *NxmTunMetadata54Masked) GetOXMName() string {
	return "tun_metadata54_masked"
}

func (self *NxmTunMetadata54Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata54Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata54Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata55 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata55 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata55) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata55) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata55) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata55(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata55, error) {
	_nxmtunmetadata55 := &NxmTunMetadata55{Oxm: parent}
	_nxmtunmetadata55.Value = decoder.Read(int(_nxmtunmetadata55.TypeLen & 0xFF))
	return _nxmtunmetadata55, nil
}

func NewNxmTunMetadata55() *NxmTunMetadata55 {
	obj := &NxmTunMetadata55{
		Oxm: NewOxm(114300),
	}
	return obj
}
func (self *NxmTunMetadata55) GetOXMName() string {
	return "tun_metadata55"
}

func (self *NxmTunMetadata55) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata55) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata55Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata55Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata55Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata55Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata55Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata55Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata55Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata55Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata55Masked, error) {
	_nxmtunmetadata55masked := &NxmTunMetadata55Masked{Oxm: parent}
	_nxmtunmetadata55masked.Value = decoder.Read(int(_nxmtunmetadata55masked.TypeLen & 0xFF))
	_nxmtunmetadata55masked.ValueMask = decoder.Read(int(_nxmtunmetadata55masked.TypeLen & 0xFF))
	return _nxmtunmetadata55masked, nil
}

func NewNxmTunMetadata55Masked() *NxmTunMetadata55Masked {
	obj := &NxmTunMetadata55Masked{
		Oxm: NewOxm(114680),
	}
	return obj
}
func (self *NxmTunMetadata55Masked) GetOXMName() string {
	return "tun_metadata55_masked"
}

func (self *NxmTunMetadata55Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata55Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata55Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata56 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata56 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata56) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata56) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata56) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata56(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata56, error) {
	_nxmtunmetadata56 := &NxmTunMetadata56{Oxm: parent}
	_nxmtunmetadata56.Value = decoder.Read(int(_nxmtunmetadata56.TypeLen & 0xFF))
	return _nxmtunmetadata56, nil
}

func NewNxmTunMetadata56() *NxmTunMetadata56 {
	obj := &NxmTunMetadata56{
		Oxm: NewOxm(114812),
	}
	return obj
}
func (self *NxmTunMetadata56) GetOXMName() string {
	return "tun_metadata56"
}

func (self *NxmTunMetadata56) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata56) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata56Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata56Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata56Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata56Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata56Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata56Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata56Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata56Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata56Masked, error) {
	_nxmtunmetadata56masked := &NxmTunMetadata56Masked{Oxm: parent}
	_nxmtunmetadata56masked.Value = decoder.Read(int(_nxmtunmetadata56masked.TypeLen & 0xFF))
	_nxmtunmetadata56masked.ValueMask = decoder.Read(int(_nxmtunmetadata56masked.TypeLen & 0xFF))
	return _nxmtunmetadata56masked, nil
}

func NewNxmTunMetadata56Masked() *NxmTunMetadata56Masked {
	obj := &NxmTunMetadata56Masked{
		Oxm: NewOxm(115192),
	}
	return obj
}
func (self *NxmTunMetadata56Masked) GetOXMName() string {
	return "tun_metadata56_masked"
}

func (self *NxmTunMetadata56Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata56Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata56Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata57 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata57 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata57) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata57) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata57) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata57(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata57, error) {
	_nxmtunmetadata57 := &NxmTunMetadata57{Oxm: parent}
	_nxmtunmetadata57.Value = decoder.Read(int(_nxmtunmetadata57.TypeLen & 0xFF))
	return _nxmtunmetadata57, nil
}

func NewNxmTunMetadata57() *NxmTunMetadata57 {
	obj := &NxmTunMetadata57{
		Oxm: NewOxm(115324),
	}
	return obj
}
func (self *NxmTunMetadata57) GetOXMName() string {
	return "tun_metadata57"
}

func (self *NxmTunMetadata57) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata57) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata57Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata57Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata57Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata57Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata57Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata57Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata57Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata57Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata57Masked, error) {
	_nxmtunmetadata57masked := &NxmTunMetadata57Masked{Oxm: parent}
	_nxmtunmetadata57masked.Value = decoder.Read(int(_nxmtunmetadata57masked.TypeLen & 0xFF))
	_nxmtunmetadata57masked.ValueMask = decoder.Read(int(_nxmtunmetadata57masked.TypeLen & 0xFF))
	return _nxmtunmetadata57masked, nil
}

func NewNxmTunMetadata57Masked() *NxmTunMetadata57Masked {
	obj := &NxmTunMetadata57Masked{
		Oxm: NewOxm(115704),
	}
	return obj
}
func (self *NxmTunMetadata57Masked) GetOXMName() string {
	return "tun_metadata57_masked"
}

func (self *NxmTunMetadata57Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata57Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata57Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata58 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata58 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata58) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata58) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata58) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata58(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata58, error) {
	_nxmtunmetadata58 := &NxmTunMetadata58{Oxm: parent}
	_nxmtunmetadata58.Value = decoder.Read(int(_nxmtunmetadata58.TypeLen & 0xFF))
	return _nxmtunmetadata58, nil
}

func NewNxmTunMetadata58() *NxmTunMetadata58 {
	obj := &NxmTunMetadata58{
		Oxm: NewOxm(115836),
	}
	return obj
}
func (self *NxmTunMetadata58) GetOXMName() string {
	return "tun_metadata58"
}

func (self *NxmTunMetadata58) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata58) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata58Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata58Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata58Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata58Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata58Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata58Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata58Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata58Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata58Masked, error) {
	_nxmtunmetadata58masked := &NxmTunMetadata58Masked{Oxm: parent}
	_nxmtunmetadata58masked.Value = decoder.Read(int(_nxmtunmetadata58masked.TypeLen & 0xFF))
	_nxmtunmetadata58masked.ValueMask = decoder.Read(int(_nxmtunmetadata58masked.TypeLen & 0xFF))
	return _nxmtunmetadata58masked, nil
}

func NewNxmTunMetadata58Masked() *NxmTunMetadata58Masked {
	obj := &NxmTunMetadata58Masked{
		Oxm: NewOxm(116216),
	}
	return obj
}
func (self *NxmTunMetadata58Masked) GetOXMName() string {
	return "tun_metadata58_masked"
}

func (self *NxmTunMetadata58Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata58Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata58Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata59 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata59 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata59) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata59) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata59) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata59(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata59, error) {
	_nxmtunmetadata59 := &NxmTunMetadata59{Oxm: parent}
	_nxmtunmetadata59.Value = decoder.Read(int(_nxmtunmetadata59.TypeLen & 0xFF))
	return _nxmtunmetadata59, nil
}

func NewNxmTunMetadata59() *NxmTunMetadata59 {
	obj := &NxmTunMetadata59{
		Oxm: NewOxm(116348),
	}
	return obj
}
func (self *NxmTunMetadata59) GetOXMName() string {
	return "tun_metadata59"
}

func (self *NxmTunMetadata59) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata59) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata59Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata59Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata59Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata59Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata59Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata59Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata59Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata59Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata59Masked, error) {
	_nxmtunmetadata59masked := &NxmTunMetadata59Masked{Oxm: parent}
	_nxmtunmetadata59masked.Value = decoder.Read(int(_nxmtunmetadata59masked.TypeLen & 0xFF))
	_nxmtunmetadata59masked.ValueMask = decoder.Read(int(_nxmtunmetadata59masked.TypeLen & 0xFF))
	return _nxmtunmetadata59masked, nil
}

func NewNxmTunMetadata59Masked() *NxmTunMetadata59Masked {
	obj := &NxmTunMetadata59Masked{
		Oxm: NewOxm(116728),
	}
	return obj
}
func (self *NxmTunMetadata59Masked) GetOXMName() string {
	return "tun_metadata59_masked"
}

func (self *NxmTunMetadata59Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata59Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata59Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata5Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata5Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata5Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata5Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata5Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata5Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata5Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata5Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata5Masked, error) {
	_nxmtunmetadata5masked := &NxmTunMetadata5Masked{Oxm: parent}
	_nxmtunmetadata5masked.Value = decoder.Read(int(_nxmtunmetadata5masked.TypeLen & 0xFF))
	_nxmtunmetadata5masked.ValueMask = decoder.Read(int(_nxmtunmetadata5masked.TypeLen & 0xFF))
	return _nxmtunmetadata5masked, nil
}

func NewNxmTunMetadata5Masked() *NxmTunMetadata5Masked {
	obj := &NxmTunMetadata5Masked{
		Oxm: NewOxm(89080),
	}
	return obj
}
func (self *NxmTunMetadata5Masked) GetOXMName() string {
	return "tun_metadata5_masked"
}

func (self *NxmTunMetadata5Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata5Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata5Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata6 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata6 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata6) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata6) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata6) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata6(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata6, error) {
	_nxmtunmetadata6 := &NxmTunMetadata6{Oxm: parent}
	_nxmtunmetadata6.Value = decoder.Read(int(_nxmtunmetadata6.TypeLen & 0xFF))
	return _nxmtunmetadata6, nil
}

func NewNxmTunMetadata6() *NxmTunMetadata6 {
	obj := &NxmTunMetadata6{
		Oxm: NewOxm(89212),
	}
	return obj
}
func (self *NxmTunMetadata6) GetOXMName() string {
	return "tun_metadata6"
}

func (self *NxmTunMetadata6) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata6) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata60 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata60 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata60) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata60) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata60) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata60(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata60, error) {
	_nxmtunmetadata60 := &NxmTunMetadata60{Oxm: parent}
	_nxmtunmetadata60.Value = decoder.Read(int(_nxmtunmetadata60.TypeLen & 0xFF))
	return _nxmtunmetadata60, nil
}

func NewNxmTunMetadata60() *NxmTunMetadata60 {
	obj := &NxmTunMetadata60{
		Oxm: NewOxm(116860),
	}
	return obj
}
func (self *NxmTunMetadata60) GetOXMName() string {
	return "tun_metadata60"
}

func (self *NxmTunMetadata60) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata60) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata60Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata60Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata60Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata60Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata60Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata60Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata60Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata60Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata60Masked, error) {
	_nxmtunmetadata60masked := &NxmTunMetadata60Masked{Oxm: parent}
	_nxmtunmetadata60masked.Value = decoder.Read(int(_nxmtunmetadata60masked.TypeLen & 0xFF))
	_nxmtunmetadata60masked.ValueMask = decoder.Read(int(_nxmtunmetadata60masked.TypeLen & 0xFF))
	return _nxmtunmetadata60masked, nil
}

func NewNxmTunMetadata60Masked() *NxmTunMetadata60Masked {
	obj := &NxmTunMetadata60Masked{
		Oxm: NewOxm(117240),
	}
	return obj
}
func (self *NxmTunMetadata60Masked) GetOXMName() string {
	return "tun_metadata60_masked"
}

func (self *NxmTunMetadata60Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata60Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata60Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata61 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata61 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata61) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata61) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata61) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata61(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata61, error) {
	_nxmtunmetadata61 := &NxmTunMetadata61{Oxm: parent}
	_nxmtunmetadata61.Value = decoder.Read(int(_nxmtunmetadata61.TypeLen & 0xFF))
	return _nxmtunmetadata61, nil
}

func NewNxmTunMetadata61() *NxmTunMetadata61 {
	obj := &NxmTunMetadata61{
		Oxm: NewOxm(117372),
	}
	return obj
}
func (self *NxmTunMetadata61) GetOXMName() string {
	return "tun_metadata61"
}

func (self *NxmTunMetadata61) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata61) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata61Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata61Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata61Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata61Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata61Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata61Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata61Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata61Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata61Masked, error) {
	_nxmtunmetadata61masked := &NxmTunMetadata61Masked{Oxm: parent}
	_nxmtunmetadata61masked.Value = decoder.Read(int(_nxmtunmetadata61masked.TypeLen & 0xFF))
	_nxmtunmetadata61masked.ValueMask = decoder.Read(int(_nxmtunmetadata61masked.TypeLen & 0xFF))
	return _nxmtunmetadata61masked, nil
}

func NewNxmTunMetadata61Masked() *NxmTunMetadata61Masked {
	obj := &NxmTunMetadata61Masked{
		Oxm: NewOxm(117752),
	}
	return obj
}
func (self *NxmTunMetadata61Masked) GetOXMName() string {
	return "tun_metadata61_masked"
}

func (self *NxmTunMetadata61Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata61Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata61Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata62 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata62 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata62) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata62) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata62) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata62(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata62, error) {
	_nxmtunmetadata62 := &NxmTunMetadata62{Oxm: parent}
	_nxmtunmetadata62.Value = decoder.Read(int(_nxmtunmetadata62.TypeLen & 0xFF))
	return _nxmtunmetadata62, nil
}

func NewNxmTunMetadata62() *NxmTunMetadata62 {
	obj := &NxmTunMetadata62{
		Oxm: NewOxm(117884),
	}
	return obj
}
func (self *NxmTunMetadata62) GetOXMName() string {
	return "tun_metadata62"
}

func (self *NxmTunMetadata62) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata62) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata62Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata62Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata62Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata62Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata62Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata62Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata62Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata62Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata62Masked, error) {
	_nxmtunmetadata62masked := &NxmTunMetadata62Masked{Oxm: parent}
	_nxmtunmetadata62masked.Value = decoder.Read(int(_nxmtunmetadata62masked.TypeLen & 0xFF))
	_nxmtunmetadata62masked.ValueMask = decoder.Read(int(_nxmtunmetadata62masked.TypeLen & 0xFF))
	return _nxmtunmetadata62masked, nil
}

func NewNxmTunMetadata62Masked() *NxmTunMetadata62Masked {
	obj := &NxmTunMetadata62Masked{
		Oxm: NewOxm(118264),
	}
	return obj
}
func (self *NxmTunMetadata62Masked) GetOXMName() string {
	return "tun_metadata62_masked"
}

func (self *NxmTunMetadata62Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata62Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata62Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata63 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata63 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata63) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata63) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata63) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata63(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata63, error) {
	_nxmtunmetadata63 := &NxmTunMetadata63{Oxm: parent}
	_nxmtunmetadata63.Value = decoder.Read(int(_nxmtunmetadata63.TypeLen & 0xFF))
	return _nxmtunmetadata63, nil
}

func NewNxmTunMetadata63() *NxmTunMetadata63 {
	obj := &NxmTunMetadata63{
		Oxm: NewOxm(118396),
	}
	return obj
}
func (self *NxmTunMetadata63) GetOXMName() string {
	return "tun_metadata63"
}

func (self *NxmTunMetadata63) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata63) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata63Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata63Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata63Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata63Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata63Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata63Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata63Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata63Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata63Masked, error) {
	_nxmtunmetadata63masked := &NxmTunMetadata63Masked{Oxm: parent}
	_nxmtunmetadata63masked.Value = decoder.Read(int(_nxmtunmetadata63masked.TypeLen & 0xFF))
	_nxmtunmetadata63masked.ValueMask = decoder.Read(int(_nxmtunmetadata63masked.TypeLen & 0xFF))
	return _nxmtunmetadata63masked, nil
}

func NewNxmTunMetadata63Masked() *NxmTunMetadata63Masked {
	obj := &NxmTunMetadata63Masked{
		Oxm: NewOxm(118776),
	}
	return obj
}
func (self *NxmTunMetadata63Masked) GetOXMName() string {
	return "tun_metadata63_masked"
}

func (self *NxmTunMetadata63Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata63Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata63Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata6Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata6Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata6Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata6Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata6Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata6Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata6Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata6Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata6Masked, error) {
	_nxmtunmetadata6masked := &NxmTunMetadata6Masked{Oxm: parent}
	_nxmtunmetadata6masked.Value = decoder.Read(int(_nxmtunmetadata6masked.TypeLen & 0xFF))
	_nxmtunmetadata6masked.ValueMask = decoder.Read(int(_nxmtunmetadata6masked.TypeLen & 0xFF))
	return _nxmtunmetadata6masked, nil
}

func NewNxmTunMetadata6Masked() *NxmTunMetadata6Masked {
	obj := &NxmTunMetadata6Masked{
		Oxm: NewOxm(89592),
	}
	return obj
}
func (self *NxmTunMetadata6Masked) GetOXMName() string {
	return "tun_metadata6_masked"
}

func (self *NxmTunMetadata6Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata6Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata6Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata7 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata7 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata7) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata7) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata7) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata7(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata7, error) {
	_nxmtunmetadata7 := &NxmTunMetadata7{Oxm: parent}
	_nxmtunmetadata7.Value = decoder.Read(int(_nxmtunmetadata7.TypeLen & 0xFF))
	return _nxmtunmetadata7, nil
}

func NewNxmTunMetadata7() *NxmTunMetadata7 {
	obj := &NxmTunMetadata7{
		Oxm: NewOxm(89724),
	}
	return obj
}
func (self *NxmTunMetadata7) GetOXMName() string {
	return "tun_metadata7"
}

func (self *NxmTunMetadata7) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata7) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata7Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata7Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata7Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata7Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata7Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata7Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata7Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata7Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata7Masked, error) {
	_nxmtunmetadata7masked := &NxmTunMetadata7Masked{Oxm: parent}
	_nxmtunmetadata7masked.Value = decoder.Read(int(_nxmtunmetadata7masked.TypeLen & 0xFF))
	_nxmtunmetadata7masked.ValueMask = decoder.Read(int(_nxmtunmetadata7masked.TypeLen & 0xFF))
	return _nxmtunmetadata7masked, nil
}

func NewNxmTunMetadata7Masked() *NxmTunMetadata7Masked {
	obj := &NxmTunMetadata7Masked{
		Oxm: NewOxm(90104),
	}
	return obj
}
func (self *NxmTunMetadata7Masked) GetOXMName() string {
	return "tun_metadata7_masked"
}

func (self *NxmTunMetadata7Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata7Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata7Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata8 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata8 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata8) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata8) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata8) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata8(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata8, error) {
	_nxmtunmetadata8 := &NxmTunMetadata8{Oxm: parent}
	_nxmtunmetadata8.Value = decoder.Read(int(_nxmtunmetadata8.TypeLen & 0xFF))
	return _nxmtunmetadata8, nil
}

func NewNxmTunMetadata8() *NxmTunMetadata8 {
	obj := &NxmTunMetadata8{
		Oxm: NewOxm(90236),
	}
	return obj
}
func (self *NxmTunMetadata8) GetOXMName() string {
	return "tun_metadata8"
}

func (self *NxmTunMetadata8) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata8) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata8Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata8Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata8Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata8Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata8Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata8Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata8Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata8Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata8Masked, error) {
	_nxmtunmetadata8masked := &NxmTunMetadata8Masked{Oxm: parent}
	_nxmtunmetadata8masked.Value = decoder.Read(int(_nxmtunmetadata8masked.TypeLen & 0xFF))
	_nxmtunmetadata8masked.ValueMask = decoder.Read(int(_nxmtunmetadata8masked.TypeLen & 0xFF))
	return _nxmtunmetadata8masked, nil
}

func NewNxmTunMetadata8Masked() *NxmTunMetadata8Masked {
	obj := &NxmTunMetadata8Masked{
		Oxm: NewOxm(90616),
	}
	return obj
}
func (self *NxmTunMetadata8Masked) GetOXMName() string {
	return "tun_metadata8_masked"
}

func (self *NxmTunMetadata8Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata8Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata8Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunMetadata9 struct {
	*Oxm
	Value []byte
}

type INxmTunMetadata9 interface {
	goloxi.IOxm
	GetValue() []byte
}

func (self *NxmTunMetadata9) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata9) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata9) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeNxmTunMetadata9(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata9, error) {
	_nxmtunmetadata9 := &NxmTunMetadata9{Oxm: parent}
	_nxmtunmetadata9.Value = decoder.Read(int(_nxmtunmetadata9.TypeLen & 0xFF))
	return _nxmtunmetadata9, nil
}

func NewNxmTunMetadata9() *NxmTunMetadata9 {
	obj := &NxmTunMetadata9{
		Oxm: NewOxm(90748),
	}
	return obj
}
func (self *NxmTunMetadata9) GetOXMName() string {
	return "tun_metadata9"
}

func (self *NxmTunMetadata9) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata9) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunMetadata9Masked struct {
	*Oxm
	Value     []byte
	ValueMask []byte
}

type INxmTunMetadata9Masked interface {
	goloxi.IOxm
	GetValue() []byte
	GetValueMask() []byte
}

func (self *NxmTunMetadata9Masked) GetValue() []byte {
	return self.Value
}

func (self *NxmTunMetadata9Masked) SetValue(v []byte) {
	self.Value = v
}

func (self *NxmTunMetadata9Masked) GetValueMask() []byte {
	return self.ValueMask
}

func (self *NxmTunMetadata9Masked) SetValueMask(v []byte) {
	self.ValueMask = v
}

func (self *NxmTunMetadata9Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeNxmTunMetadata9Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunMetadata9Masked, error) {
	_nxmtunmetadata9masked := &NxmTunMetadata9Masked{Oxm: parent}
	_nxmtunmetadata9masked.Value = decoder.Read(int(_nxmtunmetadata9masked.TypeLen & 0xFF))
	_nxmtunmetadata9masked.ValueMask = decoder.Read(int(_nxmtunmetadata9masked.TypeLen & 0xFF))
	return _nxmtunmetadata9masked, nil
}

func NewNxmTunMetadata9Masked() *NxmTunMetadata9Masked {
	obj := &NxmTunMetadata9Masked{
		Oxm: NewOxm(91128),
	}
	return obj
}
func (self *NxmTunMetadata9Masked) GetOXMName() string {
	return "tun_metadata9_masked"
}

func (self *NxmTunMetadata9Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunMetadata9Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunMetadata9Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmTunSrc struct {
	*Oxm
	Value net.IP
}

type INxmTunSrc interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *NxmTunSrc) GetValue() net.IP {
	return self.Value
}

func (self *NxmTunSrc) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmTunSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeNxmTunSrc(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunSrc, error) {
	_nxmtunsrc := &NxmTunSrc{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmTunSrc packet too short: %d < 4", decoder.Length())
	}
	_nxmtunsrc.Value = net.IP(decoder.Read(4))
	return _nxmtunsrc, nil
}

func NewNxmTunSrc() *NxmTunSrc {
	obj := &NxmTunSrc{
		Oxm: NewOxm(81412),
	}
	return obj
}
func (self *NxmTunSrc) GetOXMName() string {
	return "tun_src"
}

func (self *NxmTunSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmTunSrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type INxmTunSrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *NxmTunSrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *NxmTunSrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *NxmTunSrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *NxmTunSrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *NxmTunSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeNxmTunSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmTunSrcMasked, error) {
	_nxmtunsrcmasked := &NxmTunSrcMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("NxmTunSrcMasked packet too short: %d < 8", decoder.Length())
	}
	_nxmtunsrcmasked.Value = net.IP(decoder.Read(4))
	_nxmtunsrcmasked.ValueMask = net.IP(decoder.Read(4))
	return _nxmtunsrcmasked, nil
}

func NewNxmTunSrcMasked() *NxmTunSrcMasked {
	obj := &NxmTunSrcMasked{
		Oxm: NewOxm(81672),
	}
	return obj
}
func (self *NxmTunSrcMasked) GetOXMName() string {
	return "tun_src_masked"
}

func (self *NxmTunSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmTunSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmTunSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmUdpDst struct {
	*Oxm
	Value uint16
}

type INxmUdpDst interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmUdpDst) GetValue() uint16 {
	return self.Value
}

func (self *NxmUdpDst) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmUdpDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmUdpDst(parent *Oxm, decoder *goloxi.Decoder) (*NxmUdpDst, error) {
	_nxmudpdst := &NxmUdpDst{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmUdpDst packet too short: %d < 2", decoder.Length())
	}
	_nxmudpdst.Value = uint16(decoder.ReadUint16())
	return _nxmudpdst, nil
}

func NewNxmUdpDst() *NxmUdpDst {
	obj := &NxmUdpDst{
		Oxm: NewOxm(6146),
	}
	return obj
}
func (self *NxmUdpDst) GetOXMName() string {
	return "udp_dst"
}

func (self *NxmUdpDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmUdpDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmUdpDstMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type INxmUdpDstMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *NxmUdpDstMasked) GetValue() uint16 {
	return self.Value
}

func (self *NxmUdpDstMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmUdpDstMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmUdpDstMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmUdpDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmUdpDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmUdpDstMasked, error) {
	_nxmudpdstmasked := &NxmUdpDstMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmUdpDstMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmudpdstmasked.Value = uint16(decoder.ReadUint16())
	_nxmudpdstmasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmudpdstmasked, nil
}

func NewNxmUdpDstMasked() *NxmUdpDstMasked {
	obj := &NxmUdpDstMasked{
		Oxm: NewOxm(6404),
	}
	return obj
}
func (self *NxmUdpDstMasked) GetOXMName() string {
	return "udp_dst_masked"
}

func (self *NxmUdpDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmUdpDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmUdpDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmUdpSrc struct {
	*Oxm
	Value uint16
}

type INxmUdpSrc interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmUdpSrc) GetValue() uint16 {
	return self.Value
}

func (self *NxmUdpSrc) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmUdpSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmUdpSrc(parent *Oxm, decoder *goloxi.Decoder) (*NxmUdpSrc, error) {
	_nxmudpsrc := &NxmUdpSrc{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmUdpSrc packet too short: %d < 2", decoder.Length())
	}
	_nxmudpsrc.Value = uint16(decoder.ReadUint16())
	return _nxmudpsrc, nil
}

func NewNxmUdpSrc() *NxmUdpSrc {
	obj := &NxmUdpSrc{
		Oxm: NewOxm(5634),
	}
	return obj
}
func (self *NxmUdpSrc) GetOXMName() string {
	return "udp_src"
}

func (self *NxmUdpSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmUdpSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmUdpSrcMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type INxmUdpSrcMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *NxmUdpSrcMasked) GetValue() uint16 {
	return self.Value
}

func (self *NxmUdpSrcMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmUdpSrcMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmUdpSrcMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmUdpSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmUdpSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmUdpSrcMasked, error) {
	_nxmudpsrcmasked := &NxmUdpSrcMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmUdpSrcMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmudpsrcmasked.Value = uint16(decoder.ReadUint16())
	_nxmudpsrcmasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmudpsrcmasked, nil
}

func NewNxmUdpSrcMasked() *NxmUdpSrcMasked {
	obj := &NxmUdpSrcMasked{
		Oxm: NewOxm(5892),
	}
	return obj
}
func (self *NxmUdpSrcMasked) GetOXMName() string {
	return "udp_src_masked"
}

func (self *NxmUdpSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmUdpSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmUdpSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmVlanTci struct {
	*Oxm
	Value uint16
}

type INxmVlanTci interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *NxmVlanTci) GetValue() uint16 {
	return self.Value
}

func (self *NxmVlanTci) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmVlanTci) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeNxmVlanTci(parent *Oxm, decoder *goloxi.Decoder) (*NxmVlanTci, error) {
	_nxmvlantci := &NxmVlanTci{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("NxmVlanTci packet too short: %d < 2", decoder.Length())
	}
	_nxmvlantci.Value = uint16(decoder.ReadUint16())
	return _nxmvlantci, nil
}

func NewNxmVlanTci() *NxmVlanTci {
	obj := &NxmVlanTci{
		Oxm: NewOxm(2050),
	}
	return obj
}
func (self *NxmVlanTci) GetOXMName() string {
	return "vlan_tci"
}

func (self *NxmVlanTci) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmVlanTci) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmVlanTciMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type INxmVlanTciMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *NxmVlanTciMasked) GetValue() uint16 {
	return self.Value
}

func (self *NxmVlanTciMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *NxmVlanTciMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *NxmVlanTciMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *NxmVlanTciMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeNxmVlanTciMasked(parent *Oxm, decoder *goloxi.Decoder) (*NxmVlanTciMasked, error) {
	_nxmvlantcimasked := &NxmVlanTciMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("NxmVlanTciMasked packet too short: %d < 4", decoder.Length())
	}
	_nxmvlantcimasked.Value = uint16(decoder.ReadUint16())
	_nxmvlantcimasked.ValueMask = uint16(decoder.ReadUint16())
	return _nxmvlantcimasked, nil
}

func NewNxmVlanTciMasked() *NxmVlanTciMasked {
	obj := &NxmVlanTciMasked{
		Oxm: NewOxm(2308),
	}
	return obj
}
func (self *NxmVlanTciMasked) GetOXMName() string {
	return "vlan_tci_masked"
}

func (self *NxmVlanTciMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmVlanTciMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmVlanTciMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmXxreg0 struct {
	*Oxm
	Value uint128
}

type INxmXxreg0 interface {
	goloxi.IOxm
	GetValue() uint128
}

func (self *NxmXxreg0) GetValue() uint128 {
	return self.Value
}

func (self *NxmXxreg0) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmXxreg0) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))

	return nil
}

func DecodeNxmXxreg0(parent *Oxm, decoder *goloxi.Decoder) (*NxmXxreg0, error) {
	_nxmxxreg0 := &NxmXxreg0{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmXxreg0 packet too short: %d < 16", decoder.Length())
	}
	_nxmxxreg0.Value = uint128(decoder.ReadUint128())
	return _nxmxxreg0, nil
}

func NewNxmXxreg0() *NxmXxreg0 {
	obj := &NxmXxreg0{
		Oxm: NewOxm(122384),
	}
	return obj
}
func (self *NxmXxreg0) GetOXMName() string {
	return "xxreg0"
}

func (self *NxmXxreg0) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmXxreg0) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmXxreg0Masked struct {
	*Oxm
	Value     uint128
	ValueMask uint128
}

type INxmXxreg0Masked interface {
	goloxi.IOxm
	GetValue() uint128
	GetValueMask() uint128
}

func (self *NxmXxreg0Masked) GetValue() uint128 {
	return self.Value
}

func (self *NxmXxreg0Masked) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmXxreg0Masked) GetValueMask() uint128 {
	return self.ValueMask
}

func (self *NxmXxreg0Masked) SetValueMask(v uint128) {
	self.ValueMask = v
}

func (self *NxmXxreg0Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))
	encoder.PutUint128(uint128(self.ValueMask))

	return nil
}

func DecodeNxmXxreg0Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmXxreg0Masked, error) {
	_nxmxxreg0masked := &NxmXxreg0Masked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmXxreg0Masked packet too short: %d < 32", decoder.Length())
	}
	_nxmxxreg0masked.Value = uint128(decoder.ReadUint128())
	_nxmxxreg0masked.ValueMask = uint128(decoder.ReadUint128())
	return _nxmxxreg0masked, nil
}

func NewNxmXxreg0Masked() *NxmXxreg0Masked {
	obj := &NxmXxreg0Masked{
		Oxm: NewOxm(122656),
	}
	return obj
}
func (self *NxmXxreg0Masked) GetOXMName() string {
	return "xxreg0_masked"
}

func (self *NxmXxreg0Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmXxreg0Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmXxreg0Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmXxreg1 struct {
	*Oxm
	Value uint128
}

type INxmXxreg1 interface {
	goloxi.IOxm
	GetValue() uint128
}

func (self *NxmXxreg1) GetValue() uint128 {
	return self.Value
}

func (self *NxmXxreg1) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmXxreg1) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))

	return nil
}

func DecodeNxmXxreg1(parent *Oxm, decoder *goloxi.Decoder) (*NxmXxreg1, error) {
	_nxmxxreg1 := &NxmXxreg1{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmXxreg1 packet too short: %d < 16", decoder.Length())
	}
	_nxmxxreg1.Value = uint128(decoder.ReadUint128())
	return _nxmxxreg1, nil
}

func NewNxmXxreg1() *NxmXxreg1 {
	obj := &NxmXxreg1{
		Oxm: NewOxm(122896),
	}
	return obj
}
func (self *NxmXxreg1) GetOXMName() string {
	return "xxreg1"
}

func (self *NxmXxreg1) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmXxreg1) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmXxreg1Masked struct {
	*Oxm
	Value     uint128
	ValueMask uint128
}

type INxmXxreg1Masked interface {
	goloxi.IOxm
	GetValue() uint128
	GetValueMask() uint128
}

func (self *NxmXxreg1Masked) GetValue() uint128 {
	return self.Value
}

func (self *NxmXxreg1Masked) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmXxreg1Masked) GetValueMask() uint128 {
	return self.ValueMask
}

func (self *NxmXxreg1Masked) SetValueMask(v uint128) {
	self.ValueMask = v
}

func (self *NxmXxreg1Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))
	encoder.PutUint128(uint128(self.ValueMask))

	return nil
}

func DecodeNxmXxreg1Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmXxreg1Masked, error) {
	_nxmxxreg1masked := &NxmXxreg1Masked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmXxreg1Masked packet too short: %d < 32", decoder.Length())
	}
	_nxmxxreg1masked.Value = uint128(decoder.ReadUint128())
	_nxmxxreg1masked.ValueMask = uint128(decoder.ReadUint128())
	return _nxmxxreg1masked, nil
}

func NewNxmXxreg1Masked() *NxmXxreg1Masked {
	obj := &NxmXxreg1Masked{
		Oxm: NewOxm(123168),
	}
	return obj
}
func (self *NxmXxreg1Masked) GetOXMName() string {
	return "xxreg1_masked"
}

func (self *NxmXxreg1Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmXxreg1Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmXxreg1Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmXxreg2 struct {
	*Oxm
	Value uint128
}

type INxmXxreg2 interface {
	goloxi.IOxm
	GetValue() uint128
}

func (self *NxmXxreg2) GetValue() uint128 {
	return self.Value
}

func (self *NxmXxreg2) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmXxreg2) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))

	return nil
}

func DecodeNxmXxreg2(parent *Oxm, decoder *goloxi.Decoder) (*NxmXxreg2, error) {
	_nxmxxreg2 := &NxmXxreg2{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmXxreg2 packet too short: %d < 16", decoder.Length())
	}
	_nxmxxreg2.Value = uint128(decoder.ReadUint128())
	return _nxmxxreg2, nil
}

func NewNxmXxreg2() *NxmXxreg2 {
	obj := &NxmXxreg2{
		Oxm: NewOxm(123408),
	}
	return obj
}
func (self *NxmXxreg2) GetOXMName() string {
	return "xxreg2"
}

func (self *NxmXxreg2) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmXxreg2) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmXxreg2Masked struct {
	*Oxm
	Value     uint128
	ValueMask uint128
}

type INxmXxreg2Masked interface {
	goloxi.IOxm
	GetValue() uint128
	GetValueMask() uint128
}

func (self *NxmXxreg2Masked) GetValue() uint128 {
	return self.Value
}

func (self *NxmXxreg2Masked) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmXxreg2Masked) GetValueMask() uint128 {
	return self.ValueMask
}

func (self *NxmXxreg2Masked) SetValueMask(v uint128) {
	self.ValueMask = v
}

func (self *NxmXxreg2Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))
	encoder.PutUint128(uint128(self.ValueMask))

	return nil
}

func DecodeNxmXxreg2Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmXxreg2Masked, error) {
	_nxmxxreg2masked := &NxmXxreg2Masked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmXxreg2Masked packet too short: %d < 32", decoder.Length())
	}
	_nxmxxreg2masked.Value = uint128(decoder.ReadUint128())
	_nxmxxreg2masked.ValueMask = uint128(decoder.ReadUint128())
	return _nxmxxreg2masked, nil
}

func NewNxmXxreg2Masked() *NxmXxreg2Masked {
	obj := &NxmXxreg2Masked{
		Oxm: NewOxm(123680),
	}
	return obj
}
func (self *NxmXxreg2Masked) GetOXMName() string {
	return "xxreg2_masked"
}

func (self *NxmXxreg2Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmXxreg2Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmXxreg2Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type NxmXxreg3 struct {
	*Oxm
	Value uint128
}

type INxmXxreg3 interface {
	goloxi.IOxm
	GetValue() uint128
}

func (self *NxmXxreg3) GetValue() uint128 {
	return self.Value
}

func (self *NxmXxreg3) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmXxreg3) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))

	return nil
}

func DecodeNxmXxreg3(parent *Oxm, decoder *goloxi.Decoder) (*NxmXxreg3, error) {
	_nxmxxreg3 := &NxmXxreg3{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("NxmXxreg3 packet too short: %d < 16", decoder.Length())
	}
	_nxmxxreg3.Value = uint128(decoder.ReadUint128())
	return _nxmxxreg3, nil
}

func NewNxmXxreg3() *NxmXxreg3 {
	obj := &NxmXxreg3{
		Oxm: NewOxm(123920),
	}
	return obj
}
func (self *NxmXxreg3) GetOXMName() string {
	return "xxreg3"
}

func (self *NxmXxreg3) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmXxreg3) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type NxmXxreg3Masked struct {
	*Oxm
	Value     uint128
	ValueMask uint128
}

type INxmXxreg3Masked interface {
	goloxi.IOxm
	GetValue() uint128
	GetValueMask() uint128
}

func (self *NxmXxreg3Masked) GetValue() uint128 {
	return self.Value
}

func (self *NxmXxreg3Masked) SetValue(v uint128) {
	self.Value = v
}

func (self *NxmXxreg3Masked) GetValueMask() uint128 {
	return self.ValueMask
}

func (self *NxmXxreg3Masked) SetValueMask(v uint128) {
	self.ValueMask = v
}

func (self *NxmXxreg3Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))
	encoder.PutUint128(uint128(self.ValueMask))

	return nil
}

func DecodeNxmXxreg3Masked(parent *Oxm, decoder *goloxi.Decoder) (*NxmXxreg3Masked, error) {
	_nxmxxreg3masked := &NxmXxreg3Masked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("NxmXxreg3Masked packet too short: %d < 32", decoder.Length())
	}
	_nxmxxreg3masked.Value = uint128(decoder.ReadUint128())
	_nxmxxreg3masked.ValueMask = uint128(decoder.ReadUint128())
	return _nxmxxreg3masked, nil
}

func NewNxmXxreg3Masked() *NxmXxreg3Masked {
	obj := &NxmXxreg3Masked{
		Oxm: NewOxm(124192),
	}
	return obj
}
func (self *NxmXxreg3Masked) GetOXMName() string {
	return "xxreg3_masked"
}

func (self *NxmXxreg3Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *NxmXxreg3Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *NxmXxreg3Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmArpOp struct {
	*Oxm
	Value uint16
}

type IOxmArpOp interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmArpOp) GetValue() uint16 {
	return self.Value
}

func (self *OxmArpOp) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmArpOp) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmArpOp(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpOp, error) {
	_oxmarpop := &OxmArpOp{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmArpOp packet too short: %d < 2", decoder.Length())
	}
	_oxmarpop.Value = uint16(decoder.ReadUint16())
	return _oxmarpop, nil
}

func NewOxmArpOp() *OxmArpOp {
	obj := &OxmArpOp{
		Oxm: NewOxm(2147494402),
	}
	return obj
}
func (self *OxmArpOp) GetOXMName() string {
	return "arp_op"
}

func (self *OxmArpOp) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpOp) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmArpOpMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmArpOpMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmArpOpMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmArpOpMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmArpOpMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmArpOpMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmArpOpMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmArpOpMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpOpMasked, error) {
	_oxmarpopmasked := &OxmArpOpMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmArpOpMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmarpopmasked.Value = uint16(decoder.ReadUint16())
	_oxmarpopmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmarpopmasked, nil
}

func NewOxmArpOpMasked() *OxmArpOpMasked {
	obj := &OxmArpOpMasked{
		Oxm: NewOxm(2147494660),
	}
	return obj
}
func (self *OxmArpOpMasked) GetOXMName() string {
	return "arp_op_masked"
}

func (self *OxmArpOpMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpOpMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmArpOpMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmArpSha struct {
	*Oxm
	Value net.HardwareAddr
}

type IOxmArpSha interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *OxmArpSha) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmArpSha) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmArpSha) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeOxmArpSha(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpSha, error) {
	_oxmarpsha := &OxmArpSha{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("OxmArpSha packet too short: %d < 6", decoder.Length())
	}
	_oxmarpsha.Value = net.HardwareAddr(decoder.Read(6))
	return _oxmarpsha, nil
}

func NewOxmArpSha() *OxmArpSha {
	obj := &OxmArpSha{
		Oxm: NewOxm(2147495942),
	}
	return obj
}
func (self *OxmArpSha) GetOXMName() string {
	return "arp_sha"
}

func (self *OxmArpSha) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpSha) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmArpShaMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type IOxmArpShaMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *OxmArpShaMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmArpShaMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmArpShaMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *OxmArpShaMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *OxmArpShaMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeOxmArpShaMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpShaMasked, error) {
	_oxmarpshamasked := &OxmArpShaMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("OxmArpShaMasked packet too short: %d < 12", decoder.Length())
	}
	_oxmarpshamasked.Value = net.HardwareAddr(decoder.Read(6))
	_oxmarpshamasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _oxmarpshamasked, nil
}

func NewOxmArpShaMasked() *OxmArpShaMasked {
	obj := &OxmArpShaMasked{
		Oxm: NewOxm(2147496204),
	}
	return obj
}
func (self *OxmArpShaMasked) GetOXMName() string {
	return "arp_sha_masked"
}

func (self *OxmArpShaMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpShaMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmArpShaMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmArpSpa struct {
	*Oxm
	Value uint32
}

type IOxmArpSpa interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmArpSpa) GetValue() uint32 {
	return self.Value
}

func (self *OxmArpSpa) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmArpSpa) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmArpSpa(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpSpa, error) {
	_oxmarpspa := &OxmArpSpa{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmArpSpa packet too short: %d < 4", decoder.Length())
	}
	_oxmarpspa.Value = uint32(decoder.ReadUint32())
	return _oxmarpspa, nil
}

func NewOxmArpSpa() *OxmArpSpa {
	obj := &OxmArpSpa{
		Oxm: NewOxm(2147494916),
	}
	return obj
}
func (self *OxmArpSpa) GetOXMName() string {
	return "arp_spa"
}

func (self *OxmArpSpa) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpSpa) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmArpSpaMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmArpSpaMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmArpSpaMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmArpSpaMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmArpSpaMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmArpSpaMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmArpSpaMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmArpSpaMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpSpaMasked, error) {
	_oxmarpspamasked := &OxmArpSpaMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmArpSpaMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmarpspamasked.Value = uint32(decoder.ReadUint32())
	_oxmarpspamasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmarpspamasked, nil
}

func NewOxmArpSpaMasked() *OxmArpSpaMasked {
	obj := &OxmArpSpaMasked{
		Oxm: NewOxm(2147495176),
	}
	return obj
}
func (self *OxmArpSpaMasked) GetOXMName() string {
	return "arp_spa_masked"
}

func (self *OxmArpSpaMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpSpaMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmArpSpaMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmArpTha struct {
	*Oxm
	Value net.HardwareAddr
}

type IOxmArpTha interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *OxmArpTha) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmArpTha) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmArpTha) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeOxmArpTha(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpTha, error) {
	_oxmarptha := &OxmArpTha{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("OxmArpTha packet too short: %d < 6", decoder.Length())
	}
	_oxmarptha.Value = net.HardwareAddr(decoder.Read(6))
	return _oxmarptha, nil
}

func NewOxmArpTha() *OxmArpTha {
	obj := &OxmArpTha{
		Oxm: NewOxm(2147496454),
	}
	return obj
}
func (self *OxmArpTha) GetOXMName() string {
	return "arp_tha"
}

func (self *OxmArpTha) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpTha) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmArpThaMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type IOxmArpThaMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *OxmArpThaMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmArpThaMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmArpThaMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *OxmArpThaMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *OxmArpThaMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeOxmArpThaMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpThaMasked, error) {
	_oxmarpthamasked := &OxmArpThaMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("OxmArpThaMasked packet too short: %d < 12", decoder.Length())
	}
	_oxmarpthamasked.Value = net.HardwareAddr(decoder.Read(6))
	_oxmarpthamasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _oxmarpthamasked, nil
}

func NewOxmArpThaMasked() *OxmArpThaMasked {
	obj := &OxmArpThaMasked{
		Oxm: NewOxm(2147496716),
	}
	return obj
}
func (self *OxmArpThaMasked) GetOXMName() string {
	return "arp_tha_masked"
}

func (self *OxmArpThaMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpThaMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmArpThaMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmArpTpa struct {
	*Oxm
	Value uint32
}

type IOxmArpTpa interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmArpTpa) GetValue() uint32 {
	return self.Value
}

func (self *OxmArpTpa) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmArpTpa) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmArpTpa(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpTpa, error) {
	_oxmarptpa := &OxmArpTpa{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmArpTpa packet too short: %d < 4", decoder.Length())
	}
	_oxmarptpa.Value = uint32(decoder.ReadUint32())
	return _oxmarptpa, nil
}

func NewOxmArpTpa() *OxmArpTpa {
	obj := &OxmArpTpa{
		Oxm: NewOxm(2147495428),
	}
	return obj
}
func (self *OxmArpTpa) GetOXMName() string {
	return "arp_tpa"
}

func (self *OxmArpTpa) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpTpa) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmArpTpaMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmArpTpaMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmArpTpaMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmArpTpaMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmArpTpaMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmArpTpaMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmArpTpaMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmArpTpaMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmArpTpaMasked, error) {
	_oxmarptpamasked := &OxmArpTpaMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmArpTpaMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmarptpamasked.Value = uint32(decoder.ReadUint32())
	_oxmarptpamasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmarptpamasked, nil
}

func NewOxmArpTpaMasked() *OxmArpTpaMasked {
	obj := &OxmArpTpaMasked{
		Oxm: NewOxm(2147495688),
	}
	return obj
}
func (self *OxmArpTpaMasked) GetOXMName() string {
	return "arp_tpa_masked"
}

func (self *OxmArpTpaMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmArpTpaMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmArpTpaMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnEgrPortGroupId struct {
	*Oxm
	Value uint32
}

type IOxmBsnEgrPortGroupId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnEgrPortGroupId) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnEgrPortGroupId) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnEgrPortGroupId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnEgrPortGroupId(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnEgrPortGroupId, error) {
	_oxmbsnegrportgroupid := &OxmBsnEgrPortGroupId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnEgrPortGroupId packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnegrportgroupid.Value = uint32(decoder.ReadUint32())
	return _oxmbsnegrportgroupid, nil
}

func NewOxmBsnEgrPortGroupId() *OxmBsnEgrPortGroupId {
	obj := &OxmBsnEgrPortGroupId{
		Oxm: NewOxm(200196),
	}
	return obj
}
func (self *OxmBsnEgrPortGroupId) GetOXMName() string {
	return "bsn_egr_port_group_id"
}

func (self *OxmBsnEgrPortGroupId) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnEgrPortGroupId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnEgrPortGroupIdMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnEgrPortGroupIdMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnEgrPortGroupIdMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnEgrPortGroupIdMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnEgrPortGroupIdMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnEgrPortGroupIdMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnEgrPortGroupIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnEgrPortGroupIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnEgrPortGroupIdMasked, error) {
	_oxmbsnegrportgroupidmasked := &OxmBsnEgrPortGroupIdMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnEgrPortGroupIdMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnegrportgroupidmasked.Value = uint32(decoder.ReadUint32())
	_oxmbsnegrportgroupidmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnegrportgroupidmasked, nil
}

func NewOxmBsnEgrPortGroupIdMasked() *OxmBsnEgrPortGroupIdMasked {
	obj := &OxmBsnEgrPortGroupIdMasked{
		Oxm: NewOxm(200456),
	}
	return obj
}
func (self *OxmBsnEgrPortGroupIdMasked) GetOXMName() string {
	return "bsn_egr_port_group_id_masked"
}

func (self *OxmBsnEgrPortGroupIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnEgrPortGroupIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnEgrPortGroupIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnGlobalVrfAllowed struct {
	*Oxm
	Value uint8
}

type IOxmBsnGlobalVrfAllowed interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmBsnGlobalVrfAllowed) GetValue() uint8 {
	return self.Value
}

func (self *OxmBsnGlobalVrfAllowed) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmBsnGlobalVrfAllowed) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmBsnGlobalVrfAllowed(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnGlobalVrfAllowed, error) {
	_oxmbsnglobalvrfallowed := &OxmBsnGlobalVrfAllowed{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmBsnGlobalVrfAllowed packet too short: %d < 1", decoder.Length())
	}
	_oxmbsnglobalvrfallowed.Value = uint8(decoder.ReadByte())
	return _oxmbsnglobalvrfallowed, nil
}

func NewOxmBsnGlobalVrfAllowed() *OxmBsnGlobalVrfAllowed {
	obj := &OxmBsnGlobalVrfAllowed{
		Oxm: NewOxm(198145),
	}
	return obj
}
func (self *OxmBsnGlobalVrfAllowed) GetOXMName() string {
	return "bsn_global_vrf_allowed"
}

func (self *OxmBsnGlobalVrfAllowed) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnGlobalVrfAllowed) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnGlobalVrfAllowedMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmBsnGlobalVrfAllowedMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmBsnGlobalVrfAllowedMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmBsnGlobalVrfAllowedMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmBsnGlobalVrfAllowedMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmBsnGlobalVrfAllowedMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmBsnGlobalVrfAllowedMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmBsnGlobalVrfAllowedMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnGlobalVrfAllowedMasked, error) {
	_oxmbsnglobalvrfallowedmasked := &OxmBsnGlobalVrfAllowedMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmBsnGlobalVrfAllowedMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmbsnglobalvrfallowedmasked.Value = uint8(decoder.ReadByte())
	_oxmbsnglobalvrfallowedmasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmbsnglobalvrfallowedmasked, nil
}

func NewOxmBsnGlobalVrfAllowedMasked() *OxmBsnGlobalVrfAllowedMasked {
	obj := &OxmBsnGlobalVrfAllowedMasked{
		Oxm: NewOxm(198402),
	}
	return obj
}
func (self *OxmBsnGlobalVrfAllowedMasked) GetOXMName() string {
	return "bsn_global_vrf_allowed_masked"
}

func (self *OxmBsnGlobalVrfAllowedMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnGlobalVrfAllowedMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnGlobalVrfAllowedMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnInPorts128 struct {
	*Oxm
	Value Bitmap128
}

type IOxmBsnInPorts128 interface {
	goloxi.IOxm
	GetValue() Bitmap128
}

func (self *OxmBsnInPorts128) GetValue() Bitmap128 {
	return self.Value
}

func (self *OxmBsnInPorts128) SetValue(v Bitmap128) {
	self.Value = v
}

func (self *OxmBsnInPorts128) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	self.Value.Serialize(encoder)

	return nil
}

func DecodeOxmBsnInPorts128(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInPorts128, error) {
	_oxmbsninports128 := &OxmBsnInPorts128{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("OxmBsnInPorts128 packet too short: %d < 16", decoder.Length())
	}
	_oxmbsninports128.Value.Decode(decoder)
	return _oxmbsninports128, nil
}

func NewOxmBsnInPorts128() *OxmBsnInPorts128 {
	obj := &OxmBsnInPorts128{
		Oxm: NewOxm(196624),
	}
	return obj
}
func (self *OxmBsnInPorts128) GetOXMName() string {
	return "bsn_in_ports_128"
}

func (self *OxmBsnInPorts128) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInPorts128) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnInPorts128Masked struct {
	*Oxm
	Value     Bitmap128
	ValueMask Bitmap128
}

type IOxmBsnInPorts128Masked interface {
	goloxi.IOxm
	GetValue() Bitmap128
	GetValueMask() Bitmap128
}

func (self *OxmBsnInPorts128Masked) GetValue() Bitmap128 {
	return self.Value
}

func (self *OxmBsnInPorts128Masked) SetValue(v Bitmap128) {
	self.Value = v
}

func (self *OxmBsnInPorts128Masked) GetValueMask() Bitmap128 {
	return self.ValueMask
}

func (self *OxmBsnInPorts128Masked) SetValueMask(v Bitmap128) {
	self.ValueMask = v
}

func (self *OxmBsnInPorts128Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	self.Value.Serialize(encoder)
	self.ValueMask.Serialize(encoder)

	return nil
}

func DecodeOxmBsnInPorts128Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInPorts128Masked, error) {
	_oxmbsninports128masked := &OxmBsnInPorts128Masked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("OxmBsnInPorts128Masked packet too short: %d < 32", decoder.Length())
	}
	_oxmbsninports128masked.Value.Decode(decoder)
	_oxmbsninports128masked.ValueMask.Decode(decoder)
	return _oxmbsninports128masked, nil
}

func NewOxmBsnInPorts128Masked() *OxmBsnInPorts128Masked {
	obj := &OxmBsnInPorts128Masked{
		Oxm: NewOxm(196896),
	}
	return obj
}
func (self *OxmBsnInPorts128Masked) GetOXMName() string {
	return "bsn_in_ports_128_masked"
}

func (self *OxmBsnInPorts128Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInPorts128Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnInPorts128Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnInPorts512 struct {
	*Oxm
	Value Bitmap512
}

type IOxmBsnInPorts512 interface {
	goloxi.IOxm
	GetValue() Bitmap512
}

func (self *OxmBsnInPorts512) GetValue() Bitmap512 {
	return self.Value
}

func (self *OxmBsnInPorts512) SetValue(v Bitmap512) {
	self.Value = v
}

func (self *OxmBsnInPorts512) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	self.Value.Serialize(encoder)

	return nil
}

func DecodeOxmBsnInPorts512(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInPorts512, error) {
	_oxmbsninports512 := &OxmBsnInPorts512{Oxm: parent}
	if decoder.Length() < 64 {
		return nil, fmt.Errorf("OxmBsnInPorts512 packet too short: %d < 64", decoder.Length())
	}
	_oxmbsninports512.Value.Decode(decoder)
	return _oxmbsninports512, nil
}

func NewOxmBsnInPorts512() *OxmBsnInPorts512 {
	obj := &OxmBsnInPorts512{
		Oxm: NewOxm(206400),
	}
	return obj
}
func (self *OxmBsnInPorts512) GetOXMName() string {
	return "bsn_in_ports_512"
}

func (self *OxmBsnInPorts512) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInPorts512) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnInPorts512Masked struct {
	*Oxm
	Value     Bitmap512
	ValueMask Bitmap512
}

type IOxmBsnInPorts512Masked interface {
	goloxi.IOxm
	GetValue() Bitmap512
	GetValueMask() Bitmap512
}

func (self *OxmBsnInPorts512Masked) GetValue() Bitmap512 {
	return self.Value
}

func (self *OxmBsnInPorts512Masked) SetValue(v Bitmap512) {
	self.Value = v
}

func (self *OxmBsnInPorts512Masked) GetValueMask() Bitmap512 {
	return self.ValueMask
}

func (self *OxmBsnInPorts512Masked) SetValueMask(v Bitmap512) {
	self.ValueMask = v
}

func (self *OxmBsnInPorts512Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	self.Value.Serialize(encoder)
	self.ValueMask.Serialize(encoder)

	return nil
}

func DecodeOxmBsnInPorts512Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInPorts512Masked, error) {
	_oxmbsninports512masked := &OxmBsnInPorts512Masked{Oxm: parent}
	if decoder.Length() < 128 {
		return nil, fmt.Errorf("OxmBsnInPorts512Masked packet too short: %d < 128", decoder.Length())
	}
	_oxmbsninports512masked.Value.Decode(decoder)
	_oxmbsninports512masked.ValueMask.Decode(decoder)
	return _oxmbsninports512masked, nil
}

func NewOxmBsnInPorts512Masked() *OxmBsnInPorts512Masked {
	obj := &OxmBsnInPorts512Masked{
		Oxm: NewOxm(206720),
	}
	return obj
}
func (self *OxmBsnInPorts512Masked) GetOXMName() string {
	return "bsn_in_ports_512_masked"
}

func (self *OxmBsnInPorts512Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInPorts512Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnInPorts512Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnIngressPortGroupId struct {
	*Oxm
	Value uint32
}

type IOxmBsnIngressPortGroupId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnIngressPortGroupId) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnIngressPortGroupId) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnIngressPortGroupId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnIngressPortGroupId(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnIngressPortGroupId, error) {
	_oxmbsningressportgroupid := &OxmBsnIngressPortGroupId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnIngressPortGroupId packet too short: %d < 4", decoder.Length())
	}
	_oxmbsningressportgroupid.Value = uint32(decoder.ReadUint32())
	return _oxmbsningressportgroupid, nil
}

func NewOxmBsnIngressPortGroupId() *OxmBsnIngressPortGroupId {
	obj := &OxmBsnIngressPortGroupId{
		Oxm: NewOxm(206852),
	}
	return obj
}
func (self *OxmBsnIngressPortGroupId) GetOXMName() string {
	return "bsn_ingress_port_group_id"
}

func (self *OxmBsnIngressPortGroupId) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnIngressPortGroupId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnIngressPortGroupIdMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnIngressPortGroupIdMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnIngressPortGroupIdMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnIngressPortGroupIdMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnIngressPortGroupIdMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnIngressPortGroupIdMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnIngressPortGroupIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnIngressPortGroupIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnIngressPortGroupIdMasked, error) {
	_oxmbsningressportgroupidmasked := &OxmBsnIngressPortGroupIdMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnIngressPortGroupIdMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsningressportgroupidmasked.Value = uint32(decoder.ReadUint32())
	_oxmbsningressportgroupidmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsningressportgroupidmasked, nil
}

func NewOxmBsnIngressPortGroupIdMasked() *OxmBsnIngressPortGroupIdMasked {
	obj := &OxmBsnIngressPortGroupIdMasked{
		Oxm: NewOxm(207112),
	}
	return obj
}
func (self *OxmBsnIngressPortGroupIdMasked) GetOXMName() string {
	return "bsn_ingress_port_group_id_masked"
}

func (self *OxmBsnIngressPortGroupIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnIngressPortGroupIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnIngressPortGroupIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnInnerEthDst struct {
	*Oxm
	Value net.HardwareAddr
}

type IOxmBsnInnerEthDst interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *OxmBsnInnerEthDst) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmBsnInnerEthDst) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmBsnInnerEthDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeOxmBsnInnerEthDst(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInnerEthDst, error) {
	_oxmbsninnerethdst := &OxmBsnInnerEthDst{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("OxmBsnInnerEthDst packet too short: %d < 6", decoder.Length())
	}
	_oxmbsninnerethdst.Value = net.HardwareAddr(decoder.Read(6))
	return _oxmbsninnerethdst, nil
}

func NewOxmBsnInnerEthDst() *OxmBsnInnerEthDst {
	obj := &OxmBsnInnerEthDst{
		Oxm: NewOxm(207878),
	}
	return obj
}
func (self *OxmBsnInnerEthDst) GetOXMName() string {
	return "bsn_inner_eth_dst"
}

func (self *OxmBsnInnerEthDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInnerEthDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnInnerEthDstMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type IOxmBsnInnerEthDstMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *OxmBsnInnerEthDstMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmBsnInnerEthDstMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmBsnInnerEthDstMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *OxmBsnInnerEthDstMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *OxmBsnInnerEthDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeOxmBsnInnerEthDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInnerEthDstMasked, error) {
	_oxmbsninnerethdstmasked := &OxmBsnInnerEthDstMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("OxmBsnInnerEthDstMasked packet too short: %d < 12", decoder.Length())
	}
	_oxmbsninnerethdstmasked.Value = net.HardwareAddr(decoder.Read(6))
	_oxmbsninnerethdstmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _oxmbsninnerethdstmasked, nil
}

func NewOxmBsnInnerEthDstMasked() *OxmBsnInnerEthDstMasked {
	obj := &OxmBsnInnerEthDstMasked{
		Oxm: NewOxm(208140),
	}
	return obj
}
func (self *OxmBsnInnerEthDstMasked) GetOXMName() string {
	return "bsn_inner_eth_dst_masked"
}

func (self *OxmBsnInnerEthDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInnerEthDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnInnerEthDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnInnerEthSrc struct {
	*Oxm
	Value net.HardwareAddr
}

type IOxmBsnInnerEthSrc interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *OxmBsnInnerEthSrc) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmBsnInnerEthSrc) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmBsnInnerEthSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeOxmBsnInnerEthSrc(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInnerEthSrc, error) {
	_oxmbsninnerethsrc := &OxmBsnInnerEthSrc{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("OxmBsnInnerEthSrc packet too short: %d < 6", decoder.Length())
	}
	_oxmbsninnerethsrc.Value = net.HardwareAddr(decoder.Read(6))
	return _oxmbsninnerethsrc, nil
}

func NewOxmBsnInnerEthSrc() *OxmBsnInnerEthSrc {
	obj := &OxmBsnInnerEthSrc{
		Oxm: NewOxm(208390),
	}
	return obj
}
func (self *OxmBsnInnerEthSrc) GetOXMName() string {
	return "bsn_inner_eth_src"
}

func (self *OxmBsnInnerEthSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInnerEthSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnInnerEthSrcMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type IOxmBsnInnerEthSrcMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *OxmBsnInnerEthSrcMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmBsnInnerEthSrcMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmBsnInnerEthSrcMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *OxmBsnInnerEthSrcMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *OxmBsnInnerEthSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeOxmBsnInnerEthSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInnerEthSrcMasked, error) {
	_oxmbsninnerethsrcmasked := &OxmBsnInnerEthSrcMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("OxmBsnInnerEthSrcMasked packet too short: %d < 12", decoder.Length())
	}
	_oxmbsninnerethsrcmasked.Value = net.HardwareAddr(decoder.Read(6))
	_oxmbsninnerethsrcmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _oxmbsninnerethsrcmasked, nil
}

func NewOxmBsnInnerEthSrcMasked() *OxmBsnInnerEthSrcMasked {
	obj := &OxmBsnInnerEthSrcMasked{
		Oxm: NewOxm(208652),
	}
	return obj
}
func (self *OxmBsnInnerEthSrcMasked) GetOXMName() string {
	return "bsn_inner_eth_src_masked"
}

func (self *OxmBsnInnerEthSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInnerEthSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnInnerEthSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnInnerVlanVid struct {
	*Oxm
	Value uint16
}

type IOxmBsnInnerVlanVid interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmBsnInnerVlanVid) GetValue() uint16 {
	return self.Value
}

func (self *OxmBsnInnerVlanVid) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmBsnInnerVlanVid) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmBsnInnerVlanVid(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInnerVlanVid, error) {
	_oxmbsninnervlanvid := &OxmBsnInnerVlanVid{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmBsnInnerVlanVid packet too short: %d < 2", decoder.Length())
	}
	_oxmbsninnervlanvid.Value = uint16(decoder.ReadUint16())
	return _oxmbsninnervlanvid, nil
}

func NewOxmBsnInnerVlanVid() *OxmBsnInnerVlanVid {
	obj := &OxmBsnInnerVlanVid{
		Oxm: NewOxm(208898),
	}
	return obj
}
func (self *OxmBsnInnerVlanVid) GetOXMName() string {
	return "bsn_inner_vlan_vid"
}

func (self *OxmBsnInnerVlanVid) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInnerVlanVid) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnInnerVlanVidMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmBsnInnerVlanVidMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmBsnInnerVlanVidMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmBsnInnerVlanVidMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmBsnInnerVlanVidMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmBsnInnerVlanVidMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmBsnInnerVlanVidMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmBsnInnerVlanVidMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnInnerVlanVidMasked, error) {
	_oxmbsninnervlanvidmasked := &OxmBsnInnerVlanVidMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnInnerVlanVidMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmbsninnervlanvidmasked.Value = uint16(decoder.ReadUint16())
	_oxmbsninnervlanvidmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmbsninnervlanvidmasked, nil
}

func NewOxmBsnInnerVlanVidMasked() *OxmBsnInnerVlanVidMasked {
	obj := &OxmBsnInnerVlanVidMasked{
		Oxm: NewOxm(209156),
	}
	return obj
}
func (self *OxmBsnInnerVlanVidMasked) GetOXMName() string {
	return "bsn_inner_vlan_vid_masked"
}

func (self *OxmBsnInnerVlanVidMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnInnerVlanVidMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnInnerVlanVidMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnIpFragmentation struct {
	*Oxm
	Value uint8
}

type IOxmBsnIpFragmentation interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmBsnIpFragmentation) GetValue() uint8 {
	return self.Value
}

func (self *OxmBsnIpFragmentation) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmBsnIpFragmentation) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmBsnIpFragmentation(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnIpFragmentation, error) {
	_oxmbsnipfragmentation := &OxmBsnIpFragmentation{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmBsnIpFragmentation packet too short: %d < 1", decoder.Length())
	}
	_oxmbsnipfragmentation.Value = uint8(decoder.ReadByte())
	return _oxmbsnipfragmentation, nil
}

func NewOxmBsnIpFragmentation() *OxmBsnIpFragmentation {
	obj := &OxmBsnIpFragmentation{
		Oxm: NewOxm(209921),
	}
	return obj
}
func (self *OxmBsnIpFragmentation) GetOXMName() string {
	return "bsn_ip_fragmentation"
}

func (self *OxmBsnIpFragmentation) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnIpFragmentation) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnIpFragmentationMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmBsnIpFragmentationMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmBsnIpFragmentationMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmBsnIpFragmentationMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmBsnIpFragmentationMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmBsnIpFragmentationMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmBsnIpFragmentationMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmBsnIpFragmentationMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnIpFragmentationMasked, error) {
	_oxmbsnipfragmentationmasked := &OxmBsnIpFragmentationMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmBsnIpFragmentationMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmbsnipfragmentationmasked.Value = uint8(decoder.ReadByte())
	_oxmbsnipfragmentationmasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmbsnipfragmentationmasked, nil
}

func NewOxmBsnIpFragmentationMasked() *OxmBsnIpFragmentationMasked {
	obj := &OxmBsnIpFragmentationMasked{
		Oxm: NewOxm(210178),
	}
	return obj
}
func (self *OxmBsnIpFragmentationMasked) GetOXMName() string {
	return "bsn_ip_fragmentation_masked"
}

func (self *OxmBsnIpFragmentationMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnIpFragmentationMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnIpFragmentationMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnL2CacheHit struct {
	*Oxm
	Value uint8
}

type IOxmBsnL2CacheHit interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmBsnL2CacheHit) GetValue() uint8 {
	return self.Value
}

func (self *OxmBsnL2CacheHit) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmBsnL2CacheHit) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmBsnL2CacheHit(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnL2CacheHit, error) {
	_oxmbsnl2cachehit := &OxmBsnL2CacheHit{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmBsnL2CacheHit packet too short: %d < 1", decoder.Length())
	}
	_oxmbsnl2cachehit.Value = uint8(decoder.ReadByte())
	return _oxmbsnl2cachehit, nil
}

func NewOxmBsnL2CacheHit() *OxmBsnL2CacheHit {
	obj := &OxmBsnL2CacheHit{
		Oxm: NewOxm(205825),
	}
	return obj
}
func (self *OxmBsnL2CacheHit) GetOXMName() string {
	return "bsn_l2_cache_hit"
}

func (self *OxmBsnL2CacheHit) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnL2CacheHit) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnL2CacheHitMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmBsnL2CacheHitMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmBsnL2CacheHitMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmBsnL2CacheHitMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmBsnL2CacheHitMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmBsnL2CacheHitMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmBsnL2CacheHitMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmBsnL2CacheHitMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnL2CacheHitMasked, error) {
	_oxmbsnl2cachehitmasked := &OxmBsnL2CacheHitMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmBsnL2CacheHitMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmbsnl2cachehitmasked.Value = uint8(decoder.ReadByte())
	_oxmbsnl2cachehitmasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmbsnl2cachehitmasked, nil
}

func NewOxmBsnL2CacheHitMasked() *OxmBsnL2CacheHitMasked {
	obj := &OxmBsnL2CacheHitMasked{
		Oxm: NewOxm(206082),
	}
	return obj
}
func (self *OxmBsnL2CacheHitMasked) GetOXMName() string {
	return "bsn_l2_cache_hit_masked"
}

func (self *OxmBsnL2CacheHitMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnL2CacheHitMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnL2CacheHitMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnL3DstClassId struct {
	*Oxm
	Value uint32
}

type IOxmBsnL3DstClassId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnL3DstClassId) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnL3DstClassId) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnL3DstClassId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnL3DstClassId(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnL3DstClassId, error) {
	_oxmbsnl3dstclassid := &OxmBsnL3DstClassId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnL3DstClassId packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnl3dstclassid.Value = uint32(decoder.ReadUint32())
	return _oxmbsnl3dstclassid, nil
}

func NewOxmBsnL3DstClassId() *OxmBsnL3DstClassId {
	obj := &OxmBsnL3DstClassId{
		Oxm: NewOxm(199684),
	}
	return obj
}
func (self *OxmBsnL3DstClassId) GetOXMName() string {
	return "bsn_l3_dst_class_id"
}

func (self *OxmBsnL3DstClassId) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnL3DstClassId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnL3DstClassIdMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnL3DstClassIdMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnL3DstClassIdMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnL3DstClassIdMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnL3DstClassIdMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnL3DstClassIdMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnL3DstClassIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnL3DstClassIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnL3DstClassIdMasked, error) {
	_oxmbsnl3dstclassidmasked := &OxmBsnL3DstClassIdMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnL3DstClassIdMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnl3dstclassidmasked.Value = uint32(decoder.ReadUint32())
	_oxmbsnl3dstclassidmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnl3dstclassidmasked, nil
}

func NewOxmBsnL3DstClassIdMasked() *OxmBsnL3DstClassIdMasked {
	obj := &OxmBsnL3DstClassIdMasked{
		Oxm: NewOxm(199944),
	}
	return obj
}
func (self *OxmBsnL3DstClassIdMasked) GetOXMName() string {
	return "bsn_l3_dst_class_id_masked"
}

func (self *OxmBsnL3DstClassIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnL3DstClassIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnL3DstClassIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnL3InterfaceClassId struct {
	*Oxm
	Value uint32
}

type IOxmBsnL3InterfaceClassId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnL3InterfaceClassId) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnL3InterfaceClassId) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnL3InterfaceClassId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnL3InterfaceClassId(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnL3InterfaceClassId, error) {
	_oxmbsnl3interfaceclassid := &OxmBsnL3InterfaceClassId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnL3InterfaceClassId packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnl3interfaceclassid.Value = uint32(decoder.ReadUint32())
	return _oxmbsnl3interfaceclassid, nil
}

func NewOxmBsnL3InterfaceClassId() *OxmBsnL3InterfaceClassId {
	obj := &OxmBsnL3InterfaceClassId{
		Oxm: NewOxm(198660),
	}
	return obj
}
func (self *OxmBsnL3InterfaceClassId) GetOXMName() string {
	return "bsn_l3_interface_class_id"
}

func (self *OxmBsnL3InterfaceClassId) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnL3InterfaceClassId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnL3InterfaceClassIdMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnL3InterfaceClassIdMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnL3InterfaceClassIdMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnL3InterfaceClassIdMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnL3InterfaceClassIdMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnL3InterfaceClassIdMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnL3InterfaceClassIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnL3InterfaceClassIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnL3InterfaceClassIdMasked, error) {
	_oxmbsnl3interfaceclassidmasked := &OxmBsnL3InterfaceClassIdMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnL3InterfaceClassIdMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnl3interfaceclassidmasked.Value = uint32(decoder.ReadUint32())
	_oxmbsnl3interfaceclassidmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnl3interfaceclassidmasked, nil
}

func NewOxmBsnL3InterfaceClassIdMasked() *OxmBsnL3InterfaceClassIdMasked {
	obj := &OxmBsnL3InterfaceClassIdMasked{
		Oxm: NewOxm(198920),
	}
	return obj
}
func (self *OxmBsnL3InterfaceClassIdMasked) GetOXMName() string {
	return "bsn_l3_interface_class_id_masked"
}

func (self *OxmBsnL3InterfaceClassIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnL3InterfaceClassIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnL3InterfaceClassIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnL3SrcClassId struct {
	*Oxm
	Value uint32
}

type IOxmBsnL3SrcClassId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnL3SrcClassId) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnL3SrcClassId) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnL3SrcClassId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnL3SrcClassId(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnL3SrcClassId, error) {
	_oxmbsnl3srcclassid := &OxmBsnL3SrcClassId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnL3SrcClassId packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnl3srcclassid.Value = uint32(decoder.ReadUint32())
	return _oxmbsnl3srcclassid, nil
}

func NewOxmBsnL3SrcClassId() *OxmBsnL3SrcClassId {
	obj := &OxmBsnL3SrcClassId{
		Oxm: NewOxm(199172),
	}
	return obj
}
func (self *OxmBsnL3SrcClassId) GetOXMName() string {
	return "bsn_l3_src_class_id"
}

func (self *OxmBsnL3SrcClassId) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnL3SrcClassId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnL3SrcClassIdMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnL3SrcClassIdMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnL3SrcClassIdMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnL3SrcClassIdMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnL3SrcClassIdMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnL3SrcClassIdMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnL3SrcClassIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnL3SrcClassIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnL3SrcClassIdMasked, error) {
	_oxmbsnl3srcclassidmasked := &OxmBsnL3SrcClassIdMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnL3SrcClassIdMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnl3srcclassidmasked.Value = uint32(decoder.ReadUint32())
	_oxmbsnl3srcclassidmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnl3srcclassidmasked, nil
}

func NewOxmBsnL3SrcClassIdMasked() *OxmBsnL3SrcClassIdMasked {
	obj := &OxmBsnL3SrcClassIdMasked{
		Oxm: NewOxm(199432),
	}
	return obj
}
func (self *OxmBsnL3SrcClassIdMasked) GetOXMName() string {
	return "bsn_l3_src_class_id_masked"
}

func (self *OxmBsnL3SrcClassIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnL3SrcClassIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnL3SrcClassIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnLagId struct {
	*Oxm
	Value uint32
}

type IOxmBsnLagId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnLagId) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnLagId) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnLagId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnLagId(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnLagId, error) {
	_oxmbsnlagid := &OxmBsnLagId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnLagId packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnlagid.Value = uint32(decoder.ReadUint32())
	return _oxmbsnlagid, nil
}

func NewOxmBsnLagId() *OxmBsnLagId {
	obj := &OxmBsnLagId{
		Oxm: NewOxm(197124),
	}
	return obj
}
func (self *OxmBsnLagId) GetOXMName() string {
	return "bsn_lag_id"
}

func (self *OxmBsnLagId) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnLagId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnLagIdMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnLagIdMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnLagIdMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnLagIdMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnLagIdMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnLagIdMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnLagIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnLagIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnLagIdMasked, error) {
	_oxmbsnlagidmasked := &OxmBsnLagIdMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnLagIdMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnlagidmasked.Value = uint32(decoder.ReadUint32())
	_oxmbsnlagidmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnlagidmasked, nil
}

func NewOxmBsnLagIdMasked() *OxmBsnLagIdMasked {
	obj := &OxmBsnLagIdMasked{
		Oxm: NewOxm(197384),
	}
	return obj
}
func (self *OxmBsnLagIdMasked) GetOXMName() string {
	return "bsn_lag_id_masked"
}

func (self *OxmBsnLagIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnLagIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnLagIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnTcpFlags struct {
	*Oxm
	Value uint16
}

type IOxmBsnTcpFlags interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmBsnTcpFlags) GetValue() uint16 {
	return self.Value
}

func (self *OxmBsnTcpFlags) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmBsnTcpFlags) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmBsnTcpFlags(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnTcpFlags, error) {
	_oxmbsntcpflags := &OxmBsnTcpFlags{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmBsnTcpFlags packet too short: %d < 2", decoder.Length())
	}
	_oxmbsntcpflags.Value = uint16(decoder.ReadUint16())
	return _oxmbsntcpflags, nil
}

func NewOxmBsnTcpFlags() *OxmBsnTcpFlags {
	obj := &OxmBsnTcpFlags{
		Oxm: NewOxm(204802),
	}
	return obj
}
func (self *OxmBsnTcpFlags) GetOXMName() string {
	return "bsn_tcp_flags"
}

func (self *OxmBsnTcpFlags) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnTcpFlags) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnTcpFlagsMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmBsnTcpFlagsMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmBsnTcpFlagsMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmBsnTcpFlagsMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmBsnTcpFlagsMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmBsnTcpFlagsMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmBsnTcpFlagsMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmBsnTcpFlagsMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnTcpFlagsMasked, error) {
	_oxmbsntcpflagsmasked := &OxmBsnTcpFlagsMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnTcpFlagsMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmbsntcpflagsmasked.Value = uint16(decoder.ReadUint16())
	_oxmbsntcpflagsmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmbsntcpflagsmasked, nil
}

func NewOxmBsnTcpFlagsMasked() *OxmBsnTcpFlagsMasked {
	obj := &OxmBsnTcpFlagsMasked{
		Oxm: NewOxm(205060),
	}
	return obj
}
func (self *OxmBsnTcpFlagsMasked) GetOXMName() string {
	return "bsn_tcp_flags_masked"
}

func (self *OxmBsnTcpFlagsMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnTcpFlagsMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnTcpFlagsMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnUdf0 struct {
	*Oxm
	Value uint32
}

type IOxmBsnUdf0 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnUdf0) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf0) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf0) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnUdf0(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf0, error) {
	_oxmbsnudf0 := &OxmBsnUdf0{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnUdf0 packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnudf0.Value = uint32(decoder.ReadUint32())
	return _oxmbsnudf0, nil
}

func NewOxmBsnUdf0() *OxmBsnUdf0 {
	obj := &OxmBsnUdf0{
		Oxm: NewOxm(200708),
	}
	return obj
}
func (self *OxmBsnUdf0) GetOXMName() string {
	return "bsn_udf0"
}

func (self *OxmBsnUdf0) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf0) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnUdf0Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnUdf0Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnUdf0Masked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf0Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf0Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnUdf0Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnUdf0Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnUdf0Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf0Masked, error) {
	_oxmbsnudf0masked := &OxmBsnUdf0Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnUdf0Masked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnudf0masked.Value = uint32(decoder.ReadUint32())
	_oxmbsnudf0masked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnudf0masked, nil
}

func NewOxmBsnUdf0Masked() *OxmBsnUdf0Masked {
	obj := &OxmBsnUdf0Masked{
		Oxm: NewOxm(200968),
	}
	return obj
}
func (self *OxmBsnUdf0Masked) GetOXMName() string {
	return "bsn_udf0_masked"
}

func (self *OxmBsnUdf0Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf0Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnUdf0Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnUdf1 struct {
	*Oxm
	Value uint32
}

type IOxmBsnUdf1 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnUdf1) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf1) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf1) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnUdf1(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf1, error) {
	_oxmbsnudf1 := &OxmBsnUdf1{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnUdf1 packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnudf1.Value = uint32(decoder.ReadUint32())
	return _oxmbsnudf1, nil
}

func NewOxmBsnUdf1() *OxmBsnUdf1 {
	obj := &OxmBsnUdf1{
		Oxm: NewOxm(201220),
	}
	return obj
}
func (self *OxmBsnUdf1) GetOXMName() string {
	return "bsn_udf1"
}

func (self *OxmBsnUdf1) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf1) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnUdf1Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnUdf1Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnUdf1Masked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf1Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf1Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnUdf1Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnUdf1Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnUdf1Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf1Masked, error) {
	_oxmbsnudf1masked := &OxmBsnUdf1Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnUdf1Masked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnudf1masked.Value = uint32(decoder.ReadUint32())
	_oxmbsnudf1masked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnudf1masked, nil
}

func NewOxmBsnUdf1Masked() *OxmBsnUdf1Masked {
	obj := &OxmBsnUdf1Masked{
		Oxm: NewOxm(201480),
	}
	return obj
}
func (self *OxmBsnUdf1Masked) GetOXMName() string {
	return "bsn_udf1_masked"
}

func (self *OxmBsnUdf1Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf1Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnUdf1Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnUdf2 struct {
	*Oxm
	Value uint32
}

type IOxmBsnUdf2 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnUdf2) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf2) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf2) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnUdf2(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf2, error) {
	_oxmbsnudf2 := &OxmBsnUdf2{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnUdf2 packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnudf2.Value = uint32(decoder.ReadUint32())
	return _oxmbsnudf2, nil
}

func NewOxmBsnUdf2() *OxmBsnUdf2 {
	obj := &OxmBsnUdf2{
		Oxm: NewOxm(201732),
	}
	return obj
}
func (self *OxmBsnUdf2) GetOXMName() string {
	return "bsn_udf2"
}

func (self *OxmBsnUdf2) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf2) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnUdf2Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnUdf2Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnUdf2Masked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf2Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf2Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnUdf2Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnUdf2Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnUdf2Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf2Masked, error) {
	_oxmbsnudf2masked := &OxmBsnUdf2Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnUdf2Masked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnudf2masked.Value = uint32(decoder.ReadUint32())
	_oxmbsnudf2masked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnudf2masked, nil
}

func NewOxmBsnUdf2Masked() *OxmBsnUdf2Masked {
	obj := &OxmBsnUdf2Masked{
		Oxm: NewOxm(201992),
	}
	return obj
}
func (self *OxmBsnUdf2Masked) GetOXMName() string {
	return "bsn_udf2_masked"
}

func (self *OxmBsnUdf2Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf2Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnUdf2Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnUdf3 struct {
	*Oxm
	Value uint32
}

type IOxmBsnUdf3 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnUdf3) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf3) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf3) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnUdf3(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf3, error) {
	_oxmbsnudf3 := &OxmBsnUdf3{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnUdf3 packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnudf3.Value = uint32(decoder.ReadUint32())
	return _oxmbsnudf3, nil
}

func NewOxmBsnUdf3() *OxmBsnUdf3 {
	obj := &OxmBsnUdf3{
		Oxm: NewOxm(202244),
	}
	return obj
}
func (self *OxmBsnUdf3) GetOXMName() string {
	return "bsn_udf3"
}

func (self *OxmBsnUdf3) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf3) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnUdf3Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnUdf3Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnUdf3Masked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf3Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf3Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnUdf3Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnUdf3Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnUdf3Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf3Masked, error) {
	_oxmbsnudf3masked := &OxmBsnUdf3Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnUdf3Masked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnudf3masked.Value = uint32(decoder.ReadUint32())
	_oxmbsnudf3masked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnudf3masked, nil
}

func NewOxmBsnUdf3Masked() *OxmBsnUdf3Masked {
	obj := &OxmBsnUdf3Masked{
		Oxm: NewOxm(202504),
	}
	return obj
}
func (self *OxmBsnUdf3Masked) GetOXMName() string {
	return "bsn_udf3_masked"
}

func (self *OxmBsnUdf3Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf3Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnUdf3Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnUdf4 struct {
	*Oxm
	Value uint32
}

type IOxmBsnUdf4 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnUdf4) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf4) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf4) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnUdf4(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf4, error) {
	_oxmbsnudf4 := &OxmBsnUdf4{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnUdf4 packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnudf4.Value = uint32(decoder.ReadUint32())
	return _oxmbsnudf4, nil
}

func NewOxmBsnUdf4() *OxmBsnUdf4 {
	obj := &OxmBsnUdf4{
		Oxm: NewOxm(202756),
	}
	return obj
}
func (self *OxmBsnUdf4) GetOXMName() string {
	return "bsn_udf4"
}

func (self *OxmBsnUdf4) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf4) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnUdf4Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnUdf4Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnUdf4Masked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf4Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf4Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnUdf4Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnUdf4Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnUdf4Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf4Masked, error) {
	_oxmbsnudf4masked := &OxmBsnUdf4Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnUdf4Masked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnudf4masked.Value = uint32(decoder.ReadUint32())
	_oxmbsnudf4masked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnudf4masked, nil
}

func NewOxmBsnUdf4Masked() *OxmBsnUdf4Masked {
	obj := &OxmBsnUdf4Masked{
		Oxm: NewOxm(203016),
	}
	return obj
}
func (self *OxmBsnUdf4Masked) GetOXMName() string {
	return "bsn_udf4_masked"
}

func (self *OxmBsnUdf4Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf4Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnUdf4Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnUdf5 struct {
	*Oxm
	Value uint32
}

type IOxmBsnUdf5 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnUdf5) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf5) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf5) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnUdf5(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf5, error) {
	_oxmbsnudf5 := &OxmBsnUdf5{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnUdf5 packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnudf5.Value = uint32(decoder.ReadUint32())
	return _oxmbsnudf5, nil
}

func NewOxmBsnUdf5() *OxmBsnUdf5 {
	obj := &OxmBsnUdf5{
		Oxm: NewOxm(203268),
	}
	return obj
}
func (self *OxmBsnUdf5) GetOXMName() string {
	return "bsn_udf5"
}

func (self *OxmBsnUdf5) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf5) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnUdf5Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnUdf5Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnUdf5Masked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf5Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf5Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnUdf5Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnUdf5Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnUdf5Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf5Masked, error) {
	_oxmbsnudf5masked := &OxmBsnUdf5Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnUdf5Masked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnudf5masked.Value = uint32(decoder.ReadUint32())
	_oxmbsnudf5masked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnudf5masked, nil
}

func NewOxmBsnUdf5Masked() *OxmBsnUdf5Masked {
	obj := &OxmBsnUdf5Masked{
		Oxm: NewOxm(203528),
	}
	return obj
}
func (self *OxmBsnUdf5Masked) GetOXMName() string {
	return "bsn_udf5_masked"
}

func (self *OxmBsnUdf5Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf5Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnUdf5Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnUdf6 struct {
	*Oxm
	Value uint32
}

type IOxmBsnUdf6 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnUdf6) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf6) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf6) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnUdf6(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf6, error) {
	_oxmbsnudf6 := &OxmBsnUdf6{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnUdf6 packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnudf6.Value = uint32(decoder.ReadUint32())
	return _oxmbsnudf6, nil
}

func NewOxmBsnUdf6() *OxmBsnUdf6 {
	obj := &OxmBsnUdf6{
		Oxm: NewOxm(203780),
	}
	return obj
}
func (self *OxmBsnUdf6) GetOXMName() string {
	return "bsn_udf6"
}

func (self *OxmBsnUdf6) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf6) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnUdf6Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnUdf6Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnUdf6Masked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf6Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf6Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnUdf6Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnUdf6Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnUdf6Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf6Masked, error) {
	_oxmbsnudf6masked := &OxmBsnUdf6Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnUdf6Masked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnudf6masked.Value = uint32(decoder.ReadUint32())
	_oxmbsnudf6masked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnudf6masked, nil
}

func NewOxmBsnUdf6Masked() *OxmBsnUdf6Masked {
	obj := &OxmBsnUdf6Masked{
		Oxm: NewOxm(204040),
	}
	return obj
}
func (self *OxmBsnUdf6Masked) GetOXMName() string {
	return "bsn_udf6_masked"
}

func (self *OxmBsnUdf6Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf6Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnUdf6Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnUdf7 struct {
	*Oxm
	Value uint32
}

type IOxmBsnUdf7 interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnUdf7) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf7) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf7) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnUdf7(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf7, error) {
	_oxmbsnudf7 := &OxmBsnUdf7{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnUdf7 packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnudf7.Value = uint32(decoder.ReadUint32())
	return _oxmbsnudf7, nil
}

func NewOxmBsnUdf7() *OxmBsnUdf7 {
	obj := &OxmBsnUdf7{
		Oxm: NewOxm(204292),
	}
	return obj
}
func (self *OxmBsnUdf7) GetOXMName() string {
	return "bsn_udf7"
}

func (self *OxmBsnUdf7) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf7) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnUdf7Masked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnUdf7Masked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnUdf7Masked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnUdf7Masked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnUdf7Masked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnUdf7Masked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnUdf7Masked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnUdf7Masked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnUdf7Masked, error) {
	_oxmbsnudf7masked := &OxmBsnUdf7Masked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnUdf7Masked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnudf7masked.Value = uint32(decoder.ReadUint32())
	_oxmbsnudf7masked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnudf7masked, nil
}

func NewOxmBsnUdf7Masked() *OxmBsnUdf7Masked {
	obj := &OxmBsnUdf7Masked{
		Oxm: NewOxm(204552),
	}
	return obj
}
func (self *OxmBsnUdf7Masked) GetOXMName() string {
	return "bsn_udf7_masked"
}

func (self *OxmBsnUdf7Masked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnUdf7Masked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnUdf7Masked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnVfi struct {
	*Oxm
	Value uint16
}

type IOxmBsnVfi interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmBsnVfi) GetValue() uint16 {
	return self.Value
}

func (self *OxmBsnVfi) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmBsnVfi) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmBsnVfi(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnVfi, error) {
	_oxmbsnvfi := &OxmBsnVfi{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmBsnVfi packet too short: %d < 2", decoder.Length())
	}
	_oxmbsnvfi.Value = uint16(decoder.ReadUint16())
	return _oxmbsnvfi, nil
}

func NewOxmBsnVfi() *OxmBsnVfi {
	obj := &OxmBsnVfi{
		Oxm: NewOxm(209410),
	}
	return obj
}
func (self *OxmBsnVfi) GetOXMName() string {
	return "bsn_vfi"
}

func (self *OxmBsnVfi) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnVfi) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnVfiMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmBsnVfiMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmBsnVfiMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmBsnVfiMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmBsnVfiMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmBsnVfiMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmBsnVfiMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmBsnVfiMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnVfiMasked, error) {
	_oxmbsnvfimasked := &OxmBsnVfiMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnVfiMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnvfimasked.Value = uint16(decoder.ReadUint16())
	_oxmbsnvfimasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmbsnvfimasked, nil
}

func NewOxmBsnVfiMasked() *OxmBsnVfiMasked {
	obj := &OxmBsnVfiMasked{
		Oxm: NewOxm(209668),
	}
	return obj
}
func (self *OxmBsnVfiMasked) GetOXMName() string {
	return "bsn_vfi_masked"
}

func (self *OxmBsnVfiMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnVfiMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnVfiMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnVlanXlatePortGroupId struct {
	*Oxm
	Value uint32
}

type IOxmBsnVlanXlatePortGroupId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnVlanXlatePortGroupId) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnVlanXlatePortGroupId) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnVlanXlatePortGroupId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnVlanXlatePortGroupId(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnVlanXlatePortGroupId, error) {
	_oxmbsnvlanxlateportgroupid := &OxmBsnVlanXlatePortGroupId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnVlanXlatePortGroupId packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnvlanxlateportgroupid.Value = uint32(decoder.ReadUint32())
	return _oxmbsnvlanxlateportgroupid, nil
}

func NewOxmBsnVlanXlatePortGroupId() *OxmBsnVlanXlatePortGroupId {
	obj := &OxmBsnVlanXlatePortGroupId{
		Oxm: NewOxm(205316),
	}
	return obj
}
func (self *OxmBsnVlanXlatePortGroupId) GetOXMName() string {
	return "bsn_vlan_xlate_port_group_id"
}

func (self *OxmBsnVlanXlatePortGroupId) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnVlanXlatePortGroupId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnVlanXlatePortGroupIdMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnVlanXlatePortGroupIdMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnVlanXlatePortGroupIdMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnVlanXlatePortGroupIdMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnVlanXlatePortGroupIdMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnVlanXlatePortGroupIdMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnVlanXlatePortGroupIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnVlanXlatePortGroupIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnVlanXlatePortGroupIdMasked, error) {
	_oxmbsnvlanxlateportgroupidmasked := &OxmBsnVlanXlatePortGroupIdMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnVlanXlatePortGroupIdMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnvlanxlateportgroupidmasked.Value = uint32(decoder.ReadUint32())
	_oxmbsnvlanxlateportgroupidmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnvlanxlateportgroupidmasked, nil
}

func NewOxmBsnVlanXlatePortGroupIdMasked() *OxmBsnVlanXlatePortGroupIdMasked {
	obj := &OxmBsnVlanXlatePortGroupIdMasked{
		Oxm: NewOxm(205576),
	}
	return obj
}
func (self *OxmBsnVlanXlatePortGroupIdMasked) GetOXMName() string {
	return "bsn_vlan_xlate_port_group_id_masked"
}

func (self *OxmBsnVlanXlatePortGroupIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnVlanXlatePortGroupIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnVlanXlatePortGroupIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnVrf struct {
	*Oxm
	Value uint32
}

type IOxmBsnVrf interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnVrf) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnVrf) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnVrf) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnVrf(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnVrf, error) {
	_oxmbsnvrf := &OxmBsnVrf{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnVrf packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnvrf.Value = uint32(decoder.ReadUint32())
	return _oxmbsnvrf, nil
}

func NewOxmBsnVrf() *OxmBsnVrf {
	obj := &OxmBsnVrf{
		Oxm: NewOxm(197636),
	}
	return obj
}
func (self *OxmBsnVrf) GetOXMName() string {
	return "bsn_vrf"
}

func (self *OxmBsnVrf) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnVrf) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnVrfMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnVrfMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnVrfMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnVrfMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnVrfMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnVrfMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnVrfMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnVrfMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnVrfMasked, error) {
	_oxmbsnvrfmasked := &OxmBsnVrfMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnVrfMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnvrfmasked.Value = uint32(decoder.ReadUint32())
	_oxmbsnvrfmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnvrfmasked, nil
}

func NewOxmBsnVrfMasked() *OxmBsnVrfMasked {
	obj := &OxmBsnVrfMasked{
		Oxm: NewOxm(197896),
	}
	return obj
}
func (self *OxmBsnVrfMasked) GetOXMName() string {
	return "bsn_vrf_masked"
}

func (self *OxmBsnVrfMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnVrfMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnVrfMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmBsnVxlanNetworkId struct {
	*Oxm
	Value uint32
}

type IOxmBsnVxlanNetworkId interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmBsnVxlanNetworkId) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnVxlanNetworkId) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnVxlanNetworkId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmBsnVxlanNetworkId(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnVxlanNetworkId, error) {
	_oxmbsnvxlannetworkid := &OxmBsnVxlanNetworkId{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmBsnVxlanNetworkId packet too short: %d < 4", decoder.Length())
	}
	_oxmbsnvxlannetworkid.Value = uint32(decoder.ReadUint32())
	return _oxmbsnvxlannetworkid, nil
}

func NewOxmBsnVxlanNetworkId() *OxmBsnVxlanNetworkId {
	obj := &OxmBsnVxlanNetworkId{
		Oxm: NewOxm(207364),
	}
	return obj
}
func (self *OxmBsnVxlanNetworkId) GetOXMName() string {
	return "bsn_vxlan_network_id"
}

func (self *OxmBsnVxlanNetworkId) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnVxlanNetworkId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmBsnVxlanNetworkIdMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmBsnVxlanNetworkIdMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmBsnVxlanNetworkIdMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmBsnVxlanNetworkIdMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmBsnVxlanNetworkIdMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmBsnVxlanNetworkIdMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmBsnVxlanNetworkIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmBsnVxlanNetworkIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmBsnVxlanNetworkIdMasked, error) {
	_oxmbsnvxlannetworkidmasked := &OxmBsnVxlanNetworkIdMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmBsnVxlanNetworkIdMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmbsnvxlannetworkidmasked.Value = uint32(decoder.ReadUint32())
	_oxmbsnvxlannetworkidmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmbsnvxlannetworkidmasked, nil
}

func NewOxmBsnVxlanNetworkIdMasked() *OxmBsnVxlanNetworkIdMasked {
	obj := &OxmBsnVxlanNetworkIdMasked{
		Oxm: NewOxm(207624),
	}
	return obj
}
func (self *OxmBsnVxlanNetworkIdMasked) GetOXMName() string {
	return "bsn_vxlan_network_id_masked"
}

func (self *OxmBsnVxlanNetworkIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmBsnVxlanNetworkIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmBsnVxlanNetworkIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingIpv6Dst struct {
	*Oxm
	Value net.IP
}

type IOxmConnTrackingIpv6Dst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *OxmConnTrackingIpv6Dst) GetValue() net.IP {
	return self.Value
}

func (self *OxmConnTrackingIpv6Dst) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmConnTrackingIpv6Dst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeOxmConnTrackingIpv6Dst(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingIpv6Dst, error) {
	_oxmconntrackingipv6dst := &OxmConnTrackingIpv6Dst{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("OxmConnTrackingIpv6Dst packet too short: %d < 16", decoder.Length())
	}
	_oxmconntrackingipv6dst.Value = net.IP(decoder.Read(16))
	return _oxmconntrackingipv6dst, nil
}

func NewOxmConnTrackingIpv6Dst() *OxmConnTrackingIpv6Dst {
	obj := &OxmConnTrackingIpv6Dst{
		Oxm: NewOxm(128528),
	}
	return obj
}
func (self *OxmConnTrackingIpv6Dst) GetOXMName() string {
	return "conn_tracking_ipv6_dst"
}

func (self *OxmConnTrackingIpv6Dst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingIpv6Dst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingIpv6DstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type IOxmConnTrackingIpv6DstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *OxmConnTrackingIpv6DstMasked) GetValue() net.IP {
	return self.Value
}

func (self *OxmConnTrackingIpv6DstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmConnTrackingIpv6DstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *OxmConnTrackingIpv6DstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *OxmConnTrackingIpv6DstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeOxmConnTrackingIpv6DstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingIpv6DstMasked, error) {
	_oxmconntrackingipv6dstmasked := &OxmConnTrackingIpv6DstMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("OxmConnTrackingIpv6DstMasked packet too short: %d < 32", decoder.Length())
	}
	_oxmconntrackingipv6dstmasked.Value = net.IP(decoder.Read(16))
	_oxmconntrackingipv6dstmasked.ValueMask = net.IP(decoder.Read(16))
	return _oxmconntrackingipv6dstmasked, nil
}

func NewOxmConnTrackingIpv6DstMasked() *OxmConnTrackingIpv6DstMasked {
	obj := &OxmConnTrackingIpv6DstMasked{
		Oxm: NewOxm(128800),
	}
	return obj
}
func (self *OxmConnTrackingIpv6DstMasked) GetOXMName() string {
	return "conn_tracking_ipv6_dst_masked"
}

func (self *OxmConnTrackingIpv6DstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingIpv6DstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingIpv6DstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingIpv6Src struct {
	*Oxm
	Value net.IP
}

type IOxmConnTrackingIpv6Src interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *OxmConnTrackingIpv6Src) GetValue() net.IP {
	return self.Value
}

func (self *OxmConnTrackingIpv6Src) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmConnTrackingIpv6Src) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeOxmConnTrackingIpv6Src(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingIpv6Src, error) {
	_oxmconntrackingipv6src := &OxmConnTrackingIpv6Src{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("OxmConnTrackingIpv6Src packet too short: %d < 16", decoder.Length())
	}
	_oxmconntrackingipv6src.Value = net.IP(decoder.Read(16))
	return _oxmconntrackingipv6src, nil
}

func NewOxmConnTrackingIpv6Src() *OxmConnTrackingIpv6Src {
	obj := &OxmConnTrackingIpv6Src{
		Oxm: NewOxm(128016),
	}
	return obj
}
func (self *OxmConnTrackingIpv6Src) GetOXMName() string {
	return "conn_tracking_ipv6_src"
}

func (self *OxmConnTrackingIpv6Src) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingIpv6Src) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingIpv6SrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type IOxmConnTrackingIpv6SrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *OxmConnTrackingIpv6SrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *OxmConnTrackingIpv6SrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmConnTrackingIpv6SrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *OxmConnTrackingIpv6SrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *OxmConnTrackingIpv6SrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeOxmConnTrackingIpv6SrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingIpv6SrcMasked, error) {
	_oxmconntrackingipv6srcmasked := &OxmConnTrackingIpv6SrcMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("OxmConnTrackingIpv6SrcMasked packet too short: %d < 32", decoder.Length())
	}
	_oxmconntrackingipv6srcmasked.Value = net.IP(decoder.Read(16))
	_oxmconntrackingipv6srcmasked.ValueMask = net.IP(decoder.Read(16))
	return _oxmconntrackingipv6srcmasked, nil
}

func NewOxmConnTrackingIpv6SrcMasked() *OxmConnTrackingIpv6SrcMasked {
	obj := &OxmConnTrackingIpv6SrcMasked{
		Oxm: NewOxm(128288),
	}
	return obj
}
func (self *OxmConnTrackingIpv6SrcMasked) GetOXMName() string {
	return "conn_tracking_ipv6_src_masked"
}

func (self *OxmConnTrackingIpv6SrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingIpv6SrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingIpv6SrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingLabel struct {
	*Oxm
	Value uint128
}

type IOxmConnTrackingLabel interface {
	goloxi.IOxm
	GetValue() uint128
}

func (self *OxmConnTrackingLabel) GetValue() uint128 {
	return self.Value
}

func (self *OxmConnTrackingLabel) SetValue(v uint128) {
	self.Value = v
}

func (self *OxmConnTrackingLabel) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))

	return nil
}

func DecodeOxmConnTrackingLabel(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingLabel, error) {
	_oxmconntrackinglabel := &OxmConnTrackingLabel{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("OxmConnTrackingLabel packet too short: %d < 16", decoder.Length())
	}
	_oxmconntrackinglabel.Value = uint128(decoder.ReadUint128())
	return _oxmconntrackinglabel, nil
}

func NewOxmConnTrackingLabel() *OxmConnTrackingLabel {
	obj := &OxmConnTrackingLabel{
		Oxm: NewOxm(120848),
	}
	return obj
}
func (self *OxmConnTrackingLabel) GetOXMName() string {
	return "conn_tracking_label"
}

func (self *OxmConnTrackingLabel) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingLabel) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingLabelMasked struct {
	*Oxm
	Value     uint128
	ValueMask uint128
}

type IOxmConnTrackingLabelMasked interface {
	goloxi.IOxm
	GetValue() uint128
	GetValueMask() uint128
}

func (self *OxmConnTrackingLabelMasked) GetValue() uint128 {
	return self.Value
}

func (self *OxmConnTrackingLabelMasked) SetValue(v uint128) {
	self.Value = v
}

func (self *OxmConnTrackingLabelMasked) GetValueMask() uint128 {
	return self.ValueMask
}

func (self *OxmConnTrackingLabelMasked) SetValueMask(v uint128) {
	self.ValueMask = v
}

func (self *OxmConnTrackingLabelMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint128(uint128(self.Value))
	encoder.PutUint128(uint128(self.ValueMask))

	return nil
}

func DecodeOxmConnTrackingLabelMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingLabelMasked, error) {
	_oxmconntrackinglabelmasked := &OxmConnTrackingLabelMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("OxmConnTrackingLabelMasked packet too short: %d < 32", decoder.Length())
	}
	_oxmconntrackinglabelmasked.Value = uint128(decoder.ReadUint128())
	_oxmconntrackinglabelmasked.ValueMask = uint128(decoder.ReadUint128())
	return _oxmconntrackinglabelmasked, nil
}

func NewOxmConnTrackingLabelMasked() *OxmConnTrackingLabelMasked {
	obj := &OxmConnTrackingLabelMasked{
		Oxm: NewOxm(121120),
	}
	return obj
}
func (self *OxmConnTrackingLabelMasked) GetOXMName() string {
	return "conn_tracking_label_masked"
}

func (self *OxmConnTrackingLabelMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingLabelMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingLabelMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingMark struct {
	*Oxm
	Value uint32
}

type IOxmConnTrackingMark interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmConnTrackingMark) GetValue() uint32 {
	return self.Value
}

func (self *OxmConnTrackingMark) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmConnTrackingMark) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmConnTrackingMark(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingMark, error) {
	_oxmconntrackingmark := &OxmConnTrackingMark{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmConnTrackingMark packet too short: %d < 4", decoder.Length())
	}
	_oxmconntrackingmark.Value = uint32(decoder.ReadUint32())
	return _oxmconntrackingmark, nil
}

func NewOxmConnTrackingMark() *OxmConnTrackingMark {
	obj := &OxmConnTrackingMark{
		Oxm: NewOxm(120324),
	}
	return obj
}
func (self *OxmConnTrackingMark) GetOXMName() string {
	return "conn_tracking_mark"
}

func (self *OxmConnTrackingMark) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingMark) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingMarkMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmConnTrackingMarkMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmConnTrackingMarkMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmConnTrackingMarkMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmConnTrackingMarkMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmConnTrackingMarkMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmConnTrackingMarkMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmConnTrackingMarkMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingMarkMasked, error) {
	_oxmconntrackingmarkmasked := &OxmConnTrackingMarkMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmConnTrackingMarkMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmconntrackingmarkmasked.Value = uint32(decoder.ReadUint32())
	_oxmconntrackingmarkmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmconntrackingmarkmasked, nil
}

func NewOxmConnTrackingMarkMasked() *OxmConnTrackingMarkMasked {
	obj := &OxmConnTrackingMarkMasked{
		Oxm: NewOxm(120584),
	}
	return obj
}
func (self *OxmConnTrackingMarkMasked) GetOXMName() string {
	return "conn_tracking_mark_masked"
}

func (self *OxmConnTrackingMarkMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingMarkMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingMarkMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingNwDst struct {
	*Oxm
	Value uint32
}

type IOxmConnTrackingNwDst interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmConnTrackingNwDst) GetValue() uint32 {
	return self.Value
}

func (self *OxmConnTrackingNwDst) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmConnTrackingNwDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmConnTrackingNwDst(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingNwDst, error) {
	_oxmconntrackingnwdst := &OxmConnTrackingNwDst{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmConnTrackingNwDst packet too short: %d < 4", decoder.Length())
	}
	_oxmconntrackingnwdst.Value = uint32(decoder.ReadUint32())
	return _oxmconntrackingnwdst, nil
}

func NewOxmConnTrackingNwDst() *OxmConnTrackingNwDst {
	obj := &OxmConnTrackingNwDst{
		Oxm: NewOxm(127492),
	}
	return obj
}
func (self *OxmConnTrackingNwDst) GetOXMName() string {
	return "conn_tracking_nw_dst"
}

func (self *OxmConnTrackingNwDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingNwDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingNwDstMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmConnTrackingNwDstMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmConnTrackingNwDstMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmConnTrackingNwDstMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmConnTrackingNwDstMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmConnTrackingNwDstMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmConnTrackingNwDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmConnTrackingNwDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingNwDstMasked, error) {
	_oxmconntrackingnwdstmasked := &OxmConnTrackingNwDstMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmConnTrackingNwDstMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmconntrackingnwdstmasked.Value = uint32(decoder.ReadUint32())
	_oxmconntrackingnwdstmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmconntrackingnwdstmasked, nil
}

func NewOxmConnTrackingNwDstMasked() *OxmConnTrackingNwDstMasked {
	obj := &OxmConnTrackingNwDstMasked{
		Oxm: NewOxm(127752),
	}
	return obj
}
func (self *OxmConnTrackingNwDstMasked) GetOXMName() string {
	return "conn_tracking_nw_dst_masked"
}

func (self *OxmConnTrackingNwDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingNwDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingNwDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingNwProto struct {
	*Oxm
	Value uint8
}

type IOxmConnTrackingNwProto interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmConnTrackingNwProto) GetValue() uint8 {
	return self.Value
}

func (self *OxmConnTrackingNwProto) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmConnTrackingNwProto) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmConnTrackingNwProto(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingNwProto, error) {
	_oxmconntrackingnwproto := &OxmConnTrackingNwProto{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmConnTrackingNwProto packet too short: %d < 1", decoder.Length())
	}
	_oxmconntrackingnwproto.Value = uint8(decoder.ReadByte())
	return _oxmconntrackingnwproto, nil
}

func NewOxmConnTrackingNwProto() *OxmConnTrackingNwProto {
	obj := &OxmConnTrackingNwProto{
		Oxm: NewOxm(126465),
	}
	return obj
}
func (self *OxmConnTrackingNwProto) GetOXMName() string {
	return "conn_tracking_nw_proto"
}

func (self *OxmConnTrackingNwProto) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingNwProto) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingNwProtoMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmConnTrackingNwProtoMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmConnTrackingNwProtoMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmConnTrackingNwProtoMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmConnTrackingNwProtoMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmConnTrackingNwProtoMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmConnTrackingNwProtoMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmConnTrackingNwProtoMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingNwProtoMasked, error) {
	_oxmconntrackingnwprotomasked := &OxmConnTrackingNwProtoMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmConnTrackingNwProtoMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmconntrackingnwprotomasked.Value = uint8(decoder.ReadByte())
	_oxmconntrackingnwprotomasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmconntrackingnwprotomasked, nil
}

func NewOxmConnTrackingNwProtoMasked() *OxmConnTrackingNwProtoMasked {
	obj := &OxmConnTrackingNwProtoMasked{
		Oxm: NewOxm(126722),
	}
	return obj
}
func (self *OxmConnTrackingNwProtoMasked) GetOXMName() string {
	return "conn_tracking_nw_proto_masked"
}

func (self *OxmConnTrackingNwProtoMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingNwProtoMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingNwProtoMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingNwSrc struct {
	*Oxm
	Value uint32
}

type IOxmConnTrackingNwSrc interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmConnTrackingNwSrc) GetValue() uint32 {
	return self.Value
}

func (self *OxmConnTrackingNwSrc) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmConnTrackingNwSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmConnTrackingNwSrc(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingNwSrc, error) {
	_oxmconntrackingnwsrc := &OxmConnTrackingNwSrc{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmConnTrackingNwSrc packet too short: %d < 4", decoder.Length())
	}
	_oxmconntrackingnwsrc.Value = uint32(decoder.ReadUint32())
	return _oxmconntrackingnwsrc, nil
}

func NewOxmConnTrackingNwSrc() *OxmConnTrackingNwSrc {
	obj := &OxmConnTrackingNwSrc{
		Oxm: NewOxm(126980),
	}
	return obj
}
func (self *OxmConnTrackingNwSrc) GetOXMName() string {
	return "conn_tracking_nw_src"
}

func (self *OxmConnTrackingNwSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingNwSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingNwSrcMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmConnTrackingNwSrcMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmConnTrackingNwSrcMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmConnTrackingNwSrcMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmConnTrackingNwSrcMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmConnTrackingNwSrcMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmConnTrackingNwSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmConnTrackingNwSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingNwSrcMasked, error) {
	_oxmconntrackingnwsrcmasked := &OxmConnTrackingNwSrcMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmConnTrackingNwSrcMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmconntrackingnwsrcmasked.Value = uint32(decoder.ReadUint32())
	_oxmconntrackingnwsrcmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmconntrackingnwsrcmasked, nil
}

func NewOxmConnTrackingNwSrcMasked() *OxmConnTrackingNwSrcMasked {
	obj := &OxmConnTrackingNwSrcMasked{
		Oxm: NewOxm(127240),
	}
	return obj
}
func (self *OxmConnTrackingNwSrcMasked) GetOXMName() string {
	return "conn_tracking_nw_src_masked"
}

func (self *OxmConnTrackingNwSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingNwSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingNwSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingState struct {
	*Oxm
	Value CsStates
}

type IOxmConnTrackingState interface {
	goloxi.IOxm
	GetValue() CsStates
}

func (self *OxmConnTrackingState) GetValue() CsStates {
	return self.Value
}

func (self *OxmConnTrackingState) SetValue(v CsStates) {
	self.Value = v
}

func (self *OxmConnTrackingState) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmConnTrackingState(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingState, error) {
	_oxmconntrackingstate := &OxmConnTrackingState{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmConnTrackingState packet too short: %d < 4", decoder.Length())
	}
	_oxmconntrackingstate.Value = CsStates(decoder.ReadUint32())
	return _oxmconntrackingstate, nil
}

func NewOxmConnTrackingState() *OxmConnTrackingState {
	obj := &OxmConnTrackingState{
		Oxm: NewOxm(119300),
	}
	return obj
}
func (self *OxmConnTrackingState) GetOXMName() string {
	return "conn_tracking_state"
}

func (self *OxmConnTrackingState) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingState) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingStateMasked struct {
	*Oxm
	Value     CsStates
	ValueMask CsStates
}

type IOxmConnTrackingStateMasked interface {
	goloxi.IOxm
	GetValue() CsStates
	GetValueMask() CsStates
}

func (self *OxmConnTrackingStateMasked) GetValue() CsStates {
	return self.Value
}

func (self *OxmConnTrackingStateMasked) SetValue(v CsStates) {
	self.Value = v
}

func (self *OxmConnTrackingStateMasked) GetValueMask() CsStates {
	return self.ValueMask
}

func (self *OxmConnTrackingStateMasked) SetValueMask(v CsStates) {
	self.ValueMask = v
}

func (self *OxmConnTrackingStateMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmConnTrackingStateMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingStateMasked, error) {
	_oxmconntrackingstatemasked := &OxmConnTrackingStateMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmConnTrackingStateMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmconntrackingstatemasked.Value = CsStates(decoder.ReadUint32())
	_oxmconntrackingstatemasked.ValueMask = CsStates(decoder.ReadUint32())
	return _oxmconntrackingstatemasked, nil
}

func NewOxmConnTrackingStateMasked() *OxmConnTrackingStateMasked {
	obj := &OxmConnTrackingStateMasked{
		Oxm: NewOxm(119560),
	}
	return obj
}
func (self *OxmConnTrackingStateMasked) GetOXMName() string {
	return "conn_tracking_state_masked"
}

func (self *OxmConnTrackingStateMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingStateMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingStateMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingTpDst struct {
	*Oxm
	Value uint16
}

type IOxmConnTrackingTpDst interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmConnTrackingTpDst) GetValue() uint16 {
	return self.Value
}

func (self *OxmConnTrackingTpDst) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmConnTrackingTpDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmConnTrackingTpDst(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingTpDst, error) {
	_oxmconntrackingtpdst := &OxmConnTrackingTpDst{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmConnTrackingTpDst packet too short: %d < 2", decoder.Length())
	}
	_oxmconntrackingtpdst.Value = uint16(decoder.ReadUint16())
	return _oxmconntrackingtpdst, nil
}

func NewOxmConnTrackingTpDst() *OxmConnTrackingTpDst {
	obj := &OxmConnTrackingTpDst{
		Oxm: NewOxm(129538),
	}
	return obj
}
func (self *OxmConnTrackingTpDst) GetOXMName() string {
	return "conn_tracking_tp_dst"
}

func (self *OxmConnTrackingTpDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingTpDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingTpDstMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmConnTrackingTpDstMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmConnTrackingTpDstMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmConnTrackingTpDstMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmConnTrackingTpDstMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmConnTrackingTpDstMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmConnTrackingTpDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmConnTrackingTpDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingTpDstMasked, error) {
	_oxmconntrackingtpdstmasked := &OxmConnTrackingTpDstMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmConnTrackingTpDstMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmconntrackingtpdstmasked.Value = uint16(decoder.ReadUint16())
	_oxmconntrackingtpdstmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmconntrackingtpdstmasked, nil
}

func NewOxmConnTrackingTpDstMasked() *OxmConnTrackingTpDstMasked {
	obj := &OxmConnTrackingTpDstMasked{
		Oxm: NewOxm(129796),
	}
	return obj
}
func (self *OxmConnTrackingTpDstMasked) GetOXMName() string {
	return "conn_tracking_tp_dst_masked"
}

func (self *OxmConnTrackingTpDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingTpDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingTpDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingTpSrc struct {
	*Oxm
	Value uint16
}

type IOxmConnTrackingTpSrc interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmConnTrackingTpSrc) GetValue() uint16 {
	return self.Value
}

func (self *OxmConnTrackingTpSrc) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmConnTrackingTpSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmConnTrackingTpSrc(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingTpSrc, error) {
	_oxmconntrackingtpsrc := &OxmConnTrackingTpSrc{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmConnTrackingTpSrc packet too short: %d < 2", decoder.Length())
	}
	_oxmconntrackingtpsrc.Value = uint16(decoder.ReadUint16())
	return _oxmconntrackingtpsrc, nil
}

func NewOxmConnTrackingTpSrc() *OxmConnTrackingTpSrc {
	obj := &OxmConnTrackingTpSrc{
		Oxm: NewOxm(129026),
	}
	return obj
}
func (self *OxmConnTrackingTpSrc) GetOXMName() string {
	return "conn_tracking_tp_src"
}

func (self *OxmConnTrackingTpSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingTpSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingTpSrcMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmConnTrackingTpSrcMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmConnTrackingTpSrcMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmConnTrackingTpSrcMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmConnTrackingTpSrcMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmConnTrackingTpSrcMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmConnTrackingTpSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmConnTrackingTpSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingTpSrcMasked, error) {
	_oxmconntrackingtpsrcmasked := &OxmConnTrackingTpSrcMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmConnTrackingTpSrcMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmconntrackingtpsrcmasked.Value = uint16(decoder.ReadUint16())
	_oxmconntrackingtpsrcmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmconntrackingtpsrcmasked, nil
}

func NewOxmConnTrackingTpSrcMasked() *OxmConnTrackingTpSrcMasked {
	obj := &OxmConnTrackingTpSrcMasked{
		Oxm: NewOxm(129284),
	}
	return obj
}
func (self *OxmConnTrackingTpSrcMasked) GetOXMName() string {
	return "conn_tracking_tp_src_masked"
}

func (self *OxmConnTrackingTpSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingTpSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingTpSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmConnTrackingZone struct {
	*Oxm
	Value uint16
}

type IOxmConnTrackingZone interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmConnTrackingZone) GetValue() uint16 {
	return self.Value
}

func (self *OxmConnTrackingZone) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmConnTrackingZone) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmConnTrackingZone(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingZone, error) {
	_oxmconntrackingzone := &OxmConnTrackingZone{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmConnTrackingZone packet too short: %d < 2", decoder.Length())
	}
	_oxmconntrackingzone.Value = uint16(decoder.ReadUint16())
	return _oxmconntrackingzone, nil
}

func NewOxmConnTrackingZone() *OxmConnTrackingZone {
	obj := &OxmConnTrackingZone{
		Oxm: NewOxm(119810),
	}
	return obj
}
func (self *OxmConnTrackingZone) GetOXMName() string {
	return "conn_tracking_zone"
}

func (self *OxmConnTrackingZone) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingZone) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmConnTrackingZoneMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmConnTrackingZoneMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmConnTrackingZoneMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmConnTrackingZoneMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmConnTrackingZoneMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmConnTrackingZoneMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmConnTrackingZoneMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmConnTrackingZoneMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmConnTrackingZoneMasked, error) {
	_oxmconntrackingzonemasked := &OxmConnTrackingZoneMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmConnTrackingZoneMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmconntrackingzonemasked.Value = uint16(decoder.ReadUint16())
	_oxmconntrackingzonemasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmconntrackingzonemasked, nil
}

func NewOxmConnTrackingZoneMasked() *OxmConnTrackingZoneMasked {
	obj := &OxmConnTrackingZoneMasked{
		Oxm: NewOxm(120068),
	}
	return obj
}
func (self *OxmConnTrackingZoneMasked) GetOXMName() string {
	return "conn_tracking_zone_masked"
}

func (self *OxmConnTrackingZoneMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmConnTrackingZoneMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmConnTrackingZoneMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmEthDst struct {
	*Oxm
	Value net.HardwareAddr
}

type IOxmEthDst interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *OxmEthDst) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmEthDst) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmEthDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeOxmEthDst(parent *Oxm, decoder *goloxi.Decoder) (*OxmEthDst, error) {
	_oxmethdst := &OxmEthDst{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("OxmEthDst packet too short: %d < 6", decoder.Length())
	}
	_oxmethdst.Value = net.HardwareAddr(decoder.Read(6))
	return _oxmethdst, nil
}

func NewOxmEthDst() *OxmEthDst {
	obj := &OxmEthDst{
		Oxm: NewOxm(2147485190),
	}
	return obj
}
func (self *OxmEthDst) GetOXMName() string {
	return "eth_dst"
}

func (self *OxmEthDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmEthDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmEthDstMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type IOxmEthDstMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *OxmEthDstMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmEthDstMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmEthDstMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *OxmEthDstMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *OxmEthDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeOxmEthDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmEthDstMasked, error) {
	_oxmethdstmasked := &OxmEthDstMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("OxmEthDstMasked packet too short: %d < 12", decoder.Length())
	}
	_oxmethdstmasked.Value = net.HardwareAddr(decoder.Read(6))
	_oxmethdstmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _oxmethdstmasked, nil
}

func NewOxmEthDstMasked() *OxmEthDstMasked {
	obj := &OxmEthDstMasked{
		Oxm: NewOxm(2147485452),
	}
	return obj
}
func (self *OxmEthDstMasked) GetOXMName() string {
	return "eth_dst_masked"
}

func (self *OxmEthDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmEthDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmEthDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmEthSrc struct {
	*Oxm
	Value net.HardwareAddr
}

type IOxmEthSrc interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *OxmEthSrc) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmEthSrc) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmEthSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeOxmEthSrc(parent *Oxm, decoder *goloxi.Decoder) (*OxmEthSrc, error) {
	_oxmethsrc := &OxmEthSrc{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("OxmEthSrc packet too short: %d < 6", decoder.Length())
	}
	_oxmethsrc.Value = net.HardwareAddr(decoder.Read(6))
	return _oxmethsrc, nil
}

func NewOxmEthSrc() *OxmEthSrc {
	obj := &OxmEthSrc{
		Oxm: NewOxm(2147485702),
	}
	return obj
}
func (self *OxmEthSrc) GetOXMName() string {
	return "eth_src"
}

func (self *OxmEthSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmEthSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmEthSrcMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type IOxmEthSrcMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *OxmEthSrcMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmEthSrcMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmEthSrcMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *OxmEthSrcMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *OxmEthSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeOxmEthSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmEthSrcMasked, error) {
	_oxmethsrcmasked := &OxmEthSrcMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("OxmEthSrcMasked packet too short: %d < 12", decoder.Length())
	}
	_oxmethsrcmasked.Value = net.HardwareAddr(decoder.Read(6))
	_oxmethsrcmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _oxmethsrcmasked, nil
}

func NewOxmEthSrcMasked() *OxmEthSrcMasked {
	obj := &OxmEthSrcMasked{
		Oxm: NewOxm(2147485964),
	}
	return obj
}
func (self *OxmEthSrcMasked) GetOXMName() string {
	return "eth_src_masked"
}

func (self *OxmEthSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmEthSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmEthSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmEthType struct {
	*Oxm
	Value EthernetType
}

type IOxmEthType interface {
	goloxi.IOxm
	GetValue() EthernetType
}

func (self *OxmEthType) GetValue() EthernetType {
	return self.Value
}

func (self *OxmEthType) SetValue(v EthernetType) {
	self.Value = v
}

func (self *OxmEthType) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmEthType(parent *Oxm, decoder *goloxi.Decoder) (*OxmEthType, error) {
	_oxmethtype := &OxmEthType{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmEthType packet too short: %d < 2", decoder.Length())
	}
	_oxmethtype.Value = EthernetType(decoder.ReadUint16())
	return _oxmethtype, nil
}

func NewOxmEthType() *OxmEthType {
	obj := &OxmEthType{
		Oxm: NewOxm(2147486210),
	}
	return obj
}
func (self *OxmEthType) GetOXMName() string {
	return "eth_type"
}

func (self *OxmEthType) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmEthType) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmEthTypeMasked struct {
	*Oxm
	Value     EthernetType
	ValueMask uint16
}

type IOxmEthTypeMasked interface {
	goloxi.IOxm
	GetValue() EthernetType
	GetValueMask() uint16
}

func (self *OxmEthTypeMasked) GetValue() EthernetType {
	return self.Value
}

func (self *OxmEthTypeMasked) SetValue(v EthernetType) {
	self.Value = v
}

func (self *OxmEthTypeMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmEthTypeMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmEthTypeMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmEthTypeMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmEthTypeMasked, error) {
	_oxmethtypemasked := &OxmEthTypeMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmEthTypeMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmethtypemasked.Value = EthernetType(decoder.ReadUint16())
	_oxmethtypemasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmethtypemasked, nil
}

func NewOxmEthTypeMasked() *OxmEthTypeMasked {
	obj := &OxmEthTypeMasked{
		Oxm: NewOxm(2147486468),
	}
	return obj
}
func (self *OxmEthTypeMasked) GetOXMName() string {
	return "eth_type_masked"
}

func (self *OxmEthTypeMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmEthTypeMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmEthTypeMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIcmpv4Code struct {
	*Oxm
	Value uint8
}

type IOxmIcmpv4Code interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmIcmpv4Code) GetValue() uint8 {
	return self.Value
}

func (self *OxmIcmpv4Code) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmIcmpv4Code) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmIcmpv4Code(parent *Oxm, decoder *goloxi.Decoder) (*OxmIcmpv4Code, error) {
	_oxmicmpv4code := &OxmIcmpv4Code{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmIcmpv4Code packet too short: %d < 1", decoder.Length())
	}
	_oxmicmpv4code.Value = uint8(decoder.ReadByte())
	return _oxmicmpv4code, nil
}

func NewOxmIcmpv4Code() *OxmIcmpv4Code {
	obj := &OxmIcmpv4Code{
		Oxm: NewOxm(2147493889),
	}
	return obj
}
func (self *OxmIcmpv4Code) GetOXMName() string {
	return "icmpv4_code"
}

func (self *OxmIcmpv4Code) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIcmpv4Code) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIcmpv4CodeMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmIcmpv4CodeMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmIcmpv4CodeMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmIcmpv4CodeMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmIcmpv4CodeMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmIcmpv4CodeMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmIcmpv4CodeMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmIcmpv4CodeMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIcmpv4CodeMasked, error) {
	_oxmicmpv4codemasked := &OxmIcmpv4CodeMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmIcmpv4CodeMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmicmpv4codemasked.Value = uint8(decoder.ReadByte())
	_oxmicmpv4codemasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmicmpv4codemasked, nil
}

func NewOxmIcmpv4CodeMasked() *OxmIcmpv4CodeMasked {
	obj := &OxmIcmpv4CodeMasked{
		Oxm: NewOxm(2147494146),
	}
	return obj
}
func (self *OxmIcmpv4CodeMasked) GetOXMName() string {
	return "icmpv4_code_masked"
}

func (self *OxmIcmpv4CodeMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIcmpv4CodeMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIcmpv4CodeMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIcmpv4Type struct {
	*Oxm
	Value IcmpType
}

type IOxmIcmpv4Type interface {
	goloxi.IOxm
	GetValue() IcmpType
}

func (self *OxmIcmpv4Type) GetValue() IcmpType {
	return self.Value
}

func (self *OxmIcmpv4Type) SetValue(v IcmpType) {
	self.Value = v
}

func (self *OxmIcmpv4Type) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmIcmpv4Type(parent *Oxm, decoder *goloxi.Decoder) (*OxmIcmpv4Type, error) {
	_oxmicmpv4type := &OxmIcmpv4Type{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmIcmpv4Type packet too short: %d < 1", decoder.Length())
	}
	_oxmicmpv4type.Value = IcmpType(decoder.ReadByte())
	return _oxmicmpv4type, nil
}

func NewOxmIcmpv4Type() *OxmIcmpv4Type {
	obj := &OxmIcmpv4Type{
		Oxm: NewOxm(2147493377),
	}
	return obj
}
func (self *OxmIcmpv4Type) GetOXMName() string {
	return "icmpv4_type"
}

func (self *OxmIcmpv4Type) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIcmpv4Type) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIcmpv4TypeMasked struct {
	*Oxm
	Value     IcmpType
	ValueMask uint8
}

type IOxmIcmpv4TypeMasked interface {
	goloxi.IOxm
	GetValue() IcmpType
	GetValueMask() uint8
}

func (self *OxmIcmpv4TypeMasked) GetValue() IcmpType {
	return self.Value
}

func (self *OxmIcmpv4TypeMasked) SetValue(v IcmpType) {
	self.Value = v
}

func (self *OxmIcmpv4TypeMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmIcmpv4TypeMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmIcmpv4TypeMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmIcmpv4TypeMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIcmpv4TypeMasked, error) {
	_oxmicmpv4typemasked := &OxmIcmpv4TypeMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmIcmpv4TypeMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmicmpv4typemasked.Value = IcmpType(decoder.ReadByte())
	_oxmicmpv4typemasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmicmpv4typemasked, nil
}

func NewOxmIcmpv4TypeMasked() *OxmIcmpv4TypeMasked {
	obj := &OxmIcmpv4TypeMasked{
		Oxm: NewOxm(2147493634),
	}
	return obj
}
func (self *OxmIcmpv4TypeMasked) GetOXMName() string {
	return "icmpv4_type_masked"
}

func (self *OxmIcmpv4TypeMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIcmpv4TypeMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIcmpv4TypeMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIcmpv6Code struct {
	*Oxm
	Value uint8
}

type IOxmIcmpv6Code interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmIcmpv6Code) GetValue() uint8 {
	return self.Value
}

func (self *OxmIcmpv6Code) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmIcmpv6Code) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmIcmpv6Code(parent *Oxm, decoder *goloxi.Decoder) (*OxmIcmpv6Code, error) {
	_oxmicmpv6code := &OxmIcmpv6Code{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmIcmpv6Code packet too short: %d < 1", decoder.Length())
	}
	_oxmicmpv6code.Value = uint8(decoder.ReadByte())
	return _oxmicmpv6code, nil
}

func NewOxmIcmpv6Code() *OxmIcmpv6Code {
	obj := &OxmIcmpv6Code{
		Oxm: NewOxm(2147499009),
	}
	return obj
}
func (self *OxmIcmpv6Code) GetOXMName() string {
	return "icmpv6_code"
}

func (self *OxmIcmpv6Code) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIcmpv6Code) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIcmpv6CodeMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmIcmpv6CodeMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmIcmpv6CodeMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmIcmpv6CodeMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmIcmpv6CodeMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmIcmpv6CodeMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmIcmpv6CodeMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmIcmpv6CodeMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIcmpv6CodeMasked, error) {
	_oxmicmpv6codemasked := &OxmIcmpv6CodeMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmIcmpv6CodeMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmicmpv6codemasked.Value = uint8(decoder.ReadByte())
	_oxmicmpv6codemasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmicmpv6codemasked, nil
}

func NewOxmIcmpv6CodeMasked() *OxmIcmpv6CodeMasked {
	obj := &OxmIcmpv6CodeMasked{
		Oxm: NewOxm(2147499266),
	}
	return obj
}
func (self *OxmIcmpv6CodeMasked) GetOXMName() string {
	return "icmpv6_code_masked"
}

func (self *OxmIcmpv6CodeMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIcmpv6CodeMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIcmpv6CodeMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIcmpv6Type struct {
	*Oxm
	Value Icmpv6Type
}

type IOxmIcmpv6Type interface {
	goloxi.IOxm
	GetValue() Icmpv6Type
}

func (self *OxmIcmpv6Type) GetValue() Icmpv6Type {
	return self.Value
}

func (self *OxmIcmpv6Type) SetValue(v Icmpv6Type) {
	self.Value = v
}

func (self *OxmIcmpv6Type) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmIcmpv6Type(parent *Oxm, decoder *goloxi.Decoder) (*OxmIcmpv6Type, error) {
	_oxmicmpv6type := &OxmIcmpv6Type{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmIcmpv6Type packet too short: %d < 1", decoder.Length())
	}
	_oxmicmpv6type.Value = Icmpv6Type(decoder.ReadByte())
	return _oxmicmpv6type, nil
}

func NewOxmIcmpv6Type() *OxmIcmpv6Type {
	obj := &OxmIcmpv6Type{
		Oxm: NewOxm(2147498497),
	}
	return obj
}
func (self *OxmIcmpv6Type) GetOXMName() string {
	return "icmpv6_type"
}

func (self *OxmIcmpv6Type) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIcmpv6Type) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIcmpv6TypeMasked struct {
	*Oxm
	Value     Icmpv6Type
	ValueMask uint8
}

type IOxmIcmpv6TypeMasked interface {
	goloxi.IOxm
	GetValue() Icmpv6Type
	GetValueMask() uint8
}

func (self *OxmIcmpv6TypeMasked) GetValue() Icmpv6Type {
	return self.Value
}

func (self *OxmIcmpv6TypeMasked) SetValue(v Icmpv6Type) {
	self.Value = v
}

func (self *OxmIcmpv6TypeMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmIcmpv6TypeMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmIcmpv6TypeMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmIcmpv6TypeMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIcmpv6TypeMasked, error) {
	_oxmicmpv6typemasked := &OxmIcmpv6TypeMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmIcmpv6TypeMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmicmpv6typemasked.Value = Icmpv6Type(decoder.ReadByte())
	_oxmicmpv6typemasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmicmpv6typemasked, nil
}

func NewOxmIcmpv6TypeMasked() *OxmIcmpv6TypeMasked {
	obj := &OxmIcmpv6TypeMasked{
		Oxm: NewOxm(2147498754),
	}
	return obj
}
func (self *OxmIcmpv6TypeMasked) GetOXMName() string {
	return "icmpv6_type_masked"
}

func (self *OxmIcmpv6TypeMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIcmpv6TypeMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIcmpv6TypeMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmInPhyPort struct {
	*Oxm
	Value Port
}

type IOxmInPhyPort interface {
	goloxi.IOxm
	GetValue() Port
}

func (self *OxmInPhyPort) GetValue() Port {
	return self.Value
}

func (self *OxmInPhyPort) SetValue(v Port) {
	self.Value = v
}

func (self *OxmInPhyPort) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	self.Value.Serialize(encoder)

	return nil
}

func DecodeOxmInPhyPort(parent *Oxm, decoder *goloxi.Decoder) (*OxmInPhyPort, error) {
	_oxminphyport := &OxmInPhyPort{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmInPhyPort packet too short: %d < 4", decoder.Length())
	}
	_oxminphyport.Value.Decode(decoder)
	return _oxminphyport, nil
}

func NewOxmInPhyPort() *OxmInPhyPort {
	obj := &OxmInPhyPort{
		Oxm: NewOxm(2147484164),
	}
	return obj
}
func (self *OxmInPhyPort) GetOXMName() string {
	return "in_phy_port"
}

func (self *OxmInPhyPort) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmInPhyPort) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmInPhyPortMasked struct {
	*Oxm
	Value     Port
	ValueMask Port
}

type IOxmInPhyPortMasked interface {
	goloxi.IOxm
	GetValue() Port
	GetValueMask() Port
}

func (self *OxmInPhyPortMasked) GetValue() Port {
	return self.Value
}

func (self *OxmInPhyPortMasked) SetValue(v Port) {
	self.Value = v
}

func (self *OxmInPhyPortMasked) GetValueMask() Port {
	return self.ValueMask
}

func (self *OxmInPhyPortMasked) SetValueMask(v Port) {
	self.ValueMask = v
}

func (self *OxmInPhyPortMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	self.Value.Serialize(encoder)
	self.ValueMask.Serialize(encoder)

	return nil
}

func DecodeOxmInPhyPortMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmInPhyPortMasked, error) {
	_oxminphyportmasked := &OxmInPhyPortMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmInPhyPortMasked packet too short: %d < 8", decoder.Length())
	}
	_oxminphyportmasked.Value.Decode(decoder)
	_oxminphyportmasked.ValueMask.Decode(decoder)
	return _oxminphyportmasked, nil
}

func NewOxmInPhyPortMasked() *OxmInPhyPortMasked {
	obj := &OxmInPhyPortMasked{
		Oxm: NewOxm(2147484424),
	}
	return obj
}
func (self *OxmInPhyPortMasked) GetOXMName() string {
	return "in_phy_port_masked"
}

func (self *OxmInPhyPortMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmInPhyPortMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmInPhyPortMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmInPort struct {
	*Oxm
	Value Port
}

type IOxmInPort interface {
	goloxi.IOxm
	GetValue() Port
}

func (self *OxmInPort) GetValue() Port {
	return self.Value
}

func (self *OxmInPort) SetValue(v Port) {
	self.Value = v
}

func (self *OxmInPort) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	self.Value.Serialize(encoder)

	return nil
}

func DecodeOxmInPort(parent *Oxm, decoder *goloxi.Decoder) (*OxmInPort, error) {
	_oxminport := &OxmInPort{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmInPort packet too short: %d < 4", decoder.Length())
	}
	_oxminport.Value.Decode(decoder)
	return _oxminport, nil
}

func NewOxmInPort() *OxmInPort {
	obj := &OxmInPort{
		Oxm: NewOxm(2147483652),
	}
	return obj
}
func (self *OxmInPort) GetOXMName() string {
	return "in_port"
}

func (self *OxmInPort) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmInPort) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmInPortMasked struct {
	*Oxm
	Value     Port
	ValueMask Port
}

type IOxmInPortMasked interface {
	goloxi.IOxm
	GetValue() Port
	GetValueMask() Port
}

func (self *OxmInPortMasked) GetValue() Port {
	return self.Value
}

func (self *OxmInPortMasked) SetValue(v Port) {
	self.Value = v
}

func (self *OxmInPortMasked) GetValueMask() Port {
	return self.ValueMask
}

func (self *OxmInPortMasked) SetValueMask(v Port) {
	self.ValueMask = v
}

func (self *OxmInPortMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	self.Value.Serialize(encoder)
	self.ValueMask.Serialize(encoder)

	return nil
}

func DecodeOxmInPortMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmInPortMasked, error) {
	_oxminportmasked := &OxmInPortMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmInPortMasked packet too short: %d < 8", decoder.Length())
	}
	_oxminportmasked.Value.Decode(decoder)
	_oxminportmasked.ValueMask.Decode(decoder)
	return _oxminportmasked, nil
}

func NewOxmInPortMasked() *OxmInPortMasked {
	obj := &OxmInPortMasked{
		Oxm: NewOxm(2147483912),
	}
	return obj
}
func (self *OxmInPortMasked) GetOXMName() string {
	return "in_port_masked"
}

func (self *OxmInPortMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmInPortMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmInPortMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpDscp struct {
	*Oxm
	Value uint8
}

type IOxmIpDscp interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmIpDscp) GetValue() uint8 {
	return self.Value
}

func (self *OxmIpDscp) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmIpDscp) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmIpDscp(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpDscp, error) {
	_oxmipdscp := &OxmIpDscp{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmIpDscp packet too short: %d < 1", decoder.Length())
	}
	_oxmipdscp.Value = uint8(decoder.ReadByte())
	return _oxmipdscp, nil
}

func NewOxmIpDscp() *OxmIpDscp {
	obj := &OxmIpDscp{
		Oxm: NewOxm(2147487745),
	}
	return obj
}
func (self *OxmIpDscp) GetOXMName() string {
	return "ip_dscp"
}

func (self *OxmIpDscp) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpDscp) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpDscpMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmIpDscpMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmIpDscpMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmIpDscpMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmIpDscpMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmIpDscpMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmIpDscpMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmIpDscpMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpDscpMasked, error) {
	_oxmipdscpmasked := &OxmIpDscpMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmIpDscpMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmipdscpmasked.Value = uint8(decoder.ReadByte())
	_oxmipdscpmasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmipdscpmasked, nil
}

func NewOxmIpDscpMasked() *OxmIpDscpMasked {
	obj := &OxmIpDscpMasked{
		Oxm: NewOxm(2147488002),
	}
	return obj
}
func (self *OxmIpDscpMasked) GetOXMName() string {
	return "ip_dscp_masked"
}

func (self *OxmIpDscpMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpDscpMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpDscpMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpEcn struct {
	*Oxm
	Value uint8
}

type IOxmIpEcn interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmIpEcn) GetValue() uint8 {
	return self.Value
}

func (self *OxmIpEcn) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmIpEcn) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmIpEcn(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpEcn, error) {
	_oxmipecn := &OxmIpEcn{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmIpEcn packet too short: %d < 1", decoder.Length())
	}
	_oxmipecn.Value = uint8(decoder.ReadByte())
	return _oxmipecn, nil
}

func NewOxmIpEcn() *OxmIpEcn {
	obj := &OxmIpEcn{
		Oxm: NewOxm(2147488257),
	}
	return obj
}
func (self *OxmIpEcn) GetOXMName() string {
	return "ip_ecn"
}

func (self *OxmIpEcn) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpEcn) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpEcnMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmIpEcnMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmIpEcnMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmIpEcnMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmIpEcnMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmIpEcnMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmIpEcnMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmIpEcnMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpEcnMasked, error) {
	_oxmipecnmasked := &OxmIpEcnMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmIpEcnMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmipecnmasked.Value = uint8(decoder.ReadByte())
	_oxmipecnmasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmipecnmasked, nil
}

func NewOxmIpEcnMasked() *OxmIpEcnMasked {
	obj := &OxmIpEcnMasked{
		Oxm: NewOxm(2147488514),
	}
	return obj
}
func (self *OxmIpEcnMasked) GetOXMName() string {
	return "ip_ecn_masked"
}

func (self *OxmIpEcnMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpEcnMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpEcnMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpProto struct {
	*Oxm
	Value IpPrototype
}

type IOxmIpProto interface {
	goloxi.IOxm
	GetValue() IpPrototype
}

func (self *OxmIpProto) GetValue() IpPrototype {
	return self.Value
}

func (self *OxmIpProto) SetValue(v IpPrototype) {
	self.Value = v
}

func (self *OxmIpProto) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmIpProto(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpProto, error) {
	_oxmipproto := &OxmIpProto{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmIpProto packet too short: %d < 1", decoder.Length())
	}
	_oxmipproto.Value = IpPrototype(decoder.ReadByte())
	return _oxmipproto, nil
}

func NewOxmIpProto() *OxmIpProto {
	obj := &OxmIpProto{
		Oxm: NewOxm(2147488769),
	}
	return obj
}
func (self *OxmIpProto) GetOXMName() string {
	return "ip_proto"
}

func (self *OxmIpProto) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpProto) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpProtoMasked struct {
	*Oxm
	Value     IpPrototype
	ValueMask uint8
}

type IOxmIpProtoMasked interface {
	goloxi.IOxm
	GetValue() IpPrototype
	GetValueMask() uint8
}

func (self *OxmIpProtoMasked) GetValue() IpPrototype {
	return self.Value
}

func (self *OxmIpProtoMasked) SetValue(v IpPrototype) {
	self.Value = v
}

func (self *OxmIpProtoMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmIpProtoMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmIpProtoMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmIpProtoMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpProtoMasked, error) {
	_oxmipprotomasked := &OxmIpProtoMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmIpProtoMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmipprotomasked.Value = IpPrototype(decoder.ReadByte())
	_oxmipprotomasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmipprotomasked, nil
}

func NewOxmIpProtoMasked() *OxmIpProtoMasked {
	obj := &OxmIpProtoMasked{
		Oxm: NewOxm(2147489026),
	}
	return obj
}
func (self *OxmIpProtoMasked) GetOXMName() string {
	return "ip_proto_masked"
}

func (self *OxmIpProtoMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpProtoMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpProtoMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpv4Dst struct {
	*Oxm
	Value net.IP
}

type IOxmIpv4Dst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *OxmIpv4Dst) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv4Dst) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv4Dst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeOxmIpv4Dst(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv4Dst, error) {
	_oxmipv4dst := &OxmIpv4Dst{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmIpv4Dst packet too short: %d < 4", decoder.Length())
	}
	_oxmipv4dst.Value = net.IP(decoder.Read(4))
	return _oxmipv4dst, nil
}

func NewOxmIpv4Dst() *OxmIpv4Dst {
	obj := &OxmIpv4Dst{
		Oxm: NewOxm(2147489796),
	}
	return obj
}
func (self *OxmIpv4Dst) GetOXMName() string {
	return "ipv4_dst"
}

func (self *OxmIpv4Dst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv4Dst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpv4DstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type IOxmIpv4DstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *OxmIpv4DstMasked) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv4DstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv4DstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *OxmIpv4DstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *OxmIpv4DstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeOxmIpv4DstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv4DstMasked, error) {
	_oxmipv4dstmasked := &OxmIpv4DstMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmIpv4DstMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmipv4dstmasked.Value = net.IP(decoder.Read(4))
	_oxmipv4dstmasked.ValueMask = net.IP(decoder.Read(4))
	return _oxmipv4dstmasked, nil
}

func NewOxmIpv4DstMasked() *OxmIpv4DstMasked {
	obj := &OxmIpv4DstMasked{
		Oxm: NewOxm(2147490056),
	}
	return obj
}
func (self *OxmIpv4DstMasked) GetOXMName() string {
	return "ipv4_dst_masked"
}

func (self *OxmIpv4DstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv4DstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpv4DstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpv4Src struct {
	*Oxm
	Value net.IP
}

type IOxmIpv4Src interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *OxmIpv4Src) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv4Src) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv4Src) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeOxmIpv4Src(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv4Src, error) {
	_oxmipv4src := &OxmIpv4Src{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmIpv4Src packet too short: %d < 4", decoder.Length())
	}
	_oxmipv4src.Value = net.IP(decoder.Read(4))
	return _oxmipv4src, nil
}

func NewOxmIpv4Src() *OxmIpv4Src {
	obj := &OxmIpv4Src{
		Oxm: NewOxm(2147489284),
	}
	return obj
}
func (self *OxmIpv4Src) GetOXMName() string {
	return "ipv4_src"
}

func (self *OxmIpv4Src) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv4Src) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpv4SrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type IOxmIpv4SrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *OxmIpv4SrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv4SrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv4SrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *OxmIpv4SrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *OxmIpv4SrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeOxmIpv4SrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv4SrcMasked, error) {
	_oxmipv4srcmasked := &OxmIpv4SrcMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmIpv4SrcMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmipv4srcmasked.Value = net.IP(decoder.Read(4))
	_oxmipv4srcmasked.ValueMask = net.IP(decoder.Read(4))
	return _oxmipv4srcmasked, nil
}

func NewOxmIpv4SrcMasked() *OxmIpv4SrcMasked {
	obj := &OxmIpv4SrcMasked{
		Oxm: NewOxm(2147489544),
	}
	return obj
}
func (self *OxmIpv4SrcMasked) GetOXMName() string {
	return "ipv4_src_masked"
}

func (self *OxmIpv4SrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv4SrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpv4SrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpv6Dst struct {
	*Oxm
	Value net.IP
}

type IOxmIpv6Dst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *OxmIpv6Dst) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv6Dst) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv6Dst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeOxmIpv6Dst(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6Dst, error) {
	_oxmipv6dst := &OxmIpv6Dst{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("OxmIpv6Dst packet too short: %d < 16", decoder.Length())
	}
	_oxmipv6dst.Value = net.IP(decoder.Read(16))
	return _oxmipv6dst, nil
}

func NewOxmIpv6Dst() *OxmIpv6Dst {
	obj := &OxmIpv6Dst{
		Oxm: NewOxm(2147497488),
	}
	return obj
}
func (self *OxmIpv6Dst) GetOXMName() string {
	return "ipv6_dst"
}

func (self *OxmIpv6Dst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6Dst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpv6DstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type IOxmIpv6DstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *OxmIpv6DstMasked) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv6DstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv6DstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *OxmIpv6DstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *OxmIpv6DstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeOxmIpv6DstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6DstMasked, error) {
	_oxmipv6dstmasked := &OxmIpv6DstMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("OxmIpv6DstMasked packet too short: %d < 32", decoder.Length())
	}
	_oxmipv6dstmasked.Value = net.IP(decoder.Read(16))
	_oxmipv6dstmasked.ValueMask = net.IP(decoder.Read(16))
	return _oxmipv6dstmasked, nil
}

func NewOxmIpv6DstMasked() *OxmIpv6DstMasked {
	obj := &OxmIpv6DstMasked{
		Oxm: NewOxm(2147497760),
	}
	return obj
}
func (self *OxmIpv6DstMasked) GetOXMName() string {
	return "ipv6_dst_masked"
}

func (self *OxmIpv6DstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6DstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpv6DstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpv6Exthdr struct {
	*Oxm
	Value uint16
}

type IOxmIpv6Exthdr interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmIpv6Exthdr) GetValue() uint16 {
	return self.Value
}

func (self *OxmIpv6Exthdr) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmIpv6Exthdr) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmIpv6Exthdr(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6Exthdr, error) {
	_oxmipv6exthdr := &OxmIpv6Exthdr{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmIpv6Exthdr packet too short: %d < 2", decoder.Length())
	}
	_oxmipv6exthdr.Value = uint16(decoder.ReadUint16())
	return _oxmipv6exthdr, nil
}

func NewOxmIpv6Exthdr() *OxmIpv6Exthdr {
	obj := &OxmIpv6Exthdr{
		Oxm: NewOxm(2147503618),
	}
	return obj
}
func (self *OxmIpv6Exthdr) GetOXMName() string {
	return "ipv6_exthdr"
}

func (self *OxmIpv6Exthdr) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6Exthdr) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpv6ExthdrMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmIpv6ExthdrMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmIpv6ExthdrMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmIpv6ExthdrMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmIpv6ExthdrMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmIpv6ExthdrMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmIpv6ExthdrMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmIpv6ExthdrMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6ExthdrMasked, error) {
	_oxmipv6exthdrmasked := &OxmIpv6ExthdrMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmIpv6ExthdrMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmipv6exthdrmasked.Value = uint16(decoder.ReadUint16())
	_oxmipv6exthdrmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmipv6exthdrmasked, nil
}

func NewOxmIpv6ExthdrMasked() *OxmIpv6ExthdrMasked {
	obj := &OxmIpv6ExthdrMasked{
		Oxm: NewOxm(2147503876),
	}
	return obj
}
func (self *OxmIpv6ExthdrMasked) GetOXMName() string {
	return "ipv6_exthdr_masked"
}

func (self *OxmIpv6ExthdrMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6ExthdrMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpv6ExthdrMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpv6Flabel struct {
	*Oxm
	Value uint32
}

type IOxmIpv6Flabel interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmIpv6Flabel) GetValue() uint32 {
	return self.Value
}

func (self *OxmIpv6Flabel) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmIpv6Flabel) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmIpv6Flabel(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6Flabel, error) {
	_oxmipv6flabel := &OxmIpv6Flabel{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmIpv6Flabel packet too short: %d < 4", decoder.Length())
	}
	_oxmipv6flabel.Value = uint32(decoder.ReadUint32())
	return _oxmipv6flabel, nil
}

func NewOxmIpv6Flabel() *OxmIpv6Flabel {
	obj := &OxmIpv6Flabel{
		Oxm: NewOxm(2147497988),
	}
	return obj
}
func (self *OxmIpv6Flabel) GetOXMName() string {
	return "ipv6_flabel"
}

func (self *OxmIpv6Flabel) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6Flabel) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpv6FlabelMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmIpv6FlabelMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmIpv6FlabelMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmIpv6FlabelMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmIpv6FlabelMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmIpv6FlabelMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmIpv6FlabelMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmIpv6FlabelMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6FlabelMasked, error) {
	_oxmipv6flabelmasked := &OxmIpv6FlabelMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmIpv6FlabelMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmipv6flabelmasked.Value = uint32(decoder.ReadUint32())
	_oxmipv6flabelmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmipv6flabelmasked, nil
}

func NewOxmIpv6FlabelMasked() *OxmIpv6FlabelMasked {
	obj := &OxmIpv6FlabelMasked{
		Oxm: NewOxm(2147498248),
	}
	return obj
}
func (self *OxmIpv6FlabelMasked) GetOXMName() string {
	return "ipv6_flabel_masked"
}

func (self *OxmIpv6FlabelMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6FlabelMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpv6FlabelMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpv6NdSll struct {
	*Oxm
	Value net.HardwareAddr
}

type IOxmIpv6NdSll interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *OxmIpv6NdSll) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmIpv6NdSll) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmIpv6NdSll) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeOxmIpv6NdSll(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6NdSll, error) {
	_oxmipv6ndsll := &OxmIpv6NdSll{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("OxmIpv6NdSll packet too short: %d < 6", decoder.Length())
	}
	_oxmipv6ndsll.Value = net.HardwareAddr(decoder.Read(6))
	return _oxmipv6ndsll, nil
}

func NewOxmIpv6NdSll() *OxmIpv6NdSll {
	obj := &OxmIpv6NdSll{
		Oxm: NewOxm(2147500038),
	}
	return obj
}
func (self *OxmIpv6NdSll) GetOXMName() string {
	return "ipv6_nd_sll"
}

func (self *OxmIpv6NdSll) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6NdSll) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpv6NdSllMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type IOxmIpv6NdSllMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *OxmIpv6NdSllMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmIpv6NdSllMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmIpv6NdSllMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *OxmIpv6NdSllMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *OxmIpv6NdSllMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeOxmIpv6NdSllMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6NdSllMasked, error) {
	_oxmipv6ndsllmasked := &OxmIpv6NdSllMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("OxmIpv6NdSllMasked packet too short: %d < 12", decoder.Length())
	}
	_oxmipv6ndsllmasked.Value = net.HardwareAddr(decoder.Read(6))
	_oxmipv6ndsllmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _oxmipv6ndsllmasked, nil
}

func NewOxmIpv6NdSllMasked() *OxmIpv6NdSllMasked {
	obj := &OxmIpv6NdSllMasked{
		Oxm: NewOxm(2147500300),
	}
	return obj
}
func (self *OxmIpv6NdSllMasked) GetOXMName() string {
	return "ipv6_nd_sll_masked"
}

func (self *OxmIpv6NdSllMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6NdSllMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpv6NdSllMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpv6NdTarget struct {
	*Oxm
	Value net.IP
}

type IOxmIpv6NdTarget interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *OxmIpv6NdTarget) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv6NdTarget) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv6NdTarget) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeOxmIpv6NdTarget(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6NdTarget, error) {
	_oxmipv6ndtarget := &OxmIpv6NdTarget{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("OxmIpv6NdTarget packet too short: %d < 16", decoder.Length())
	}
	_oxmipv6ndtarget.Value = net.IP(decoder.Read(16))
	return _oxmipv6ndtarget, nil
}

func NewOxmIpv6NdTarget() *OxmIpv6NdTarget {
	obj := &OxmIpv6NdTarget{
		Oxm: NewOxm(2147499536),
	}
	return obj
}
func (self *OxmIpv6NdTarget) GetOXMName() string {
	return "ipv6_nd_target"
}

func (self *OxmIpv6NdTarget) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6NdTarget) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpv6NdTargetMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type IOxmIpv6NdTargetMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *OxmIpv6NdTargetMasked) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv6NdTargetMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv6NdTargetMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *OxmIpv6NdTargetMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *OxmIpv6NdTargetMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeOxmIpv6NdTargetMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6NdTargetMasked, error) {
	_oxmipv6ndtargetmasked := &OxmIpv6NdTargetMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("OxmIpv6NdTargetMasked packet too short: %d < 32", decoder.Length())
	}
	_oxmipv6ndtargetmasked.Value = net.IP(decoder.Read(16))
	_oxmipv6ndtargetmasked.ValueMask = net.IP(decoder.Read(16))
	return _oxmipv6ndtargetmasked, nil
}

func NewOxmIpv6NdTargetMasked() *OxmIpv6NdTargetMasked {
	obj := &OxmIpv6NdTargetMasked{
		Oxm: NewOxm(2147499808),
	}
	return obj
}
func (self *OxmIpv6NdTargetMasked) GetOXMName() string {
	return "ipv6_nd_target_masked"
}

func (self *OxmIpv6NdTargetMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6NdTargetMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpv6NdTargetMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpv6NdTll struct {
	*Oxm
	Value net.HardwareAddr
}

type IOxmIpv6NdTll interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
}

func (self *OxmIpv6NdTll) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmIpv6NdTll) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmIpv6NdTll) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)

	return nil
}

func DecodeOxmIpv6NdTll(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6NdTll, error) {
	_oxmipv6ndtll := &OxmIpv6NdTll{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("OxmIpv6NdTll packet too short: %d < 6", decoder.Length())
	}
	_oxmipv6ndtll.Value = net.HardwareAddr(decoder.Read(6))
	return _oxmipv6ndtll, nil
}

func NewOxmIpv6NdTll() *OxmIpv6NdTll {
	obj := &OxmIpv6NdTll{
		Oxm: NewOxm(2147500550),
	}
	return obj
}
func (self *OxmIpv6NdTll) GetOXMName() string {
	return "ipv6_nd_tll"
}

func (self *OxmIpv6NdTll) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6NdTll) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpv6NdTllMasked struct {
	*Oxm
	Value     net.HardwareAddr
	ValueMask net.HardwareAddr
}

type IOxmIpv6NdTllMasked interface {
	goloxi.IOxm
	GetValue() net.HardwareAddr
	GetValueMask() net.HardwareAddr
}

func (self *OxmIpv6NdTllMasked) GetValue() net.HardwareAddr {
	return self.Value
}

func (self *OxmIpv6NdTllMasked) SetValue(v net.HardwareAddr) {
	self.Value = v
}

func (self *OxmIpv6NdTllMasked) GetValueMask() net.HardwareAddr {
	return self.ValueMask
}

func (self *OxmIpv6NdTllMasked) SetValueMask(v net.HardwareAddr) {
	self.ValueMask = v
}

func (self *OxmIpv6NdTllMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value)
	encoder.Write(self.ValueMask)

	return nil
}

func DecodeOxmIpv6NdTllMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6NdTllMasked, error) {
	_oxmipv6ndtllmasked := &OxmIpv6NdTllMasked{Oxm: parent}
	if decoder.Length() < 12 {
		return nil, fmt.Errorf("OxmIpv6NdTllMasked packet too short: %d < 12", decoder.Length())
	}
	_oxmipv6ndtllmasked.Value = net.HardwareAddr(decoder.Read(6))
	_oxmipv6ndtllmasked.ValueMask = net.HardwareAddr(decoder.Read(6))
	return _oxmipv6ndtllmasked, nil
}

func NewOxmIpv6NdTllMasked() *OxmIpv6NdTllMasked {
	obj := &OxmIpv6NdTllMasked{
		Oxm: NewOxm(2147500812),
	}
	return obj
}
func (self *OxmIpv6NdTllMasked) GetOXMName() string {
	return "ipv6_nd_tll_masked"
}

func (self *OxmIpv6NdTllMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6NdTllMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpv6NdTllMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmIpv6Src struct {
	*Oxm
	Value net.IP
}

type IOxmIpv6Src interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *OxmIpv6Src) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv6Src) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv6Src) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())

	return nil
}

func DecodeOxmIpv6Src(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6Src, error) {
	_oxmipv6src := &OxmIpv6Src{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("OxmIpv6Src packet too short: %d < 16", decoder.Length())
	}
	_oxmipv6src.Value = net.IP(decoder.Read(16))
	return _oxmipv6src, nil
}

func NewOxmIpv6Src() *OxmIpv6Src {
	obj := &OxmIpv6Src{
		Oxm: NewOxm(2147496976),
	}
	return obj
}
func (self *OxmIpv6Src) GetOXMName() string {
	return "ipv6_src"
}

func (self *OxmIpv6Src) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6Src) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmIpv6SrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type IOxmIpv6SrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *OxmIpv6SrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *OxmIpv6SrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmIpv6SrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *OxmIpv6SrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *OxmIpv6SrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To16())
	encoder.Write(self.ValueMask.To16())

	return nil
}

func DecodeOxmIpv6SrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmIpv6SrcMasked, error) {
	_oxmipv6srcmasked := &OxmIpv6SrcMasked{Oxm: parent}
	if decoder.Length() < 32 {
		return nil, fmt.Errorf("OxmIpv6SrcMasked packet too short: %d < 32", decoder.Length())
	}
	_oxmipv6srcmasked.Value = net.IP(decoder.Read(16))
	_oxmipv6srcmasked.ValueMask = net.IP(decoder.Read(16))
	return _oxmipv6srcmasked, nil
}

func NewOxmIpv6SrcMasked() *OxmIpv6SrcMasked {
	obj := &OxmIpv6SrcMasked{
		Oxm: NewOxm(2147497248),
	}
	return obj
}
func (self *OxmIpv6SrcMasked) GetOXMName() string {
	return "ipv6_src_masked"
}

func (self *OxmIpv6SrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmIpv6SrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmIpv6SrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmMetadata struct {
	*Oxm
	Value uint64
}

type IOxmMetadata interface {
	goloxi.IOxm
	GetValue() uint64
}

func (self *OxmMetadata) GetValue() uint64 {
	return self.Value
}

func (self *OxmMetadata) SetValue(v uint64) {
	self.Value = v
}

func (self *OxmMetadata) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint64(uint64(self.Value))

	return nil
}

func DecodeOxmMetadata(parent *Oxm, decoder *goloxi.Decoder) (*OxmMetadata, error) {
	_oxmmetadata := &OxmMetadata{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmMetadata packet too short: %d < 8", decoder.Length())
	}
	_oxmmetadata.Value = uint64(decoder.ReadUint64())
	return _oxmmetadata, nil
}

func NewOxmMetadata() *OxmMetadata {
	obj := &OxmMetadata{
		Oxm: NewOxm(2147484680),
	}
	return obj
}
func (self *OxmMetadata) GetOXMName() string {
	return "metadata"
}

func (self *OxmMetadata) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmMetadata) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmMetadataMasked struct {
	*Oxm
	Value     uint64
	ValueMask uint64
}

type IOxmMetadataMasked interface {
	goloxi.IOxm
	GetValue() uint64
	GetValueMask() uint64
}

func (self *OxmMetadataMasked) GetValue() uint64 {
	return self.Value
}

func (self *OxmMetadataMasked) SetValue(v uint64) {
	self.Value = v
}

func (self *OxmMetadataMasked) GetValueMask() uint64 {
	return self.ValueMask
}

func (self *OxmMetadataMasked) SetValueMask(v uint64) {
	self.ValueMask = v
}

func (self *OxmMetadataMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint64(uint64(self.Value))
	encoder.PutUint64(uint64(self.ValueMask))

	return nil
}

func DecodeOxmMetadataMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmMetadataMasked, error) {
	_oxmmetadatamasked := &OxmMetadataMasked{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("OxmMetadataMasked packet too short: %d < 16", decoder.Length())
	}
	_oxmmetadatamasked.Value = uint64(decoder.ReadUint64())
	_oxmmetadatamasked.ValueMask = uint64(decoder.ReadUint64())
	return _oxmmetadatamasked, nil
}

func NewOxmMetadataMasked() *OxmMetadataMasked {
	obj := &OxmMetadataMasked{
		Oxm: NewOxm(2147484944),
	}
	return obj
}
func (self *OxmMetadataMasked) GetOXMName() string {
	return "metadata_masked"
}

func (self *OxmMetadataMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmMetadataMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmMetadataMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmMplsBos struct {
	*Oxm
	Value uint8
}

type IOxmMplsBos interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmMplsBos) GetValue() uint8 {
	return self.Value
}

func (self *OxmMplsBos) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmMplsBos) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmMplsBos(parent *Oxm, decoder *goloxi.Decoder) (*OxmMplsBos, error) {
	_oxmmplsbos := &OxmMplsBos{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmMplsBos packet too short: %d < 1", decoder.Length())
	}
	_oxmmplsbos.Value = uint8(decoder.ReadByte())
	return _oxmmplsbos, nil
}

func NewOxmMplsBos() *OxmMplsBos {
	obj := &OxmMplsBos{
		Oxm: NewOxm(2147502081),
	}
	return obj
}
func (self *OxmMplsBos) GetOXMName() string {
	return "mpls_bos"
}

func (self *OxmMplsBos) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmMplsBos) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmMplsBosMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmMplsBosMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmMplsBosMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmMplsBosMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmMplsBosMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmMplsBosMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmMplsBosMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmMplsBosMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmMplsBosMasked, error) {
	_oxmmplsbosmasked := &OxmMplsBosMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmMplsBosMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmmplsbosmasked.Value = uint8(decoder.ReadByte())
	_oxmmplsbosmasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmmplsbosmasked, nil
}

func NewOxmMplsBosMasked() *OxmMplsBosMasked {
	obj := &OxmMplsBosMasked{
		Oxm: NewOxm(2147502338),
	}
	return obj
}
func (self *OxmMplsBosMasked) GetOXMName() string {
	return "mpls_bos_masked"
}

func (self *OxmMplsBosMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmMplsBosMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmMplsBosMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmMplsLabel struct {
	*Oxm
	Value uint32
}

type IOxmMplsLabel interface {
	goloxi.IOxm
	GetValue() uint32
}

func (self *OxmMplsLabel) GetValue() uint32 {
	return self.Value
}

func (self *OxmMplsLabel) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmMplsLabel) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))

	return nil
}

func DecodeOxmMplsLabel(parent *Oxm, decoder *goloxi.Decoder) (*OxmMplsLabel, error) {
	_oxmmplslabel := &OxmMplsLabel{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmMplsLabel packet too short: %d < 4", decoder.Length())
	}
	_oxmmplslabel.Value = uint32(decoder.ReadUint32())
	return _oxmmplslabel, nil
}

func NewOxmMplsLabel() *OxmMplsLabel {
	obj := &OxmMplsLabel{
		Oxm: NewOxm(2147501060),
	}
	return obj
}
func (self *OxmMplsLabel) GetOXMName() string {
	return "mpls_label"
}

func (self *OxmMplsLabel) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmMplsLabel) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmMplsLabelMasked struct {
	*Oxm
	Value     uint32
	ValueMask uint32
}

type IOxmMplsLabelMasked interface {
	goloxi.IOxm
	GetValue() uint32
	GetValueMask() uint32
}

func (self *OxmMplsLabelMasked) GetValue() uint32 {
	return self.Value
}

func (self *OxmMplsLabelMasked) SetValue(v uint32) {
	self.Value = v
}

func (self *OxmMplsLabelMasked) GetValueMask() uint32 {
	return self.ValueMask
}

func (self *OxmMplsLabelMasked) SetValueMask(v uint32) {
	self.ValueMask = v
}

func (self *OxmMplsLabelMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Value))
	encoder.PutUint32(uint32(self.ValueMask))

	return nil
}

func DecodeOxmMplsLabelMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmMplsLabelMasked, error) {
	_oxmmplslabelmasked := &OxmMplsLabelMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmMplsLabelMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmmplslabelmasked.Value = uint32(decoder.ReadUint32())
	_oxmmplslabelmasked.ValueMask = uint32(decoder.ReadUint32())
	return _oxmmplslabelmasked, nil
}

func NewOxmMplsLabelMasked() *OxmMplsLabelMasked {
	obj := &OxmMplsLabelMasked{
		Oxm: NewOxm(2147501320),
	}
	return obj
}
func (self *OxmMplsLabelMasked) GetOXMName() string {
	return "mpls_label_masked"
}

func (self *OxmMplsLabelMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmMplsLabelMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmMplsLabelMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmMplsTc struct {
	*Oxm
	Value uint8
}

type IOxmMplsTc interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmMplsTc) GetValue() uint8 {
	return self.Value
}

func (self *OxmMplsTc) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmMplsTc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmMplsTc(parent *Oxm, decoder *goloxi.Decoder) (*OxmMplsTc, error) {
	_oxmmplstc := &OxmMplsTc{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmMplsTc packet too short: %d < 1", decoder.Length())
	}
	_oxmmplstc.Value = uint8(decoder.ReadByte())
	return _oxmmplstc, nil
}

func NewOxmMplsTc() *OxmMplsTc {
	obj := &OxmMplsTc{
		Oxm: NewOxm(2147501569),
	}
	return obj
}
func (self *OxmMplsTc) GetOXMName() string {
	return "mpls_tc"
}

func (self *OxmMplsTc) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmMplsTc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmMplsTcMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmMplsTcMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmMplsTcMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmMplsTcMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmMplsTcMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmMplsTcMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmMplsTcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmMplsTcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmMplsTcMasked, error) {
	_oxmmplstcmasked := &OxmMplsTcMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmMplsTcMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmmplstcmasked.Value = uint8(decoder.ReadByte())
	_oxmmplstcmasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmmplstcmasked, nil
}

func NewOxmMplsTcMasked() *OxmMplsTcMasked {
	obj := &OxmMplsTcMasked{
		Oxm: NewOxm(2147501826),
	}
	return obj
}
func (self *OxmMplsTcMasked) GetOXMName() string {
	return "mpls_tc_masked"
}

func (self *OxmMplsTcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmMplsTcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmMplsTcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmOvsTcpFlags struct {
	*Oxm
	ExperimenterId uint32
	Value          uint16
}

type IOxmOvsTcpFlags interface {
	goloxi.IOxm
	GetExperimenterId() uint32
	GetValue() uint16
}

func (self *OxmOvsTcpFlags) GetExperimenterId() uint32 {
	return self.ExperimenterId
}

func (self *OxmOvsTcpFlags) SetExperimenterId(v uint32) {
	self.ExperimenterId = v
}

func (self *OxmOvsTcpFlags) GetValue() uint16 {
	return self.Value
}

func (self *OxmOvsTcpFlags) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmOvsTcpFlags) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.ExperimenterId))
	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmOvsTcpFlags(parent *Oxm, decoder *goloxi.Decoder) (*OxmOvsTcpFlags, error) {
	_oxmovstcpflags := &OxmOvsTcpFlags{Oxm: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("OxmOvsTcpFlags packet too short: %d < 6", decoder.Length())
	}
	_oxmovstcpflags.ExperimenterId = uint32(decoder.ReadUint32())
	_oxmovstcpflags.Value = uint16(decoder.ReadUint16())
	return _oxmovstcpflags, nil
}

func NewOxmOvsTcpFlags() *OxmOvsTcpFlags {
	obj := &OxmOvsTcpFlags{
		Oxm: NewOxm(4294923270),
	}
	return obj
}
func (self *OxmOvsTcpFlags) GetOXMName() string {
	return "ovs_tcp_flags"
}

func (self *OxmOvsTcpFlags) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmOvsTcpFlags) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmOvsTcpFlagsMasked struct {
	*Oxm
	ExperimenterId uint32
	Value          uint16
	ValueMask      uint16
}

type IOxmOvsTcpFlagsMasked interface {
	goloxi.IOxm
	GetExperimenterId() uint32
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmOvsTcpFlagsMasked) GetExperimenterId() uint32 {
	return self.ExperimenterId
}

func (self *OxmOvsTcpFlagsMasked) SetExperimenterId(v uint32) {
	self.ExperimenterId = v
}

func (self *OxmOvsTcpFlagsMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmOvsTcpFlagsMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmOvsTcpFlagsMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmOvsTcpFlagsMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmOvsTcpFlagsMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.ExperimenterId))
	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmOvsTcpFlagsMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmOvsTcpFlagsMasked, error) {
	_oxmovstcpflagsmasked := &OxmOvsTcpFlagsMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmOvsTcpFlagsMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmovstcpflagsmasked.ExperimenterId = uint32(decoder.ReadUint32())
	_oxmovstcpflagsmasked.Value = uint16(decoder.ReadUint16())
	_oxmovstcpflagsmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmovstcpflagsmasked, nil
}

func NewOxmOvsTcpFlagsMasked() *OxmOvsTcpFlagsMasked {
	obj := &OxmOvsTcpFlagsMasked{
		Oxm: NewOxm(4294923528),
	}
	return obj
}
func (self *OxmOvsTcpFlagsMasked) GetOXMName() string {
	return "ovs_tcp_flags_masked"
}

func (self *OxmOvsTcpFlagsMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmOvsTcpFlagsMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmOvsTcpFlagsMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmSctpDst struct {
	*Oxm
	Value uint16
}

type IOxmSctpDst interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmSctpDst) GetValue() uint16 {
	return self.Value
}

func (self *OxmSctpDst) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmSctpDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmSctpDst(parent *Oxm, decoder *goloxi.Decoder) (*OxmSctpDst, error) {
	_oxmsctpdst := &OxmSctpDst{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmSctpDst packet too short: %d < 2", decoder.Length())
	}
	_oxmsctpdst.Value = uint16(decoder.ReadUint16())
	return _oxmsctpdst, nil
}

func NewOxmSctpDst() *OxmSctpDst {
	obj := &OxmSctpDst{
		Oxm: NewOxm(2147492866),
	}
	return obj
}
func (self *OxmSctpDst) GetOXMName() string {
	return "sctp_dst"
}

func (self *OxmSctpDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmSctpDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmSctpDstMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmSctpDstMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmSctpDstMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmSctpDstMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmSctpDstMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmSctpDstMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmSctpDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmSctpDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmSctpDstMasked, error) {
	_oxmsctpdstmasked := &OxmSctpDstMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmSctpDstMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmsctpdstmasked.Value = uint16(decoder.ReadUint16())
	_oxmsctpdstmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmsctpdstmasked, nil
}

func NewOxmSctpDstMasked() *OxmSctpDstMasked {
	obj := &OxmSctpDstMasked{
		Oxm: NewOxm(2147493124),
	}
	return obj
}
func (self *OxmSctpDstMasked) GetOXMName() string {
	return "sctp_dst_masked"
}

func (self *OxmSctpDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmSctpDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmSctpDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmSctpSrc struct {
	*Oxm
	Value uint16
}

type IOxmSctpSrc interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmSctpSrc) GetValue() uint16 {
	return self.Value
}

func (self *OxmSctpSrc) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmSctpSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmSctpSrc(parent *Oxm, decoder *goloxi.Decoder) (*OxmSctpSrc, error) {
	_oxmsctpsrc := &OxmSctpSrc{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmSctpSrc packet too short: %d < 2", decoder.Length())
	}
	_oxmsctpsrc.Value = uint16(decoder.ReadUint16())
	return _oxmsctpsrc, nil
}

func NewOxmSctpSrc() *OxmSctpSrc {
	obj := &OxmSctpSrc{
		Oxm: NewOxm(2147492354),
	}
	return obj
}
func (self *OxmSctpSrc) GetOXMName() string {
	return "sctp_src"
}

func (self *OxmSctpSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmSctpSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmSctpSrcMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmSctpSrcMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmSctpSrcMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmSctpSrcMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmSctpSrcMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmSctpSrcMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmSctpSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmSctpSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmSctpSrcMasked, error) {
	_oxmsctpsrcmasked := &OxmSctpSrcMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmSctpSrcMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmsctpsrcmasked.Value = uint16(decoder.ReadUint16())
	_oxmsctpsrcmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmsctpsrcmasked, nil
}

func NewOxmSctpSrcMasked() *OxmSctpSrcMasked {
	obj := &OxmSctpSrcMasked{
		Oxm: NewOxm(2147492612),
	}
	return obj
}
func (self *OxmSctpSrcMasked) GetOXMName() string {
	return "sctp_src_masked"
}

func (self *OxmSctpSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmSctpSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmSctpSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmTcpDst struct {
	*Oxm
	Value uint16
}

type IOxmTcpDst interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmTcpDst) GetValue() uint16 {
	return self.Value
}

func (self *OxmTcpDst) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmTcpDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmTcpDst(parent *Oxm, decoder *goloxi.Decoder) (*OxmTcpDst, error) {
	_oxmtcpdst := &OxmTcpDst{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmTcpDst packet too short: %d < 2", decoder.Length())
	}
	_oxmtcpdst.Value = uint16(decoder.ReadUint16())
	return _oxmtcpdst, nil
}

func NewOxmTcpDst() *OxmTcpDst {
	obj := &OxmTcpDst{
		Oxm: NewOxm(2147490818),
	}
	return obj
}
func (self *OxmTcpDst) GetOXMName() string {
	return "tcp_dst"
}

func (self *OxmTcpDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTcpDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmTcpDstMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmTcpDstMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmTcpDstMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmTcpDstMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmTcpDstMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmTcpDstMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmTcpDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmTcpDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmTcpDstMasked, error) {
	_oxmtcpdstmasked := &OxmTcpDstMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmTcpDstMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmtcpdstmasked.Value = uint16(decoder.ReadUint16())
	_oxmtcpdstmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmtcpdstmasked, nil
}

func NewOxmTcpDstMasked() *OxmTcpDstMasked {
	obj := &OxmTcpDstMasked{
		Oxm: NewOxm(2147491076),
	}
	return obj
}
func (self *OxmTcpDstMasked) GetOXMName() string {
	return "tcp_dst_masked"
}

func (self *OxmTcpDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTcpDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmTcpDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmTcpSrc struct {
	*Oxm
	Value uint16
}

type IOxmTcpSrc interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmTcpSrc) GetValue() uint16 {
	return self.Value
}

func (self *OxmTcpSrc) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmTcpSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmTcpSrc(parent *Oxm, decoder *goloxi.Decoder) (*OxmTcpSrc, error) {
	_oxmtcpsrc := &OxmTcpSrc{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmTcpSrc packet too short: %d < 2", decoder.Length())
	}
	_oxmtcpsrc.Value = uint16(decoder.ReadUint16())
	return _oxmtcpsrc, nil
}

func NewOxmTcpSrc() *OxmTcpSrc {
	obj := &OxmTcpSrc{
		Oxm: NewOxm(2147490306),
	}
	return obj
}
func (self *OxmTcpSrc) GetOXMName() string {
	return "tcp_src"
}

func (self *OxmTcpSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTcpSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmTcpSrcMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmTcpSrcMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmTcpSrcMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmTcpSrcMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmTcpSrcMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmTcpSrcMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmTcpSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmTcpSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmTcpSrcMasked, error) {
	_oxmtcpsrcmasked := &OxmTcpSrcMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmTcpSrcMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmtcpsrcmasked.Value = uint16(decoder.ReadUint16())
	_oxmtcpsrcmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmtcpsrcmasked, nil
}

func NewOxmTcpSrcMasked() *OxmTcpSrcMasked {
	obj := &OxmTcpSrcMasked{
		Oxm: NewOxm(2147490564),
	}
	return obj
}
func (self *OxmTcpSrcMasked) GetOXMName() string {
	return "tcp_src_masked"
}

func (self *OxmTcpSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTcpSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmTcpSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmTunnelId struct {
	*Oxm
	Value uint64
}

type IOxmTunnelId interface {
	goloxi.IOxm
	GetValue() uint64
}

func (self *OxmTunnelId) GetValue() uint64 {
	return self.Value
}

func (self *OxmTunnelId) SetValue(v uint64) {
	self.Value = v
}

func (self *OxmTunnelId) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint64(uint64(self.Value))

	return nil
}

func DecodeOxmTunnelId(parent *Oxm, decoder *goloxi.Decoder) (*OxmTunnelId, error) {
	_oxmtunnelid := &OxmTunnelId{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmTunnelId packet too short: %d < 8", decoder.Length())
	}
	_oxmtunnelid.Value = uint64(decoder.ReadUint64())
	return _oxmtunnelid, nil
}

func NewOxmTunnelId() *OxmTunnelId {
	obj := &OxmTunnelId{
		Oxm: NewOxm(2147503112),
	}
	return obj
}
func (self *OxmTunnelId) GetOXMName() string {
	return "tunnel_id"
}

func (self *OxmTunnelId) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTunnelId) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmTunnelIdMasked struct {
	*Oxm
	Value     uint64
	ValueMask uint64
}

type IOxmTunnelIdMasked interface {
	goloxi.IOxm
	GetValue() uint64
	GetValueMask() uint64
}

func (self *OxmTunnelIdMasked) GetValue() uint64 {
	return self.Value
}

func (self *OxmTunnelIdMasked) SetValue(v uint64) {
	self.Value = v
}

func (self *OxmTunnelIdMasked) GetValueMask() uint64 {
	return self.ValueMask
}

func (self *OxmTunnelIdMasked) SetValueMask(v uint64) {
	self.ValueMask = v
}

func (self *OxmTunnelIdMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint64(uint64(self.Value))
	encoder.PutUint64(uint64(self.ValueMask))

	return nil
}

func DecodeOxmTunnelIdMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmTunnelIdMasked, error) {
	_oxmtunnelidmasked := &OxmTunnelIdMasked{Oxm: parent}
	if decoder.Length() < 16 {
		return nil, fmt.Errorf("OxmTunnelIdMasked packet too short: %d < 16", decoder.Length())
	}
	_oxmtunnelidmasked.Value = uint64(decoder.ReadUint64())
	_oxmtunnelidmasked.ValueMask = uint64(decoder.ReadUint64())
	return _oxmtunnelidmasked, nil
}

func NewOxmTunnelIdMasked() *OxmTunnelIdMasked {
	obj := &OxmTunnelIdMasked{
		Oxm: NewOxm(2147503376),
	}
	return obj
}
func (self *OxmTunnelIdMasked) GetOXMName() string {
	return "tunnel_id_masked"
}

func (self *OxmTunnelIdMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTunnelIdMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmTunnelIdMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmTunnelIpv4Dst struct {
	*Oxm
	Value net.IP
}

type IOxmTunnelIpv4Dst interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *OxmTunnelIpv4Dst) GetValue() net.IP {
	return self.Value
}

func (self *OxmTunnelIpv4Dst) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmTunnelIpv4Dst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeOxmTunnelIpv4Dst(parent *Oxm, decoder *goloxi.Decoder) (*OxmTunnelIpv4Dst, error) {
	_oxmtunnelipv4dst := &OxmTunnelIpv4Dst{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmTunnelIpv4Dst packet too short: %d < 4", decoder.Length())
	}
	_oxmtunnelipv4dst.Value = net.IP(decoder.Read(4))
	return _oxmtunnelipv4dst, nil
}

func NewOxmTunnelIpv4Dst() *OxmTunnelIpv4Dst {
	obj := &OxmTunnelIpv4Dst{
		Oxm: NewOxm(81924),
	}
	return obj
}
func (self *OxmTunnelIpv4Dst) GetOXMName() string {
	return "tunnel_ipv4_dst"
}

func (self *OxmTunnelIpv4Dst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTunnelIpv4Dst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmTunnelIpv4DstMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type IOxmTunnelIpv4DstMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *OxmTunnelIpv4DstMasked) GetValue() net.IP {
	return self.Value
}

func (self *OxmTunnelIpv4DstMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmTunnelIpv4DstMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *OxmTunnelIpv4DstMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *OxmTunnelIpv4DstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeOxmTunnelIpv4DstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmTunnelIpv4DstMasked, error) {
	_oxmtunnelipv4dstmasked := &OxmTunnelIpv4DstMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmTunnelIpv4DstMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmtunnelipv4dstmasked.Value = net.IP(decoder.Read(4))
	_oxmtunnelipv4dstmasked.ValueMask = net.IP(decoder.Read(4))
	return _oxmtunnelipv4dstmasked, nil
}

func NewOxmTunnelIpv4DstMasked() *OxmTunnelIpv4DstMasked {
	obj := &OxmTunnelIpv4DstMasked{
		Oxm: NewOxm(82184),
	}
	return obj
}
func (self *OxmTunnelIpv4DstMasked) GetOXMName() string {
	return "tunnel_ipv4_dst_masked"
}

func (self *OxmTunnelIpv4DstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTunnelIpv4DstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmTunnelIpv4DstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmTunnelIpv4Src struct {
	*Oxm
	Value net.IP
}

type IOxmTunnelIpv4Src interface {
	goloxi.IOxm
	GetValue() net.IP
}

func (self *OxmTunnelIpv4Src) GetValue() net.IP {
	return self.Value
}

func (self *OxmTunnelIpv4Src) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmTunnelIpv4Src) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())

	return nil
}

func DecodeOxmTunnelIpv4Src(parent *Oxm, decoder *goloxi.Decoder) (*OxmTunnelIpv4Src, error) {
	_oxmtunnelipv4src := &OxmTunnelIpv4Src{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmTunnelIpv4Src packet too short: %d < 4", decoder.Length())
	}
	_oxmtunnelipv4src.Value = net.IP(decoder.Read(4))
	return _oxmtunnelipv4src, nil
}

func NewOxmTunnelIpv4Src() *OxmTunnelIpv4Src {
	obj := &OxmTunnelIpv4Src{
		Oxm: NewOxm(81412),
	}
	return obj
}
func (self *OxmTunnelIpv4Src) GetOXMName() string {
	return "tunnel_ipv4_src"
}

func (self *OxmTunnelIpv4Src) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTunnelIpv4Src) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmTunnelIpv4SrcMasked struct {
	*Oxm
	Value     net.IP
	ValueMask net.IP
}

type IOxmTunnelIpv4SrcMasked interface {
	goloxi.IOxm
	GetValue() net.IP
	GetValueMask() net.IP
}

func (self *OxmTunnelIpv4SrcMasked) GetValue() net.IP {
	return self.Value
}

func (self *OxmTunnelIpv4SrcMasked) SetValue(v net.IP) {
	self.Value = v
}

func (self *OxmTunnelIpv4SrcMasked) GetValueMask() net.IP {
	return self.ValueMask
}

func (self *OxmTunnelIpv4SrcMasked) SetValueMask(v net.IP) {
	self.ValueMask = v
}

func (self *OxmTunnelIpv4SrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.Write(self.Value.To4())
	encoder.Write(self.ValueMask.To4())

	return nil
}

func DecodeOxmTunnelIpv4SrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmTunnelIpv4SrcMasked, error) {
	_oxmtunnelipv4srcmasked := &OxmTunnelIpv4SrcMasked{Oxm: parent}
	if decoder.Length() < 8 {
		return nil, fmt.Errorf("OxmTunnelIpv4SrcMasked packet too short: %d < 8", decoder.Length())
	}
	_oxmtunnelipv4srcmasked.Value = net.IP(decoder.Read(4))
	_oxmtunnelipv4srcmasked.ValueMask = net.IP(decoder.Read(4))
	return _oxmtunnelipv4srcmasked, nil
}

func NewOxmTunnelIpv4SrcMasked() *OxmTunnelIpv4SrcMasked {
	obj := &OxmTunnelIpv4SrcMasked{
		Oxm: NewOxm(81672),
	}
	return obj
}
func (self *OxmTunnelIpv4SrcMasked) GetOXMName() string {
	return "tunnel_ipv4_src_masked"
}

func (self *OxmTunnelIpv4SrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmTunnelIpv4SrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmTunnelIpv4SrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmUdpDst struct {
	*Oxm
	Value uint16
}

type IOxmUdpDst interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmUdpDst) GetValue() uint16 {
	return self.Value
}

func (self *OxmUdpDst) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmUdpDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmUdpDst(parent *Oxm, decoder *goloxi.Decoder) (*OxmUdpDst, error) {
	_oxmudpdst := &OxmUdpDst{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmUdpDst packet too short: %d < 2", decoder.Length())
	}
	_oxmudpdst.Value = uint16(decoder.ReadUint16())
	return _oxmudpdst, nil
}

func NewOxmUdpDst() *OxmUdpDst {
	obj := &OxmUdpDst{
		Oxm: NewOxm(2147491842),
	}
	return obj
}
func (self *OxmUdpDst) GetOXMName() string {
	return "udp_dst"
}

func (self *OxmUdpDst) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmUdpDst) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmUdpDstMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmUdpDstMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmUdpDstMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmUdpDstMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmUdpDstMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmUdpDstMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmUdpDstMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmUdpDstMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmUdpDstMasked, error) {
	_oxmudpdstmasked := &OxmUdpDstMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmUdpDstMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmudpdstmasked.Value = uint16(decoder.ReadUint16())
	_oxmudpdstmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmudpdstmasked, nil
}

func NewOxmUdpDstMasked() *OxmUdpDstMasked {
	obj := &OxmUdpDstMasked{
		Oxm: NewOxm(2147492100),
	}
	return obj
}
func (self *OxmUdpDstMasked) GetOXMName() string {
	return "udp_dst_masked"
}

func (self *OxmUdpDstMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmUdpDstMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmUdpDstMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmUdpSrc struct {
	*Oxm
	Value uint16
}

type IOxmUdpSrc interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmUdpSrc) GetValue() uint16 {
	return self.Value
}

func (self *OxmUdpSrc) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmUdpSrc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmUdpSrc(parent *Oxm, decoder *goloxi.Decoder) (*OxmUdpSrc, error) {
	_oxmudpsrc := &OxmUdpSrc{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmUdpSrc packet too short: %d < 2", decoder.Length())
	}
	_oxmudpsrc.Value = uint16(decoder.ReadUint16())
	return _oxmudpsrc, nil
}

func NewOxmUdpSrc() *OxmUdpSrc {
	obj := &OxmUdpSrc{
		Oxm: NewOxm(2147491330),
	}
	return obj
}
func (self *OxmUdpSrc) GetOXMName() string {
	return "udp_src"
}

func (self *OxmUdpSrc) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmUdpSrc) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmUdpSrcMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmUdpSrcMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmUdpSrcMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmUdpSrcMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmUdpSrcMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmUdpSrcMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmUdpSrcMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmUdpSrcMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmUdpSrcMasked, error) {
	_oxmudpsrcmasked := &OxmUdpSrcMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmUdpSrcMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmudpsrcmasked.Value = uint16(decoder.ReadUint16())
	_oxmudpsrcmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmudpsrcmasked, nil
}

func NewOxmUdpSrcMasked() *OxmUdpSrcMasked {
	obj := &OxmUdpSrcMasked{
		Oxm: NewOxm(2147491588),
	}
	return obj
}
func (self *OxmUdpSrcMasked) GetOXMName() string {
	return "udp_src_masked"
}

func (self *OxmUdpSrcMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmUdpSrcMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmUdpSrcMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmVlanPcp struct {
	*Oxm
	Value uint8
}

type IOxmVlanPcp interface {
	goloxi.IOxm
	GetValue() uint8
}

func (self *OxmVlanPcp) GetValue() uint8 {
	return self.Value
}

func (self *OxmVlanPcp) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmVlanPcp) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))

	return nil
}

func DecodeOxmVlanPcp(parent *Oxm, decoder *goloxi.Decoder) (*OxmVlanPcp, error) {
	_oxmvlanpcp := &OxmVlanPcp{Oxm: parent}
	if decoder.Length() < 1 {
		return nil, fmt.Errorf("OxmVlanPcp packet too short: %d < 1", decoder.Length())
	}
	_oxmvlanpcp.Value = uint8(decoder.ReadByte())
	return _oxmvlanpcp, nil
}

func NewOxmVlanPcp() *OxmVlanPcp {
	obj := &OxmVlanPcp{
		Oxm: NewOxm(2147487233),
	}
	return obj
}
func (self *OxmVlanPcp) GetOXMName() string {
	return "vlan_pcp"
}

func (self *OxmVlanPcp) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmVlanPcp) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmVlanPcpMasked struct {
	*Oxm
	Value     uint8
	ValueMask uint8
}

type IOxmVlanPcpMasked interface {
	goloxi.IOxm
	GetValue() uint8
	GetValueMask() uint8
}

func (self *OxmVlanPcpMasked) GetValue() uint8 {
	return self.Value
}

func (self *OxmVlanPcpMasked) SetValue(v uint8) {
	self.Value = v
}

func (self *OxmVlanPcpMasked) GetValueMask() uint8 {
	return self.ValueMask
}

func (self *OxmVlanPcpMasked) SetValueMask(v uint8) {
	self.ValueMask = v
}

func (self *OxmVlanPcpMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint8(uint8(self.Value))
	encoder.PutUint8(uint8(self.ValueMask))

	return nil
}

func DecodeOxmVlanPcpMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmVlanPcpMasked, error) {
	_oxmvlanpcpmasked := &OxmVlanPcpMasked{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmVlanPcpMasked packet too short: %d < 2", decoder.Length())
	}
	_oxmvlanpcpmasked.Value = uint8(decoder.ReadByte())
	_oxmvlanpcpmasked.ValueMask = uint8(decoder.ReadByte())
	return _oxmvlanpcpmasked, nil
}

func NewOxmVlanPcpMasked() *OxmVlanPcpMasked {
	obj := &OxmVlanPcpMasked{
		Oxm: NewOxm(2147487490),
	}
	return obj
}
func (self *OxmVlanPcpMasked) GetOXMName() string {
	return "vlan_pcp_masked"
}

func (self *OxmVlanPcpMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmVlanPcpMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmVlanPcpMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}

type OxmVlanVid struct {
	*Oxm
	Value uint16
}

type IOxmVlanVid interface {
	goloxi.IOxm
	GetValue() uint16
}

func (self *OxmVlanVid) GetValue() uint16 {
	return self.Value
}

func (self *OxmVlanVid) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmVlanVid) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))

	return nil
}

func DecodeOxmVlanVid(parent *Oxm, decoder *goloxi.Decoder) (*OxmVlanVid, error) {
	_oxmvlanvid := &OxmVlanVid{Oxm: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("OxmVlanVid packet too short: %d < 2", decoder.Length())
	}
	_oxmvlanvid.Value = uint16(decoder.ReadUint16())
	return _oxmvlanvid, nil
}

func NewOxmVlanVid() *OxmVlanVid {
	obj := &OxmVlanVid{
		Oxm: NewOxm(2147486722),
	}
	return obj
}
func (self *OxmVlanVid) GetOXMName() string {
	return "vlan_vid"
}

func (self *OxmVlanVid) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmVlanVid) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s}", self.GetOXMName(), string(value))), nil
}

type OxmVlanVidMasked struct {
	*Oxm
	Value     uint16
	ValueMask uint16
}

type IOxmVlanVidMasked interface {
	goloxi.IOxm
	GetValue() uint16
	GetValueMask() uint16
}

func (self *OxmVlanVidMasked) GetValue() uint16 {
	return self.Value
}

func (self *OxmVlanVidMasked) SetValue(v uint16) {
	self.Value = v
}

func (self *OxmVlanVidMasked) GetValueMask() uint16 {
	return self.ValueMask
}

func (self *OxmVlanVidMasked) SetValueMask(v uint16) {
	self.ValueMask = v
}

func (self *OxmVlanVidMasked) Serialize(encoder *goloxi.Encoder) error {
	if err := self.Oxm.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Value))
	encoder.PutUint16(uint16(self.ValueMask))

	return nil
}

func DecodeOxmVlanVidMasked(parent *Oxm, decoder *goloxi.Decoder) (*OxmVlanVidMasked, error) {
	_oxmvlanvidmasked := &OxmVlanVidMasked{Oxm: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("OxmVlanVidMasked packet too short: %d < 4", decoder.Length())
	}
	_oxmvlanvidmasked.Value = uint16(decoder.ReadUint16())
	_oxmvlanvidmasked.ValueMask = uint16(decoder.ReadUint16())
	return _oxmvlanvidmasked, nil
}

func NewOxmVlanVidMasked() *OxmVlanVidMasked {
	obj := &OxmVlanVidMasked{
		Oxm: NewOxm(2147486980),
	}
	return obj
}
func (self *OxmVlanVidMasked) GetOXMName() string {
	return "vlan_vid_masked"
}

func (self *OxmVlanVidMasked) GetOXMValue() interface{} {
	return self.Value
}

func (self *OxmVlanVidMasked) GetOXMValueMask() interface{} {
	return self.ValueMask
}

func (self *OxmVlanVidMasked) MarshalJSON() ([]byte, error) {
	value, err := jsonValue(self.GetOXMValue())
	if err != nil {
		return nil, err
	}
	valueMask, err := jsonValue(self.GetOXMValueMask())
	if err != nil {
		return nil, err
	}
	return []byte(fmt.Sprintf("{\"Type\":\"%s\",\"Value\":%s,\"Mask\":%s}", self.GetOXMName(), string(value), string(valueMask))), nil
}
