// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/device.proto

package voltha

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	common "github.com/opencord/voltha-protos/v2/go/common"
	openflow_13 "github.com/opencord/voltha-protos/v2/go/openflow_13"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PmConfig_PmType int32

const (
	PmConfig_COUNTER PmConfig_PmType = 0
	PmConfig_GAUGE   PmConfig_PmType = 1
	PmConfig_STATE   PmConfig_PmType = 2
	PmConfig_CONTEXT PmConfig_PmType = 3
)

var PmConfig_PmType_name = map[int32]string{
	0: "COUNTER",
	1: "GAUGE",
	2: "STATE",
	3: "CONTEXT",
}

var PmConfig_PmType_value = map[string]int32{
	"COUNTER": 0,
	"GAUGE":   1,
	"STATE":   2,
	"CONTEXT": 3,
}

func (x PmConfig_PmType) String() string {
	return proto.EnumName(PmConfig_PmType_name, int32(x))
}

func (PmConfig_PmType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{2, 0}
}

type ImageDownload_ImageDownloadState int32

const (
	ImageDownload_DOWNLOAD_UNKNOWN     ImageDownload_ImageDownloadState = 0
	ImageDownload_DOWNLOAD_SUCCEEDED   ImageDownload_ImageDownloadState = 1
	ImageDownload_DOWNLOAD_REQUESTED   ImageDownload_ImageDownloadState = 2
	ImageDownload_DOWNLOAD_STARTED     ImageDownload_ImageDownloadState = 3
	ImageDownload_DOWNLOAD_FAILED      ImageDownload_ImageDownloadState = 4
	ImageDownload_DOWNLOAD_UNSUPPORTED ImageDownload_ImageDownloadState = 5
	ImageDownload_DOWNLOAD_CANCELLED   ImageDownload_ImageDownloadState = 6
)

var ImageDownload_ImageDownloadState_name = map[int32]string{
	0: "DOWNLOAD_UNKNOWN",
	1: "DOWNLOAD_SUCCEEDED",
	2: "DOWNLOAD_REQUESTED",
	3: "DOWNLOAD_STARTED",
	4: "DOWNLOAD_FAILED",
	5: "DOWNLOAD_UNSUPPORTED",
	6: "DOWNLOAD_CANCELLED",
}

var ImageDownload_ImageDownloadState_value = map[string]int32{
	"DOWNLOAD_UNKNOWN":     0,
	"DOWNLOAD_SUCCEEDED":   1,
	"DOWNLOAD_REQUESTED":   2,
	"DOWNLOAD_STARTED":     3,
	"DOWNLOAD_FAILED":      4,
	"DOWNLOAD_UNSUPPORTED": 5,
	"DOWNLOAD_CANCELLED":   6,
}

func (x ImageDownload_ImageDownloadState) String() string {
	return proto.EnumName(ImageDownload_ImageDownloadState_name, int32(x))
}

func (ImageDownload_ImageDownloadState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7, 0}
}

type ImageDownload_ImageDownloadFailureReason int32

const (
	ImageDownload_NO_ERROR           ImageDownload_ImageDownloadFailureReason = 0
	ImageDownload_INVALID_URL        ImageDownload_ImageDownloadFailureReason = 1
	ImageDownload_DEVICE_BUSY        ImageDownload_ImageDownloadFailureReason = 2
	ImageDownload_INSUFFICIENT_SPACE ImageDownload_ImageDownloadFailureReason = 3
	ImageDownload_UNKNOWN_ERROR      ImageDownload_ImageDownloadFailureReason = 4
	ImageDownload_CANCELLED          ImageDownload_ImageDownloadFailureReason = 5
)

var ImageDownload_ImageDownloadFailureReason_name = map[int32]string{
	0: "NO_ERROR",
	1: "INVALID_URL",
	2: "DEVICE_BUSY",
	3: "INSUFFICIENT_SPACE",
	4: "UNKNOWN_ERROR",
	5: "CANCELLED",
}

var ImageDownload_ImageDownloadFailureReason_value = map[string]int32{
	"NO_ERROR":           0,
	"INVALID_URL":        1,
	"DEVICE_BUSY":        2,
	"INSUFFICIENT_SPACE": 3,
	"UNKNOWN_ERROR":      4,
	"CANCELLED":          5,
}

func (x ImageDownload_ImageDownloadFailureReason) String() string {
	return proto.EnumName(ImageDownload_ImageDownloadFailureReason_name, int32(x))
}

func (ImageDownload_ImageDownloadFailureReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7, 1}
}

type ImageDownload_ImageActivateState int32

const (
	ImageDownload_IMAGE_UNKNOWN    ImageDownload_ImageActivateState = 0
	ImageDownload_IMAGE_INACTIVE   ImageDownload_ImageActivateState = 1
	ImageDownload_IMAGE_ACTIVATING ImageDownload_ImageActivateState = 2
	ImageDownload_IMAGE_ACTIVE     ImageDownload_ImageActivateState = 3
	ImageDownload_IMAGE_REVERTING  ImageDownload_ImageActivateState = 4
	ImageDownload_IMAGE_REVERTED   ImageDownload_ImageActivateState = 5
)

var ImageDownload_ImageActivateState_name = map[int32]string{
	0: "IMAGE_UNKNOWN",
	1: "IMAGE_INACTIVE",
	2: "IMAGE_ACTIVATING",
	3: "IMAGE_ACTIVE",
	4: "IMAGE_REVERTING",
	5: "IMAGE_REVERTED",
}

var ImageDownload_ImageActivateState_value = map[string]int32{
	"IMAGE_UNKNOWN":    0,
	"IMAGE_INACTIVE":   1,
	"IMAGE_ACTIVATING": 2,
	"IMAGE_ACTIVE":     3,
	"IMAGE_REVERTING":  4,
	"IMAGE_REVERTED":   5,
}

func (x ImageDownload_ImageActivateState) String() string {
	return proto.EnumName(ImageDownload_ImageActivateState_name, int32(x))
}

func (ImageDownload_ImageActivateState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7, 2}
}

type Port_PortType int32

const (
	Port_UNKNOWN      Port_PortType = 0
	Port_ETHERNET_NNI Port_PortType = 1
	Port_ETHERNET_UNI Port_PortType = 2
	Port_PON_OLT      Port_PortType = 3
	Port_PON_ONU      Port_PortType = 4
	Port_VENET_OLT    Port_PortType = 5
	Port_VENET_ONU    Port_PortType = 6
)

var Port_PortType_name = map[int32]string{
	0: "UNKNOWN",
	1: "ETHERNET_NNI",
	2: "ETHERNET_UNI",
	3: "PON_OLT",
	4: "PON_ONU",
	5: "VENET_OLT",
	6: "VENET_ONU",
}

var Port_PortType_value = map[string]int32{
	"UNKNOWN":      0,
	"ETHERNET_NNI": 1,
	"ETHERNET_UNI": 2,
	"PON_OLT":      3,
	"PON_ONU":      4,
	"VENET_OLT":    5,
	"VENET_ONU":    6,
}

func (x Port_PortType) String() string {
	return proto.EnumName(Port_PortType_name, int32(x))
}

func (Port_PortType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9, 0}
}

type SimulateAlarmRequest_OperationType int32

const (
	SimulateAlarmRequest_RAISE SimulateAlarmRequest_OperationType = 0
	SimulateAlarmRequest_CLEAR SimulateAlarmRequest_OperationType = 1
)

var SimulateAlarmRequest_OperationType_name = map[int32]string{
	0: "RAISE",
	1: "CLEAR",
}

var SimulateAlarmRequest_OperationType_value = map[string]int32{
	"RAISE": 0,
	"CLEAR": 1,
}

func (x SimulateAlarmRequest_OperationType) String() string {
	return proto.EnumName(SimulateAlarmRequest_OperationType_name, int32(x))
}

func (SimulateAlarmRequest_OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{13, 0}
}

// A Device Type
type DeviceType struct {
	// Unique name for the device type
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Unique vendor id for the device type applicable to ONU
	// 4 bytes of vendor id from ONU serial number
	VendorId  string   `protobuf:"bytes,5,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	VendorIds []string `protobuf:"bytes,6,rep,name=vendor_ids,json=vendorIds,proto3" json:"vendor_ids,omitempty"`
	// Name of the adapter that handles device type
	Adapter string `protobuf:"bytes,2,opt,name=adapter,proto3" json:"adapter,omitempty"`
	// Capabilities
	AcceptsBulkFlowUpdate           bool     `protobuf:"varint,3,opt,name=accepts_bulk_flow_update,json=acceptsBulkFlowUpdate,proto3" json:"accepts_bulk_flow_update,omitempty"`
	AcceptsAddRemoveFlowUpdates     bool     `protobuf:"varint,4,opt,name=accepts_add_remove_flow_updates,json=acceptsAddRemoveFlowUpdates,proto3" json:"accepts_add_remove_flow_updates,omitempty"`
	AcceptsDirectLogicalFlowsUpdate bool     `protobuf:"varint,7,opt,name=accepts_direct_logical_flows_update,json=acceptsDirectLogicalFlowsUpdate,proto3" json:"accepts_direct_logical_flows_update,omitempty"`
	XXX_NoUnkeyedLiteral            struct{} `json:"-"`
	XXX_unrecognized                []byte   `json:"-"`
	XXX_sizecache                   int32    `json:"-"`
}

func (m *DeviceType) Reset()         { *m = DeviceType{} }
func (m *DeviceType) String() string { return proto.CompactTextString(m) }
func (*DeviceType) ProtoMessage()    {}
func (*DeviceType) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{0}
}

func (m *DeviceType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceType.Unmarshal(m, b)
}
func (m *DeviceType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceType.Marshal(b, m, deterministic)
}
func (m *DeviceType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceType.Merge(m, src)
}
func (m *DeviceType) XXX_Size() int {
	return xxx_messageInfo_DeviceType.Size(m)
}
func (m *DeviceType) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceType.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceType proto.InternalMessageInfo

func (m *DeviceType) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeviceType) GetVendorId() string {
	if m != nil {
		return m.VendorId
	}
	return ""
}

func (m *DeviceType) GetVendorIds() []string {
	if m != nil {
		return m.VendorIds
	}
	return nil
}

func (m *DeviceType) GetAdapter() string {
	if m != nil {
		return m.Adapter
	}
	return ""
}

func (m *DeviceType) GetAcceptsBulkFlowUpdate() bool {
	if m != nil {
		return m.AcceptsBulkFlowUpdate
	}
	return false
}

func (m *DeviceType) GetAcceptsAddRemoveFlowUpdates() bool {
	if m != nil {
		return m.AcceptsAddRemoveFlowUpdates
	}
	return false
}

func (m *DeviceType) GetAcceptsDirectLogicalFlowsUpdate() bool {
	if m != nil {
		return m.AcceptsDirectLogicalFlowsUpdate
	}
	return false
}

// A plurality of device types
type DeviceTypes struct {
	Items                []*DeviceType `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DeviceTypes) Reset()         { *m = DeviceTypes{} }
func (m *DeviceTypes) String() string { return proto.CompactTextString(m) }
func (*DeviceTypes) ProtoMessage()    {}
func (*DeviceTypes) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{1}
}

func (m *DeviceTypes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceTypes.Unmarshal(m, b)
}
func (m *DeviceTypes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceTypes.Marshal(b, m, deterministic)
}
func (m *DeviceTypes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceTypes.Merge(m, src)
}
func (m *DeviceTypes) XXX_Size() int {
	return xxx_messageInfo_DeviceTypes.Size(m)
}
func (m *DeviceTypes) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceTypes.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceTypes proto.InternalMessageInfo

func (m *DeviceTypes) GetItems() []*DeviceType {
	if m != nil {
		return m.Items
	}
	return nil
}

type PmConfig struct {
	Name                 string          `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type                 PmConfig_PmType `protobuf:"varint,2,opt,name=type,proto3,enum=voltha.PmConfig_PmType" json:"type,omitempty"`
	Enabled              bool            `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	SampleFreq           uint32          `protobuf:"varint,4,opt,name=sample_freq,json=sampleFreq,proto3" json:"sample_freq,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *PmConfig) Reset()         { *m = PmConfig{} }
func (m *PmConfig) String() string { return proto.CompactTextString(m) }
func (*PmConfig) ProtoMessage()    {}
func (*PmConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{2}
}

func (m *PmConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmConfig.Unmarshal(m, b)
}
func (m *PmConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmConfig.Marshal(b, m, deterministic)
}
func (m *PmConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmConfig.Merge(m, src)
}
func (m *PmConfig) XXX_Size() int {
	return xxx_messageInfo_PmConfig.Size(m)
}
func (m *PmConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PmConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PmConfig proto.InternalMessageInfo

func (m *PmConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PmConfig) GetType() PmConfig_PmType {
	if m != nil {
		return m.Type
	}
	return PmConfig_COUNTER
}

func (m *PmConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PmConfig) GetSampleFreq() uint32 {
	if m != nil {
		return m.SampleFreq
	}
	return 0
}

type PmGroupConfig struct {
	GroupName            string      `protobuf:"bytes,1,opt,name=group_name,json=groupName,proto3" json:"group_name,omitempty"`
	GroupFreq            uint32      `protobuf:"varint,2,opt,name=group_freq,json=groupFreq,proto3" json:"group_freq,omitempty"`
	Enabled              bool        `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Metrics              []*PmConfig `protobuf:"bytes,4,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *PmGroupConfig) Reset()         { *m = PmGroupConfig{} }
func (m *PmGroupConfig) String() string { return proto.CompactTextString(m) }
func (*PmGroupConfig) ProtoMessage()    {}
func (*PmGroupConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{3}
}

func (m *PmGroupConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmGroupConfig.Unmarshal(m, b)
}
func (m *PmGroupConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmGroupConfig.Marshal(b, m, deterministic)
}
func (m *PmGroupConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmGroupConfig.Merge(m, src)
}
func (m *PmGroupConfig) XXX_Size() int {
	return xxx_messageInfo_PmGroupConfig.Size(m)
}
func (m *PmGroupConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PmGroupConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PmGroupConfig proto.InternalMessageInfo

func (m *PmGroupConfig) GetGroupName() string {
	if m != nil {
		return m.GroupName
	}
	return ""
}

func (m *PmGroupConfig) GetGroupFreq() uint32 {
	if m != nil {
		return m.GroupFreq
	}
	return 0
}

func (m *PmGroupConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PmGroupConfig) GetMetrics() []*PmConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type PmConfigs struct {
	Id          string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	DefaultFreq uint32 `protobuf:"varint,2,opt,name=default_freq,json=defaultFreq,proto3" json:"default_freq,omitempty"`
	// Forces group names and group semantics
	Grouped bool `protobuf:"varint,3,opt,name=grouped,proto3" json:"grouped,omitempty"`
	// Allows Pm to set an individual sample frequency
	FreqOverride         bool             `protobuf:"varint,4,opt,name=freq_override,json=freqOverride,proto3" json:"freq_override,omitempty"`
	Groups               []*PmGroupConfig `protobuf:"bytes,5,rep,name=groups,proto3" json:"groups,omitempty"`
	Metrics              []*PmConfig      `protobuf:"bytes,6,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PmConfigs) Reset()         { *m = PmConfigs{} }
func (m *PmConfigs) String() string { return proto.CompactTextString(m) }
func (*PmConfigs) ProtoMessage()    {}
func (*PmConfigs) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{4}
}

func (m *PmConfigs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PmConfigs.Unmarshal(m, b)
}
func (m *PmConfigs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PmConfigs.Marshal(b, m, deterministic)
}
func (m *PmConfigs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PmConfigs.Merge(m, src)
}
func (m *PmConfigs) XXX_Size() int {
	return xxx_messageInfo_PmConfigs.Size(m)
}
func (m *PmConfigs) XXX_DiscardUnknown() {
	xxx_messageInfo_PmConfigs.DiscardUnknown(m)
}

var xxx_messageInfo_PmConfigs proto.InternalMessageInfo

func (m *PmConfigs) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PmConfigs) GetDefaultFreq() uint32 {
	if m != nil {
		return m.DefaultFreq
	}
	return 0
}

func (m *PmConfigs) GetGrouped() bool {
	if m != nil {
		return m.Grouped
	}
	return false
}

func (m *PmConfigs) GetFreqOverride() bool {
	if m != nil {
		return m.FreqOverride
	}
	return false
}

func (m *PmConfigs) GetGroups() []*PmGroupConfig {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *PmConfigs) GetMetrics() []*PmConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// Describes instance of software image on the device
type Image struct {
	Name            string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version         string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Hash            string `protobuf:"bytes,3,opt,name=hash,proto3" json:"hash,omitempty"`
	InstallDatetime string `protobuf:"bytes,4,opt,name=install_datetime,json=installDatetime,proto3" json:"install_datetime,omitempty"`
	// The active software image is one that is currently loaded and executing
	// in the ONU or circuit pack. Under normal operation, one software image
	// is always active while the other is inactive. Under no circumstances are
	// both software images allowed to be active at the same time
	IsActive bool `protobuf:"varint,5,opt,name=is_active,json=isActive,proto3" json:"is_active,omitempty"`
	// The committed software image is loaded and executed upon reboot of the
	// ONU and/or circuit pack. During normal operation, one software image is
	// always committed, while the other is uncommitted.
	IsCommitted bool `protobuf:"varint,6,opt,name=is_committed,json=isCommitted,proto3" json:"is_committed,omitempty"`
	// A software image is valid if it has been verified to be an executable
	// code image. The verification mechanism is not subject to standardization;
	// however, it should include at least a data integrity (e.g., CRC) check of
	// the entire code image.
	IsValid              bool     `protobuf:"varint,7,opt,name=is_valid,json=isValid,proto3" json:"is_valid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{5}
}

func (m *Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Image.Unmarshal(m, b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Image.Marshal(b, m, deterministic)
}
func (m *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(m, src)
}
func (m *Image) XXX_Size() int {
	return xxx_messageInfo_Image.Size(m)
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *Image) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Image) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Image) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *Image) GetInstallDatetime() string {
	if m != nil {
		return m.InstallDatetime
	}
	return ""
}

func (m *Image) GetIsActive() bool {
	if m != nil {
		return m.IsActive
	}
	return false
}

func (m *Image) GetIsCommitted() bool {
	if m != nil {
		return m.IsCommitted
	}
	return false
}

func (m *Image) GetIsValid() bool {
	if m != nil {
		return m.IsValid
	}
	return false
}

// List of software on the device
type Images struct {
	Image                []*Image `protobuf:"bytes,1,rep,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Images) Reset()         { *m = Images{} }
func (m *Images) String() string { return proto.CompactTextString(m) }
func (*Images) ProtoMessage()    {}
func (*Images) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{6}
}

func (m *Images) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Images.Unmarshal(m, b)
}
func (m *Images) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Images.Marshal(b, m, deterministic)
}
func (m *Images) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Images.Merge(m, src)
}
func (m *Images) XXX_Size() int {
	return xxx_messageInfo_Images.Size(m)
}
func (m *Images) XXX_DiscardUnknown() {
	xxx_messageInfo_Images.DiscardUnknown(m)
}

var xxx_messageInfo_Images proto.InternalMessageInfo

func (m *Images) GetImage() []*Image {
	if m != nil {
		return m.Image
	}
	return nil
}

type ImageDownload struct {
	// Device Identifier
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Image unique identifier
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// URL where the image is available
	// should include username password
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// CRC of the image to be verified aginst
	Crc uint32 `protobuf:"varint,4,opt,name=crc,proto3" json:"crc,omitempty"`
	// Download state
	DownloadState ImageDownload_ImageDownloadState `protobuf:"varint,5,opt,name=download_state,json=downloadState,proto3,enum=voltha.ImageDownload_ImageDownloadState" json:"download_state,omitempty"`
	// Downloaded version
	ImageVersion string `protobuf:"bytes,6,opt,name=image_version,json=imageVersion,proto3" json:"image_version,omitempty"`
	// Bytes downloaded
	DownloadedBytes uint32 `protobuf:"varint,7,opt,name=downloaded_bytes,json=downloadedBytes,proto3" json:"downloaded_bytes,omitempty"`
	// Download failure reason
	Reason ImageDownload_ImageDownloadFailureReason `protobuf:"varint,8,opt,name=reason,proto3,enum=voltha.ImageDownload_ImageDownloadFailureReason" json:"reason,omitempty"`
	// Additional info
	AdditionalInfo string `protobuf:"bytes,9,opt,name=additional_info,json=additionalInfo,proto3" json:"additional_info,omitempty"`
	// Save current configuration
	SaveConfig bool `protobuf:"varint,10,opt,name=save_config,json=saveConfig,proto3" json:"save_config,omitempty"`
	// Image local location
	LocalDir string `protobuf:"bytes,11,opt,name=local_dir,json=localDir,proto3" json:"local_dir,omitempty"`
	// Image activation state
	ImageState ImageDownload_ImageActivateState `protobuf:"varint,12,opt,name=image_state,json=imageState,proto3,enum=voltha.ImageDownload_ImageActivateState" json:"image_state,omitempty"`
	// Image file size
	FileSize             uint32   `protobuf:"varint,13,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageDownload) Reset()         { *m = ImageDownload{} }
func (m *ImageDownload) String() string { return proto.CompactTextString(m) }
func (*ImageDownload) ProtoMessage()    {}
func (*ImageDownload) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{7}
}

func (m *ImageDownload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageDownload.Unmarshal(m, b)
}
func (m *ImageDownload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageDownload.Marshal(b, m, deterministic)
}
func (m *ImageDownload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageDownload.Merge(m, src)
}
func (m *ImageDownload) XXX_Size() int {
	return xxx_messageInfo_ImageDownload.Size(m)
}
func (m *ImageDownload) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageDownload.DiscardUnknown(m)
}

var xxx_messageInfo_ImageDownload proto.InternalMessageInfo

func (m *ImageDownload) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ImageDownload) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImageDownload) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *ImageDownload) GetCrc() uint32 {
	if m != nil {
		return m.Crc
	}
	return 0
}

func (m *ImageDownload) GetDownloadState() ImageDownload_ImageDownloadState {
	if m != nil {
		return m.DownloadState
	}
	return ImageDownload_DOWNLOAD_UNKNOWN
}

func (m *ImageDownload) GetImageVersion() string {
	if m != nil {
		return m.ImageVersion
	}
	return ""
}

func (m *ImageDownload) GetDownloadedBytes() uint32 {
	if m != nil {
		return m.DownloadedBytes
	}
	return 0
}

func (m *ImageDownload) GetReason() ImageDownload_ImageDownloadFailureReason {
	if m != nil {
		return m.Reason
	}
	return ImageDownload_NO_ERROR
}

func (m *ImageDownload) GetAdditionalInfo() string {
	if m != nil {
		return m.AdditionalInfo
	}
	return ""
}

func (m *ImageDownload) GetSaveConfig() bool {
	if m != nil {
		return m.SaveConfig
	}
	return false
}

func (m *ImageDownload) GetLocalDir() string {
	if m != nil {
		return m.LocalDir
	}
	return ""
}

func (m *ImageDownload) GetImageState() ImageDownload_ImageActivateState {
	if m != nil {
		return m.ImageState
	}
	return ImageDownload_IMAGE_UNKNOWN
}

func (m *ImageDownload) GetFileSize() uint32 {
	if m != nil {
		return m.FileSize
	}
	return 0
}

type ImageDownloads struct {
	Items                []*ImageDownload `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ImageDownloads) Reset()         { *m = ImageDownloads{} }
func (m *ImageDownloads) String() string { return proto.CompactTextString(m) }
func (*ImageDownloads) ProtoMessage()    {}
func (*ImageDownloads) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{8}
}

func (m *ImageDownloads) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageDownloads.Unmarshal(m, b)
}
func (m *ImageDownloads) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageDownloads.Marshal(b, m, deterministic)
}
func (m *ImageDownloads) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageDownloads.Merge(m, src)
}
func (m *ImageDownloads) XXX_Size() int {
	return xxx_messageInfo_ImageDownloads.Size(m)
}
func (m *ImageDownloads) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageDownloads.DiscardUnknown(m)
}

var xxx_messageInfo_ImageDownloads proto.InternalMessageInfo

func (m *ImageDownloads) GetItems() []*ImageDownload {
	if m != nil {
		return m.Items
	}
	return nil
}

type Port struct {
	PortNo               uint32                       `protobuf:"varint,1,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	Label                string                       `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	Type                 Port_PortType                `protobuf:"varint,3,opt,name=type,proto3,enum=voltha.Port_PortType" json:"type,omitempty"`
	AdminState           common.AdminState_AdminState `protobuf:"varint,5,opt,name=admin_state,json=adminState,proto3,enum=common.AdminState_AdminState" json:"admin_state,omitempty"`
	OperStatus           common.OperStatus_OperStatus `protobuf:"varint,6,opt,name=oper_status,json=operStatus,proto3,enum=common.OperStatus_OperStatus" json:"oper_status,omitempty"`
	DeviceId             string                       `protobuf:"bytes,7,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	Peers                []*Port_PeerPort             `protobuf:"bytes,8,rep,name=peers,proto3" json:"peers,omitempty"`
	RxPackets            uint64                       `protobuf:"fixed64,9,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	RxBytes              uint64                       `protobuf:"fixed64,10,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	RxErrors             uint64                       `protobuf:"fixed64,11,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	TxPackets            uint64                       `protobuf:"fixed64,12,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	TxBytes              uint64                       `protobuf:"fixed64,13,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	TxErrors             uint64                       `protobuf:"fixed64,14,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Port) Reset()         { *m = Port{} }
func (m *Port) String() string { return proto.CompactTextString(m) }
func (*Port) ProtoMessage()    {}
func (*Port) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9}
}

func (m *Port) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Port.Unmarshal(m, b)
}
func (m *Port) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Port.Marshal(b, m, deterministic)
}
func (m *Port) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port.Merge(m, src)
}
func (m *Port) XXX_Size() int {
	return xxx_messageInfo_Port.Size(m)
}
func (m *Port) XXX_DiscardUnknown() {
	xxx_messageInfo_Port.DiscardUnknown(m)
}

var xxx_messageInfo_Port proto.InternalMessageInfo

func (m *Port) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

func (m *Port) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Port) GetType() Port_PortType {
	if m != nil {
		return m.Type
	}
	return Port_UNKNOWN
}

func (m *Port) GetAdminState() common.AdminState_AdminState {
	if m != nil {
		return m.AdminState
	}
	return common.AdminState_UNKNOWN
}

func (m *Port) GetOperStatus() common.OperStatus_OperStatus {
	if m != nil {
		return m.OperStatus
	}
	return common.OperStatus_UNKNOWN
}

func (m *Port) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Port) GetPeers() []*Port_PeerPort {
	if m != nil {
		return m.Peers
	}
	return nil
}

func (m *Port) GetRxPackets() uint64 {
	if m != nil {
		return m.RxPackets
	}
	return 0
}

func (m *Port) GetRxBytes() uint64 {
	if m != nil {
		return m.RxBytes
	}
	return 0
}

func (m *Port) GetRxErrors() uint64 {
	if m != nil {
		return m.RxErrors
	}
	return 0
}

func (m *Port) GetTxPackets() uint64 {
	if m != nil {
		return m.TxPackets
	}
	return 0
}

func (m *Port) GetTxBytes() uint64 {
	if m != nil {
		return m.TxBytes
	}
	return 0
}

func (m *Port) GetTxErrors() uint64 {
	if m != nil {
		return m.TxErrors
	}
	return 0
}

type Port_PeerPort struct {
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	PortNo               uint32   `protobuf:"varint,2,opt,name=port_no,json=portNo,proto3" json:"port_no,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Port_PeerPort) Reset()         { *m = Port_PeerPort{} }
func (m *Port_PeerPort) String() string { return proto.CompactTextString(m) }
func (*Port_PeerPort) ProtoMessage()    {}
func (*Port_PeerPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{9, 0}
}

func (m *Port_PeerPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Port_PeerPort.Unmarshal(m, b)
}
func (m *Port_PeerPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Port_PeerPort.Marshal(b, m, deterministic)
}
func (m *Port_PeerPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port_PeerPort.Merge(m, src)
}
func (m *Port_PeerPort) XXX_Size() int {
	return xxx_messageInfo_Port_PeerPort.Size(m)
}
func (m *Port_PeerPort) XXX_DiscardUnknown() {
	xxx_messageInfo_Port_PeerPort.DiscardUnknown(m)
}

var xxx_messageInfo_Port_PeerPort proto.InternalMessageInfo

func (m *Port_PeerPort) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Port_PeerPort) GetPortNo() uint32 {
	if m != nil {
		return m.PortNo
	}
	return 0
}

type Ports struct {
	Items                []*Port  `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Ports) Reset()         { *m = Ports{} }
func (m *Ports) String() string { return proto.CompactTextString(m) }
func (*Ports) ProtoMessage()    {}
func (*Ports) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{10}
}

func (m *Ports) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Ports.Unmarshal(m, b)
}
func (m *Ports) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Ports.Marshal(b, m, deterministic)
}
func (m *Ports) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ports.Merge(m, src)
}
func (m *Ports) XXX_Size() int {
	return xxx_messageInfo_Ports.Size(m)
}
func (m *Ports) XXX_DiscardUnknown() {
	xxx_messageInfo_Ports.DiscardUnknown(m)
}

var xxx_messageInfo_Ports proto.InternalMessageInfo

func (m *Ports) GetItems() []*Port {
	if m != nil {
		return m.Items
	}
	return nil
}

// A Physical Device instance
type Device struct {
	// Voltha's device identifier
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Device type, refers to one of the registered device types
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Is this device a root device. Each logical switch has one root
	// device that is associated with the logical flow switch.
	Root bool `protobuf:"varint,3,opt,name=root,proto3" json:"root,omitempty"`
	// Parent device id, in the device tree (for a root device, the parent_id
	// is the logical_device.id)
	ParentId     string `protobuf:"bytes,4,opt,name=parent_id,json=parentId,proto3" json:"parent_id,omitempty"`
	ParentPortNo uint32 `protobuf:"varint,20,opt,name=parent_port_no,json=parentPortNo,proto3" json:"parent_port_no,omitempty"`
	// Vendor, version, serial number, etc.
	Vendor          string `protobuf:"bytes,5,opt,name=vendor,proto3" json:"vendor,omitempty"`
	Model           string `protobuf:"bytes,6,opt,name=model,proto3" json:"model,omitempty"`
	HardwareVersion string `protobuf:"bytes,7,opt,name=hardware_version,json=hardwareVersion,proto3" json:"hardware_version,omitempty"`
	FirmwareVersion string `protobuf:"bytes,8,opt,name=firmware_version,json=firmwareVersion,proto3" json:"firmware_version,omitempty"`
	// List of software on the device
	Images       *Images `protobuf:"bytes,9,opt,name=images,proto3" json:"images,omitempty"`
	SerialNumber string  `protobuf:"bytes,10,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	VendorId     string  `protobuf:"bytes,24,opt,name=vendor_id,json=vendorId,proto3" json:"vendor_id,omitempty"`
	// Addapter that takes care of device
	Adapter string `protobuf:"bytes,11,opt,name=adapter,proto3" json:"adapter,omitempty"`
	// Device contact on vlan (if 0, no vlan)
	Vlan uint32 `protobuf:"varint,12,opt,name=vlan,proto3" json:"vlan,omitempty"`
	// Device contact MAC address (format: "xx:xx:xx:xx:xx:xx")
	MacAddress string `protobuf:"bytes,13,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// Types that are valid to be assigned to Address:
	//	*Device_Ipv4Address
	//	*Device_Ipv6Address
	//	*Device_HostAndPort
	Address       isDevice_Address                   `protobuf_oneof:"address"`
	ExtraArgs     string                             `protobuf:"bytes,23,opt,name=extra_args,json=extraArgs,proto3" json:"extra_args,omitempty"`
	ProxyAddress  *Device_ProxyAddress               `protobuf:"bytes,19,opt,name=proxy_address,json=proxyAddress,proto3" json:"proxy_address,omitempty"`
	AdminState    common.AdminState_AdminState       `protobuf:"varint,16,opt,name=admin_state,json=adminState,proto3,enum=common.AdminState_AdminState" json:"admin_state,omitempty"`
	OperStatus    common.OperStatus_OperStatus       `protobuf:"varint,17,opt,name=oper_status,json=operStatus,proto3,enum=common.OperStatus_OperStatus" json:"oper_status,omitempty"`
	Reason        string                             `protobuf:"bytes,22,opt,name=reason,proto3" json:"reason,omitempty"`
	ConnectStatus common.ConnectStatus_ConnectStatus `protobuf:"varint,18,opt,name=connect_status,json=connectStatus,proto3,enum=common.ConnectStatus_ConnectStatus" json:"connect_status,omitempty"`
	// Device type specific attributes
	Custom     *any.Any                `protobuf:"bytes,64,opt,name=custom,proto3" json:"custom,omitempty"`
	Ports      []*Port                 `protobuf:"bytes,128,rep,name=ports,proto3" json:"ports,omitempty"`
	Flows      *openflow_13.Flows      `protobuf:"bytes,129,opt,name=flows,proto3" json:"flows,omitempty"`
	FlowGroups *openflow_13.FlowGroups `protobuf:"bytes,130,opt,name=flow_groups,json=flowGroups,proto3" json:"flow_groups,omitempty"`
	// PmConfigs will eventually converted to a child node of the
	// device to falicitata callbacks and to simplify manipulation.
	PmConfigs            *PmConfigs       `protobuf:"bytes,131,opt,name=pm_configs,json=pmConfigs,proto3" json:"pm_configs,omitempty"`
	ImageDownloads       []*ImageDownload `protobuf:"bytes,133,rep,name=image_downloads,json=imageDownloads,proto3" json:"image_downloads,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Device) Reset()         { *m = Device{} }
func (m *Device) String() string { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()    {}
func (*Device) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{11}
}

func (m *Device) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device.Unmarshal(m, b)
}
func (m *Device) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device.Marshal(b, m, deterministic)
}
func (m *Device) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device.Merge(m, src)
}
func (m *Device) XXX_Size() int {
	return xxx_messageInfo_Device.Size(m)
}
func (m *Device) XXX_DiscardUnknown() {
	xxx_messageInfo_Device.DiscardUnknown(m)
}

var xxx_messageInfo_Device proto.InternalMessageInfo

func (m *Device) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Device) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Device) GetRoot() bool {
	if m != nil {
		return m.Root
	}
	return false
}

func (m *Device) GetParentId() string {
	if m != nil {
		return m.ParentId
	}
	return ""
}

func (m *Device) GetParentPortNo() uint32 {
	if m != nil {
		return m.ParentPortNo
	}
	return 0
}

func (m *Device) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *Device) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *Device) GetHardwareVersion() string {
	if m != nil {
		return m.HardwareVersion
	}
	return ""
}

func (m *Device) GetFirmwareVersion() string {
	if m != nil {
		return m.FirmwareVersion
	}
	return ""
}

func (m *Device) GetImages() *Images {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Device) GetSerialNumber() string {
	if m != nil {
		return m.SerialNumber
	}
	return ""
}

func (m *Device) GetVendorId() string {
	if m != nil {
		return m.VendorId
	}
	return ""
}

func (m *Device) GetAdapter() string {
	if m != nil {
		return m.Adapter
	}
	return ""
}

func (m *Device) GetVlan() uint32 {
	if m != nil {
		return m.Vlan
	}
	return 0
}

func (m *Device) GetMacAddress() string {
	if m != nil {
		return m.MacAddress
	}
	return ""
}

type isDevice_Address interface {
	isDevice_Address()
}

type Device_Ipv4Address struct {
	Ipv4Address string `protobuf:"bytes,14,opt,name=ipv4_address,json=ipv4Address,proto3,oneof"`
}

type Device_Ipv6Address struct {
	Ipv6Address string `protobuf:"bytes,15,opt,name=ipv6_address,json=ipv6Address,proto3,oneof"`
}

type Device_HostAndPort struct {
	HostAndPort string `protobuf:"bytes,21,opt,name=host_and_port,json=hostAndPort,proto3,oneof"`
}

func (*Device_Ipv4Address) isDevice_Address() {}

func (*Device_Ipv6Address) isDevice_Address() {}

func (*Device_HostAndPort) isDevice_Address() {}

func (m *Device) GetAddress() isDevice_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Device) GetIpv4Address() string {
	if x, ok := m.GetAddress().(*Device_Ipv4Address); ok {
		return x.Ipv4Address
	}
	return ""
}

func (m *Device) GetIpv6Address() string {
	if x, ok := m.GetAddress().(*Device_Ipv6Address); ok {
		return x.Ipv6Address
	}
	return ""
}

func (m *Device) GetHostAndPort() string {
	if x, ok := m.GetAddress().(*Device_HostAndPort); ok {
		return x.HostAndPort
	}
	return ""
}

func (m *Device) GetExtraArgs() string {
	if m != nil {
		return m.ExtraArgs
	}
	return ""
}

func (m *Device) GetProxyAddress() *Device_ProxyAddress {
	if m != nil {
		return m.ProxyAddress
	}
	return nil
}

func (m *Device) GetAdminState() common.AdminState_AdminState {
	if m != nil {
		return m.AdminState
	}
	return common.AdminState_UNKNOWN
}

func (m *Device) GetOperStatus() common.OperStatus_OperStatus {
	if m != nil {
		return m.OperStatus
	}
	return common.OperStatus_UNKNOWN
}

func (m *Device) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *Device) GetConnectStatus() common.ConnectStatus_ConnectStatus {
	if m != nil {
		return m.ConnectStatus
	}
	return common.ConnectStatus_UNKNOWN
}

func (m *Device) GetCustom() *any.Any {
	if m != nil {
		return m.Custom
	}
	return nil
}

func (m *Device) GetPorts() []*Port {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *Device) GetFlows() *openflow_13.Flows {
	if m != nil {
		return m.Flows
	}
	return nil
}

func (m *Device) GetFlowGroups() *openflow_13.FlowGroups {
	if m != nil {
		return m.FlowGroups
	}
	return nil
}

func (m *Device) GetPmConfigs() *PmConfigs {
	if m != nil {
		return m.PmConfigs
	}
	return nil
}

func (m *Device) GetImageDownloads() []*ImageDownload {
	if m != nil {
		return m.ImageDownloads
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Device) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Device_Ipv4Address)(nil),
		(*Device_Ipv6Address)(nil),
		(*Device_HostAndPort)(nil),
	}
}

type Device_ProxyAddress struct {
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	DeviceType           string   `protobuf:"bytes,2,opt,name=device_type,json=deviceType,proto3" json:"device_type,omitempty"`
	ChannelId            uint32   `protobuf:"varint,3,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	ChannelGroupId       uint32   `protobuf:"varint,4,opt,name=channel_group_id,json=channelGroupId,proto3" json:"channel_group_id,omitempty"`
	ChannelTermination   string   `protobuf:"bytes,5,opt,name=channel_termination,json=channelTermination,proto3" json:"channel_termination,omitempty"`
	OnuId                uint32   `protobuf:"varint,6,opt,name=onu_id,json=onuId,proto3" json:"onu_id,omitempty"`
	OnuSessionId         uint32   `protobuf:"varint,7,opt,name=onu_session_id,json=onuSessionId,proto3" json:"onu_session_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Device_ProxyAddress) Reset()         { *m = Device_ProxyAddress{} }
func (m *Device_ProxyAddress) String() string { return proto.CompactTextString(m) }
func (*Device_ProxyAddress) ProtoMessage()    {}
func (*Device_ProxyAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{11, 0}
}

func (m *Device_ProxyAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device_ProxyAddress.Unmarshal(m, b)
}
func (m *Device_ProxyAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device_ProxyAddress.Marshal(b, m, deterministic)
}
func (m *Device_ProxyAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device_ProxyAddress.Merge(m, src)
}
func (m *Device_ProxyAddress) XXX_Size() int {
	return xxx_messageInfo_Device_ProxyAddress.Size(m)
}
func (m *Device_ProxyAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_Device_ProxyAddress.DiscardUnknown(m)
}

var xxx_messageInfo_Device_ProxyAddress proto.InternalMessageInfo

func (m *Device_ProxyAddress) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *Device_ProxyAddress) GetDeviceType() string {
	if m != nil {
		return m.DeviceType
	}
	return ""
}

func (m *Device_ProxyAddress) GetChannelId() uint32 {
	if m != nil {
		return m.ChannelId
	}
	return 0
}

func (m *Device_ProxyAddress) GetChannelGroupId() uint32 {
	if m != nil {
		return m.ChannelGroupId
	}
	return 0
}

func (m *Device_ProxyAddress) GetChannelTermination() string {
	if m != nil {
		return m.ChannelTermination
	}
	return ""
}

func (m *Device_ProxyAddress) GetOnuId() uint32 {
	if m != nil {
		return m.OnuId
	}
	return 0
}

func (m *Device_ProxyAddress) GetOnuSessionId() uint32 {
	if m != nil {
		return m.OnuSessionId
	}
	return 0
}

type Devices struct {
	Items                []*Device `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Devices) Reset()         { *m = Devices{} }
func (m *Devices) String() string { return proto.CompactTextString(m) }
func (*Devices) ProtoMessage()    {}
func (*Devices) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{12}
}

func (m *Devices) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Devices.Unmarshal(m, b)
}
func (m *Devices) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Devices.Marshal(b, m, deterministic)
}
func (m *Devices) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Devices.Merge(m, src)
}
func (m *Devices) XXX_Size() int {
	return xxx_messageInfo_Devices.Size(m)
}
func (m *Devices) XXX_DiscardUnknown() {
	xxx_messageInfo_Devices.DiscardUnknown(m)
}

var xxx_messageInfo_Devices proto.InternalMessageInfo

func (m *Devices) GetItems() []*Device {
	if m != nil {
		return m.Items
	}
	return nil
}

type SimulateAlarmRequest struct {
	// Device Identifier
	Id                   string                             `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Indicator            string                             `protobuf:"bytes,2,opt,name=indicator,proto3" json:"indicator,omitempty"`
	IntfId               string                             `protobuf:"bytes,3,opt,name=intf_id,json=intfId,proto3" json:"intf_id,omitempty"`
	PortTypeName         string                             `protobuf:"bytes,4,opt,name=port_type_name,json=portTypeName,proto3" json:"port_type_name,omitempty"`
	OnuDeviceId          string                             `protobuf:"bytes,5,opt,name=onu_device_id,json=onuDeviceId,proto3" json:"onu_device_id,omitempty"`
	InverseBitErrorRate  int32                              `protobuf:"varint,6,opt,name=inverse_bit_error_rate,json=inverseBitErrorRate,proto3" json:"inverse_bit_error_rate,omitempty"`
	Drift                int32                              `protobuf:"varint,7,opt,name=drift,proto3" json:"drift,omitempty"`
	NewEqd               int32                              `protobuf:"varint,8,opt,name=new_eqd,json=newEqd,proto3" json:"new_eqd,omitempty"`
	OnuSerialNumber      string                             `protobuf:"bytes,9,opt,name=onu_serial_number,json=onuSerialNumber,proto3" json:"onu_serial_number,omitempty"`
	Operation            SimulateAlarmRequest_OperationType `protobuf:"varint,10,opt,name=operation,proto3,enum=voltha.SimulateAlarmRequest_OperationType" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *SimulateAlarmRequest) Reset()         { *m = SimulateAlarmRequest{} }
func (m *SimulateAlarmRequest) String() string { return proto.CompactTextString(m) }
func (*SimulateAlarmRequest) ProtoMessage()    {}
func (*SimulateAlarmRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_200940f73d155856, []int{13}
}

func (m *SimulateAlarmRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimulateAlarmRequest.Unmarshal(m, b)
}
func (m *SimulateAlarmRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimulateAlarmRequest.Marshal(b, m, deterministic)
}
func (m *SimulateAlarmRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimulateAlarmRequest.Merge(m, src)
}
func (m *SimulateAlarmRequest) XXX_Size() int {
	return xxx_messageInfo_SimulateAlarmRequest.Size(m)
}
func (m *SimulateAlarmRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SimulateAlarmRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SimulateAlarmRequest proto.InternalMessageInfo

func (m *SimulateAlarmRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SimulateAlarmRequest) GetIndicator() string {
	if m != nil {
		return m.Indicator
	}
	return ""
}

func (m *SimulateAlarmRequest) GetIntfId() string {
	if m != nil {
		return m.IntfId
	}
	return ""
}

func (m *SimulateAlarmRequest) GetPortTypeName() string {
	if m != nil {
		return m.PortTypeName
	}
	return ""
}

func (m *SimulateAlarmRequest) GetOnuDeviceId() string {
	if m != nil {
		return m.OnuDeviceId
	}
	return ""
}

func (m *SimulateAlarmRequest) GetInverseBitErrorRate() int32 {
	if m != nil {
		return m.InverseBitErrorRate
	}
	return 0
}

func (m *SimulateAlarmRequest) GetDrift() int32 {
	if m != nil {
		return m.Drift
	}
	return 0
}

func (m *SimulateAlarmRequest) GetNewEqd() int32 {
	if m != nil {
		return m.NewEqd
	}
	return 0
}

func (m *SimulateAlarmRequest) GetOnuSerialNumber() string {
	if m != nil {
		return m.OnuSerialNumber
	}
	return ""
}

func (m *SimulateAlarmRequest) GetOperation() SimulateAlarmRequest_OperationType {
	if m != nil {
		return m.Operation
	}
	return SimulateAlarmRequest_RAISE
}

func init() {
	proto.RegisterEnum("voltha.PmConfig_PmType", PmConfig_PmType_name, PmConfig_PmType_value)
	proto.RegisterEnum("voltha.ImageDownload_ImageDownloadState", ImageDownload_ImageDownloadState_name, ImageDownload_ImageDownloadState_value)
	proto.RegisterEnum("voltha.ImageDownload_ImageDownloadFailureReason", ImageDownload_ImageDownloadFailureReason_name, ImageDownload_ImageDownloadFailureReason_value)
	proto.RegisterEnum("voltha.ImageDownload_ImageActivateState", ImageDownload_ImageActivateState_name, ImageDownload_ImageActivateState_value)
	proto.RegisterEnum("voltha.Port_PortType", Port_PortType_name, Port_PortType_value)
	proto.RegisterEnum("voltha.SimulateAlarmRequest_OperationType", SimulateAlarmRequest_OperationType_name, SimulateAlarmRequest_OperationType_value)
	proto.RegisterType((*DeviceType)(nil), "voltha.DeviceType")
	proto.RegisterType((*DeviceTypes)(nil), "voltha.DeviceTypes")
	proto.RegisterType((*PmConfig)(nil), "voltha.PmConfig")
	proto.RegisterType((*PmGroupConfig)(nil), "voltha.PmGroupConfig")
	proto.RegisterType((*PmConfigs)(nil), "voltha.PmConfigs")
	proto.RegisterType((*Image)(nil), "voltha.Image")
	proto.RegisterType((*Images)(nil), "voltha.Images")
	proto.RegisterType((*ImageDownload)(nil), "voltha.ImageDownload")
	proto.RegisterType((*ImageDownloads)(nil), "voltha.ImageDownloads")
	proto.RegisterType((*Port)(nil), "voltha.Port")
	proto.RegisterType((*Port_PeerPort)(nil), "voltha.Port.PeerPort")
	proto.RegisterType((*Ports)(nil), "voltha.Ports")
	proto.RegisterType((*Device)(nil), "voltha.Device")
	proto.RegisterType((*Device_ProxyAddress)(nil), "voltha.Device.ProxyAddress")
	proto.RegisterType((*Devices)(nil), "voltha.Devices")
	proto.RegisterType((*SimulateAlarmRequest)(nil), "voltha.SimulateAlarmRequest")
}

func init() { proto.RegisterFile("voltha_protos/device.proto", fileDescriptor_200940f73d155856) }

var fileDescriptor_200940f73d155856 = []byte{
	// 2382 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x58, 0x4d, 0x73, 0x1b, 0x49,
	0xf9, 0x8f, 0x64, 0xcf, 0x48, 0xf3, 0xe8, 0xc5, 0x93, 0x8e, 0xb3, 0x99, 0xd8, 0x7f, 0x97, 0xf3,
	0x57, 0x96, 0xc2, 0x9b, 0x25, 0x76, 0x48, 0xa8, 0xdd, 0x2d, 0xaa, 0xa0, 0x22, 0x4b, 0xe3, 0x44,
	0x85, 0x91, 0xbc, 0x2d, 0xc9, 0x0b, 0x5c, 0xa6, 0xc6, 0x9a, 0x96, 0x3d, 0xb5, 0xf3, 0xa2, 0x74,
	0x8f, 0x64, 0x7b, 0x4f, 0xc0, 0x16, 0x9c, 0xb8, 0x51, 0xc5, 0x67, 0xe0, 0x1b, 0x70, 0x84, 0x2f,
	0x90, 0xe2, 0x0b, 0x70, 0xe2, 0x40, 0x51, 0x9c, 0x38, 0xe5, 0x4c, 0xf5, 0x9b, 0x34, 0xe3, 0x84,
	0xec, 0x72, 0x99, 0xea, 0xfe, 0x3d, 0x2f, 0xdd, 0xfd, 0xeb, 0xee, 0xe7, 0x79, 0x7a, 0x60, 0x6b,
	0x91, 0x46, 0xd9, 0x85, 0xef, 0xcd, 0x68, 0x9a, 0xa5, 0xec, 0x20, 0x20, 0x8b, 0x70, 0x42, 0xf6,
	0x45, 0x0f, 0x99, 0x52, 0xb6, 0x75, 0xff, 0x3c, 0x4d, 0xcf, 0x23, 0x72, 0x20, 0xd0, 0xb3, 0xf9,
	0xf4, 0xc0, 0x4f, 0xae, 0xa5, 0xca, 0xd6, 0x0d, 0xf3, 0x49, 0x1a, 0xc7, 0x69, 0xa2, 0x64, 0x4e,
	0x51, 0x16, 0x93, 0xcc, 0x57, 0x92, 0xdd, 0xa2, 0x24, 0x9d, 0x91, 0x64, 0x1a, 0xa5, 0x97, 0xde,
	0xf7, 0x9f, 0x29, 0x85, 0x07, 0x45, 0x85, 0x6b, 0x3f, 0x39, 0xf7, 0xd2, 0x59, 0x16, 0xa6, 0x09,
	0x93, 0x1a, 0xad, 0x3f, 0x97, 0x01, 0xba, 0x62, 0xb2, 0xa3, 0xeb, 0x19, 0x41, 0x4d, 0x28, 0x87,
	0x81, 0x53, 0x7a, 0x50, 0xda, 0xb3, 0x70, 0x39, 0x0c, 0xd0, 0x36, 0x58, 0x0b, 0x92, 0x04, 0x29,
	0xf5, 0xc2, 0xc0, 0x31, 0x04, 0x5c, 0x95, 0x40, 0x2f, 0x40, 0x3b, 0x00, 0x4b, 0x21, 0x73, 0xcc,
	0x07, 0x6b, 0x7b, 0x16, 0xb6, 0xb4, 0x94, 0x21, 0x07, 0x2a, 0x7e, 0xe0, 0xcf, 0x32, 0x42, 0x9d,
	0xb2, 0xb0, 0xd4, 0x5d, 0xf4, 0x29, 0x38, 0xfe, 0x64, 0x42, 0x66, 0x19, 0xf3, 0xce, 0xe6, 0xd1,
	0x97, 0x9e, 0x98, 0xf4, 0x7c, 0x16, 0xf8, 0x19, 0x71, 0xd6, 0x1e, 0x94, 0xf6, 0xaa, 0xf8, 0xae,
	0x92, 0x1f, 0xce, 0xa3, 0x2f, 0x8f, 0xa2, 0xf4, 0x72, 0x2c, 0x84, 0xa8, 0x0b, 0xbb, 0xda, 0xd0,
	0x0f, 0x02, 0x8f, 0x92, 0x38, 0x5d, 0x90, 0xbc, 0x39, 0x73, 0xd6, 0x85, 0xfd, 0xb6, 0x52, 0x6b,
	0x07, 0x01, 0x16, 0x4a, 0x2b, 0x27, 0x0c, 0x1d, 0xc3, 0x43, 0xed, 0x25, 0x08, 0x29, 0x99, 0x64,
	0x5e, 0x94, 0x9e, 0x87, 0x13, 0x3f, 0x12, 0x9e, 0x98, 0x9e, 0x49, 0x45, 0x78, 0xd2, 0x03, 0x76,
	0x85, 0xe6, 0xb1, 0x54, 0xe4, 0xde, 0x98, 0x74, 0xd7, 0xfa, 0x14, 0x6a, 0x2b, 0x02, 0x19, 0xda,
	0x03, 0x23, 0xcc, 0x48, 0xcc, 0x9c, 0xd2, 0x83, 0xb5, 0xbd, 0xda, 0x53, 0xb4, 0x2f, 0xb7, 0x60,
	0x7f, 0xa5, 0x83, 0xa5, 0x42, 0xeb, 0x2f, 0x25, 0xa8, 0x9e, 0xc4, 0x9d, 0x34, 0x99, 0x86, 0xe7,
	0x08, 0xc1, 0x7a, 0xe2, 0xc7, 0x44, 0x51, 0x2f, 0xda, 0xe8, 0x63, 0x58, 0xcf, 0xae, 0x67, 0x44,
	0xb0, 0xd7, 0x7c, 0x7a, 0x4f, 0x7b, 0xd2, 0x36, 0xfb, 0x27, 0xb1, 0x70, 0x27, 0x94, 0x38, 0xdb,
	0x24, 0xf1, 0xcf, 0x22, 0x12, 0x28, 0x0a, 0x75, 0x17, 0xed, 0x42, 0x8d, 0xf9, 0xf1, 0x2c, 0x22,
	0xde, 0x94, 0x92, 0x57, 0x82, 0xa0, 0x06, 0x06, 0x09, 0x1d, 0x51, 0xf2, 0xaa, 0xf5, 0x19, 0x98,
	0xd2, 0x15, 0xaa, 0x41, 0xa5, 0x33, 0x18, 0xf7, 0x47, 0x2e, 0xb6, 0x6f, 0x21, 0x0b, 0x8c, 0x17,
	0xed, 0xf1, 0x0b, 0xd7, 0x2e, 0xf1, 0xe6, 0x70, 0xd4, 0x1e, 0xb9, 0x76, 0x59, 0xaa, 0xf4, 0x47,
	0xee, 0xcf, 0x46, 0xf6, 0x5a, 0xeb, 0xf7, 0x25, 0x68, 0x9c, 0xc4, 0x2f, 0x68, 0x3a, 0x9f, 0xa9,
	0x75, 0xec, 0x00, 0x9c, 0xf3, 0xae, 0x97, 0x5b, 0x8d, 0x25, 0x90, 0x3e, 0x5f, 0xd2, 0x52, 0x2c,
	0xa6, 0x52, 0x16, 0x53, 0x91, 0x62, 0x3e, 0x93, 0xf7, 0x2c, 0xe2, 0x11, 0x54, 0x62, 0x92, 0xd1,
	0x70, 0xc2, 0x77, 0x98, 0x13, 0x6b, 0xdf, 0xa4, 0x03, 0x6b, 0x85, 0xd6, 0x3f, 0x4a, 0x60, 0x69,
	0x94, 0xbd, 0x75, 0xa4, 0xff, 0x1f, 0xea, 0x01, 0x99, 0xfa, 0xf3, 0x28, 0xcb, 0x4f, 0xa2, 0xa6,
	0x30, 0x31, 0x8d, 0x5d, 0xa8, 0x88, 0x39, 0xe9, 0x69, 0x1c, 0x1a, 0xff, 0x7c, 0xf3, 0x7a, 0xa7,
	0x84, 0x35, 0x8a, 0x1e, 0x41, 0x83, 0xdb, 0x7a, 0xe9, 0x82, 0x50, 0x1a, 0x06, 0x44, 0x9e, 0x3a,
	0xad, 0x56, 0xe7, 0xb2, 0x81, 0x12, 0xa1, 0xc7, 0x60, 0x0a, 0x33, 0xe6, 0x18, 0x62, 0xe2, 0x77,
	0x57, 0x13, 0xcf, 0x11, 0x87, 0x95, 0x52, 0x7e, 0xa1, 0xe6, 0x37, 0x2d, 0xf4, 0xaf, 0x25, 0x30,
	0x7a, 0xb1, 0x7f, 0x4e, 0xde, 0x79, 0x7c, 0x1c, 0xa8, 0x2c, 0x08, 0x65, 0x61, 0x9a, 0xe8, 0xfb,
	0xa7, 0xba, 0x5c, 0xfb, 0xc2, 0x67, 0x17, 0x62, 0x71, 0x16, 0x16, 0x6d, 0xf4, 0x11, 0xd8, 0x61,
	0xc2, 0x32, 0x3f, 0x8a, 0x3c, 0x7e, 0xac, 0xb3, 0x30, 0x96, 0xab, 0xb2, 0xf0, 0x86, 0xc2, 0xbb,
	0x0a, 0xe6, 0x41, 0x21, 0x64, 0x9e, 0x3f, 0xc9, 0xc2, 0x05, 0x11, 0x41, 0xa1, 0x8a, 0xab, 0x21,
	0x6b, 0x8b, 0x3e, 0xa7, 0x37, 0x64, 0x1e, 0x0f, 0x60, 0x61, 0x96, 0x91, 0xc0, 0x31, 0x85, 0xbc,
	0x16, 0xb2, 0x8e, 0x86, 0xd0, 0x7d, 0xa8, 0x86, 0xcc, 0x5b, 0xf8, 0x51, 0x18, 0xa8, 0x4b, 0x56,
	0x09, 0xd9, 0x29, 0xef, 0xb6, 0x1e, 0x83, 0x29, 0x16, 0xc4, 0xd0, 0x43, 0x30, 0x42, 0xde, 0x52,
	0xf7, 0xa8, 0xa1, 0x59, 0x10, 0x62, 0x2c, 0x65, 0xad, 0x7f, 0x55, 0xa0, 0x21, 0x80, 0x6e, 0x7a,
	0x99, 0x44, 0xa9, 0x1f, 0xbc, 0xb5, 0xdb, 0x9a, 0x98, 0x72, 0x8e, 0x18, 0x1b, 0xd6, 0xe6, 0x34,
	0x52, 0xab, 0xe7, 0x4d, 0x8e, 0x4c, 0xe8, 0x44, 0x5d, 0x0d, 0xde, 0x44, 0x03, 0x68, 0x06, 0xca,
	0xa7, 0xc7, 0x32, 0x1e, 0x0e, 0x0c, 0x71, 0x0b, 0xf7, 0x0a, 0xf3, 0xd0, 0xc3, 0x16, 0x7b, 0x43,
	0xae, 0x8f, 0x1b, 0x41, 0xbe, 0x8b, 0x1e, 0x42, 0x43, 0xcc, 0xd9, 0xd3, 0x7b, 0x62, 0x8a, 0xe1,
	0xeb, 0x02, 0x3c, 0x55, 0x1b, 0xf3, 0x11, 0xd8, 0xda, 0x8a, 0x04, 0xde, 0xd9, 0x35, 0x0f, 0x68,
	0x15, 0x31, 0xa9, 0x8d, 0x15, 0x7e, 0xc8, 0x61, 0xf4, 0x12, 0x4c, 0x4a, 0x7c, 0x96, 0x26, 0x4e,
	0x55, 0x4c, 0xec, 0xc9, 0xb7, 0x98, 0xd8, 0x91, 0x1f, 0x46, 0x73, 0x4a, 0xb0, 0xb0, 0xc3, 0xca,
	0x1e, 0x7d, 0x17, 0x36, 0xfc, 0x20, 0x08, 0x79, 0x56, 0xf0, 0x23, 0x2f, 0x4c, 0xa6, 0xa9, 0x63,
	0x89, 0xb9, 0x35, 0x57, 0x70, 0x2f, 0x99, 0xa6, 0x32, 0x90, 0x2c, 0x88, 0x37, 0x11, 0xc7, 0xd0,
	0x01, 0xb1, 0x75, 0xc0, 0x21, 0x75, 0xf9, 0xb7, 0xc1, 0x8a, 0x52, 0x1e, 0x47, 0x83, 0x90, 0x3a,
	0x35, 0x99, 0x2d, 0x04, 0xd0, 0x0d, 0x29, 0xea, 0x41, 0x4d, 0x12, 0x20, 0xe9, 0xac, 0x7f, 0x23,
	0x9d, 0xe2, 0x40, 0xf9, 0x19, 0x91, 0x74, 0x82, 0x30, 0x96, 0x5c, 0x6e, 0x83, 0x35, 0x0d, 0x23,
	0xe2, 0xb1, 0xf0, 0x2b, 0xe2, 0x34, 0x04, 0x3f, 0x55, 0x0e, 0x0c, 0xc3, 0xaf, 0x48, 0xeb, 0x4f,
	0x25, 0x40, 0x6f, 0x6f, 0x07, 0xda, 0x04, 0xbb, 0x3b, 0xf8, 0xa2, 0x7f, 0x3c, 0x68, 0x77, 0xbd,
	0x71, 0xff, 0x27, 0xfd, 0xc1, 0x17, 0x7d, 0xfb, 0x16, 0xfa, 0x00, 0xd0, 0x12, 0x1d, 0x8e, 0x3b,
	0x1d, 0xd7, 0xed, 0xba, 0x5d, 0xbb, 0x54, 0xc0, 0xb1, 0xfb, 0xf9, 0xd8, 0x1d, 0x8e, 0xdc, 0xae,
	0x5d, 0x2e, 0x78, 0x19, 0x8e, 0xda, 0x98, 0xa3, 0x6b, 0xe8, 0x0e, 0x6c, 0x2c, 0xd1, 0xa3, 0x76,
	0xef, 0xd8, 0xed, 0xda, 0xeb, 0xc8, 0x81, 0xcd, 0xdc, 0x80, 0xc3, 0xf1, 0xc9, 0xc9, 0x40, 0xa8,
	0x1b, 0x05, 0xe7, 0x9d, 0x76, 0xbf, 0xe3, 0x1e, 0x73, 0x0b, 0xb3, 0xf5, 0xdb, 0x12, 0x6c, 0xfd,
	0xf7, 0xfd, 0x42, 0x75, 0xa8, 0xf6, 0x07, 0x9e, 0x8b, 0xf1, 0x80, 0x47, 0xe7, 0x0d, 0xa8, 0xf5,
	0xfa, 0xa7, 0xed, 0xe3, 0x5e, 0xd7, 0x1b, 0xe3, 0x63, 0xbb, 0xc4, 0x81, 0xae, 0x7b, 0xda, 0xeb,
	0xb8, 0xde, 0xe1, 0x78, 0xf8, 0x73, 0xbb, 0xcc, 0x87, 0xe9, 0xf5, 0x87, 0xe3, 0xa3, 0xa3, 0x5e,
	0xa7, 0xe7, 0xf6, 0x47, 0xde, 0xf0, 0xa4, 0xdd, 0x71, 0xed, 0x35, 0x74, 0x1b, 0x1a, 0x8a, 0x00,
	0xe5, 0x6c, 0x1d, 0x35, 0xc0, 0x5a, 0x4d, 0xc4, 0x68, 0xfd, 0x4e, 0x53, 0x58, 0xd8, 0x02, 0x6e,
	0xd8, 0xfb, 0x69, 0xfb, 0x85, 0x9b, 0xe3, 0x0f, 0x41, 0x53, 0x42, 0xbd, 0x7e, 0xbb, 0x33, 0xea,
	0x9d, 0xf2, 0x64, 0xb1, 0x09, 0xb6, 0xc4, 0x04, 0xd2, 0x1e, 0xf5, 0xfa, 0x2f, 0xec, 0x32, 0xb2,
	0xa1, 0x9e, 0x43, 0x5d, 0xc9, 0x9a, 0x44, 0xb0, 0x7b, 0xea, 0x62, 0xa1, 0xb6, 0xbe, 0x72, 0x28,
	0x41, 0x3e, 0x9d, 0x1f, 0x1a, 0xff, 0x7e, 0xf3, 0x7a, 0xe7, 0x56, 0xeb, 0x47, 0xd0, 0x2c, 0xb0,
	0xc3, 0xd0, 0xc7, 0x3a, 0xd7, 0x96, 0x8b, 0x91, 0xb5, 0xa0, 0xa6, 0xd3, 0xed, 0x1f, 0x0c, 0x58,
	0x3f, 0x49, 0x69, 0x86, 0xee, 0x41, 0x65, 0x96, 0xd2, 0xcc, 0x4b, 0x52, 0x11, 0x27, 0x1a, 0xd8,
	0xe4, 0xdd, 0x7e, 0x8a, 0x36, 0xc1, 0x88, 0xfc, 0x33, 0x12, 0xa9, 0x60, 0x21, 0x3b, 0xe8, 0x23,
	0x95, 0x85, 0xd7, 0xc4, 0x81, 0x5d, 0x45, 0xef, 0x94, 0x66, 0xe2, 0x93, 0xcb, 0xc1, 0x3f, 0x86,
	0x9a, 0x1f, 0xc4, 0x61, 0x52, 0x88, 0x18, 0x3b, 0xfb, 0xaa, 0x9a, 0x6b, 0x73, 0x91, 0x60, 0x32,
	0xd7, 0xc4, 0xe0, 0x2f, 0xdb, 0xdc, 0x3e, 0x9d, 0x11, 0x2a, 0xcc, 0xe7, 0x4c, 0x44, 0x88, 0x9c,
	0xfd, 0x60, 0x46, 0xe8, 0x50, 0x48, 0x72, 0x4d, 0x0c, 0xe9, 0xb2, 0xcd, 0xef, 0x85, 0x2c, 0x3c,
	0x3d, 0x15, 0x59, 0x2d, 0x5c, 0x95, 0x40, 0x2f, 0xe0, 0x64, 0xcd, 0x08, 0xa1, 0xcc, 0xa9, 0xde,
	0x48, 0x43, 0x62, 0x21, 0x84, 0x50, 0xde, 0xc0, 0x52, 0x87, 0xe7, 0x69, 0x7a, 0xe5, 0xcd, 0xfc,
	0xc9, 0x97, 0x24, 0x63, 0x22, 0x1c, 0x98, 0xd8, 0xa2, 0x57, 0x27, 0x12, 0xe0, 0x11, 0x9c, 0x5e,
	0xa9, 0xf8, 0x04, 0x42, 0x58, 0xa1, 0x57, 0x32, 0x2e, 0x6d, 0x83, 0x45, 0xaf, 0x3c, 0x42, 0x69,
	0x4a, 0x99, 0x88, 0x01, 0x26, 0xae, 0xd2, 0x2b, 0x57, 0xf4, 0xb9, 0xdb, 0x6c, 0xe5, 0xb6, 0x2e,
	0xdd, 0x66, 0x79, 0xb7, 0x99, 0x76, 0xdb, 0x90, 0x6e, 0xb3, 0x95, 0xdb, 0x6c, 0xe9, 0xb6, 0x29,
	0xdd, 0x66, 0xca, 0xed, 0xd6, 0x73, 0xa8, 0xea, 0x05, 0x14, 0x39, 0x28, 0xdd, 0xe0, 0x20, 0xb7,
	0xf5, 0xe5, 0xfc, 0xd6, 0xb7, 0x18, 0x54, 0xf5, 0x5e, 0xf2, 0x0a, 0x67, 0x75, 0xc0, 0x6d, 0xa8,
	0xbb, 0xa3, 0x97, 0x2e, 0xee, 0xbb, 0x23, 0xaf, 0xdf, 0xef, 0xd9, 0xa5, 0x02, 0x32, 0xee, 0xf7,
	0x64, 0x49, 0x74, 0x32, 0xe8, 0x7b, 0x83, 0xe3, 0x91, 0xbd, 0xb6, 0xec, 0xf4, 0xc7, 0xf2, 0x5e,
	0x9d, 0xba, 0x5c, 0x91, 0xcb, 0x8c, 0x5c, 0xb7, 0x3f, 0xb6, 0x4d, 0x7d, 0xae, 0x3f, 0x06, 0x83,
	0x8f, 0xcd, 0x50, 0xab, 0x58, 0x3a, 0xd6, 0xf3, 0x3b, 0xa4, 0x4f, 0xf1, 0xdf, 0xea, 0x60, 0xca,
	0x52, 0x12, 0xdd, 0x5d, 0xa5, 0x3a, 0x5d, 0x79, 0xf0, 0x8c, 0x77, 0x3f, 0x57, 0x35, 0x2e, 0x05,
	0xf2, 0x7c, 0xde, 0x87, 0x75, 0x9a, 0xa6, 0x59, 0xb1, 0xa8, 0x11, 0x10, 0x6a, 0x81, 0x35, 0xf3,
	0x29, 0x49, 0x32, 0x4e, 0xdb, 0x7a, 0xde, 0xb4, 0x2a, 0x71, 0x71, 0x82, 0x9a, 0x4a, 0x47, 0x93,
	0xb8, 0xc9, 0x49, 0x5c, 0x96, 0x3d, 0x52, 0x78, 0x22, 0x2f, 0xd3, 0x0e, 0x98, 0xf2, 0x29, 0x20,
	0x9f, 0x0d, 0x5a, 0x49, 0x81, 0x68, 0x1b, 0x8c, 0x38, 0x0d, 0x48, 0x24, 0xd3, 0xa0, 0x96, 0x4a,
	0x0c, 0x3d, 0x01, 0xfb, 0xc2, 0xa7, 0xc1, 0xa5, 0x4f, 0x57, 0xe9, 0xb2, 0x92, 0xd7, 0xdb, 0xd0,
	0x62, 0x9d, 0x38, 0x9f, 0x80, 0x3d, 0x0d, 0x69, 0x5c, 0xb0, 0xa8, 0x16, 0x2c, 0xb4, 0x58, 0x5b,
	0x3c, 0x06, 0x53, 0x64, 0x14, 0x79, 0xba, 0x6b, 0x4f, 0x9b, 0x85, 0xe0, 0xc1, 0x96, 0xf3, 0x95,
	0x4a, 0xbc, 0xe2, 0x63, 0x84, 0x86, 0x7e, 0xe4, 0x25, 0xf3, 0xf8, 0x8c, 0x50, 0x71, 0xec, 0x97,
	0xde, 0xeb, 0x52, 0xd6, 0x17, 0x22, 0xce, 0xe5, 0xea, 0xd1, 0xe4, 0x14, 0xb8, 0x5c, 0xbe, 0x9d,
	0x76, 0x57, 0x8f, 0xa3, 0x5a, 0x5e, 0x63, 0xf9, 0x46, 0x42, 0xb0, 0xbe, 0x88, 0xfc, 0x44, 0x5c,
	0x92, 0x06, 0x16, 0x6d, 0x9e, 0x80, 0x63, 0x7f, 0xc2, 0x9f, 0x3e, 0x94, 0x30, 0x79, 0x45, 0x2c,
	0x0c, 0xb1, 0x3f, 0x69, 0x4b, 0x04, 0x3d, 0x84, 0x7a, 0x38, 0x5b, 0xfc, 0x60, 0xa9, 0xc1, 0x2f,
	0x8a, 0xf5, 0xf2, 0x16, 0xae, 0x71, 0xb4, 0xa8, 0xf4, 0xc9, 0x52, 0x69, 0x23, 0xa7, 0xf4, 0x89,
	0x56, 0xfa, 0x10, 0x1a, 0x17, 0x29, 0xcb, 0x3c, 0x3f, 0x09, 0xc4, 0x6e, 0x3b, 0x77, 0xb5, 0x16,
	0x87, 0xdb, 0x49, 0x20, 0x2e, 0xdb, 0x0e, 0x00, 0xb9, 0xca, 0xa8, 0xef, 0xf9, 0xf4, 0x9c, 0x39,
	0xf7, 0x64, 0xb5, 0x2f, 0x90, 0x36, 0x3d, 0x67, 0xe8, 0x39, 0x34, 0x66, 0x34, 0xbd, 0xba, 0x5e,
	0x0e, 0x75, 0x47, 0x50, 0xbd, 0x5d, 0x7c, 0x13, 0xed, 0x9f, 0x70, 0x1d, 0x35, 0x30, 0xae, 0xcf,
	0x72, 0xbd, 0x9b, 0x11, 0xd5, 0xfe, 0x5f, 0x23, 0xaa, 0x5b, 0x8c, 0xa8, 0xb7, 0xbf, 0x45, 0x44,
	0xd5, 0x3b, 0x91, 0x0f, 0xac, 0x3b, 0xcb, 0x62, 0xeb, 0x83, 0xc2, 0x61, 0x56, 0x15, 0xd4, 0xe7,
	0xd0, 0x9c, 0xa4, 0x49, 0xc2, 0x5f, 0x92, 0x6a, 0x20, 0x24, 0x06, 0x7a, 0xa8, 0x07, 0xea, 0x48,
	0xa9, 0x1a, 0xab, 0xd0, 0xd3, 0xbe, 0x1a, 0x93, 0x3c, 0x8a, 0xbe, 0x07, 0xe6, 0x64, 0xce, 0xb2,
	0x34, 0x76, 0x9e, 0x0b, 0xce, 0x36, 0xf7, 0xe5, 0xcf, 0x83, 0x7d, 0xfd, 0xf3, 0x60, 0xbf, 0x9d,
	0x5c, 0x63, 0xa5, 0x83, 0x9e, 0x81, 0xc1, 0x37, 0x89, 0x39, 0xbf, 0x7c, 0x47, 0xe8, 0x38, 0x6c,
	0xfe, 0xfd, 0xcd, 0xeb, 0x1d, 0x6b, 0x19, 0xfa, 0xb0, 0xd4, 0x45, 0x4f, 0xc0, 0x10, 0xef, 0x5d,
	0xe7, 0x57, 0x25, 0x31, 0x04, 0xda, 0xcf, 0xff, 0x40, 0x10, 0x4f, 0xdc, 0x43, 0x83, 0x9b, 0xde,
	0xc2, 0x52, 0x11, 0x3d, 0x87, 0x9a, 0x10, 0xab, 0xf7, 0xcc, 0xaf, 0xa5, 0xdd, 0xbd, 0xb7, 0xec,
	0xc4, 0xbb, 0x66, 0x69, 0x0c, 0xd3, 0x25, 0x84, 0x3e, 0x03, 0x98, 0xc5, 0xaa, 0x80, 0x64, 0xce,
	0xd7, 0xd2, 0xc1, 0xed, 0x9b, 0x2f, 0x9c, 0xa5, 0xa9, 0x35, 0x5b, 0x3e, 0xe3, 0x8e, 0x61, 0x43,
	0x96, 0x8f, 0xba, 0x10, 0x66, 0xce, 0x6f, 0x4a, 0xef, 0x49, 0xfb, 0x87, 0x35, 0xee, 0xc2, 0x94,
	0xe5, 0x3f, 0x6e, 0x86, 0x85, 0xca, 0x61, 0xeb, 0xeb, 0x32, 0xd4, 0xf3, 0xc7, 0xee, 0xfd, 0x69,
	0x63, 0x17, 0x6a, 0x4a, 0xb8, 0x8a, 0xac, 0x18, 0x82, 0xd5, 0x6f, 0x93, 0x1d, 0x80, 0xc9, 0x85,
	0x9f, 0x24, 0x24, 0xe2, 0xe6, 0x6b, 0xf2, 0x59, 0xab, 0x90, 0x5e, 0x80, 0xf6, 0xc0, 0xd6, 0x62,
	0xf9, 0xfa, 0x55, 0x31, 0xb6, 0x81, 0x9b, 0x0a, 0x17, 0xf4, 0xf4, 0x02, 0x74, 0x00, 0x77, 0xb4,
	0x66, 0x46, 0x68, 0x1c, 0x26, 0x3e, 0xaf, 0xbf, 0xd5, 0x9f, 0x17, 0xa4, 0x44, 0xa3, 0x95, 0x04,
	0xdd, 0x05, 0x33, 0x4d, 0xe6, 0xdc, 0xa1, 0x29, 0x1c, 0x1a, 0x69, 0x32, 0xef, 0x05, 0xe8, 0x43,
	0x68, 0x72, 0x98, 0x11, 0xc6, 0x83, 0x9d, 0x2e, 0x07, 0x1a, 0xb8, 0x9e, 0x26, 0xf3, 0xa1, 0x04,
	0x7b, 0x81, 0x4a, 0x40, 0x87, 0x16, 0x8f, 0x45, 0x82, 0x86, 0xd6, 0x01, 0x54, 0xe4, 0xa5, 0xe4,
	0x11, 0xa0, 0x90, 0x8d, 0x9a, 0xc5, 0x4b, 0xab, 0xf3, 0xd1, 0x1f, 0xd7, 0x60, 0x73, 0x18, 0xc6,
	0xf3, 0xc8, 0xcf, 0x48, 0x3b, 0xf2, 0x69, 0x8c, 0xc9, 0xab, 0x39, 0x61, 0xd9, 0x5b, 0x0f, 0xb1,
	0xff, 0x03, 0x2b, 0x4c, 0x82, 0x70, 0xe2, 0x67, 0xa9, 0xfe, 0x1f, 0xb4, 0x02, 0x78, 0x62, 0x0e,
	0x93, 0x6c, 0xaa, 0xd9, 0xb3, 0xb0, 0xc9, 0xbb, 0x72, 0x21, 0xe2, 0xd8, 0x72, 0xe2, 0xe5, 0x3f,
	0x05, 0xf9, 0x28, 0xad, 0xcf, 0x54, 0xba, 0x16, 0xbf, 0x15, 0x5a, 0xd0, 0xe0, 0xcb, 0x5d, 0xed,
	0xa0, 0x24, 0xac, 0x96, 0x26, 0xf3, 0xae, 0xde, 0xc4, 0x67, 0xf0, 0x41, 0x98, 0xf0, 0xdc, 0x40,
	0xbc, 0xb3, 0x30, 0x93, 0xa5, 0x84, 0x47, 0x79, 0x54, 0xe1, 0xcc, 0x19, 0xf8, 0x8e, 0x92, 0x1e,
	0x86, 0x99, 0x28, 0x2b, 0xb0, 0x7c, 0x35, 0x18, 0x01, 0x0d, 0xa7, 0x99, 0xa0, 0xcf, 0xc0, 0xb2,
	0xc3, 0x67, 0x9b, 0x90, 0x4b, 0x8f, 0xbc, 0x0a, 0x44, 0x92, 0x31, 0xb0, 0x99, 0x90, 0x4b, 0xf7,
	0x55, 0x80, 0x1e, 0xc1, 0x6d, 0x49, 0x7b, 0x3e, 0x53, 0xc8, 0xc7, 0xd4, 0x86, 0x60, 0x3e, 0x97,
	0x25, 0x5e, 0x82, 0xc5, 0x23, 0x8c, 0xdc, 0x60, 0x10, 0xf1, 0xe2, 0x91, 0xe6, 0xf8, 0x5d, 0x8c,
	0x8a, 0x10, 0x25, 0xb4, 0x45, 0xc5, 0xb9, 0x32, 0x6e, 0x7d, 0x07, 0x1a, 0x05, 0x19, 0xb2, 0xc0,
	0xc0, 0xed, 0xde, 0xd0, 0x95, 0x3f, 0x71, 0x3a, 0xc7, 0x6e, 0x1b, 0xdb, 0xa5, 0xc3, 0x27, 0xbf,
	0xd8, 0x3f, 0x0f, 0xb3, 0x8b, 0xf9, 0x19, 0x8f, 0x4a, 0xe2, 0x67, 0xe1, 0x24, 0xa5, 0xc1, 0x81,
	0x1c, 0xf2, 0xb1, 0xfa, 0x45, 0xb8, 0x78, 0x7a, 0x70, 0x9e, 0x2a, 0xec, 0xcc, 0x14, 0xe0, 0xb3,
	0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0xc5, 0x71, 0xb2, 0x11, 0xdd, 0x14, 0x00, 0x00,
}
