/*
 * Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
 * Copyright (c) 2011, 2012 Open Networking Foundation
 * Copyright 2013, Big Switch Networks, Inc. This library was generated by the LoxiGen Compiler.
 * Copyright 2018, Red Hat, Inc.
 */
// Automatically generated by LOXI from template module.go
// Do not modify

package of13

import (
	"encoding/binary"
	"fmt"

	"github.com/donNewtonAlpha/goloxi"
)

type ActionId struct {
	Type uint16
	Len  uint16
}

type IActionId interface {
	goloxi.Serializable
	GetType() uint16
	GetLen() uint16
}

func (self *ActionId) GetType() uint16 {
	return self.Type
}

func (self *ActionId) SetType(v uint16) {
	self.Type = v
}

func (self *ActionId) GetLen() uint16 {
	return self.Len
}

func (self *ActionId) SetLen(v uint16) {
	self.Len = v
}

func (self *ActionId) Serialize(encoder *goloxi.Encoder) error {

	encoder.PutUint16(uint16(self.Type))
	encoder.PutUint16(uint16(self.Len))

	return nil
}

func DecodeActionId(decoder *goloxi.Decoder) (IActionId, error) {
	_actionid := &ActionId{}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("ActionId packet too short: %d < 4", decoder.Length())
	}
	_actionid.Type = uint16(decoder.ReadUint16())
	_actionid.Len = uint16(decoder.ReadUint16())
	oldDecoder := decoder
	defer func() { decoder = oldDecoder }()
	decoder = decoder.SliceDecoder(int(_actionid.Len), 2+2)

	switch _actionid.Type {
	case 0:
		return DecodeActionIdOutput(_actionid, decoder)
	case 11:
		return DecodeActionIdCopyTtlOut(_actionid, decoder)
	case 12:
		return DecodeActionIdCopyTtlIn(_actionid, decoder)
	case 15:
		return DecodeActionIdSetMplsTtl(_actionid, decoder)
	case 16:
		return DecodeActionIdDecMplsTtl(_actionid, decoder)
	case 17:
		return DecodeActionIdPushVlan(_actionid, decoder)
	case 18:
		return DecodeActionIdPopVlan(_actionid, decoder)
	case 19:
		return DecodeActionIdPushMpls(_actionid, decoder)
	case 20:
		return DecodeActionIdPopMpls(_actionid, decoder)
	case 21:
		return DecodeActionIdSetQueue(_actionid, decoder)
	case 22:
		return DecodeActionIdGroup(_actionid, decoder)
	case 23:
		return DecodeActionIdSetNwTtl(_actionid, decoder)
	case 24:
		return DecodeActionIdDecNwTtl(_actionid, decoder)
	case 25:
		return DecodeActionIdSetField(_actionid, decoder)
	case 26:
		return DecodeActionIdPushPbb(_actionid, decoder)
	case 27:
		return DecodeActionIdPopPbb(_actionid, decoder)
	case 65535:
		return DecodeActionIdExperimenter(_actionid, decoder)
	default:
		return _actionid, nil
	}
}

func NewActionId(_type uint16) *ActionId {
	obj := &ActionId{}
	obj.Type = _type
	return obj
}

type ActionIdExperimenter struct {
	*ActionId
	Experimenter uint32
}

type IActionIdExperimenter interface {
	IActionId
	GetExperimenter() uint32
}

func (self *ActionIdExperimenter) GetExperimenter() uint32 {
	return self.Experimenter
}

func (self *ActionIdExperimenter) SetExperimenter(v uint32) {
	self.Experimenter = v
}

func (self *ActionIdExperimenter) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Experimenter))

	return nil
}

func DecodeActionIdExperimenter(parent *ActionId, decoder *goloxi.Decoder) (IActionIdExperimenter, error) {
	_actionidexperimenter := &ActionIdExperimenter{ActionId: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("ActionIdExperimenter packet too short: %d < 4", decoder.Length())
	}
	_actionidexperimenter.Experimenter = uint32(decoder.ReadUint32())

	switch _actionidexperimenter.Experimenter {
	case 8992:
		return DecodeActionIdNicira(_actionidexperimenter, decoder)
	case 6035143:
		return DecodeActionIdBsn(_actionidexperimenter, decoder)
	default:
		return _actionidexperimenter, nil
	}
}

func NewActionIdExperimenter(_experimenter uint32) *ActionIdExperimenter {
	obj := &ActionIdExperimenter{
		ActionId: NewActionId(65535),
	}
	obj.Experimenter = _experimenter
	return obj
}

type ActionIdBsn struct {
	*ActionIdExperimenter
	Subtype uint32
}

type IActionIdBsn interface {
	IActionIdExperimenter
	GetSubtype() uint32
}

func (self *ActionIdBsn) GetSubtype() uint32 {
	return self.Subtype
}

func (self *ActionIdBsn) SetSubtype(v uint32) {
	self.Subtype = v
}

func (self *ActionIdBsn) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdExperimenter.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.Subtype))

	return nil
}

func DecodeActionIdBsn(parent *ActionIdExperimenter, decoder *goloxi.Decoder) (IActionIdBsn, error) {
	_actionidbsn := &ActionIdBsn{ActionIdExperimenter: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("ActionIdBsn packet too short: %d < 4", decoder.Length())
	}
	_actionidbsn.Subtype = uint32(decoder.ReadUint32())

	switch _actionidbsn.Subtype {
	case 1:
		return DecodeActionIdBsnMirror(_actionidbsn, decoder)
	case 2:
		return DecodeActionIdBsnSetTunnelDst(_actionidbsn, decoder)
	case 4:
		return DecodeActionIdBsnChecksum(_actionidbsn, decoder)
	case 5:
		return DecodeActionIdBsnGentable(_actionidbsn, decoder)
	default:
		return _actionidbsn, nil
	}
}

func NewActionIdBsn(_subtype uint32) *ActionIdBsn {
	obj := &ActionIdBsn{
		ActionIdExperimenter: NewActionIdExperimenter(6035143),
	}
	obj.Subtype = _subtype
	return obj
}

type ActionIdBsnChecksum struct {
	*ActionIdBsn
}

type IActionIdBsnChecksum interface {
	IActionIdBsn
}

func (self *ActionIdBsnChecksum) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdBsn.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdBsnChecksum(parent *ActionIdBsn, decoder *goloxi.Decoder) (*ActionIdBsnChecksum, error) {
	_actionidbsnchecksum := &ActionIdBsnChecksum{ActionIdBsn: parent}
	return _actionidbsnchecksum, nil
}

func NewActionIdBsnChecksum() *ActionIdBsnChecksum {
	obj := &ActionIdBsnChecksum{
		ActionIdBsn: NewActionIdBsn(4),
	}
	return obj
}

type ActionIdBsnGentable struct {
	*ActionIdBsn
}

type IActionIdBsnGentable interface {
	IActionIdBsn
}

func (self *ActionIdBsnGentable) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdBsn.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdBsnGentable(parent *ActionIdBsn, decoder *goloxi.Decoder) (*ActionIdBsnGentable, error) {
	_actionidbsngentable := &ActionIdBsnGentable{ActionIdBsn: parent}
	return _actionidbsngentable, nil
}

func NewActionIdBsnGentable() *ActionIdBsnGentable {
	obj := &ActionIdBsnGentable{
		ActionIdBsn: NewActionIdBsn(5),
	}
	return obj
}

type ActionIdBsnMirror struct {
	*ActionIdBsn
}

type IActionIdBsnMirror interface {
	IActionIdBsn
}

func (self *ActionIdBsnMirror) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdBsn.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdBsnMirror(parent *ActionIdBsn, decoder *goloxi.Decoder) (*ActionIdBsnMirror, error) {
	_actionidbsnmirror := &ActionIdBsnMirror{ActionIdBsn: parent}
	return _actionidbsnmirror, nil
}

func NewActionIdBsnMirror() *ActionIdBsnMirror {
	obj := &ActionIdBsnMirror{
		ActionIdBsn: NewActionIdBsn(1),
	}
	return obj
}

type ActionIdBsnSetTunnelDst struct {
	*ActionIdBsn
}

type IActionIdBsnSetTunnelDst interface {
	IActionIdBsn
}

func (self *ActionIdBsnSetTunnelDst) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdBsn.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdBsnSetTunnelDst(parent *ActionIdBsn, decoder *goloxi.Decoder) (*ActionIdBsnSetTunnelDst, error) {
	_actionidbsnsettunneldst := &ActionIdBsnSetTunnelDst{ActionIdBsn: parent}
	return _actionidbsnsettunneldst, nil
}

func NewActionIdBsnSetTunnelDst() *ActionIdBsnSetTunnelDst {
	obj := &ActionIdBsnSetTunnelDst{
		ActionIdBsn: NewActionIdBsn(2),
	}
	return obj
}

type ActionIdCopyTtlIn struct {
	*ActionId
}

type IActionIdCopyTtlIn interface {
	IActionId
}

func (self *ActionIdCopyTtlIn) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdCopyTtlIn(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdCopyTtlIn, error) {
	_actionidcopyttlin := &ActionIdCopyTtlIn{ActionId: parent}
	return _actionidcopyttlin, nil
}

func NewActionIdCopyTtlIn() *ActionIdCopyTtlIn {
	obj := &ActionIdCopyTtlIn{
		ActionId: NewActionId(12),
	}
	return obj
}

type ActionIdCopyTtlOut struct {
	*ActionId
}

type IActionIdCopyTtlOut interface {
	IActionId
}

func (self *ActionIdCopyTtlOut) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdCopyTtlOut(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdCopyTtlOut, error) {
	_actionidcopyttlout := &ActionIdCopyTtlOut{ActionId: parent}
	return _actionidcopyttlout, nil
}

func NewActionIdCopyTtlOut() *ActionIdCopyTtlOut {
	obj := &ActionIdCopyTtlOut{
		ActionId: NewActionId(11),
	}
	return obj
}

type ActionIdDecMplsTtl struct {
	*ActionId
}

type IActionIdDecMplsTtl interface {
	IActionId
}

func (self *ActionIdDecMplsTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdDecMplsTtl(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdDecMplsTtl, error) {
	_actioniddecmplsttl := &ActionIdDecMplsTtl{ActionId: parent}
	return _actioniddecmplsttl, nil
}

func NewActionIdDecMplsTtl() *ActionIdDecMplsTtl {
	obj := &ActionIdDecMplsTtl{
		ActionId: NewActionId(16),
	}
	return obj
}

type ActionIdDecNwTtl struct {
	*ActionId
}

type IActionIdDecNwTtl interface {
	IActionId
}

func (self *ActionIdDecNwTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdDecNwTtl(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdDecNwTtl, error) {
	_actioniddecnwttl := &ActionIdDecNwTtl{ActionId: parent}
	return _actioniddecnwttl, nil
}

func NewActionIdDecNwTtl() *ActionIdDecNwTtl {
	obj := &ActionIdDecNwTtl{
		ActionId: NewActionId(24),
	}
	return obj
}

type ActionIdGroup struct {
	*ActionId
}

type IActionIdGroup interface {
	IActionId
}

func (self *ActionIdGroup) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdGroup(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdGroup, error) {
	_actionidgroup := &ActionIdGroup{ActionId: parent}
	return _actionidgroup, nil
}

func NewActionIdGroup() *ActionIdGroup {
	obj := &ActionIdGroup{
		ActionId: NewActionId(22),
	}
	return obj
}

type ActionIdNicira struct {
	*ActionIdExperimenter
	Subtype uint16
}

type IActionIdNicira interface {
	IActionIdExperimenter
	GetSubtype() uint16
}

func (self *ActionIdNicira) GetSubtype() uint16 {
	return self.Subtype
}

func (self *ActionIdNicira) SetSubtype(v uint16) {
	self.Subtype = v
}

func (self *ActionIdNicira) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdExperimenter.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint16(uint16(self.Subtype))

	return nil
}

func DecodeActionIdNicira(parent *ActionIdExperimenter, decoder *goloxi.Decoder) (IActionIdNicira, error) {
	_actionidnicira := &ActionIdNicira{ActionIdExperimenter: parent}
	if decoder.Length() < 2 {
		return nil, fmt.Errorf("ActionIdNicira packet too short: %d < 2", decoder.Length())
	}
	_actionidnicira.Subtype = uint16(decoder.ReadUint16())

	switch _actionidnicira.Subtype {
	case 1:
		return DecodeActionIdNxResubmit(_actionidnicira, decoder)
	case 2:
		return DecodeActionIdNxSetTunnel(_actionidnicira, decoder)
	case 4:
		return DecodeActionIdNxSetQueue(_actionidnicira, decoder)
	case 5:
		return DecodeActionIdNxPopQueue(_actionidnicira, decoder)
	case 6:
		return DecodeActionIdNxRegMove(_actionidnicira, decoder)
	case 7:
		return DecodeActionIdNxRegLoad(_actionidnicira, decoder)
	case 8:
		return DecodeActionIdNxNote(_actionidnicira, decoder)
	case 9:
		return DecodeActionIdNxSetTunnel64(_actionidnicira, decoder)
	case 10:
		return DecodeActionIdNxMultipath(_actionidnicira, decoder)
	case 12:
		return DecodeActionIdNxBundle(_actionidnicira, decoder)
	case 13:
		return DecodeActionIdNxBundleLoadInPort(_actionidnicira, decoder)
	case 14:
		return DecodeActionIdResubmit(_actionidnicira, decoder)
	case 15:
		return DecodeActionIdNxOutputReg(_actionidnicira, decoder)
	case 16:
		return DecodeActionIdNxLearn(_actionidnicira, decoder)
	case 17:
		return DecodeActionIdNxExit(_actionidnicira, decoder)
	case 18:
		return DecodeActionIdNiciraDecTtl(_actionidnicira, decoder)
	case 19:
		return DecodeActionIdNxFinTimeout(_actionidnicira, decoder)
	case 20:
		return DecodeActionIdNxController(_actionidnicira, decoder)
	case 21:
		return DecodeActionIdNxDecTtlCntIds(_actionidnicira, decoder)
	case 22:
		return DecodeActionIdNxWriteMetadata(_actionidnicira, decoder)
	case 23:
		return DecodeActionIdNxPushMpls(_actionidnicira, decoder)
	case 24:
		return DecodeActionIdNxPopMpls(_actionidnicira, decoder)
	case 25:
		return DecodeActionIdNxSetMplsTtl(_actionidnicira, decoder)
	case 26:
		return DecodeActionIdNxDecMplsTtl(_actionidnicira, decoder)
	case 27:
		return DecodeActionIdNxStackPush(_actionidnicira, decoder)
	case 28:
		return DecodeActionIdNxStackPop(_actionidnicira, decoder)
	case 29:
		return DecodeActionIdNxSample(_actionidnicira, decoder)
	case 30:
		return DecodeActionIdNxSetMplsLabel(_actionidnicira, decoder)
	case 31:
		return DecodeActionIdNxSetMplsTc(_actionidnicira, decoder)
	case 32:
		return DecodeActionIdNxOutputReg2(_actionidnicira, decoder)
	case 33:
		return DecodeActionIdNxRegLoad2(_actionidnicira, decoder)
	case 34:
		return DecodeActionIdNxConjunction(_actionidnicira, decoder)
	case 35:
		return DecodeActionIdNxCt(_actionidnicira, decoder)
	case 36:
		return DecodeActionIdNxNat(_actionidnicira, decoder)
	case 37:
		return DecodeActionIdNxController2(_actionidnicira, decoder)
	case 38:
		return DecodeActionIdNxSample2(_actionidnicira, decoder)
	case 39:
		return DecodeActionIdNxOutputTrunc(_actionidnicira, decoder)
	case 40:
		return DecodeActionIdNxGroup(_actionidnicira, decoder)
	case 41:
		return DecodeActionIdNxSample3(_actionidnicira, decoder)
	case 42:
		return DecodeActionIdNxClone(_actionidnicira, decoder)
	case 43:
		return DecodeActionIdNxCtClear(_actionidnicira, decoder)
	case 44:
		return DecodeActionIdNxResubmitTableCt(_actionidnicira, decoder)
	case 45:
		return DecodeActionIdNxLearn2(_actionidnicira, decoder)
	case 46:
		return DecodeActionIdNxEncap(_actionidnicira, decoder)
	case 47:
		return DecodeActionIdNxDecap(_actionidnicira, decoder)
	case 48:
		return DecodeActionIdNxDecNshTtl(_actionidnicira, decoder)
	case 254:
		return DecodeActionIdNxDebugSlow(_actionidnicira, decoder)
	case 255:
		return DecodeActionIdNxDebugRecirc(_actionidnicira, decoder)
	default:
		return _actionidnicira, nil
	}
}

func NewActionIdNicira(_subtype uint16) *ActionIdNicira {
	obj := &ActionIdNicira{
		ActionIdExperimenter: NewActionIdExperimenter(8992),
	}
	obj.Subtype = _subtype
	return obj
}

type ActionIdNiciraDecTtl struct {
	*ActionIdNicira
}

type IActionIdNiciraDecTtl interface {
	IActionIdNicira
}

func (self *ActionIdNiciraDecTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNiciraDecTtl(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNiciraDecTtl, error) {
	_actionidniciradecttl := &ActionIdNiciraDecTtl{ActionIdNicira: parent}
	return _actionidniciradecttl, nil
}

func NewActionIdNiciraDecTtl() *ActionIdNiciraDecTtl {
	obj := &ActionIdNiciraDecTtl{
		ActionIdNicira: NewActionIdNicira(18),
	}
	return obj
}

type ActionIdNxBundle struct {
	*ActionIdNicira
}

type IActionIdNxBundle interface {
	IActionIdNicira
}

func (self *ActionIdNxBundle) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxBundle(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxBundle, error) {
	_actionidnxbundle := &ActionIdNxBundle{ActionIdNicira: parent}
	return _actionidnxbundle, nil
}

func NewActionIdNxBundle() *ActionIdNxBundle {
	obj := &ActionIdNxBundle{
		ActionIdNicira: NewActionIdNicira(12),
	}
	return obj
}

type ActionIdNxBundleLoad struct {
	*ActionIdNicira
	SlaveType ActionNxBundleSlaveType
}

type IActionIdNxBundleLoad interface {
	IActionIdNicira
	GetSlaveType() ActionNxBundleSlaveType
}

func (self *ActionIdNxBundleLoad) GetSlaveType() ActionNxBundleSlaveType {
	return self.SlaveType
}

func (self *ActionIdNxBundleLoad) SetSlaveType(v ActionNxBundleSlaveType) {
	self.SlaveType = v
}

func (self *ActionIdNxBundleLoad) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.SlaveType))

	return nil
}

func DecodeActionIdNxBundleLoad(parent *ActionIdNicira, decoder *goloxi.Decoder) (IActionIdNxBundleLoad, error) {
	_actionidnxbundleload := &ActionIdNxBundleLoad{ActionIdNicira: parent}
	if decoder.Length() < 4 {
		return nil, fmt.Errorf("ActionIdNxBundleLoad packet too short: %d < 4", decoder.Length())
	}
	_actionidnxbundleload.SlaveType = ActionNxBundleSlaveType(decoder.ReadUint32())
	return _actionidnxbundleload, nil
}

func NewActionIdNxBundleLoad(_slave_type ActionNxBundleSlaveType) *ActionIdNxBundleLoad {
	obj := &ActionIdNxBundleLoad{
		ActionIdNicira: NewActionIdNicira(13),
	}
	obj.SlaveType = _slave_type
	return obj
}

type ActionIdNxBundleLoadInPort struct {
	*ActionIdNicira
	SlaveType ActionNxBundleSlaveType
	NSlaves   uint16
}

type IActionIdNxBundleLoadInPort interface {
	IActionIdNicira
	GetSlaveType() ActionNxBundleSlaveType
	GetNSlaves() uint16
}

func (self *ActionIdNxBundleLoadInPort) GetSlaveType() ActionNxBundleSlaveType {
	return self.SlaveType
}

func (self *ActionIdNxBundleLoadInPort) SetSlaveType(v ActionNxBundleSlaveType) {
	self.SlaveType = v
}

func (self *ActionIdNxBundleLoadInPort) GetNSlaves() uint16 {
	return self.NSlaves
}

func (self *ActionIdNxBundleLoadInPort) SetNSlaves(v uint16) {
	self.NSlaves = v
}

func (self *ActionIdNxBundleLoadInPort) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	encoder.PutUint32(uint32(self.SlaveType))
	encoder.PutUint16(uint16(self.NSlaves))

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxBundleLoadInPort(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxBundleLoadInPort, error) {
	_actionidnxbundleloadinport := &ActionIdNxBundleLoadInPort{ActionIdNicira: parent}
	if decoder.Length() < 6 {
		return nil, fmt.Errorf("ActionIdNxBundleLoadInPort packet too short: %d < 6", decoder.Length())
	}
	_actionidnxbundleloadinport.SlaveType = ActionNxBundleSlaveType(decoder.ReadUint32())
	_actionidnxbundleloadinport.NSlaves = uint16(decoder.ReadUint16())
	return _actionidnxbundleloadinport, nil
}

func NewActionIdNxBundleLoadInPort() *ActionIdNxBundleLoadInPort {
	obj := &ActionIdNxBundleLoadInPort{
		ActionIdNicira: NewActionIdNicira(13),
	}
	return obj
}

type ActionIdNxClone struct {
	*ActionIdNicira
}

type IActionIdNxClone interface {
	IActionIdNicira
}

func (self *ActionIdNxClone) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxClone(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxClone, error) {
	_actionidnxclone := &ActionIdNxClone{ActionIdNicira: parent}
	return _actionidnxclone, nil
}

func NewActionIdNxClone() *ActionIdNxClone {
	obj := &ActionIdNxClone{
		ActionIdNicira: NewActionIdNicira(42),
	}
	return obj
}

type ActionIdNxConjunction struct {
	*ActionIdNicira
}

type IActionIdNxConjunction interface {
	IActionIdNicira
}

func (self *ActionIdNxConjunction) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxConjunction(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxConjunction, error) {
	_actionidnxconjunction := &ActionIdNxConjunction{ActionIdNicira: parent}
	return _actionidnxconjunction, nil
}

func NewActionIdNxConjunction() *ActionIdNxConjunction {
	obj := &ActionIdNxConjunction{
		ActionIdNicira: NewActionIdNicira(34),
	}
	return obj
}

type ActionIdNxController struct {
	*ActionIdNicira
}

type IActionIdNxController interface {
	IActionIdNicira
}

func (self *ActionIdNxController) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxController(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxController, error) {
	_actionidnxcontroller := &ActionIdNxController{ActionIdNicira: parent}
	return _actionidnxcontroller, nil
}

func NewActionIdNxController() *ActionIdNxController {
	obj := &ActionIdNxController{
		ActionIdNicira: NewActionIdNicira(20),
	}
	return obj
}

type ActionIdNxController2 struct {
	*ActionIdNicira
}

type IActionIdNxController2 interface {
	IActionIdNicira
}

func (self *ActionIdNxController2) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxController2(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxController2, error) {
	_actionidnxcontroller2 := &ActionIdNxController2{ActionIdNicira: parent}
	return _actionidnxcontroller2, nil
}

func NewActionIdNxController2() *ActionIdNxController2 {
	obj := &ActionIdNxController2{
		ActionIdNicira: NewActionIdNicira(37),
	}
	return obj
}

type ActionIdNxCt struct {
	*ActionIdNicira
}

type IActionIdNxCt interface {
	IActionIdNicira
}

func (self *ActionIdNxCt) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxCt(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxCt, error) {
	_actionidnxct := &ActionIdNxCt{ActionIdNicira: parent}
	return _actionidnxct, nil
}

func NewActionIdNxCt() *ActionIdNxCt {
	obj := &ActionIdNxCt{
		ActionIdNicira: NewActionIdNicira(35),
	}
	return obj
}

type ActionIdNxCtClear struct {
	*ActionIdNicira
}

type IActionIdNxCtClear interface {
	IActionIdNicira
}

func (self *ActionIdNxCtClear) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxCtClear(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxCtClear, error) {
	_actionidnxctclear := &ActionIdNxCtClear{ActionIdNicira: parent}
	return _actionidnxctclear, nil
}

func NewActionIdNxCtClear() *ActionIdNxCtClear {
	obj := &ActionIdNxCtClear{
		ActionIdNicira: NewActionIdNicira(43),
	}
	return obj
}

type ActionIdNxDebugRecirc struct {
	*ActionIdNicira
}

type IActionIdNxDebugRecirc interface {
	IActionIdNicira
}

func (self *ActionIdNxDebugRecirc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxDebugRecirc(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxDebugRecirc, error) {
	_actionidnxdebugrecirc := &ActionIdNxDebugRecirc{ActionIdNicira: parent}
	return _actionidnxdebugrecirc, nil
}

func NewActionIdNxDebugRecirc() *ActionIdNxDebugRecirc {
	obj := &ActionIdNxDebugRecirc{
		ActionIdNicira: NewActionIdNicira(255),
	}
	return obj
}

type ActionIdNxDebugSlow struct {
	*ActionIdNicira
}

type IActionIdNxDebugSlow interface {
	IActionIdNicira
}

func (self *ActionIdNxDebugSlow) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxDebugSlow(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxDebugSlow, error) {
	_actionidnxdebugslow := &ActionIdNxDebugSlow{ActionIdNicira: parent}
	return _actionidnxdebugslow, nil
}

func NewActionIdNxDebugSlow() *ActionIdNxDebugSlow {
	obj := &ActionIdNxDebugSlow{
		ActionIdNicira: NewActionIdNicira(254),
	}
	return obj
}

type ActionIdNxDecMplsTtl struct {
	*ActionIdNicira
}

type IActionIdNxDecMplsTtl interface {
	IActionIdNicira
}

func (self *ActionIdNxDecMplsTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxDecMplsTtl(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxDecMplsTtl, error) {
	_actionidnxdecmplsttl := &ActionIdNxDecMplsTtl{ActionIdNicira: parent}
	return _actionidnxdecmplsttl, nil
}

func NewActionIdNxDecMplsTtl() *ActionIdNxDecMplsTtl {
	obj := &ActionIdNxDecMplsTtl{
		ActionIdNicira: NewActionIdNicira(26),
	}
	return obj
}

type ActionIdNxDecNshTtl struct {
	*ActionIdNicira
}

type IActionIdNxDecNshTtl interface {
	IActionIdNicira
}

func (self *ActionIdNxDecNshTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxDecNshTtl(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxDecNshTtl, error) {
	_actionidnxdecnshttl := &ActionIdNxDecNshTtl{ActionIdNicira: parent}
	return _actionidnxdecnshttl, nil
}

func NewActionIdNxDecNshTtl() *ActionIdNxDecNshTtl {
	obj := &ActionIdNxDecNshTtl{
		ActionIdNicira: NewActionIdNicira(48),
	}
	return obj
}

type ActionIdNxDecTtlCntIds struct {
	*ActionIdNicira
}

type IActionIdNxDecTtlCntIds interface {
	IActionIdNicira
}

func (self *ActionIdNxDecTtlCntIds) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxDecTtlCntIds(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxDecTtlCntIds, error) {
	_actionidnxdecttlcntids := &ActionIdNxDecTtlCntIds{ActionIdNicira: parent}
	return _actionidnxdecttlcntids, nil
}

func NewActionIdNxDecTtlCntIds() *ActionIdNxDecTtlCntIds {
	obj := &ActionIdNxDecTtlCntIds{
		ActionIdNicira: NewActionIdNicira(21),
	}
	return obj
}

type ActionIdNxDecap struct {
	*ActionIdNicira
}

type IActionIdNxDecap interface {
	IActionIdNicira
}

func (self *ActionIdNxDecap) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxDecap(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxDecap, error) {
	_actionidnxdecap := &ActionIdNxDecap{ActionIdNicira: parent}
	return _actionidnxdecap, nil
}

func NewActionIdNxDecap() *ActionIdNxDecap {
	obj := &ActionIdNxDecap{
		ActionIdNicira: NewActionIdNicira(47),
	}
	return obj
}

type ActionIdNxEncap struct {
	*ActionIdNicira
}

type IActionIdNxEncap interface {
	IActionIdNicira
}

func (self *ActionIdNxEncap) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxEncap(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxEncap, error) {
	_actionidnxencap := &ActionIdNxEncap{ActionIdNicira: parent}
	return _actionidnxencap, nil
}

func NewActionIdNxEncap() *ActionIdNxEncap {
	obj := &ActionIdNxEncap{
		ActionIdNicira: NewActionIdNicira(46),
	}
	return obj
}

type ActionIdNxExit struct {
	*ActionIdNicira
}

type IActionIdNxExit interface {
	IActionIdNicira
}

func (self *ActionIdNxExit) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxExit(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxExit, error) {
	_actionidnxexit := &ActionIdNxExit{ActionIdNicira: parent}
	return _actionidnxexit, nil
}

func NewActionIdNxExit() *ActionIdNxExit {
	obj := &ActionIdNxExit{
		ActionIdNicira: NewActionIdNicira(17),
	}
	return obj
}

type ActionIdNxFinTimeout struct {
	*ActionIdNicira
}

type IActionIdNxFinTimeout interface {
	IActionIdNicira
}

func (self *ActionIdNxFinTimeout) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxFinTimeout(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxFinTimeout, error) {
	_actionidnxfintimeout := &ActionIdNxFinTimeout{ActionIdNicira: parent}
	return _actionidnxfintimeout, nil
}

func NewActionIdNxFinTimeout() *ActionIdNxFinTimeout {
	obj := &ActionIdNxFinTimeout{
		ActionIdNicira: NewActionIdNicira(19),
	}
	return obj
}

type ActionIdNxGroup struct {
	*ActionIdNicira
}

type IActionIdNxGroup interface {
	IActionIdNicira
}

func (self *ActionIdNxGroup) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxGroup(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxGroup, error) {
	_actionidnxgroup := &ActionIdNxGroup{ActionIdNicira: parent}
	return _actionidnxgroup, nil
}

func NewActionIdNxGroup() *ActionIdNxGroup {
	obj := &ActionIdNxGroup{
		ActionIdNicira: NewActionIdNicira(40),
	}
	return obj
}

type ActionIdNxLearn struct {
	*ActionIdNicira
}

type IActionIdNxLearn interface {
	IActionIdNicira
}

func (self *ActionIdNxLearn) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxLearn(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxLearn, error) {
	_actionidnxlearn := &ActionIdNxLearn{ActionIdNicira: parent}
	return _actionidnxlearn, nil
}

func NewActionIdNxLearn() *ActionIdNxLearn {
	obj := &ActionIdNxLearn{
		ActionIdNicira: NewActionIdNicira(16),
	}
	return obj
}

type ActionIdNxLearn2 struct {
	*ActionIdNicira
}

type IActionIdNxLearn2 interface {
	IActionIdNicira
}

func (self *ActionIdNxLearn2) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxLearn2(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxLearn2, error) {
	_actionidnxlearn2 := &ActionIdNxLearn2{ActionIdNicira: parent}
	return _actionidnxlearn2, nil
}

func NewActionIdNxLearn2() *ActionIdNxLearn2 {
	obj := &ActionIdNxLearn2{
		ActionIdNicira: NewActionIdNicira(45),
	}
	return obj
}

type ActionIdNxMultipath struct {
	*ActionIdNicira
}

type IActionIdNxMultipath interface {
	IActionIdNicira
}

func (self *ActionIdNxMultipath) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxMultipath(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxMultipath, error) {
	_actionidnxmultipath := &ActionIdNxMultipath{ActionIdNicira: parent}
	return _actionidnxmultipath, nil
}

func NewActionIdNxMultipath() *ActionIdNxMultipath {
	obj := &ActionIdNxMultipath{
		ActionIdNicira: NewActionIdNicira(10),
	}
	return obj
}

type ActionIdNxNat struct {
	*ActionIdNicira
}

type IActionIdNxNat interface {
	IActionIdNicira
}

func (self *ActionIdNxNat) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxNat(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxNat, error) {
	_actionidnxnat := &ActionIdNxNat{ActionIdNicira: parent}
	return _actionidnxnat, nil
}

func NewActionIdNxNat() *ActionIdNxNat {
	obj := &ActionIdNxNat{
		ActionIdNicira: NewActionIdNicira(36),
	}
	return obj
}

type ActionIdNxNote struct {
	*ActionIdNicira
}

type IActionIdNxNote interface {
	IActionIdNicira
}

func (self *ActionIdNxNote) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxNote(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxNote, error) {
	_actionidnxnote := &ActionIdNxNote{ActionIdNicira: parent}
	return _actionidnxnote, nil
}

func NewActionIdNxNote() *ActionIdNxNote {
	obj := &ActionIdNxNote{
		ActionIdNicira: NewActionIdNicira(8),
	}
	return obj
}

type ActionIdNxOutputReg struct {
	*ActionIdNicira
}

type IActionIdNxOutputReg interface {
	IActionIdNicira
}

func (self *ActionIdNxOutputReg) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxOutputReg(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxOutputReg, error) {
	_actionidnxoutputreg := &ActionIdNxOutputReg{ActionIdNicira: parent}
	return _actionidnxoutputreg, nil
}

func NewActionIdNxOutputReg() *ActionIdNxOutputReg {
	obj := &ActionIdNxOutputReg{
		ActionIdNicira: NewActionIdNicira(15),
	}
	return obj
}

type ActionIdNxOutputReg2 struct {
	*ActionIdNicira
}

type IActionIdNxOutputReg2 interface {
	IActionIdNicira
}

func (self *ActionIdNxOutputReg2) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxOutputReg2(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxOutputReg2, error) {
	_actionidnxoutputreg2 := &ActionIdNxOutputReg2{ActionIdNicira: parent}
	return _actionidnxoutputreg2, nil
}

func NewActionIdNxOutputReg2() *ActionIdNxOutputReg2 {
	obj := &ActionIdNxOutputReg2{
		ActionIdNicira: NewActionIdNicira(32),
	}
	return obj
}

type ActionIdNxOutputTrunc struct {
	*ActionIdNicira
}

type IActionIdNxOutputTrunc interface {
	IActionIdNicira
}

func (self *ActionIdNxOutputTrunc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxOutputTrunc(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxOutputTrunc, error) {
	_actionidnxoutputtrunc := &ActionIdNxOutputTrunc{ActionIdNicira: parent}
	return _actionidnxoutputtrunc, nil
}

func NewActionIdNxOutputTrunc() *ActionIdNxOutputTrunc {
	obj := &ActionIdNxOutputTrunc{
		ActionIdNicira: NewActionIdNicira(39),
	}
	return obj
}

type ActionIdNxPopMpls struct {
	*ActionIdNicira
}

type IActionIdNxPopMpls interface {
	IActionIdNicira
}

func (self *ActionIdNxPopMpls) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxPopMpls(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxPopMpls, error) {
	_actionidnxpopmpls := &ActionIdNxPopMpls{ActionIdNicira: parent}
	return _actionidnxpopmpls, nil
}

func NewActionIdNxPopMpls() *ActionIdNxPopMpls {
	obj := &ActionIdNxPopMpls{
		ActionIdNicira: NewActionIdNicira(24),
	}
	return obj
}

type ActionIdNxPopQueue struct {
	*ActionIdNicira
}

type IActionIdNxPopQueue interface {
	IActionIdNicira
}

func (self *ActionIdNxPopQueue) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxPopQueue(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxPopQueue, error) {
	_actionidnxpopqueue := &ActionIdNxPopQueue{ActionIdNicira: parent}
	return _actionidnxpopqueue, nil
}

func NewActionIdNxPopQueue() *ActionIdNxPopQueue {
	obj := &ActionIdNxPopQueue{
		ActionIdNicira: NewActionIdNicira(5),
	}
	return obj
}

type ActionIdNxPushMpls struct {
	*ActionIdNicira
}

type IActionIdNxPushMpls interface {
	IActionIdNicira
}

func (self *ActionIdNxPushMpls) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxPushMpls(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxPushMpls, error) {
	_actionidnxpushmpls := &ActionIdNxPushMpls{ActionIdNicira: parent}
	return _actionidnxpushmpls, nil
}

func NewActionIdNxPushMpls() *ActionIdNxPushMpls {
	obj := &ActionIdNxPushMpls{
		ActionIdNicira: NewActionIdNicira(23),
	}
	return obj
}

type ActionIdNxRegLoad struct {
	*ActionIdNicira
}

type IActionIdNxRegLoad interface {
	IActionIdNicira
}

func (self *ActionIdNxRegLoad) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxRegLoad(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxRegLoad, error) {
	_actionidnxregload := &ActionIdNxRegLoad{ActionIdNicira: parent}
	return _actionidnxregload, nil
}

func NewActionIdNxRegLoad() *ActionIdNxRegLoad {
	obj := &ActionIdNxRegLoad{
		ActionIdNicira: NewActionIdNicira(7),
	}
	return obj
}

type ActionIdNxRegLoad2 struct {
	*ActionIdNicira
}

type IActionIdNxRegLoad2 interface {
	IActionIdNicira
}

func (self *ActionIdNxRegLoad2) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxRegLoad2(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxRegLoad2, error) {
	_actionidnxregload2 := &ActionIdNxRegLoad2{ActionIdNicira: parent}
	return _actionidnxregload2, nil
}

func NewActionIdNxRegLoad2() *ActionIdNxRegLoad2 {
	obj := &ActionIdNxRegLoad2{
		ActionIdNicira: NewActionIdNicira(33),
	}
	return obj
}

type ActionIdNxRegMove struct {
	*ActionIdNicira
}

type IActionIdNxRegMove interface {
	IActionIdNicira
}

func (self *ActionIdNxRegMove) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxRegMove(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxRegMove, error) {
	_actionidnxregmove := &ActionIdNxRegMove{ActionIdNicira: parent}
	return _actionidnxregmove, nil
}

func NewActionIdNxRegMove() *ActionIdNxRegMove {
	obj := &ActionIdNxRegMove{
		ActionIdNicira: NewActionIdNicira(6),
	}
	return obj
}

type ActionIdNxResubmit struct {
	*ActionIdNicira
}

type IActionIdNxResubmit interface {
	IActionIdNicira
}

func (self *ActionIdNxResubmit) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxResubmit(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxResubmit, error) {
	_actionidnxresubmit := &ActionIdNxResubmit{ActionIdNicira: parent}
	return _actionidnxresubmit, nil
}

func NewActionIdNxResubmit() *ActionIdNxResubmit {
	obj := &ActionIdNxResubmit{
		ActionIdNicira: NewActionIdNicira(1),
	}
	return obj
}

type ActionIdNxResubmitTable struct {
	*ActionIdNicira
}

type IActionIdNxResubmitTable interface {
	IActionIdNicira
}

func (self *ActionIdNxResubmitTable) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxResubmitTable(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxResubmitTable, error) {
	_actionidnxresubmittable := &ActionIdNxResubmitTable{ActionIdNicira: parent}
	return _actionidnxresubmittable, nil
}

func NewActionIdNxResubmitTable() *ActionIdNxResubmitTable {
	obj := &ActionIdNxResubmitTable{
		ActionIdNicira: NewActionIdNicira(14),
	}
	return obj
}

type ActionIdNxResubmitTableCt struct {
	*ActionIdNicira
}

type IActionIdNxResubmitTableCt interface {
	IActionIdNicira
}

func (self *ActionIdNxResubmitTableCt) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxResubmitTableCt(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxResubmitTableCt, error) {
	_actionidnxresubmittablect := &ActionIdNxResubmitTableCt{ActionIdNicira: parent}
	return _actionidnxresubmittablect, nil
}

func NewActionIdNxResubmitTableCt() *ActionIdNxResubmitTableCt {
	obj := &ActionIdNxResubmitTableCt{
		ActionIdNicira: NewActionIdNicira(44),
	}
	return obj
}

type ActionIdNxSample struct {
	*ActionIdNicira
}

type IActionIdNxSample interface {
	IActionIdNicira
}

func (self *ActionIdNxSample) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxSample(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxSample, error) {
	_actionidnxsample := &ActionIdNxSample{ActionIdNicira: parent}
	return _actionidnxsample, nil
}

func NewActionIdNxSample() *ActionIdNxSample {
	obj := &ActionIdNxSample{
		ActionIdNicira: NewActionIdNicira(29),
	}
	return obj
}

type ActionIdNxSample2 struct {
	*ActionIdNicira
}

type IActionIdNxSample2 interface {
	IActionIdNicira
}

func (self *ActionIdNxSample2) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxSample2(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxSample2, error) {
	_actionidnxsample2 := &ActionIdNxSample2{ActionIdNicira: parent}
	return _actionidnxsample2, nil
}

func NewActionIdNxSample2() *ActionIdNxSample2 {
	obj := &ActionIdNxSample2{
		ActionIdNicira: NewActionIdNicira(38),
	}
	return obj
}

type ActionIdNxSample3 struct {
	*ActionIdNicira
}

type IActionIdNxSample3 interface {
	IActionIdNicira
}

func (self *ActionIdNxSample3) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxSample3(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxSample3, error) {
	_actionidnxsample3 := &ActionIdNxSample3{ActionIdNicira: parent}
	return _actionidnxsample3, nil
}

func NewActionIdNxSample3() *ActionIdNxSample3 {
	obj := &ActionIdNxSample3{
		ActionIdNicira: NewActionIdNicira(41),
	}
	return obj
}

type ActionIdNxSetMplsLabel struct {
	*ActionIdNicira
}

type IActionIdNxSetMplsLabel interface {
	IActionIdNicira
}

func (self *ActionIdNxSetMplsLabel) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxSetMplsLabel(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxSetMplsLabel, error) {
	_actionidnxsetmplslabel := &ActionIdNxSetMplsLabel{ActionIdNicira: parent}
	return _actionidnxsetmplslabel, nil
}

func NewActionIdNxSetMplsLabel() *ActionIdNxSetMplsLabel {
	obj := &ActionIdNxSetMplsLabel{
		ActionIdNicira: NewActionIdNicira(30),
	}
	return obj
}

type ActionIdNxSetMplsTc struct {
	*ActionIdNicira
}

type IActionIdNxSetMplsTc interface {
	IActionIdNicira
}

func (self *ActionIdNxSetMplsTc) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxSetMplsTc(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxSetMplsTc, error) {
	_actionidnxsetmplstc := &ActionIdNxSetMplsTc{ActionIdNicira: parent}
	return _actionidnxsetmplstc, nil
}

func NewActionIdNxSetMplsTc() *ActionIdNxSetMplsTc {
	obj := &ActionIdNxSetMplsTc{
		ActionIdNicira: NewActionIdNicira(31),
	}
	return obj
}

type ActionIdNxSetMplsTtl struct {
	*ActionIdNicira
}

type IActionIdNxSetMplsTtl interface {
	IActionIdNicira
}

func (self *ActionIdNxSetMplsTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxSetMplsTtl(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxSetMplsTtl, error) {
	_actionidnxsetmplsttl := &ActionIdNxSetMplsTtl{ActionIdNicira: parent}
	return _actionidnxsetmplsttl, nil
}

func NewActionIdNxSetMplsTtl() *ActionIdNxSetMplsTtl {
	obj := &ActionIdNxSetMplsTtl{
		ActionIdNicira: NewActionIdNicira(25),
	}
	return obj
}

type ActionIdNxSetQueue struct {
	*ActionIdNicira
}

type IActionIdNxSetQueue interface {
	IActionIdNicira
}

func (self *ActionIdNxSetQueue) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxSetQueue(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxSetQueue, error) {
	_actionidnxsetqueue := &ActionIdNxSetQueue{ActionIdNicira: parent}
	return _actionidnxsetqueue, nil
}

func NewActionIdNxSetQueue() *ActionIdNxSetQueue {
	obj := &ActionIdNxSetQueue{
		ActionIdNicira: NewActionIdNicira(4),
	}
	return obj
}

type ActionIdNxSetTunnel struct {
	*ActionIdNicira
}

type IActionIdNxSetTunnel interface {
	IActionIdNicira
}

func (self *ActionIdNxSetTunnel) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxSetTunnel(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxSetTunnel, error) {
	_actionidnxsettunnel := &ActionIdNxSetTunnel{ActionIdNicira: parent}
	return _actionidnxsettunnel, nil
}

func NewActionIdNxSetTunnel() *ActionIdNxSetTunnel {
	obj := &ActionIdNxSetTunnel{
		ActionIdNicira: NewActionIdNicira(2),
	}
	return obj
}

type ActionIdNxSetTunnel64 struct {
	*ActionIdNicira
}

type IActionIdNxSetTunnel64 interface {
	IActionIdNicira
}

func (self *ActionIdNxSetTunnel64) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxSetTunnel64(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxSetTunnel64, error) {
	_actionidnxsettunnel64 := &ActionIdNxSetTunnel64{ActionIdNicira: parent}
	return _actionidnxsettunnel64, nil
}

func NewActionIdNxSetTunnel64() *ActionIdNxSetTunnel64 {
	obj := &ActionIdNxSetTunnel64{
		ActionIdNicira: NewActionIdNicira(9),
	}
	return obj
}

type ActionIdNxStackPop struct {
	*ActionIdNicira
}

type IActionIdNxStackPop interface {
	IActionIdNicira
}

func (self *ActionIdNxStackPop) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxStackPop(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxStackPop, error) {
	_actionidnxstackpop := &ActionIdNxStackPop{ActionIdNicira: parent}
	return _actionidnxstackpop, nil
}

func NewActionIdNxStackPop() *ActionIdNxStackPop {
	obj := &ActionIdNxStackPop{
		ActionIdNicira: NewActionIdNicira(28),
	}
	return obj
}

type ActionIdNxStackPush struct {
	*ActionIdNicira
}

type IActionIdNxStackPush interface {
	IActionIdNicira
}

func (self *ActionIdNxStackPush) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxStackPush(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxStackPush, error) {
	_actionidnxstackpush := &ActionIdNxStackPush{ActionIdNicira: parent}
	return _actionidnxstackpush, nil
}

func NewActionIdNxStackPush() *ActionIdNxStackPush {
	obj := &ActionIdNxStackPush{
		ActionIdNicira: NewActionIdNicira(27),
	}
	return obj
}

type ActionIdNxWriteMetadata struct {
	*ActionIdNicira
}

type IActionIdNxWriteMetadata interface {
	IActionIdNicira
}

func (self *ActionIdNxWriteMetadata) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdNxWriteMetadata(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdNxWriteMetadata, error) {
	_actionidnxwritemetadata := &ActionIdNxWriteMetadata{ActionIdNicira: parent}
	return _actionidnxwritemetadata, nil
}

func NewActionIdNxWriteMetadata() *ActionIdNxWriteMetadata {
	obj := &ActionIdNxWriteMetadata{
		ActionIdNicira: NewActionIdNicira(22),
	}
	return obj
}

type ActionIdOutput struct {
	*ActionId
}

type IActionIdOutput interface {
	IActionId
}

func (self *ActionIdOutput) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdOutput(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdOutput, error) {
	_actionidoutput := &ActionIdOutput{ActionId: parent}
	return _actionidoutput, nil
}

func NewActionIdOutput() *ActionIdOutput {
	obj := &ActionIdOutput{
		ActionId: NewActionId(0),
	}
	return obj
}

type ActionIdPopMpls struct {
	*ActionId
}

type IActionIdPopMpls interface {
	IActionId
}

func (self *ActionIdPopMpls) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdPopMpls(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdPopMpls, error) {
	_actionidpopmpls := &ActionIdPopMpls{ActionId: parent}
	return _actionidpopmpls, nil
}

func NewActionIdPopMpls() *ActionIdPopMpls {
	obj := &ActionIdPopMpls{
		ActionId: NewActionId(20),
	}
	return obj
}

type ActionIdPopPbb struct {
	*ActionId
}

type IActionIdPopPbb interface {
	IActionId
}

func (self *ActionIdPopPbb) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdPopPbb(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdPopPbb, error) {
	_actionidpoppbb := &ActionIdPopPbb{ActionId: parent}
	return _actionidpoppbb, nil
}

func NewActionIdPopPbb() *ActionIdPopPbb {
	obj := &ActionIdPopPbb{
		ActionId: NewActionId(27),
	}
	return obj
}

type ActionIdPopVlan struct {
	*ActionId
}

type IActionIdPopVlan interface {
	IActionId
}

func (self *ActionIdPopVlan) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdPopVlan(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdPopVlan, error) {
	_actionidpopvlan := &ActionIdPopVlan{ActionId: parent}
	return _actionidpopvlan, nil
}

func NewActionIdPopVlan() *ActionIdPopVlan {
	obj := &ActionIdPopVlan{
		ActionId: NewActionId(18),
	}
	return obj
}

type ActionIdPushMpls struct {
	*ActionId
}

type IActionIdPushMpls interface {
	IActionId
}

func (self *ActionIdPushMpls) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdPushMpls(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdPushMpls, error) {
	_actionidpushmpls := &ActionIdPushMpls{ActionId: parent}
	return _actionidpushmpls, nil
}

func NewActionIdPushMpls() *ActionIdPushMpls {
	obj := &ActionIdPushMpls{
		ActionId: NewActionId(19),
	}
	return obj
}

type ActionIdPushPbb struct {
	*ActionId
}

type IActionIdPushPbb interface {
	IActionId
}

func (self *ActionIdPushPbb) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdPushPbb(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdPushPbb, error) {
	_actionidpushpbb := &ActionIdPushPbb{ActionId: parent}
	return _actionidpushpbb, nil
}

func NewActionIdPushPbb() *ActionIdPushPbb {
	obj := &ActionIdPushPbb{
		ActionId: NewActionId(26),
	}
	return obj
}

type ActionIdPushVlan struct {
	*ActionId
}

type IActionIdPushVlan interface {
	IActionId
}

func (self *ActionIdPushVlan) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdPushVlan(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdPushVlan, error) {
	_actionidpushvlan := &ActionIdPushVlan{ActionId: parent}
	return _actionidpushvlan, nil
}

func NewActionIdPushVlan() *ActionIdPushVlan {
	obj := &ActionIdPushVlan{
		ActionId: NewActionId(17),
	}
	return obj
}

type ActionIdResubmit struct {
	*ActionIdNicira
}

type IActionIdResubmit interface {
	IActionIdNicira
}

func (self *ActionIdResubmit) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionIdNicira.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdResubmit(parent *ActionIdNicira, decoder *goloxi.Decoder) (*ActionIdResubmit, error) {
	_actionidresubmit := &ActionIdResubmit{ActionIdNicira: parent}
	return _actionidresubmit, nil
}

func NewActionIdResubmit() *ActionIdResubmit {
	obj := &ActionIdResubmit{
		ActionIdNicira: NewActionIdNicira(14),
	}
	return obj
}

type ActionIdSetField struct {
	*ActionId
}

type IActionIdSetField interface {
	IActionId
}

func (self *ActionIdSetField) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdSetField(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdSetField, error) {
	_actionidsetfield := &ActionIdSetField{ActionId: parent}
	return _actionidsetfield, nil
}

func NewActionIdSetField() *ActionIdSetField {
	obj := &ActionIdSetField{
		ActionId: NewActionId(25),
	}
	return obj
}

type ActionIdSetMplsTtl struct {
	*ActionId
}

type IActionIdSetMplsTtl interface {
	IActionId
}

func (self *ActionIdSetMplsTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdSetMplsTtl(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdSetMplsTtl, error) {
	_actionidsetmplsttl := &ActionIdSetMplsTtl{ActionId: parent}
	return _actionidsetmplsttl, nil
}

func NewActionIdSetMplsTtl() *ActionIdSetMplsTtl {
	obj := &ActionIdSetMplsTtl{
		ActionId: NewActionId(15),
	}
	return obj
}

type ActionIdSetNwTtl struct {
	*ActionId
}

type IActionIdSetNwTtl interface {
	IActionId
}

func (self *ActionIdSetNwTtl) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdSetNwTtl(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdSetNwTtl, error) {
	_actionidsetnwttl := &ActionIdSetNwTtl{ActionId: parent}
	return _actionidsetnwttl, nil
}

func NewActionIdSetNwTtl() *ActionIdSetNwTtl {
	obj := &ActionIdSetNwTtl{
		ActionId: NewActionId(23),
	}
	return obj
}

type ActionIdSetQueue struct {
	*ActionId
}

type IActionIdSetQueue interface {
	IActionId
}

func (self *ActionIdSetQueue) Serialize(encoder *goloxi.Encoder) error {
	if err := self.ActionId.Serialize(encoder); err != nil {
		return err
	}

	binary.BigEndian.PutUint16(encoder.Bytes()[2:4], uint16(len(encoder.Bytes())))

	return nil
}

func DecodeActionIdSetQueue(parent *ActionId, decoder *goloxi.Decoder) (*ActionIdSetQueue, error) {
	_actionidsetqueue := &ActionIdSetQueue{ActionId: parent}
	return _actionidsetqueue, nil
}

func NewActionIdSetQueue() *ActionIdSetQueue {
	obj := &ActionIdSetQueue{
		ActionId: NewActionId(21),
	}
	return obj
}
