# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2019-02-21 16:10
from __future__ import unicode_literals

import core.models.xosbase_header
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0002_initial_data'),
    ]

    operations = [
        migrations.CreateModel(
            name='KubernetesConfigVolumeMount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, help_text=b'Time this model was created')),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer')),
                ('enacted', models.DateTimeField(blank=True, default=None, help_text=b'When synced, set to the timestamp of the data that was synced', null=True)),
                ('policed', models.DateTimeField(blank=True, default=None, help_text=b'When policed, set to the timestamp of the data that was policed', null=True)),
                ('backend_register', models.CharField(blank=True, default=b'{}', max_length=1024, null=True)),
                ('backend_need_delete', models.BooleanField(default=False)),
                ('backend_need_reap', models.BooleanField(default=False)),
                ('backend_status', models.CharField(default=b'Provisioning in progress', max_length=1024, null=True)),
                ('backend_code', models.IntegerField(default=0)),
                ('deleted', models.BooleanField(default=False)),
                ('write_protect', models.BooleanField(default=False)),
                ('lazy_blocked', models.BooleanField(default=False)),
                ('no_sync', models.BooleanField(default=False)),
                ('no_policy', models.BooleanField(default=False)),
                ('policy_status', models.CharField(blank=True, default=b'Policy in process', max_length=1024, null=True)),
                ('policy_code', models.IntegerField(blank=True, default=0, null=True)),
                ('leaf_model_name', models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024)),
                ('backend_need_delete_policy', models.BooleanField(default=False, help_text=b'True if delete model_policy must be run before object can be reaped')),
                ('xos_managed', models.BooleanField(default=True, help_text=b'True if xos is responsible for creating/deleting this object')),
                ('backend_handle', models.CharField(blank=True, help_text=b'Handle used by the backend to track this object', max_length=1024, null=True)),
                ('changed_by_step', models.DateTimeField(blank=True, default=None, help_text=b'Time this model was changed by a sync step', null=True)),
                ('changed_by_policy', models.DateTimeField(blank=True, default=None, help_text=b'Time this model was changed by a model policy', null=True)),
                ('mount_path', models.CharField(blank=True, help_text=b'Path to mount secret', max_length=1024, null=True)),
                ('sub_path', models.CharField(blank=True, help_text=b'Subpath within secret to mount', max_length=1024, null=True)),
            ],
            options={
                'verbose_name': 'KubernetesConfigVolumeMount',
            },
            bases=(models.Model, core.models.xosbase_header.PlModelMixIn),
        ),
        migrations.CreateModel(
            name='KubernetesData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, help_text=b'Time this model was created')),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer')),
                ('enacted', models.DateTimeField(blank=True, default=None, help_text=b'When synced, set to the timestamp of the data that was synced', null=True)),
                ('policed', models.DateTimeField(blank=True, default=None, help_text=b'When policed, set to the timestamp of the data that was policed', null=True)),
                ('backend_register', models.CharField(blank=True, default=b'{}', max_length=1024, null=True)),
                ('backend_need_delete', models.BooleanField(default=False)),
                ('backend_need_reap', models.BooleanField(default=False)),
                ('backend_status', models.CharField(default=b'Provisioning in progress', max_length=1024, null=True)),
                ('backend_code', models.IntegerField(default=0)),
                ('deleted', models.BooleanField(default=False)),
                ('write_protect', models.BooleanField(default=False)),
                ('lazy_blocked', models.BooleanField(default=False)),
                ('no_sync', models.BooleanField(default=False)),
                ('no_policy', models.BooleanField(default=False)),
                ('policy_status', models.CharField(blank=True, default=b'Policy in process', max_length=1024, null=True)),
                ('policy_code', models.IntegerField(blank=True, default=0, null=True)),
                ('leaf_model_name', models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024)),
                ('backend_need_delete_policy', models.BooleanField(default=False, help_text=b'True if delete model_policy must be run before object can be reaped')),
                ('xos_managed', models.BooleanField(default=True, help_text=b'True if xos is responsible for creating/deleting this object')),
                ('backend_handle', models.CharField(blank=True, help_text=b'Handle used by the backend to track this object', max_length=1024, null=True)),
                ('changed_by_step', models.DateTimeField(blank=True, default=None, help_text=b'Time this model was changed by a sync step', null=True)),
                ('changed_by_policy', models.DateTimeField(blank=True, default=None, help_text=b'Time this model was changed by a model policy', null=True)),
                ('name', models.CharField(blank=True, help_text=b'Name of this data store', max_length=256, null=True)),
                ('data', models.TextField(blank=True, help_text=b'Set of key,value pairs encoded as a json dictionary', null=True)),
            ],
            options={
                'verbose_name': 'KubernetesData',
            },
            bases=(models.Model, core.models.xosbase_header.PlModelMixIn),
        ),
        migrations.CreateModel(
            name='KubernetesResourceInstance',
            fields=[
                ('serviceinstance_decl_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.ServiceInstance_decl')),
                ('resource_definition', models.TextField(blank=True, help_text=b'yaml blob', null=True)),
                ('kubectl_state', models.CharField(blank=True, choices=[(b'created', b'CREATED'), (b'updated', b'UPDATED'), (b'deleted', b'DELETED')], help_text=b'Most recent state of kubectl', max_length=32, null=True)),
            ],
            options={
                'verbose_name': 'Kubernetes Resource Instance',
            },
            bases=('core.serviceinstance',),
        ),
        migrations.CreateModel(
            name='KubernetesSecretVolumeMount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, help_text=b'Time this model was created')),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer')),
                ('enacted', models.DateTimeField(blank=True, default=None, help_text=b'When synced, set to the timestamp of the data that was synced', null=True)),
                ('policed', models.DateTimeField(blank=True, default=None, help_text=b'When policed, set to the timestamp of the data that was policed', null=True)),
                ('backend_register', models.CharField(blank=True, default=b'{}', max_length=1024, null=True)),
                ('backend_need_delete', models.BooleanField(default=False)),
                ('backend_need_reap', models.BooleanField(default=False)),
                ('backend_status', models.CharField(default=b'Provisioning in progress', max_length=1024, null=True)),
                ('backend_code', models.IntegerField(default=0)),
                ('deleted', models.BooleanField(default=False)),
                ('write_protect', models.BooleanField(default=False)),
                ('lazy_blocked', models.BooleanField(default=False)),
                ('no_sync', models.BooleanField(default=False)),
                ('no_policy', models.BooleanField(default=False)),
                ('policy_status', models.CharField(blank=True, default=b'Policy in process', max_length=1024, null=True)),
                ('policy_code', models.IntegerField(blank=True, default=0, null=True)),
                ('leaf_model_name', models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024)),
                ('backend_need_delete_policy', models.BooleanField(default=False, help_text=b'True if delete model_policy must be run before object can be reaped')),
                ('xos_managed', models.BooleanField(default=True, help_text=b'True if xos is responsible for creating/deleting this object')),
                ('backend_handle', models.CharField(blank=True, help_text=b'Handle used by the backend to track this object', max_length=1024, null=True)),
                ('changed_by_step', models.DateTimeField(blank=True, default=None, help_text=b'Time this model was changed by a sync step', null=True)),
                ('changed_by_policy', models.DateTimeField(blank=True, default=None, help_text=b'Time this model was changed by a model policy', null=True)),
                ('mount_path', models.CharField(blank=True, help_text=b'Path to mount secret', max_length=256, null=True)),
                ('sub_path', models.CharField(blank=True, help_text=b'Subpath within secret to mount', max_length=1024, null=True)),
            ],
            options={
                'verbose_name': 'KubernetesSecretVolumeMount',
            },
            bases=(models.Model, core.models.xosbase_header.PlModelMixIn),
        ),
        migrations.CreateModel(
            name='KubernetesService',
            fields=[
                ('service_decl_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.Service_decl')),
            ],
            options={
                'verbose_name': 'Kubernetes Service',
            },
            bases=('core.service',),
        ),
        migrations.CreateModel(
            name='KubernetesServiceInstance',
            fields=[
                ('computeserviceinstance_decl_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.ComputeServiceInstance_decl')),
                ('pod_ip', models.CharField(blank=True, help_text=b'IP address of pod', max_length=32, null=True)),
                ('need_event', models.BooleanField(default=False, help_text=b'True if a kafka event needs to be sent by the pull step')),
                ('last_event_sent', models.CharField(blank=True, choices=[(b'created', b'CREATED'), (b'updated', b'UPDATED'), (b'deleted', b'DELETED')], help_text=b'Type of last event sent', max_length=32, null=True)),
            ],
            options={
                'verbose_name': 'Kubernetes Service Instance',
            },
            bases=('core.computeserviceinstance',),
        ),
        migrations.CreateModel(
            name='KubernetesConfigMap',
            fields=[
                ('kubernetesdata_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='kubernetes.KubernetesData')),
            ],
            options={
                'verbose_name': 'KubernetesConfigMap',
            },
            bases=('kubernetes.kubernetesdata',),
        ),
        migrations.CreateModel(
            name='KubernetesSecret',
            fields=[
                ('kubernetesdata_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='kubernetes.KubernetesData')),
            ],
            options={
                'verbose_name': 'KubernetesSecret',
            },
            bases=('kubernetes.kubernetesdata',),
        ),
        migrations.AddField(
            model_name='kubernetessecretvolumemount',
            name='service_instance',
            field=models.ForeignKey(help_text=b'Service instance in which to mount secret', on_delete=django.db.models.deletion.CASCADE, related_name='kubernetes_secret_volume_mounts', to='kubernetes.KubernetesServiceInstance'),
        ),
        migrations.AddField(
            model_name='kubernetesdata',
            name='trust_domain',
            field=models.ForeignKey(help_text=b'Trust domain this data resides in', on_delete=django.db.models.deletion.CASCADE, related_name='kubernetes_configmaps', to='core.TrustDomain'),
        ),
        migrations.AddField(
            model_name='kubernetesconfigvolumemount',
            name='service_instance',
            field=models.ForeignKey(help_text=b'Service instance in which to mount config', on_delete=django.db.models.deletion.CASCADE, related_name='kubernetes_config_volume_mounts', to='kubernetes.KubernetesServiceInstance'),
        ),
        migrations.AddField(
            model_name='kubernetessecretvolumemount',
            name='secret',
            field=models.ForeignKey(help_text=b'Secret to mount', on_delete=django.db.models.deletion.CASCADE, related_name='kubernetes_secret_volume_mounts', to='kubernetes.KubernetesSecret'),
        ),
        migrations.AddField(
            model_name='kubernetesconfigvolumemount',
            name='config',
            field=models.ForeignKey(help_text=b'Config to mount', on_delete=django.db.models.deletion.CASCADE, related_name='kubernetes_config_voume_mounts', to='kubernetes.KubernetesConfigMap'),
        ),
    ]
