/*
* Copyright (c) 2017 Sprint
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/****************
 Generated By: fdtool enhancements to diafuzzer
 License: same as freeDiameter
****************/


/* 
 * Dictionary definitions of objects specified in ts29344_avps (e10).
 */
#include <freeDiameter/extension.h>

#define PROTO_VER "e10"
#define GEN_DATE  1506697162.59

const char *ts29344_avps_proto_ver = PROTO_VER;
const double ts29344_avps_gen_date = GEN_DATE;

/* The content of this file follows the same structure as dict_base_proto.c */

#define CHECK_dict_new( _type, _data, _parent, _ref )                                     \
{                                                                                         \
    int _ret = fd_dict_new( fd_g_config->cnf_dict, (_type), (_data), (_parent), (_ref) ); \
    if ( _ret != 0 && _ret != EEXIST )                                                    \
       return _ret;                                                                       \
}

#define CHECK_dict_search( _type, _criteria, _what, _result )		\
    CHECK_FCT(  fd_dict_search( fd_g_config->cnf_dict, (_type), (_criteria), (_what), (_result), ENOENT) );

struct local_rules_definition {
    struct dict_avp_request avp_vendor_plus_name;
    enum rule_position	position;
    int 			min;
    int			max;
};

#define RULE_ORDER( _position ) ((((_position) == RULE_FIXED_HEAD) || ((_position) == RULE_FIXED_TAIL)) ? 1 : 0 )

/* Attention! This version of the macro uses AVP_BY_NAME_AND_VENDOR, in contrast to most other copies! */
#define PARSE_loc_rules( _rulearray, _parent) {                                                         \
        int __ar;                                                                                       \
        for (__ar=0; __ar < sizeof(_rulearray) / sizeof((_rulearray)[0]); __ar++) {                     \
                struct dict_rule_data __data = { NULL,                                                  \
                        (_rulearray)[__ar].position,                                                    \
                        0,                                                                              \
                        (_rulearray)[__ar].min,                                                         \
                        (_rulearray)[__ar].max};                                                        \
                __data.rule_order = RULE_ORDER(__data.rule_position);                                   \
                CHECK_FCT(  fd_dict_search(                                                             \
                        fd_g_config->cnf_dict,                                                          \
                        DICT_AVP,                                                                       \
                        AVP_BY_NAME_AND_VENDOR,                                                         \
                        &(_rulearray)[__ar].avp_vendor_plus_name,                                       \
                        &__data.rule_avp, 0 ) );                                                        \
                if ( !__data.rule_avp ) {                                                               \
                        TRACE_DEBUG(INFO, "AVP Not found: '%s'", (_rulearray)[__ar].avp_vendor_plus_name.avp_name);             \
                        return ENOENT;                                                                  \
                }                                                                                       \
                {                                                                                       \
                         int _ret = fd_dict_new( fd_g_config->cnf_dict, DICT_RULE, &(__data), (_parent), NULL ); \
                         if ( _ret != 0 && _ret != EEXIST )      {                                      \
                                TRACE_DEBUG(INFO, "Error on rule with AVP '%s'",                        \
                                            (_rulearray)[__ar].avp_vendor_plus_name.avp_name);          \
                                return EINVAL;                                                          \
                         }                                                                              \
                }                                                                                       \
        }                                                                                               \
}

#define CHECK_vendor_new( _data ) { \
        struct dict_object * vendor_found; \
        if (fd_dict_search(fd_g_config->cnf_dict,DICT_VENDOR,VENDOR_BY_ID,&_data.vendor_id,&vendor_found,ENOENT) == ENOENT) { \
                CHECK_FCT(fd_dict_new(fd_g_config->cnf_dict, DICT_VENDOR, &_data, NULL, NULL)); \
        } \
}

#define enumval_def_u32( _val_, _str_ )		\
    { _str_, 		{ .u32 = _val_ }}

#define enumval_def_os( _len_, _val_, _str_ )				\
    { _str_, 		{ .os = { .data = (unsigned char *)_val_, .len = _len_ }}}


static int dict_ts29344_avps_load_defs(char * conffile)
{
   TRACE_ENTRY("%p", conffile);
	/* Application Section */
	{
		/* Create the vendors */		{
			struct dict_vendor_data vendor_data = { 10415, "3GPP" };
			CHECK_dict_new(DICT_VENDOR, &vendor_data, NULL, NULL)
		}
	}


   /* AVP section */
   {
		struct dict_object * Address_type;
		struct dict_object * UTF8String_type;
		struct dict_object * DiameterIdentity_type;
		struct dict_object * DiameterURI_type;
		struct dict_object * Time_type;
		struct dict_object * IPFilterRule_type;

		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "Address", &Address_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "UTF8String", &UTF8String_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "DiameterIdentity", &DiameterIdentity_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "DiameterURI", &DiameterURI_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "Time", &Time_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "IPFilterRule", &IPFilterRule_type);
		/* ProSe-Permission */
		{
			struct dict_avp_data data = {
				3702,	/* Code */
				10415,	/* Vendor */
				"ProSe-Permission",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* ProSe-Direct-Allowed */
		{
			struct dict_avp_data data = {
				3704,	/* Code */
				10415,	/* Vendor */
				"ProSe-Direct-Allowed",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* UPR-Flags */
		{
			struct dict_avp_data data = {
				3705,	/* Code */
				10415,	/* Vendor */
				"UPR-Flags",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* PNR-Flags */
		{
			struct dict_avp_data data = {
				3706,	/* Code */
				10415,	/* Vendor */
				"PNR-Flags",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Authorized-Discovery-Range */
		{
			struct dict_avp_data data = {
				3708,	/* Code */
				10415,	/* Vendor */
				"Authorized-Discovery-Range",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* ProSe-Initial-Location-Information */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				3707,	/* Code */
				10415,	/* Vendor */
				"ProSe-Initial-Location-Information",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* ProSe-Allowed-PLMN */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				3703,	/* Code */
				10415,	/* Vendor */
				"ProSe-Allowed-PLMN",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* ProSe-Subscription-Data */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				3701,	/* Code */
				10415,	/* Vendor */
				"ProSe-Subscription-Data",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}

	
   }

   /* Commands section */
   {

   }

   return 0;
}

static int dict_ts29344_avps_load_rules(char * conffile)
{
   /* Grouped AVP section */
   {
	  /* ProSe-Initial-Location-Information */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 10415, .avp_name = "ProSe-Initial-Location-Information"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 10415, .avp_name = "MME-Name"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 10415, .avp_name = "E-UTRAN-Cell-Global-Identity"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 10415, .avp_name = "Tracking-Area-Identity"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 10415, .avp_name = "Age-Of-Location-Information"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* ProSe-Allowed-PLMN */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 10415, .avp_name = "ProSe-Allowed-PLMN"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 10415, .avp_name = "Visited-PLMN-Id"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 10415, .avp_name = "Authorized-Discovery-Range"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 10415, .avp_name = "ProSe-Direct-Allowed"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* ProSe-Subscription-Data */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 10415, .avp_name = "ProSe-Subscription-Data"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 10415, .avp_name = "ProSe-Permission"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 10415, .avp_name = "ProSe-Allowed-PLMN"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 10415, .avp_name = "3GPP-Charging-Characteristics"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }

   }	

   /* Commands section */
   {

   }

   LOG_D( "Extension 'Dictionary definitions for ts29344_avps (e10)' initialized");
   return 0;
}

int dict_entry(char * conffile)
{
	dict_ts29344_avps_load_defs(conffile);
	return dict_ts29344_avps_load_rules(conffile);
}

const char* dict_ts29344_avps_proto_ver(char * conffile) {
	return ts29344_avps_proto_ver;
}

const double dict_ts29344_avps_gen_ts(char * conffile) {
	return ts29344_avps_gen_date;
}

EXTENSION_ENTRY2("dict_ts29344_avps", dict_ts29344_avps_load_defs, dict_ts29344_avps_load_rules, "dict_ts29272_avps", "dict_ts29329_avps", "dict_ts29229_avps", "dict_ts29173_avps", "dict_ts29061_avps", "dict_draftload_avps", "dict_rfc7683_avps", "dict_rfc7944_avps");



