/*
* Copyright (c) 2017 Sprint
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/****************
 Generated By: fdtool enhancements to diafuzzer
 License: same as freeDiameter
****************/


/* 
 * Dictionary definitions of objects specified in rfc5777_avps.
 */
#include <freeDiameter/extension.h>

#define PROTO_VER "unspecified"
#define GEN_DATE  1506697143.56

const char *rfc5777_avps_proto_ver = PROTO_VER;
const double rfc5777_avps_gen_date = GEN_DATE;

/* The content of this file follows the same structure as dict_base_proto.c */

#define CHECK_dict_new( _type, _data, _parent, _ref )                                     \
{                                                                                         \
    int _ret = fd_dict_new( fd_g_config->cnf_dict, (_type), (_data), (_parent), (_ref) ); \
    if ( _ret != 0 && _ret != EEXIST )                                                    \
       return _ret;                                                                       \
}

#define CHECK_dict_search( _type, _criteria, _what, _result )		\
    CHECK_FCT(  fd_dict_search( fd_g_config->cnf_dict, (_type), (_criteria), (_what), (_result), ENOENT) );

struct local_rules_definition {
    struct dict_avp_request avp_vendor_plus_name;
    enum rule_position	position;
    int 			min;
    int			max;
};

#define RULE_ORDER( _position ) ((((_position) == RULE_FIXED_HEAD) || ((_position) == RULE_FIXED_TAIL)) ? 1 : 0 )

/* Attention! This version of the macro uses AVP_BY_NAME_AND_VENDOR, in contrast to most other copies! */
#define PARSE_loc_rules( _rulearray, _parent) {                                                         \
        int __ar;                                                                                       \
        for (__ar=0; __ar < sizeof(_rulearray) / sizeof((_rulearray)[0]); __ar++) {                     \
                struct dict_rule_data __data = { NULL,                                                  \
                        (_rulearray)[__ar].position,                                                    \
                        0,                                                                              \
                        (_rulearray)[__ar].min,                                                         \
                        (_rulearray)[__ar].max};                                                        \
                __data.rule_order = RULE_ORDER(__data.rule_position);                                   \
                CHECK_FCT(  fd_dict_search(                                                             \
                        fd_g_config->cnf_dict,                                                          \
                        DICT_AVP,                                                                       \
                        AVP_BY_NAME_AND_VENDOR,                                                         \
                        &(_rulearray)[__ar].avp_vendor_plus_name,                                       \
                        &__data.rule_avp, 0 ) );                                                        \
                if ( !__data.rule_avp ) {                                                               \
                        TRACE_DEBUG(INFO, "AVP Not found: '%s'", (_rulearray)[__ar].avp_vendor_plus_name.avp_name);             \
                        return ENOENT;                                                                  \
                }                                                                                       \
                {                                                                                       \
                         int _ret = fd_dict_new( fd_g_config->cnf_dict, DICT_RULE, &(__data), (_parent), NULL ); \
                         if ( _ret != 0 && _ret != EEXIST )      {                                      \
                                TRACE_DEBUG(INFO, "Error on rule with AVP '%s'",                        \
                                            (_rulearray)[__ar].avp_vendor_plus_name.avp_name);          \
                                return EINVAL;                                                          \
                         }                                                                              \
                }                                                                                       \
        }                                                                                               \
}

#define CHECK_vendor_new( _data ) { \
        struct dict_object * vendor_found; \
        if (fd_dict_search(fd_g_config->cnf_dict,DICT_VENDOR,VENDOR_BY_ID,&_data.vendor_id,&vendor_found,ENOENT) == ENOENT) { \
                CHECK_FCT(fd_dict_new(fd_g_config->cnf_dict, DICT_VENDOR, &_data, NULL, NULL)); \
        } \
}

#define enumval_def_u32( _val_, _str_ )		\
    { _str_, 		{ .u32 = _val_ }}

#define enumval_def_os( _len_, _val_, _str_ )				\
    { _str_, 		{ .os = { .data = (unsigned char *)_val_, .len = _len_ }}}


static int dict_rfc5777_avps_load_defs(char * conffile)
{
   TRACE_ENTRY("%p", conffile);

   /* AVP section */
   {
		struct dict_object * Address_type;
		struct dict_object * UTF8String_type;
		struct dict_object * DiameterIdentity_type;
		struct dict_object * DiameterURI_type;
		struct dict_object * Time_type;
		struct dict_object * IPFilterRule_type;

		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "Address", &Address_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "UTF8String", &UTF8String_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "DiameterIdentity", &DiameterIdentity_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "DiameterURI", &DiameterURI_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "Time", &Time_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "IPFilterRule", &IPFilterRule_type);
		/* Filter-Rule-Precedence */
		{
			struct dict_avp_data data = {
				510,	/* Code */
				0,	/* Vendor */
				"Filter-Rule-Precedence",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Classifier-ID */
		{
			struct dict_avp_data data = {
				512,	/* Code */
				0,	/* Vendor */
				"Classifier-ID",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Protocol */
		{
			struct dict_avp_data data = {
				513,	/* Code */
				0,	/* Vendor */
				"Protocol",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Protocol)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "HOPOPT", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "ICMP", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "IGMP", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "GGP", { .i32=3 }};
			struct dict_enumval_data        t_5 = { "IPv4", { .i32=4 }};
			struct dict_enumval_data        t_6 = { "ST", { .i32=5 }};
			struct dict_enumval_data        t_7 = { "TCP", { .i32=6 }};
			struct dict_enumval_data        t_8 = { "CBT", { .i32=7 }};
			struct dict_enumval_data        t_9 = { "EGP", { .i32=8 }};
			struct dict_enumval_data        t_10 = { "IGP", { .i32=9 }};
			struct dict_enumval_data        t_11 = { "BBN-RCC-MON", { .i32=10 }};
			struct dict_enumval_data        t_12 = { "NVP-II", { .i32=11 }};
			struct dict_enumval_data        t_13 = { "PUP", { .i32=12 }};
			struct dict_enumval_data        t_14 = { "ARGUS", { .i32=13 }};
			struct dict_enumval_data        t_15 = { "EMCON", { .i32=14 }};
			struct dict_enumval_data        t_16 = { "XNET", { .i32=15 }};
			struct dict_enumval_data        t_17 = { "CHAOS", { .i32=16 }};
			struct dict_enumval_data        t_18 = { "UDP", { .i32=17 }};
			struct dict_enumval_data        t_19 = { "MUX", { .i32=18 }};
			struct dict_enumval_data        t_20 = { "DCN-MEAS", { .i32=19 }};
			struct dict_enumval_data        t_21 = { "HMP", { .i32=20 }};
			struct dict_enumval_data        t_22 = { "PRM", { .i32=21 }};
			struct dict_enumval_data        t_23 = { "XNS-IDP", { .i32=22 }};
			struct dict_enumval_data        t_24 = { "TRUNK-1", { .i32=23 }};
			struct dict_enumval_data        t_25 = { "TRUNK-2", { .i32=24 }};
			struct dict_enumval_data        t_26 = { "LEAF-1", { .i32=25 }};
			struct dict_enumval_data        t_27 = { "LEAF-2", { .i32=26 }};
			struct dict_enumval_data        t_28 = { "RDP", { .i32=27 }};
			struct dict_enumval_data        t_29 = { "IRTP", { .i32=28 }};
			struct dict_enumval_data        t_30 = { "ISO-TP4", { .i32=29 }};
			struct dict_enumval_data        t_31 = { "NETBLT", { .i32=30 }};
			struct dict_enumval_data        t_32 = { "MFE-NSP", { .i32=31 }};
			struct dict_enumval_data        t_33 = { "MERIT-INP", { .i32=32 }};
			struct dict_enumval_data        t_34 = { "DCCP", { .i32=33 }};
			struct dict_enumval_data        t_35 = { "3PC", { .i32=34 }};
			struct dict_enumval_data        t_36 = { "IDPR", { .i32=35 }};
			struct dict_enumval_data        t_37 = { "XTP", { .i32=36 }};
			struct dict_enumval_data        t_38 = { "DDP", { .i32=37 }};
			struct dict_enumval_data        t_39 = { "IDPR-CMTP", { .i32=38 }};
			struct dict_enumval_data        t_40 = { "TPplusplus", { .i32=39 }};
			struct dict_enumval_data        t_41 = { "IL", { .i32=40 }};
			struct dict_enumval_data        t_42 = { "IPv6", { .i32=41 }};
			struct dict_enumval_data        t_43 = { "SDRP", { .i32=42 }};
			struct dict_enumval_data        t_44 = { "IPv6-Route", { .i32=43 }};
			struct dict_enumval_data        t_45 = { "IPv6-Frag", { .i32=44 }};
			struct dict_enumval_data        t_46 = { "IDRP", { .i32=45 }};
			struct dict_enumval_data        t_47 = { "RSVP", { .i32=46 }};
			struct dict_enumval_data        t_48 = { "GRE", { .i32=47 }};
			struct dict_enumval_data        t_49 = { "DSR", { .i32=48 }};
			struct dict_enumval_data        t_50 = { "BNA", { .i32=49 }};
			struct dict_enumval_data        t_51 = { "ESP", { .i32=50 }};
			struct dict_enumval_data        t_52 = { "AH", { .i32=51 }};
			struct dict_enumval_data        t_53 = { "I-NLSP", { .i32=52 }};
			struct dict_enumval_data        t_54 = { "SWIPE", { .i32=53 }};
			struct dict_enumval_data        t_55 = { "NARP", { .i32=54 }};
			struct dict_enumval_data        t_56 = { "MOBILE", { .i32=55 }};
			struct dict_enumval_data        t_57 = { "TLSP", { .i32=56 }};
			struct dict_enumval_data        t_58 = { "SKIP", { .i32=57 }};
			struct dict_enumval_data        t_59 = { "IPv6-ICMP", { .i32=58 }};
			struct dict_enumval_data        t_60 = { "IPv6-NoNxt", { .i32=59 }};
			struct dict_enumval_data        t_61 = { "IPv6-Opts", { .i32=60 }};
			struct dict_enumval_data        t_62 = { "CFTP", { .i32=62 }};
			struct dict_enumval_data        t_63 = { "SAT-EXPAK", { .i32=64 }};
			struct dict_enumval_data        t_64 = { "KRYPTOLAN", { .i32=65 }};
			struct dict_enumval_data        t_65 = { "RVD", { .i32=66 }};
			struct dict_enumval_data        t_66 = { "IPPC", { .i32=67 }};
			struct dict_enumval_data        t_67 = { "SAT-MON", { .i32=69 }};
			struct dict_enumval_data        t_68 = { "VISA", { .i32=70 }};
			struct dict_enumval_data        t_69 = { "IPCV", { .i32=71 }};
			struct dict_enumval_data        t_70 = { "CPNX", { .i32=72 }};
			struct dict_enumval_data        t_71 = { "CPHB", { .i32=73 }};
			struct dict_enumval_data        t_72 = { "WSN", { .i32=74 }};
			struct dict_enumval_data        t_73 = { "PVP", { .i32=75 }};
			struct dict_enumval_data        t_74 = { "BR-SAT-MON", { .i32=76 }};
			struct dict_enumval_data        t_75 = { "SUN-ND", { .i32=77 }};
			struct dict_enumval_data        t_76 = { "WB-MON", { .i32=78 }};
			struct dict_enumval_data        t_77 = { "WB-EXPAK", { .i32=79 }};
			struct dict_enumval_data        t_78 = { "ISO-IP", { .i32=80 }};
			struct dict_enumval_data        t_79 = { "VMTP", { .i32=81 }};
			struct dict_enumval_data        t_80 = { "SECURE-VMTP", { .i32=82 }};
			struct dict_enumval_data        t_81 = { "VINES", { .i32=83 }};
			struct dict_enumval_data        t_82 = { "TTP", { .i32=84 }};
			struct dict_enumval_data        t_83 = { "IPTM", { .i32=84 }};
			struct dict_enumval_data        t_84 = { "NSFNET-IGP", { .i32=85 }};
			struct dict_enumval_data        t_85 = { "DGP", { .i32=86 }};
			struct dict_enumval_data        t_86 = { "TCF", { .i32=87 }};
			struct dict_enumval_data        t_87 = { "EIGRP", { .i32=88 }};
			struct dict_enumval_data        t_88 = { "OSPFIGP", { .i32=89 }};
			struct dict_enumval_data        t_89 = { "Sprite-RPC", { .i32=90 }};
			struct dict_enumval_data        t_90 = { "LARP", { .i32=91 }};
			struct dict_enumval_data        t_91 = { "MTP", { .i32=92 }};
			struct dict_enumval_data        t_92 = { "AX_25", { .i32=93 }};
			struct dict_enumval_data        t_93 = { "IPIP", { .i32=94 }};
			struct dict_enumval_data        t_94 = { "MICP", { .i32=95 }};
			struct dict_enumval_data        t_95 = { "SCC-SP", { .i32=96 }};
			struct dict_enumval_data        t_96 = { "ETHERIP", { .i32=97 }};
			struct dict_enumval_data        t_97 = { "ENCAP", { .i32=98 }};
			struct dict_enumval_data        t_98 = { "GMTP", { .i32=100 }};
			struct dict_enumval_data        t_99 = { "IFMP", { .i32=101 }};
			struct dict_enumval_data        t_100 = { "PNNI", { .i32=102 }};
			struct dict_enumval_data        t_101 = { "PIM", { .i32=103 }};
			struct dict_enumval_data        t_102 = { "ARIS", { .i32=104 }};
			struct dict_enumval_data        t_103 = { "SCPS", { .i32=105 }};
			struct dict_enumval_data        t_104 = { "QNX", { .i32=106 }};
			struct dict_enumval_data        t_105 = { "A_N", { .i32=107 }};
			struct dict_enumval_data        t_106 = { "IPComp", { .i32=108 }};
			struct dict_enumval_data        t_107 = { "SNP", { .i32=109 }};
			struct dict_enumval_data        t_108 = { "Compaq-Peer", { .i32=110 }};
			struct dict_enumval_data        t_109 = { "IPX-in-IP", { .i32=111 }};
			struct dict_enumval_data        t_110 = { "VRRP", { .i32=112 }};
			struct dict_enumval_data        t_111 = { "PGM", { .i32=113 }};
			struct dict_enumval_data        t_112 = { "L2TP", { .i32=115 }};
			struct dict_enumval_data        t_113 = { "DDX", { .i32=116 }};
			struct dict_enumval_data        t_114 = { "IATP", { .i32=117 }};
			struct dict_enumval_data        t_115 = { "STP", { .i32=118 }};
			struct dict_enumval_data        t_116 = { "SRP", { .i32=119 }};
			struct dict_enumval_data        t_117 = { "UTI", { .i32=120 }};
			struct dict_enumval_data        t_118 = { "SMP", { .i32=121 }};
			struct dict_enumval_data        t_119 = { "SM", { .i32=122 }};
			struct dict_enumval_data        t_120 = { "PTP", { .i32=123 }};
			struct dict_enumval_data        t_121 = { "ISISoverIPv4", { .i32=124 }};
			struct dict_enumval_data        t_122 = { "FIRE", { .i32=125 }};
			struct dict_enumval_data        t_123 = { "CRTP", { .i32=126 }};
			struct dict_enumval_data        t_124 = { "CRUDP", { .i32=127 }};
			struct dict_enumval_data        t_125 = { "SSCOPMCE", { .i32=128 }};
			struct dict_enumval_data        t_126 = { "IPLT", { .i32=129 }};
			struct dict_enumval_data        t_127 = { "SPS", { .i32=130 }};
			struct dict_enumval_data        t_128 = { "PIPE", { .i32=131 }};
			struct dict_enumval_data        t_129 = { "SCTP", { .i32=132 }};
			struct dict_enumval_data        t_130 = { "FC", { .i32=133 }};
			struct dict_enumval_data        t_131 = { "RSVP-E2E-IGNORE", { .i32=134 }};
			struct dict_enumval_data        t_132 = { "MobilityHeader", { .i32=135 }};
			struct dict_enumval_data        t_133 = { "UDPLite", { .i32=136 }};
			struct dict_enumval_data        t_134 = { "MPLS-in-IP", { .i32=137 }};
			struct dict_enumval_data        t_135 = { "manet", { .i32=138 }};
			struct dict_enumval_data        t_136 = { "HIP", { .i32=139 }};
			struct dict_enumval_data        t_137 = { "Shim6", { .i32=140 }};
			struct dict_enumval_data        t_138 = { "WESP", { .i32=141 }};
			struct dict_enumval_data        t_139 = { "ROHC", { .i32=142 }};
			struct dict_enumval_data        t_140 = { "Reserved", { .i32=255 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_5, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_6, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_7, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_8, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_9, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_10, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_11, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_12, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_13, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_14, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_15, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_16, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_17, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_18, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_19, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_20, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_21, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_22, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_23, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_24, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_25, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_26, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_27, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_28, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_29, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_30, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_31, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_32, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_33, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_34, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_35, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_36, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_37, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_38, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_39, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_40, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_41, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_42, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_43, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_44, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_45, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_46, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_47, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_48, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_49, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_50, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_51, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_52, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_53, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_54, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_55, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_56, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_57, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_58, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_59, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_60, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_61, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_62, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_63, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_64, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_65, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_66, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_67, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_68, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_69, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_70, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_71, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_72, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_73, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_74, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_75, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_76, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_77, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_78, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_79, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_80, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_81, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_82, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_83, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_84, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_85, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_86, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_87, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_88, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_89, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_90, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_91, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_92, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_93, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_94, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_95, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_96, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_97, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_98, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_99, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_100, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_101, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_102, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_103, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_104, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_105, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_106, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_107, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_108, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_109, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_110, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_111, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_112, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_113, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_114, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_115, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_116, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_117, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_118, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_119, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_120, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_121, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_122, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_123, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_124, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_125, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_126, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_127, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_128, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_129, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_130, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_131, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_132, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_133, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_134, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_135, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_136, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_137, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_138, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_139, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_140, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Direction */
		{
			struct dict_avp_data data = {
				514,	/* Code */
				0,	/* Vendor */
				"Direction",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Direction)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "IN", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "OUT", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "BOTH", { .i32=2 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Negated */
		{
			struct dict_avp_data data = {
				517,	/* Code */
				0,	/* Vendor */
				"Negated",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Negated)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "False", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "True", { .i32=1 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* IP-Address */
		{
			struct dict_avp_data data = {
				518,	/* Code */
				0,	/* Vendor */
				"IP-Address",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, Address_type, NULL);
		};
		/* IP-Address-Start */
		{
			struct dict_avp_data data = {
				520,	/* Code */
				0,	/* Vendor */
				"IP-Address-Start",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, Address_type, NULL);
		};
		/* IP-Address-End */
		{
			struct dict_avp_data data = {
				521,	/* Code */
				0,	/* Vendor */
				"IP-Address-End",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, Address_type, NULL);
		};
		/* IP-Bit-Mask-Width */
		{
			struct dict_avp_data data = {
				523,	/* Code */
				0,	/* Vendor */
				"IP-Bit-Mask-Width",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* MAC-Address */
		{
			struct dict_avp_data data = {
				524,	/* Code */
				0,	/* Vendor */
				"MAC-Address",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* MAC-Address-Mask-Pattern */
		{
			struct dict_avp_data data = {
				526,	/* Code */
				0,	/* Vendor */
				"MAC-Address-Mask-Pattern",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* EUI64-Address */
		{
			struct dict_avp_data data = {
				527,	/* Code */
				0,	/* Vendor */
				"EUI64-Address",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* EUI64-Address-Mask-Pattern */
		{
			struct dict_avp_data data = {
				529,	/* Code */
				0,	/* Vendor */
				"EUI64-Address-Mask-Pattern",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Port */
		{
			struct dict_avp_data data = {
				530,	/* Code */
				0,	/* Vendor */
				"Port",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Port-Start */
		{
			struct dict_avp_data data = {
				532,	/* Code */
				0,	/* Vendor */
				"Port-Start",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Port-End */
		{
			struct dict_avp_data data = {
				533,	/* Code */
				0,	/* Vendor */
				"Port-End",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Use-Assigned-Address */
		{
			struct dict_avp_data data = {
				534,	/* Code */
				0,	/* Vendor */
				"Use-Assigned-Address",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Use-Assigned-Address)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "False", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "True", { .i32=1 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Diffserv-Code-Point */
		{
			struct dict_avp_data data = {
				535,	/* Code */
				0,	/* Vendor */
				"Diffserv-Code-Point",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Diffserv-Code-Point)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "CS0", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "CS1", { .i32=8 }};
			struct dict_enumval_data        t_3 = { "CS2", { .i32=16 }};
			struct dict_enumval_data        t_4 = { "CS3", { .i32=24 }};
			struct dict_enumval_data        t_5 = { "CS4", { .i32=32 }};
			struct dict_enumval_data        t_6 = { "CS5", { .i32=40 }};
			struct dict_enumval_data        t_7 = { "CS6", { .i32=48 }};
			struct dict_enumval_data        t_8 = { "CS7", { .i32=56 }};
			struct dict_enumval_data        t_9 = { "AF11", { .i32=10 }};
			struct dict_enumval_data        t_10 = { "AF12", { .i32=12 }};
			struct dict_enumval_data        t_11 = { "AF13", { .i32=14 }};
			struct dict_enumval_data        t_12 = { "AF21", { .i32=18 }};
			struct dict_enumval_data        t_13 = { "AF22", { .i32=20 }};
			struct dict_enumval_data        t_14 = { "AF23", { .i32=22 }};
			struct dict_enumval_data        t_15 = { "AF31", { .i32=26 }};
			struct dict_enumval_data        t_16 = { "AF32", { .i32=28 }};
			struct dict_enumval_data        t_17 = { "AF33", { .i32=30 }};
			struct dict_enumval_data        t_18 = { "AF41", { .i32=34 }};
			struct dict_enumval_data        t_19 = { "AF42", { .i32=36 }};
			struct dict_enumval_data        t_20 = { "AF43", { .i32=38 }};
			struct dict_enumval_data        t_21 = { "EF", { .i32=46 }};
			struct dict_enumval_data        t_22 = { "VOICE_ADMIT", { .i32=44 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_5, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_6, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_7, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_8, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_9, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_10, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_11, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_12, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_13, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_14, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_15, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_16, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_17, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_18, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_19, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_20, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_21, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_22, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Fragmentation-Flag */
		{
			struct dict_avp_data data = {
				536,	/* Code */
				0,	/* Vendor */
				"Fragmentation-Flag",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Fragmentation-Flag)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "DF", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "MF", { .i32=1 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* IP-Option-Type */
		{
			struct dict_avp_data data = {
				538,	/* Code */
				0,	/* Vendor */
				"IP-Option-Type",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(IP-Option-Type)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "EOOL", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "NOP", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "SEC", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "LSR", { .i32=3 }};
			struct dict_enumval_data        t_5 = { "TS", { .i32=4 }};
			struct dict_enumval_data        t_6 = { "E-SEC", { .i32=5 }};
			struct dict_enumval_data        t_7 = { "CIPSO", { .i32=6 }};
			struct dict_enumval_data        t_8 = { "RR", { .i32=7 }};
			struct dict_enumval_data        t_9 = { "SID", { .i32=8 }};
			struct dict_enumval_data        t_10 = { "SSR", { .i32=9 }};
			struct dict_enumval_data        t_11 = { "ZSU", { .i32=10 }};
			struct dict_enumval_data        t_12 = { "MTUP", { .i32=11 }};
			struct dict_enumval_data        t_13 = { "MTUR", { .i32=12 }};
			struct dict_enumval_data        t_14 = { "FINN", { .i32=13 }};
			struct dict_enumval_data        t_15 = { "VISA", { .i32=14 }};
			struct dict_enumval_data        t_16 = { "ENCODE", { .i32=15 }};
			struct dict_enumval_data        t_17 = { "IMITD", { .i32=16 }};
			struct dict_enumval_data        t_18 = { "EIP", { .i32=17 }};
			struct dict_enumval_data        t_19 = { "TR", { .i32=18 }};
			struct dict_enumval_data        t_20 = { "ADDEXT", { .i32=19 }};
			struct dict_enumval_data        t_21 = { "RTRALT", { .i32=20 }};
			struct dict_enumval_data        t_22 = { "SDB", { .i32=21 }};
			struct dict_enumval_data        t_23 = { "DPS", { .i32=23 }};
			struct dict_enumval_data        t_24 = { "UMP", { .i32=24 }};
			struct dict_enumval_data        t_25 = { "QS", { .i32=25 }};
			struct dict_enumval_data        t_26 = { "EXP", { .i32=30 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_5, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_6, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_7, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_8, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_9, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_10, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_11, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_12, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_13, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_14, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_15, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_16, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_17, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_18, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_19, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_20, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_21, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_22, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_23, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_24, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_25, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_26, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* IP-Option-Value */
		{
			struct dict_avp_data data = {
				539,	/* Code */
				0,	/* Vendor */
				"IP-Option-Value",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* TCP-Option-Type */
		{
			struct dict_avp_data data = {
				541,	/* Code */
				0,	/* Vendor */
				"TCP-Option-Type",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(TCP-Option-Type)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "EOL", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "NOP", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "MAX_SEG_SZ", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "Window_Scale", { .i32=3 }};
			struct dict_enumval_data        t_5 = { "SACK_Permitted", { .i32=4 }};
			struct dict_enumval_data        t_6 = { "SACK", { .i32=5 }};
			struct dict_enumval_data        t_7 = { "Echo", { .i32=6 }};
			struct dict_enumval_data        t_8 = { "Echo_Reply", { .i32=7 }};
			struct dict_enumval_data        t_9 = { "Timestamps", { .i32=8 }};
			struct dict_enumval_data        t_10 = { "PartialOrderConnectionPermitted", { .i32=9 }};
			struct dict_enumval_data        t_11 = { "PartialOrderServiceProfile", { .i32=10 }};
			struct dict_enumval_data        t_12 = { "CC", { .i32=11 }};
			struct dict_enumval_data        t_13 = { "CC_NEW", { .i32=12 }};
			struct dict_enumval_data        t_14 = { "CC_ECHO", { .i32=13 }};
			struct dict_enumval_data        t_15 = { "TCP_Alternate_Checksum_Request", { .i32=14 }};
			struct dict_enumval_data        t_16 = { "TCP_Alternate_Checksum_Data", { .i32=15 }};
			struct dict_enumval_data        t_17 = { "Skeeter", { .i32=16 }};
			struct dict_enumval_data        t_18 = { "Bubba", { .i32=17 }};
			struct dict_enumval_data        t_19 = { "Trailer_Checksum_Option", { .i32=18 }};
			struct dict_enumval_data        t_20 = { "MD5_Signature_Option", { .i32=19 }};
			struct dict_enumval_data        t_21 = { "SCPS_Capabilities", { .i32=20 }};
			struct dict_enumval_data        t_22 = { "Selective_Negative_Acknowledgements", { .i32=21 }};
			struct dict_enumval_data        t_23 = { "Record_Boundaries", { .i32=22 }};
			struct dict_enumval_data        t_24 = { "Corruption_experienced", { .i32=23 }};
			struct dict_enumval_data        t_25 = { "SNAP", { .i32=24 }};
			struct dict_enumval_data        t_26 = { "TCP_Compression_Filter", { .i32=26 }};
			struct dict_enumval_data        t_27 = { "Quick-Start_Response", { .i32=27 }};
			struct dict_enumval_data        t_28 = { "User_Timeout_Option", { .i32=28 }};
			struct dict_enumval_data        t_29 = { "TCP_Authentication_Option", { .i32=29 }};
			struct dict_enumval_data        t_30 = { "Multipath_TCP", { .i32=30 }};
			struct dict_enumval_data        t_31 = { "Reserved1", { .i32=31 }};
			struct dict_enumval_data        t_32 = { "Reserved2", { .i32=32 }};
			struct dict_enumval_data        t_33 = { "Reserved3", { .i32=33 }};
			struct dict_enumval_data        t_34 = { "TCP_Fast_Open_Cookie", { .i32=34 }};
			struct dict_enumval_data        t_35 = { "Reserved4", { .i32=69 }};
			struct dict_enumval_data        t_36 = { "Reserved5", { .i32=70 }};
			struct dict_enumval_data        t_37 = { "Reserved6", { .i32=76 }};
			struct dict_enumval_data        t_38 = { "Reserved7", { .i32=77 }};
			struct dict_enumval_data        t_39 = { "Reserved8", { .i32=78 }};
			struct dict_enumval_data        t_40 = { "RFC3692-style_Experiment_1", { .i32=253 }};
			struct dict_enumval_data        t_41 = { "RFC3692-style_Experiment_2", { .i32=254 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_5, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_6, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_7, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_8, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_9, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_10, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_11, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_12, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_13, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_14, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_15, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_16, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_17, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_18, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_19, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_20, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_21, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_22, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_23, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_24, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_25, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_26, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_27, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_28, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_29, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_30, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_31, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_32, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_33, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_34, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_35, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_36, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_37, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_38, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_39, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_40, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_41, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* TCP-Option-Value */
		{
			struct dict_avp_data data = {
				542,	/* Code */
				0,	/* Vendor */
				"TCP-Option-Value",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* TCP-Flag-Type */
		{
			struct dict_avp_data data = {
				544,	/* Code */
				0,	/* Vendor */
				"TCP-Flag-Type",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* ICMP-Type-Number */
		{
			struct dict_avp_data data = {
				546,	/* Code */
				0,	/* Vendor */
				"ICMP-Type-Number",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(ICMP-Type-Number)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "Echo_Reply", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "Destination_Unreachable", { .i32=3 }};
			struct dict_enumval_data        t_3 = { "Source_Quench", { .i32=4 }};
			struct dict_enumval_data        t_4 = { "Redirect", { .i32=5 }};
			struct dict_enumval_data        t_5 = { "Alternate_Host_Address", { .i32=6 }};
			struct dict_enumval_data        t_6 = { "Echo", { .i32=8 }};
			struct dict_enumval_data        t_7 = { "Router_Advertisement", { .i32=9 }};
			struct dict_enumval_data        t_8 = { "Router_Solicitation", { .i32=10 }};
			struct dict_enumval_data        t_9 = { "Time_Exceeded", { .i32=11 }};
			struct dict_enumval_data        t_10 = { "Parameter_Problem", { .i32=12 }};
			struct dict_enumval_data        t_11 = { "Timestamp", { .i32=13 }};
			struct dict_enumval_data        t_12 = { "Timestamp_Reply", { .i32=14 }};
			struct dict_enumval_data        t_13 = { "Information_Request", { .i32=15 }};
			struct dict_enumval_data        t_14 = { "Information_Reply", { .i32=16 }};
			struct dict_enumval_data        t_15 = { "Address_Mask_Request", { .i32=17 }};
			struct dict_enumval_data        t_16 = { "Address_Mask_Reply", { .i32=18 }};
			struct dict_enumval_data        t_17 = { "Traceroute", { .i32=30 }};
			struct dict_enumval_data        t_18 = { "Datagram_Conversion_Error", { .i32=31 }};
			struct dict_enumval_data        t_19 = { "Mobile_Host_Redirect", { .i32=32 }};
			struct dict_enumval_data        t_20 = { "IPv6_Where-Are-You", { .i32=33 }};
			struct dict_enumval_data        t_21 = { "IPv6_I-Am-Here", { .i32=34 }};
			struct dict_enumval_data        t_22 = { "Mobile_Registration_Request", { .i32=35 }};
			struct dict_enumval_data        t_23 = { "Mobile_Registration_Reply", { .i32=36 }};
			struct dict_enumval_data        t_24 = { "Domain_Name_Request", { .i32=37 }};
			struct dict_enumval_data        t_25 = { "Domain_Name_Reply", { .i32=38 }};
			struct dict_enumval_data        t_26 = { "SKIP", { .i32=39 }};
			struct dict_enumval_data        t_27 = { "Photuris", { .i32=40 }};
			struct dict_enumval_data        t_28 = { "ICMP_messages_utilized_by_experimental", { .i32=41 }};
			struct dict_enumval_data        t_29 = { "RFC3692-style_Experiment_1", { .i32=253 }};
			struct dict_enumval_data        t_30 = { "RFC3692-style_Experiment_2", { .i32=254 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_5, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_6, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_7, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_8, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_9, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_10, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_11, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_12, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_13, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_14, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_15, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_16, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_17, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_18, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_19, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_20, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_21, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_22, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_23, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_24, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_25, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_26, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_27, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_28, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_29, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_30, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* ICMP-Code */
		{
			struct dict_avp_data data = {
				547,	/* Code */
				0,	/* Vendor */
				"ICMP-Code",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(ICMP-Code)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "Echo_Reply", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "Destination_Unreachable", { .i32=3 }};
			struct dict_enumval_data        t_3 = { "Source_Quench", { .i32=4 }};
			struct dict_enumval_data        t_4 = { "Redirect", { .i32=5 }};
			struct dict_enumval_data        t_5 = { "Alternate_Host_Address", { .i32=6 }};
			struct dict_enumval_data        t_6 = { "Echo", { .i32=8 }};
			struct dict_enumval_data        t_7 = { "Router_Advertisement", { .i32=9 }};
			struct dict_enumval_data        t_8 = { "Router_Solicitation", { .i32=10 }};
			struct dict_enumval_data        t_9 = { "Time_Exceeded", { .i32=11 }};
			struct dict_enumval_data        t_10 = { "Parameter_Problem", { .i32=12 }};
			struct dict_enumval_data        t_11 = { "Timestamp", { .i32=13 }};
			struct dict_enumval_data        t_12 = { "Timestamp_Reply", { .i32=14 }};
			struct dict_enumval_data        t_13 = { "Information_Request", { .i32=15 }};
			struct dict_enumval_data        t_14 = { "Information_Reply", { .i32=16 }};
			struct dict_enumval_data        t_15 = { "Address_Mask_Request", { .i32=17 }};
			struct dict_enumval_data        t_16 = { "Address_Mask_Reply", { .i32=18 }};
			struct dict_enumval_data        t_17 = { "Traceroute", { .i32=30 }};
			struct dict_enumval_data        t_18 = { "Datagram_Conversion_Error", { .i32=31 }};
			struct dict_enumval_data        t_19 = { "Mobile_Host_Redirect", { .i32=32 }};
			struct dict_enumval_data        t_20 = { "IPv6_Where-Are-You", { .i32=33 }};
			struct dict_enumval_data        t_21 = { "IPv6_I-Am-Here", { .i32=34 }};
			struct dict_enumval_data        t_22 = { "Mobile_Registration_Request", { .i32=35 }};
			struct dict_enumval_data        t_23 = { "Mobile_Registration_Reply", { .i32=36 }};
			struct dict_enumval_data        t_24 = { "Domain_Name_Request", { .i32=37 }};
			struct dict_enumval_data        t_25 = { "Domain_Name_Reply", { .i32=38 }};
			struct dict_enumval_data        t_26 = { "SKIP", { .i32=39 }};
			struct dict_enumval_data        t_27 = { "Photuris", { .i32=40 }};
			struct dict_enumval_data        t_28 = { "ICMP_messages_utilized_by_experimental", { .i32=41 }};
			struct dict_enumval_data        t_29 = { "RFC3692-style_Experiment_1", { .i32=253 }};
			struct dict_enumval_data        t_30 = { "RFC3692-style_Experiment_2", { .i32=254 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_5, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_6, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_7, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_8, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_9, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_10, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_11, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_12, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_13, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_14, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_15, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_16, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_17, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_18, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_19, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_20, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_21, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_22, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_23, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_24, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_25, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_26, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_27, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_28, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_29, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_30, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* ETH-Ether-Type */
		{
			struct dict_avp_data data = {
				550,	/* Code */
				0,	/* Vendor */
				"ETH-Ether-Type",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* ETH-SAP */
		{
			struct dict_avp_data data = {
				551,	/* Code */
				0,	/* Vendor */
				"ETH-SAP",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* S-VID-Start */
		{
			struct dict_avp_data data = {
				553,	/* Code */
				0,	/* Vendor */
				"S-VID-Start",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* S-VID-End */
		{
			struct dict_avp_data data = {
				554,	/* Code */
				0,	/* Vendor */
				"S-VID-End",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* C-VID-Start */
		{
			struct dict_avp_data data = {
				555,	/* Code */
				0,	/* Vendor */
				"C-VID-Start",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* C-VID-End */
		{
			struct dict_avp_data data = {
				556,	/* Code */
				0,	/* Vendor */
				"C-VID-End",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Low-User-Priority */
		{
			struct dict_avp_data data = {
				558,	/* Code */
				0,	/* Vendor */
				"Low-User-Priority",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* High-User-Priority */
		{
			struct dict_avp_data data = {
				559,	/* Code */
				0,	/* Vendor */
				"High-User-Priority",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Time-Of-Day-Start */
		{
			struct dict_avp_data data = {
				561,	/* Code */
				0,	/* Vendor */
				"Time-Of-Day-Start",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Time-Of-Day-End */
		{
			struct dict_avp_data data = {
				562,	/* Code */
				0,	/* Vendor */
				"Time-Of-Day-End",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Day-Of-Week-Mask */
		{
			struct dict_avp_data data = {
				563,	/* Code */
				0,	/* Vendor */
				"Day-Of-Week-Mask",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Day-Of-Month-Mask */
		{
			struct dict_avp_data data = {
				564,	/* Code */
				0,	/* Vendor */
				"Day-Of-Month-Mask",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Month-Of-Year-Mask */
		{
			struct dict_avp_data data = {
				565,	/* Code */
				0,	/* Vendor */
				"Month-Of-Year-Mask",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Absolute-Start-Time */
		{
			struct dict_avp_data data = {
				566,	/* Code */
				0,	/* Vendor */
				"Absolute-Start-Time",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, Time_type, NULL);
		};
		/* Absolute-Start-Fractional-Seconds */
		{
			struct dict_avp_data data = {
				567,	/* Code */
				0,	/* Vendor */
				"Absolute-Start-Fractional-Seconds",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Absolute-End-Time */
		{
			struct dict_avp_data data = {
				568,	/* Code */
				0,	/* Vendor */
				"Absolute-End-Time",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, Time_type, NULL);
		};
		/* Absolute-End-Fractional-Seconds */
		{
			struct dict_avp_data data = {
				569,	/* Code */
				0,	/* Vendor */
				"Absolute-End-Fractional-Seconds",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Timezone-Flag */
		{
			struct dict_avp_data data = {
				570,	/* Code */
				0,	/* Vendor */
				"Timezone-Flag",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Timezone-Flag)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "UTC", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "LOCAL", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "OFFSET", { .i32=2 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Timezone-Offset */
		{
			struct dict_avp_data data = {
				571,	/* Code */
				0,	/* Vendor */
				"Timezone-Offset",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Treatment-Action */
		{
			struct dict_avp_data data = {
				572,	/* Code */
				0,	/* Vendor */
				"Treatment-Action",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Treatment-Action)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "drop", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "shape", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "mark", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "permit", { .i32=3 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* QoS-Profile-Id */
		{
			struct dict_avp_data data = {
				573,	/* Code */
				0,	/* Vendor */
				"QoS-Profile-Id",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* QoS-Semantics */
		{
			struct dict_avp_data data = {
				575,	/* Code */
				0,	/* Vendor */
				"QoS-Semantics",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(QoS-Semantics)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "QoS_Desired", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "QoS_Available", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "QoS_Delivered", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "Minimum_QoS", { .i32=3 }};
			struct dict_enumval_data        t_5 = { "QoS_Authorized", { .i32=4 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_5, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* QoS-Parameters */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				576,	/* Code */
				0,	/* Vendor */
				"QoS-Parameters",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* ETH-Proto-Type */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				549,	/* Code */
				0,	/* Vendor */
				"ETH-Proto-Type",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* VLAN-ID-Range */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				552,	/* Code */
				0,	/* Vendor */
				"VLAN-ID-Range",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* IP-Option */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				537,	/* Code */
				0,	/* Vendor */
				"IP-Option",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* IP-Address-Mask */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				522,	/* Code */
				0,	/* Vendor */
				"IP-Address-Mask",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Time-Of-Day-Condition */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				560,	/* Code */
				0,	/* Vendor */
				"Time-Of-Day-Condition",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* TCP-Option */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				540,	/* Code */
				0,	/* Vendor */
				"TCP-Option",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* MAC-Address-Mask */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				525,	/* Code */
				0,	/* Vendor */
				"MAC-Address-Mask",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* TCP-Flags */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				543,	/* Code */
				0,	/* Vendor */
				"TCP-Flags",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Port-Range */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				531,	/* Code */
				0,	/* Vendor */
				"Port-Range",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* ICMP-Type */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				545,	/* Code */
				0,	/* Vendor */
				"ICMP-Type",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* User-Priority-Range */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				557,	/* Code */
				0,	/* Vendor */
				"User-Priority-Range",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* QoS-Profile-Template */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				574,	/* Code */
				0,	/* Vendor */
				"QoS-Profile-Template",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* IP-Address-Range */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				519,	/* Code */
				0,	/* Vendor */
				"IP-Address-Range",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* EUI64-Address-Mask */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				528,	/* Code */
				0,	/* Vendor */
				"EUI64-Address-Mask",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* From-Spec */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				515,	/* Code */
				0,	/* Vendor */
				"From-Spec",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Excess-Treatment */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				577,	/* Code */
				0,	/* Vendor */
				"Excess-Treatment",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* ETH-Option */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				548,	/* Code */
				0,	/* Vendor */
				"ETH-Option",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* To-Spec */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				516,	/* Code */
				0,	/* Vendor */
				"To-Spec",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* QoS-Capability */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				578,	/* Code */
				0,	/* Vendor */
				"QoS-Capability",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Classifier */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				511,	/* Code */
				0,	/* Vendor */
				"Classifier",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Filter-Rule */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				509,	/* Code */
				0,	/* Vendor */
				"Filter-Rule",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* QoS-Resources */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				508,	/* Code */
				0,	/* Vendor */
				"QoS-Resources",	/* Name */
				0,	/* Fixed flags */
				0,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}

	
   }

   /* Commands section */
   {

   }

   return 0;
}

static int dict_rfc5777_avps_load_rules(char * conffile)
{
   /* Grouped AVP section */
   {
	  /* QoS-Parameters */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "QoS-Parameters"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{

		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* ETH-Proto-Type */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "ETH-Proto-Type"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "ETH-Ether-Type"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "ETH-SAP"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* VLAN-ID-Range */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "VLAN-ID-Range"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "S-VID-Start"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "S-VID-End"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "C-VID-Start"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "C-VID-End"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* IP-Option */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "IP-Option"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "IP-Option-Type"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "IP-Option-Value"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Negated"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* IP-Address-Mask */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "IP-Address-Mask"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "IP-Address"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "IP-Bit-Mask-Width"}, RULE_REQUIRED, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Time-Of-Day-Condition */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Time-Of-Day-Condition"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Time-Of-Day-Start"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Time-Of-Day-End"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Day-Of-Week-Mask"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Day-Of-Month-Mask"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Month-Of-Year-Mask"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Absolute-Start-Time"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Absolute-End-Time"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Timezone-Flag"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* TCP-Option */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "TCP-Option"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "TCP-Option-Type"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "TCP-Option-Value"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Negated"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* MAC-Address-Mask */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "MAC-Address-Mask"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "MAC-Address"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "MAC-Address-Mask-Pattern"}, RULE_REQUIRED, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* TCP-Flags */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "TCP-Flags"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "TCP-Flag-Type"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Negated"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Port-Range */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Port-Range"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Port-Start"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Port-End"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* ICMP-Type */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "ICMP-Type"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "ICMP-Type-Number"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "ICMP-Code"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Negated"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* User-Priority-Range */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "User-Priority-Range"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Low-User-Priority"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "High-User-Priority"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* QoS-Profile-Template */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "QoS-Profile-Template"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Vendor-Id"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "QoS-Profile-Id"}, RULE_REQUIRED, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* IP-Address-Range */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "IP-Address-Range"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "IP-Address-Start"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "IP-Address-End"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* EUI64-Address-Mask */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "EUI64-Address-Mask"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "EUI64-Address"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "EUI64-Address-Mask-Pattern"}, RULE_REQUIRED, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* From-Spec */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "From-Spec"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "IP-Address"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "IP-Address-Range"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "IP-Address-Mask"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "MAC-Address"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "MAC-Address-Mask"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "EUI64-Address"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "EUI64-Address-Mask"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Port"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Port-Range"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Negated"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Use-Assigned-Address"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Excess-Treatment */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Excess-Treatment"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Treatment-Action"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "QoS-Profile-Template"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "QoS-Parameters"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* ETH-Option */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "ETH-Option"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "ETH-Proto-Type"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "VLAN-ID-Range"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "User-Priority-Range"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* To-Spec */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "To-Spec"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "IP-Address"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "IP-Address-Range"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "IP-Address-Mask"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "MAC-Address"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "MAC-Address-Mask"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "EUI64-Address"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "EUI64-Address-Mask"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Port"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Port-Range"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Negated"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Use-Assigned-Address"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* QoS-Capability */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "QoS-Capability"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "QoS-Profile-Template"}, RULE_REQUIRED, 1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Classifier */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Classifier"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Classifier-ID"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Protocol"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Direction"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "From-Spec"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "To-Spec"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Diffserv-Code-Point"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Fragmentation-Flag"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "IP-Option"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "TCP-Option"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "TCP-Flags"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "ICMP-Type"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "ETH-Option"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Filter-Rule */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Filter-Rule"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Filter-Rule-Precedence"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Classifier"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Time-Of-Day-Condition"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Treatment-Action"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "QoS-Semantics"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "QoS-Profile-Template"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "QoS-Parameters"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Excess-Treatment"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* QoS-Resources */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "QoS-Resources"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Filter-Rule"}, RULE_REQUIRED, 1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }

   }	

   /* Commands section */
   {

   }

   LOG_D( "Extension 'Dictionary definitions for rfc5777_avps (None)' initialized");
   return 0;
}

int dict_entry(char * conffile)
{
	dict_rfc5777_avps_load_defs(conffile);
	return dict_rfc5777_avps_load_rules(conffile);
}

const char* dict_rfc5777_avps_proto_ver(char * conffile) {
	return rfc5777_avps_proto_ver;
}

const double dict_rfc5777_avps_gen_ts(char * conffile) {
	return rfc5777_avps_gen_date;
}

EXTENSION_ENTRY2("dict_rfc5777_avps", dict_rfc5777_avps_load_defs, dict_rfc5777_avps_load_rules);



