/*
* Copyright (c) 2017 Sprint
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/****************
 Generated By: fdtool enhancements to diafuzzer
 License: same as freeDiameter
****************/


/* 
 * Dictionary definitions of objects specified in rfc4006bis_avps.
 */
#include <freeDiameter/extension.h>

#define PROTO_VER "unspecified"
#define GEN_DATE  1506697143.49

const char *rfc4006bis_avps_proto_ver = PROTO_VER;
const double rfc4006bis_avps_gen_date = GEN_DATE;

/* The content of this file follows the same structure as dict_base_proto.c */

#define CHECK_dict_new( _type, _data, _parent, _ref )                                     \
{                                                                                         \
    int _ret = fd_dict_new( fd_g_config->cnf_dict, (_type), (_data), (_parent), (_ref) ); \
    if ( _ret != 0 && _ret != EEXIST )                                                    \
       return _ret;                                                                       \
}

#define CHECK_dict_search( _type, _criteria, _what, _result )		\
    CHECK_FCT(  fd_dict_search( fd_g_config->cnf_dict, (_type), (_criteria), (_what), (_result), ENOENT) );

struct local_rules_definition {
    struct dict_avp_request avp_vendor_plus_name;
    enum rule_position	position;
    int 			min;
    int			max;
};

#define RULE_ORDER( _position ) ((((_position) == RULE_FIXED_HEAD) || ((_position) == RULE_FIXED_TAIL)) ? 1 : 0 )

/* Attention! This version of the macro uses AVP_BY_NAME_AND_VENDOR, in contrast to most other copies! */
#define PARSE_loc_rules( _rulearray, _parent) {                                                         \
        int __ar;                                                                                       \
        for (__ar=0; __ar < sizeof(_rulearray) / sizeof((_rulearray)[0]); __ar++) {                     \
                struct dict_rule_data __data = { NULL,                                                  \
                        (_rulearray)[__ar].position,                                                    \
                        0,                                                                              \
                        (_rulearray)[__ar].min,                                                         \
                        (_rulearray)[__ar].max};                                                        \
                __data.rule_order = RULE_ORDER(__data.rule_position);                                   \
                CHECK_FCT(  fd_dict_search(                                                             \
                        fd_g_config->cnf_dict,                                                          \
                        DICT_AVP,                                                                       \
                        AVP_BY_NAME_AND_VENDOR,                                                         \
                        &(_rulearray)[__ar].avp_vendor_plus_name,                                       \
                        &__data.rule_avp, 0 ) );                                                        \
                if ( !__data.rule_avp ) {                                                               \
                        TRACE_DEBUG(INFO, "AVP Not found: '%s'", (_rulearray)[__ar].avp_vendor_plus_name.avp_name);             \
                        return ENOENT;                                                                  \
                }                                                                                       \
                {                                                                                       \
                         int _ret = fd_dict_new( fd_g_config->cnf_dict, DICT_RULE, &(__data), (_parent), NULL ); \
                         if ( _ret != 0 && _ret != EEXIST )      {                                      \
                                TRACE_DEBUG(INFO, "Error on rule with AVP '%s'",                        \
                                            (_rulearray)[__ar].avp_vendor_plus_name.avp_name);          \
                                return EINVAL;                                                          \
                         }                                                                              \
                }                                                                                       \
        }                                                                                               \
}

#define CHECK_vendor_new( _data ) { \
        struct dict_object * vendor_found; \
        if (fd_dict_search(fd_g_config->cnf_dict,DICT_VENDOR,VENDOR_BY_ID,&_data.vendor_id,&vendor_found,ENOENT) == ENOENT) { \
                CHECK_FCT(fd_dict_new(fd_g_config->cnf_dict, DICT_VENDOR, &_data, NULL, NULL)); \
        } \
}

#define enumval_def_u32( _val_, _str_ )		\
    { _str_, 		{ .u32 = _val_ }}

#define enumval_def_os( _len_, _val_, _str_ )				\
    { _str_, 		{ .os = { .data = (unsigned char *)_val_, .len = _len_ }}}


static int dict_rfc4006bis_avps_load_defs(char * conffile)
{
   TRACE_ENTRY("%p", conffile);

   /* AVP section */
   {
		struct dict_object * Address_type;
		struct dict_object * UTF8String_type;
		struct dict_object * DiameterIdentity_type;
		struct dict_object * DiameterURI_type;
		struct dict_object * Time_type;
		struct dict_object * IPFilterRule_type;

		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "Address", &Address_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "UTF8String", &UTF8String_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "DiameterIdentity", &DiameterIdentity_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "DiameterURI", &DiameterURI_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "Time", &Time_type);
		CHECK_dict_search( DICT_TYPE, TYPE_BY_NAME, "IPFilterRule", &IPFilterRule_type);
		/* CC-Correlation-Id */
		{
			struct dict_avp_data data = {
				411,	/* Code */
				0,	/* Vendor */
				"CC-Correlation-Id",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* CC-Input-Octets */
		{
			struct dict_avp_data data = {
				412,	/* Code */
				0,	/* Vendor */
				"CC-Input-Octets",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED64	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* CC-Output-Octets */
		{
			struct dict_avp_data data = {
				414,	/* Code */
				0,	/* Vendor */
				"CC-Output-Octets",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED64	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* CC-Request-Number */
		{
			struct dict_avp_data data = {
				415,	/* Code */
				0,	/* Vendor */
				"CC-Request-Number",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* CC-Request-Type */
		{
			struct dict_avp_data data = {
				416,	/* Code */
				0,	/* Vendor */
				"CC-Request-Type",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(CC-Request-Type)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "INITIAL_REQUEST", { .i32=1 }};
			struct dict_enumval_data        t_2 = { "UPDATE_REQUEST", { .i32=2 }};
			struct dict_enumval_data        t_3 = { "TERMINATION_REQUEST", { .i32=3 }};
			struct dict_enumval_data        t_4 = { "EVENT_REQUEST", { .i32=4 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* CC-Service-Specific-Units */
		{
			struct dict_avp_data data = {
				417,	/* Code */
				0,	/* Vendor */
				"CC-Service-Specific-Units",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED64	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* CC-Session-Failover */
		{
			struct dict_avp_data data = {
				418,	/* Code */
				0,	/* Vendor */
				"CC-Session-Failover",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(CC-Session-Failover)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "FAILOVER_NOT_SUPPORTED", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "FAILOVER_SUPPORTED", { .i32=1 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* CC-Sub-Session-Id */
		{
			struct dict_avp_data data = {
				419,	/* Code */
				0,	/* Vendor */
				"CC-Sub-Session-Id",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED64	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* CC-Time */
		{
			struct dict_avp_data data = {
				420,	/* Code */
				0,	/* Vendor */
				"CC-Time",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* CC-Total-Octets */
		{
			struct dict_avp_data data = {
				421,	/* Code */
				0,	/* Vendor */
				"CC-Total-Octets",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED64	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* CC-Unit-Type */
		{
			struct dict_avp_data data = {
				454,	/* Code */
				0,	/* Vendor */
				"CC-Unit-Type",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(CC-Unit-Type)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "TIME", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "MONEY", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "TOTAL_OCTETS", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "INPUT_OCTETS", { .i32=3 }};
			struct dict_enumval_data        t_5 = { "OUTPUT_OCTETS", { .i32=4 }};
			struct dict_enumval_data        t_6 = { "SERVICE_SPECIFIC_UNITS", { .i32=5 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_5, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_6, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Check-Balance-Result */
		{
			struct dict_avp_data data = {
				422,	/* Code */
				0,	/* Vendor */
				"Check-Balance-Result",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Check-Balance-Result)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "ENOUGH_CREDIT", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "NO_CREDIT", { .i32=1 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Cost-Unit */
		{
			struct dict_avp_data data = {
				424,	/* Code */
				0,	/* Vendor */
				"Cost-Unit",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Credit-Control */
		{
			struct dict_avp_data data = {
				426,	/* Code */
				0,	/* Vendor */
				"Credit-Control",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Credit-Control)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "CREDIT_AUTHORIZATION", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "RE_AUTHORIZATION", { .i32=1 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Credit-Control-Failure-Handling */
		{
			struct dict_avp_data data = {
				427,	/* Code */
				0,	/* Vendor */
				"Credit-Control-Failure-Handling",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Credit-Control-Failure-Handling)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "TERMINATE", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "CONTINUE", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "RETRY_AND_TERMINATE", { .i32=2 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Currency-Code */
		{
			struct dict_avp_data data = {
				425,	/* Code */
				0,	/* Vendor */
				"Currency-Code",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Direct-Debiting-Failure-Handling */
		{
			struct dict_avp_data data = {
				428,	/* Code */
				0,	/* Vendor */
				"Direct-Debiting-Failure-Handling",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Direct-Debiting-Failure-Handling)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "TERMINATE_OR_BUFFER", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "CONTINUE", { .i32=1 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Exponent */
		{
			struct dict_avp_data data = {
				429,	/* Code */
				0,	/* Vendor */
				"Exponent",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Final-Unit-Action */
		{
			struct dict_avp_data data = {
				449,	/* Code */
				0,	/* Vendor */
				"Final-Unit-Action",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Final-Unit-Action)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "TERMINATE", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "REDIRECT", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "RESTRICT_ACCESS", { .i32=2 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* G-S-U-Pool-Identifier */
		{
			struct dict_avp_data data = {
				453,	/* Code */
				0,	/* Vendor */
				"G-S-U-Pool-Identifier",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Multiple-Services-Indicator */
		{
			struct dict_avp_data data = {
				455,	/* Code */
				0,	/* Vendor */
				"Multiple-Services-Indicator",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Multiple-Services-Indicator)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "MULTIPLE_SERVICES_NOT_SUPPORTED", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "MULTIPLE_SERVICES_SUPPORTED", { .i32=1 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Rating-Group */
		{
			struct dict_avp_data data = {
				432,	/* Code */
				0,	/* Vendor */
				"Rating-Group",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Redirect-Address-Type */
		{
			struct dict_avp_data data = {
				433,	/* Code */
				0,	/* Vendor */
				"Redirect-Address-Type",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Redirect-Address-Type)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "IPv4_Address", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "IPv6_Address", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "URL", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "SIP_URI", { .i32=3 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Redirect-Server-Address */
		{
			struct dict_avp_data data = {
				435,	/* Code */
				0,	/* Vendor */
				"Redirect-Server-Address",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Redirect-Address-IPAddress */
		{
			struct dict_avp_data data = {
				99996,	/* Code */
				0,	/* Vendor */
				"Redirect-Address-IPAddress",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, Address_type, NULL);
		};
		/* Redirect-Address-URL */
		{
			struct dict_avp_data data = {
				99997,	/* Code */
				0,	/* Vendor */
				"Redirect-Address-URL",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Redirect-Address-SIP-URI */
		{
			struct dict_avp_data data = {
				99998,	/* Code */
				0,	/* Vendor */
				"Redirect-Address-SIP-URI",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Requested-Action */
		{
			struct dict_avp_data data = {
				436,	/* Code */
				0,	/* Vendor */
				"Requested-Action",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Requested-Action)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "DIRECT_DEBITING", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "REFUND_ACCOUNT", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "CHECK_BALANCE", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "PRICE_ENQUIRY", { .i32=3 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Restriction-Filter-Rule */
		{
			struct dict_avp_data data = {
				438,	/* Code */
				0,	/* Vendor */
				"Restriction-Filter-Rule",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, IPFilterRule_type, NULL);
		};
		/* Service-Context-Id */
		{
			struct dict_avp_data data = {
				461,	/* Code */
				0,	/* Vendor */
				"Service-Context-Id",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Service-Identifier */
		{
			struct dict_avp_data data = {
				439,	/* Code */
				0,	/* Vendor */
				"Service-Identifier",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Service-Parameter-Type */
		{
			struct dict_avp_data data = {
				441,	/* Code */
				0,	/* Vendor */
				"Service-Parameter-Type",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Service-Parameter-Value */
		{
			struct dict_avp_data data = {
				442,	/* Code */
				0,	/* Vendor */
				"Service-Parameter-Value",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Subscription-Id-Data */
		{
			struct dict_avp_data data = {
				444,	/* Code */
				0,	/* Vendor */
				"Subscription-Id-Data",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Subscription-Id-Type */
		{
			struct dict_avp_data data = {
				450,	/* Code */
				0,	/* Vendor */
				"Subscription-Id-Type",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Subscription-Id-Type)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "END_USER_E164", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "END_USER_IMSI", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "END_USER_SIP_URI", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "END_USER_NAI", { .i32=3 }};
			struct dict_enumval_data        t_5 = { "END_USER_PRIVATE", { .i32=4 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_5, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Subscription-Id-E164 */
		{
			struct dict_avp_data data = {
				99990,	/* Code */
				0,	/* Vendor */
				"Subscription-Id-E164",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Subscription-Id-IMSI */
		{
			struct dict_avp_data data = {
				99991,	/* Code */
				0,	/* Vendor */
				"Subscription-Id-IMSI",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Subscription-Id-SIP-URI */
		{
			struct dict_avp_data data = {
				99992,	/* Code */
				0,	/* Vendor */
				"Subscription-Id-SIP-URI",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Subscription-Id-NAI */
		{
			struct dict_avp_data data = {
				99993,	/* Code */
				0,	/* Vendor */
				"Subscription-Id-NAI",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Subscription-Id-Private */
		{
			struct dict_avp_data data = {
				99994,	/* Code */
				0,	/* Vendor */
				"Subscription-Id-Private",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, UTF8String_type, NULL);
		};
		/* Tariff-Change-Usage */
		{
			struct dict_avp_data data = {
				452,	/* Code */
				0,	/* Vendor */
				"Tariff-Change-Usage",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(Tariff-Change-Usage)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "UNIT_BEFORE_TARIFF_CHANGE", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "UNIT_AFTER_TARIFF_CHANGE", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "UNIT_INDETERMINATE", { .i32=2 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* Tariff-Time-Change */
		{
			struct dict_avp_data data = {
				451,	/* Code */
				0,	/* Vendor */
				"Tariff-Time-Change",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, Time_type, NULL);
		};
		/* User-Equipment-Info-Type */
		{
			struct dict_avp_data data = {
				459,	/* Code */
				0,	/* Vendor */
				"User-Equipment-Info-Type",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_INTEGER32	/* base type of data */
			};
			struct dict_object        *type;
			struct dict_type_data     tdata = { AVP_TYPE_INTEGER32, "Enumerated(User-Equipment-Info-Type)", NULL, NULL, NULL };
			struct dict_enumval_data        t_1 = { "IMEISV", { .i32=0 }};
			struct dict_enumval_data        t_2 = { "MAC", { .i32=1 }};
			struct dict_enumval_data        t_3 = { "EUI64", { .i32=2 }};
			struct dict_enumval_data        t_4 = { "MODIFIED_EUI64", { .i32=3 }};
			/* Create the Enumerated type, and then the AVP */
			CHECK_dict_new( DICT_TYPE, &tdata, NULL, &type);
			CHECK_dict_new( DICT_ENUMVAL, &t_1, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_2, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_3, type, NULL);
			CHECK_dict_new( DICT_ENUMVAL, &t_4, type, NULL);
			CHECK_dict_new( DICT_AVP, &data, type, NULL);
		};
		/* User-Equipment-Info-Value */
		{
			struct dict_avp_data data = {
				460,	/* Code */
				0,	/* Vendor */
				"User-Equipment-Info-Value",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* User-Equipment-Info-IMEISV */
		{
			struct dict_avp_data data = {
				99984,	/* Code */
				0,	/* Vendor */
				"User-Equipment-Info-IMEISV",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* User-Equipment-Info-MAC */
		{
			struct dict_avp_data data = {
				99985,	/* Code */
				0,	/* Vendor */
				"User-Equipment-Info-MAC",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* User-Equipment-Info-EUI64 */
		{
			struct dict_avp_data data = {
				99986,	/* Code */
				0,	/* Vendor */
				"User-Equipment-Info-EUI64",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* User-Equipment-Info-ModifiedEUI64 */
		{
			struct dict_avp_data data = {
				99987,	/* Code */
				0,	/* Vendor */
				"User-Equipment-Info-ModifiedEUI64",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* User-Equipment-Info-IMEI */
		{
			struct dict_avp_data data = {
				99988,	/* Code */
				0,	/* Vendor */
				"User-Equipment-Info-IMEI",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_OCTETSTRING	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Value-Digits */
		{
			struct dict_avp_data data = {
				447,	/* Code */
				0,	/* Vendor */
				"Value-Digits",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_INTEGER64	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Validity-Time */
		{
			struct dict_avp_data data = {
				448,	/* Code */
				0,	/* Vendor */
				"Validity-Time",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_UNSIGNED32	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data, NULL, NULL);
		};
		/* Subscription-Id-Extension */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				99989,	/* Code */
				0,	/* Vendor */
				"Subscription-Id-Extension",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Subscription-Id */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				443,	/* Code */
				0,	/* Vendor */
				"Subscription-Id",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Service-Parameter-Info */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				440,	/* Code */
				0,	/* Vendor */
				"Service-Parameter-Info",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* User-Equipment-Info */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				458,	/* Code */
				0,	/* Vendor */
				"User-Equipment-Info",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Unit-Value */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				445,	/* Code */
				0,	/* Vendor */
				"Unit-Value",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Redirect-Server-Extension */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				99995,	/* Code */
				0,	/* Vendor */
				"Redirect-Server-Extension",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Redirect-Server */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				434,	/* Code */
				0,	/* Vendor */
				"Redirect-Server",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* User-Equipment-Info-Extension */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				99983,	/* Code */
				0,	/* Vendor */
				"User-Equipment-Info-Extension",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* G-S-U-Pool-Reference */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				457,	/* Code */
				0,	/* Vendor */
				"G-S-U-Pool-Reference",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Final-Unit-Indication */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				430,	/* Code */
				0,	/* Vendor */
				"Final-Unit-Indication",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* CC-Money */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				413,	/* Code */
				0,	/* Vendor */
				"CC-Money",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Cost-Information */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				423,	/* Code */
				0,	/* Vendor */
				"Cost-Information",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Used-Service-Unit */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				446,	/* Code */
				0,	/* Vendor */
				"Used-Service-Unit",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Requested-Service-Unit */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				437,	/* Code */
				0,	/* Vendor */
				"Requested-Service-Unit",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Granted-Service-Unit */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				431,	/* Code */
				0,	/* Vendor */
				"Granted-Service-Unit",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* QoS-Final-Unit-Indication */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				99999,	/* Code */
				0,	/* Vendor */
				"QoS-Final-Unit-Indication",	/* Name */
				AVP_FLAG_VENDOR,	/* Fixed flags */
				AVP_FLAG_VENDOR,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}
		/* Multiple-Services-Credit-Control */
		{
			/* Grouped */
			struct dict_object * avp;
			struct dict_avp_data data = {
				456,	/* Code */
				0,	/* Vendor */
				"Multiple-Services-Credit-Control",	/* Name */
				AVP_FLAG_VENDOR | AVP_FLAG_MANDATORY,	/* Fixed flags */
				AVP_FLAG_MANDATORY,	/* Fixed flag values */
				AVP_TYPE_GROUPED	/* base type of data */
			};
			CHECK_dict_new( DICT_AVP, &data , NULL, &avp);
		}

	
   }

   /* Commands section */
   {

   }

   return 0;
}

static int dict_rfc4006bis_avps_load_rules(char * conffile)
{
   /* Grouped AVP section */
   {
	  /* Subscription-Id-Extension */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Subscription-Id-Extension"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Subscription-Id-E164"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Subscription-Id-IMSI"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Subscription-Id-SIP-URI"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Subscription-Id-NAI"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Subscription-Id-Private"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Subscription-Id */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Subscription-Id"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Subscription-Id-Type"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Subscription-Id-Data"}, RULE_REQUIRED, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Service-Parameter-Info */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Service-Parameter-Info"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Service-Parameter-Type"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Service-Parameter-Value"}, RULE_REQUIRED, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* User-Equipment-Info */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "User-Equipment-Info"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "User-Equipment-Info-Type"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "User-Equipment-Info-Value"}, RULE_REQUIRED, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Unit-Value */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Unit-Value"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Value-Digits"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Exponent"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Redirect-Server-Extension */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Redirect-Server-Extension"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Redirect-Address-IPAddress"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Redirect-Address-URL"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Redirect-Address-SIP-URI"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Redirect-Server */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Redirect-Server"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Redirect-Address-Type"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Redirect-Server-Address"}, RULE_REQUIRED, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* User-Equipment-Info-Extension */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "User-Equipment-Info-Extension"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "User-Equipment-Info-IMEISV"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "User-Equipment-Info-MAC"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "User-Equipment-Info-EUI64"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "User-Equipment-Info-ModifiedEUI64"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "User-Equipment-Info-IMEI"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* G-S-U-Pool-Reference */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "G-S-U-Pool-Reference"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "G-S-U-Pool-Identifier"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Unit-Type"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Unit-Value"}, RULE_REQUIRED, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Final-Unit-Indication */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Final-Unit-Indication"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Final-Unit-Action"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Restriction-Filter-Rule"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Filter-Id"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Redirect-Server"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* CC-Money */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "CC-Money"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Unit-Value"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Currency-Code"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Cost-Information */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Cost-Information"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Unit-Value"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Currency-Code"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Cost-Unit"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Used-Service-Unit */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Used-Service-Unit"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Tariff-Change-Usage"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Time"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Money"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Total-Octets"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Input-Octets"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Output-Octets"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Service-Specific-Units"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Requested-Service-Unit */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Requested-Service-Unit"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "CC-Time"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Money"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Total-Octets"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Input-Octets"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Output-Octets"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Service-Specific-Units"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Granted-Service-Unit */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Granted-Service-Unit"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Tariff-Time-Change"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Time"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Money"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Total-Octets"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Input-Octets"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Output-Octets"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "CC-Service-Specific-Units"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* QoS-Final-Unit-Indication */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "QoS-Final-Unit-Indication"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Final-Unit-Action"}, RULE_REQUIRED, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Filter-Rule"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Filter-Id"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Redirect-Server-Extension"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }
	  /* Multiple-Services-Credit-Control */
	  {
		/* Grouped */
		struct dict_object * avp;
		struct dict_avp_request avp_vendor_plus_name =  { .avp_vendor = 0, .avp_name = "Multiple-Services-Credit-Control"};
		CHECK_dict_search(DICT_AVP,  AVP_BY_NAME_AND_VENDOR, &avp_vendor_plus_name, &avp)
		struct local_rules_definition rules[] =
		{
			{ { .avp_vendor = 0, .avp_name = "Granted-Service-Unit"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Requested-Service-Unit"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Used-Service-Unit"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Tariff-Change-Usage"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Service-Identifier"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Rating-Group"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "G-S-U-Pool-Reference"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Validity-Time"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Result-Code"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "Final-Unit-Indication"}, RULE_OPTIONAL, -1, -1 },
			{ { .avp_vendor = 0, .avp_name = "QoS-Final-Unit-Indication"}, RULE_OPTIONAL, -1, -1 }
		};
		PARSE_loc_rules( rules, avp );
	  }

   }	

   /* Commands section */
   {

   }

   LOG_D( "Extension 'Dictionary definitions for rfc4006bis_avps (None)' initialized");
   return 0;
}

int dict_entry(char * conffile)
{
	dict_rfc4006bis_avps_load_defs(conffile);
	return dict_rfc4006bis_avps_load_rules(conffile);
}

const char* dict_rfc4006bis_avps_proto_ver(char * conffile) {
	return rfc4006bis_avps_proto_ver;
}

const double dict_rfc4006bis_avps_gen_ts(char * conffile) {
	return rfc4006bis_avps_gen_date;
}

EXTENSION_ENTRY2("dict_rfc4006bis_avps", dict_rfc4006bis_avps_load_defs, dict_rfc4006bis_avps_load_rules, "dict_rfc7155_avps", "dict_rfc5777_avps");



