#!/usr/bin/python
# coding: utf8
#Copyright © 2016 - 2017 Copyright (c) Sprint, Inc. and others.  All rights reserved.
#
#This program and the accompanying materials are made available under the
#terms of the Eclipse Public License v1.0 which accompanies this distribution,
#and is available at http://www.eclipse.org/legal/epl-v10.html

import zmq

def main():

    try:
        context = zmq.Context(1)

        # Socket facing clients
        frontend = context.socket(zmq.SUB)
        frontend.bind("tcp://192.168.105.14:5555")
        
        frontend.setsockopt(zmq.SUBSCRIBE, "")
        
         # Socket facing services
        backend = context.socket(zmq.PUB)
        backend.bind("tcp://192.168.105.14:5556")


        zmq.device(zmq.FORWARDER, frontend, backend)
    except Exception, e:
        print e
        print "bringing down zmq device"
    finally:
        pass
        frontend.close()
        backend.close()
        context.term()

if __name__ == "__main__":
    main()
