# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.
# See the file LICENSE.pyloxi which should have been included in the source distribution

# Automatically generated by LOXI from template oxm.py
# Do not modify

import struct
import const
import util
import loxi.generic_util
import loxi

def unpack(reader):
    type_len, = reader.peek('!L')
    if type_len in parsers:
        return parsers[type_len](reader)
    else:
        raise loxi.ProtocolError("unknown OXM cls=%#x type=%#x masked=%d len=%d (%#x)" % \
            ((type_len >> 16) & 0xffff, (type_len >> 9) & 0x7f, (type_len >> 8) & 1, type_len & 0xff, type_len))

def unpack_list(reader):
    return loxi.generic_util.unpack_list(reader, unpack)

class OXM(object):
    type_len = None # override in subclass
    pass

class arp_op(OXM):
    type_len = 2147494402

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_op()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147494402)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_op {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class arp_op_masked(OXM):
    type_len = 2147494660

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_op_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147494660)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_op_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class arp_sha(OXM):
    type_len = 2147495942

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_sha()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147495942)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_sha {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

class arp_sha_masked(OXM):
    type_len = 2147496204

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_sha_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147496204)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_sha_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

class arp_spa(OXM):
    type_len = 2147494916

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_spa()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147494916)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_spa {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class arp_spa_masked(OXM):
    type_len = 2147495176

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_spa_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147495176)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_spa_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class arp_tha(OXM):
    type_len = 2147496454

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_tha()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147496454)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_tha {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

class arp_tha_masked(OXM):
    type_len = 2147496716

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_tha_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147496716)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_tha_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

class arp_tpa(OXM):
    type_len = 2147495428

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_tpa()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147495428)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_tpa {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class arp_tpa_masked(OXM):
    type_len = 2147495688

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = arp_tpa_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147495688)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("arp_tpa_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class eth_dst(OXM):
    type_len = 2147485190

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = eth_dst()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147485190)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("eth_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

class eth_dst_masked(OXM):
    type_len = 2147485452

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = eth_dst_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147485452)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("eth_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

class eth_src(OXM):
    type_len = 2147485702

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = eth_src()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147485702)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("eth_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

class eth_src_masked(OXM):
    type_len = 2147485964

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = eth_src_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147485964)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("eth_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

class eth_type(OXM):
    type_len = 2147486210

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = eth_type()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147486210)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("eth_type {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class eth_type_masked(OXM):
    type_len = 2147486468

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = eth_type_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147486468)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("eth_type_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class icmpv4_code(OXM):
    type_len = 2147493889

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = icmpv4_code()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147493889)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("icmpv4_code {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class icmpv4_code_masked(OXM):
    type_len = 2147494146

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = icmpv4_code_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147494146)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("icmpv4_code_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class icmpv4_type(OXM):
    type_len = 2147493377

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = icmpv4_type()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147493377)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("icmpv4_type {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class icmpv4_type_masked(OXM):
    type_len = 2147493634

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = icmpv4_type_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147493634)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("icmpv4_type_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class icmpv6_code(OXM):
    type_len = 2147499009

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = icmpv6_code()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147499009)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("icmpv6_code {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class icmpv6_code_masked(OXM):
    type_len = 2147499266

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = icmpv6_code_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147499266)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("icmpv6_code_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class icmpv6_type(OXM):
    type_len = 2147498497

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = icmpv6_type()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147498497)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("icmpv6_type {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class icmpv6_type_masked(OXM):
    type_len = 2147498754

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = icmpv6_type_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147498754)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("icmpv6_type_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class in_phy_port(OXM):
    type_len = 2147484164

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_port_no(self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = in_phy_port()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147484164)
        obj.value = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("in_phy_port {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_port(self.value))
            q.breakable()
        q.text('}')

class in_phy_port_masked(OXM):
    type_len = 2147484424

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_port_no(self.value))
        packed.append(util.pack_port_no(self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = in_phy_port_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147484424)
        obj.value = util.unpack_port_no(reader)
        obj.value_mask = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("in_phy_port_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_port(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_port(self.value_mask))
            q.breakable()
        q.text('}')

class in_port(OXM):
    type_len = 2147483652

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_port_no(self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = in_port()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147483652)
        obj.value = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("in_port {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_port(self.value))
            q.breakable()
        q.text('}')

class in_port_masked(OXM):
    type_len = 2147483912

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(util.pack_port_no(self.value))
        packed.append(util.pack_port_no(self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = in_port_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147483912)
        obj.value = util.unpack_port_no(reader)
        obj.value_mask = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("in_port_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_port(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_port(self.value_mask))
            q.breakable()
        q.text('}')

class ip_dscp(OXM):
    type_len = 2147487745

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ip_dscp()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147487745)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ip_dscp {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class ip_dscp_masked(OXM):
    type_len = 2147488002

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ip_dscp_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147488002)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ip_dscp_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class ip_ecn(OXM):
    type_len = 2147488257

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ip_ecn()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147488257)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ip_ecn {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class ip_ecn_masked(OXM):
    type_len = 2147488514

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ip_ecn_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147488514)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ip_ecn_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class ip_proto(OXM):
    type_len = 2147488769

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ip_proto()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147488769)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ip_proto {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class ip_proto_masked(OXM):
    type_len = 2147489026

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ip_proto_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147489026)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ip_proto_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class ipv4_dst(OXM):
    type_len = 2147489796

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv4_dst()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147489796)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv4_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

class ipv4_dst_masked(OXM):
    type_len = 2147490056

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv4_dst_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147490056)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv4_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_ipv4(self.value_mask))
            q.breakable()
        q.text('}')

class ipv4_src(OXM):
    type_len = 2147489284

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv4_src()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147489284)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv4_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
            q.breakable()
        q.text('}')

class ipv4_src_masked(OXM):
    type_len = 2147489544

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv4_src_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147489544)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv4_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_ipv4(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_ipv4(self.value_mask))
            q.breakable()
        q.text('}')

class ipv6_dst(OXM):
    type_len = 2147497488

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_dst()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147497488)
        obj.value = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

class ipv6_dst_masked(OXM):
    type_len = 2147497760

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        packed.append(struct.pack("!16s", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_dst_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147497760)
        obj.value = reader.read('!16s')[0]
        obj.value_mask = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.pp(self.value_mask)
            q.breakable()
        q.text('}')

class ipv6_flabel(OXM):
    type_len = 2147497988

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_flabel()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147497988)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_flabel {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class ipv6_flabel_masked(OXM):
    type_len = 2147498248

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_flabel_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147498248)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_flabel_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class ipv6_nd_sll(OXM):
    type_len = 2147500038

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_nd_sll()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147500038)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_nd_sll {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

class ipv6_nd_sll_masked(OXM):
    type_len = 2147500300

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_nd_sll_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147500300)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_nd_sll_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

class ipv6_nd_target(OXM):
    type_len = 2147499536

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_nd_target()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147499536)
        obj.value = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_nd_target {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

class ipv6_nd_target_masked(OXM):
    type_len = 2147499808

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        packed.append(struct.pack("!16s", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_nd_target_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147499808)
        obj.value = reader.read('!16s')[0]
        obj.value_mask = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_nd_target_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.pp(self.value_mask)
            q.breakable()
        q.text('}')

class ipv6_nd_tll(OXM):
    type_len = 2147500550

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_nd_tll()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147500550)
        obj.value = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_nd_tll {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
            q.breakable()
        q.text('}')

class ipv6_nd_tll_masked(OXM):
    type_len = 2147500812

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = [0,0,0,0,0,0]
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!6B", *self.value))
        packed.append(struct.pack("!6B", *self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_nd_tll_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147500812)
        obj.value = list(reader.read('!6B'))
        obj.value_mask = list(reader.read('!6B'))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_nd_tll_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text(util.pretty_mac(self.value))
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text(util.pretty_mac(self.value_mask))
            q.breakable()
        q.text('}')

class ipv6_src(OXM):
    type_len = 2147496976

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_src()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147496976)
        obj.value = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')

class ipv6_src_masked(OXM):
    type_len = 2147497248

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!16s", self.value))
        packed.append(struct.pack("!16s", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = ipv6_src_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147497248)
        obj.value = reader.read('!16s')[0]
        obj.value_mask = reader.read('!16s')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("ipv6_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.pp(self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.pp(self.value_mask)
            q.breakable()
        q.text('}')

class metadata(OXM):
    type_len = 2147484680

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!Q", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = metadata()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147484680)
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("metadata {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class metadata_masked(OXM):
    type_len = 2147484944

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!Q", self.value))
        packed.append(struct.pack("!Q", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = metadata_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147484944)
        obj.value = reader.read("!Q")[0]
        obj.value_mask = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("metadata_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class mpls_label(OXM):
    type_len = 2147501060

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = mpls_label()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147501060)
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("mpls_label {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class mpls_label_masked(OXM):
    type_len = 2147501320

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!L", self.value))
        packed.append(struct.pack("!L", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = mpls_label_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147501320)
        obj.value = reader.read("!L")[0]
        obj.value_mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("mpls_label_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class mpls_tc(OXM):
    type_len = 2147501569

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = mpls_tc()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147501569)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("mpls_tc {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class mpls_tc_masked(OXM):
    type_len = 2147501826

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = mpls_tc_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147501826)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("mpls_tc_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class sctp_dst(OXM):
    type_len = 2147492866

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = sctp_dst()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147492866)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("sctp_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class sctp_dst_masked(OXM):
    type_len = 2147493124

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = sctp_dst_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147493124)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("sctp_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class sctp_src(OXM):
    type_len = 2147492354

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = sctp_src()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147492354)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("sctp_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class sctp_src_masked(OXM):
    type_len = 2147492612

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = sctp_src_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147492612)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("sctp_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class tcp_dst(OXM):
    type_len = 2147490818

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = tcp_dst()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147490818)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("tcp_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class tcp_dst_masked(OXM):
    type_len = 2147491076

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = tcp_dst_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147491076)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("tcp_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class tcp_src(OXM):
    type_len = 2147490306

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = tcp_src()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147490306)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("tcp_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class tcp_src_masked(OXM):
    type_len = 2147490564

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = tcp_src_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147490564)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("tcp_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class udp_dst(OXM):
    type_len = 2147491842

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = udp_dst()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147491842)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("udp_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class udp_dst_masked(OXM):
    type_len = 2147492100

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = udp_dst_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147492100)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("udp_dst_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class udp_src(OXM):
    type_len = 2147491330

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = udp_src()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147491330)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("udp_src {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class udp_src_masked(OXM):
    type_len = 2147491588

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = udp_src_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147491588)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("udp_src_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class vlan_pcp(OXM):
    type_len = 2147487233

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = vlan_pcp()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147487233)
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("vlan_pcp {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class vlan_pcp_masked(OXM):
    type_len = 2147487490

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!B", self.value))
        packed.append(struct.pack("!B", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = vlan_pcp_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147487490)
        obj.value = reader.read("!B")[0]
        obj.value_mask = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("vlan_pcp_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')

class vlan_vid(OXM):
    type_len = 2147486722

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = vlan_vid()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147486722)
        obj.value = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("vlan_vid {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')

class vlan_vid_masked(OXM):
    type_len = 2147486980

    def __init__(self, value=None, value_mask=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        if value_mask != None:
            self.value_mask = value_mask
        else:
            self.value_mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.type_len))
        packed.append(struct.pack("!H", self.value))
        packed.append(struct.pack("!H", self.value_mask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = vlan_vid_masked()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type_len = reader.read("!L")[0]
        assert(_type_len == 2147486980)
        obj.value = reader.read("!H")[0]
        obj.value_mask = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        if self.value_mask != other.value_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("vlan_vid_masked {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
                q.text(","); q.breakable()
                q.text("value_mask = ");
                q.text("%#x" % self.value_mask)
            q.breakable()
        q.text('}')


parsers = {
    2147483652 : in_port.unpack,
    2147483912 : in_port_masked.unpack,
    2147484164 : in_phy_port.unpack,
    2147484424 : in_phy_port_masked.unpack,
    2147484680 : metadata.unpack,
    2147484944 : metadata_masked.unpack,
    2147485190 : eth_dst.unpack,
    2147485452 : eth_dst_masked.unpack,
    2147485702 : eth_src.unpack,
    2147485964 : eth_src_masked.unpack,
    2147486210 : eth_type.unpack,
    2147486468 : eth_type_masked.unpack,
    2147486722 : vlan_vid.unpack,
    2147486980 : vlan_vid_masked.unpack,
    2147487233 : vlan_pcp.unpack,
    2147487490 : vlan_pcp_masked.unpack,
    2147487745 : ip_dscp.unpack,
    2147488002 : ip_dscp_masked.unpack,
    2147488257 : ip_ecn.unpack,
    2147488514 : ip_ecn_masked.unpack,
    2147488769 : ip_proto.unpack,
    2147489026 : ip_proto_masked.unpack,
    2147489284 : ipv4_src.unpack,
    2147489544 : ipv4_src_masked.unpack,
    2147489796 : ipv4_dst.unpack,
    2147490056 : ipv4_dst_masked.unpack,
    2147490306 : tcp_src.unpack,
    2147490564 : tcp_src_masked.unpack,
    2147490818 : tcp_dst.unpack,
    2147491076 : tcp_dst_masked.unpack,
    2147491330 : udp_src.unpack,
    2147491588 : udp_src_masked.unpack,
    2147491842 : udp_dst.unpack,
    2147492100 : udp_dst_masked.unpack,
    2147492354 : sctp_src.unpack,
    2147492612 : sctp_src_masked.unpack,
    2147492866 : sctp_dst.unpack,
    2147493124 : sctp_dst_masked.unpack,
    2147493377 : icmpv4_type.unpack,
    2147493634 : icmpv4_type_masked.unpack,
    2147493889 : icmpv4_code.unpack,
    2147494146 : icmpv4_code_masked.unpack,
    2147494402 : arp_op.unpack,
    2147494660 : arp_op_masked.unpack,
    2147494916 : arp_spa.unpack,
    2147495176 : arp_spa_masked.unpack,
    2147495428 : arp_tpa.unpack,
    2147495688 : arp_tpa_masked.unpack,
    2147495942 : arp_sha.unpack,
    2147496204 : arp_sha_masked.unpack,
    2147496454 : arp_tha.unpack,
    2147496716 : arp_tha_masked.unpack,
    2147496976 : ipv6_src.unpack,
    2147497248 : ipv6_src_masked.unpack,
    2147497488 : ipv6_dst.unpack,
    2147497760 : ipv6_dst_masked.unpack,
    2147497988 : ipv6_flabel.unpack,
    2147498248 : ipv6_flabel_masked.unpack,
    2147498497 : icmpv6_type.unpack,
    2147498754 : icmpv6_type_masked.unpack,
    2147499009 : icmpv6_code.unpack,
    2147499266 : icmpv6_code_masked.unpack,
    2147499536 : ipv6_nd_target.unpack,
    2147499808 : ipv6_nd_target_masked.unpack,
    2147500038 : ipv6_nd_sll.unpack,
    2147500300 : ipv6_nd_sll_masked.unpack,
    2147500550 : ipv6_nd_tll.unpack,
    2147500812 : ipv6_nd_tll_masked.unpack,
    2147501060 : mpls_label.unpack,
    2147501320 : mpls_label_masked.unpack,
    2147501569 : mpls_tc.unpack,
    2147501826 : mpls_tc_masked.unpack,
}
