
# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.
# See the file LICENSE.pyloxi which should have been included in the source distribution

# Automatically generated by LOXI from template module.py
# Do not modify

import struct
import loxi
import util
import loxi.generic_util

import sys
ofp = sys.modules['loxi.of13']

class action(loxi.OFObject):
    subtypes = {}


    def __init__(self, type=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 0)
        subclass = action.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = action()
        obj.type = reader.read("!H")[0]
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        return True

    def pretty_print(self, q):
        q.text("action {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')


class experimenter(action):
    subtypes = {}

    type = 65535

    def __init__(self, experimenter=None, data=None):
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed.append(loxi.generic_util.pad_to(8, length))
        length += len(packed[-1])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 4)
        subclass = experimenter.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = experimenter()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.experimenter = reader.read("!L")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("experimenter {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

action.subtypes[65535] = experimenter
"""
class bsn(experimenter):
    subtypes = {}

    type = 65535
    experimenter = 6035143

    def __init__(self, subtype=None):
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 8)
        subclass = bsn.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = bsn()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        obj.subtype = reader.read("!L")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.subtype != other.subtype: return False
        return True

    def pretty_print(self, q):
        q.text("bsn {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

experimenter.subtypes[6035143] = bsn

class bsn_checksum(bsn):
    type = 65535
    experimenter = 6035143
    subtype = 4

    def __init__(self, checksum=None):
        if checksum != None:
            self.checksum = checksum
        else:
            self.checksum = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(util.pack_checksum_128(self.checksum))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_checksum()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 4)
        obj.checksum = util.unpack_checksum_128(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.checksum != other.checksum: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_checksum {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("checksum = ");
                q.pp(self.checksum)
            q.breakable()
        q.text('}')

bsn.subtypes[4] = bsn_checksum

class bsn_gentable(bsn):
    type = 65535
    experimenter = 6035143
    subtype = 5

    def __init__(self, table_id=None, key=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if key != None:
            self.key = key
        else:
            self.key = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.table_id))
        packed.append(loxi.generic_util.pack_list(self.key))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_gentable()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 5)
        obj.table_id = reader.read("!L")[0]
        obj.key = loxi.generic_util.unpack_list(reader, ofp.bsn_tlv.bsn_tlv.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.key != other.key: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_gentable {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("key = ");
                q.pp(self.key)
            q.breakable()
        q.text('}')

bsn.subtypes[5] = bsn_gentable

class bsn_mirror(bsn):
    type = 65535
    experimenter = 6035143
    subtype = 1

    def __init__(self, dest_port=None, vlan_tag=None, copy_stage=None):
        if dest_port != None:
            self.dest_port = dest_port
        else:
            self.dest_port = 0
        if vlan_tag != None:
            self.vlan_tag = vlan_tag
        else:
            self.vlan_tag = 0
        if copy_stage != None:
            self.copy_stage = copy_stage
        else:
            self.copy_stage = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.dest_port))
        packed.append(struct.pack("!L", self.vlan_tag))
        packed.append(struct.pack("!B", self.copy_stage))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_mirror()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 1)
        obj.dest_port = reader.read("!L")[0]
        obj.vlan_tag = reader.read("!L")[0]
        obj.copy_stage = reader.read("!B")[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.dest_port != other.dest_port: return False
        if self.vlan_tag != other.vlan_tag: return False
        if self.copy_stage != other.copy_stage: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_mirror {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("dest_port = ");
                q.text("%#x" % self.dest_port)
                q.text(","); q.breakable()
                q.text("vlan_tag = ");
                q.text("%#x" % self.vlan_tag)
                q.text(","); q.breakable()
                q.text("copy_stage = ");
                q.text("%#x" % self.copy_stage)
            q.breakable()
        q.text('}')

bsn.subtypes[1] = bsn_mirror

class bsn_set_tunnel_dst(bsn):
    type = 65535
    experimenter = 6035143
    subtype = 2

    def __init__(self, dst=None):
        if dst != None:
            self.dst = dst
        else:
            self.dst = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.dst))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_set_tunnel_dst()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 2)
        obj.dst = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.dst != other.dst: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_set_tunnel_dst {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("dst = ");
                q.text("%#x" % self.dst)
            q.breakable()
        q.text('}')

bsn.subtypes[2] = bsn_set_tunnel_dst
"""

class copy_ttl_in(action):
    type = 12

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = copy_ttl_in()
        _type = reader.read("!H")[0]
        assert(_type == 12)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("copy_ttl_in {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

action.subtypes[12] = copy_ttl_in

class copy_ttl_out(action):
    type = 11

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = copy_ttl_out()
        _type = reader.read("!H")[0]
        assert(_type == 11)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("copy_ttl_out {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

action.subtypes[11] = copy_ttl_out

class dec_mpls_ttl(action):
    type = 16

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = dec_mpls_ttl()
        _type = reader.read("!H")[0]
        assert(_type == 16)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("dec_mpls_ttl {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

action.subtypes[16] = dec_mpls_ttl

class dec_nw_ttl(action):
    type = 24

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = dec_nw_ttl()
        _type = reader.read("!H")[0]
        assert(_type == 24)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("dec_nw_ttl {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

action.subtypes[24] = dec_nw_ttl

class group(action):
    type = 22

    def __init__(self, group_id=None):
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.group_id))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group()
        _type = reader.read("!H")[0]
        assert(_type == 22)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.group_id = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.group_id != other.group_id: return False
        return True

    def pretty_print(self, q):
        q.text("group {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
            q.breakable()
        q.text('}')

action.subtypes[22] = group
"""
class nicira(experimenter):
    subtypes = {}

    type = 65535
    experimenter = 8992

    def __init__(self, subtype=None):
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 2)
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 8)
        subclass = nicira.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = nicira()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 8992)
        obj.subtype = reader.read("!H")[0]
        reader.skip(2)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.subtype != other.subtype: return False
        return True

    def pretty_print(self, q):
        q.text("nicira {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

experimenter.subtypes[8992] = nicira

class nicira_dec_ttl(nicira):
    type = 65535
    experimenter = 8992
    subtype = 18

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 2)
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = nicira_dec_ttl()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 8992)
        _subtype = reader.read("!H")[0]
        assert(_subtype == 18)
        reader.skip(2)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("nicira_dec_ttl {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

nicira.subtypes[18] = nicira_dec_ttl
"""
class output(action):
    type = 0

    def __init__(self, port=None, max_len=None):
        if port != None:
            self.port = port
        else:
            self.port = 0
        if max_len != None:
            self.max_len = max_len
        else:
            self.max_len = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(util.pack_port_no(self.port))
        packed.append(struct.pack("!H", self.max_len))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = output()
        _type = reader.read("!H")[0]
        assert(_type == 0)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.port = util.unpack_port_no(reader)
        obj.max_len = reader.read("!H")[0]
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port != other.port: return False
        if self.max_len != other.max_len: return False
        return True

    def pretty_print(self, q):
        q.text("output {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
                q.text(","); q.breakable()
                q.text("max_len = ");
                q.text("%#x" % self.max_len)
            q.breakable()
        q.text('}')

action.subtypes[0] = output

class pop_mpls(action):
    type = 20

    def __init__(self, ethertype=None):
        if ethertype != None:
            self.ethertype = ethertype
        else:
            self.ethertype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!H", self.ethertype))
        packed.append('\x00' * 2)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = pop_mpls()
        _type = reader.read("!H")[0]
        assert(_type == 20)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.ethertype = reader.read("!H")[0]
        reader.skip(2)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.ethertype != other.ethertype: return False
        return True

    def pretty_print(self, q):
        q.text("pop_mpls {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ethertype = ");
                q.text("%#x" % self.ethertype)
            q.breakable()
        q.text('}')

action.subtypes[20] = pop_mpls

class pop_pbb(action):
    type = 27

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = pop_pbb()
        _type = reader.read("!H")[0]
        assert(_type == 27)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("pop_pbb {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

action.subtypes[27] = pop_pbb

class pop_vlan(action):
    type = 18

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = pop_vlan()
        _type = reader.read("!H")[0]
        assert(_type == 18)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("pop_vlan {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

action.subtypes[18] = pop_vlan

class push_mpls(action):
    type = 19

    def __init__(self, ethertype=None):
        if ethertype != None:
            self.ethertype = ethertype
        else:
            self.ethertype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!H", self.ethertype))
        packed.append('\x00' * 2)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = push_mpls()
        _type = reader.read("!H")[0]
        assert(_type == 19)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.ethertype = reader.read("!H")[0]
        reader.skip(2)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.ethertype != other.ethertype: return False
        return True

    def pretty_print(self, q):
        q.text("push_mpls {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ethertype = ");
                q.text("%#x" % self.ethertype)
            q.breakable()
        q.text('}')

action.subtypes[19] = push_mpls

class push_pbb(action):
    type = 26

    def __init__(self, ethertype=None):
        if ethertype != None:
            self.ethertype = ethertype
        else:
            self.ethertype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!H", self.ethertype))
        packed.append('\x00' * 2)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = push_pbb()
        _type = reader.read("!H")[0]
        assert(_type == 26)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.ethertype = reader.read("!H")[0]
        reader.skip(2)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.ethertype != other.ethertype: return False
        return True

    def pretty_print(self, q):
        q.text("push_pbb {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ethertype = ");
                q.text("%#x" % self.ethertype)
            q.breakable()
        q.text('}')

action.subtypes[26] = push_pbb

class push_vlan(action):
    type = 17

    def __init__(self, ethertype=None):
        if ethertype != None:
            self.ethertype = ethertype
        else:
            self.ethertype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!H", self.ethertype))
        packed.append('\x00' * 2)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = push_vlan()
        _type = reader.read("!H")[0]
        assert(_type == 17)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.ethertype = reader.read("!H")[0]
        reader.skip(2)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.ethertype != other.ethertype: return False
        return True

    def pretty_print(self, q):
        q.text("push_vlan {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ethertype = ");
                q.text("%#x" % self.ethertype)
            q.breakable()
        q.text('}')

action.subtypes[17] = push_vlan

class set_field(action):
    type = 25

    def __init__(self, field=None):
        if field != None:
            self.field = field
        else:
            self.field = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(self.field.pack())
        length = sum([len(x) for x in packed])
        packed.append(loxi.generic_util.pad_to(8, length))
        length += len(packed[-1])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = set_field()
        _type = reader.read("!H")[0]
        assert(_type == 25)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.field = ofp.oxm.oxm.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.field != other.field: return False
        return True

    def pretty_print(self, q):
        q.text("set_field {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("field = ");
                q.pp(self.field)
            q.breakable()
        q.text('}')

action.subtypes[25] = set_field

class set_mpls_ttl(action):
    type = 15

    def __init__(self, mpls_ttl=None):
        if mpls_ttl != None:
            self.mpls_ttl = mpls_ttl
        else:
            self.mpls_ttl = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!B", self.mpls_ttl))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = set_mpls_ttl()
        _type = reader.read("!H")[0]
        assert(_type == 15)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.mpls_ttl = reader.read("!B")[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.mpls_ttl != other.mpls_ttl: return False
        return True

    def pretty_print(self, q):
        q.text("set_mpls_ttl {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("mpls_ttl = ");
                q.text("%#x" % self.mpls_ttl)
            q.breakable()
        q.text('}')

action.subtypes[15] = set_mpls_ttl

class set_nw_ttl(action):
    type = 23

    def __init__(self, nw_ttl=None):
        if nw_ttl != None:
            self.nw_ttl = nw_ttl
        else:
            self.nw_ttl = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!B", self.nw_ttl))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = set_nw_ttl()
        _type = reader.read("!H")[0]
        assert(_type == 23)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.nw_ttl = reader.read("!B")[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.nw_ttl != other.nw_ttl: return False
        return True

    def pretty_print(self, q):
        q.text("set_nw_ttl {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("nw_ttl = ");
                q.text("%#x" % self.nw_ttl)
            q.breakable()
        q.text('}')

action.subtypes[23] = set_nw_ttl

class set_queue(action):
    type = 21

    def __init__(self, queue_id=None):
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.queue_id))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = set_queue()
        _type = reader.read("!H")[0]
        assert(_type == 21)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        obj.queue_id = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.queue_id != other.queue_id: return False
        return True

    def pretty_print(self, q):
        q.text("set_queue {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
            q.breakable()
        q.text('}')

action.subtypes[21] = set_queue

OFDPA_EXPERIMETER =0x00001018

class ofdpa(experimenter):
    subtypes = {}

    type = 65535
    experimenter = OFDPA_EXPERIMETER

    def __init__(self, subtype=None):
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        #8 is offset, ref OFReader
        subtype, = reader.peek('!H', 8)
        subclass = ofdpa.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = ofdpa()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        obj.subtype = reader.read("!H")[0]
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.subtype != other.subtype: return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')

experimenter.subtypes[OFDPA_EXPERIMETER] = ofdpa

OFDPA_ACT_PUSH_L2_HEADER=1
OFDPA_ACT_POP_L2_HEADER=2 
OFDPA_ACT_PUSH_CW=3 
OFDPA_ACT_POP_CW=4
OFDPA_ACT_COPY_TC_IN=5
OFDPA_ACT_COPY_TC_OUT=6
OFDPA_ACT_SET_TC_FROM_TABLE=7
OFDPA_ACT_SET_PCP_DFI_FROM_TABLE=9
OFDPA_ACT_OAM_LM_RX_COUNT=10
OFDPA_ACT_OAM_LM_TX_COUNT=11
OFDPA_ACT_OAM_SET_COUNTER_FIELDS=12
OFDPA_ACT_DEC_TTL_MTU=13
OFDPA_ACT_CHECK_DROP_STATUS=14
OFDPA_ACT_SET_QOS_FROM_TABLE=15


class ofdpa_push_l2_header(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_PUSH_L2_HEADER

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_push_l2_header()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_PUSH_L2_HEADER)   
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa_push_l2_header {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_push_l2_header");
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_PUSH_L2_HEADER] = ofdpa_push_l2_header

class ofdpa_pop_l2_header(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_POP_L2_HEADER

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 6)        
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_pop_l2_header()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_POP_L2_HEADER)          
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa_pop_l2_header {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_pop_l2_header");
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_POP_L2_HEADER] = ofdpa_pop_l2_header

class ofdpa_push_cw(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_PUSH_CW

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 6)        
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_push_cw()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_PUSH_CW)          
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa_push_cw {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_push_cw");
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_PUSH_CW] = ofdpa_push_cw

class ofdpa_pop_cw(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_POP_CW

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 6)        
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_pop_cw()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_POP_CW)          
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa_pop_cw {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_pop_cw");
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_POP_CW] = ofdpa_pop_cw

class ofdpa_copy_tc_in(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_COPY_TC_IN

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 6)        
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_copy_tc_in()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_COPY_TC_IN)  
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa_copy_tc_in {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_copy_tc_in");
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_COPY_TC_IN] = ofdpa_copy_tc_in

class ofdpa_copy_tc_out(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_COPY_TC_OUT

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 6)        
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_copy_tc_out()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_COPY_TC_OUT)        
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa_copy_tc_out {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_copy_tc_out");
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_COPY_TC_OUT] = ofdpa_copy_tc_out

class ofdpa_dec_ttl_mtu(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_DEC_TTL_MTU

    def __init__(self):
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append('\x00' * 6)        
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_dec_ttl_mtu()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_DEC_TTL_MTU)        
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa_dec_ttl_mtu {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_dec_ttl_mtu");
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_DEC_TTL_MTU] = ofdpa_dec_ttl_mtu

class ofdpa_set_tc_from_table(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_SET_TC_FROM_TABLE

    def __init__(self, qos_index=None):
        if qos_index != None:
            self.qos_index = qos_index
        else:
            self.qos_index = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append(struct.pack("!B", self.qos_index))
        packed.append('\x00' * 5)        
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_set_tc_from_table()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_SET_TC_FROM_TABLE)
        obj.qos_index = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.qos_index != other.qos_index: return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa_set_tc_from_table {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_set_tc_from_table");
                q.pp(self.qos_index)
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_SET_TC_FROM_TABLE] = ofdpa_set_tc_from_table


class ofdpa_set_pcp_dfi_from_table(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_SET_PCP_DFI_FROM_TABLE

    def __init__(self, qos_index=None):
        if qos_index != None:
            self.qos_index = qos_index
        else:
            self.qos_index = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append(struct.pack("!B", self.qos_index))
        packed.append('\x00' * 5)         
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_set_pcp_dfi_from_table()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_SET_PCP_DFI_FROM_TABLE)
        obj.qos_index = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.qos_index != other.qos_index: return False
        return True

    def pretty_print(self, q):
        q.text("ofdpa_set_pcp_dfi_from_table {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_set_pcp_dfi_from_table");
                q.pp(self.qos_index)
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_SET_PCP_DFI_FROM_TABLE] = ofdpa_set_pcp_dfi_from_table


class ofdpa_check_drop_status(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_CHECK_DROP_STATUS

    def __init__(self, index, status_type):
        self.index = index
        self.status_type  = status_type
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append(struct.pack("!L", self.index))
        packed.append(struct.pack("!B", self.status_type))  
        packed.append('\x00' * 1)    
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_check_drop_status()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_CHECK_DROP_STATUS)
        obj.status_type  = reader.read("!L")[0]
        obj.index = reader.read("!B")[0]        
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.index != other.index: return False
        if self.status_type != other.status_type: return False        
        return True

    def pretty_print(self, q):
        q.text("ofdpa_check_drop_status {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_check_drop_status = ");
                q.pp(self.index)
                q.pp(self.status_type)                
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_CHECK_DROP_STATUS] = ofdpa_check_drop_status


class ofdpa_set_qos_from_table(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_SET_QOS_FROM_TABLE

    def __init__(self, qos_index, mpls_tc):
        self.qos_index = qos_index
        self.mpls_tc  = mpls_tc
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append(struct.pack("!B", self.qos_index))
        packed.append(struct.pack("!B", self.mpls_tc))   
        packed.append('\x00' * 4)           
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_check_drop_status()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_SET_QOS_FROM_TABLE)
        obj.qos_index = reader.read("!B")[0]
        obj.mpls_tc  = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.qos_index != other.qos_index: return False
        if self.mpls_tc != other.mpls_tc: return False        
        return True

    def pretty_print(self, q):
        q.text("ofdpa_set_qos_from_table {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_set_qos_from_table = ");
                q.pp(self.qos_index)
                q.pp(self.mpls_tc)                
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_SET_QOS_FROM_TABLE] = ofdpa_set_qos_from_table


class ofdpa_oam_lm_tx_count(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_OAM_LM_TX_COUNT

    def __init__(self, lmep_id, traffic_class):
        self.lmep_id = lmep_id
        self.traffic_class  = traffic_class
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append(struct.pack("!L", self.lmep_id))
        packed.append(struct.pack("!B", self.traffic_class))   
        packed.append('\x00' * 1)   
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_check_drop_status()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_OAM_LM_TX_COUNT)
        obj.lmep_id = reader.read("!L")[0]
        obj.traffic_class  = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.lmep_id != other.lmep_id: return False
        if self.traffic_class != other.traffic_class: return False        
        return True

    def pretty_print(self, q):
        q.text("ofdpa_oam_lm_tx_count {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_oam_lm_tx_count = ");
                q.pp(self.lmep_id)
                q.pp(self.traffic_class)                
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_OAM_LM_TX_COUNT] = ofdpa_oam_lm_tx_count

class ofdpa_oam_lm_rx_count(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_OAM_LM_RX_COUNT

    def __init__(self, lmep_id, traffic_class):
        self.lmep_id = lmep_id
        self.traffic_class  = traffic_class
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append(struct.pack("!L", self.lmep_id))
        packed.append(struct.pack("!B", self.traffic_class))  
        packed.append('\x00' * 1)   
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_check_drop_status()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_OAM_LM_RX_COUNT)
        obj.lmep_id = reader.read("!L")[0]
        obj.traffic_class  = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.lmep_id != other.lmep_id: return False
        if self.traffic_class != other.traffic_class: return False        
        return True

    def pretty_print(self, q):
        q.text("ofdpa_oam_lm_rx_count {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_oam_lm_rx_count = ");
                q.pp(self.lmep_id)
                q.pp(self.traffic_class)                
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_OAM_LM_RX_COUNT] = ofdpa_oam_lm_rx_count


class ofdpa_oam_set_counter_field(ofdpa):
    type = 65535
    experimenter = OFDPA_EXPERIMETER
    subtype = OFDPA_ACT_OAM_SET_COUNTER_FIELDS

    def __init__(self, lmep_id, traffic_class):
        self.lmep_id = lmep_id
        self.traffic_class  = traffic_class
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!H", self.subtype))
        packed.append(struct.pack("!L", self.lmep_id))
        packed.append(struct.pack("!B", self.traffic_class))  
        packed.append('\x00' * 1)   
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = ofdpa_check_drop_status()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len, 4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == OFDPA_EXPERIMETER)
        _subtype = reader.read("!H")[0]
        assert(_subtype == OFDPA_ACT_OAM_SET_COUNTER_FIELDS)
        obj.lmep_id = reader.read("!L")[0]
        obj.traffic_class  = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.lmep_id != other.lmep_id: return False
        if self.traffic_class != other.traffic_class: return False        
        return True

    def pretty_print(self, q):
        q.text("ofdpa_oam_set_counter_field {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("ofdpa_oam_set_counter_field = ");
                q.pp(self.lmep_id)
                q.pp(self.traffic_class)                
            q.breakable()
        q.text('}')

ofdpa.subtypes[OFDPA_ACT_OAM_SET_COUNTER_FIELDS] = ofdpa_oam_set_counter_field