#
# Copyright 2012, 2013, Big Switch Networks, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

# Automatically generated by LOXI from template common.py
# Do not modify

import sys
import struct
import action
import const
import util

# HACK make this module visible as 'common' to simplify code generation
common = sys.modules[__name__]

def unpack_list_flow_stats_entry(buf):
    entries = []
    offset = 0
    while offset < len(buf):
        length, = struct.unpack_from("!H", buf, offset)
        if length == 0: raise loxi.ProtocolError("entry length is 0")
        if offset + length > len(buf): raise loxi.ProtocolError("entry length overruns list length")
        entries.append(flow_stats_entry.unpack(buffer(buf, offset, length)))
        offset += length
    return entries

def unpack_list_queue_prop(buf):
    entries = []
    offset = 0
    while offset < len(buf):
        type, length, = struct.unpack_from("!HH", buf, offset)
        if length == 0: raise loxi.ProtocolError("entry length is 0")
        if offset + length > len(buf): raise loxi.ProtocolError("entry length overruns list length")
        if type == const.OFPQT_MIN_RATE:
            entry = queue_prop_min_rate.unpack(buffer(buf, offset, length))
        else:
            raise loxi.ProtocolError("unknown queue prop %d" % type)
        entries.append(entry)
        offset += length
    return entries

def unpack_list_packet_queue(buf):
    entries = []
    offset = 0
    while offset < len(buf):
        _, length, = struct.unpack_from("!LH", buf, offset)
        if length == 0: raise loxi.ProtocolError("entry length is 0")
        if offset + length > len(buf): raise loxi.ProtocolError("entry length overruns list length")
        entries.append(packet_queue.unpack(buffer(buf, offset, length)))
        offset += length
    return entries

class bsn_interface(object):

    def __init__(self, hw_addr=None, pad=None, name=None, ipv4_addr=None, ipv4_netmask=None):
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if pad != None:
            self.pad = pad
        else:
            self.pad = 0
        if name != None:
            self.name = name
        else:
            self.name = ""
        if ipv4_addr != None:
            self.ipv4_addr = ipv4_addr
        else:
            self.ipv4_addr = 0
        if ipv4_netmask != None:
            self.ipv4_netmask = ipv4_netmask
        else:
            self.ipv4_netmask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append(struct.pack("!H", self.pad))
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.ipv4_addr))
        packed.append(struct.pack("!L", self.ipv4_netmask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        assert(len(buf) >= 32) # Should be verified by caller
        obj = bsn_interface()
        obj.hw_addr = list(struct.unpack_from('!6B', buf, 0))
        obj.pad = struct.unpack_from('!H', buf, 6)[0]
        obj.name = str(buffer(buf, 8, 16)).rstrip("\x00")
        obj.ipv4_addr = struct.unpack_from('!L', buf, 24)[0]
        obj.ipv4_netmask = struct.unpack_from('!L', buf, 28)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.hw_addr != other.hw_addr: return False
        if self.pad != other.pad: return False
        if self.name != other.name: return False
        if self.ipv4_addr != other.ipv4_addr: return False
        if self.ipv4_netmask != other.ipv4_netmask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_interface {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("pad = ");
                q.text("%#x" % self.pad)
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("ipv4_addr = ");
                q.text(util.pretty_ipv4(self.ipv4_addr))
                q.text(","); q.breakable()
                q.text("ipv4_netmask = ");
                q.text(util.pretty_ipv4(self.ipv4_netmask))
            q.breakable()
        q.text('}')

class flow_stats_entry(object):

    def __init__(self, table_id=None, pad=None, match=None, duration_sec=None, duration_nsec=None, priority=None, idle_timeout=None, hard_timeout=None, pad2=None, cookie=None, packet_count=None, byte_count=None, actions=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if pad2 != None:
            self.pad2 = pad2
        else:
            self.pad2 = [0,0,0,0,0,0]
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!B", self.pad))
        packed.append(self.match.pack())
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!6B", *self.pad2))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append("".join([x.pack() for x in self.actions]))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        assert(len(buf) >= 88) # Should be verified by caller
        obj = flow_stats_entry()
        _length = struct.unpack_from('!H', buf, 0)[0]
        assert(_length == len(buf))
        if _length < 88: raise loxi.ProtocolError("flow_stats_entry length is %d, should be at least 88" % _length)
        obj.table_id = struct.unpack_from('!B', buf, 2)[0]
        obj.pad = struct.unpack_from('!B', buf, 3)[0]
        obj.match = common.match.unpack(buffer(buf, 4))
        obj.duration_sec = struct.unpack_from('!L', buf, 44)[0]
        obj.duration_nsec = struct.unpack_from('!L', buf, 48)[0]
        obj.priority = struct.unpack_from('!H', buf, 52)[0]
        obj.idle_timeout = struct.unpack_from('!H', buf, 54)[0]
        obj.hard_timeout = struct.unpack_from('!H', buf, 56)[0]
        obj.pad2 = list(struct.unpack_from('!6B', buf, 58))
        obj.cookie = struct.unpack_from('!Q', buf, 64)[0]
        obj.packet_count = struct.unpack_from('!Q', buf, 72)[0]
        obj.byte_count = struct.unpack_from('!Q', buf, 80)[0]
        obj.actions = action.unpack_list(buffer(buf, 88))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.pad != other.pad: return False
        if self.match != other.match: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.priority != other.priority: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.pad2 != other.pad2: return False
        if self.cookie != other.cookie: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.text("%#x" % self.pad)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("pad2 = ");
                q.pp(self.pad2)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class match_v1(object):

    def __init__(self, wildcards=None, in_port=None, eth_src=None, eth_dst=None, vlan_vid=None, vlan_pcp=None, pad1=None, eth_type=None, ip_dscp=None, ip_proto=None, pad2=None, ipv4_src=None, ipv4_dst=None, tcp_src=None, tcp_dst=None):
        if wildcards != None:
            self.wildcards = wildcards
        else:
            self.wildcards = const.OFPFW_ALL
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if eth_src != None:
            self.eth_src = eth_src
        else:
            self.eth_src = [0,0,0,0,0,0]
        if eth_dst != None:
            self.eth_dst = eth_dst
        else:
            self.eth_dst = [0,0,0,0,0,0]
        if vlan_vid != None:
            self.vlan_vid = vlan_vid
        else:
            self.vlan_vid = 0
        if vlan_pcp != None:
            self.vlan_pcp = vlan_pcp
        else:
            self.vlan_pcp = 0
        if pad1 != None:
            self.pad1 = pad1
        else:
            self.pad1 = 0
        if eth_type != None:
            self.eth_type = eth_type
        else:
            self.eth_type = 0
        if ip_dscp != None:
            self.ip_dscp = ip_dscp
        else:
            self.ip_dscp = 0
        if ip_proto != None:
            self.ip_proto = ip_proto
        else:
            self.ip_proto = 0
        if pad2 != None:
            self.pad2 = pad2
        else:
            self.pad2 = [0,0]
        if ipv4_src != None:
            self.ipv4_src = ipv4_src
        else:
            self.ipv4_src = 0
        if ipv4_dst != None:
            self.ipv4_dst = ipv4_dst
        else:
            self.ipv4_dst = 0
        if tcp_src != None:
            self.tcp_src = tcp_src
        else:
            self.tcp_src = 0
        if tcp_dst != None:
            self.tcp_dst = tcp_dst
        else:
            self.tcp_dst = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.wildcards))
        packed.append(struct.pack("!H", self.in_port))
        packed.append(struct.pack("!6B", *self.eth_src))
        packed.append(struct.pack("!6B", *self.eth_dst))
        packed.append(struct.pack("!H", self.vlan_vid))
        packed.append(struct.pack("!B", self.vlan_pcp))
        packed.append(struct.pack("!B", self.pad1))
        packed.append(struct.pack("!H", self.eth_type))
        packed.append(struct.pack("!B", self.ip_dscp))
        packed.append(struct.pack("!B", self.ip_proto))
        packed.append(struct.pack("!2B", *self.pad2))
        packed.append(struct.pack("!L", self.ipv4_src))
        packed.append(struct.pack("!L", self.ipv4_dst))
        packed.append(struct.pack("!H", self.tcp_src))
        packed.append(struct.pack("!H", self.tcp_dst))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        assert(len(buf) >= 40) # Should be verified by caller
        obj = match_v1()
        obj.wildcards = struct.unpack_from('!L', buf, 0)[0]
        obj.in_port = struct.unpack_from('!H', buf, 4)[0]
        obj.eth_src = list(struct.unpack_from('!6B', buf, 6))
        obj.eth_dst = list(struct.unpack_from('!6B', buf, 12))
        obj.vlan_vid = struct.unpack_from('!H', buf, 18)[0]
        obj.vlan_pcp = struct.unpack_from('!B', buf, 20)[0]
        obj.pad1 = struct.unpack_from('!B', buf, 21)[0]
        obj.eth_type = struct.unpack_from('!H', buf, 22)[0]
        obj.ip_dscp = struct.unpack_from('!B', buf, 24)[0]
        obj.ip_proto = struct.unpack_from('!B', buf, 25)[0]
        obj.pad2 = list(struct.unpack_from('!2B', buf, 26))
        obj.ipv4_src = struct.unpack_from('!L', buf, 28)[0]
        obj.ipv4_dst = struct.unpack_from('!L', buf, 32)[0]
        obj.tcp_src = struct.unpack_from('!H', buf, 36)[0]
        obj.tcp_dst = struct.unpack_from('!H', buf, 38)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.wildcards != other.wildcards: return False
        if self.in_port != other.in_port: return False
        if self.eth_src != other.eth_src: return False
        if self.eth_dst != other.eth_dst: return False
        if self.vlan_vid != other.vlan_vid: return False
        if self.vlan_pcp != other.vlan_pcp: return False
        if self.pad1 != other.pad1: return False
        if self.eth_type != other.eth_type: return False
        if self.ip_dscp != other.ip_dscp: return False
        if self.ip_proto != other.ip_proto: return False
        if self.pad2 != other.pad2: return False
        if self.ipv4_src != other.ipv4_src: return False
        if self.ipv4_dst != other.ipv4_dst: return False
        if self.tcp_src != other.tcp_src: return False
        if self.tcp_dst != other.tcp_dst: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("match_v1 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("wildcards = ");
                q.text(util.pretty_wildcards(self.wildcards))
                q.text(","); q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("eth_src = ");
                q.text(util.pretty_mac(self.eth_src))
                q.text(","); q.breakable()
                q.text("eth_dst = ");
                q.text(util.pretty_mac(self.eth_dst))
                q.text(","); q.breakable()
                q.text("vlan_vid = ");
                q.text("%#x" % self.vlan_vid)
                q.text(","); q.breakable()
                q.text("vlan_pcp = ");
                q.text("%#x" % self.vlan_pcp)
                q.text(","); q.breakable()
                q.text("pad1 = ");
                q.text("%#x" % self.pad1)
                q.text(","); q.breakable()
                q.text("eth_type = ");
                q.text("%#x" % self.eth_type)
                q.text(","); q.breakable()
                q.text("ip_dscp = ");
                q.text("%#x" % self.ip_dscp)
                q.text(","); q.breakable()
                q.text("ip_proto = ");
                q.text("%#x" % self.ip_proto)
                q.text(","); q.breakable()
                q.text("pad2 = ");
                q.pp(self.pad2)
                q.text(","); q.breakable()
                q.text("ipv4_src = ");
                q.text(util.pretty_ipv4(self.ipv4_src))
                q.text(","); q.breakable()
                q.text("ipv4_dst = ");
                q.text(util.pretty_ipv4(self.ipv4_dst))
                q.text(","); q.breakable()
                q.text("tcp_src = ");
                q.text("%#x" % self.tcp_src)
                q.text(","); q.breakable()
                q.text("tcp_dst = ");
                q.text("%#x" % self.tcp_dst)
            q.breakable()
        q.text('}')

match = match_v1

class packet_queue(object):

    def __init__(self, queue_id=None, pad=None, properties=None):
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0]
        if properties != None:
            self.properties = properties
        else:
            self.properties = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!2B", *self.pad))
        packed.append("".join([x.pack() for x in self.properties]))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        assert(len(buf) >= 8) # Should be verified by caller
        obj = packet_queue()
        obj.queue_id = struct.unpack_from('!L', buf, 0)[0]
        _length = struct.unpack_from('!H', buf, 4)[0]
        assert(_length == len(buf))
        if _length < 8: raise loxi.ProtocolError("packet_queue length is %d, should be at least 8" % _length)
        obj.pad = list(struct.unpack_from('!2B', buf, 6))
        obj.properties = common.unpack_list_queue_prop(buffer(buf, 8))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.queue_id != other.queue_id: return False
        if self.pad != other.pad: return False
        if self.properties != other.properties: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("packet_queue {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("properties = ");
                q.pp(self.properties)
            q.breakable()
        q.text('}')

class port_desc(object):

    def __init__(self, port_no=None, hw_addr=None, name=None, config=None, state=None, curr=None, advertised=None, supported=None, peer=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if config != None:
            self.config = config
        else:
            self.config = 0
        if state != None:
            self.state = state
        else:
            self.state = 0
        if curr != None:
            self.curr = curr
        else:
            self.curr = 0
        if advertised != None:
            self.advertised = advertised
        else:
            self.advertised = 0
        if supported != None:
            self.supported = supported
        else:
            self.supported = 0
        if peer != None:
            self.peer = peer
        else:
            self.peer = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.port_no))
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.state))
        packed.append(struct.pack("!L", self.curr))
        packed.append(struct.pack("!L", self.advertised))
        packed.append(struct.pack("!L", self.supported))
        packed.append(struct.pack("!L", self.peer))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        assert(len(buf) >= 48) # Should be verified by caller
        obj = port_desc()
        obj.port_no = struct.unpack_from('!H', buf, 0)[0]
        obj.hw_addr = list(struct.unpack_from('!6B', buf, 2))
        obj.name = str(buffer(buf, 8, 16)).rstrip("\x00")
        obj.config = struct.unpack_from('!L', buf, 24)[0]
        obj.state = struct.unpack_from('!L', buf, 28)[0]
        obj.curr = struct.unpack_from('!L', buf, 32)[0]
        obj.advertised = struct.unpack_from('!L', buf, 36)[0]
        obj.supported = struct.unpack_from('!L', buf, 40)[0]
        obj.peer = struct.unpack_from('!L', buf, 44)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.hw_addr != other.hw_addr: return False
        if self.name != other.name: return False
        if self.config != other.config: return False
        if self.state != other.state: return False
        if self.curr != other.curr: return False
        if self.advertised != other.advertised: return False
        if self.supported != other.supported: return False
        if self.peer != other.peer: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_desc {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("state = ");
                q.text("%#x" % self.state)
                q.text(","); q.breakable()
                q.text("curr = ");
                q.text("%#x" % self.curr)
                q.text(","); q.breakable()
                q.text("advertised = ");
                q.text("%#x" % self.advertised)
                q.text(","); q.breakable()
                q.text("supported = ");
                q.text("%#x" % self.supported)
                q.text(","); q.breakable()
                q.text("peer = ");
                q.text("%#x" % self.peer)
            q.breakable()
        q.text('}')

class port_stats_entry(object):

    def __init__(self, port_no=None, pad=None, rx_packets=None, tx_packets=None, rx_bytes=None, tx_bytes=None, rx_dropped=None, tx_dropped=None, rx_errors=None, tx_errors=None, rx_frame_err=None, rx_over_err=None, rx_crc_err=None, collisions=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0,0,0,0]
        if rx_packets != None:
            self.rx_packets = rx_packets
        else:
            self.rx_packets = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if rx_bytes != None:
            self.rx_bytes = rx_bytes
        else:
            self.rx_bytes = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if rx_dropped != None:
            self.rx_dropped = rx_dropped
        else:
            self.rx_dropped = 0
        if tx_dropped != None:
            self.tx_dropped = tx_dropped
        else:
            self.tx_dropped = 0
        if rx_errors != None:
            self.rx_errors = rx_errors
        else:
            self.rx_errors = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0
        if rx_frame_err != None:
            self.rx_frame_err = rx_frame_err
        else:
            self.rx_frame_err = 0
        if rx_over_err != None:
            self.rx_over_err = rx_over_err
        else:
            self.rx_over_err = 0
        if rx_crc_err != None:
            self.rx_crc_err = rx_crc_err
        else:
            self.rx_crc_err = 0
        if collisions != None:
            self.collisions = collisions
        else:
            self.collisions = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.port_no))
        packed.append(struct.pack("!6B", *self.pad))
        packed.append(struct.pack("!Q", self.rx_packets))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.rx_bytes))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.rx_dropped))
        packed.append(struct.pack("!Q", self.tx_dropped))
        packed.append(struct.pack("!Q", self.rx_errors))
        packed.append(struct.pack("!Q", self.tx_errors))
        packed.append(struct.pack("!Q", self.rx_frame_err))
        packed.append(struct.pack("!Q", self.rx_over_err))
        packed.append(struct.pack("!Q", self.rx_crc_err))
        packed.append(struct.pack("!Q", self.collisions))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        assert(len(buf) >= 104) # Should be verified by caller
        obj = port_stats_entry()
        obj.port_no = struct.unpack_from('!H', buf, 0)[0]
        obj.pad = list(struct.unpack_from('!6B', buf, 2))
        obj.rx_packets = struct.unpack_from('!Q', buf, 8)[0]
        obj.tx_packets = struct.unpack_from('!Q', buf, 16)[0]
        obj.rx_bytes = struct.unpack_from('!Q', buf, 24)[0]
        obj.tx_bytes = struct.unpack_from('!Q', buf, 32)[0]
        obj.rx_dropped = struct.unpack_from('!Q', buf, 40)[0]
        obj.tx_dropped = struct.unpack_from('!Q', buf, 48)[0]
        obj.rx_errors = struct.unpack_from('!Q', buf, 56)[0]
        obj.tx_errors = struct.unpack_from('!Q', buf, 64)[0]
        obj.rx_frame_err = struct.unpack_from('!Q', buf, 72)[0]
        obj.rx_over_err = struct.unpack_from('!Q', buf, 80)[0]
        obj.rx_crc_err = struct.unpack_from('!Q', buf, 88)[0]
        obj.collisions = struct.unpack_from('!Q', buf, 96)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.pad != other.pad: return False
        if self.rx_packets != other.rx_packets: return False
        if self.tx_packets != other.tx_packets: return False
        if self.rx_bytes != other.rx_bytes: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.rx_dropped != other.rx_dropped: return False
        if self.tx_dropped != other.tx_dropped: return False
        if self.rx_errors != other.rx_errors: return False
        if self.tx_errors != other.tx_errors: return False
        if self.rx_frame_err != other.rx_frame_err: return False
        if self.rx_over_err != other.rx_over_err: return False
        if self.rx_crc_err != other.rx_crc_err: return False
        if self.collisions != other.collisions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("rx_packets = ");
                q.text("%#x" % self.rx_packets)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("rx_bytes = ");
                q.text("%#x" % self.rx_bytes)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("rx_dropped = ");
                q.text("%#x" % self.rx_dropped)
                q.text(","); q.breakable()
                q.text("tx_dropped = ");
                q.text("%#x" % self.tx_dropped)
                q.text(","); q.breakable()
                q.text("rx_errors = ");
                q.text("%#x" % self.rx_errors)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
                q.text(","); q.breakable()
                q.text("rx_frame_err = ");
                q.text("%#x" % self.rx_frame_err)
                q.text(","); q.breakable()
                q.text("rx_over_err = ");
                q.text("%#x" % self.rx_over_err)
                q.text(","); q.breakable()
                q.text("rx_crc_err = ");
                q.text("%#x" % self.rx_crc_err)
                q.text(","); q.breakable()
                q.text("collisions = ");
                q.text("%#x" % self.collisions)
            q.breakable()
        q.text('}')

class queue_prop_min_rate(object):
    type = const.OFPQT_MIN_RATE

    def __init__(self, pad=None, rate=None, pad2=None):
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0,0]
        if rate != None:
            self.rate = rate
        else:
            self.rate = 0
        if pad2 != None:
            self.pad2 = pad2
        else:
            self.pad2 = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append(struct.pack("!4B", *self.pad))
        packed.append(struct.pack("!H", self.rate))
        packed.append(struct.pack("!6B", *self.pad2))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        assert(len(buf) >= 16) # Should be verified by caller
        obj = queue_prop_min_rate()
        type = struct.unpack_from('!H', buf, 0)[0]
        assert(type == const.OFPQT_MIN_RATE)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 16: raise loxi.ProtocolError("queue_prop_min_rate length is %d, should be 16" % _length)
        obj.pad = list(struct.unpack_from('!4B', buf, 4))
        obj.rate = struct.unpack_from('!H', buf, 8)[0]
        obj.pad2 = list(struct.unpack_from('!6B', buf, 10))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.pad != other.pad: return False
        if self.rate != other.rate: return False
        if self.pad2 != other.pad2: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_prop_min_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("rate = ");
                q.text("%#x" % self.rate)
                q.text(","); q.breakable()
                q.text("pad2 = ");
                q.pp(self.pad2)
            q.breakable()
        q.text('}')

class queue_stats_entry(object):

    def __init__(self, port_no=None, pad=None, queue_id=None, tx_bytes=None, tx_packets=None, tx_errors=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0]
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.port_no))
        packed.append(struct.pack("!2B", *self.pad))
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.tx_errors))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        assert(len(buf) >= 32) # Should be verified by caller
        obj = queue_stats_entry()
        obj.port_no = struct.unpack_from('!H', buf, 0)[0]
        obj.pad = list(struct.unpack_from('!2B', buf, 2))
        obj.queue_id = struct.unpack_from('!L', buf, 4)[0]
        obj.tx_bytes = struct.unpack_from('!Q', buf, 8)[0]
        obj.tx_packets = struct.unpack_from('!Q', buf, 16)[0]
        obj.tx_errors = struct.unpack_from('!Q', buf, 24)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.pad != other.pad: return False
        if self.queue_id != other.queue_id: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.tx_packets != other.tx_packets: return False
        if self.tx_errors != other.tx_errors: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
            q.breakable()
        q.text('}')

class table_stats_entry(object):

    def __init__(self, table_id=None, pad=None, name=None, wildcards=None, max_entries=None, active_count=None, lookup_count=None, matched_count=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if wildcards != None:
            self.wildcards = wildcards
        else:
            self.wildcards = const.OFPFW_ALL
        if max_entries != None:
            self.max_entries = max_entries
        else:
            self.max_entries = 0
        if active_count != None:
            self.active_count = active_count
        else:
            self.active_count = 0
        if lookup_count != None:
            self.lookup_count = lookup_count
        else:
            self.lookup_count = 0
        if matched_count != None:
            self.matched_count = matched_count
        else:
            self.matched_count = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!3B", *self.pad))
        packed.append(struct.pack("!32s", self.name))
        packed.append(struct.pack("!L", self.wildcards))
        packed.append(struct.pack("!L", self.max_entries))
        packed.append(struct.pack("!L", self.active_count))
        packed.append(struct.pack("!Q", self.lookup_count))
        packed.append(struct.pack("!Q", self.matched_count))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        assert(len(buf) >= 64) # Should be verified by caller
        obj = table_stats_entry()
        obj.table_id = struct.unpack_from('!B', buf, 0)[0]
        obj.pad = list(struct.unpack_from('!3B', buf, 1))
        obj.name = str(buffer(buf, 4, 32)).rstrip("\x00")
        obj.wildcards = struct.unpack_from('!L', buf, 36)[0]
        obj.max_entries = struct.unpack_from('!L', buf, 40)[0]
        obj.active_count = struct.unpack_from('!L', buf, 44)[0]
        obj.lookup_count = struct.unpack_from('!Q', buf, 48)[0]
        obj.matched_count = struct.unpack_from('!Q', buf, 56)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.pad != other.pad: return False
        if self.name != other.name: return False
        if self.wildcards != other.wildcards: return False
        if self.max_entries != other.max_entries: return False
        if self.active_count != other.active_count: return False
        if self.lookup_count != other.lookup_count: return False
        if self.matched_count != other.matched_count: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("wildcards = ");
                q.text(util.pretty_wildcards(self.wildcards))
                q.text(","); q.breakable()
                q.text("max_entries = ");
                q.text("%#x" % self.max_entries)
                q.text(","); q.breakable()
                q.text("active_count = ");
                q.text("%#x" % self.active_count)
                q.text(","); q.breakable()
                q.text("lookup_count = ");
                q.text("%#x" % self.lookup_count)
                q.text(","); q.breakable()
                q.text("matched_count = ");
                q.text("%#x" % self.matched_count)
            q.breakable()
        q.text('}')

