# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.
# See the file LICENSE.pyloxi which should have been included in the source distribution

# Automatically generated by LOXI from template module.py
# Do not modify

import struct
import loxi
import const
import bsn_tlv
import meter_band
import instruction
import oxm
import common
import instruction_id
import action
import message
import action_id
import util
import loxi.generic_util

class bsn_controller_connection(loxi.OFObject):

    def __init__(self, state=None, auxiliary_id=None, role=None, uri=None):
        if state != None:
            self.state = state
        else:
            self.state = 0
        if auxiliary_id != None:
            self.auxiliary_id = auxiliary_id
        else:
            self.auxiliary_id = 0
        if role != None:
            self.role = role
        else:
            self.role = 0
        if uri != None:
            self.uri = uri
        else:
            self.uri = ""
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.state))
        packed.append(struct.pack("!B", self.auxiliary_id))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.role))
        packed.append(struct.pack("!256s", self.uri))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_controller_connection()
        obj.state = reader.read("!B")[0]
        obj.auxiliary_id = reader.read("!B")[0]
        reader.skip(2)
        obj.role = reader.read("!L")[0]
        obj.uri = reader.read("!256s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.state != other.state: return False
        if self.auxiliary_id != other.auxiliary_id: return False
        if self.role != other.role: return False
        if self.uri != other.uri: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_controller_connection {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("state = ");
                q.text("%#x" % self.state)
                q.text(","); q.breakable()
                q.text("auxiliary_id = ");
                q.text("%#x" % self.auxiliary_id)
                q.text(","); q.breakable()
                q.text("role = ");
                q.text("%#x" % self.role)
                q.text(","); q.breakable()
                q.text("uri = ");
                q.pp(self.uri)
            q.breakable()
        q.text('}')


class bsn_debug_counter_desc_stats_entry(loxi.OFObject):

    def __init__(self, counter_id=None, name=None, description=None):
        if counter_id != None:
            self.counter_id = counter_id
        else:
            self.counter_id = 0
        if name != None:
            self.name = name
        else:
            self.name = ""
        if description != None:
            self.description = description
        else:
            self.description = ""
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!Q", self.counter_id))
        packed.append(struct.pack("!64s", self.name))
        packed.append(struct.pack("!256s", self.description))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_debug_counter_desc_stats_entry()
        obj.counter_id = reader.read("!Q")[0]
        obj.name = reader.read("!64s")[0].rstrip("\x00")
        obj.description = reader.read("!256s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.counter_id != other.counter_id: return False
        if self.name != other.name: return False
        if self.description != other.description: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_debug_counter_desc_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("counter_id = ");
                q.text("%#x" % self.counter_id)
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("description = ");
                q.pp(self.description)
            q.breakable()
        q.text('}')


class bsn_debug_counter_stats_entry(loxi.OFObject):

    def __init__(self, counter_id=None, value=None):
        if counter_id != None:
            self.counter_id = counter_id
        else:
            self.counter_id = 0
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!Q", self.counter_id))
        packed.append(struct.pack("!Q", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_debug_counter_stats_entry()
        obj.counter_id = reader.read("!Q")[0]
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.counter_id != other.counter_id: return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_debug_counter_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("counter_id = ");
                q.text("%#x" % self.counter_id)
                q.text(","); q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')


class bsn_flow_checksum_bucket_stats_entry(loxi.OFObject):

    def __init__(self, checksum=None):
        if checksum != None:
            self.checksum = checksum
        else:
            self.checksum = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!Q", self.checksum))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_flow_checksum_bucket_stats_entry()
        obj.checksum = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.checksum != other.checksum: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_flow_checksum_bucket_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("checksum = ");
                q.text("%#x" % self.checksum)
            q.breakable()
        q.text('}')


class bsn_gentable_bucket_stats_entry(loxi.OFObject):

    def __init__(self, checksum=None):
        if checksum != None:
            self.checksum = checksum
        else:
            self.checksum = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_checksum_128(self.checksum))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_gentable_bucket_stats_entry()
        obj.checksum = util.unpack_checksum_128(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.checksum != other.checksum: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_gentable_bucket_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("checksum = ");
                q.pp(self.checksum)
            q.breakable()
        q.text('}')


class bsn_gentable_desc_stats_entry(loxi.OFObject):

    def __init__(self, table_id=None, name=None, buckets_size=None, max_entries=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if name != None:
            self.name = name
        else:
            self.name = ""
        if buckets_size != None:
            self.buckets_size = buckets_size
        else:
            self.buckets_size = 0
        if max_entries != None:
            self.max_entries = max_entries
        else:
            self.max_entries = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!H", self.table_id))
        packed.append(struct.pack("!32s", self.name))
        packed.append(struct.pack("!L", self.buckets_size))
        packed.append(struct.pack("!L", self.max_entries))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_gentable_desc_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        obj.table_id = reader.read("!H")[0]
        obj.name = reader.read("!32s")[0].rstrip("\x00")
        obj.buckets_size = reader.read("!L")[0]
        obj.max_entries = reader.read("!L")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.name != other.name: return False
        if self.buckets_size != other.buckets_size: return False
        if self.max_entries != other.max_entries: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_gentable_desc_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("buckets_size = ");
                q.text("%#x" % self.buckets_size)
                q.text(","); q.breakable()
                q.text("max_entries = ");
                q.text("%#x" % self.max_entries)
            q.breakable()
        q.text('}')


class bsn_gentable_entry_desc_stats_entry(loxi.OFObject):

    def __init__(self, checksum=None, key=None, value=None):
        if checksum != None:
            self.checksum = checksum
        else:
            self.checksum = 0
        if key != None:
            self.key = key
        else:
            self.key = []
        if value != None:
            self.value = value
        else:
            self.value = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!H", 0)) # placeholder for key_length at index 1
        packed.append(util.pack_checksum_128(self.checksum))
        packed.append(loxi.generic_util.pack_list(self.key))
        packed[1] = struct.pack("!H", len(packed[-1]))
        packed.append(loxi.generic_util.pack_list(self.value))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_gentable_entry_desc_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        _key_length = reader.read("!H")[0]
        obj.checksum = util.unpack_checksum_128(reader)
        obj.key = loxi.generic_util.unpack_list(reader.slice(_key_length), bsn_tlv.bsn_tlv.unpack)
        obj.value = loxi.generic_util.unpack_list(reader, bsn_tlv.bsn_tlv.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.checksum != other.checksum: return False
        if self.key != other.key: return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_gentable_entry_desc_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("checksum = ");
                q.pp(self.checksum)
                q.text(","); q.breakable()
                q.text("key = ");
                q.pp(self.key)
                q.text(","); q.breakable()
                q.text("value = ");
                q.pp(self.value)
            q.breakable()
        q.text('}')


class bsn_gentable_entry_stats_entry(loxi.OFObject):

    def __init__(self, key=None, stats=None):
        if key != None:
            self.key = key
        else:
            self.key = []
        if stats != None:
            self.stats = stats
        else:
            self.stats = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!H", 0)) # placeholder for key_length at index 1
        packed.append(loxi.generic_util.pack_list(self.key))
        packed[1] = struct.pack("!H", len(packed[-1]))
        packed.append(loxi.generic_util.pack_list(self.stats))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_gentable_entry_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        _key_length = reader.read("!H")[0]
        obj.key = loxi.generic_util.unpack_list(reader.slice(_key_length), bsn_tlv.bsn_tlv.unpack)
        obj.stats = loxi.generic_util.unpack_list(reader, bsn_tlv.bsn_tlv.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.key != other.key: return False
        if self.stats != other.stats: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_gentable_entry_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("key = ");
                q.pp(self.key)
                q.text(","); q.breakable()
                q.text("stats = ");
                q.pp(self.stats)
            q.breakable()
        q.text('}')


class bsn_gentable_stats_entry(loxi.OFObject):

    def __init__(self, table_id=None, entry_count=None, checksum=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if entry_count != None:
            self.entry_count = entry_count
        else:
            self.entry_count = 0
        if checksum != None:
            self.checksum = checksum
        else:
            self.checksum = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.table_id))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.entry_count))
        packed.append(util.pack_checksum_128(self.checksum))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_gentable_stats_entry()
        obj.table_id = reader.read("!H")[0]
        reader.skip(2)
        obj.entry_count = reader.read("!L")[0]
        obj.checksum = util.unpack_checksum_128(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.entry_count != other.entry_count: return False
        if self.checksum != other.checksum: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_gentable_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("entry_count = ");
                q.text("%#x" % self.entry_count)
                q.text(","); q.breakable()
                q.text("checksum = ");
                q.pp(self.checksum)
            q.breakable()
        q.text('}')


class bsn_interface(loxi.OFObject):

    def __init__(self, hw_addr=None, name=None, ipv4_addr=None, ipv4_netmask=None):
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if ipv4_addr != None:
            self.ipv4_addr = ipv4_addr
        else:
            self.ipv4_addr = 0
        if ipv4_netmask != None:
            self.ipv4_netmask = ipv4_netmask
        else:
            self.ipv4_netmask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.ipv4_addr))
        packed.append(struct.pack("!L", self.ipv4_netmask))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_interface()
        obj.hw_addr = list(reader.read('!6B'))
        reader.skip(2)
        obj.name = reader.read("!16s")[0].rstrip("\x00")
        obj.ipv4_addr = reader.read("!L")[0]
        obj.ipv4_netmask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.hw_addr != other.hw_addr: return False
        if self.name != other.name: return False
        if self.ipv4_addr != other.ipv4_addr: return False
        if self.ipv4_netmask != other.ipv4_netmask: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_interface {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("ipv4_addr = ");
                q.text(util.pretty_ipv4(self.ipv4_addr))
                q.text(","); q.breakable()
                q.text("ipv4_netmask = ");
                q.text(util.pretty_ipv4(self.ipv4_netmask))
            q.breakable()
        q.text('}')


class bsn_lacp_stats_entry(loxi.OFObject):

    def __init__(self, port_no=None, actor_sys_priority=None, actor_sys_mac=None, actor_port_priority=None, actor_port_num=None, actor_key=None, convergence_status=None, partner_sys_priority=None, partner_sys_mac=None, partner_port_priority=None, partner_port_num=None, partner_key=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if actor_sys_priority != None:
            self.actor_sys_priority = actor_sys_priority
        else:
            self.actor_sys_priority = 0
        if actor_sys_mac != None:
            self.actor_sys_mac = actor_sys_mac
        else:
            self.actor_sys_mac = [0,0,0,0,0,0]
        if actor_port_priority != None:
            self.actor_port_priority = actor_port_priority
        else:
            self.actor_port_priority = 0
        if actor_port_num != None:
            self.actor_port_num = actor_port_num
        else:
            self.actor_port_num = 0
        if actor_key != None:
            self.actor_key = actor_key
        else:
            self.actor_key = 0
        if convergence_status != None:
            self.convergence_status = convergence_status
        else:
            self.convergence_status = 0
        if partner_sys_priority != None:
            self.partner_sys_priority = partner_sys_priority
        else:
            self.partner_sys_priority = 0
        if partner_sys_mac != None:
            self.partner_sys_mac = partner_sys_mac
        else:
            self.partner_sys_mac = [0,0,0,0,0,0]
        if partner_port_priority != None:
            self.partner_port_priority = partner_port_priority
        else:
            self.partner_port_priority = 0
        if partner_port_num != None:
            self.partner_port_num = partner_port_num
        else:
            self.partner_port_num = 0
        if partner_key != None:
            self.partner_key = partner_key
        else:
            self.partner_key = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!H", self.actor_sys_priority))
        packed.append(struct.pack("!6B", *self.actor_sys_mac))
        packed.append(struct.pack("!H", self.actor_port_priority))
        packed.append(struct.pack("!H", self.actor_port_num))
        packed.append(struct.pack("!H", self.actor_key))
        packed.append(struct.pack("!B", self.convergence_status))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!H", self.partner_sys_priority))
        packed.append(struct.pack("!6B", *self.partner_sys_mac))
        packed.append(struct.pack("!H", self.partner_port_priority))
        packed.append(struct.pack("!H", self.partner_port_num))
        packed.append(struct.pack("!H", self.partner_key))
        packed.append('\x00' * 2)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_lacp_stats_entry()
        obj.port_no = util.unpack_port_no(reader)
        obj.actor_sys_priority = reader.read("!H")[0]
        obj.actor_sys_mac = list(reader.read('!6B'))
        obj.actor_port_priority = reader.read("!H")[0]
        obj.actor_port_num = reader.read("!H")[0]
        obj.actor_key = reader.read("!H")[0]
        obj.convergence_status = reader.read("!B")[0]
        reader.skip(1)
        obj.partner_sys_priority = reader.read("!H")[0]
        obj.partner_sys_mac = list(reader.read('!6B'))
        obj.partner_port_priority = reader.read("!H")[0]
        obj.partner_port_num = reader.read("!H")[0]
        obj.partner_key = reader.read("!H")[0]
        reader.skip(2)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.actor_sys_priority != other.actor_sys_priority: return False
        if self.actor_sys_mac != other.actor_sys_mac: return False
        if self.actor_port_priority != other.actor_port_priority: return False
        if self.actor_port_num != other.actor_port_num: return False
        if self.actor_key != other.actor_key: return False
        if self.convergence_status != other.convergence_status: return False
        if self.partner_sys_priority != other.partner_sys_priority: return False
        if self.partner_sys_mac != other.partner_sys_mac: return False
        if self.partner_port_priority != other.partner_port_priority: return False
        if self.partner_port_num != other.partner_port_num: return False
        if self.partner_key != other.partner_key: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_lacp_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("actor_sys_priority = ");
                q.text("%#x" % self.actor_sys_priority)
                q.text(","); q.breakable()
                q.text("actor_sys_mac = ");
                q.text(util.pretty_mac(self.actor_sys_mac))
                q.text(","); q.breakable()
                q.text("actor_port_priority = ");
                q.text("%#x" % self.actor_port_priority)
                q.text(","); q.breakable()
                q.text("actor_port_num = ");
                q.text("%#x" % self.actor_port_num)
                q.text(","); q.breakable()
                q.text("actor_key = ");
                q.text("%#x" % self.actor_key)
                q.text(","); q.breakable()
                q.text("convergence_status = ");
                q.text("%#x" % self.convergence_status)
                q.text(","); q.breakable()
                q.text("partner_sys_priority = ");
                q.text("%#x" % self.partner_sys_priority)
                q.text(","); q.breakable()
                q.text("partner_sys_mac = ");
                q.text(util.pretty_mac(self.partner_sys_mac))
                q.text(","); q.breakable()
                q.text("partner_port_priority = ");
                q.text("%#x" % self.partner_port_priority)
                q.text(","); q.breakable()
                q.text("partner_port_num = ");
                q.text("%#x" % self.partner_port_num)
                q.text(","); q.breakable()
                q.text("partner_key = ");
                q.text("%#x" % self.partner_key)
            q.breakable()
        q.text('}')


class bsn_port_counter_stats_entry(loxi.OFObject):

    def __init__(self, port_no=None, values=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if values != None:
            self.values = values
        else:
            self.values = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append('\x00' * 2)
        packed.append(util.pack_port_no(self.port_no))
        packed.append(loxi.generic_util.pack_list(self.values))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_port_counter_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        reader.skip(2)
        obj.port_no = util.unpack_port_no(reader)
        obj.values = loxi.generic_util.unpack_list(reader, common.uint64.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.values != other.values: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_port_counter_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("values = ");
                q.pp(self.values)
            q.breakable()
        q.text('}')


class bsn_switch_pipeline_stats_entry(loxi.OFObject):

    def __init__(self, pipeline=None):
        if pipeline != None:
            self.pipeline = pipeline
        else:
            self.pipeline = ""
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!256s", self.pipeline))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_switch_pipeline_stats_entry()
        obj.pipeline = reader.read("!256s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.pipeline != other.pipeline: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_switch_pipeline_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("pipeline = ");
                q.pp(self.pipeline)
            q.breakable()
        q.text('}')


class bsn_table_checksum_stats_entry(loxi.OFObject):

    def __init__(self, table_id=None, checksum=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if checksum != None:
            self.checksum = checksum
        else:
            self.checksum = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!Q", self.checksum))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_table_checksum_stats_entry()
        obj.table_id = reader.read("!B")[0]
        obj.checksum = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.checksum != other.checksum: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_table_checksum_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("checksum = ");
                q.text("%#x" % self.checksum)
            q.breakable()
        q.text('}')


class bsn_vport(loxi.OFObject):
    subtypes = {}


    def __init__(self, type=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 0)
        subclass = bsn_vport.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = bsn_vport()
        obj.type = reader.read("!H")[0]
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vport {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')


class bsn_vlan_counter_stats_entry(loxi.OFObject):

    def __init__(self, vlan_vid=None, values=None):
        if vlan_vid != None:
            self.vlan_vid = vlan_vid
        else:
            self.vlan_vid = 0
        if values != None:
            self.values = values
        else:
            self.values = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!H", self.vlan_vid))
        packed.append('\x00' * 4)
        packed.append(loxi.generic_util.pack_list(self.values))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vlan_counter_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        obj.vlan_vid = reader.read("!H")[0]
        reader.skip(4)
        obj.values = loxi.generic_util.unpack_list(reader, common.uint64.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.vlan_vid != other.vlan_vid: return False
        if self.values != other.values: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vlan_counter_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("vlan_vid = ");
                q.text("%#x" % self.vlan_vid)
                q.text(","); q.breakable()
                q.text("values = ");
                q.pp(self.values)
            q.breakable()
        q.text('}')


class bsn_vport_l2gre(bsn_vport):
    type = 1

    def __init__(self, flags=None, port_no=None, loopback_port_no=None, local_mac=None, nh_mac=None, src_ip=None, dst_ip=None, dscp=None, ttl=None, vpn=None, rate_limit=None, if_name=None):
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if loopback_port_no != None:
            self.loopback_port_no = loopback_port_no
        else:
            self.loopback_port_no = 0
        if local_mac != None:
            self.local_mac = local_mac
        else:
            self.local_mac = [0,0,0,0,0,0]
        if nh_mac != None:
            self.nh_mac = nh_mac
        else:
            self.nh_mac = [0,0,0,0,0,0]
        if src_ip != None:
            self.src_ip = src_ip
        else:
            self.src_ip = 0
        if dst_ip != None:
            self.dst_ip = dst_ip
        else:
            self.dst_ip = 0
        if dscp != None:
            self.dscp = dscp
        else:
            self.dscp = 0
        if ttl != None:
            self.ttl = ttl
        else:
            self.ttl = 0
        if vpn != None:
            self.vpn = vpn
        else:
            self.vpn = 0
        if rate_limit != None:
            self.rate_limit = rate_limit
        else:
            self.rate_limit = 0
        if if_name != None:
            self.if_name = if_name
        else:
            self.if_name = ""
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.flags))
        packed.append(util.pack_port_no(self.port_no))
        packed.append(util.pack_port_no(self.loopback_port_no))
        packed.append(struct.pack("!6B", *self.local_mac))
        packed.append(struct.pack("!6B", *self.nh_mac))
        packed.append(struct.pack("!L", self.src_ip))
        packed.append(struct.pack("!L", self.dst_ip))
        packed.append(struct.pack("!B", self.dscp))
        packed.append(struct.pack("!B", self.ttl))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.vpn))
        packed.append(struct.pack("!L", self.rate_limit))
        packed.append(struct.pack("!16s", self.if_name))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vport_l2gre()
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.flags = reader.read("!L")[0]
        obj.port_no = util.unpack_port_no(reader)
        obj.loopback_port_no = util.unpack_port_no(reader)
        obj.local_mac = list(reader.read('!6B'))
        obj.nh_mac = list(reader.read('!6B'))
        obj.src_ip = reader.read("!L")[0]
        obj.dst_ip = reader.read("!L")[0]
        obj.dscp = reader.read("!B")[0]
        obj.ttl = reader.read("!B")[0]
        reader.skip(2)
        obj.vpn = reader.read("!L")[0]
        obj.rate_limit = reader.read("!L")[0]
        obj.if_name = reader.read("!16s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        if self.loopback_port_no != other.loopback_port_no: return False
        if self.local_mac != other.local_mac: return False
        if self.nh_mac != other.nh_mac: return False
        if self.src_ip != other.src_ip: return False
        if self.dst_ip != other.dst_ip: return False
        if self.dscp != other.dscp: return False
        if self.ttl != other.ttl: return False
        if self.vpn != other.vpn: return False
        if self.rate_limit != other.rate_limit: return False
        if self.if_name != other.if_name: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vport_l2gre {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("loopback_port_no = ");
                q.text(util.pretty_port(self.loopback_port_no))
                q.text(","); q.breakable()
                q.text("local_mac = ");
                q.text(util.pretty_mac(self.local_mac))
                q.text(","); q.breakable()
                q.text("nh_mac = ");
                q.text(util.pretty_mac(self.nh_mac))
                q.text(","); q.breakable()
                q.text("src_ip = ");
                q.text(util.pretty_ipv4(self.src_ip))
                q.text(","); q.breakable()
                q.text("dst_ip = ");
                q.text(util.pretty_ipv4(self.dst_ip))
                q.text(","); q.breakable()
                q.text("dscp = ");
                q.text("%#x" % self.dscp)
                q.text(","); q.breakable()
                q.text("ttl = ");
                q.text("%#x" % self.ttl)
                q.text(","); q.breakable()
                q.text("vpn = ");
                q.text("%#x" % self.vpn)
                q.text(","); q.breakable()
                q.text("rate_limit = ");
                q.text("%#x" % self.rate_limit)
                q.text(","); q.breakable()
                q.text("if_name = ");
                q.pp(self.if_name)
            q.breakable()
        q.text('}')

bsn_vport.subtypes[1] = bsn_vport_l2gre

class bsn_vport_q_in_q(bsn_vport):
    type = 0

    def __init__(self, port_no=None, ingress_tpid=None, ingress_vlan_id=None, egress_tpid=None, egress_vlan_id=None, if_name=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if ingress_tpid != None:
            self.ingress_tpid = ingress_tpid
        else:
            self.ingress_tpid = 0
        if ingress_vlan_id != None:
            self.ingress_vlan_id = ingress_vlan_id
        else:
            self.ingress_vlan_id = 0
        if egress_tpid != None:
            self.egress_tpid = egress_tpid
        else:
            self.egress_tpid = 0
        if egress_vlan_id != None:
            self.egress_vlan_id = egress_vlan_id
        else:
            self.egress_vlan_id = 0
        if if_name != None:
            self.if_name = if_name
        else:
            self.if_name = ""
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.port_no))
        packed.append(struct.pack("!H", self.ingress_tpid))
        packed.append(struct.pack("!H", self.ingress_vlan_id))
        packed.append(struct.pack("!H", self.egress_tpid))
        packed.append(struct.pack("!H", self.egress_vlan_id))
        packed.append(struct.pack("!16s", self.if_name))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vport_q_in_q()
        _type = reader.read("!H")[0]
        assert(_type == 0)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.port_no = reader.read("!L")[0]
        obj.ingress_tpid = reader.read("!H")[0]
        obj.ingress_vlan_id = reader.read("!H")[0]
        obj.egress_tpid = reader.read("!H")[0]
        obj.egress_vlan_id = reader.read("!H")[0]
        obj.if_name = reader.read("!16s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.ingress_tpid != other.ingress_tpid: return False
        if self.ingress_vlan_id != other.ingress_vlan_id: return False
        if self.egress_tpid != other.egress_tpid: return False
        if self.egress_vlan_id != other.egress_vlan_id: return False
        if self.if_name != other.if_name: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vport_q_in_q {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text("%#x" % self.port_no)
                q.text(","); q.breakable()
                q.text("ingress_tpid = ");
                q.text("%#x" % self.ingress_tpid)
                q.text(","); q.breakable()
                q.text("ingress_vlan_id = ");
                q.text("%#x" % self.ingress_vlan_id)
                q.text(","); q.breakable()
                q.text("egress_tpid = ");
                q.text("%#x" % self.egress_tpid)
                q.text(","); q.breakable()
                q.text("egress_vlan_id = ");
                q.text("%#x" % self.egress_vlan_id)
                q.text(","); q.breakable()
                q.text("if_name = ");
                q.pp(self.if_name)
            q.breakable()
        q.text('}')

bsn_vport.subtypes[0] = bsn_vport_q_in_q

class bsn_vrf_counter_stats_entry(loxi.OFObject):

    def __init__(self, vrf=None, values=None):
        if vrf != None:
            self.vrf = vrf
        else:
            self.vrf = 0
        if values != None:
            self.values = values
        else:
            self.values = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.vrf))
        packed.append(loxi.generic_util.pack_list(self.values))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_vrf_counter_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        reader.skip(2)
        obj.vrf = reader.read("!L")[0]
        obj.values = loxi.generic_util.unpack_list(reader, common.uint64.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.vrf != other.vrf: return False
        if self.values != other.values: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_vrf_counter_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("vrf = ");
                q.text("%#x" % self.vrf)
                q.text(","); q.breakable()
                q.text("values = ");
                q.pp(self.values)
            q.breakable()
        q.text('}')


class bucket(loxi.OFObject):

    def __init__(self, weight=None, watch_port=None, watch_group=None, actions=None):
        if weight != None:
            self.weight = weight
        else:
            self.weight = 0
        if watch_port != None:
            self.watch_port = watch_port
        else:
            self.watch_port = 0
        if watch_group != None:
            self.watch_group = watch_group
        else:
            self.watch_group = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 0
        packed.append(struct.pack("!H", self.weight))
        packed.append(util.pack_port_no(self.watch_port))
        packed.append(struct.pack("!L", self.watch_group))
        packed.append('\x00' * 4)
        packed.append(loxi.generic_util.pack_list(self.actions))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bucket()
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len - (0 + 2))
        obj.weight = reader.read("!H")[0]
        obj.watch_port = util.unpack_port_no(reader)
        obj.watch_group = reader.read("!L")[0]
        reader.skip(4)
        obj.actions = loxi.generic_util.unpack_list(reader, action.action.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.weight != other.weight: return False
        if self.watch_port != other.watch_port: return False
        if self.watch_group != other.watch_group: return False
        if self.actions != other.actions: return False
        return True

    def pretty_print(self, q):
        q.text("bucket {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("weight = ");
                q.text("%#x" % self.weight)
                q.text(","); q.breakable()
                q.text("watch_port = ");
                q.text(util.pretty_port(self.watch_port))
                q.text(","); q.breakable()
                q.text("watch_group = ");
                q.text("%#x" % self.watch_group)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')


class bucket_counter(loxi.OFObject):

    def __init__(self, packet_count=None, byte_count=None):
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bucket_counter()
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        return True

    def pretty_print(self, q):
        q.text("bucket_counter {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
            q.breakable()
        q.text('}')


class flow_stats_entry(loxi.OFObject):

    def __init__(self, table_id=None, duration_sec=None, duration_nsec=None, priority=None, idle_timeout=None, hard_timeout=None, flags=None, cookie=None, packet_count=None, byte_count=None, match=None, instructions=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(self.match.pack())
        packed.append(loxi.generic_util.pack_list(self.instructions))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        obj.table_id = reader.read("!B")[0]
        reader.skip(1)
        obj.duration_sec = reader.read("!L")[0]
        obj.duration_nsec = reader.read("!L")[0]
        obj.priority = reader.read("!H")[0]
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.cookie = reader.read("!Q")[0]
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        obj.match = common.match.unpack(reader)
        obj.instructions = loxi.generic_util.unpack_list(reader, instruction.instruction.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.priority != other.priority: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.flags != other.flags: return False
        if self.cookie != other.cookie: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def pretty_print(self, q):
        q.text("flow_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')


class group_desc_stats_entry(loxi.OFObject):

    def __init__(self, group_type=None, group_id=None, buckets=None):
        if group_type != None:
            self.group_type = group_type
        else:
            self.group_type = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if buckets != None:
            self.buckets = buckets
        else:
            self.buckets = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!B", self.group_type))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.group_id))
        packed.append(loxi.generic_util.pack_list(self.buckets))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_desc_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        obj.group_type = reader.read("!B")[0]
        reader.skip(1)
        obj.group_id = reader.read("!L")[0]
        obj.buckets = loxi.generic_util.unpack_list(reader, common.bucket.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.group_type != other.group_type: return False
        if self.group_id != other.group_id: return False
        if self.buckets != other.buckets: return False
        return True

    def pretty_print(self, q):
        q.text("group_desc_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("group_type = ");
                q.text("%#x" % self.group_type)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("buckets = ");
                q.pp(self.buckets)
            q.breakable()
        q.text('}')


class group_stats_entry(loxi.OFObject):

    def __init__(self, group_id=None, ref_count=None, packet_count=None, byte_count=None, duration_sec=None, duration_nsec=None, bucket_stats=None):
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if ref_count != None:
            self.ref_count = ref_count
        else:
            self.ref_count = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if bucket_stats != None:
            self.bucket_stats = bucket_stats
        else:
            self.bucket_stats = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.group_id))
        packed.append(struct.pack("!L", self.ref_count))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(loxi.generic_util.pack_list(self.bucket_stats))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_stats_entry()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        reader.skip(2)
        obj.group_id = reader.read("!L")[0]
        obj.ref_count = reader.read("!L")[0]
        reader.skip(4)
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        obj.duration_sec = reader.read("!L")[0]
        obj.duration_nsec = reader.read("!L")[0]
        obj.bucket_stats = loxi.generic_util.unpack_list(reader, common.bucket_counter.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.group_id != other.group_id: return False
        if self.ref_count != other.ref_count: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.bucket_stats != other.bucket_stats: return False
        return True

    def pretty_print(self, q):
        q.text("group_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("ref_count = ");
                q.text("%#x" % self.ref_count)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("bucket_stats = ");
                q.pp(self.bucket_stats)
            q.breakable()
        q.text('}')


class hello_elem(loxi.OFObject):
    subtypes = {}


    def __init__(self, type=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 0)
        subclass = hello_elem.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = hello_elem()
        obj.type = reader.read("!H")[0]
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        return True

    def pretty_print(self, q):
        q.text("hello_elem {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')


class hello_elem_versionbitmap(hello_elem):
    type = 1

    def __init__(self, bitmaps=None):
        if bitmaps != None:
            self.bitmaps = bitmaps
        else:
            self.bitmaps = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.bitmaps))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = hello_elem_versionbitmap()
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.bitmaps = loxi.generic_util.unpack_list(reader, common.uint32.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.bitmaps != other.bitmaps: return False
        return True

    def pretty_print(self, q):
        q.text("hello_elem_versionbitmap {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("bitmaps = ");
                q.pp(self.bitmaps)
            q.breakable()
        q.text('}')

hello_elem.subtypes[1] = hello_elem_versionbitmap

class match_v3(loxi.OFObject):
    type = 1

    def __init__(self, oxm_list=None):
        if oxm_list != None:
            self.oxm_list = oxm_list
        else:
            self.oxm_list = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.oxm_list))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        packed.append(loxi.generic_util.pad_to(8, length))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = match_v3()
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.oxm_list = loxi.generic_util.unpack_list(reader, oxm.oxm.unpack)
        orig_reader.skip_align()
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.oxm_list != other.oxm_list: return False
        return True

    def pretty_print(self, q):
        q.text("match_v3 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("oxm_list = ");
                q.pp(self.oxm_list)
            q.breakable()
        q.text('}')


class meter_band_stats(loxi.OFObject):

    def __init__(self, packet_band_count=None, byte_band_count=None):
        if packet_band_count != None:
            self.packet_band_count = packet_band_count
        else:
            self.packet_band_count = 0
        if byte_band_count != None:
            self.byte_band_count = byte_band_count
        else:
            self.byte_band_count = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!Q", self.packet_band_count))
        packed.append(struct.pack("!Q", self.byte_band_count))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = meter_band_stats()
        obj.packet_band_count = reader.read("!Q")[0]
        obj.byte_band_count = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.packet_band_count != other.packet_band_count: return False
        if self.byte_band_count != other.byte_band_count: return False
        return True

    def pretty_print(self, q):
        q.text("meter_band_stats {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("packet_band_count = ");
                q.text("%#x" % self.packet_band_count)
                q.text(","); q.breakable()
                q.text("byte_band_count = ");
                q.text("%#x" % self.byte_band_count)
            q.breakable()
        q.text('}')


class meter_config(loxi.OFObject):

    def __init__(self, flags=None, meter_id=None, entries=None):
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if meter_id != None:
            self.meter_id = meter_id
        else:
            self.meter_id = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!L", self.meter_id))
        packed.append(loxi.generic_util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = meter_config()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        obj.flags = reader.read("!H")[0]
        obj.meter_id = reader.read("!L")[0]
        obj.entries = loxi.generic_util.unpack_list(reader, meter_band.meter_band.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.flags != other.flags: return False
        if self.meter_id != other.meter_id: return False
        if self.entries != other.entries: return False
        return True

    def pretty_print(self, q):
        q.text("meter_config {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("meter_id = ");
                q.text("%#x" % self.meter_id)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')


class meter_features(loxi.OFObject):

    def __init__(self, max_meter=None, band_types=None, capabilities=None, max_bands=None, max_color=None):
        if max_meter != None:
            self.max_meter = max_meter
        else:
            self.max_meter = 0
        if band_types != None:
            self.band_types = band_types
        else:
            self.band_types = 0
        if capabilities != None:
            self.capabilities = capabilities
        else:
            self.capabilities = 0
        if max_bands != None:
            self.max_bands = max_bands
        else:
            self.max_bands = 0
        if max_color != None:
            self.max_color = max_color
        else:
            self.max_color = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.max_meter))
        packed.append(struct.pack("!L", self.band_types))
        packed.append(struct.pack("!L", self.capabilities))
        packed.append(struct.pack("!B", self.max_bands))
        packed.append(struct.pack("!B", self.max_color))
        packed.append('\x00' * 2)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = meter_features()
        obj.max_meter = reader.read("!L")[0]
        obj.band_types = reader.read("!L")[0]
        obj.capabilities = reader.read("!L")[0]
        obj.max_bands = reader.read("!B")[0]
        obj.max_color = reader.read("!B")[0]
        reader.skip(2)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.max_meter != other.max_meter: return False
        if self.band_types != other.band_types: return False
        if self.capabilities != other.capabilities: return False
        if self.max_bands != other.max_bands: return False
        if self.max_color != other.max_color: return False
        return True

    def pretty_print(self, q):
        q.text("meter_features {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("max_meter = ");
                q.text("%#x" % self.max_meter)
                q.text(","); q.breakable()
                q.text("band_types = ");
                q.text("%#x" % self.band_types)
                q.text(","); q.breakable()
                q.text("capabilities = ");
                q.text("%#x" % self.capabilities)
                q.text(","); q.breakable()
                q.text("max_bands = ");
                q.text("%#x" % self.max_bands)
                q.text(","); q.breakable()
                q.text("max_color = ");
                q.text("%#x" % self.max_color)
            q.breakable()
        q.text('}')


class meter_stats(loxi.OFObject):

    def __init__(self, meter_id=None, flow_count=None, packet_in_count=None, byte_in_count=None, duration_sec=None, duration_nsec=None, band_stats=None):
        if meter_id != None:
            self.meter_id = meter_id
        else:
            self.meter_id = 0
        if flow_count != None:
            self.flow_count = flow_count
        else:
            self.flow_count = 0
        if packet_in_count != None:
            self.packet_in_count = packet_in_count
        else:
            self.packet_in_count = 0
        if byte_in_count != None:
            self.byte_in_count = byte_in_count
        else:
            self.byte_in_count = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if band_stats != None:
            self.band_stats = band_stats
        else:
            self.band_stats = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.meter_id))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 6)
        packed.append(struct.pack("!L", self.flow_count))
        packed.append(struct.pack("!Q", self.packet_in_count))
        packed.append(struct.pack("!Q", self.byte_in_count))
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(loxi.generic_util.pack_list(self.band_stats))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = meter_stats()
        obj.meter_id = reader.read("!L")[0]
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len - (4 + 2))
        reader.skip(6)
        obj.flow_count = reader.read("!L")[0]
        obj.packet_in_count = reader.read("!Q")[0]
        obj.byte_in_count = reader.read("!Q")[0]
        obj.duration_sec = reader.read("!L")[0]
        obj.duration_nsec = reader.read("!L")[0]
        obj.band_stats = loxi.generic_util.unpack_list(reader, common.meter_band_stats.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.meter_id != other.meter_id: return False
        if self.flow_count != other.flow_count: return False
        if self.packet_in_count != other.packet_in_count: return False
        if self.byte_in_count != other.byte_in_count: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.band_stats != other.band_stats: return False
        return True

    def pretty_print(self, q):
        q.text("meter_stats {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("meter_id = ");
                q.text("%#x" % self.meter_id)
                q.text(","); q.breakable()
                q.text("flow_count = ");
                q.text("%#x" % self.flow_count)
                q.text(","); q.breakable()
                q.text("packet_in_count = ");
                q.text("%#x" % self.packet_in_count)
                q.text(","); q.breakable()
                q.text("byte_in_count = ");
                q.text("%#x" % self.byte_in_count)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("band_stats = ");
                q.pp(self.band_stats)
            q.breakable()
        q.text('}')


class packet_queue(loxi.OFObject):

    def __init__(self, queue_id=None, port=None, properties=None):
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if port != None:
            self.port = port
        else:
            self.port = 0
        if properties != None:
            self.properties = properties
        else:
            self.properties = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(util.pack_port_no(self.port))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 2
        packed.append('\x00' * 6)
        packed.append(loxi.generic_util.pack_list(self.properties))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = packet_queue()
        obj.queue_id = reader.read("!L")[0]
        obj.port = util.unpack_port_no(reader)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len - (8 + 2))
        reader.skip(6)
        obj.properties = loxi.generic_util.unpack_list(reader, common.queue_prop.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.queue_id != other.queue_id: return False
        if self.port != other.port: return False
        if self.properties != other.properties: return False
        return True

    def pretty_print(self, q):
        q.text("packet_queue {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
                q.text(","); q.breakable()
                q.text("properties = ");
                q.pp(self.properties)
            q.breakable()
        q.text('}')


class port_desc(loxi.OFObject):

    def __init__(self, port_no=None, hw_addr=None, name=None, config=None, state=None, curr=None, advertised=None, supported=None, peer=None, curr_speed=None, max_speed=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if config != None:
            self.config = config
        else:
            self.config = 0
        if state != None:
            self.state = state
        else:
            self.state = 0
        if curr != None:
            self.curr = curr
        else:
            self.curr = 0
        if advertised != None:
            self.advertised = advertised
        else:
            self.advertised = 0
        if supported != None:
            self.supported = supported
        else:
            self.supported = 0
        if peer != None:
            self.peer = peer
        else:
            self.peer = 0
        if curr_speed != None:
            self.curr_speed = curr_speed
        else:
            self.curr_speed = 0
        if max_speed != None:
            self.max_speed = max_speed
        else:
            self.max_speed = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.state))
        packed.append(struct.pack("!L", self.curr))
        packed.append(struct.pack("!L", self.advertised))
        packed.append(struct.pack("!L", self.supported))
        packed.append(struct.pack("!L", self.peer))
        packed.append(struct.pack("!L", self.curr_speed))
        packed.append(struct.pack("!L", self.max_speed))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_desc()
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(4)
        obj.hw_addr = list(reader.read('!6B'))
        reader.skip(2)
        obj.name = reader.read("!16s")[0].rstrip("\x00")
        obj.config = reader.read("!L")[0]
        obj.state = reader.read("!L")[0]
        obj.curr = reader.read("!L")[0]
        obj.advertised = reader.read("!L")[0]
        obj.supported = reader.read("!L")[0]
        obj.peer = reader.read("!L")[0]
        obj.curr_speed = reader.read("!L")[0]
        obj.max_speed = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.hw_addr != other.hw_addr: return False
        if self.name != other.name: return False
        if self.config != other.config: return False
        if self.state != other.state: return False
        if self.curr != other.curr: return False
        if self.advertised != other.advertised: return False
        if self.supported != other.supported: return False
        if self.peer != other.peer: return False
        if self.curr_speed != other.curr_speed: return False
        if self.max_speed != other.max_speed: return False
        return True

    def pretty_print(self, q):
        q.text("port_desc {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("state = ");
                q.text("%#x" % self.state)
                q.text(","); q.breakable()
                q.text("curr = ");
                q.text("%#x" % self.curr)
                q.text(","); q.breakable()
                q.text("advertised = ");
                q.text("%#x" % self.advertised)
                q.text(","); q.breakable()
                q.text("supported = ");
                q.text("%#x" % self.supported)
                q.text(","); q.breakable()
                q.text("peer = ");
                q.text("%#x" % self.peer)
                q.text(","); q.breakable()
                q.text("curr_speed = ");
                q.text("%#x" % self.curr_speed)
                q.text(","); q.breakable()
                q.text("max_speed = ");
                q.text("%#x" % self.max_speed)
            q.breakable()
        q.text('}')


class port_stats_entry(loxi.OFObject):

    def __init__(self, port_no=None, rx_packets=None, tx_packets=None, rx_bytes=None, tx_bytes=None, rx_dropped=None, tx_dropped=None, rx_errors=None, tx_errors=None, rx_frame_err=None, rx_over_err=None, rx_crc_err=None, collisions=None, duration_sec=None, duration_nsec=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if rx_packets != None:
            self.rx_packets = rx_packets
        else:
            self.rx_packets = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if rx_bytes != None:
            self.rx_bytes = rx_bytes
        else:
            self.rx_bytes = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if rx_dropped != None:
            self.rx_dropped = rx_dropped
        else:
            self.rx_dropped = 0
        if tx_dropped != None:
            self.tx_dropped = tx_dropped
        else:
            self.tx_dropped = 0
        if rx_errors != None:
            self.rx_errors = rx_errors
        else:
            self.rx_errors = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0
        if rx_frame_err != None:
            self.rx_frame_err = rx_frame_err
        else:
            self.rx_frame_err = 0
        if rx_over_err != None:
            self.rx_over_err = rx_over_err
        else:
            self.rx_over_err = 0
        if rx_crc_err != None:
            self.rx_crc_err = rx_crc_err
        else:
            self.rx_crc_err = 0
        if collisions != None:
            self.collisions = collisions
        else:
            self.collisions = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.rx_packets))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.rx_bytes))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.rx_dropped))
        packed.append(struct.pack("!Q", self.tx_dropped))
        packed.append(struct.pack("!Q", self.rx_errors))
        packed.append(struct.pack("!Q", self.tx_errors))
        packed.append(struct.pack("!Q", self.rx_frame_err))
        packed.append(struct.pack("!Q", self.rx_over_err))
        packed.append(struct.pack("!Q", self.rx_crc_err))
        packed.append(struct.pack("!Q", self.collisions))
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_stats_entry()
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(4)
        obj.rx_packets = reader.read("!Q")[0]
        obj.tx_packets = reader.read("!Q")[0]
        obj.rx_bytes = reader.read("!Q")[0]
        obj.tx_bytes = reader.read("!Q")[0]
        obj.rx_dropped = reader.read("!Q")[0]
        obj.tx_dropped = reader.read("!Q")[0]
        obj.rx_errors = reader.read("!Q")[0]
        obj.tx_errors = reader.read("!Q")[0]
        obj.rx_frame_err = reader.read("!Q")[0]
        obj.rx_over_err = reader.read("!Q")[0]
        obj.rx_crc_err = reader.read("!Q")[0]
        obj.collisions = reader.read("!Q")[0]
        obj.duration_sec = reader.read("!L")[0]
        obj.duration_nsec = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.rx_packets != other.rx_packets: return False
        if self.tx_packets != other.tx_packets: return False
        if self.rx_bytes != other.rx_bytes: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.rx_dropped != other.rx_dropped: return False
        if self.tx_dropped != other.tx_dropped: return False
        if self.rx_errors != other.rx_errors: return False
        if self.tx_errors != other.tx_errors: return False
        if self.rx_frame_err != other.rx_frame_err: return False
        if self.rx_over_err != other.rx_over_err: return False
        if self.rx_crc_err != other.rx_crc_err: return False
        if self.collisions != other.collisions: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        return True

    def pretty_print(self, q):
        q.text("port_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("rx_packets = ");
                q.text("%#x" % self.rx_packets)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("rx_bytes = ");
                q.text("%#x" % self.rx_bytes)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("rx_dropped = ");
                q.text("%#x" % self.rx_dropped)
                q.text(","); q.breakable()
                q.text("tx_dropped = ");
                q.text("%#x" % self.tx_dropped)
                q.text(","); q.breakable()
                q.text("rx_errors = ");
                q.text("%#x" % self.rx_errors)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
                q.text(","); q.breakable()
                q.text("rx_frame_err = ");
                q.text("%#x" % self.rx_frame_err)
                q.text(","); q.breakable()
                q.text("rx_over_err = ");
                q.text("%#x" % self.rx_over_err)
                q.text(","); q.breakable()
                q.text("rx_crc_err = ");
                q.text("%#x" % self.rx_crc_err)
                q.text(","); q.breakable()
                q.text("collisions = ");
                q.text("%#x" % self.collisions)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
            q.breakable()
        q.text('}')


class queue_prop(loxi.OFObject):
    subtypes = {}


    def __init__(self, type=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 0)
        subclass = queue_prop.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = queue_prop()
        obj.type = reader.read("!H")[0]
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len - (2 + 2))
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        return True

    def pretty_print(self, q):
        q.text("queue_prop {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')


class queue_prop_experimenter(queue_prop):
    subtypes = {}

    type = 65535

    def __init__(self, experimenter=None, data=None):
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.experimenter))
        packed.append('\x00' * 4)
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 8)
        subclass = queue_prop_experimenter.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = queue_prop_experimenter()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len - (2 + 2))
        reader.skip(4)
        obj.experimenter = reader.read("!L")[0]
        reader.skip(4)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("queue_prop_experimenter {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

queue_prop.subtypes[65535] = queue_prop_experimenter

class queue_prop_max_rate(queue_prop):
    type = 2

    def __init__(self, rate=None):
        if rate != None:
            self.rate = rate
        else:
            self.rate = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        packed.append(struct.pack("!H", self.rate))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_prop_max_rate()
        _type = reader.read("!H")[0]
        assert(_type == 2)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len - (2 + 2))
        reader.skip(4)
        obj.rate = reader.read("!H")[0]
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.rate != other.rate: return False
        return True

    def pretty_print(self, q):
        q.text("queue_prop_max_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("rate = ");
                q.text("%#x" % self.rate)
            q.breakable()
        q.text('}')

queue_prop.subtypes[2] = queue_prop_max_rate

class queue_prop_min_rate(queue_prop):
    type = 1

    def __init__(self, rate=None):
        if rate != None:
            self.rate = rate
        else:
            self.rate = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        packed.append(struct.pack("!H", self.rate))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_prop_min_rate()
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _len = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_len - (2 + 2))
        reader.skip(4)
        obj.rate = reader.read("!H")[0]
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.rate != other.rate: return False
        return True

    def pretty_print(self, q):
        q.text("queue_prop_min_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("rate = ");
                q.text("%#x" % self.rate)
            q.breakable()
        q.text('}')

queue_prop.subtypes[1] = queue_prop_min_rate

class queue_stats_entry(loxi.OFObject):

    def __init__(self, port_no=None, queue_id=None, tx_bytes=None, tx_packets=None, tx_errors=None, duration_sec=None, duration_nsec=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.tx_errors))
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_stats_entry()
        obj.port_no = util.unpack_port_no(reader)
        obj.queue_id = reader.read("!L")[0]
        obj.tx_bytes = reader.read("!Q")[0]
        obj.tx_packets = reader.read("!Q")[0]
        obj.tx_errors = reader.read("!Q")[0]
        obj.duration_sec = reader.read("!L")[0]
        obj.duration_nsec = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.queue_id != other.queue_id: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.tx_packets != other.tx_packets: return False
        if self.tx_errors != other.tx_errors: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        return True

    def pretty_print(self, q):
        q.text("queue_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
            q.breakable()
        q.text('}')


class table_feature_prop(loxi.OFObject):
    subtypes = {}


    def __init__(self, type=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 0)
        subclass = table_feature_prop.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = table_feature_prop()
        obj.type = reader.read("!H")[0]
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop {")
        with q.group():
            with q.indent(2):
                q.breakable()
            q.breakable()
        q.text('}')


class table_feature_prop_apply_actions(table_feature_prop):
    type = 6

    def __init__(self, action_ids=None):
        if action_ids != None:
            self.action_ids = action_ids
        else:
            self.action_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.action_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_apply_actions()
        _type = reader.read("!H")[0]
        assert(_type == 6)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.action_ids = loxi.generic_util.unpack_list(reader, action_id.action_id.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.action_ids != other.action_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_apply_actions {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("action_ids = ");
                q.pp(self.action_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[6] = table_feature_prop_apply_actions

class table_feature_prop_apply_actions_miss(table_feature_prop):
    type = 7

    def __init__(self, action_ids=None):
        if action_ids != None:
            self.action_ids = action_ids
        else:
            self.action_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.action_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_apply_actions_miss()
        _type = reader.read("!H")[0]
        assert(_type == 7)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.action_ids = loxi.generic_util.unpack_list(reader, action_id.action_id.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.action_ids != other.action_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_apply_actions_miss {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("action_ids = ");
                q.pp(self.action_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[7] = table_feature_prop_apply_actions_miss

class table_feature_prop_apply_setfield(table_feature_prop):
    type = 14

    def __init__(self, oxm_ids=None):
        if oxm_ids != None:
            self.oxm_ids = oxm_ids
        else:
            self.oxm_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.oxm_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_apply_setfield()
        _type = reader.read("!H")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.oxm_ids = loxi.generic_util.unpack_list(reader, common.uint32.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.oxm_ids != other.oxm_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_apply_setfield {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("oxm_ids = ");
                q.pp(self.oxm_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[14] = table_feature_prop_apply_setfield

class table_feature_prop_apply_setfield_miss(table_feature_prop):
    type = 15

    def __init__(self, oxm_ids=None):
        if oxm_ids != None:
            self.oxm_ids = oxm_ids
        else:
            self.oxm_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.oxm_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_apply_setfield_miss()
        _type = reader.read("!H")[0]
        assert(_type == 15)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.oxm_ids = loxi.generic_util.unpack_list(reader, common.uint32.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.oxm_ids != other.oxm_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_apply_setfield_miss {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("oxm_ids = ");
                q.pp(self.oxm_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[15] = table_feature_prop_apply_setfield_miss

class table_feature_prop_experimenter(table_feature_prop):
    type = 65534

    def __init__(self, experimenter=None, subtype=None, experimenter_data=None):
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        if experimenter_data != None:
            self.experimenter_data = experimenter_data
        else:
            self.experimenter_data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(self.experimenter_data)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_experimenter()
        _type = reader.read("!H")[0]
        assert(_type == 65534)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.experimenter = reader.read("!L")[0]
        obj.subtype = reader.read("!L")[0]
        obj.experimenter_data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.experimenter != other.experimenter: return False
        if self.subtype != other.subtype: return False
        if self.experimenter_data != other.experimenter_data: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_experimenter {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("experimenter = ");
                q.text("%#x" % self.experimenter)
                q.text(","); q.breakable()
                q.text("subtype = ");
                q.text("%#x" % self.subtype)
                q.text(","); q.breakable()
                q.text("experimenter_data = ");
                q.pp(self.experimenter_data)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[65534] = table_feature_prop_experimenter

class table_feature_prop_experimenter_miss(table_feature_prop):
    type = 65535

    def __init__(self, experimenter=None, subtype=None, experimenter_data=None):
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        if experimenter_data != None:
            self.experimenter_data = experimenter_data
        else:
            self.experimenter_data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(self.experimenter_data)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_experimenter_miss()
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.experimenter = reader.read("!L")[0]
        obj.subtype = reader.read("!L")[0]
        obj.experimenter_data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.experimenter != other.experimenter: return False
        if self.subtype != other.subtype: return False
        if self.experimenter_data != other.experimenter_data: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_experimenter_miss {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("experimenter = ");
                q.text("%#x" % self.experimenter)
                q.text(","); q.breakable()
                q.text("subtype = ");
                q.text("%#x" % self.subtype)
                q.text(","); q.breakable()
                q.text("experimenter_data = ");
                q.pp(self.experimenter_data)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[65535] = table_feature_prop_experimenter_miss

class table_feature_prop_instructions(table_feature_prop):
    type = 0

    def __init__(self, instruction_ids=None):
        if instruction_ids != None:
            self.instruction_ids = instruction_ids
        else:
            self.instruction_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.instruction_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_instructions()
        _type = reader.read("!H")[0]
        assert(_type == 0)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.instruction_ids = loxi.generic_util.unpack_list(reader, instruction_id.instruction_id.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.instruction_ids != other.instruction_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_instructions {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("instruction_ids = ");
                q.pp(self.instruction_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[0] = table_feature_prop_instructions

class table_feature_prop_instructions_miss(table_feature_prop):
    type = 1

    def __init__(self, instruction_ids=None):
        if instruction_ids != None:
            self.instruction_ids = instruction_ids
        else:
            self.instruction_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.instruction_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_instructions_miss()
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.instruction_ids = loxi.generic_util.unpack_list(reader, instruction_id.instruction_id.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.instruction_ids != other.instruction_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_instructions_miss {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("instruction_ids = ");
                q.pp(self.instruction_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[1] = table_feature_prop_instructions_miss

class table_feature_prop_match(table_feature_prop):
    type = 8

    def __init__(self, oxm_ids=None):
        if oxm_ids != None:
            self.oxm_ids = oxm_ids
        else:
            self.oxm_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.oxm_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_match()
        _type = reader.read("!H")[0]
        assert(_type == 8)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.oxm_ids = loxi.generic_util.unpack_list(reader, common.uint32.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.oxm_ids != other.oxm_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_match {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("oxm_ids = ");
                q.pp(self.oxm_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[8] = table_feature_prop_match

class table_feature_prop_next_tables(table_feature_prop):
    type = 2

    def __init__(self, next_table_ids=None):
        if next_table_ids != None:
            self.next_table_ids = next_table_ids
        else:
            self.next_table_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.next_table_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_next_tables()
        _type = reader.read("!H")[0]
        assert(_type == 2)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.next_table_ids = loxi.generic_util.unpack_list(reader, common.uint8.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.next_table_ids != other.next_table_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_next_tables {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("next_table_ids = ");
                q.pp(self.next_table_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[2] = table_feature_prop_next_tables

class table_feature_prop_next_tables_miss(table_feature_prop):
    type = 3

    def __init__(self, next_table_ids=None):
        if next_table_ids != None:
            self.next_table_ids = next_table_ids
        else:
            self.next_table_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.next_table_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_next_tables_miss()
        _type = reader.read("!H")[0]
        assert(_type == 3)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.next_table_ids = loxi.generic_util.unpack_list(reader, common.uint8.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.next_table_ids != other.next_table_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_next_tables_miss {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("next_table_ids = ");
                q.pp(self.next_table_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[3] = table_feature_prop_next_tables_miss

class table_feature_prop_wildcards(table_feature_prop):
    type = 10

    def __init__(self, oxm_ids=None):
        if oxm_ids != None:
            self.oxm_ids = oxm_ids
        else:
            self.oxm_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.oxm_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_wildcards()
        _type = reader.read("!H")[0]
        assert(_type == 10)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.oxm_ids = loxi.generic_util.unpack_list(reader, common.uint32.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.oxm_ids != other.oxm_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_wildcards {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("oxm_ids = ");
                q.pp(self.oxm_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[10] = table_feature_prop_wildcards

class table_feature_prop_write_actions(table_feature_prop):
    type = 4

    def __init__(self, action_ids=None):
        if action_ids != None:
            self.action_ids = action_ids
        else:
            self.action_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.action_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_write_actions()
        _type = reader.read("!H")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.action_ids = loxi.generic_util.unpack_list(reader, action_id.action_id.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.action_ids != other.action_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_write_actions {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("action_ids = ");
                q.pp(self.action_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[4] = table_feature_prop_write_actions

class table_feature_prop_write_actions_miss(table_feature_prop):
    type = 5

    def __init__(self, action_ids=None):
        if action_ids != None:
            self.action_ids = action_ids
        else:
            self.action_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.action_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_write_actions_miss()
        _type = reader.read("!H")[0]
        assert(_type == 5)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.action_ids = loxi.generic_util.unpack_list(reader, action_id.action_id.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.action_ids != other.action_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_write_actions_miss {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("action_ids = ");
                q.pp(self.action_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[5] = table_feature_prop_write_actions_miss

class table_feature_prop_write_setfield(table_feature_prop):
    type = 12

    def __init__(self, oxm_ids=None):
        if oxm_ids != None:
            self.oxm_ids = oxm_ids
        else:
            self.oxm_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.oxm_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_write_setfield()
        _type = reader.read("!H")[0]
        assert(_type == 12)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.oxm_ids = loxi.generic_util.unpack_list(reader, common.uint32.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.oxm_ids != other.oxm_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_write_setfield {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("oxm_ids = ");
                q.pp(self.oxm_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[12] = table_feature_prop_write_setfield

class table_feature_prop_write_setfield_miss(table_feature_prop):
    type = 13

    def __init__(self, oxm_ids=None):
        if oxm_ids != None:
            self.oxm_ids = oxm_ids
        else:
            self.oxm_ids = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(loxi.generic_util.pack_list(self.oxm_ids))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_feature_prop_write_setfield_miss()
        _type = reader.read("!H")[0]
        assert(_type == 13)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.oxm_ids = loxi.generic_util.unpack_list(reader, common.uint32.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.oxm_ids != other.oxm_ids: return False
        return True

    def pretty_print(self, q):
        q.text("table_feature_prop_write_setfield_miss {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("oxm_ids = ");
                q.pp(self.oxm_ids)
            q.breakable()
        q.text('}')

table_feature_prop.subtypes[13] = table_feature_prop_write_setfield_miss

class table_features(loxi.OFObject):

    def __init__(self, table_id=None, name=None, metadata_match=None, metadata_write=None, config=None, max_entries=None, properties=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if name != None:
            self.name = name
        else:
            self.name = ""
        if metadata_match != None:
            self.metadata_match = metadata_match
        else:
            self.metadata_match = 0
        if metadata_write != None:
            self.metadata_write = metadata_write
        else:
            self.metadata_write = 0
        if config != None:
            self.config = config
        else:
            self.config = 0
        if max_entries != None:
            self.max_entries = max_entries
        else:
            self.max_entries = 0
        if properties != None:
            self.properties = properties
        else:
            self.properties = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 5)
        packed.append(struct.pack("!32s", self.name))
        packed.append(struct.pack("!Q", self.metadata_match))
        packed.append(struct.pack("!Q", self.metadata_write))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.max_entries))
        packed.append(loxi.generic_util.pack_list(self.properties))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_features()
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (0 + 2))
        obj.table_id = reader.read("!B")[0]
        reader.skip(5)
        obj.name = reader.read("!32s")[0].rstrip("\x00")
        obj.metadata_match = reader.read("!Q")[0]
        obj.metadata_write = reader.read("!Q")[0]
        obj.config = reader.read("!L")[0]
        obj.max_entries = reader.read("!L")[0]
        obj.properties = loxi.generic_util.unpack_list(reader, common.table_feature_prop.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.name != other.name: return False
        if self.metadata_match != other.metadata_match: return False
        if self.metadata_write != other.metadata_write: return False
        if self.config != other.config: return False
        if self.max_entries != other.max_entries: return False
        if self.properties != other.properties: return False
        return True

    def pretty_print(self, q):
        q.text("table_features {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("metadata_match = ");
                q.text("%#x" % self.metadata_match)
                q.text(","); q.breakable()
                q.text("metadata_write = ");
                q.text("%#x" % self.metadata_write)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("max_entries = ");
                q.text("%#x" % self.max_entries)
                q.text(","); q.breakable()
                q.text("properties = ");
                q.pp(self.properties)
            q.breakable()
        q.text('}')


class table_stats_entry(loxi.OFObject):

    def __init__(self, table_id=None, active_count=None, lookup_count=None, matched_count=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if active_count != None:
            self.active_count = active_count
        else:
            self.active_count = 0
        if lookup_count != None:
            self.lookup_count = lookup_count
        else:
            self.lookup_count = 0
        if matched_count != None:
            self.matched_count = matched_count
        else:
            self.matched_count = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.active_count))
        packed.append(struct.pack("!Q", self.lookup_count))
        packed.append(struct.pack("!Q", self.matched_count))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_stats_entry()
        obj.table_id = reader.read("!B")[0]
        reader.skip(3)
        obj.active_count = reader.read("!L")[0]
        obj.lookup_count = reader.read("!Q")[0]
        obj.matched_count = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.active_count != other.active_count: return False
        if self.lookup_count != other.lookup_count: return False
        if self.matched_count != other.matched_count: return False
        return True

    def pretty_print(self, q):
        q.text("table_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("active_count = ");
                q.text("%#x" % self.active_count)
                q.text(","); q.breakable()
                q.text("lookup_count = ");
                q.text("%#x" % self.lookup_count)
                q.text(","); q.breakable()
                q.text("matched_count = ");
                q.text("%#x" % self.matched_count)
            q.breakable()
        q.text('}')


class uint32(loxi.OFObject):

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = uint32()
        obj.value = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("uint32 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')


class uint64(loxi.OFObject):

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!Q", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = uint64()
        obj.value = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("uint64 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')


class uint8(loxi.OFObject):

    def __init__(self, value=None):
        if value != None:
            self.value = value
        else:
            self.value = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.value))
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = uint8()
        obj.value = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.value != other.value: return False
        return True

    def pretty_print(self, q):
        q.text("uint8 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("value = ");
                q.text("%#x" % self.value)
            q.breakable()
        q.text('}')



match = match_v3
