#
# Copyright 2012, 2013, Big Switch Networks, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

# Automatically generated by LOXI from template message.py
# Do not modify

import struct
import loxi
import const
import common
import action # for unpack_list
import util

class Message(object):
    version = const.OFP_VERSION
    type = None # override in subclass
    xid = None

class aggregate_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_AGGREGATE

    def __init__(self, xid=None, flags=None, packet_count=None, byte_count=None, flow_count=None, pad=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if flow_count != None:
            self.flow_count = flow_count
        else:
            self.flow_count = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(struct.pack("!L", self.flow_count))
        packed.append(struct.pack("!4B", *self.pad))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = aggregate_stats_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 36: raise loxi.ProtocolError("aggregate_stats_reply length is %d, should be 36" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_AGGREGATE)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.packet_count = struct.unpack_from('!Q', buf, 12)[0]
        obj.byte_count = struct.unpack_from('!Q', buf, 20)[0]
        obj.flow_count = struct.unpack_from('!L', buf, 28)[0]
        obj.pad = list(struct.unpack_from('!4B', buf, 32))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.flow_count != other.flow_count: return False
        if self.pad != other.pad: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("aggregate_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("flow_count = ");
                q.text("%#x" % self.flow_count)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
            q.breakable()
        q.text('}')

class aggregate_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_AGGREGATE

    def __init__(self, xid=None, flags=None, match=None, table_id=None, pad=None, out_port=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(self.match.pack())
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!B", self.pad))
        packed.append(struct.pack("!H", self.out_port))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = aggregate_stats_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 56: raise loxi.ProtocolError("aggregate_stats_request length is %d, should be 56" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_AGGREGATE)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.match = common.match.unpack(buffer(buf, 12))
        obj.table_id = struct.unpack_from('!B', buf, 52)[0]
        obj.pad = struct.unpack_from('!B', buf, 53)[0]
        obj.out_port = struct.unpack_from('!H', buf, 54)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.table_id != other.table_id: return False
        if self.pad != other.pad: return False
        if self.out_port != other.out_port: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("aggregate_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.text("%#x" % self.pad)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
            q.breakable()
        q.text('}')

class barrier_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_BARRIER_REPLY

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = barrier_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_BARRIER_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 8: raise loxi.ProtocolError("barrier_reply length is %d, should be 8" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("barrier_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class barrier_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_BARRIER_REQUEST

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = barrier_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_BARRIER_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 8: raise loxi.ProtocolError("barrier_request length is %d, should be 8" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("barrier_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class bsn_get_interfaces_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 10

    def __init__(self, xid=None, interfaces=None):
        self.xid = xid
        if interfaces != None:
            self.interfaces = interfaces
        else:
            self.interfaces = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append("".join([x.pack() for x in self.interfaces]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_interfaces_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 16: raise loxi.ProtocolError("bsn_get_interfaces_reply length is %d, should be at least 16" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 10)
        obj.interfaces = util.unpack_array(common.bsn_interface.unpack, 32, buffer(buf, 16))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.interfaces != other.interfaces: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_interfaces_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("interfaces = ");
                q.pp(self.interfaces)
            q.breakable()
        q.text('}')

class bsn_get_interfaces_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 9

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_interfaces_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 16: raise loxi.ProtocolError("bsn_get_interfaces_request length is %d, should be 16" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 9)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_interfaces_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class bsn_get_ip_mask_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 2

    def __init__(self, xid=None, index=None, pad=None, mask=None):
        self.xid = xid
        if index != None:
            self.index = index
        else:
            self.index = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0]
        if mask != None:
            self.mask = mask
        else:
            self.mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.index))
        packed.append(struct.pack("!3B", *self.pad))
        packed.append(struct.pack("!L", self.mask))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_ip_mask_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 24: raise loxi.ProtocolError("bsn_get_ip_mask_reply length is %d, should be 24" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 2)
        obj.index = struct.unpack_from('!B', buf, 16)[0]
        obj.pad = list(struct.unpack_from('!3B', buf, 17))
        obj.mask = struct.unpack_from('!L', buf, 20)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.index != other.index: return False
        if self.pad != other.pad: return False
        if self.mask != other.mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_ip_mask_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("index = ");
                q.text("%#x" % self.index)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("mask = ");
                q.text("%#x" % self.mask)
            q.breakable()
        q.text('}')

class bsn_get_ip_mask_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 1

    def __init__(self, xid=None, index=None, pad=None):
        self.xid = xid
        if index != None:
            self.index = index
        else:
            self.index = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.index))
        packed.append(struct.pack("!7B", *self.pad))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_ip_mask_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 24: raise loxi.ProtocolError("bsn_get_ip_mask_request length is %d, should be 24" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 1)
        obj.index = struct.unpack_from('!B', buf, 16)[0]
        obj.pad = list(struct.unpack_from('!7B', buf, 17))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.index != other.index: return False
        if self.pad != other.pad: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_ip_mask_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("index = ");
                q.text("%#x" % self.index)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
            q.breakable()
        q.text('}')

class bsn_get_mirroring_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 5

    def __init__(self, xid=None, report_mirror_ports=None, pad=None):
        self.xid = xid
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append(struct.pack("!3B", *self.pad))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_mirroring_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 20: raise loxi.ProtocolError("bsn_get_mirroring_reply length is %d, should be 20" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 5)
        obj.report_mirror_ports = struct.unpack_from('!B', buf, 16)[0]
        obj.pad = list(struct.unpack_from('!3B', buf, 17))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        if self.pad != other.pad: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_mirroring_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
            q.breakable()
        q.text('}')

class bsn_get_mirroring_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 4

    def __init__(self, xid=None, report_mirror_ports=None, pad=None):
        self.xid = xid
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append(struct.pack("!3B", *self.pad))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_mirroring_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 20: raise loxi.ProtocolError("bsn_get_mirroring_request length is %d, should be 20" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 4)
        obj.report_mirror_ports = struct.unpack_from('!B', buf, 16)[0]
        obj.pad = list(struct.unpack_from('!3B', buf, 17))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        if self.pad != other.pad: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_mirroring_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
            q.breakable()
        q.text('}')

class bsn_set_ip_mask(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 0

    def __init__(self, xid=None, index=None, pad=None, mask=None):
        self.xid = xid
        if index != None:
            self.index = index
        else:
            self.index = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0]
        if mask != None:
            self.mask = mask
        else:
            self.mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.index))
        packed.append(struct.pack("!3B", *self.pad))
        packed.append(struct.pack("!L", self.mask))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_ip_mask()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 24: raise loxi.ProtocolError("bsn_set_ip_mask length is %d, should be 24" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 0)
        obj.index = struct.unpack_from('!B', buf, 16)[0]
        obj.pad = list(struct.unpack_from('!3B', buf, 17))
        obj.mask = struct.unpack_from('!L', buf, 20)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.index != other.index: return False
        if self.pad != other.pad: return False
        if self.mask != other.mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_ip_mask {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("index = ");
                q.text("%#x" % self.index)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("mask = ");
                q.text("%#x" % self.mask)
            q.breakable()
        q.text('}')

class bsn_set_mirroring(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 3

    def __init__(self, xid=None, report_mirror_ports=None, pad=None):
        self.xid = xid
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append(struct.pack("!3B", *self.pad))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_mirroring()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 20: raise loxi.ProtocolError("bsn_set_mirroring length is %d, should be 20" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 3)
        obj.report_mirror_ports = struct.unpack_from('!B', buf, 16)[0]
        obj.pad = list(struct.unpack_from('!3B', buf, 17))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        if self.pad != other.pad: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_mirroring {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
            q.breakable()
        q.text('}')

class bsn_shell_command(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 6

    def __init__(self, xid=None, service=None, data=None):
        self.xid = xid
        if service != None:
            self.service = service
        else:
            self.service = 0
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.service))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_shell_command()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 20: raise loxi.ProtocolError("bsn_shell_command length is %d, should be at least 20" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 6)
        obj.service = struct.unpack_from('!L', buf, 16)[0]
        obj.data = buf[20:]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.service != other.service: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_shell_command {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("service = ");
                q.text("%#x" % self.service)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class bsn_shell_output(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 7

    def __init__(self, xid=None, data=None):
        self.xid = xid
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_shell_output()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 16: raise loxi.ProtocolError("bsn_shell_output length is %d, should be at least 16" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 7)
        obj.data = buf[16:]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_shell_output {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class bsn_shell_status(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x5c16c7
    subtype = 8

    def __init__(self, xid=None, status=None):
        self.xid = xid
        if status != None:
            self.status = status
        else:
            self.status = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_shell_status()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 20: raise loxi.ProtocolError("bsn_shell_status length is %d, should be 20" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x5c16c7)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 8)
        obj.status = struct.unpack_from('!L', buf, 16)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_shell_status {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

class desc_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_DESC

    def __init__(self, xid=None, flags=None, mfr_desc=None, hw_desc=None, sw_desc=None, serial_num=None, dp_desc=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if mfr_desc != None:
            self.mfr_desc = mfr_desc
        else:
            self.mfr_desc = ""
        if hw_desc != None:
            self.hw_desc = hw_desc
        else:
            self.hw_desc = ""
        if sw_desc != None:
            self.sw_desc = sw_desc
        else:
            self.sw_desc = ""
        if serial_num != None:
            self.serial_num = serial_num
        else:
            self.serial_num = ""
        if dp_desc != None:
            self.dp_desc = dp_desc
        else:
            self.dp_desc = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!256s", self.mfr_desc))
        packed.append(struct.pack("!256s", self.hw_desc))
        packed.append(struct.pack("!256s", self.sw_desc))
        packed.append(struct.pack("!32s", self.serial_num))
        packed.append(struct.pack("!256s", self.dp_desc))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = desc_stats_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 1068: raise loxi.ProtocolError("desc_stats_reply length is %d, should be 1068" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_DESC)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.mfr_desc = str(buffer(buf, 12, 256)).rstrip("\x00")
        obj.hw_desc = str(buffer(buf, 268, 256)).rstrip("\x00")
        obj.sw_desc = str(buffer(buf, 524, 256)).rstrip("\x00")
        obj.serial_num = str(buffer(buf, 780, 32)).rstrip("\x00")
        obj.dp_desc = str(buffer(buf, 812, 256)).rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.mfr_desc != other.mfr_desc: return False
        if self.hw_desc != other.hw_desc: return False
        if self.sw_desc != other.sw_desc: return False
        if self.serial_num != other.serial_num: return False
        if self.dp_desc != other.dp_desc: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("desc_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("mfr_desc = ");
                q.pp(self.mfr_desc)
                q.text(","); q.breakable()
                q.text("hw_desc = ");
                q.pp(self.hw_desc)
                q.text(","); q.breakable()
                q.text("sw_desc = ");
                q.pp(self.sw_desc)
                q.text(","); q.breakable()
                q.text("serial_num = ");
                q.pp(self.serial_num)
                q.text(","); q.breakable()
                q.text("dp_desc = ");
                q.pp(self.dp_desc)
            q.breakable()
        q.text('}')

class desc_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_DESC

    def __init__(self, xid=None, flags=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = desc_stats_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 12: raise loxi.ProtocolError("desc_stats_request length is %d, should be 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_DESC)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("desc_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

class echo_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_ECHO_REPLY

    def __init__(self, xid=None, data=None):
        self.xid = xid
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = echo_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_ECHO_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 8: raise loxi.ProtocolError("echo_reply length is %d, should be at least 8" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.data = buf[8:]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("echo_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class echo_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_ECHO_REQUEST

    def __init__(self, xid=None, data=None):
        self.xid = xid
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = echo_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_ECHO_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 8: raise loxi.ProtocolError("echo_request length is %d, should be at least 8" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.data = buf[8:]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("echo_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class error_msg(Message):
    version = const.OFP_VERSION
    type = const.OFPT_ERROR

    def __init__(self, xid=None, err_type=None, code=None, data=None):
        self.xid = xid
        if err_type != None:
            self.err_type = err_type
        else:
            self.err_type = 0
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = error_msg()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_ERROR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 12: raise loxi.ProtocolError("error_msg length is %d, should be at least 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.err_type = struct.unpack_from('!H', buf, 8)[0]
        obj.code = struct.unpack_from('!H', buf, 10)[0]
        obj.data = buf[12:]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.err_type != other.err_type: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("err_type = ");
                q.text("%#x" % self.err_type)
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class experimenter_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_VENDOR

    def __init__(self, xid=None, flags=None, experimenter=None, data=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = experimenter_stats_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 16: raise loxi.ProtocolError("experimenter_stats_reply length is %d, should be at least 16" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_VENDOR)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.experimenter = struct.unpack_from('!L', buf, 12)[0]
        obj.data = buf[16:]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("experimenter_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("experimenter = ");
                q.text("%#x" % self.experimenter)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class experimenter_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_VENDOR

    def __init__(self, xid=None, flags=None, experimenter=None, data=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = experimenter_stats_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 16: raise loxi.ProtocolError("experimenter_stats_request length is %d, should be at least 16" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_VENDOR)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.experimenter = struct.unpack_from('!L', buf, 12)[0]
        obj.data = buf[16:]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("experimenter_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("experimenter = ");
                q.text("%#x" % self.experimenter)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class features_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FEATURES_REPLY

    def __init__(self, xid=None, datapath_id=None, n_buffers=None, n_tables=None, pad=None, capabilities=None, actions=None, ports=None):
        self.xid = xid
        if datapath_id != None:
            self.datapath_id = datapath_id
        else:
            self.datapath_id = 0
        if n_buffers != None:
            self.n_buffers = n_buffers
        else:
            self.n_buffers = 0
        if n_tables != None:
            self.n_tables = n_tables
        else:
            self.n_tables = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0]
        if capabilities != None:
            self.capabilities = capabilities
        else:
            self.capabilities = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = 0
        if ports != None:
            self.ports = ports
        else:
            self.ports = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.datapath_id))
        packed.append(struct.pack("!L", self.n_buffers))
        packed.append(struct.pack("!B", self.n_tables))
        packed.append(struct.pack("!3B", *self.pad))
        packed.append(struct.pack("!L", self.capabilities))
        packed.append(struct.pack("!L", self.actions))
        packed.append("".join([x.pack() for x in self.ports]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = features_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_FEATURES_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 32: raise loxi.ProtocolError("features_reply length is %d, should be at least 32" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.datapath_id = struct.unpack_from('!Q', buf, 8)[0]
        obj.n_buffers = struct.unpack_from('!L', buf, 16)[0]
        obj.n_tables = struct.unpack_from('!B', buf, 20)[0]
        obj.pad = list(struct.unpack_from('!3B', buf, 21))
        obj.capabilities = struct.unpack_from('!L', buf, 24)[0]
        obj.actions = struct.unpack_from('!L', buf, 28)[0]
        obj.ports = util.unpack_array(common.port_desc.unpack, 48, buffer(buf, 32))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.datapath_id != other.datapath_id: return False
        if self.n_buffers != other.n_buffers: return False
        if self.n_tables != other.n_tables: return False
        if self.pad != other.pad: return False
        if self.capabilities != other.capabilities: return False
        if self.actions != other.actions: return False
        if self.ports != other.ports: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("features_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("datapath_id = ");
                q.text("%#x" % self.datapath_id)
                q.text(","); q.breakable()
                q.text("n_buffers = ");
                q.text("%#x" % self.n_buffers)
                q.text(","); q.breakable()
                q.text("n_tables = ");
                q.text("%#x" % self.n_tables)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("capabilities = ");
                q.text("%#x" % self.capabilities)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.text("%#x" % self.actions)
                q.text(","); q.breakable()
                q.text("ports = ");
                q.pp(self.ports)
            q.breakable()
        q.text('}')

class features_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FEATURES_REQUEST

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = features_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_FEATURES_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 8: raise loxi.ProtocolError("features_request length is %d, should be 8" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("features_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class flow_add(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_ADD

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!H", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!H", self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append("".join([x.pack() for x in self.actions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_add()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_FLOW_MOD)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 72: raise loxi.ProtocolError("flow_add length is %d, should be at least 72" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.match = common.match.unpack(buffer(buf, 8))
        obj.cookie = struct.unpack_from('!Q', buf, 48)[0]
        _command = struct.unpack_from('!H', buf, 56)[0]
        assert(_command == const.OFPFC_ADD)
        obj.idle_timeout = struct.unpack_from('!H', buf, 58)[0]
        obj.hard_timeout = struct.unpack_from('!H', buf, 60)[0]
        obj.priority = struct.unpack_from('!H', buf, 62)[0]
        obj.buffer_id = struct.unpack_from('!L', buf, 64)[0]
        obj.out_port = struct.unpack_from('!H', buf, 68)[0]
        obj.flags = struct.unpack_from('!H', buf, 70)[0]
        obj.actions = action.unpack_list(buffer(buf, 72))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_add {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_delete(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_DELETE

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!H", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!H", self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append("".join([x.pack() for x in self.actions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_delete()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_FLOW_MOD)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 72: raise loxi.ProtocolError("flow_delete length is %d, should be at least 72" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.match = common.match.unpack(buffer(buf, 8))
        obj.cookie = struct.unpack_from('!Q', buf, 48)[0]
        _command = struct.unpack_from('!H', buf, 56)[0]
        assert(_command == const.OFPFC_DELETE)
        obj.idle_timeout = struct.unpack_from('!H', buf, 58)[0]
        obj.hard_timeout = struct.unpack_from('!H', buf, 60)[0]
        obj.priority = struct.unpack_from('!H', buf, 62)[0]
        obj.buffer_id = struct.unpack_from('!L', buf, 64)[0]
        obj.out_port = struct.unpack_from('!H', buf, 68)[0]
        obj.flags = struct.unpack_from('!H', buf, 70)[0]
        obj.actions = action.unpack_list(buffer(buf, 72))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_delete {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_delete_strict(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_DELETE_STRICT

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!H", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!H", self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append("".join([x.pack() for x in self.actions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_delete_strict()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_FLOW_MOD)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 72: raise loxi.ProtocolError("flow_delete_strict length is %d, should be at least 72" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.match = common.match.unpack(buffer(buf, 8))
        obj.cookie = struct.unpack_from('!Q', buf, 48)[0]
        _command = struct.unpack_from('!H', buf, 56)[0]
        assert(_command == const.OFPFC_DELETE_STRICT)
        obj.idle_timeout = struct.unpack_from('!H', buf, 58)[0]
        obj.hard_timeout = struct.unpack_from('!H', buf, 60)[0]
        obj.priority = struct.unpack_from('!H', buf, 62)[0]
        obj.buffer_id = struct.unpack_from('!L', buf, 64)[0]
        obj.out_port = struct.unpack_from('!H', buf, 68)[0]
        obj.flags = struct.unpack_from('!H', buf, 70)[0]
        obj.actions = action.unpack_list(buffer(buf, 72))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_delete_strict {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_modify(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_MODIFY

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!H", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!H", self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append("".join([x.pack() for x in self.actions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_modify()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_FLOW_MOD)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 72: raise loxi.ProtocolError("flow_modify length is %d, should be at least 72" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.match = common.match.unpack(buffer(buf, 8))
        obj.cookie = struct.unpack_from('!Q', buf, 48)[0]
        _command = struct.unpack_from('!H', buf, 56)[0]
        assert(_command == const.OFPFC_MODIFY)
        obj.idle_timeout = struct.unpack_from('!H', buf, 58)[0]
        obj.hard_timeout = struct.unpack_from('!H', buf, 60)[0]
        obj.priority = struct.unpack_from('!H', buf, 62)[0]
        obj.buffer_id = struct.unpack_from('!L', buf, 64)[0]
        obj.out_port = struct.unpack_from('!H', buf, 68)[0]
        obj.flags = struct.unpack_from('!H', buf, 70)[0]
        obj.actions = action.unpack_list(buffer(buf, 72))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_modify {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_modify_strict(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_MODIFY_STRICT

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!H", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!H", self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append("".join([x.pack() for x in self.actions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_modify_strict()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_FLOW_MOD)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 72: raise loxi.ProtocolError("flow_modify_strict length is %d, should be at least 72" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.match = common.match.unpack(buffer(buf, 8))
        obj.cookie = struct.unpack_from('!Q', buf, 48)[0]
        _command = struct.unpack_from('!H', buf, 56)[0]
        assert(_command == const.OFPFC_MODIFY_STRICT)
        obj.idle_timeout = struct.unpack_from('!H', buf, 58)[0]
        obj.hard_timeout = struct.unpack_from('!H', buf, 60)[0]
        obj.priority = struct.unpack_from('!H', buf, 62)[0]
        obj.buffer_id = struct.unpack_from('!L', buf, 64)[0]
        obj.out_port = struct.unpack_from('!H', buf, 68)[0]
        obj.flags = struct.unpack_from('!H', buf, 70)[0]
        obj.actions = action.unpack_list(buffer(buf, 72))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_modify_strict {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_removed(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_REMOVED

    def __init__(self, xid=None, match=None, cookie=None, priority=None, reason=None, pad=None, duration_sec=None, duration_nsec=None, idle_timeout=None, pad2=None, packet_count=None, byte_count=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if pad2 != None:
            self.pad2 = pad2
        else:
            self.pad2 = [0,0]
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!B", self.reason))
        packed.append(struct.pack("!B", self.pad))
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!2B", *self.pad2))
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_removed()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_FLOW_REMOVED)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 88: raise loxi.ProtocolError("flow_removed length is %d, should be 88" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.match = common.match.unpack(buffer(buf, 8))
        obj.cookie = struct.unpack_from('!Q', buf, 48)[0]
        obj.priority = struct.unpack_from('!H', buf, 56)[0]
        obj.reason = struct.unpack_from('!B', buf, 58)[0]
        obj.pad = struct.unpack_from('!B', buf, 59)[0]
        obj.duration_sec = struct.unpack_from('!L', buf, 60)[0]
        obj.duration_nsec = struct.unpack_from('!L', buf, 64)[0]
        obj.idle_timeout = struct.unpack_from('!H', buf, 68)[0]
        obj.pad2 = list(struct.unpack_from('!2B', buf, 70))
        obj.packet_count = struct.unpack_from('!Q', buf, 72)[0]
        obj.byte_count = struct.unpack_from('!Q', buf, 80)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.priority != other.priority: return False
        if self.reason != other.reason: return False
        if self.pad != other.pad: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.pad2 != other.pad2: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_removed {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.text("%#x" % self.pad)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("pad2 = ");
                q.pp(self.pad2)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
            q.breakable()
        q.text('}')

class flow_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_FLOW

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_stats_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 12: raise loxi.ProtocolError("flow_stats_reply length is %d, should be at least 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_FLOW)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.entries = common.unpack_list_flow_stats_entry(buffer(buf, 12))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class flow_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_FLOW

    def __init__(self, xid=None, flags=None, match=None, table_id=None, pad=None, out_port=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(self.match.pack())
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!B", self.pad))
        packed.append(struct.pack("!H", self.out_port))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_stats_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 56: raise loxi.ProtocolError("flow_stats_request length is %d, should be 56" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_FLOW)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.match = common.match.unpack(buffer(buf, 12))
        obj.table_id = struct.unpack_from('!B', buf, 52)[0]
        obj.pad = struct.unpack_from('!B', buf, 53)[0]
        obj.out_port = struct.unpack_from('!H', buf, 54)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.table_id != other.table_id: return False
        if self.pad != other.pad: return False
        if self.out_port != other.out_port: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.text("%#x" % self.pad)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
            q.breakable()
        q.text('}')

class get_config_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_GET_CONFIG_REPLY

    def __init__(self, xid=None, flags=None, miss_send_len=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if miss_send_len != None:
            self.miss_send_len = miss_send_len
        else:
            self.miss_send_len = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.miss_send_len))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = get_config_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_GET_CONFIG_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 12: raise loxi.ProtocolError("get_config_reply length is %d, should be 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.flags = struct.unpack_from('!H', buf, 8)[0]
        obj.miss_send_len = struct.unpack_from('!H', buf, 10)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.miss_send_len != other.miss_send_len: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("get_config_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("miss_send_len = ");
                q.text("%#x" % self.miss_send_len)
            q.breakable()
        q.text('}')

class get_config_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_GET_CONFIG_REQUEST

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = get_config_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_GET_CONFIG_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 8: raise loxi.ProtocolError("get_config_request length is %d, should be 8" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("get_config_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class hello(Message):
    version = const.OFP_VERSION
    type = const.OFPT_HELLO

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = hello()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_HELLO)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 8: raise loxi.ProtocolError("hello length is %d, should be 8" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("hello {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class nicira_controller_role_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x2320
    subtype = 11

    def __init__(self, xid=None, role=None):
        self.xid = xid
        if role != None:
            self.role = role
        else:
            self.role = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.role))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = nicira_controller_role_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 20: raise loxi.ProtocolError("nicira_controller_role_reply length is %d, should be 20" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x2320)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 11)
        obj.role = struct.unpack_from('!L', buf, 16)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.role != other.role: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("nicira_controller_role_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("role = ");
                q.text("%#x" % self.role)
            q.breakable()
        q.text('}')

class nicira_controller_role_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_VENDOR
    experimenter = 0x2320
    subtype = 10

    def __init__(self, xid=None, role=None):
        self.xid = xid
        if role != None:
            self.role = role
        else:
            self.role = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.role))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = nicira_controller_role_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_VENDOR)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 20: raise loxi.ProtocolError("nicira_controller_role_request length is %d, should be 20" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        experimenter = struct.unpack_from('!L', buf, 8)[0]
        assert(experimenter == 0x2320)
        subtype = struct.unpack_from('!L', buf, 12)[0]
        assert(subtype == 10)
        obj.role = struct.unpack_from('!L', buf, 16)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.role != other.role: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("nicira_controller_role_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("role = ");
                q.text("%#x" % self.role)
            q.breakable()
        q.text('}')

class packet_in(Message):
    version = const.OFP_VERSION
    type = const.OFPT_PACKET_IN

    def __init__(self, xid=None, buffer_id=None, total_len=None, in_port=None, reason=None, pad=None, data=None):
        self.xid = xid
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if total_len != None:
            self.total_len = total_len
        else:
            self.total_len = 0
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = 0
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!H", self.total_len))
        packed.append(struct.pack("!H", self.in_port))
        packed.append(struct.pack("!B", self.reason))
        packed.append(struct.pack("!B", self.pad))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = packet_in()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_PACKET_IN)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 18: raise loxi.ProtocolError("packet_in length is %d, should be at least 18" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.buffer_id = struct.unpack_from('!L', buf, 8)[0]
        obj.total_len = struct.unpack_from('!H', buf, 12)[0]
        obj.in_port = struct.unpack_from('!H', buf, 14)[0]
        obj.reason = struct.unpack_from('!B', buf, 16)[0]
        obj.pad = struct.unpack_from('!B', buf, 17)[0]
        obj.data = buf[18:]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.buffer_id != other.buffer_id: return False
        if self.total_len != other.total_len: return False
        if self.in_port != other.in_port: return False
        if self.reason != other.reason: return False
        if self.pad != other.pad: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("packet_in {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("total_len = ");
                q.text("%#x" % self.total_len)
                q.text(","); q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.text("%#x" % self.pad)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class packet_out(Message):
    version = const.OFP_VERSION
    type = const.OFPT_PACKET_OUT

    def __init__(self, xid=None, buffer_id=None, in_port=None, actions=None, data=None):
        self.xid = xid
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 3
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!H", self.in_port))
        packed_actions = "".join([x.pack() for x in self.actions])
        packed.append(struct.pack("!H", len(packed_actions)))
        packed.append(packed_actions)
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = packet_out()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_PACKET_OUT)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 16: raise loxi.ProtocolError("packet_out length is %d, should be at least 16" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.buffer_id = struct.unpack_from('!L', buf, 8)[0]
        obj.in_port = struct.unpack_from('!H', buf, 12)[0]
        actions_len = struct.unpack_from('!H', buf, 14)[0]
        obj.actions = action.unpack_list(buffer(buf, 16, actions_len))
        obj.data = str(buffer(buf, 16+actions_len))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.buffer_id != other.buffer_id: return False
        if self.in_port != other.in_port: return False
        if self.actions != other.actions: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("packet_out {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class port_mod(Message):
    version = const.OFP_VERSION
    type = const.OFPT_PORT_MOD

    def __init__(self, xid=None, port_no=None, hw_addr=None, config=None, mask=None, advertise=None, pad=None):
        self.xid = xid
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if config != None:
            self.config = config
        else:
            self.config = 0
        if mask != None:
            self.mask = mask
        else:
            self.mask = 0
        if advertise != None:
            self.advertise = advertise
        else:
            self.advertise = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.port_no))
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.mask))
        packed.append(struct.pack("!L", self.advertise))
        packed.append(struct.pack("!4B", *self.pad))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_mod()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_PORT_MOD)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 32: raise loxi.ProtocolError("port_mod length is %d, should be 32" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.port_no = struct.unpack_from('!H', buf, 8)[0]
        obj.hw_addr = list(struct.unpack_from('!6B', buf, 10))
        obj.config = struct.unpack_from('!L', buf, 16)[0]
        obj.mask = struct.unpack_from('!L', buf, 20)[0]
        obj.advertise = struct.unpack_from('!L', buf, 24)[0]
        obj.pad = list(struct.unpack_from('!4B', buf, 28))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.port_no != other.port_no: return False
        if self.hw_addr != other.hw_addr: return False
        if self.config != other.config: return False
        if self.mask != other.mask: return False
        if self.advertise != other.advertise: return False
        if self.pad != other.pad: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("mask = ");
                q.text("%#x" % self.mask)
                q.text(","); q.breakable()
                q.text("advertise = ");
                q.text("%#x" % self.advertise)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
            q.breakable()
        q.text('}')

class port_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_PORT

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_stats_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 12: raise loxi.ProtocolError("port_stats_reply length is %d, should be at least 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_PORT)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.entries = util.unpack_array(common.port_stats_entry.unpack, 104, buffer(buf, 12))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class port_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_PORT

    def __init__(self, xid=None, flags=None, port_no=None, pad=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0,0,0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.port_no))
        packed.append(struct.pack("!6B", *self.pad))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_stats_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 20: raise loxi.ProtocolError("port_stats_request length is %d, should be 20" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_PORT)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.port_no = struct.unpack_from('!H', buf, 12)[0]
        obj.pad = list(struct.unpack_from('!6B', buf, 14))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        if self.pad != other.pad: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
            q.breakable()
        q.text('}')

class port_status(Message):
    version = const.OFP_VERSION
    type = const.OFPT_PORT_STATUS

    def __init__(self, xid=None, reason=None, pad=None, desc=None):
        self.xid = xid
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0,0,0,0,0]
        if desc != None:
            self.desc = desc
        else:
            self.desc = common.port_desc()

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!B", self.reason))
        packed.append(struct.pack("!7B", *self.pad))
        packed.append(self.desc.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_status()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_PORT_STATUS)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 64: raise loxi.ProtocolError("port_status length is %d, should be 64" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.reason = struct.unpack_from('!B', buf, 8)[0]
        obj.pad = list(struct.unpack_from('!7B', buf, 9))
        obj.desc = common.port_desc.unpack(buffer(buf, 16))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.reason != other.reason: return False
        if self.pad != other.pad: return False
        if self.desc != other.desc: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_status {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("desc = ");
                q.pp(self.desc)
            q.breakable()
        q.text('}')

class queue_get_config_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_QUEUE_GET_CONFIG_REPLY

    def __init__(self, xid=None, port=None, pad=None, queues=None):
        self.xid = xid
        if port != None:
            self.port = port
        else:
            self.port = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0,0,0,0]
        if queues != None:
            self.queues = queues
        else:
            self.queues = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.port))
        packed.append(struct.pack("!6B", *self.pad))
        packed.append("".join([x.pack() for x in self.queues]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_get_config_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_QUEUE_GET_CONFIG_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 16: raise loxi.ProtocolError("queue_get_config_reply length is %d, should be at least 16" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.port = struct.unpack_from('!H', buf, 8)[0]
        obj.pad = list(struct.unpack_from('!6B', buf, 10))
        obj.queues = common.unpack_list_packet_queue(buffer(buf, 16))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.port != other.port: return False
        if self.pad != other.pad: return False
        if self.queues != other.queues: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_get_config_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("queues = ");
                q.pp(self.queues)
            q.breakable()
        q.text('}')

class queue_get_config_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_QUEUE_GET_CONFIG_REQUEST

    def __init__(self, xid=None, port=None, pad=None):
        self.xid = xid
        if port != None:
            self.port = port
        else:
            self.port = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0]

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.port))
        packed.append(struct.pack("!2B", *self.pad))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_get_config_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_QUEUE_GET_CONFIG_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 12: raise loxi.ProtocolError("queue_get_config_request length is %d, should be 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.port = struct.unpack_from('!H', buf, 8)[0]
        obj.pad = list(struct.unpack_from('!2B', buf, 10))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.port != other.port: return False
        if self.pad != other.pad: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_get_config_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
            q.breakable()
        q.text('}')

class queue_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_QUEUE

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_stats_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 12: raise loxi.ProtocolError("queue_stats_reply length is %d, should be at least 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_QUEUE)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.entries = util.unpack_array(common.queue_stats_entry.unpack, 32, buffer(buf, 12))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class queue_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_QUEUE

    def __init__(self, xid=None, flags=None, port_no=None, pad=None, queue_id=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0]
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.port_no))
        packed.append(struct.pack("!2B", *self.pad))
        packed.append(struct.pack("!L", self.queue_id))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_stats_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 20: raise loxi.ProtocolError("queue_stats_request length is %d, should be 20" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_QUEUE)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.port_no = struct.unpack_from('!H', buf, 12)[0]
        obj.pad = list(struct.unpack_from('!2B', buf, 14))
        obj.queue_id = struct.unpack_from('!L', buf, 16)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        if self.pad != other.pad: return False
        if self.queue_id != other.queue_id: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
            q.breakable()
        q.text('}')

class set_config(Message):
    version = const.OFP_VERSION
    type = const.OFPT_SET_CONFIG

    def __init__(self, xid=None, flags=None, miss_send_len=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if miss_send_len != None:
            self.miss_send_len = miss_send_len
        else:
            self.miss_send_len = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.miss_send_len))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = set_config()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_SET_CONFIG)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 12: raise loxi.ProtocolError("set_config length is %d, should be 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.flags = struct.unpack_from('!H', buf, 8)[0]
        obj.miss_send_len = struct.unpack_from('!H', buf, 10)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.miss_send_len != other.miss_send_len: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("set_config {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("miss_send_len = ");
                q.text("%#x" % self.miss_send_len)
            q.breakable()
        q.text('}')

class table_mod(Message):
    version = const.OFP_VERSION
    type = 22

    def __init__(self, xid=None, table_id=None, pad=None, config=None):
        self.xid = xid
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if pad != None:
            self.pad = pad
        else:
            self.pad = [0,0,0]
        if config != None:
            self.config = config
        else:
            self.config = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!3B", *self.pad))
        packed.append(struct.pack("!L", self.config))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = table_mod()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == 22)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 16: raise loxi.ProtocolError("table_mod length is %d, should be 16" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        obj.table_id = struct.unpack_from('!B', buf, 8)[0]
        obj.pad = list(struct.unpack_from('!3B', buf, 9))
        obj.config = struct.unpack_from('!L', buf, 12)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.table_id != other.table_id: return False
        if self.pad != other.pad: return False
        if self.config != other.config: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("pad = ");
                q.pp(self.pad)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
            q.breakable()
        q.text('}')

class table_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_TABLE

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = table_stats_reply()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REPLY)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length < 12: raise loxi.ProtocolError("table_stats_reply length is %d, should be at least 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_TABLE)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        obj.entries = util.unpack_array(common.table_stats_entry.unpack, 64, buffer(buf, 12))
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class table_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_TABLE

    def __init__(self, xid=None, flags=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = table_stats_request()
        version = struct.unpack_from('!B', buf, 0)[0]
        assert(version == const.OFP_VERSION)
        type = struct.unpack_from('!B', buf, 1)[0]
        assert(type == const.OFPT_STATS_REQUEST)
        _length = struct.unpack_from('!H', buf, 2)[0]
        assert(_length == len(buf))
        if _length != 12: raise loxi.ProtocolError("table_stats_request length is %d, should be 12" % _length)
        obj.xid = struct.unpack_from('!L', buf, 4)[0]
        stats_type = struct.unpack_from('!H', buf, 8)[0]
        assert(stats_type == const.OFPST_TABLE)
        obj.flags = struct.unpack_from('!H', buf, 10)[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')


def parse_header(buf):
    if len(buf) < 8:
        raise loxi.ProtocolError("too short to be an OpenFlow message")
    return struct.unpack_from("!BBHL", buf)

def parse_message(buf):
    msg_ver, msg_type, msg_len, msg_xid = parse_header(buf)
    if msg_ver != const.OFP_VERSION and msg_type != ofp.OFPT_HELLO:
        raise loxi.ProtocolError("wrong OpenFlow version")
    if len(buf) != msg_len:
        raise loxi.ProtocolError("incorrect message size")
    if msg_type in parsers:
        return parsers[msg_type](buf)
    else:
        raise loxi.ProtocolError("unexpected message type")

def parse_flow_mod(buf):
    if len(buf) < 56 + 2:
        raise loxi.ProtocolError("message too short")
    cmd, = struct.unpack_from("!H", buf, 56)
    if cmd in flow_mod_parsers:
        return flow_mod_parsers[cmd](buf)
    else:
        raise loxi.ProtocolError("unexpected flow mod cmd %u" % cmd)

def parse_stats_reply(buf):
    if len(buf) < 8 + 2:
        raise loxi.ProtocolError("message too short")
    stats_type, = struct.unpack_from("!H", buf, 8)
    if stats_type in stats_reply_parsers:
        return stats_reply_parsers[stats_type](buf)
    else:
        raise loxi.ProtocolError("unexpected stats type %u" % stats_type)

def parse_stats_request(buf):
    if len(buf) < 8 + 2:
        raise loxi.ProtocolError("message too short")
    stats_type, = struct.unpack_from("!H", buf, 8)
    if stats_type in stats_request_parsers:
        return stats_request_parsers[stats_type](buf)
    else:
        raise loxi.ProtocolError("unexpected stats type %u" % stats_type)

def parse_vendor(buf):
    if len(buf) < 16:
        raise loxi.ProtocolError("experimenter message too short")

    experimenter, = struct.unpack_from("!L", buf, 8)
    if experimenter == 0x005c16c7: # Big Switch Networks
        subtype, = struct.unpack_from("!L", buf, 12)
    elif experimenter == 0x00002320: # Nicira
        subtype, = struct.unpack_from("!L", buf, 12)
    else:
        raise loxi.ProtocolError("unexpected experimenter id %#x" % experimenter)

    if subtype in experimenter_parsers[experimenter]:
        return experimenter_parsers[experimenter][subtype](buf)
    else:
        raise loxi.ProtocolError("unexpected experimenter %#x subtype %#x" % (experimenter, subtype))

parsers = {
    22 : table_mod.unpack,
    const.OFPT_BARRIER_REPLY : barrier_reply.unpack,
    const.OFPT_BARRIER_REQUEST : barrier_request.unpack,
    const.OFPT_ECHO_REPLY : echo_reply.unpack,
    const.OFPT_ECHO_REQUEST : echo_request.unpack,
    const.OFPT_ERROR : error_msg.unpack,
    const.OFPT_FEATURES_REPLY : features_reply.unpack,
    const.OFPT_FEATURES_REQUEST : features_request.unpack,
    const.OFPT_FLOW_MOD : parse_flow_mod,
    const.OFPT_FLOW_REMOVED : flow_removed.unpack,
    const.OFPT_GET_CONFIG_REPLY : get_config_reply.unpack,
    const.OFPT_GET_CONFIG_REQUEST : get_config_request.unpack,
    const.OFPT_HELLO : hello.unpack,
    const.OFPT_PACKET_IN : packet_in.unpack,
    const.OFPT_PACKET_OUT : packet_out.unpack,
    const.OFPT_PORT_MOD : port_mod.unpack,
    const.OFPT_PORT_STATUS : port_status.unpack,
    const.OFPT_QUEUE_GET_CONFIG_REPLY : queue_get_config_reply.unpack,
    const.OFPT_QUEUE_GET_CONFIG_REQUEST : queue_get_config_request.unpack,
    const.OFPT_SET_CONFIG : set_config.unpack,
    const.OFPT_STATS_REPLY : parse_stats_reply,
    const.OFPT_STATS_REQUEST : parse_stats_request,
    const.OFPT_VENDOR : parse_vendor,
}

flow_mod_parsers = {
    const.OFPFC_ADD : flow_add.unpack,
    const.OFPFC_MODIFY : flow_modify.unpack,
    const.OFPFC_MODIFY_STRICT : flow_modify_strict.unpack,
    const.OFPFC_DELETE : flow_delete.unpack,
    const.OFPFC_DELETE_STRICT : flow_delete_strict.unpack,
}

stats_reply_parsers = {
    const.OFPST_DESC : desc_stats_reply.unpack,
    const.OFPST_FLOW : flow_stats_reply.unpack,
    const.OFPST_AGGREGATE : aggregate_stats_reply.unpack,
    const.OFPST_TABLE : table_stats_reply.unpack,
    const.OFPST_PORT : port_stats_reply.unpack,
    const.OFPST_QUEUE : queue_stats_reply.unpack,
    const.OFPST_VENDOR : experimenter_stats_reply.unpack,
}

stats_request_parsers = {
    const.OFPST_DESC : desc_stats_request.unpack,
    const.OFPST_FLOW : flow_stats_request.unpack,
    const.OFPST_AGGREGATE : aggregate_stats_request.unpack,
    const.OFPST_TABLE : table_stats_request.unpack,
    const.OFPST_PORT : port_stats_request.unpack,
    const.OFPST_QUEUE : queue_stats_request.unpack,
    const.OFPST_VENDOR : experimenter_stats_request.unpack,
}

experimenter_parsers = {
    0x2320 : {
        11: nicira_controller_role_reply.unpack,
        10: nicira_controller_role_request.unpack,
    },
    0x5c16c7 : {
        10: bsn_get_interfaces_reply.unpack,
        9: bsn_get_interfaces_request.unpack,
        2: bsn_get_ip_mask_reply.unpack,
        1: bsn_get_ip_mask_request.unpack,
        5: bsn_get_mirroring_reply.unpack,
        4: bsn_get_mirroring_request.unpack,
        0: bsn_set_ip_mask.unpack,
        3: bsn_set_mirroring.unpack,
        6: bsn_shell_command.unpack,
        7: bsn_shell_output.unpack,
        8: bsn_shell_status.unpack,
    },
}
