# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.
# See the file LICENSE.pyloxi which should have been included in the source distribution

# Automatically generated by LOXI from template module.py
# Do not modify

import struct
import loxi
import const
import common
import action
import instruction
import util
import loxi.generic_util

class message(loxi.OFObject):
    subtypes = {}

    version = 2

    def __init__(self, type=None, xid=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('B', 1)
        subclass = message.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = message()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        obj.type = reader.read("!B")[0]
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def pretty_print(self, q):
        q.text("message {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')


class stats_reply(message):
    subtypes = {}

    version = 2
    type = 19

    def __init__(self, xid=None, stats_type=None, flags=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if stats_type != None:
            self.stats_type = stats_type
        else:
            self.stats_type = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 8)
        subclass = stats_reply.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.stats_type = reader.read("!H")[0]
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.stats_type != other.stats_type: return False
        if self.flags != other.flags: return False
        return True

    def pretty_print(self, q):
        q.text("stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

message.subtypes[19] = stats_reply

class aggregate_stats_reply(stats_reply):
    version = 2
    type = 19
    stats_type = 2

    def __init__(self, xid=None, flags=None, packet_count=None, byte_count=None, flow_count=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if flow_count != None:
            self.flow_count = flow_count
        else:
            self.flow_count = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(struct.pack("!L", self.flow_count))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = aggregate_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 2)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        obj.flow_count = reader.read("!L")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.flow_count != other.flow_count: return False
        return True

    def pretty_print(self, q):
        q.text("aggregate_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("flow_count = ");
                q.text("%#x" % self.flow_count)
            q.breakable()
        q.text('}')

stats_reply.subtypes[2] = aggregate_stats_reply

class stats_request(message):
    subtypes = {}

    version = 2
    type = 18

    def __init__(self, xid=None, stats_type=None, flags=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if stats_type != None:
            self.stats_type = stats_type
        else:
            self.stats_type = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 8)
        subclass = stats_request.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.stats_type = reader.read("!H")[0]
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.stats_type != other.stats_type: return False
        if self.flags != other.flags: return False
        return True

    def pretty_print(self, q):
        q.text("stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

message.subtypes[18] = stats_request

class aggregate_stats_request(stats_request):
    version = 2
    type = 18
    stats_type = 2

    def __init__(self, xid=None, flags=None, table_id=None, out_port=None, out_group=None, cookie=None, cookie_mask=None, match=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 3)
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(self.match.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = aggregate_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 2)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.table_id = reader.read("!B")[0]
        reader.skip(3)
        obj.out_port = util.unpack_port_no(reader)
        obj.out_group = reader.read("!L")[0]
        reader.skip(4)
        obj.cookie = reader.read("!Q")[0]
        obj.cookie_mask = reader.read("!Q")[0]
        obj.match = common.match.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.table_id != other.table_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.match != other.match: return False
        return True

    def pretty_print(self, q):
        q.text("aggregate_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
            q.breakable()
        q.text('}')

stats_request.subtypes[2] = aggregate_stats_request

class error_msg(message):
    subtypes = {}

    version = 2
    type = 1

    def __init__(self, xid=None, err_type=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if err_type != None:
            self.err_type = err_type
        else:
            self.err_type = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 8)
        subclass = error_msg.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.err_type = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.err_type != other.err_type: return False
        return True

    def pretty_print(self, q):
        q.text("error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

message.subtypes[1] = error_msg

class bad_action_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 2

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bad_action_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 2)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("bad_action_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[2] = bad_action_error_msg

class bad_instruction_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 3

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bad_instruction_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 3)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("bad_instruction_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[3] = bad_instruction_error_msg

class bad_match_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 4

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bad_match_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 4)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("bad_match_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[4] = bad_match_error_msg

class bad_request_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 1

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bad_request_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 1)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("bad_request_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[1] = bad_request_error_msg

class barrier_reply(message):
    version = 2
    type = 21

    def __init__(self, xid=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = barrier_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 21)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        return True

    def pretty_print(self, q):
        q.text("barrier_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

message.subtypes[21] = barrier_reply

class barrier_request(message):
    version = 2
    type = 20

    def __init__(self, xid=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = barrier_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 20)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        return True

    def pretty_print(self, q):
        q.text("barrier_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

message.subtypes[20] = barrier_request

class experimenter(message):
    subtypes = {}

    version = 2
    type = 4

    def __init__(self, xid=None, experimenter=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 8)
        subclass = experimenter.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = experimenter()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.experimenter = reader.read("!L")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("experimenter {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

message.subtypes[4] = experimenter

class bsn_header(experimenter):
    subtypes = {}

    version = 2
    type = 4
    experimenter = 6035143

    def __init__(self, xid=None, subtype=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 12)
        subclass = bsn_header.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = bsn_header()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        obj.subtype = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.subtype != other.subtype: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_header {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

experimenter.subtypes[6035143] = bsn_header

class bsn_bw_clear_data_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 22

    def __init__(self, xid=None, status=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if status != None:
            self.status = status
        else:
            self.status = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_bw_clear_data_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 22)
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_bw_clear_data_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

bsn_header.subtypes[22] = bsn_bw_clear_data_reply

class bsn_bw_clear_data_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 21

    def __init__(self, xid=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_bw_clear_data_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 21)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_bw_clear_data_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

bsn_header.subtypes[21] = bsn_bw_clear_data_request

class bsn_bw_enable_get_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 20

    def __init__(self, xid=None, enabled=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if enabled != None:
            self.enabled = enabled
        else:
            self.enabled = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.enabled))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_bw_enable_get_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 20)
        obj.enabled = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.enabled != other.enabled: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_bw_enable_get_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("enabled = ");
                q.text("%#x" % self.enabled)
            q.breakable()
        q.text('}')

bsn_header.subtypes[20] = bsn_bw_enable_get_reply

class bsn_bw_enable_get_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 19

    def __init__(self, xid=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_bw_enable_get_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 19)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_bw_enable_get_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

bsn_header.subtypes[19] = bsn_bw_enable_get_request

class bsn_bw_enable_set_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 23

    def __init__(self, xid=None, enable=None, status=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if enable != None:
            self.enable = enable
        else:
            self.enable = 0
        if status != None:
            self.status = status
        else:
            self.status = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.enable))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_bw_enable_set_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 23)
        obj.enable = reader.read("!L")[0]
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.enable != other.enable: return False
        if self.status != other.status: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_bw_enable_set_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("enable = ");
                q.text("%#x" % self.enable)
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

bsn_header.subtypes[23] = bsn_bw_enable_set_reply

class bsn_bw_enable_set_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 18

    def __init__(self, xid=None, enable=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if enable != None:
            self.enable = enable
        else:
            self.enable = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.enable))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_bw_enable_set_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 18)
        obj.enable = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.enable != other.enable: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_bw_enable_set_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("enable = ");
                q.text("%#x" % self.enable)
            q.breakable()
        q.text('}')

bsn_header.subtypes[18] = bsn_bw_enable_set_request

class bsn_get_interfaces_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 10

    def __init__(self, xid=None, interfaces=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if interfaces != None:
            self.interfaces = interfaces
        else:
            self.interfaces = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(loxi.generic_util.pack_list(self.interfaces))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_get_interfaces_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 10)
        obj.interfaces = loxi.generic_util.unpack_list(reader, common.bsn_interface.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.interfaces != other.interfaces: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_get_interfaces_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("interfaces = ");
                q.pp(self.interfaces)
            q.breakable()
        q.text('}')

bsn_header.subtypes[10] = bsn_get_interfaces_reply

class bsn_get_interfaces_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 9

    def __init__(self, xid=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_get_interfaces_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 9)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_get_interfaces_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

bsn_header.subtypes[9] = bsn_get_interfaces_request

class bsn_get_mirroring_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 5

    def __init__(self, xid=None, report_mirror_ports=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_get_mirroring_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 5)
        obj.report_mirror_ports = reader.read("!B")[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_get_mirroring_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
            q.breakable()
        q.text('}')

bsn_header.subtypes[5] = bsn_get_mirroring_reply

class bsn_get_mirroring_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 4

    def __init__(self, xid=None, report_mirror_ports=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_get_mirroring_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 4)
        obj.report_mirror_ports = reader.read("!B")[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_get_mirroring_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
            q.breakable()
        q.text('}')

bsn_header.subtypes[4] = bsn_get_mirroring_request

class bsn_pdu_rx_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 34

    def __init__(self, xid=None, status=None, port_no=None, slot_num=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if status != None:
            self.status = status
        else:
            self.status = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if slot_num != None:
            self.slot_num = slot_num
        else:
            self.slot_num = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!B", self.slot_num))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_pdu_rx_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 34)
        obj.status = reader.read("!L")[0]
        obj.port_no = util.unpack_port_no(reader)
        obj.slot_num = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        if self.port_no != other.port_no: return False
        if self.slot_num != other.slot_num: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_pdu_rx_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("slot_num = ");
                q.text("%#x" % self.slot_num)
            q.breakable()
        q.text('}')

bsn_header.subtypes[34] = bsn_pdu_rx_reply

class bsn_pdu_rx_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 33

    def __init__(self, xid=None, timeout_ms=None, port_no=None, slot_num=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if timeout_ms != None:
            self.timeout_ms = timeout_ms
        else:
            self.timeout_ms = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if slot_num != None:
            self.slot_num = slot_num
        else:
            self.slot_num = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.timeout_ms))
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!B", self.slot_num))
        packed.append('\x00' * 3)
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_pdu_rx_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 33)
        obj.timeout_ms = reader.read("!L")[0]
        obj.port_no = util.unpack_port_no(reader)
        obj.slot_num = reader.read("!B")[0]
        reader.skip(3)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.timeout_ms != other.timeout_ms: return False
        if self.port_no != other.port_no: return False
        if self.slot_num != other.slot_num: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_pdu_rx_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("timeout_ms = ");
                q.text("%#x" % self.timeout_ms)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("slot_num = ");
                q.text("%#x" % self.slot_num)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

bsn_header.subtypes[33] = bsn_pdu_rx_request

class bsn_pdu_rx_timeout(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 35

    def __init__(self, xid=None, port_no=None, slot_num=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if slot_num != None:
            self.slot_num = slot_num
        else:
            self.slot_num = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!B", self.slot_num))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_pdu_rx_timeout()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 35)
        obj.port_no = util.unpack_port_no(reader)
        obj.slot_num = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.port_no != other.port_no: return False
        if self.slot_num != other.slot_num: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_pdu_rx_timeout {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("slot_num = ");
                q.text("%#x" % self.slot_num)
            q.breakable()
        q.text('}')

bsn_header.subtypes[35] = bsn_pdu_rx_timeout

class bsn_pdu_tx_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 32

    def __init__(self, xid=None, status=None, port_no=None, slot_num=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if status != None:
            self.status = status
        else:
            self.status = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if slot_num != None:
            self.slot_num = slot_num
        else:
            self.slot_num = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!B", self.slot_num))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_pdu_tx_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 32)
        obj.status = reader.read("!L")[0]
        obj.port_no = util.unpack_port_no(reader)
        obj.slot_num = reader.read("!B")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        if self.port_no != other.port_no: return False
        if self.slot_num != other.slot_num: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_pdu_tx_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("slot_num = ");
                q.text("%#x" % self.slot_num)
            q.breakable()
        q.text('}')

bsn_header.subtypes[32] = bsn_pdu_tx_reply

class bsn_pdu_tx_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 31

    def __init__(self, xid=None, tx_interval_ms=None, port_no=None, slot_num=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if tx_interval_ms != None:
            self.tx_interval_ms = tx_interval_ms
        else:
            self.tx_interval_ms = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if slot_num != None:
            self.slot_num = slot_num
        else:
            self.slot_num = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.tx_interval_ms))
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!B", self.slot_num))
        packed.append('\x00' * 3)
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_pdu_tx_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 31)
        obj.tx_interval_ms = reader.read("!L")[0]
        obj.port_no = util.unpack_port_no(reader)
        obj.slot_num = reader.read("!B")[0]
        reader.skip(3)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.tx_interval_ms != other.tx_interval_ms: return False
        if self.port_no != other.port_no: return False
        if self.slot_num != other.slot_num: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_pdu_tx_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("tx_interval_ms = ");
                q.text("%#x" % self.tx_interval_ms)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("slot_num = ");
                q.text("%#x" % self.slot_num)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

bsn_header.subtypes[31] = bsn_pdu_tx_request

class bsn_set_mirroring(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 3

    def __init__(self, xid=None, report_mirror_ports=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_set_mirroring()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 3)
        obj.report_mirror_ports = reader.read("!B")[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_set_mirroring {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
            q.breakable()
        q.text('}')

bsn_header.subtypes[3] = bsn_set_mirroring

class bsn_set_pktin_suppression_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 25

    def __init__(self, xid=None, status=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if status != None:
            self.status = status
        else:
            self.status = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_set_pktin_suppression_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 25)
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_set_pktin_suppression_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

bsn_header.subtypes[25] = bsn_set_pktin_suppression_reply

class bsn_set_pktin_suppression_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 11

    def __init__(self, xid=None, enabled=None, idle_timeout=None, hard_timeout=None, priority=None, cookie=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if enabled != None:
            self.enabled = enabled
        else:
            self.enabled = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.enabled))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!Q", self.cookie))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_set_pktin_suppression_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 11)
        obj.enabled = reader.read("!B")[0]
        reader.skip(1)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.cookie = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.enabled != other.enabled: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.cookie != other.cookie: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_set_pktin_suppression_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("enabled = ");
                q.text("%#x" % self.enabled)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
            q.breakable()
        q.text('}')

bsn_header.subtypes[11] = bsn_set_pktin_suppression_request

class experimenter_stats_reply(stats_reply):
    subtypes = {}

    version = 2
    type = 19
    stats_type = 65535

    def __init__(self, xid=None, flags=None, experimenter=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.experimenter))
        packed.append('\x00' * 4)
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 16)
        subclass = experimenter_stats_reply.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = experimenter_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 65535)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.experimenter = reader.read("!L")[0]
        reader.skip(4)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("experimenter_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

stats_reply.subtypes[65535] = experimenter_stats_reply

class bsn_stats_reply(experimenter_stats_reply):
    subtypes = {}

    version = 2
    type = 19
    stats_type = 65535
    experimenter = 6035143

    def __init__(self, xid=None, flags=None, subtype=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 20)
        subclass = bsn_stats_reply.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = bsn_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 65535)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        obj.subtype = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.subtype != other.subtype: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

experimenter_stats_reply.subtypes[6035143] = bsn_stats_reply

class experimenter_stats_request(stats_request):
    subtypes = {}

    version = 2
    type = 18
    stats_type = 65535

    def __init__(self, xid=None, flags=None, experimenter=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.experimenter))
        packed.append('\x00' * 4)
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 16)
        subclass = experimenter_stats_request.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = experimenter_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 65535)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.experimenter = reader.read("!L")[0]
        reader.skip(4)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("experimenter_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

stats_request.subtypes[65535] = experimenter_stats_request

class bsn_stats_request(experimenter_stats_request):
    subtypes = {}

    version = 2
    type = 18
    stats_type = 65535
    experimenter = 6035143

    def __init__(self, xid=None, flags=None, subtype=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 20)
        subclass = bsn_stats_request.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = bsn_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 65535)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        obj.subtype = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.subtype != other.subtype: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

experimenter_stats_request.subtypes[6035143] = bsn_stats_request

class bsn_virtual_port_create_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 16

    def __init__(self, xid=None, status=None, vport_no=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if status != None:
            self.status = status
        else:
            self.status = 0
        if vport_no != None:
            self.vport_no = vport_no
        else:
            self.vport_no = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        packed.append(struct.pack("!L", self.vport_no))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_virtual_port_create_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 16)
        obj.status = reader.read("!L")[0]
        obj.vport_no = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        if self.vport_no != other.vport_no: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_virtual_port_create_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
                q.text(","); q.breakable()
                q.text("vport_no = ");
                q.text("%#x" % self.vport_no)
            q.breakable()
        q.text('}')

bsn_header.subtypes[16] = bsn_virtual_port_create_reply

class bsn_virtual_port_create_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 15

    def __init__(self, xid=None, vport=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if vport != None:
            self.vport = vport
        else:
            self.vport = common.bsn_vport()
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(self.vport.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_virtual_port_create_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 15)
        obj.vport = common.bsn_vport.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.vport != other.vport: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_virtual_port_create_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("vport = ");
                q.pp(self.vport)
            q.breakable()
        q.text('}')

bsn_header.subtypes[15] = bsn_virtual_port_create_request

class bsn_virtual_port_remove_reply(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 26

    def __init__(self, xid=None, status=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if status != None:
            self.status = status
        else:
            self.status = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_virtual_port_remove_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 26)
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_virtual_port_remove_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

bsn_header.subtypes[26] = bsn_virtual_port_remove_reply

class bsn_virtual_port_remove_request(bsn_header):
    version = 2
    type = 4
    experimenter = 6035143
    subtype = 17

    def __init__(self, xid=None, vport_no=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if vport_no != None:
            self.vport_no = vport_no
        else:
            self.vport_no = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.vport_no))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = bsn_virtual_port_remove_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 17)
        obj.vport_no = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.vport_no != other.vport_no: return False
        return True

    def pretty_print(self, q):
        q.text("bsn_virtual_port_remove_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("vport_no = ");
                q.text("%#x" % self.vport_no)
            q.breakable()
        q.text('}')

bsn_header.subtypes[17] = bsn_virtual_port_remove_request

class desc_stats_reply(stats_reply):
    version = 2
    type = 19
    stats_type = 0

    def __init__(self, xid=None, flags=None, mfr_desc=None, hw_desc=None, sw_desc=None, serial_num=None, dp_desc=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if mfr_desc != None:
            self.mfr_desc = mfr_desc
        else:
            self.mfr_desc = ""
        if hw_desc != None:
            self.hw_desc = hw_desc
        else:
            self.hw_desc = ""
        if sw_desc != None:
            self.sw_desc = sw_desc
        else:
            self.sw_desc = ""
        if serial_num != None:
            self.serial_num = serial_num
        else:
            self.serial_num = ""
        if dp_desc != None:
            self.dp_desc = dp_desc
        else:
            self.dp_desc = ""
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!256s", self.mfr_desc))
        packed.append(struct.pack("!256s", self.hw_desc))
        packed.append(struct.pack("!256s", self.sw_desc))
        packed.append(struct.pack("!32s", self.serial_num))
        packed.append(struct.pack("!256s", self.dp_desc))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = desc_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 0)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.mfr_desc = reader.read("!256s")[0].rstrip("\x00")
        obj.hw_desc = reader.read("!256s")[0].rstrip("\x00")
        obj.sw_desc = reader.read("!256s")[0].rstrip("\x00")
        obj.serial_num = reader.read("!32s")[0].rstrip("\x00")
        obj.dp_desc = reader.read("!256s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.mfr_desc != other.mfr_desc: return False
        if self.hw_desc != other.hw_desc: return False
        if self.sw_desc != other.sw_desc: return False
        if self.serial_num != other.serial_num: return False
        if self.dp_desc != other.dp_desc: return False
        return True

    def pretty_print(self, q):
        q.text("desc_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("mfr_desc = ");
                q.pp(self.mfr_desc)
                q.text(","); q.breakable()
                q.text("hw_desc = ");
                q.pp(self.hw_desc)
                q.text(","); q.breakable()
                q.text("sw_desc = ");
                q.pp(self.sw_desc)
                q.text(","); q.breakable()
                q.text("serial_num = ");
                q.pp(self.serial_num)
                q.text(","); q.breakable()
                q.text("dp_desc = ");
                q.pp(self.dp_desc)
            q.breakable()
        q.text('}')

stats_reply.subtypes[0] = desc_stats_reply

class desc_stats_request(stats_request):
    version = 2
    type = 18
    stats_type = 0

    def __init__(self, xid=None, flags=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = desc_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 0)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def pretty_print(self, q):
        q.text("desc_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

stats_request.subtypes[0] = desc_stats_request

class echo_reply(message):
    version = 2
    type = 3

    def __init__(self, xid=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = echo_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 3)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("echo_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

message.subtypes[3] = echo_reply

class echo_request(message):
    version = 2
    type = 2

    def __init__(self, xid=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = echo_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 2)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("echo_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

message.subtypes[2] = echo_request

class features_reply(message):
    version = 2
    type = 6

    def __init__(self, xid=None, datapath_id=None, n_buffers=None, n_tables=None, capabilities=None, reserved=None, ports=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if datapath_id != None:
            self.datapath_id = datapath_id
        else:
            self.datapath_id = 0
        if n_buffers != None:
            self.n_buffers = n_buffers
        else:
            self.n_buffers = 0
        if n_tables != None:
            self.n_tables = n_tables
        else:
            self.n_tables = 0
        if capabilities != None:
            self.capabilities = capabilities
        else:
            self.capabilities = 0
        if reserved != None:
            self.reserved = reserved
        else:
            self.reserved = 0
        if ports != None:
            self.ports = ports
        else:
            self.ports = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.datapath_id))
        packed.append(struct.pack("!L", self.n_buffers))
        packed.append(struct.pack("!B", self.n_tables))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.capabilities))
        packed.append(struct.pack("!L", self.reserved))
        packed.append(loxi.generic_util.pack_list(self.ports))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = features_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 6)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.datapath_id = reader.read("!Q")[0]
        obj.n_buffers = reader.read("!L")[0]
        obj.n_tables = reader.read("!B")[0]
        reader.skip(3)
        obj.capabilities = reader.read("!L")[0]
        obj.reserved = reader.read("!L")[0]
        obj.ports = loxi.generic_util.unpack_list(reader, common.port_desc.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.datapath_id != other.datapath_id: return False
        if self.n_buffers != other.n_buffers: return False
        if self.n_tables != other.n_tables: return False
        if self.capabilities != other.capabilities: return False
        if self.reserved != other.reserved: return False
        if self.ports != other.ports: return False
        return True

    def pretty_print(self, q):
        q.text("features_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("datapath_id = ");
                q.text("%#x" % self.datapath_id)
                q.text(","); q.breakable()
                q.text("n_buffers = ");
                q.text("%#x" % self.n_buffers)
                q.text(","); q.breakable()
                q.text("n_tables = ");
                q.text("%#x" % self.n_tables)
                q.text(","); q.breakable()
                q.text("capabilities = ");
                q.text("%#x" % self.capabilities)
                q.text(","); q.breakable()
                q.text("reserved = ");
                q.text("%#x" % self.reserved)
                q.text(","); q.breakable()
                q.text("ports = ");
                q.pp(self.ports)
            q.breakable()
        q.text('}')

message.subtypes[6] = features_reply

class features_request(message):
    version = 2
    type = 5

    def __init__(self, xid=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = features_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 5)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        return True

    def pretty_print(self, q):
        q.text("features_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

message.subtypes[5] = features_request

class flow_mod(message):
    subtypes = {}

    version = 2
    type = 14

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, _command=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if _command != None:
            self._command = _command
        else:
            self._command = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append(loxi.generic_util.pack_list(self.instructions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('B', 25)
        subclass = flow_mod.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = flow_mod()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.cookie = reader.read("!Q")[0]
        obj.cookie_mask = reader.read("!Q")[0]
        obj.table_id = reader.read("!B")[0]
        obj._command = util.unpack_fm_cmd(reader)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.out_group = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = loxi.generic_util.unpack_list(reader, instruction.instruction.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self._command != other._command: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def pretty_print(self, q):
        q.text("flow_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

message.subtypes[14] = flow_mod

class flow_add(flow_mod):
    version = 2
    type = 14
    _command = 0

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append(loxi.generic_util.pack_list(self.instructions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_add()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.cookie = reader.read("!Q")[0]
        obj.cookie_mask = reader.read("!Q")[0]
        obj.table_id = reader.read("!B")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 0)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.out_group = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = loxi.generic_util.unpack_list(reader, instruction.instruction.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def pretty_print(self, q):
        q.text("flow_add {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

flow_mod.subtypes[0] = flow_add

class flow_delete(flow_mod):
    version = 2
    type = 14
    _command = 3

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append(loxi.generic_util.pack_list(self.instructions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_delete()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.cookie = reader.read("!Q")[0]
        obj.cookie_mask = reader.read("!Q")[0]
        obj.table_id = reader.read("!B")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 3)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.out_group = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = loxi.generic_util.unpack_list(reader, instruction.instruction.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def pretty_print(self, q):
        q.text("flow_delete {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

flow_mod.subtypes[3] = flow_delete

class flow_delete_strict(flow_mod):
    version = 2
    type = 14
    _command = 4

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append(loxi.generic_util.pack_list(self.instructions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_delete_strict()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.cookie = reader.read("!Q")[0]
        obj.cookie_mask = reader.read("!Q")[0]
        obj.table_id = reader.read("!B")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 4)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.out_group = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = loxi.generic_util.unpack_list(reader, instruction.instruction.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def pretty_print(self, q):
        q.text("flow_delete_strict {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

flow_mod.subtypes[4] = flow_delete_strict

class flow_mod_failed_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 5

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_mod_failed_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 5)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("flow_mod_failed_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[5] = flow_mod_failed_error_msg

class flow_modify(flow_mod):
    version = 2
    type = 14
    _command = 1

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append(loxi.generic_util.pack_list(self.instructions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_modify()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.cookie = reader.read("!Q")[0]
        obj.cookie_mask = reader.read("!Q")[0]
        obj.table_id = reader.read("!B")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 1)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.out_group = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = loxi.generic_util.unpack_list(reader, instruction.instruction.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def pretty_print(self, q):
        q.text("flow_modify {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

flow_mod.subtypes[1] = flow_modify

class flow_modify_strict(flow_mod):
    version = 2
    type = 14
    _command = 2

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append(loxi.generic_util.pack_list(self.instructions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_modify_strict()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.cookie = reader.read("!Q")[0]
        obj.cookie_mask = reader.read("!Q")[0]
        obj.table_id = reader.read("!B")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 2)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.out_group = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = loxi.generic_util.unpack_list(reader, instruction.instruction.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def pretty_print(self, q):
        q.text("flow_modify_strict {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

flow_mod.subtypes[2] = flow_modify_strict

class flow_removed(message):
    version = 2
    type = 11

    def __init__(self, xid=None, cookie=None, priority=None, reason=None, table_id=None, duration_sec=None, duration_nsec=None, idle_timeout=None, packet_count=None, byte_count=None, match=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!B", self.reason))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(self.match.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_removed()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 11)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.cookie = reader.read("!Q")[0]
        obj.priority = reader.read("!H")[0]
        obj.reason = reader.read("!B")[0]
        obj.table_id = reader.read("!B")[0]
        obj.duration_sec = reader.read("!L")[0]
        obj.duration_nsec = reader.read("!L")[0]
        obj.idle_timeout = reader.read("!H")[0]
        reader.skip(2)
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        obj.match = common.match.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.priority != other.priority: return False
        if self.reason != other.reason: return False
        if self.table_id != other.table_id: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.match != other.match: return False
        return True

    def pretty_print(self, q):
        q.text("flow_removed {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
            q.breakable()
        q.text('}')

message.subtypes[11] = flow_removed

class flow_stats_reply(stats_reply):
    version = 2
    type = 19
    stats_type = 1

    def __init__(self, xid=None, flags=None, entries=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(loxi.generic_util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 1)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.entries = loxi.generic_util.unpack_list(reader, common.flow_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def pretty_print(self, q):
        q.text("flow_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

stats_reply.subtypes[1] = flow_stats_reply

class flow_stats_request(stats_request):
    version = 2
    type = 18
    stats_type = 1

    def __init__(self, xid=None, flags=None, table_id=None, out_port=None, out_group=None, cookie=None, cookie_mask=None, match=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 3)
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(self.match.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = flow_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 1)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.table_id = reader.read("!B")[0]
        reader.skip(3)
        obj.out_port = util.unpack_port_no(reader)
        obj.out_group = reader.read("!L")[0]
        reader.skip(4)
        obj.cookie = reader.read("!Q")[0]
        obj.cookie_mask = reader.read("!Q")[0]
        obj.match = common.match.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.table_id != other.table_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.match != other.match: return False
        return True

    def pretty_print(self, q):
        q.text("flow_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
            q.breakable()
        q.text('}')

stats_request.subtypes[1] = flow_stats_request

class get_config_reply(message):
    version = 2
    type = 8

    def __init__(self, xid=None, flags=None, miss_send_len=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if miss_send_len != None:
            self.miss_send_len = miss_send_len
        else:
            self.miss_send_len = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.miss_send_len))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = get_config_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 8)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        obj.miss_send_len = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.miss_send_len != other.miss_send_len: return False
        return True

    def pretty_print(self, q):
        q.text("get_config_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("miss_send_len = ");
                q.text("%#x" % self.miss_send_len)
            q.breakable()
        q.text('}')

message.subtypes[8] = get_config_reply

class get_config_request(message):
    version = 2
    type = 7

    def __init__(self, xid=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = get_config_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 7)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        return True

    def pretty_print(self, q):
        q.text("get_config_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

message.subtypes[7] = get_config_request

class group_mod(message):
    subtypes = {}

    version = 2
    type = 15

    def __init__(self, xid=None, command=None, group_type=None, group_id=None, buckets=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if command != None:
            self.command = command
        else:
            self.command = 0
        if group_type != None:
            self.group_type = group_type
        else:
            self.group_type = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if buckets != None:
            self.buckets = buckets
        else:
            self.buckets = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.command))
        packed.append(struct.pack("!B", self.group_type))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.group_id))
        packed.append(loxi.generic_util.pack_list(self.buckets))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!H', 8)
        subclass = group_mod.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = group_mod()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 15)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.command = reader.read("!H")[0]
        obj.group_type = reader.read("!B")[0]
        reader.skip(1)
        obj.group_id = reader.read("!L")[0]
        obj.buckets = loxi.generic_util.unpack_list(reader, common.bucket.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.command != other.command: return False
        if self.group_type != other.group_type: return False
        if self.group_id != other.group_id: return False
        if self.buckets != other.buckets: return False
        return True

    def pretty_print(self, q):
        q.text("group_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("group_type = ");
                q.text("%#x" % self.group_type)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("buckets = ");
                q.pp(self.buckets)
            q.breakable()
        q.text('}')

message.subtypes[15] = group_mod

class group_add(group_mod):
    version = 2
    type = 15
    command = 0

    def __init__(self, xid=None, group_type=None, group_id=None, buckets=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if group_type != None:
            self.group_type = group_type
        else:
            self.group_type = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if buckets != None:
            self.buckets = buckets
        else:
            self.buckets = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.command))
        packed.append(struct.pack("!B", self.group_type))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.group_id))
        packed.append(loxi.generic_util.pack_list(self.buckets))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_add()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 15)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _command = reader.read("!H")[0]
        assert(_command == 0)
        obj.group_type = reader.read("!B")[0]
        reader.skip(1)
        obj.group_id = reader.read("!L")[0]
        obj.buckets = loxi.generic_util.unpack_list(reader, common.bucket.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.group_type != other.group_type: return False
        if self.group_id != other.group_id: return False
        if self.buckets != other.buckets: return False
        return True

    def pretty_print(self, q):
        q.text("group_add {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("group_type = ");
                q.text("%#x" % self.group_type)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("buckets = ");
                q.pp(self.buckets)
            q.breakable()
        q.text('}')

group_mod.subtypes[0] = group_add

class group_delete(group_mod):
    version = 2
    type = 15
    command = 2

    def __init__(self, xid=None, group_type=None, group_id=None, buckets=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if group_type != None:
            self.group_type = group_type
        else:
            self.group_type = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if buckets != None:
            self.buckets = buckets
        else:
            self.buckets = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.command))
        packed.append(struct.pack("!B", self.group_type))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.group_id))
        packed.append(loxi.generic_util.pack_list(self.buckets))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_delete()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 15)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _command = reader.read("!H")[0]
        assert(_command == 2)
        obj.group_type = reader.read("!B")[0]
        reader.skip(1)
        obj.group_id = reader.read("!L")[0]
        obj.buckets = loxi.generic_util.unpack_list(reader, common.bucket.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.group_type != other.group_type: return False
        if self.group_id != other.group_id: return False
        if self.buckets != other.buckets: return False
        return True

    def pretty_print(self, q):
        q.text("group_delete {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("group_type = ");
                q.text("%#x" % self.group_type)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("buckets = ");
                q.pp(self.buckets)
            q.breakable()
        q.text('}')

group_mod.subtypes[2] = group_delete

class group_desc_stats_reply(stats_reply):
    version = 2
    type = 19
    stats_type = 7

    def __init__(self, xid=None, flags=None, entries=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(loxi.generic_util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_desc_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 7)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.entries = loxi.generic_util.unpack_list(reader, common.group_desc_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def pretty_print(self, q):
        q.text("group_desc_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

stats_reply.subtypes[7] = group_desc_stats_reply

class group_desc_stats_request(stats_request):
    version = 2
    type = 18
    stats_type = 7

    def __init__(self, xid=None, flags=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_desc_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 7)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def pretty_print(self, q):
        q.text("group_desc_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

stats_request.subtypes[7] = group_desc_stats_request

class group_mod_failed_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 6

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_mod_failed_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 6)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("group_mod_failed_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[6] = group_mod_failed_error_msg

class group_modify(group_mod):
    version = 2
    type = 15
    command = 1

    def __init__(self, xid=None, group_type=None, group_id=None, buckets=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if group_type != None:
            self.group_type = group_type
        else:
            self.group_type = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if buckets != None:
            self.buckets = buckets
        else:
            self.buckets = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.command))
        packed.append(struct.pack("!B", self.group_type))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.group_id))
        packed.append(loxi.generic_util.pack_list(self.buckets))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_modify()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 15)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _command = reader.read("!H")[0]
        assert(_command == 1)
        obj.group_type = reader.read("!B")[0]
        reader.skip(1)
        obj.group_id = reader.read("!L")[0]
        obj.buckets = loxi.generic_util.unpack_list(reader, common.bucket.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.group_type != other.group_type: return False
        if self.group_id != other.group_id: return False
        if self.buckets != other.buckets: return False
        return True

    def pretty_print(self, q):
        q.text("group_modify {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("group_type = ");
                q.text("%#x" % self.group_type)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("buckets = ");
                q.pp(self.buckets)
            q.breakable()
        q.text('}')

group_mod.subtypes[1] = group_modify

class group_stats_reply(stats_reply):
    version = 2
    type = 19
    stats_type = 6

    def __init__(self, xid=None, flags=None, entries=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(loxi.generic_util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 6)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.entries = loxi.generic_util.unpack_list(reader, common.group_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def pretty_print(self, q):
        q.text("group_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

stats_reply.subtypes[6] = group_stats_reply

class group_stats_request(stats_request):
    version = 2
    type = 18
    stats_type = 6

    def __init__(self, xid=None, flags=None, group_id=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.group_id))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = group_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 6)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.group_id = reader.read("!L")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.group_id != other.group_id: return False
        return True

    def pretty_print(self, q):
        q.text("group_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
            q.breakable()
        q.text('}')

stats_request.subtypes[6] = group_stats_request

class hello(message):
    version = 2
    type = 0

    def __init__(self, xid=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = hello()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 0)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        return True

    def pretty_print(self, q):
        q.text("hello {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

message.subtypes[0] = hello

class hello_failed_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 0

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = hello_failed_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 0)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("hello_failed_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[0] = hello_failed_error_msg

class nicira_header(experimenter):
    subtypes = {}

    version = 2
    type = 4
    experimenter = 8992

    def __init__(self, xid=None, subtype=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        subtype, = reader.peek('!L', 12)
        subclass = nicira_header.subtypes.get(subtype)
        if subclass:
            return subclass.unpack(reader)

        obj = nicira_header()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 8992)
        obj.subtype = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.subtype != other.subtype: return False
        return True

    def pretty_print(self, q):
        q.text("nicira_header {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

experimenter.subtypes[8992] = nicira_header

class packet_in(message):
    version = 2
    type = 10

    def __init__(self, xid=None, buffer_id=None, in_port=None, in_phy_port=None, total_len=None, reason=None, table_id=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if in_phy_port != None:
            self.in_phy_port = in_phy_port
        else:
            self.in_phy_port = 0
        if total_len != None:
            self.total_len = total_len
        else:
            self.total_len = 0
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.in_port))
        packed.append(util.pack_port_no(self.in_phy_port))
        packed.append(struct.pack("!H", self.total_len))
        packed.append(struct.pack("!B", self.reason))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = packet_in()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 10)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.in_port = util.unpack_port_no(reader)
        obj.in_phy_port = util.unpack_port_no(reader)
        obj.total_len = reader.read("!H")[0]
        obj.reason = reader.read("!B")[0]
        obj.table_id = reader.read("!B")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.buffer_id != other.buffer_id: return False
        if self.in_port != other.in_port: return False
        if self.in_phy_port != other.in_phy_port: return False
        if self.total_len != other.total_len: return False
        if self.reason != other.reason: return False
        if self.table_id != other.table_id: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("packet_in {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("in_phy_port = ");
                q.text(util.pretty_port(self.in_phy_port))
                q.text(","); q.breakable()
                q.text("total_len = ");
                q.text("%#x" % self.total_len)
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

message.subtypes[10] = packet_in

class packet_out(message):
    version = 2
    type = 13

    def __init__(self, xid=None, buffer_id=None, in_port=None, actions=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.in_port))
        packed.append(struct.pack("!H", 0)) # placeholder for actions_len at index 6
        packed.append('\x00' * 6)
        packed.append(loxi.generic_util.pack_list(self.actions))
        packed[6] = struct.pack("!H", len(packed[-1]))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = packet_out()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 13)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.in_port = util.unpack_port_no(reader)
        _actions_len = reader.read("!H")[0]
        reader.skip(6)
        obj.actions = loxi.generic_util.unpack_list(reader.slice(_actions_len), action.action.unpack)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.buffer_id != other.buffer_id: return False
        if self.in_port != other.in_port: return False
        if self.actions != other.actions: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("packet_out {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

message.subtypes[13] = packet_out

class port_mod(message):
    version = 2
    type = 16

    def __init__(self, xid=None, port_no=None, hw_addr=None, config=None, mask=None, advertise=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if config != None:
            self.config = config
        else:
            self.config = 0
        if mask != None:
            self.mask = mask
        else:
            self.mask = 0
        if advertise != None:
            self.advertise = advertise
        else:
            self.advertise = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.mask))
        packed.append(struct.pack("!L", self.advertise))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_mod()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 16)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(4)
        obj.hw_addr = list(reader.read('!6B'))
        reader.skip(2)
        obj.config = reader.read("!L")[0]
        obj.mask = reader.read("!L")[0]
        obj.advertise = reader.read("!L")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.port_no != other.port_no: return False
        if self.hw_addr != other.hw_addr: return False
        if self.config != other.config: return False
        if self.mask != other.mask: return False
        if self.advertise != other.advertise: return False
        return True

    def pretty_print(self, q):
        q.text("port_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("mask = ");
                q.text("%#x" % self.mask)
                q.text(","); q.breakable()
                q.text("advertise = ");
                q.text("%#x" % self.advertise)
            q.breakable()
        q.text('}')

message.subtypes[16] = port_mod

class port_mod_failed_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 7

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_mod_failed_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 7)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("port_mod_failed_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[7] = port_mod_failed_error_msg

class port_stats_reply(stats_reply):
    version = 2
    type = 19
    stats_type = 4

    def __init__(self, xid=None, flags=None, entries=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(loxi.generic_util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 4)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.entries = loxi.generic_util.unpack_list(reader, common.port_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def pretty_print(self, q):
        q.text("port_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

stats_reply.subtypes[4] = port_stats_reply

class port_stats_request(stats_request):
    version = 2
    type = 18
    stats_type = 4

    def __init__(self, xid=None, flags=None, port_no=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 4)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        return True

    def pretty_print(self, q):
        q.text("port_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
            q.breakable()
        q.text('}')

stats_request.subtypes[4] = port_stats_request

class port_status(message):
    version = 2
    type = 12

    def __init__(self, xid=None, reason=None, desc=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if desc != None:
            self.desc = desc
        else:
            self.desc = common.port_desc()
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!B", self.reason))
        packed.append('\x00' * 7)
        packed.append(self.desc.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = port_status()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 12)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.reason = reader.read("!B")[0]
        reader.skip(7)
        obj.desc = common.port_desc.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.reason != other.reason: return False
        if self.desc != other.desc: return False
        return True

    def pretty_print(self, q):
        q.text("port_status {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("desc = ");
                q.pp(self.desc)
            q.breakable()
        q.text('}')

message.subtypes[12] = port_status

class queue_get_config_reply(message):
    version = 2
    type = 23

    def __init__(self, xid=None, port=None, queues=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if port != None:
            self.port = port
        else:
            self.port = 0
        if queues != None:
            self.queues = queues
        else:
            self.queues = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(util.pack_port_no(self.port))
        packed.append('\x00' * 4)
        packed.append(loxi.generic_util.pack_list(self.queues))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_get_config_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 23)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.port = util.unpack_port_no(reader)
        reader.skip(4)
        obj.queues = loxi.generic_util.unpack_list(reader, common.packet_queue.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.port != other.port: return False
        if self.queues != other.queues: return False
        return True

    def pretty_print(self, q):
        q.text("queue_get_config_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
                q.text(","); q.breakable()
                q.text("queues = ");
                q.pp(self.queues)
            q.breakable()
        q.text('}')

message.subtypes[23] = queue_get_config_reply

class queue_get_config_request(message):
    version = 2
    type = 22

    def __init__(self, xid=None, port=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if port != None:
            self.port = port
        else:
            self.port = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(util.pack_port_no(self.port))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_get_config_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 22)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.port = util.unpack_port_no(reader)
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.port != other.port: return False
        return True

    def pretty_print(self, q):
        q.text("queue_get_config_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
            q.breakable()
        q.text('}')

message.subtypes[22] = queue_get_config_request

class queue_op_failed_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 9

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_op_failed_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 9)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("queue_op_failed_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[9] = queue_op_failed_error_msg

class queue_stats_reply(stats_reply):
    version = 2
    type = 19
    stats_type = 5

    def __init__(self, xid=None, flags=None, entries=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(loxi.generic_util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 5)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.entries = loxi.generic_util.unpack_list(reader, common.queue_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def pretty_print(self, q):
        q.text("queue_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

stats_reply.subtypes[5] = queue_stats_reply

class queue_stats_request(stats_request):
    version = 2
    type = 18
    stats_type = 5

    def __init__(self, xid=None, flags=None, port_no=None, queue_id=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!L", self.queue_id))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = queue_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 5)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.port_no = util.unpack_port_no(reader)
        obj.queue_id = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        if self.queue_id != other.queue_id: return False
        return True

    def pretty_print(self, q):
        q.text("queue_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
            q.breakable()
        q.text('}')

stats_request.subtypes[5] = queue_stats_request

class set_config(message):
    version = 2
    type = 9

    def __init__(self, xid=None, flags=None, miss_send_len=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if miss_send_len != None:
            self.miss_send_len = miss_send_len
        else:
            self.miss_send_len = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.miss_send_len))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = set_config()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 9)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        obj.miss_send_len = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.miss_send_len != other.miss_send_len: return False
        return True

    def pretty_print(self, q):
        q.text("set_config {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("miss_send_len = ");
                q.text("%#x" % self.miss_send_len)
            q.breakable()
        q.text('}')

message.subtypes[9] = set_config

class switch_config_failed_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 10

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = switch_config_failed_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 10)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("switch_config_failed_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[10] = switch_config_failed_error_msg

class table_mod(message):
    version = 2
    type = 17

    def __init__(self, xid=None, table_id=None, config=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if config != None:
            self.config = config
        else:
            self.config = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.config))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_mod()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 17)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        obj.table_id = reader.read("!B")[0]
        reader.skip(3)
        obj.config = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.table_id != other.table_id: return False
        if self.config != other.config: return False
        return True

    def pretty_print(self, q):
        q.text("table_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
            q.breakable()
        q.text('}')

message.subtypes[17] = table_mod

class table_mod_failed_error_msg(error_msg):
    version = 2
    type = 1
    err_type = 8

    def __init__(self, xid=None, code=None, data=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_mod_failed_error_msg()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _err_type = reader.read("!H")[0]
        assert(_err_type == 8)
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def pretty_print(self, q):
        q.text("table_mod_failed_error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

error_msg.subtypes[8] = table_mod_failed_error_msg

class table_stats_reply(stats_reply):
    version = 2
    type = 19
    stats_type = 3

    def __init__(self, xid=None, flags=None, entries=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(loxi.generic_util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_stats_reply()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 3)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        obj.entries = loxi.generic_util.unpack_list(reader, common.table_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def pretty_print(self, q):
        q.text("table_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

stats_reply.subtypes[3] = table_stats_reply

class table_stats_request(stats_request):
    version = 2
    type = 18
    stats_type = 3

    def __init__(self, xid=None, flags=None):
        if xid != None:
            self.xid = xid
        else:
            self.xid = None
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(reader):
        obj = table_stats_request()
        _version = reader.read("!B")[0]
        assert(_version == 2)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        orig_reader = reader
        reader = orig_reader.slice(_length - (2 + 2))
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 3)
        obj.flags = reader.read("!H")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def pretty_print(self, q):
        q.text("table_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

stats_request.subtypes[3] = table_stats_request


def parse_header(buf):
    if len(buf) < 8:
        raise loxi.ProtocolError("too short to be an OpenFlow message")
    return struct.unpack_from("!BBHL", buf)

def parse_message(buf):
    msg_ver, msg_type, msg_len, msg_xid = parse_header(buf)
    if msg_ver != const.OFP_VERSION and msg_type != const.OFPT_HELLO:
        raise loxi.ProtocolError("wrong OpenFlow version (expected %d, got %d)" % (const.OFP_VERSION, msg_ver))
    if len(buf) != msg_len:
        raise loxi.ProtocolError("incorrect message size")
    return message.unpack(loxi.generic_util.OFReader(buf))
