# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.

# Automatically generated by LOXI from template common.py
# Do not modify

import sys
import struct
import action
import instruction # for unpack_list
import const
import util
import loxi.generic_util


# HACK make this module visible as 'common' to simplify code generation
common = sys.modules[__name__]

def unpack_list_flow_stats_entry(reader):
    return loxi.generic_util.unpack_list_lv16(reader, flow_stats_entry.unpack)

def unpack_list_queue_prop(reader):
    def deserializer(reader, typ):
        if typ == const.OFPQT_MIN_RATE:
            return queue_prop_min_rate.unpack(reader)
        else:
            raise loxi.ProtocolError("unknown queue prop %d" % typ)
    return loxi.generic_util.unpack_list_tlv16(reader, deserializer)

def unpack_list_packet_queue(reader):
    def wrapper(reader):
        length, = reader.peek('!4xH')
        return packet_queue.unpack(reader.slice(length))
    return loxi.generic_util.unpack_list(reader, wrapper)

def unpack_list_hello_elem(reader):
    def deserializer(reader, typ):
        if typ == const.OFPHET_VERSIONBITMAP:
            return hello_elem_versionbitmap.unpack(reader)
        else:
            return None
    return [x for x in loxi.generic_util.unpack_list_tlv16(reader, deserializer) if x != None]

def unpack_list_bucket(reader):
    return loxi.generic_util.unpack_list_lv16(reader, bucket.unpack)

def unpack_list_group_desc_stats_entry(reader):
    return loxi.generic_util.unpack_list_lv16(reader, group_desc_stats_entry.unpack)

def unpack_list_group_stats_entry(reader):
    return loxi.generic_util.unpack_list_lv16(reader, group_stats_entry.unpack)

def unpack_list_meter_stats(reader):
    def wrapper(reader):
        length, = reader.peek('!4xH')
        return meter_stats.unpack(reader.slice(length))
    return loxi.generic_util.unpack_list(reader, wrapper)

class bsn_interface(object):

    def __init__(self, hw_addr=None, name=None, ipv4_addr=None, ipv4_netmask=None):
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if ipv4_addr != None:
            self.ipv4_addr = ipv4_addr
        else:
            self.ipv4_addr = 0
        if ipv4_netmask != None:
            self.ipv4_netmask = ipv4_netmask
        else:
            self.ipv4_netmask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.ipv4_addr))
        packed.append(struct.pack("!L", self.ipv4_netmask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = bsn_interface()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.hw_addr = list(reader.read('!6B'))
        reader.skip(2)
        obj.name = reader.read("!16s")[0].rstrip("\x00")
        obj.ipv4_addr = reader.read('!L')[0]
        obj.ipv4_netmask = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.hw_addr != other.hw_addr: return False
        if self.name != other.name: return False
        if self.ipv4_addr != other.ipv4_addr: return False
        if self.ipv4_netmask != other.ipv4_netmask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_interface {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("ipv4_addr = ");
                q.text(util.pretty_ipv4(self.ipv4_addr))
                q.text(","); q.breakable()
                q.text("ipv4_netmask = ");
                q.text(util.pretty_ipv4(self.ipv4_netmask))
            q.breakable()
        q.text('}')

class bucket(object):

    def __init__(self, weight=None, watch_port=None, watch_group=None, actions=None):
        if weight != None:
            self.weight = weight
        else:
            self.weight = 0
        if watch_port != None:
            self.watch_port = watch_port
        else:
            self.watch_port = 0
        if watch_group != None:
            self.watch_group = watch_group
        else:
            self.watch_group = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 0
        packed.append(struct.pack("!H", self.weight))
        packed.append(struct.pack("!L", self.watch_port))
        packed.append(struct.pack("!L", self.watch_group))
        packed.append('\x00' * 4)
        packed.append("".join([x.pack() for x in self.actions]))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = bucket()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _len = reader.read('!H')[0]
        obj.weight = reader.read('!H')[0]
        obj.watch_port = reader.read('!L')[0]
        obj.watch_group = reader.read('!L')[0]
        reader.skip(4)
        obj.actions = action.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.weight != other.weight: return False
        if self.watch_port != other.watch_port: return False
        if self.watch_group != other.watch_group: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bucket {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("weight = ");
                q.text("%#x" % self.weight)
                q.text(","); q.breakable()
                q.text("watch_port = ");
                q.text(util.pretty_port(self.watch_port))
                q.text(","); q.breakable()
                q.text("watch_group = ");
                q.text("%#x" % self.watch_group)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class bucket_counter(object):

    def __init__(self, packet_count=None, byte_count=None):
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = bucket_counter()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.packet_count = reader.read('!Q')[0]
        obj.byte_count = reader.read('!Q')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bucket_counter {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
            q.breakable()
        q.text('}')

class flow_stats_entry(object):

    def __init__(self, table_id=None, duration_sec=None, duration_nsec=None, priority=None, idle_timeout=None, hard_timeout=None, cookie=None, packet_count=None, byte_count=None, match=None, instructions=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append('\x00' * 6)
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(self.match.pack())
        packed.append("".join([x.pack() for x in self.instructions]))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = flow_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _length = reader.read('!H')[0]
        obj.table_id = reader.read('!B')[0]
        reader.skip(1)
        obj.duration_sec = reader.read('!L')[0]
        obj.duration_nsec = reader.read('!L')[0]
        obj.priority = reader.read('!H')[0]
        obj.idle_timeout = reader.read('!H')[0]
        obj.hard_timeout = reader.read('!H')[0]
        reader.skip(6)
        obj.cookie = reader.read('!Q')[0]
        obj.packet_count = reader.read('!Q')[0]
        obj.byte_count = reader.read('!Q')[0]
        obj.match = common.match.unpack(reader)
        obj.instructions = instruction.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.priority != other.priority: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.cookie != other.cookie: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

class group_desc_stats_entry(object):

    def __init__(self, type=None, group_id=None, buckets=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if buckets != None:
            self.buckets = buckets
        else:
            self.buckets = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!B", self.type))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.group_id))
        packed.append("".join([x.pack() for x in self.buckets]))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = group_desc_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _length = reader.read('!H')[0]
        obj.type = reader.read('!B')[0]
        reader.skip(1)
        obj.group_id = reader.read('!L')[0]
        obj.buckets = common.unpack_list_bucket(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        if self.group_id != other.group_id: return False
        if self.buckets != other.buckets: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_desc_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("type = ");
                q.text("%#x" % self.type)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("buckets = ");
                q.pp(self.buckets)
            q.breakable()
        q.text('}')

class group_stats_entry(object):

    def __init__(self, group_id=None, ref_count=None, packet_count=None, byte_count=None, bucket_stats=None):
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if ref_count != None:
            self.ref_count = ref_count
        else:
            self.ref_count = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if bucket_stats != None:
            self.bucket_stats = bucket_stats
        else:
            self.bucket_stats = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.group_id))
        packed.append(struct.pack("!L", self.ref_count))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append("".join([x.pack() for x in self.bucket_stats]))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = group_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _length = reader.read('!H')[0]
        reader.skip(2)
        obj.group_id = reader.read('!L')[0]
        obj.ref_count = reader.read('!L')[0]
        reader.skip(4)
        obj.packet_count = reader.read('!Q')[0]
        obj.byte_count = reader.read('!Q')[0]
        obj.bucket_stats = loxi.generic_util.unpack_list(reader, common.bucket_counter.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.group_id != other.group_id: return False
        if self.ref_count != other.ref_count: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.bucket_stats != other.bucket_stats: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("ref_count = ");
                q.text("%#x" % self.ref_count)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("bucket_stats = ");
                q.pp(self.bucket_stats)
            q.breakable()
        q.text('}')

class match_v2(object):
    type = 0

    def __init__(self, in_port=None, wildcards=None, eth_src=None, eth_src_mask=None, eth_dst=None, eth_dst_mask=None, vlan_vid=None, vlan_pcp=None, eth_type=None, ip_dscp=None, ip_proto=None, ipv4_src=None, ipv4_src_mask=None, ipv4_dst=None, ipv4_dst_mask=None, tcp_src=None, tcp_dst=None, mpls_label=None, mpls_tc=None, metadata=None, metadata_mask=None):
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if wildcards != None:
            self.wildcards = wildcards
        else:
            self.wildcards = const.OFPFW_ALL
        if eth_src != None:
            self.eth_src = eth_src
        else:
            self.eth_src = [0,0,0,0,0,0]
        if eth_src_mask != None:
            self.eth_src_mask = eth_src_mask
        else:
            self.eth_src_mask = [0,0,0,0,0,0]
        if eth_dst != None:
            self.eth_dst = eth_dst
        else:
            self.eth_dst = [0,0,0,0,0,0]
        if eth_dst_mask != None:
            self.eth_dst_mask = eth_dst_mask
        else:
            self.eth_dst_mask = [0,0,0,0,0,0]
        if vlan_vid != None:
            self.vlan_vid = vlan_vid
        else:
            self.vlan_vid = 0
        if vlan_pcp != None:
            self.vlan_pcp = vlan_pcp
        else:
            self.vlan_pcp = 0
        if eth_type != None:
            self.eth_type = eth_type
        else:
            self.eth_type = 0
        if ip_dscp != None:
            self.ip_dscp = ip_dscp
        else:
            self.ip_dscp = 0
        if ip_proto != None:
            self.ip_proto = ip_proto
        else:
            self.ip_proto = 0
        if ipv4_src != None:
            self.ipv4_src = ipv4_src
        else:
            self.ipv4_src = 0
        if ipv4_src_mask != None:
            self.ipv4_src_mask = ipv4_src_mask
        else:
            self.ipv4_src_mask = 0
        if ipv4_dst != None:
            self.ipv4_dst = ipv4_dst
        else:
            self.ipv4_dst = 0
        if ipv4_dst_mask != None:
            self.ipv4_dst_mask = ipv4_dst_mask
        else:
            self.ipv4_dst_mask = 0
        if tcp_src != None:
            self.tcp_src = tcp_src
        else:
            self.tcp_src = 0
        if tcp_dst != None:
            self.tcp_dst = tcp_dst
        else:
            self.tcp_dst = 0
        if mpls_label != None:
            self.mpls_label = mpls_label
        else:
            self.mpls_label = 0
        if mpls_tc != None:
            self.mpls_tc = mpls_tc
        else:
            self.mpls_tc = 0
        if metadata != None:
            self.metadata = metadata
        else:
            self.metadata = 0
        if metadata_mask != None:
            self.metadata_mask = metadata_mask
        else:
            self.metadata_mask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.in_port))
        packed.append(struct.pack("!L", self.wildcards))
        packed.append(struct.pack("!6B", *self.eth_src))
        packed.append(struct.pack("!6B", *self.eth_src_mask))
        packed.append(struct.pack("!6B", *self.eth_dst))
        packed.append(struct.pack("!6B", *self.eth_dst_mask))
        packed.append(struct.pack("!H", self.vlan_vid))
        packed.append(struct.pack("!B", self.vlan_pcp))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!H", self.eth_type))
        packed.append(struct.pack("!B", self.ip_dscp))
        packed.append(struct.pack("!B", self.ip_proto))
        packed.append(struct.pack("!L", self.ipv4_src))
        packed.append(struct.pack("!L", self.ipv4_src_mask))
        packed.append(struct.pack("!L", self.ipv4_dst))
        packed.append(struct.pack("!L", self.ipv4_dst_mask))
        packed.append(struct.pack("!H", self.tcp_src))
        packed.append(struct.pack("!H", self.tcp_dst))
        packed.append(struct.pack("!L", self.mpls_label))
        packed.append(struct.pack("!B", self.mpls_tc))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!Q", self.metadata))
        packed.append(struct.pack("!Q", self.metadata_mask))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = match_v2()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type = reader.read('!H')[0]
        assert(_type == 0)
        _length = reader.read('!H')[0]
        obj.in_port = reader.read('!L')[0]
        obj.wildcards = reader.read('!L')[0]
        obj.eth_src = list(reader.read('!6B'))
        obj.eth_src_mask = list(reader.read('!6B'))
        obj.eth_dst = list(reader.read('!6B'))
        obj.eth_dst_mask = list(reader.read('!6B'))
        obj.vlan_vid = reader.read('!H')[0]
        obj.vlan_pcp = reader.read('!B')[0]
        reader.skip(1)
        obj.eth_type = reader.read('!H')[0]
        obj.ip_dscp = reader.read('!B')[0]
        obj.ip_proto = reader.read('!B')[0]
        obj.ipv4_src = reader.read('!L')[0]
        obj.ipv4_src_mask = reader.read('!L')[0]
        obj.ipv4_dst = reader.read('!L')[0]
        obj.ipv4_dst_mask = reader.read('!L')[0]
        obj.tcp_src = reader.read('!H')[0]
        obj.tcp_dst = reader.read('!H')[0]
        obj.mpls_label = reader.read('!L')[0]
        obj.mpls_tc = reader.read('!B')[0]
        reader.skip(3)
        obj.metadata = reader.read('!Q')[0]
        obj.metadata_mask = reader.read('!Q')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.in_port != other.in_port: return False
        if self.wildcards != other.wildcards: return False
        if self.eth_src != other.eth_src: return False
        if self.eth_src_mask != other.eth_src_mask: return False
        if self.eth_dst != other.eth_dst: return False
        if self.eth_dst_mask != other.eth_dst_mask: return False
        if self.vlan_vid != other.vlan_vid: return False
        if self.vlan_pcp != other.vlan_pcp: return False
        if self.eth_type != other.eth_type: return False
        if self.ip_dscp != other.ip_dscp: return False
        if self.ip_proto != other.ip_proto: return False
        if self.ipv4_src != other.ipv4_src: return False
        if self.ipv4_src_mask != other.ipv4_src_mask: return False
        if self.ipv4_dst != other.ipv4_dst: return False
        if self.ipv4_dst_mask != other.ipv4_dst_mask: return False
        if self.tcp_src != other.tcp_src: return False
        if self.tcp_dst != other.tcp_dst: return False
        if self.mpls_label != other.mpls_label: return False
        if self.mpls_tc != other.mpls_tc: return False
        if self.metadata != other.metadata: return False
        if self.metadata_mask != other.metadata_mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("match_v2 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("wildcards = ");
                q.text(util.pretty_wildcards(self.wildcards))
                q.text(","); q.breakable()
                q.text("eth_src = ");
                q.text(util.pretty_mac(self.eth_src))
                q.text(","); q.breakable()
                q.text("eth_src_mask = ");
                q.text(util.pretty_mac(self.eth_src_mask))
                q.text(","); q.breakable()
                q.text("eth_dst = ");
                q.text(util.pretty_mac(self.eth_dst))
                q.text(","); q.breakable()
                q.text("eth_dst_mask = ");
                q.text(util.pretty_mac(self.eth_dst_mask))
                q.text(","); q.breakable()
                q.text("vlan_vid = ");
                q.text("%#x" % self.vlan_vid)
                q.text(","); q.breakable()
                q.text("vlan_pcp = ");
                q.text("%#x" % self.vlan_pcp)
                q.text(","); q.breakable()
                q.text("eth_type = ");
                q.text("%#x" % self.eth_type)
                q.text(","); q.breakable()
                q.text("ip_dscp = ");
                q.text("%#x" % self.ip_dscp)
                q.text(","); q.breakable()
                q.text("ip_proto = ");
                q.text("%#x" % self.ip_proto)
                q.text(","); q.breakable()
                q.text("ipv4_src = ");
                q.text(util.pretty_ipv4(self.ipv4_src))
                q.text(","); q.breakable()
                q.text("ipv4_src_mask = ");
                q.text(util.pretty_ipv4(self.ipv4_src_mask))
                q.text(","); q.breakable()
                q.text("ipv4_dst = ");
                q.text(util.pretty_ipv4(self.ipv4_dst))
                q.text(","); q.breakable()
                q.text("ipv4_dst_mask = ");
                q.text(util.pretty_ipv4(self.ipv4_dst_mask))
                q.text(","); q.breakable()
                q.text("tcp_src = ");
                q.text("%#x" % self.tcp_src)
                q.text(","); q.breakable()
                q.text("tcp_dst = ");
                q.text("%#x" % self.tcp_dst)
                q.text(","); q.breakable()
                q.text("mpls_label = ");
                q.text("%#x" % self.mpls_label)
                q.text(","); q.breakable()
                q.text("mpls_tc = ");
                q.text("%#x" % self.mpls_tc)
                q.text(","); q.breakable()
                q.text("metadata = ");
                q.text("%#x" % self.metadata)
                q.text(","); q.breakable()
                q.text("metadata_mask = ");
                q.text("%#x" % self.metadata_mask)
            q.breakable()
        q.text('}')

class packet_queue(object):

    def __init__(self, queue_id=None, properties=None):
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if properties != None:
            self.properties = properties
        else:
            self.properties = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 2)
        packed.append("".join([x.pack() for x in self.properties]))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = packet_queue()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.queue_id = reader.read('!L')[0]
        _len = reader.read('!H')[0]
        reader.skip(2)
        obj.properties = common.unpack_list_queue_prop(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.queue_id != other.queue_id: return False
        if self.properties != other.properties: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("packet_queue {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("properties = ");
                q.pp(self.properties)
            q.breakable()
        q.text('}')

class port_desc(object):

    def __init__(self, port_no=None, hw_addr=None, name=None, config=None, state=None, curr=None, advertised=None, supported=None, peer=None, curr_speed=None, max_speed=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if config != None:
            self.config = config
        else:
            self.config = 0
        if state != None:
            self.state = state
        else:
            self.state = 0
        if curr != None:
            self.curr = curr
        else:
            self.curr = 0
        if advertised != None:
            self.advertised = advertised
        else:
            self.advertised = 0
        if supported != None:
            self.supported = supported
        else:
            self.supported = 0
        if peer != None:
            self.peer = peer
        else:
            self.peer = 0
        if curr_speed != None:
            self.curr_speed = curr_speed
        else:
            self.curr_speed = 0
        if max_speed != None:
            self.max_speed = max_speed
        else:
            self.max_speed = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.port_no))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.state))
        packed.append(struct.pack("!L", self.curr))
        packed.append(struct.pack("!L", self.advertised))
        packed.append(struct.pack("!L", self.supported))
        packed.append(struct.pack("!L", self.peer))
        packed.append(struct.pack("!L", self.curr_speed))
        packed.append(struct.pack("!L", self.max_speed))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = port_desc()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.port_no = reader.read('!L')[0]
        reader.skip(4)
        obj.hw_addr = list(reader.read('!6B'))
        reader.skip(2)
        obj.name = reader.read("!16s")[0].rstrip("\x00")
        obj.config = reader.read('!L')[0]
        obj.state = reader.read('!L')[0]
        obj.curr = reader.read('!L')[0]
        obj.advertised = reader.read('!L')[0]
        obj.supported = reader.read('!L')[0]
        obj.peer = reader.read('!L')[0]
        obj.curr_speed = reader.read('!L')[0]
        obj.max_speed = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.hw_addr != other.hw_addr: return False
        if self.name != other.name: return False
        if self.config != other.config: return False
        if self.state != other.state: return False
        if self.curr != other.curr: return False
        if self.advertised != other.advertised: return False
        if self.supported != other.supported: return False
        if self.peer != other.peer: return False
        if self.curr_speed != other.curr_speed: return False
        if self.max_speed != other.max_speed: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_desc {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("state = ");
                q.text("%#x" % self.state)
                q.text(","); q.breakable()
                q.text("curr = ");
                q.text("%#x" % self.curr)
                q.text(","); q.breakable()
                q.text("advertised = ");
                q.text("%#x" % self.advertised)
                q.text(","); q.breakable()
                q.text("supported = ");
                q.text("%#x" % self.supported)
                q.text(","); q.breakable()
                q.text("peer = ");
                q.text("%#x" % self.peer)
                q.text(","); q.breakable()
                q.text("curr_speed = ");
                q.text("%#x" % self.curr_speed)
                q.text(","); q.breakable()
                q.text("max_speed = ");
                q.text("%#x" % self.max_speed)
            q.breakable()
        q.text('}')

class port_stats_entry(object):

    def __init__(self, port_no=None, rx_packets=None, tx_packets=None, rx_bytes=None, tx_bytes=None, rx_dropped=None, tx_dropped=None, rx_errors=None, tx_errors=None, rx_frame_err=None, rx_over_err=None, rx_crc_err=None, collisions=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if rx_packets != None:
            self.rx_packets = rx_packets
        else:
            self.rx_packets = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if rx_bytes != None:
            self.rx_bytes = rx_bytes
        else:
            self.rx_bytes = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if rx_dropped != None:
            self.rx_dropped = rx_dropped
        else:
            self.rx_dropped = 0
        if tx_dropped != None:
            self.tx_dropped = tx_dropped
        else:
            self.tx_dropped = 0
        if rx_errors != None:
            self.rx_errors = rx_errors
        else:
            self.rx_errors = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0
        if rx_frame_err != None:
            self.rx_frame_err = rx_frame_err
        else:
            self.rx_frame_err = 0
        if rx_over_err != None:
            self.rx_over_err = rx_over_err
        else:
            self.rx_over_err = 0
        if rx_crc_err != None:
            self.rx_crc_err = rx_crc_err
        else:
            self.rx_crc_err = 0
        if collisions != None:
            self.collisions = collisions
        else:
            self.collisions = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.port_no))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.rx_packets))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.rx_bytes))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.rx_dropped))
        packed.append(struct.pack("!Q", self.tx_dropped))
        packed.append(struct.pack("!Q", self.rx_errors))
        packed.append(struct.pack("!Q", self.tx_errors))
        packed.append(struct.pack("!Q", self.rx_frame_err))
        packed.append(struct.pack("!Q", self.rx_over_err))
        packed.append(struct.pack("!Q", self.rx_crc_err))
        packed.append(struct.pack("!Q", self.collisions))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = port_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.port_no = reader.read('!L')[0]
        reader.skip(4)
        obj.rx_packets = reader.read('!Q')[0]
        obj.tx_packets = reader.read('!Q')[0]
        obj.rx_bytes = reader.read('!Q')[0]
        obj.tx_bytes = reader.read('!Q')[0]
        obj.rx_dropped = reader.read('!Q')[0]
        obj.tx_dropped = reader.read('!Q')[0]
        obj.rx_errors = reader.read('!Q')[0]
        obj.tx_errors = reader.read('!Q')[0]
        obj.rx_frame_err = reader.read('!Q')[0]
        obj.rx_over_err = reader.read('!Q')[0]
        obj.rx_crc_err = reader.read('!Q')[0]
        obj.collisions = reader.read('!Q')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.rx_packets != other.rx_packets: return False
        if self.tx_packets != other.tx_packets: return False
        if self.rx_bytes != other.rx_bytes: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.rx_dropped != other.rx_dropped: return False
        if self.tx_dropped != other.tx_dropped: return False
        if self.rx_errors != other.rx_errors: return False
        if self.tx_errors != other.tx_errors: return False
        if self.rx_frame_err != other.rx_frame_err: return False
        if self.rx_over_err != other.rx_over_err: return False
        if self.rx_crc_err != other.rx_crc_err: return False
        if self.collisions != other.collisions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("rx_packets = ");
                q.text("%#x" % self.rx_packets)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("rx_bytes = ");
                q.text("%#x" % self.rx_bytes)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("rx_dropped = ");
                q.text("%#x" % self.rx_dropped)
                q.text(","); q.breakable()
                q.text("tx_dropped = ");
                q.text("%#x" % self.tx_dropped)
                q.text(","); q.breakable()
                q.text("rx_errors = ");
                q.text("%#x" % self.rx_errors)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
                q.text(","); q.breakable()
                q.text("rx_frame_err = ");
                q.text("%#x" % self.rx_frame_err)
                q.text(","); q.breakable()
                q.text("rx_over_err = ");
                q.text("%#x" % self.rx_over_err)
                q.text(","); q.breakable()
                q.text("rx_crc_err = ");
                q.text("%#x" % self.rx_crc_err)
                q.text(","); q.breakable()
                q.text("collisions = ");
                q.text("%#x" % self.collisions)
            q.breakable()
        q.text('}')

class queue_prop_min_rate(object):
    type = const.OFPQT_MIN_RATE

    def __init__(self, rate=None):
        if rate != None:
            self.rate = rate
        else:
            self.rate = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        packed.append(struct.pack("!H", self.rate))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = queue_prop_min_rate()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type = reader.read('!H')[0]
        assert(_type == const.OFPQT_MIN_RATE)
        _len = reader.read('!H')[0]
        reader.skip(4)
        obj.rate = reader.read('!H')[0]
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.rate != other.rate: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_prop_min_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("rate = ");
                q.text("%#x" % self.rate)
            q.breakable()
        q.text('}')

class queue_stats_entry(object):

    def __init__(self, port_no=None, queue_id=None, tx_bytes=None, tx_packets=None, tx_errors=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.port_no))
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.tx_errors))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = queue_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.port_no = reader.read('!L')[0]
        obj.queue_id = reader.read('!L')[0]
        obj.tx_bytes = reader.read('!Q')[0]
        obj.tx_packets = reader.read('!Q')[0]
        obj.tx_errors = reader.read('!Q')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.queue_id != other.queue_id: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.tx_packets != other.tx_packets: return False
        if self.tx_errors != other.tx_errors: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
            q.breakable()
        q.text('}')

class table_stats_entry(object):

    def __init__(self, table_id=None, name=None, wildcards=None, match=None, instructions=None, write_actions=None, apply_actions=None, config=None, max_entries=None, active_count=None, lookup_count=None, matched_count=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if name != None:
            self.name = name
        else:
            self.name = ""
        if wildcards != None:
            self.wildcards = wildcards
        else:
            self.wildcards = const.OFPFW_ALL
        if match != None:
            self.match = match
        else:
            self.match = const.OFPFW_ALL
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = 0
        if write_actions != None:
            self.write_actions = write_actions
        else:
            self.write_actions = 0
        if apply_actions != None:
            self.apply_actions = apply_actions
        else:
            self.apply_actions = 0
        if config != None:
            self.config = config
        else:
            self.config = 0
        if max_entries != None:
            self.max_entries = max_entries
        else:
            self.max_entries = 0
        if active_count != None:
            self.active_count = active_count
        else:
            self.active_count = 0
        if lookup_count != None:
            self.lookup_count = lookup_count
        else:
            self.lookup_count = 0
        if matched_count != None:
            self.matched_count = matched_count
        else:
            self.matched_count = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 7)
        packed.append(struct.pack("!32s", self.name))
        packed.append(struct.pack("!L", self.wildcards))
        packed.append(struct.pack("!L", self.match))
        packed.append(struct.pack("!L", self.instructions))
        packed.append(struct.pack("!L", self.write_actions))
        packed.append(struct.pack("!L", self.apply_actions))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.max_entries))
        packed.append(struct.pack("!L", self.active_count))
        packed.append(struct.pack("!Q", self.lookup_count))
        packed.append(struct.pack("!Q", self.matched_count))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = table_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.table_id = reader.read('!B')[0]
        reader.skip(7)
        obj.name = reader.read("!32s")[0].rstrip("\x00")
        obj.wildcards = reader.read('!L')[0]
        obj.match = reader.read('!L')[0]
        obj.instructions = reader.read('!L')[0]
        obj.write_actions = reader.read('!L')[0]
        obj.apply_actions = reader.read('!L')[0]
        obj.config = reader.read('!L')[0]
        obj.max_entries = reader.read('!L')[0]
        obj.active_count = reader.read('!L')[0]
        obj.lookup_count = reader.read('!Q')[0]
        obj.matched_count = reader.read('!Q')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.name != other.name: return False
        if self.wildcards != other.wildcards: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        if self.write_actions != other.write_actions: return False
        if self.apply_actions != other.apply_actions: return False
        if self.config != other.config: return False
        if self.max_entries != other.max_entries: return False
        if self.active_count != other.active_count: return False
        if self.lookup_count != other.lookup_count: return False
        if self.matched_count != other.matched_count: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("wildcards = ");
                q.text(util.pretty_wildcards(self.wildcards))
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.text("%#x" % self.instructions)
                q.text(","); q.breakable()
                q.text("write_actions = ");
                q.text("%#x" % self.write_actions)
                q.text(","); q.breakable()
                q.text("apply_actions = ");
                q.text("%#x" % self.apply_actions)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("max_entries = ");
                q.text("%#x" % self.max_entries)
                q.text(","); q.breakable()
                q.text("active_count = ");
                q.text("%#x" % self.active_count)
                q.text(","); q.breakable()
                q.text("lookup_count = ");
                q.text("%#x" % self.lookup_count)
                q.text(","); q.breakable()
                q.text("matched_count = ");
                q.text("%#x" % self.matched_count)
            q.breakable()
        q.text('}')


match = match_v2
