# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.
# See the file LICENSE.pyloxi which should have been included in the source distribution

# Automatically generated by LOXI from template message.py
# Do not modify

import struct
import loxi
import const
import common
import action # for unpack_list
import util
import loxi.generic_util

class Message(object):
    version = const.OFP_VERSION
    type = None # override in subclass
    xid = None

class aggregate_stats_reply(Message):
    version = 1
    type = 17
    stats_type = 2

    def __init__(self, xid=None, flags=None, packet_count=None, byte_count=None, flow_count=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if flow_count != None:
            self.flow_count = flow_count
        else:
            self.flow_count = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(struct.pack("!L", self.flow_count))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = aggregate_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 17)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 2)
        obj.flags = reader.read("!H")[0]
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        obj.flow_count = reader.read("!L")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.flow_count != other.flow_count: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("aggregate_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("flow_count = ");
                q.text("%#x" % self.flow_count)
            q.breakable()
        q.text('}')

class aggregate_stats_request(Message):
    version = 1
    type = 16
    stats_type = 2

    def __init__(self, xid=None, flags=None, match=None, table_id=None, out_port=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(self.match.pack())
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 1)
        packed.append(util.pack_port_no(self.out_port))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = aggregate_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 16)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 2)
        obj.flags = reader.read("!H")[0]
        obj.match = common.match.unpack(reader)
        obj.table_id = reader.read("!B")[0]
        reader.skip(1)
        obj.out_port = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.table_id != other.table_id: return False
        if self.out_port != other.out_port: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("aggregate_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
            q.breakable()
        q.text('}')

class barrier_reply(Message):
    version = 1
    type = 19

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = barrier_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 19)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("barrier_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class barrier_request(Message):
    version = 1
    type = 18

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = barrier_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 18)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("barrier_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class bsn_bw_clear_data_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 22

    def __init__(self, xid=None, status=None):
        self.xid = xid
        if status != None:
            self.status = status
        else:
            self.status = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_bw_clear_data_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 22)
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_bw_clear_data_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

class bsn_bw_clear_data_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 21

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_bw_clear_data_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 21)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_bw_clear_data_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class bsn_bw_enable_get_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 20

    def __init__(self, xid=None, enabled=None):
        self.xid = xid
        if enabled != None:
            self.enabled = enabled
        else:
            self.enabled = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.enabled))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_bw_enable_get_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 20)
        obj.enabled = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.enabled != other.enabled: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_bw_enable_get_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("enabled = ");
                q.text("%#x" % self.enabled)
            q.breakable()
        q.text('}')

class bsn_bw_enable_get_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 19

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_bw_enable_get_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 19)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_bw_enable_get_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class bsn_bw_enable_set_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 23

    def __init__(self, xid=None, enable=None, status=None):
        self.xid = xid
        if enable != None:
            self.enable = enable
        else:
            self.enable = 0
        if status != None:
            self.status = status
        else:
            self.status = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.enable))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_bw_enable_set_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 23)
        obj.enable = reader.read("!L")[0]
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.enable != other.enable: return False
        if self.status != other.status: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_bw_enable_set_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("enable = ");
                q.text("%#x" % self.enable)
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

class bsn_bw_enable_set_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 18

    def __init__(self, xid=None, enable=None):
        self.xid = xid
        if enable != None:
            self.enable = enable
        else:
            self.enable = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.enable))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_bw_enable_set_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 18)
        obj.enable = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.enable != other.enable: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_bw_enable_set_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("enable = ");
                q.text("%#x" % self.enable)
            q.breakable()
        q.text('}')

class bsn_get_interfaces_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 10

    def __init__(self, xid=None, interfaces=None):
        self.xid = xid
        if interfaces != None:
            self.interfaces = interfaces
        else:
            self.interfaces = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(util.pack_list(self.interfaces))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_interfaces_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 10)
        obj.interfaces = loxi.generic_util.unpack_list(reader, common.bsn_interface.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.interfaces != other.interfaces: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_interfaces_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("interfaces = ");
                q.pp(self.interfaces)
            q.breakable()
        q.text('}')

class bsn_get_interfaces_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 9

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_interfaces_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 9)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_interfaces_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class bsn_get_ip_mask_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 2

    def __init__(self, xid=None, index=None, mask=None):
        self.xid = xid
        if index != None:
            self.index = index
        else:
            self.index = 0
        if mask != None:
            self.mask = mask
        else:
            self.mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.index))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.mask))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_ip_mask_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 2)
        obj.index = reader.read("!B")[0]
        reader.skip(3)
        obj.mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.index != other.index: return False
        if self.mask != other.mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_ip_mask_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("index = ");
                q.text("%#x" % self.index)
                q.text(","); q.breakable()
                q.text("mask = ");
                q.text("%#x" % self.mask)
            q.breakable()
        q.text('}')

class bsn_get_ip_mask_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 1

    def __init__(self, xid=None, index=None):
        self.xid = xid
        if index != None:
            self.index = index
        else:
            self.index = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.index))
        packed.append('\x00' * 7)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_ip_mask_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 1)
        obj.index = reader.read("!B")[0]
        reader.skip(7)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.index != other.index: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_ip_mask_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("index = ");
                q.text("%#x" % self.index)
            q.breakable()
        q.text('}')

class bsn_get_l2_table_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 14

    def __init__(self, xid=None, l2_table_enable=None, l2_table_priority=None):
        self.xid = xid
        if l2_table_enable != None:
            self.l2_table_enable = l2_table_enable
        else:
            self.l2_table_enable = 0
        if l2_table_priority != None:
            self.l2_table_priority = l2_table_priority
        else:
            self.l2_table_priority = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.l2_table_enable))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!H", self.l2_table_priority))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_l2_table_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 14)
        obj.l2_table_enable = reader.read("!B")[0]
        reader.skip(1)
        obj.l2_table_priority = reader.read("!H")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.l2_table_enable != other.l2_table_enable: return False
        if self.l2_table_priority != other.l2_table_priority: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_l2_table_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("l2_table_enable = ");
                q.text("%#x" % self.l2_table_enable)
                q.text(","); q.breakable()
                q.text("l2_table_priority = ");
                q.text("%#x" % self.l2_table_priority)
            q.breakable()
        q.text('}')

class bsn_get_l2_table_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 13

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_l2_table_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 13)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_l2_table_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class bsn_get_mirroring_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 5

    def __init__(self, xid=None, report_mirror_ports=None):
        self.xid = xid
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_mirroring_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 5)
        obj.report_mirror_ports = reader.read("!B")[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_mirroring_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
            q.breakable()
        q.text('}')

class bsn_get_mirroring_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 4

    def __init__(self, xid=None, report_mirror_ports=None):
        self.xid = xid
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_mirroring_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 4)
        obj.report_mirror_ports = reader.read("!B")[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_mirroring_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
            q.breakable()
        q.text('}')

class bsn_set_ip_mask(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 0

    def __init__(self, xid=None, index=None, mask=None):
        self.xid = xid
        if index != None:
            self.index = index
        else:
            self.index = 0
        if mask != None:
            self.mask = mask
        else:
            self.mask = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.index))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.mask))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_ip_mask()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 0)
        obj.index = reader.read("!B")[0]
        reader.skip(3)
        obj.mask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.index != other.index: return False
        if self.mask != other.mask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_ip_mask {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("index = ");
                q.text("%#x" % self.index)
                q.text(","); q.breakable()
                q.text("mask = ");
                q.text("%#x" % self.mask)
            q.breakable()
        q.text('}')

class bsn_set_l2_table_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 24

    def __init__(self, xid=None, l2_table_enable=None, l2_table_priority=None, status=None):
        self.xid = xid
        if l2_table_enable != None:
            self.l2_table_enable = l2_table_enable
        else:
            self.l2_table_enable = 0
        if l2_table_priority != None:
            self.l2_table_priority = l2_table_priority
        else:
            self.l2_table_priority = 0
        if status != None:
            self.status = status
        else:
            self.status = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.l2_table_enable))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!H", self.l2_table_priority))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_l2_table_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 24)
        obj.l2_table_enable = reader.read("!B")[0]
        reader.skip(1)
        obj.l2_table_priority = reader.read("!H")[0]
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.l2_table_enable != other.l2_table_enable: return False
        if self.l2_table_priority != other.l2_table_priority: return False
        if self.status != other.status: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_l2_table_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("l2_table_enable = ");
                q.text("%#x" % self.l2_table_enable)
                q.text(","); q.breakable()
                q.text("l2_table_priority = ");
                q.text("%#x" % self.l2_table_priority)
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

class bsn_set_l2_table_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 12

    def __init__(self, xid=None, l2_table_enable=None, l2_table_priority=None):
        self.xid = xid
        if l2_table_enable != None:
            self.l2_table_enable = l2_table_enable
        else:
            self.l2_table_enable = 0
        if l2_table_priority != None:
            self.l2_table_priority = l2_table_priority
        else:
            self.l2_table_priority = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.l2_table_enable))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!H", self.l2_table_priority))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_l2_table_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 12)
        obj.l2_table_enable = reader.read("!B")[0]
        reader.skip(1)
        obj.l2_table_priority = reader.read("!H")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.l2_table_enable != other.l2_table_enable: return False
        if self.l2_table_priority != other.l2_table_priority: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_l2_table_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("l2_table_enable = ");
                q.text("%#x" % self.l2_table_enable)
                q.text(","); q.breakable()
                q.text("l2_table_priority = ");
                q.text("%#x" % self.l2_table_priority)
            q.breakable()
        q.text('}')

class bsn_set_mirroring(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 3

    def __init__(self, xid=None, report_mirror_ports=None):
        self.xid = xid
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_mirroring()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 3)
        obj.report_mirror_ports = reader.read("!B")[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_mirroring {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
            q.breakable()
        q.text('}')

class bsn_set_pktin_suppression_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 25

    def __init__(self, xid=None, status=None):
        self.xid = xid
        if status != None:
            self.status = status
        else:
            self.status = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_pktin_suppression_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 25)
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_pktin_suppression_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

class bsn_set_pktin_suppression_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 11

    def __init__(self, xid=None, enabled=None, idle_timeout=None, hard_timeout=None, priority=None, cookie=None):
        self.xid = xid
        if enabled != None:
            self.enabled = enabled
        else:
            self.enabled = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.enabled))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!Q", self.cookie))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_pktin_suppression_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 11)
        obj.enabled = reader.read("!B")[0]
        reader.skip(1)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.cookie = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.enabled != other.enabled: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.cookie != other.cookie: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_pktin_suppression_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("enabled = ");
                q.text("%#x" % self.enabled)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
            q.breakable()
        q.text('}')

class bsn_shell_command(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 6

    def __init__(self, xid=None, service=None, data=None):
        self.xid = xid
        if service != None:
            self.service = service
        else:
            self.service = 0
        if data != None:
            self.data = data
        else:
            self.data = ''

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.service))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_shell_command()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 6)
        obj.service = reader.read("!L")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.service != other.service: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_shell_command {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("service = ");
                q.text("%#x" % self.service)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class bsn_shell_output(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 7

    def __init__(self, xid=None, data=None):
        self.xid = xid
        if data != None:
            self.data = data
        else:
            self.data = ''

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_shell_output()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 7)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_shell_output {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class bsn_shell_status(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 8

    def __init__(self, xid=None, status=None):
        self.xid = xid
        if status != None:
            self.status = status
        else:
            self.status = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_shell_status()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 8)
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_shell_status {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

class bsn_virtual_port_create_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 16

    def __init__(self, xid=None, status=None, vport_no=None):
        self.xid = xid
        if status != None:
            self.status = status
        else:
            self.status = 0
        if vport_no != None:
            self.vport_no = vport_no
        else:
            self.vport_no = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        packed.append(struct.pack("!L", self.vport_no))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_virtual_port_create_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 16)
        obj.status = reader.read("!L")[0]
        obj.vport_no = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        if self.vport_no != other.vport_no: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_virtual_port_create_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
                q.text(","); q.breakable()
                q.text("vport_no = ");
                q.text("%#x" % self.vport_no)
            q.breakable()
        q.text('}')

class bsn_virtual_port_create_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 15

    def __init__(self, xid=None, vport=None):
        self.xid = xid
        if vport != None:
            self.vport = vport
        else:
            self.vport = common.bsn_vport_q_in_q()

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(self.vport.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_virtual_port_create_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 15)
        obj.vport = common.bsn_vport_q_in_q.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.vport != other.vport: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_virtual_port_create_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("vport = ");
                q.pp(self.vport)
            q.breakable()
        q.text('}')

class bsn_virtual_port_remove_reply(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 26

    def __init__(self, xid=None, status=None):
        self.xid = xid
        if status != None:
            self.status = status
        else:
            self.status = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.status))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_virtual_port_remove_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 26)
        obj.status = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.status != other.status: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_virtual_port_remove_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("status = ");
                q.text("%#x" % self.status)
            q.breakable()
        q.text('}')

class bsn_virtual_port_remove_request(Message):
    version = 1
    type = 4
    experimenter = 6035143
    subtype = 17

    def __init__(self, xid=None, vport_no=None):
        self.xid = xid
        if vport_no != None:
            self.vport_no = vport_no
        else:
            self.vport_no = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.vport_no))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_virtual_port_remove_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 6035143)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 17)
        obj.vport_no = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.vport_no != other.vport_no: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_virtual_port_remove_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("vport_no = ");
                q.text("%#x" % self.vport_no)
            q.breakable()
        q.text('}')

class desc_stats_reply(Message):
    version = 1
    type = 17
    stats_type = 0

    def __init__(self, xid=None, flags=None, mfr_desc=None, hw_desc=None, sw_desc=None, serial_num=None, dp_desc=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if mfr_desc != None:
            self.mfr_desc = mfr_desc
        else:
            self.mfr_desc = ""
        if hw_desc != None:
            self.hw_desc = hw_desc
        else:
            self.hw_desc = ""
        if sw_desc != None:
            self.sw_desc = sw_desc
        else:
            self.sw_desc = ""
        if serial_num != None:
            self.serial_num = serial_num
        else:
            self.serial_num = ""
        if dp_desc != None:
            self.dp_desc = dp_desc
        else:
            self.dp_desc = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!256s", self.mfr_desc))
        packed.append(struct.pack("!256s", self.hw_desc))
        packed.append(struct.pack("!256s", self.sw_desc))
        packed.append(struct.pack("!32s", self.serial_num))
        packed.append(struct.pack("!256s", self.dp_desc))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = desc_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 17)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 0)
        obj.flags = reader.read("!H")[0]
        obj.mfr_desc = reader.read("!256s")[0].rstrip("\x00")
        obj.hw_desc = reader.read("!256s")[0].rstrip("\x00")
        obj.sw_desc = reader.read("!256s")[0].rstrip("\x00")
        obj.serial_num = reader.read("!32s")[0].rstrip("\x00")
        obj.dp_desc = reader.read("!256s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.mfr_desc != other.mfr_desc: return False
        if self.hw_desc != other.hw_desc: return False
        if self.sw_desc != other.sw_desc: return False
        if self.serial_num != other.serial_num: return False
        if self.dp_desc != other.dp_desc: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("desc_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("mfr_desc = ");
                q.pp(self.mfr_desc)
                q.text(","); q.breakable()
                q.text("hw_desc = ");
                q.pp(self.hw_desc)
                q.text(","); q.breakable()
                q.text("sw_desc = ");
                q.pp(self.sw_desc)
                q.text(","); q.breakable()
                q.text("serial_num = ");
                q.pp(self.serial_num)
                q.text(","); q.breakable()
                q.text("dp_desc = ");
                q.pp(self.dp_desc)
            q.breakable()
        q.text('}')

class desc_stats_request(Message):
    version = 1
    type = 16
    stats_type = 0

    def __init__(self, xid=None, flags=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = desc_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 16)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 0)
        obj.flags = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("desc_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

class echo_reply(Message):
    version = 1
    type = 3

    def __init__(self, xid=None, data=None):
        self.xid = xid
        if data != None:
            self.data = data
        else:
            self.data = ''

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = echo_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 3)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("echo_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class echo_request(Message):
    version = 1
    type = 2

    def __init__(self, xid=None, data=None):
        self.xid = xid
        if data != None:
            self.data = data
        else:
            self.data = ''

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = echo_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 2)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("echo_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class error_msg(Message):
    version = 1
    type = 1

    def __init__(self, xid=None, err_type=None, code=None, data=None):
        self.xid = xid
        if err_type != None:
            self.err_type = err_type
        else:
            self.err_type = 0
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ''

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = error_msg()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.err_type = reader.read("!H")[0]
        obj.code = reader.read("!H")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.err_type != other.err_type: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("err_type = ");
                q.text("%#x" % self.err_type)
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class experimenter_stats_reply(Message):
    version = 1
    type = 17
    stats_type = 65535

    def __init__(self, xid=None, flags=None, experimenter=None, data=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ''

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = experimenter_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 17)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 65535)
        obj.flags = reader.read("!H")[0]
        obj.experimenter = reader.read("!L")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("experimenter_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("experimenter = ");
                q.text("%#x" % self.experimenter)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class experimenter_stats_request(Message):
    version = 1
    type = 16
    stats_type = 65535

    def __init__(self, xid=None, flags=None, experimenter=None, data=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ''

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = experimenter_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 16)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 65535)
        obj.flags = reader.read("!H")[0]
        obj.experimenter = reader.read("!L")[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("experimenter_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("experimenter = ");
                q.text("%#x" % self.experimenter)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class features_reply(Message):
    version = 1
    type = 6

    def __init__(self, xid=None, datapath_id=None, n_buffers=None, n_tables=None, capabilities=None, actions=None, ports=None):
        self.xid = xid
        if datapath_id != None:
            self.datapath_id = datapath_id
        else:
            self.datapath_id = 0
        if n_buffers != None:
            self.n_buffers = n_buffers
        else:
            self.n_buffers = 0
        if n_tables != None:
            self.n_tables = n_tables
        else:
            self.n_tables = 0
        if capabilities != None:
            self.capabilities = capabilities
        else:
            self.capabilities = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = 0
        if ports != None:
            self.ports = ports
        else:
            self.ports = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.datapath_id))
        packed.append(struct.pack("!L", self.n_buffers))
        packed.append(struct.pack("!B", self.n_tables))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.capabilities))
        packed.append(struct.pack("!L", self.actions))
        packed.append(util.pack_list(self.ports))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = features_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 6)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.datapath_id = reader.read("!Q")[0]
        obj.n_buffers = reader.read("!L")[0]
        obj.n_tables = reader.read("!B")[0]
        reader.skip(3)
        obj.capabilities = reader.read("!L")[0]
        obj.actions = reader.read("!L")[0]
        obj.ports = loxi.generic_util.unpack_list(reader, common.port_desc.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.datapath_id != other.datapath_id: return False
        if self.n_buffers != other.n_buffers: return False
        if self.n_tables != other.n_tables: return False
        if self.capabilities != other.capabilities: return False
        if self.actions != other.actions: return False
        if self.ports != other.ports: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("features_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("datapath_id = ");
                q.text("%#x" % self.datapath_id)
                q.text(","); q.breakable()
                q.text("n_buffers = ");
                q.text("%#x" % self.n_buffers)
                q.text(","); q.breakable()
                q.text("n_tables = ");
                q.text("%#x" % self.n_tables)
                q.text(","); q.breakable()
                q.text("capabilities = ");
                q.text("%#x" % self.capabilities)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.text("%#x" % self.actions)
                q.text(","); q.breakable()
                q.text("ports = ");
                q.pp(self.ports)
            q.breakable()
        q.text('}')

class features_request(Message):
    version = 1
    type = 5

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = features_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 5)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("features_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class flow_add(Message):
    version = 1
    type = 14
    _command = 0

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_list(self.actions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_add()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.match = common.match.unpack(reader)
        obj.cookie = reader.read("!Q")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 0)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.flags = reader.read("!H")[0]
        obj.actions = action.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_add {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_delete(Message):
    version = 1
    type = 14
    _command = 3

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_list(self.actions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_delete()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.match = common.match.unpack(reader)
        obj.cookie = reader.read("!Q")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 3)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.flags = reader.read("!H")[0]
        obj.actions = action.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_delete {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_delete_strict(Message):
    version = 1
    type = 14
    _command = 4

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_list(self.actions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_delete_strict()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.match = common.match.unpack(reader)
        obj.cookie = reader.read("!Q")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 4)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.flags = reader.read("!H")[0]
        obj.actions = action.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_delete_strict {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_modify(Message):
    version = 1
    type = 14
    _command = 1

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_list(self.actions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_modify()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.match = common.match.unpack(reader)
        obj.cookie = reader.read("!Q")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 1)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.flags = reader.read("!H")[0]
        obj.actions = action.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_modify {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_modify_strict(Message):
    version = 1
    type = 14
    _command = 2

    def __init__(self, xid=None, match=None, cookie=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, flags=None, actions=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(util.pack_fm_cmd(self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.out_port))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_list(self.actions))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_modify_strict()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 14)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.match = common.match.unpack(reader)
        obj.cookie = reader.read("!Q")[0]
        __command = util.unpack_fm_cmd(reader)
        assert(__command == 2)
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        obj.priority = reader.read("!H")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.out_port = util.unpack_port_no(reader)
        obj.flags = reader.read("!H")[0]
        obj.actions = action.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.flags != other.flags: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_modify_strict {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class flow_removed(Message):
    version = 1
    type = 11

    def __init__(self, xid=None, match=None, cookie=None, priority=None, reason=None, duration_sec=None, duration_nsec=None, idle_timeout=None, packet_count=None, byte_count=None):
        self.xid = xid
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.match.pack())
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!B", self.reason))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_removed()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 11)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.match = common.match.unpack(reader)
        obj.cookie = reader.read("!Q")[0]
        obj.priority = reader.read("!H")[0]
        obj.reason = reader.read("!B")[0]
        reader.skip(1)
        obj.duration_sec = reader.read("!L")[0]
        obj.duration_nsec = reader.read("!L")[0]
        obj.idle_timeout = reader.read("!H")[0]
        reader.skip(2)
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.match != other.match: return False
        if self.cookie != other.cookie: return False
        if self.priority != other.priority: return False
        if self.reason != other.reason: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_removed {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
            q.breakable()
        q.text('}')

class flow_stats_reply(Message):
    version = 1
    type = 17
    stats_type = 1

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 17)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 1)
        obj.flags = reader.read("!H")[0]
        obj.entries = common.unpack_list_flow_stats_entry(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class flow_stats_request(Message):
    version = 1
    type = 16
    stats_type = 1

    def __init__(self, xid=None, flags=None, match=None, table_id=None, out_port=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(self.match.pack())
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 1)
        packed.append(util.pack_port_no(self.out_port))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 16)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 1)
        obj.flags = reader.read("!H")[0]
        obj.match = common.match.unpack(reader)
        obj.table_id = reader.read("!B")[0]
        reader.skip(1)
        obj.out_port = util.unpack_port_no(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.table_id != other.table_id: return False
        if self.out_port != other.out_port: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
            q.breakable()
        q.text('}')

class get_config_reply(Message):
    version = 1
    type = 8

    def __init__(self, xid=None, flags=None, miss_send_len=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if miss_send_len != None:
            self.miss_send_len = miss_send_len
        else:
            self.miss_send_len = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.miss_send_len))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = get_config_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 8)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        obj.miss_send_len = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.miss_send_len != other.miss_send_len: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("get_config_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("miss_send_len = ");
                q.text("%#x" % self.miss_send_len)
            q.breakable()
        q.text('}')

class get_config_request(Message):
    version = 1
    type = 7

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = get_config_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 7)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("get_config_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class hello(Message):
    version = 1
    type = 0

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = hello()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 0)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("hello {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class nicira_controller_role_reply(Message):
    version = 1
    type = 4
    experimenter = 8992
    subtype = 11

    def __init__(self, xid=None, role=None):
        self.xid = xid
        if role != None:
            self.role = role
        else:
            self.role = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.role))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = nicira_controller_role_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 8992)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 11)
        obj.role = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.role != other.role: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("nicira_controller_role_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("role = ");
                q.text("%#x" % self.role)
            q.breakable()
        q.text('}')

class nicira_controller_role_request(Message):
    version = 1
    type = 4
    experimenter = 8992
    subtype = 10

    def __init__(self, xid=None, role=None):
        self.xid = xid
        if role != None:
            self.role = role
        else:
            self.role = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!L", self.role))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = nicira_controller_role_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 4)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _experimenter = reader.read("!L")[0]
        assert(_experimenter == 8992)
        _subtype = reader.read("!L")[0]
        assert(_subtype == 10)
        obj.role = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.role != other.role: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("nicira_controller_role_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("role = ");
                q.text("%#x" % self.role)
            q.breakable()
        q.text('}')

class packet_in(Message):
    version = 1
    type = 10

    def __init__(self, xid=None, buffer_id=None, total_len=None, in_port=None, reason=None, data=None):
        self.xid = xid
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if total_len != None:
            self.total_len = total_len
        else:
            self.total_len = 0
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if data != None:
            self.data = data
        else:
            self.data = ''

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!H", self.total_len))
        packed.append(util.pack_port_no(self.in_port))
        packed.append(struct.pack("!B", self.reason))
        packed.append('\x00' * 1)
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = packet_in()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 10)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.total_len = reader.read("!H")[0]
        obj.in_port = util.unpack_port_no(reader)
        obj.reason = reader.read("!B")[0]
        reader.skip(1)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.buffer_id != other.buffer_id: return False
        if self.total_len != other.total_len: return False
        if self.in_port != other.in_port: return False
        if self.reason != other.reason: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("packet_in {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("total_len = ");
                q.text("%#x" % self.total_len)
                q.text(","); q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class packet_out(Message):
    version = 1
    type = 13

    def __init__(self, xid=None, buffer_id=None, in_port=None, actions=None, data=None):
        self.xid = xid
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []
        if data != None:
            self.data = data
        else:
            self.data = ''

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(util.pack_port_no(self.in_port))
        packed.append(struct.pack("!H", 0)) # placeholder for actions_len at index 6
        packed.append(util.pack_list(self.actions))
        packed[6] = struct.pack("!H", len(packed[-1]))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = packet_out()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 13)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.buffer_id = reader.read("!L")[0]
        obj.in_port = util.unpack_port_no(reader)
        _actions_len = reader.read("!H")[0]
        obj.actions = action.unpack_list(reader.slice(_actions_len))
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.buffer_id != other.buffer_id: return False
        if self.in_port != other.in_port: return False
        if self.actions != other.actions: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("packet_out {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class port_mod(Message):
    version = 1
    type = 15

    def __init__(self, xid=None, port_no=None, hw_addr=None, config=None, mask=None, advertise=None):
        self.xid = xid
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if config != None:
            self.config = config
        else:
            self.config = 0
        if mask != None:
            self.mask = mask
        else:
            self.mask = 0
        if advertise != None:
            self.advertise = advertise
        else:
            self.advertise = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.mask))
        packed.append(struct.pack("!L", self.advertise))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_mod()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 15)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.port_no = util.unpack_port_no(reader)
        obj.hw_addr = list(reader.read('!6B'))
        obj.config = reader.read("!L")[0]
        obj.mask = reader.read("!L")[0]
        obj.advertise = reader.read("!L")[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.port_no != other.port_no: return False
        if self.hw_addr != other.hw_addr: return False
        if self.config != other.config: return False
        if self.mask != other.mask: return False
        if self.advertise != other.advertise: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("mask = ");
                q.text("%#x" % self.mask)
                q.text(","); q.breakable()
                q.text("advertise = ");
                q.text("%#x" % self.advertise)
            q.breakable()
        q.text('}')

class port_stats_reply(Message):
    version = 1
    type = 17
    stats_type = 4

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 17)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 4)
        obj.flags = reader.read("!H")[0]
        obj.entries = loxi.generic_util.unpack_list(reader, common.port_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class port_stats_request(Message):
    version = 1
    type = 16
    stats_type = 4

    def __init__(self, xid=None, flags=None, port_no=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 16)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 4)
        obj.flags = reader.read("!H")[0]
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
            q.breakable()
        q.text('}')

class port_status(Message):
    version = 1
    type = 12

    def __init__(self, xid=None, reason=None, desc=None):
        self.xid = xid
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if desc != None:
            self.desc = desc
        else:
            self.desc = common.port_desc()

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!B", self.reason))
        packed.append('\x00' * 7)
        packed.append(self.desc.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_status()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 12)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.reason = reader.read("!B")[0]
        reader.skip(7)
        obj.desc = common.port_desc.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.reason != other.reason: return False
        if self.desc != other.desc: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_status {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("desc = ");
                q.pp(self.desc)
            q.breakable()
        q.text('}')

class queue_get_config_reply(Message):
    version = 1
    type = 21

    def __init__(self, xid=None, port=None, queues=None):
        self.xid = xid
        if port != None:
            self.port = port
        else:
            self.port = 0
        if queues != None:
            self.queues = queues
        else:
            self.queues = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(util.pack_port_no(self.port))
        packed.append('\x00' * 6)
        packed.append(util.pack_list(self.queues))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_get_config_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 21)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.port = util.unpack_port_no(reader)
        reader.skip(6)
        obj.queues = common.unpack_list_packet_queue(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.port != other.port: return False
        if self.queues != other.queues: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_get_config_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
                q.text(","); q.breakable()
                q.text("queues = ");
                q.pp(self.queues)
            q.breakable()
        q.text('}')

class queue_get_config_request(Message):
    version = 1
    type = 20

    def __init__(self, xid=None, port=None):
        self.xid = xid
        if port != None:
            self.port = port
        else:
            self.port = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(util.pack_port_no(self.port))
        packed.append('\x00' * 2)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_get_config_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 20)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.port = util.unpack_port_no(reader)
        reader.skip(2)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.port != other.port: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_get_config_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
            q.breakable()
        q.text('}')

class queue_stats_reply(Message):
    version = 1
    type = 17
    stats_type = 5

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 17)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 5)
        obj.flags = reader.read("!H")[0]
        obj.entries = loxi.generic_util.unpack_list(reader, common.queue_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class queue_stats_request(Message):
    version = 1
    type = 16
    stats_type = 5

    def __init__(self, xid=None, flags=None, port_no=None, queue_id=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.queue_id))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 16)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 5)
        obj.flags = reader.read("!H")[0]
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(2)
        obj.queue_id = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        if self.queue_id != other.queue_id: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
            q.breakable()
        q.text('}')

class set_config(Message):
    version = 1
    type = 9

    def __init__(self, xid=None, flags=None, miss_send_len=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if miss_send_len != None:
            self.miss_send_len = miss_send_len
        else:
            self.miss_send_len = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.miss_send_len))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = set_config()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 9)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.flags = reader.read("!H")[0]
        obj.miss_send_len = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.miss_send_len != other.miss_send_len: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("set_config {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("miss_send_len = ");
                q.text("%#x" % self.miss_send_len)
            q.breakable()
        q.text('}')

class table_mod(Message):
    version = 1
    type = 22

    def __init__(self, xid=None, table_id=None, config=None):
        self.xid = xid
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if config != None:
            self.config = config
        else:
            self.config = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.config))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = table_mod()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 22)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        obj.table_id = reader.read("!B")[0]
        reader.skip(3)
        obj.config = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.table_id != other.table_id: return False
        if self.config != other.config: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
            q.breakable()
        q.text('}')

class table_stats_reply(Message):
    version = 1
    type = 17
    stats_type = 3

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append(util.pack_list(self.entries))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = table_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 17)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 3)
        obj.flags = reader.read("!H")[0]
        obj.entries = loxi.generic_util.unpack_list(reader, common.table_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class table_stats_request(Message):
    version = 1
    type = 16
    stats_type = 3

    def __init__(self, xid=None, flags=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = table_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read("!B")[0]
        assert(_version == 1)
        _type = reader.read("!B")[0]
        assert(_type == 16)
        _length = reader.read("!H")[0]
        obj.xid = reader.read("!L")[0]
        _stats_type = reader.read("!H")[0]
        assert(_stats_type == 3)
        obj.flags = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')


def parse_header(buf):
    if len(buf) < 8:
        raise loxi.ProtocolError("too short to be an OpenFlow message")
    return struct.unpack_from("!BBHL", buf)

def parse_message(buf):
    msg_ver, msg_type, msg_len, msg_xid = parse_header(buf)
    if msg_ver != const.OFP_VERSION and msg_type != ofp.OFPT_HELLO:
        raise loxi.ProtocolError("wrong OpenFlow version")
    if len(buf) != msg_len:
        raise loxi.ProtocolError("incorrect message size")
    if msg_type in parsers:
        return parsers[msg_type](buf)
    else:
        raise loxi.ProtocolError("unexpected message type")

def parse_flow_mod(buf):
    if len(buf) < 56 + 2:
        raise loxi.ProtocolError("message too short")
    cmd, = struct.unpack_from("!H", buf, 56)
    if cmd in flow_mod_parsers:
        return flow_mod_parsers[cmd](buf)
    else:
        raise loxi.ProtocolError("unexpected flow mod cmd %u" % cmd)

def parse_stats_reply(buf):
    if len(buf) < 8 + 2:
        raise loxi.ProtocolError("message too short")
    stats_type, = struct.unpack_from("!H", buf, 8)
    if stats_type in stats_reply_parsers:
        return stats_reply_parsers[stats_type](buf)
    else:
        raise loxi.ProtocolError("unexpected stats type %u" % stats_type)

def parse_stats_request(buf):
    if len(buf) < 8 + 2:
        raise loxi.ProtocolError("message too short")
    stats_type, = struct.unpack_from("!H", buf, 8)
    if stats_type in stats_request_parsers:
        return stats_request_parsers[stats_type](buf)
    else:
        raise loxi.ProtocolError("unexpected stats type %u" % stats_type)

def parse_vendor(buf):
    if len(buf) < 16:
        raise loxi.ProtocolError("experimenter message too short")

    experimenter, = struct.unpack_from("!L", buf, 8)
    if experimenter == 0x005c16c7: # Big Switch Networks
        subtype, = struct.unpack_from("!L", buf, 12)
    elif experimenter == 0x00002320: # Nicira
        subtype, = struct.unpack_from("!L", buf, 12)
    else:
        raise loxi.ProtocolError("unexpected experimenter id %#x" % experimenter)

    if subtype in experimenter_parsers[experimenter]:
        return experimenter_parsers[experimenter][subtype](buf)
    else:
        raise loxi.ProtocolError("unexpected experimenter %#x subtype %#x" % (experimenter, subtype))

parsers = {
    const.OFPT_HELLO : hello.unpack,
    const.OFPT_ERROR : error_msg.unpack,
    const.OFPT_ECHO_REQUEST : echo_request.unpack,
    const.OFPT_ECHO_REPLY : echo_reply.unpack,
    const.OFPT_VENDOR : parse_vendor,
    const.OFPT_FEATURES_REQUEST : features_request.unpack,
    const.OFPT_FEATURES_REPLY : features_reply.unpack,
    const.OFPT_GET_CONFIG_REQUEST : get_config_request.unpack,
    const.OFPT_GET_CONFIG_REPLY : get_config_reply.unpack,
    const.OFPT_SET_CONFIG : set_config.unpack,
    const.OFPT_PACKET_IN : packet_in.unpack,
    const.OFPT_FLOW_REMOVED : flow_removed.unpack,
    const.OFPT_PORT_STATUS : port_status.unpack,
    const.OFPT_PACKET_OUT : packet_out.unpack,
    const.OFPT_FLOW_MOD : parse_flow_mod,
    const.OFPT_PORT_MOD : port_mod.unpack,
    const.OFPT_STATS_REQUEST : parse_stats_request,
    const.OFPT_STATS_REPLY : parse_stats_reply,
    const.OFPT_BARRIER_REQUEST : barrier_request.unpack,
    const.OFPT_BARRIER_REPLY : barrier_reply.unpack,
    const.OFPT_QUEUE_GET_CONFIG_REQUEST : queue_get_config_request.unpack,
    const.OFPT_QUEUE_GET_CONFIG_REPLY : queue_get_config_reply.unpack,
    22 : table_mod.unpack,
}

flow_mod_parsers = {
    const.OFPFC_ADD : flow_add.unpack,
    const.OFPFC_MODIFY : flow_modify.unpack,
    const.OFPFC_MODIFY_STRICT : flow_modify_strict.unpack,
    const.OFPFC_DELETE : flow_delete.unpack,
    const.OFPFC_DELETE_STRICT : flow_delete_strict.unpack,
}

stats_reply_parsers = {
    const.OFPST_DESC : desc_stats_reply.unpack,
    const.OFPST_FLOW : flow_stats_reply.unpack,
    const.OFPST_AGGREGATE : aggregate_stats_reply.unpack,
    const.OFPST_TABLE : table_stats_reply.unpack,
    const.OFPST_PORT : port_stats_reply.unpack,
    const.OFPST_QUEUE : queue_stats_reply.unpack,
    const.OFPST_VENDOR : experimenter_stats_reply.unpack,
}

stats_request_parsers = {
    const.OFPST_DESC : desc_stats_request.unpack,
    const.OFPST_FLOW : flow_stats_request.unpack,
    const.OFPST_AGGREGATE : aggregate_stats_request.unpack,
    const.OFPST_TABLE : table_stats_request.unpack,
    const.OFPST_PORT : port_stats_request.unpack,
    const.OFPST_QUEUE : queue_stats_request.unpack,
    const.OFPST_VENDOR : experimenter_stats_request.unpack,
}

experimenter_parsers = {
    8992 : {
        11: nicira_controller_role_reply.unpack,
        10: nicira_controller_role_request.unpack,
    },
    6035143 : {
        22: bsn_bw_clear_data_reply.unpack,
        21: bsn_bw_clear_data_request.unpack,
        20: bsn_bw_enable_get_reply.unpack,
        19: bsn_bw_enable_get_request.unpack,
        23: bsn_bw_enable_set_reply.unpack,
        18: bsn_bw_enable_set_request.unpack,
        10: bsn_get_interfaces_reply.unpack,
        9: bsn_get_interfaces_request.unpack,
        2: bsn_get_ip_mask_reply.unpack,
        1: bsn_get_ip_mask_request.unpack,
        14: bsn_get_l2_table_reply.unpack,
        13: bsn_get_l2_table_request.unpack,
        5: bsn_get_mirroring_reply.unpack,
        4: bsn_get_mirroring_request.unpack,
        0: bsn_set_ip_mask.unpack,
        24: bsn_set_l2_table_reply.unpack,
        12: bsn_set_l2_table_request.unpack,
        3: bsn_set_mirroring.unpack,
        25: bsn_set_pktin_suppression_reply.unpack,
        11: bsn_set_pktin_suppression_request.unpack,
        6: bsn_shell_command.unpack,
        7: bsn_shell_output.unpack,
        8: bsn_shell_status.unpack,
        16: bsn_virtual_port_create_reply.unpack,
        15: bsn_virtual_port_create_request.unpack,
        26: bsn_virtual_port_remove_reply.unpack,
        17: bsn_virtual_port_remove_request.unpack,
    },
}
