# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.

# Automatically generated by LOXI from template message.py
# Do not modify

import struct
import loxi
import const
import common
import action # for unpack_list
import instruction # for unpack_list
import util
import loxi.generic_util

class Message(object):
    version = const.OFP_VERSION
    type = None # override in subclass
    xid = None

class aggregate_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_AGGREGATE

    def __init__(self, xid=None, flags=None, packet_count=None, byte_count=None, flow_count=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if flow_count != None:
            self.flow_count = flow_count
        else:
            self.flow_count = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(struct.pack("!L", self.flow_count))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = aggregate_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_AGGREGATE)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.packet_count = reader.read('!Q')[0]
        obj.byte_count = reader.read('!Q')[0]
        obj.flow_count = reader.read('!L')[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.flow_count != other.flow_count: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("aggregate_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("flow_count = ");
                q.text("%#x" % self.flow_count)
            q.breakable()
        q.text('}')

class aggregate_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_AGGREGATE

    def __init__(self, xid=None, flags=None, table_id=None, out_port=None, out_group=None, cookie=None, cookie_mask=None, match=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(self.match.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = aggregate_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_AGGREGATE)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.table_id = reader.read('!B')[0]
        reader.skip(3)
        obj.out_port = reader.read('!L')[0]
        obj.out_group = reader.read('!L')[0]
        reader.skip(4)
        obj.cookie = reader.read('!Q')[0]
        obj.cookie_mask = reader.read('!Q')[0]
        obj.match = common.match.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.table_id != other.table_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.match != other.match: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("aggregate_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
            q.breakable()
        q.text('}')

class barrier_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_BARRIER_REPLY

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = barrier_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_BARRIER_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("barrier_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class barrier_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_BARRIER_REQUEST

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = barrier_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_BARRIER_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("barrier_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class bsn_get_interfaces_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_EXPERIMENTER
    experimenter = 0x5c16c7
    subtype = 10

    def __init__(self, xid=None, interfaces=None):
        self.xid = xid
        if interfaces != None:
            self.interfaces = interfaces
        else:
            self.interfaces = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append("".join([x.pack() for x in self.interfaces]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_interfaces_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_EXPERIMENTER)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _experimenter = reader.read('!L')[0]
        assert(_experimenter == 0x5c16c7)
        _subtype = reader.read('!L')[0]
        assert(_subtype == 10)
        obj.interfaces = loxi.generic_util.unpack_list(reader, common.bsn_interface.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.interfaces != other.interfaces: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_interfaces_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("interfaces = ");
                q.pp(self.interfaces)
            q.breakable()
        q.text('}')

class bsn_get_interfaces_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_EXPERIMENTER
    experimenter = 0x5c16c7
    subtype = 9

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_interfaces_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_EXPERIMENTER)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _experimenter = reader.read('!L')[0]
        assert(_experimenter == 0x5c16c7)
        _subtype = reader.read('!L')[0]
        assert(_subtype == 9)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_interfaces_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class bsn_get_mirroring_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_EXPERIMENTER
    experimenter = 0x5c16c7
    subtype = 5

    def __init__(self, xid=None, report_mirror_ports=None):
        self.xid = xid
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_mirroring_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_EXPERIMENTER)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _experimenter = reader.read('!L')[0]
        assert(_experimenter == 0x5c16c7)
        _subtype = reader.read('!L')[0]
        assert(_subtype == 5)
        obj.report_mirror_ports = reader.read('!B')[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_mirroring_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
            q.breakable()
        q.text('}')

class bsn_get_mirroring_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_EXPERIMENTER
    experimenter = 0x5c16c7
    subtype = 4

    def __init__(self, xid=None, report_mirror_ports=None):
        self.xid = xid
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_get_mirroring_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_EXPERIMENTER)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _experimenter = reader.read('!L')[0]
        assert(_experimenter == 0x5c16c7)
        _subtype = reader.read('!L')[0]
        assert(_subtype == 4)
        obj.report_mirror_ports = reader.read('!B')[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_get_mirroring_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
            q.breakable()
        q.text('}')

class bsn_set_mirroring(Message):
    version = const.OFP_VERSION
    type = const.OFPT_EXPERIMENTER
    experimenter = 0x5c16c7
    subtype = 3

    def __init__(self, xid=None, report_mirror_ports=None):
        self.xid = xid
        if report_mirror_ports != None:
            self.report_mirror_ports = report_mirror_ports
        else:
            self.report_mirror_ports = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.report_mirror_ports))
        packed.append('\x00' * 3)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_mirroring()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_EXPERIMENTER)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _experimenter = reader.read('!L')[0]
        assert(_experimenter == 0x5c16c7)
        _subtype = reader.read('!L')[0]
        assert(_subtype == 3)
        obj.report_mirror_ports = reader.read('!B')[0]
        reader.skip(3)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.report_mirror_ports != other.report_mirror_ports: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_mirroring {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("report_mirror_ports = ");
                q.text("%#x" % self.report_mirror_ports)
            q.breakable()
        q.text('}')

class bsn_set_pktin_suppression(Message):
    version = const.OFP_VERSION
    type = const.OFPT_EXPERIMENTER
    experimenter = 0x5c16c7
    subtype = 11

    def __init__(self, xid=None, enabled=None, idle_timeout=None, hard_timeout=None, priority=None, cookie=None):
        self.xid = xid
        if enabled != None:
            self.enabled = enabled
        else:
            self.enabled = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(struct.pack("!B", self.enabled))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!Q", self.cookie))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = bsn_set_pktin_suppression()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_EXPERIMENTER)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _experimenter = reader.read('!L')[0]
        assert(_experimenter == 0x5c16c7)
        _subtype = reader.read('!L')[0]
        assert(_subtype == 11)
        obj.enabled = reader.read('!B')[0]
        reader.skip(1)
        obj.idle_timeout = reader.read('!H')[0]
        obj.hard_timeout = reader.read('!H')[0]
        obj.priority = reader.read('!H')[0]
        obj.cookie = reader.read('!Q')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.enabled != other.enabled: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.cookie != other.cookie: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_set_pktin_suppression {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("enabled = ");
                q.text("%#x" % self.enabled)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
            q.breakable()
        q.text('}')

class desc_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_DESC

    def __init__(self, xid=None, flags=None, mfr_desc=None, hw_desc=None, sw_desc=None, serial_num=None, dp_desc=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if mfr_desc != None:
            self.mfr_desc = mfr_desc
        else:
            self.mfr_desc = ""
        if hw_desc != None:
            self.hw_desc = hw_desc
        else:
            self.hw_desc = ""
        if sw_desc != None:
            self.sw_desc = sw_desc
        else:
            self.sw_desc = ""
        if serial_num != None:
            self.serial_num = serial_num
        else:
            self.serial_num = ""
        if dp_desc != None:
            self.dp_desc = dp_desc
        else:
            self.dp_desc = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!256s", self.mfr_desc))
        packed.append(struct.pack("!256s", self.hw_desc))
        packed.append(struct.pack("!256s", self.sw_desc))
        packed.append(struct.pack("!32s", self.serial_num))
        packed.append(struct.pack("!256s", self.dp_desc))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = desc_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_DESC)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.mfr_desc = reader.read("!256s")[0].rstrip("\x00")
        obj.hw_desc = reader.read("!256s")[0].rstrip("\x00")
        obj.sw_desc = reader.read("!256s")[0].rstrip("\x00")
        obj.serial_num = reader.read("!32s")[0].rstrip("\x00")
        obj.dp_desc = reader.read("!256s")[0].rstrip("\x00")
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.mfr_desc != other.mfr_desc: return False
        if self.hw_desc != other.hw_desc: return False
        if self.sw_desc != other.sw_desc: return False
        if self.serial_num != other.serial_num: return False
        if self.dp_desc != other.dp_desc: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("desc_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("mfr_desc = ");
                q.pp(self.mfr_desc)
                q.text(","); q.breakable()
                q.text("hw_desc = ");
                q.pp(self.hw_desc)
                q.text(","); q.breakable()
                q.text("sw_desc = ");
                q.pp(self.sw_desc)
                q.text(","); q.breakable()
                q.text("serial_num = ");
                q.pp(self.serial_num)
                q.text(","); q.breakable()
                q.text("dp_desc = ");
                q.pp(self.dp_desc)
            q.breakable()
        q.text('}')

class desc_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_DESC

    def __init__(self, xid=None, flags=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = desc_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_DESC)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("desc_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

class echo_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_ECHO_REPLY

    def __init__(self, xid=None, data=None):
        self.xid = xid
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = echo_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_ECHO_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("echo_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class echo_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_ECHO_REQUEST

    def __init__(self, xid=None, data=None):
        self.xid = xid
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = echo_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_ECHO_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("echo_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class error_msg(Message):
    version = const.OFP_VERSION
    type = const.OFPT_ERROR

    def __init__(self, xid=None, err_type=None, code=None, data=None):
        self.xid = xid
        if err_type != None:
            self.err_type = err_type
        else:
            self.err_type = 0
        if code != None:
            self.code = code
        else:
            self.code = 0
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.err_type))
        packed.append(struct.pack("!H", self.code))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = error_msg()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_ERROR)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.err_type = reader.read('!H')[0]
        obj.code = reader.read('!H')[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.err_type != other.err_type: return False
        if self.code != other.code: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("error_msg {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("err_type = ");
                q.text("%#x" % self.err_type)
                q.text(","); q.breakable()
                q.text("code = ");
                q.text("%#x" % self.code)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class experimenter_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_EXPERIMENTER

    def __init__(self, xid=None, flags=None, experimenter=None, subtype=None, data=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = experimenter_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_EXPERIMENTER)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.experimenter = reader.read('!L')[0]
        obj.subtype = reader.read('!L')[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.experimenter != other.experimenter: return False
        if self.subtype != other.subtype: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("experimenter_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("experimenter = ");
                q.text("%#x" % self.experimenter)
                q.text(","); q.breakable()
                q.text("subtype = ");
                q.text("%#x" % self.subtype)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class experimenter_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_EXPERIMENTER

    def __init__(self, xid=None, flags=None, experimenter=None, subtype=None, data=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if subtype != None:
            self.subtype = subtype
        else:
            self.subtype = 0
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.experimenter))
        packed.append(struct.pack("!L", self.subtype))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = experimenter_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_EXPERIMENTER)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.experimenter = reader.read('!L')[0]
        obj.subtype = reader.read('!L')[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.experimenter != other.experimenter: return False
        if self.subtype != other.subtype: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("experimenter_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("experimenter = ");
                q.text("%#x" % self.experimenter)
                q.text(","); q.breakable()
                q.text("subtype = ");
                q.text("%#x" % self.subtype)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class features_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FEATURES_REPLY

    def __init__(self, xid=None, datapath_id=None, n_buffers=None, n_tables=None, capabilities=None, reserved=None, ports=None):
        self.xid = xid
        if datapath_id != None:
            self.datapath_id = datapath_id
        else:
            self.datapath_id = 0
        if n_buffers != None:
            self.n_buffers = n_buffers
        else:
            self.n_buffers = 0
        if n_tables != None:
            self.n_tables = n_tables
        else:
            self.n_tables = 0
        if capabilities != None:
            self.capabilities = capabilities
        else:
            self.capabilities = 0
        if reserved != None:
            self.reserved = reserved
        else:
            self.reserved = 0
        if ports != None:
            self.ports = ports
        else:
            self.ports = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.datapath_id))
        packed.append(struct.pack("!L", self.n_buffers))
        packed.append(struct.pack("!B", self.n_tables))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.capabilities))
        packed.append(struct.pack("!L", self.reserved))
        packed.append("".join([x.pack() for x in self.ports]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = features_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_FEATURES_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.datapath_id = reader.read('!Q')[0]
        obj.n_buffers = reader.read('!L')[0]
        obj.n_tables = reader.read('!B')[0]
        reader.skip(3)
        obj.capabilities = reader.read('!L')[0]
        obj.reserved = reader.read('!L')[0]
        obj.ports = loxi.generic_util.unpack_list(reader, common.port_desc.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.datapath_id != other.datapath_id: return False
        if self.n_buffers != other.n_buffers: return False
        if self.n_tables != other.n_tables: return False
        if self.capabilities != other.capabilities: return False
        if self.reserved != other.reserved: return False
        if self.ports != other.ports: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("features_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("datapath_id = ");
                q.text("%#x" % self.datapath_id)
                q.text(","); q.breakable()
                q.text("n_buffers = ");
                q.text("%#x" % self.n_buffers)
                q.text(","); q.breakable()
                q.text("n_tables = ");
                q.text("%#x" % self.n_tables)
                q.text(","); q.breakable()
                q.text("capabilities = ");
                q.text("%#x" % self.capabilities)
                q.text(","); q.breakable()
                q.text("reserved = ");
                q.text("%#x" % self.reserved)
                q.text(","); q.breakable()
                q.text("ports = ");
                q.pp(self.ports)
            q.breakable()
        q.text('}')

class features_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FEATURES_REQUEST

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = features_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_FEATURES_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("features_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class flow_add(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_ADD

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        self.xid = xid
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!B", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!L", self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append("".join([x.pack() for x in self.instructions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_add()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_FLOW_MOD)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.cookie = reader.read('!Q')[0]
        obj.cookie_mask = reader.read('!Q')[0]
        obj.table_id = reader.read('!B')[0]
        __command = reader.read('!B')[0]
        assert(__command == const.OFPFC_ADD)
        obj.idle_timeout = reader.read('!H')[0]
        obj.hard_timeout = reader.read('!H')[0]
        obj.priority = reader.read('!H')[0]
        obj.buffer_id = reader.read('!L')[0]
        obj.out_port = reader.read('!L')[0]
        obj.out_group = reader.read('!L')[0]
        obj.flags = reader.read('!H')[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = instruction.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_add {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

class flow_delete(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_DELETE

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        self.xid = xid
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!B", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!L", self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append("".join([x.pack() for x in self.instructions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_delete()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_FLOW_MOD)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.cookie = reader.read('!Q')[0]
        obj.cookie_mask = reader.read('!Q')[0]
        obj.table_id = reader.read('!B')[0]
        __command = reader.read('!B')[0]
        assert(__command == const.OFPFC_DELETE)
        obj.idle_timeout = reader.read('!H')[0]
        obj.hard_timeout = reader.read('!H')[0]
        obj.priority = reader.read('!H')[0]
        obj.buffer_id = reader.read('!L')[0]
        obj.out_port = reader.read('!L')[0]
        obj.out_group = reader.read('!L')[0]
        obj.flags = reader.read('!H')[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = instruction.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_delete {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

class flow_delete_strict(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_DELETE_STRICT

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        self.xid = xid
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!B", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!L", self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append("".join([x.pack() for x in self.instructions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_delete_strict()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_FLOW_MOD)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.cookie = reader.read('!Q')[0]
        obj.cookie_mask = reader.read('!Q')[0]
        obj.table_id = reader.read('!B')[0]
        __command = reader.read('!B')[0]
        assert(__command == const.OFPFC_DELETE_STRICT)
        obj.idle_timeout = reader.read('!H')[0]
        obj.hard_timeout = reader.read('!H')[0]
        obj.priority = reader.read('!H')[0]
        obj.buffer_id = reader.read('!L')[0]
        obj.out_port = reader.read('!L')[0]
        obj.out_group = reader.read('!L')[0]
        obj.flags = reader.read('!H')[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = instruction.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_delete_strict {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

class flow_modify(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_MODIFY

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        self.xid = xid
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!B", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!L", self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append("".join([x.pack() for x in self.instructions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_modify()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_FLOW_MOD)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.cookie = reader.read('!Q')[0]
        obj.cookie_mask = reader.read('!Q')[0]
        obj.table_id = reader.read('!B')[0]
        __command = reader.read('!B')[0]
        assert(__command == const.OFPFC_MODIFY)
        obj.idle_timeout = reader.read('!H')[0]
        obj.hard_timeout = reader.read('!H')[0]
        obj.priority = reader.read('!H')[0]
        obj.buffer_id = reader.read('!L')[0]
        obj.out_port = reader.read('!L')[0]
        obj.out_group = reader.read('!L')[0]
        obj.flags = reader.read('!H')[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = instruction.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_modify {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

class flow_modify_strict(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_MOD
    _command = const.OFPFC_MODIFY_STRICT

    def __init__(self, xid=None, cookie=None, cookie_mask=None, table_id=None, idle_timeout=None, hard_timeout=None, priority=None, buffer_id=None, out_port=None, out_group=None, flags=None, match=None, instructions=None):
        self.xid = xid
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!B", self._command))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!L", self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 2)
        packed.append(self.match.pack())
        packed.append("".join([x.pack() for x in self.instructions]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_modify_strict()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_FLOW_MOD)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.cookie = reader.read('!Q')[0]
        obj.cookie_mask = reader.read('!Q')[0]
        obj.table_id = reader.read('!B')[0]
        __command = reader.read('!B')[0]
        assert(__command == const.OFPFC_MODIFY_STRICT)
        obj.idle_timeout = reader.read('!H')[0]
        obj.hard_timeout = reader.read('!H')[0]
        obj.priority = reader.read('!H')[0]
        obj.buffer_id = reader.read('!L')[0]
        obj.out_port = reader.read('!L')[0]
        obj.out_group = reader.read('!L')[0]
        obj.flags = reader.read('!H')[0]
        reader.skip(2)
        obj.match = common.match.unpack(reader)
        obj.instructions = instruction.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.table_id != other.table_id: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.priority != other.priority: return False
        if self.buffer_id != other.buffer_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.flags != other.flags: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_modify_strict {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

class flow_removed(Message):
    version = const.OFP_VERSION
    type = const.OFPT_FLOW_REMOVED

    def __init__(self, xid=None, cookie=None, priority=None, reason=None, table_id=None, duration_sec=None, duration_nsec=None, idle_timeout=None, hard_timeout=None, packet_count=None, byte_count=None, match=None):
        self.xid = xid
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!B", self.reason))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(self.match.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_removed()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_FLOW_REMOVED)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.cookie = reader.read('!Q')[0]
        obj.priority = reader.read('!H')[0]
        obj.reason = reader.read('!B')[0]
        obj.table_id = reader.read('!B')[0]
        obj.duration_sec = reader.read('!L')[0]
        obj.duration_nsec = reader.read('!L')[0]
        obj.idle_timeout = reader.read('!H')[0]
        obj.hard_timeout = reader.read('!H')[0]
        obj.packet_count = reader.read('!Q')[0]
        obj.byte_count = reader.read('!Q')[0]
        obj.match = common.match.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.cookie != other.cookie: return False
        if self.priority != other.priority: return False
        if self.reason != other.reason: return False
        if self.table_id != other.table_id: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.match != other.match: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_removed {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
            q.breakable()
        q.text('}')

class flow_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_FLOW

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_FLOW)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.entries = common.unpack_list_flow_stats_entry(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class flow_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_FLOW

    def __init__(self, xid=None, flags=None, table_id=None, out_port=None, out_group=None, cookie=None, cookie_mask=None, match=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if out_port != None:
            self.out_port = out_port
        else:
            self.out_port = 0
        if out_group != None:
            self.out_group = out_group
        else:
            self.out_group = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if cookie_mask != None:
            self.cookie_mask = cookie_mask
        else:
            self.cookie_mask = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.out_port))
        packed.append(struct.pack("!L", self.out_group))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.cookie_mask))
        packed.append(self.match.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = flow_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_FLOW)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.table_id = reader.read('!B')[0]
        reader.skip(3)
        obj.out_port = reader.read('!L')[0]
        obj.out_group = reader.read('!L')[0]
        reader.skip(4)
        obj.cookie = reader.read('!Q')[0]
        obj.cookie_mask = reader.read('!Q')[0]
        obj.match = common.match.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.table_id != other.table_id: return False
        if self.out_port != other.out_port: return False
        if self.out_group != other.out_group: return False
        if self.cookie != other.cookie: return False
        if self.cookie_mask != other.cookie_mask: return False
        if self.match != other.match: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("out_port = ");
                q.text(util.pretty_port(self.out_port))
                q.text(","); q.breakable()
                q.text("out_group = ");
                q.text("%#x" % self.out_group)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("cookie_mask = ");
                q.text("%#x" % self.cookie_mask)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
            q.breakable()
        q.text('}')

class get_config_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_GET_CONFIG_REPLY

    def __init__(self, xid=None, flags=None, miss_send_len=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if miss_send_len != None:
            self.miss_send_len = miss_send_len
        else:
            self.miss_send_len = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.miss_send_len))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = get_config_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_GET_CONFIG_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.flags = reader.read('!H')[0]
        obj.miss_send_len = reader.read('!H')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.miss_send_len != other.miss_send_len: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("get_config_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("miss_send_len = ");
                q.text("%#x" % self.miss_send_len)
            q.breakable()
        q.text('}')

class get_config_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_GET_CONFIG_REQUEST

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = get_config_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_GET_CONFIG_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("get_config_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class group_desc_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_GROUP_DESC

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = group_desc_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_GROUP_DESC)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.entries = common.unpack_list_group_desc_stats_entry(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_desc_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class group_desc_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_GROUP_DESC

    def __init__(self, xid=None, flags=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = group_desc_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_GROUP_DESC)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_desc_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

class group_features_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_GROUP_FEATURES

    def __init__(self, xid=None, flags=None, types=None, capabilities=None, max_groups_all=None, max_groups_select=None, max_groups_indirect=None, max_groups_ff=None, actions_all=None, actions_select=None, actions_indirect=None, actions_ff=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if types != None:
            self.types = types
        else:
            self.types = 0
        if capabilities != None:
            self.capabilities = capabilities
        else:
            self.capabilities = 0
        if max_groups_all != None:
            self.max_groups_all = max_groups_all
        else:
            self.max_groups_all = 0
        if max_groups_select != None:
            self.max_groups_select = max_groups_select
        else:
            self.max_groups_select = 0
        if max_groups_indirect != None:
            self.max_groups_indirect = max_groups_indirect
        else:
            self.max_groups_indirect = 0
        if max_groups_ff != None:
            self.max_groups_ff = max_groups_ff
        else:
            self.max_groups_ff = 0
        if actions_all != None:
            self.actions_all = actions_all
        else:
            self.actions_all = 0
        if actions_select != None:
            self.actions_select = actions_select
        else:
            self.actions_select = 0
        if actions_indirect != None:
            self.actions_indirect = actions_indirect
        else:
            self.actions_indirect = 0
        if actions_ff != None:
            self.actions_ff = actions_ff
        else:
            self.actions_ff = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.types))
        packed.append(struct.pack("!L", self.capabilities))
        packed.append(struct.pack("!L", self.max_groups_all))
        packed.append(struct.pack("!L", self.max_groups_select))
        packed.append(struct.pack("!L", self.max_groups_indirect))
        packed.append(struct.pack("!L", self.max_groups_ff))
        packed.append(struct.pack("!L", self.actions_all))
        packed.append(struct.pack("!L", self.actions_select))
        packed.append(struct.pack("!L", self.actions_indirect))
        packed.append(struct.pack("!L", self.actions_ff))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = group_features_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_GROUP_FEATURES)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.types = reader.read('!L')[0]
        obj.capabilities = reader.read('!L')[0]
        obj.max_groups_all = reader.read('!L')[0]
        obj.max_groups_select = reader.read('!L')[0]
        obj.max_groups_indirect = reader.read('!L')[0]
        obj.max_groups_ff = reader.read('!L')[0]
        obj.actions_all = reader.read('!L')[0]
        obj.actions_select = reader.read('!L')[0]
        obj.actions_indirect = reader.read('!L')[0]
        obj.actions_ff = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.types != other.types: return False
        if self.capabilities != other.capabilities: return False
        if self.max_groups_all != other.max_groups_all: return False
        if self.max_groups_select != other.max_groups_select: return False
        if self.max_groups_indirect != other.max_groups_indirect: return False
        if self.max_groups_ff != other.max_groups_ff: return False
        if self.actions_all != other.actions_all: return False
        if self.actions_select != other.actions_select: return False
        if self.actions_indirect != other.actions_indirect: return False
        if self.actions_ff != other.actions_ff: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_features_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("types = ");
                q.text("%#x" % self.types)
                q.text(","); q.breakable()
                q.text("capabilities = ");
                q.text("%#x" % self.capabilities)
                q.text(","); q.breakable()
                q.text("max_groups_all = ");
                q.text("%#x" % self.max_groups_all)
                q.text(","); q.breakable()
                q.text("max_groups_select = ");
                q.text("%#x" % self.max_groups_select)
                q.text(","); q.breakable()
                q.text("max_groups_indirect = ");
                q.text("%#x" % self.max_groups_indirect)
                q.text(","); q.breakable()
                q.text("max_groups_ff = ");
                q.text("%#x" % self.max_groups_ff)
                q.text(","); q.breakable()
                q.text("actions_all = ");
                q.text("%#x" % self.actions_all)
                q.text(","); q.breakable()
                q.text("actions_select = ");
                q.text("%#x" % self.actions_select)
                q.text(","); q.breakable()
                q.text("actions_indirect = ");
                q.text("%#x" % self.actions_indirect)
                q.text(","); q.breakable()
                q.text("actions_ff = ");
                q.text("%#x" % self.actions_ff)
            q.breakable()
        q.text('}')

class group_features_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_GROUP_FEATURES

    def __init__(self, xid=None, flags=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = group_features_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_GROUP_FEATURES)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_features_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')

class group_mod(Message):
    version = const.OFP_VERSION
    type = const.OFPT_GROUP_MOD

    def __init__(self, xid=None, command=None, group_type=None, group_id=None, buckets=None):
        self.xid = xid
        if command != None:
            self.command = command
        else:
            self.command = 0
        if group_type != None:
            self.group_type = group_type
        else:
            self.group_type = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if buckets != None:
            self.buckets = buckets
        else:
            self.buckets = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.command))
        packed.append(struct.pack("!B", self.group_type))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.group_id))
        packed.append("".join([x.pack() for x in self.buckets]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = group_mod()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_GROUP_MOD)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.command = reader.read('!H')[0]
        obj.group_type = reader.read('!B')[0]
        reader.skip(1)
        obj.group_id = reader.read('!L')[0]
        obj.buckets = common.unpack_list_bucket(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.command != other.command: return False
        if self.group_type != other.group_type: return False
        if self.group_id != other.group_id: return False
        if self.buckets != other.buckets: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("command = ");
                q.text("%#x" % self.command)
                q.text(","); q.breakable()
                q.text("group_type = ");
                q.text("%#x" % self.group_type)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("buckets = ");
                q.pp(self.buckets)
            q.breakable()
        q.text('}')

class group_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_GROUP

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = group_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_GROUP)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.entries = common.unpack_list_group_stats_entry(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class group_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_GROUP

    def __init__(self, xid=None, flags=None, group_id=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.group_id))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = group_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_GROUP)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.group_id = reader.read('!L')[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.group_id != other.group_id: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
            q.breakable()
        q.text('}')

class hello(Message):
    version = const.OFP_VERSION
    type = const.OFPT_HELLO

    def __init__(self, xid=None):
        self.xid = xid

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = hello()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_HELLO)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("hello {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
            q.breakable()
        q.text('}')

class packet_in(Message):
    version = const.OFP_VERSION
    type = const.OFPT_PACKET_IN

    def __init__(self, xid=None, buffer_id=None, total_len=None, reason=None, table_id=None, match=None, data=None):
        self.xid = xid
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if total_len != None:
            self.total_len = total_len
        else:
            self.total_len = 0
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!H", self.total_len))
        packed.append(struct.pack("!B", self.reason))
        packed.append(struct.pack("!B", self.table_id))
        packed.append(self.match.pack())
        packed.append('\x00' * 2)
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = packet_in()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_PACKET_IN)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.buffer_id = reader.read('!L')[0]
        obj.total_len = reader.read('!H')[0]
        obj.reason = reader.read('!B')[0]
        obj.table_id = reader.read('!B')[0]
        obj.match = common.match.unpack(reader)
        reader.skip(2)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.buffer_id != other.buffer_id: return False
        if self.total_len != other.total_len: return False
        if self.reason != other.reason: return False
        if self.table_id != other.table_id: return False
        if self.match != other.match: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("packet_in {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("total_len = ");
                q.text("%#x" % self.total_len)
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class packet_out(Message):
    version = const.OFP_VERSION
    type = const.OFPT_PACKET_OUT

    def __init__(self, xid=None, buffer_id=None, in_port=None, actions=None, data=None):
        self.xid = xid
        if buffer_id != None:
            self.buffer_id = buffer_id
        else:
            self.buffer_id = 0
        if in_port != None:
            self.in_port = in_port
        else:
            self.in_port = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.buffer_id))
        packed.append(struct.pack("!L", self.in_port))
        packed.append(struct.pack("!H", 0)) # placeholder for actions_len at index 6
        packed.append('\x00' * 6)
        packed.append("".join([x.pack() for x in self.actions]))
        packed[6] = struct.pack("!H", len(packed[-1]))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = packet_out()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_PACKET_OUT)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.buffer_id = reader.read('!L')[0]
        obj.in_port = reader.read('!L')[0]
        _actions_len = reader.read('!H')[0]
        reader.skip(6)
        obj.actions = action.unpack_list(reader.slice(_actions_len))
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.buffer_id != other.buffer_id: return False
        if self.in_port != other.in_port: return False
        if self.actions != other.actions: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("packet_out {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("buffer_id = ");
                q.text("%#x" % self.buffer_id)
                q.text(","); q.breakable()
                q.text("in_port = ");
                q.text(util.pretty_port(self.in_port))
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class port_mod(Message):
    version = const.OFP_VERSION
    type = const.OFPT_PORT_MOD

    def __init__(self, xid=None, port_no=None, hw_addr=None, config=None, mask=None, advertise=None):
        self.xid = xid
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if config != None:
            self.config = config
        else:
            self.config = 0
        if mask != None:
            self.mask = mask
        else:
            self.mask = 0
        if advertise != None:
            self.advertise = advertise
        else:
            self.advertise = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.port_no))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.mask))
        packed.append(struct.pack("!L", self.advertise))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_mod()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_PORT_MOD)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.port_no = reader.read('!L')[0]
        reader.skip(4)
        obj.hw_addr = list(reader.read('!6B'))
        reader.skip(2)
        obj.config = reader.read('!L')[0]
        obj.mask = reader.read('!L')[0]
        obj.advertise = reader.read('!L')[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.port_no != other.port_no: return False
        if self.hw_addr != other.hw_addr: return False
        if self.config != other.config: return False
        if self.mask != other.mask: return False
        if self.advertise != other.advertise: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("mask = ");
                q.text("%#x" % self.mask)
                q.text(","); q.breakable()
                q.text("advertise = ");
                q.text("%#x" % self.advertise)
            q.breakable()
        q.text('}')

class port_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_PORT

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_PORT)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.entries = loxi.generic_util.unpack_list(reader, common.port_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class port_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_PORT

    def __init__(self, xid=None, flags=None, port_no=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.port_no))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_PORT)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.port_no = reader.read('!L')[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
            q.breakable()
        q.text('}')

class port_status(Message):
    version = const.OFP_VERSION
    type = const.OFPT_PORT_STATUS

    def __init__(self, xid=None, reason=None, desc=None):
        self.xid = xid
        if reason != None:
            self.reason = reason
        else:
            self.reason = 0
        if desc != None:
            self.desc = desc
        else:
            self.desc = common.port_desc()

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!B", self.reason))
        packed.append('\x00' * 7)
        packed.append(self.desc.pack())
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = port_status()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_PORT_STATUS)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.reason = reader.read('!B')[0]
        reader.skip(7)
        obj.desc = common.port_desc.unpack(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.reason != other.reason: return False
        if self.desc != other.desc: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_status {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("reason = ");
                q.text("%#x" % self.reason)
                q.text(","); q.breakable()
                q.text("desc = ");
                q.pp(self.desc)
            q.breakable()
        q.text('}')

class queue_get_config_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_QUEUE_GET_CONFIG_REPLY

    def __init__(self, xid=None, port=None, queues=None):
        self.xid = xid
        if port != None:
            self.port = port
        else:
            self.port = 0
        if queues != None:
            self.queues = queues
        else:
            self.queues = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.port))
        packed.append('\x00' * 4)
        packed.append("".join([x.pack() for x in self.queues]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_get_config_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_QUEUE_GET_CONFIG_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.port = reader.read('!L')[0]
        reader.skip(4)
        obj.queues = common.unpack_list_packet_queue(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.port != other.port: return False
        if self.queues != other.queues: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_get_config_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
                q.text(","); q.breakable()
                q.text("queues = ");
                q.pp(self.queues)
            q.breakable()
        q.text('}')

class queue_get_config_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_QUEUE_GET_CONFIG_REQUEST

    def __init__(self, xid=None, port=None):
        self.xid = xid
        if port != None:
            self.port = port
        else:
            self.port = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.port))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_get_config_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_QUEUE_GET_CONFIG_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.port = reader.read('!L')[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.port != other.port: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_get_config_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
            q.breakable()
        q.text('}')

class queue_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_QUEUE

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_QUEUE)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.entries = loxi.generic_util.unpack_list(reader, common.queue_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class queue_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_QUEUE

    def __init__(self, xid=None, flags=None, port_no=None, queue_id=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.port_no))
        packed.append(struct.pack("!L", self.queue_id))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = queue_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_QUEUE)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.port_no = reader.read('!L')[0]
        obj.queue_id = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.port_no != other.port_no: return False
        if self.queue_id != other.queue_id: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
            q.breakable()
        q.text('}')

class role_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_ROLE_REPLY

    def __init__(self, xid=None, data=None):
        self.xid = xid
        if data != None:
            self.data = data
        else:
            self.data = ""

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = role_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_ROLE_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("role_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class role_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_ROLE_REQUEST

    def __init__(self, xid=None, role=None, generation_id=None):
        self.xid = xid
        if role != None:
            self.role = role
        else:
            self.role = 0
        if generation_id != None:
            self.generation_id = generation_id
        else:
            self.generation_id = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!L", self.role))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.generation_id))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = role_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_ROLE_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.role = reader.read('!L')[0]
        reader.skip(4)
        obj.generation_id = reader.read('!Q')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.role != other.role: return False
        if self.generation_id != other.generation_id: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("role_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("role = ");
                q.text("%#x" % self.role)
                q.text(","); q.breakable()
                q.text("generation_id = ");
                q.text("%#x" % self.generation_id)
            q.breakable()
        q.text('}')

class set_config(Message):
    version = const.OFP_VERSION
    type = const.OFPT_SET_CONFIG

    def __init__(self, xid=None, flags=None, miss_send_len=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if miss_send_len != None:
            self.miss_send_len = miss_send_len
        else:
            self.miss_send_len = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.flags))
        packed.append(struct.pack("!H", self.miss_send_len))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = set_config()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_SET_CONFIG)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.flags = reader.read('!H')[0]
        obj.miss_send_len = reader.read('!H')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.miss_send_len != other.miss_send_len: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("set_config {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("miss_send_len = ");
                q.text("%#x" % self.miss_send_len)
            q.breakable()
        q.text('}')

class table_mod(Message):
    version = const.OFP_VERSION
    type = const.OFPT_TABLE_MOD

    def __init__(self, xid=None, table_id=None, config=None):
        self.xid = xid
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if config != None:
            self.config = config
        else:
            self.config = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 3)
        packed.append(struct.pack("!L", self.config))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = table_mod()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_TABLE_MOD)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        obj.table_id = reader.read('!B')[0]
        reader.skip(3)
        obj.config = reader.read('!L')[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.table_id != other.table_id: return False
        if self.config != other.config: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_mod {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
            q.breakable()
        q.text('}')

class table_stats_reply(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REPLY
    stats_type = const.OFPST_TABLE

    def __init__(self, xid=None, flags=None, entries=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0
        if entries != None:
            self.entries = entries
        else:
            self.entries = []

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        packed.append("".join([x.pack() for x in self.entries]))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = table_stats_reply()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REPLY)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_TABLE)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        obj.entries = loxi.generic_util.unpack_list(reader, common.table_stats_entry.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        if self.entries != other.entries: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_stats_reply {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
                q.text(","); q.breakable()
                q.text("entries = ");
                q.pp(self.entries)
            q.breakable()
        q.text('}')

class table_stats_request(Message):
    version = const.OFP_VERSION
    type = const.OFPT_STATS_REQUEST
    stats_type = const.OFPST_TABLE

    def __init__(self, xid=None, flags=None):
        self.xid = xid
        if flags != None:
            self.flags = flags
        else:
            self.flags = 0

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.version))
        packed.append(struct.pack("!B", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 2
        packed.append(struct.pack("!L", self.xid))
        packed.append(struct.pack("!H", self.stats_type))
        packed.append(struct.pack("!H", self.flags))
        packed.append('\x00' * 4)
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        if len(buf) < 8: raise loxi.ProtocolError("buffer too short to contain an OpenFlow message")
        obj = table_stats_request()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _version = reader.read('!B')[0]
        assert(_version == const.OFP_VERSION)
        _type = reader.read('!B')[0]
        assert(_type == const.OFPT_STATS_REQUEST)
        _length = reader.read('!H')[0]
        obj.xid = reader.read('!L')[0]
        _stats_type = reader.read('!H')[0]
        assert(_stats_type == const.OFPST_TABLE)
        obj.flags = reader.read('!H')[0]
        reader.skip(4)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.version != other.version: return False
        if self.type != other.type: return False
        if self.xid != other.xid: return False
        if self.flags != other.flags: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def __str__(self):
        return self.show()

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_stats_request {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("xid = ");
                if self.xid != None:
                    q.text("%#x" % self.xid)
                else:
                    q.text('None')
                q.text(","); q.breakable()
                q.text("flags = ");
                q.text("%#x" % self.flags)
            q.breakable()
        q.text('}')


def parse_header(buf):
    if len(buf) < 8:
        raise loxi.ProtocolError("too short to be an OpenFlow message")
    return struct.unpack_from("!BBHL", buf)

def parse_message(buf):
    msg_ver, msg_type, msg_len, msg_xid = parse_header(buf)
    if msg_ver != const.OFP_VERSION and msg_type != ofp.OFPT_HELLO:
        raise loxi.ProtocolError("wrong OpenFlow version")
    if len(buf) != msg_len:
        raise loxi.ProtocolError("incorrect message size")
    if msg_type in parsers:
        return parsers[msg_type](buf)
    else:
        raise loxi.ProtocolError("unexpected message type")

def parse_flow_mod(buf):
    if len(buf) < 56 + 2:
        raise loxi.ProtocolError("message too short")
    cmd, = struct.unpack_from("!H", buf, 56)
    if cmd in flow_mod_parsers:
        return flow_mod_parsers[cmd](buf)
    else:
        raise loxi.ProtocolError("unexpected flow mod cmd %u" % cmd)

def parse_stats_reply(buf):
    if len(buf) < 8 + 2:
        raise loxi.ProtocolError("message too short")
    stats_type, = struct.unpack_from("!H", buf, 8)
    if stats_type in stats_reply_parsers:
        return stats_reply_parsers[stats_type](buf)
    else:
        raise loxi.ProtocolError("unexpected stats type %u" % stats_type)

def parse_stats_request(buf):
    if len(buf) < 8 + 2:
        raise loxi.ProtocolError("message too short")
    stats_type, = struct.unpack_from("!H", buf, 8)
    if stats_type in stats_request_parsers:
        return stats_request_parsers[stats_type](buf)
    else:
        raise loxi.ProtocolError("unexpected stats type %u" % stats_type)

def parse_experimenter(buf):
    if len(buf) < 16:
        raise loxi.ProtocolError("experimenter message too short")

    experimenter, = struct.unpack_from("!L", buf, 8)
    if experimenter == 0x005c16c7: # Big Switch Networks
        subtype, = struct.unpack_from("!L", buf, 12)
    elif experimenter == 0x00002320: # Nicira
        subtype, = struct.unpack_from("!L", buf, 12)
    else:
        raise loxi.ProtocolError("unexpected experimenter id %#x" % experimenter)

    if subtype in experimenter_parsers[experimenter]:
        return experimenter_parsers[experimenter][subtype](buf)
    else:
        raise loxi.ProtocolError("unexpected experimenter %#x subtype %#x" % (experimenter, subtype))

parsers = {
    const.OFPT_BARRIER_REPLY : barrier_reply.unpack,
    const.OFPT_BARRIER_REQUEST : barrier_request.unpack,
    const.OFPT_ECHO_REPLY : echo_reply.unpack,
    const.OFPT_ECHO_REQUEST : echo_request.unpack,
    const.OFPT_ERROR : error_msg.unpack,
    const.OFPT_EXPERIMENTER : parse_experimenter,
    const.OFPT_FEATURES_REPLY : features_reply.unpack,
    const.OFPT_FEATURES_REQUEST : features_request.unpack,
    const.OFPT_FLOW_MOD : parse_flow_mod,
    const.OFPT_FLOW_REMOVED : flow_removed.unpack,
    const.OFPT_GET_CONFIG_REPLY : get_config_reply.unpack,
    const.OFPT_GET_CONFIG_REQUEST : get_config_request.unpack,
    const.OFPT_GROUP_MOD : group_mod.unpack,
    const.OFPT_HELLO : hello.unpack,
    const.OFPT_PACKET_IN : packet_in.unpack,
    const.OFPT_PACKET_OUT : packet_out.unpack,
    const.OFPT_PORT_MOD : port_mod.unpack,
    const.OFPT_PORT_STATUS : port_status.unpack,
    const.OFPT_QUEUE_GET_CONFIG_REPLY : queue_get_config_reply.unpack,
    const.OFPT_QUEUE_GET_CONFIG_REQUEST : queue_get_config_request.unpack,
    const.OFPT_ROLE_REPLY : role_reply.unpack,
    const.OFPT_ROLE_REQUEST : role_request.unpack,
    const.OFPT_SET_CONFIG : set_config.unpack,
    const.OFPT_STATS_REPLY : parse_stats_reply,
    const.OFPT_STATS_REQUEST : parse_stats_request,
    const.OFPT_TABLE_MOD : table_mod.unpack,
}

flow_mod_parsers = {
    const.OFPFC_ADD : flow_add.unpack,
    const.OFPFC_MODIFY : flow_modify.unpack,
    const.OFPFC_MODIFY_STRICT : flow_modify_strict.unpack,
    const.OFPFC_DELETE : flow_delete.unpack,
    const.OFPFC_DELETE_STRICT : flow_delete_strict.unpack,
}

stats_reply_parsers = {
    const.OFPST_DESC : desc_stats_reply.unpack,
    const.OFPST_FLOW : flow_stats_reply.unpack,
    const.OFPST_AGGREGATE : aggregate_stats_reply.unpack,
    const.OFPST_TABLE : table_stats_reply.unpack,
    const.OFPST_PORT : port_stats_reply.unpack,
    const.OFPST_QUEUE : queue_stats_reply.unpack,
    const.OFPST_EXPERIMENTER : experimenter_stats_reply.unpack,
}

stats_request_parsers = {
    const.OFPST_DESC : desc_stats_request.unpack,
    const.OFPST_FLOW : flow_stats_request.unpack,
    const.OFPST_AGGREGATE : aggregate_stats_request.unpack,
    const.OFPST_TABLE : table_stats_request.unpack,
    const.OFPST_PORT : port_stats_request.unpack,
    const.OFPST_QUEUE : queue_stats_request.unpack,
    const.OFPST_EXPERIMENTER : experimenter_stats_request.unpack,
}

experimenter_parsers = {
}
