# Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
# Copyright (c) 2011, 2012 Open Networking Foundation
# Copyright (c) 2012, 2013 Big Switch Networks, Inc.
# See the file LICENSE.pyloxi which should have been included in the source distribution

# Automatically generated by LOXI from template common.py
# Do not modify

import sys
import struct
import action
import instruction # for unpack_list
import const
import util
import loxi.generic_util

import oxm

# HACK make this module visible as 'common' to simplify code generation
common = sys.modules[__name__]

def unpack_list_flow_stats_entry(reader):
    return loxi.generic_util.unpack_list_lv16(reader, flow_stats_entry.unpack)

def unpack_list_queue_prop(reader):
    def deserializer(reader, typ):
        if typ == const.OFPQT_MIN_RATE:
            return queue_prop_min_rate.unpack(reader)
        else:
            raise loxi.ProtocolError("unknown queue prop %d" % typ)
    return loxi.generic_util.unpack_list_tlv16(reader, deserializer)

def unpack_list_packet_queue(reader):
    def wrapper(reader):
        length, = reader.peek('!4xH')
        return packet_queue.unpack(reader.slice(length))
    return loxi.generic_util.unpack_list(reader, wrapper)

def unpack_list_hello_elem(reader):
    def deserializer(reader, typ):
        if typ == const.OFPHET_VERSIONBITMAP:
            return hello_elem_versionbitmap.unpack(reader)
        else:
            return None
    return [x for x in loxi.generic_util.unpack_list_tlv16(reader, deserializer) if x != None]

def unpack_list_bucket(reader):
    return loxi.generic_util.unpack_list_lv16(reader, bucket.unpack)

def unpack_list_group_desc_stats_entry(reader):
    return loxi.generic_util.unpack_list_lv16(reader, group_desc_stats_entry.unpack)

def unpack_list_group_stats_entry(reader):
    return loxi.generic_util.unpack_list_lv16(reader, group_stats_entry.unpack)

def unpack_list_meter_stats(reader):
    def wrapper(reader):
        length, = reader.peek('!4xH')
        return meter_stats.unpack(reader.slice(length))
    return loxi.generic_util.unpack_list(reader, wrapper)

class bsn_interface(object):

    def __init__(self, hw_addr=None, name=None, ipv4_addr=None, ipv4_netmask=None):
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if ipv4_addr != None:
            self.ipv4_addr = ipv4_addr
        else:
            self.ipv4_addr = 0
        if ipv4_netmask != None:
            self.ipv4_netmask = ipv4_netmask
        else:
            self.ipv4_netmask = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.ipv4_addr))
        packed.append(struct.pack("!L", self.ipv4_netmask))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = bsn_interface()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.hw_addr = list(reader.read('!6B'))
        reader.skip(2)
        obj.name = reader.read("!16s")[0].rstrip("\x00")
        obj.ipv4_addr = reader.read("!L")[0]
        obj.ipv4_netmask = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.hw_addr != other.hw_addr: return False
        if self.name != other.name: return False
        if self.ipv4_addr != other.ipv4_addr: return False
        if self.ipv4_netmask != other.ipv4_netmask: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_interface {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("ipv4_addr = ");
                q.text(util.pretty_ipv4(self.ipv4_addr))
                q.text(","); q.breakable()
                q.text("ipv4_netmask = ");
                q.text(util.pretty_ipv4(self.ipv4_netmask))
            q.breakable()
        q.text('}')

class bsn_vport_q_in_q(object):
    type = 0

    def __init__(self, port_no=None, ingress_tpid=None, ingress_vlan_id=None, egress_tpid=None, egress_vlan_id=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if ingress_tpid != None:
            self.ingress_tpid = ingress_tpid
        else:
            self.ingress_tpid = 0
        if ingress_vlan_id != None:
            self.ingress_vlan_id = ingress_vlan_id
        else:
            self.ingress_vlan_id = 0
        if egress_tpid != None:
            self.egress_tpid = egress_tpid
        else:
            self.egress_tpid = 0
        if egress_vlan_id != None:
            self.egress_vlan_id = egress_vlan_id
        else:
            self.egress_vlan_id = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(struct.pack("!L", self.port_no))
        packed.append(struct.pack("!H", self.ingress_tpid))
        packed.append(struct.pack("!H", self.ingress_vlan_id))
        packed.append(struct.pack("!H", self.egress_tpid))
        packed.append(struct.pack("!H", self.egress_vlan_id))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = bsn_vport_q_in_q()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type = reader.read("!H")[0]
        assert(_type == 0)
        _length = reader.read("!H")[0]
        obj.port_no = reader.read("!L")[0]
        obj.ingress_tpid = reader.read("!H")[0]
        obj.ingress_vlan_id = reader.read("!H")[0]
        obj.egress_tpid = reader.read("!H")[0]
        obj.egress_vlan_id = reader.read("!H")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.ingress_tpid != other.ingress_tpid: return False
        if self.ingress_vlan_id != other.ingress_vlan_id: return False
        if self.egress_tpid != other.egress_tpid: return False
        if self.egress_vlan_id != other.egress_vlan_id: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bsn_vport_q_in_q {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text("%#x" % self.port_no)
                q.text(","); q.breakable()
                q.text("ingress_tpid = ");
                q.text("%#x" % self.ingress_tpid)
                q.text(","); q.breakable()
                q.text("ingress_vlan_id = ");
                q.text("%#x" % self.ingress_vlan_id)
                q.text(","); q.breakable()
                q.text("egress_tpid = ");
                q.text("%#x" % self.egress_tpid)
                q.text(","); q.breakable()
                q.text("egress_vlan_id = ");
                q.text("%#x" % self.egress_vlan_id)
            q.breakable()
        q.text('}')

class bucket(object):

    def __init__(self, weight=None, watch_port=None, watch_group=None, actions=None):
        if weight != None:
            self.weight = weight
        else:
            self.weight = 0
        if watch_port != None:
            self.watch_port = watch_port
        else:
            self.watch_port = 0
        if watch_group != None:
            self.watch_group = watch_group
        else:
            self.watch_group = 0
        if actions != None:
            self.actions = actions
        else:
            self.actions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 0
        packed.append(struct.pack("!H", self.weight))
        packed.append(util.pack_port_no(self.watch_port))
        packed.append(struct.pack("!L", self.watch_group))
        packed.append('\x00' * 4)
        packed.append(util.pack_list(self.actions))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = bucket()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _len = reader.read("!H")[0]
        obj.weight = reader.read("!H")[0]
        obj.watch_port = util.unpack_port_no(reader)
        obj.watch_group = reader.read("!L")[0]
        reader.skip(4)
        obj.actions = action.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.weight != other.weight: return False
        if self.watch_port != other.watch_port: return False
        if self.watch_group != other.watch_group: return False
        if self.actions != other.actions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bucket {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("weight = ");
                q.text("%#x" % self.weight)
                q.text(","); q.breakable()
                q.text("watch_port = ");
                q.text(util.pretty_port(self.watch_port))
                q.text(","); q.breakable()
                q.text("watch_group = ");
                q.text("%#x" % self.watch_group)
                q.text(","); q.breakable()
                q.text("actions = ");
                q.pp(self.actions)
            q.breakable()
        q.text('}')

class bucket_counter(object):

    def __init__(self, packet_count=None, byte_count=None):
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = bucket_counter()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("bucket_counter {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
            q.breakable()
        q.text('}')

class flow_stats_entry(object):

    def __init__(self, table_id=None, duration_sec=None, duration_nsec=None, priority=None, idle_timeout=None, hard_timeout=None, cookie=None, packet_count=None, byte_count=None, match=None, instructions=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if duration_sec != None:
            self.duration_sec = duration_sec
        else:
            self.duration_sec = 0
        if duration_nsec != None:
            self.duration_nsec = duration_nsec
        else:
            self.duration_nsec = 0
        if priority != None:
            self.priority = priority
        else:
            self.priority = 0
        if idle_timeout != None:
            self.idle_timeout = idle_timeout
        else:
            self.idle_timeout = 0
        if hard_timeout != None:
            self.hard_timeout = hard_timeout
        else:
            self.hard_timeout = 0
        if cookie != None:
            self.cookie = cookie
        else:
            self.cookie = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if match != None:
            self.match = match
        else:
            self.match = common.match()
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.duration_sec))
        packed.append(struct.pack("!L", self.duration_nsec))
        packed.append(struct.pack("!H", self.priority))
        packed.append(struct.pack("!H", self.idle_timeout))
        packed.append(struct.pack("!H", self.hard_timeout))
        packed.append('\x00' * 6)
        packed.append(struct.pack("!Q", self.cookie))
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(self.match.pack())
        packed.append(util.pack_list(self.instructions))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = flow_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _length = reader.read("!H")[0]
        obj.table_id = reader.read("!B")[0]
        reader.skip(1)
        obj.duration_sec = reader.read("!L")[0]
        obj.duration_nsec = reader.read("!L")[0]
        obj.priority = reader.read("!H")[0]
        obj.idle_timeout = reader.read("!H")[0]
        obj.hard_timeout = reader.read("!H")[0]
        reader.skip(6)
        obj.cookie = reader.read("!Q")[0]
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        obj.match = common.match.unpack(reader)
        obj.instructions = instruction.unpack_list(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.duration_sec != other.duration_sec: return False
        if self.duration_nsec != other.duration_nsec: return False
        if self.priority != other.priority: return False
        if self.idle_timeout != other.idle_timeout: return False
        if self.hard_timeout != other.hard_timeout: return False
        if self.cookie != other.cookie: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.match != other.match: return False
        if self.instructions != other.instructions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("flow_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("duration_sec = ");
                q.text("%#x" % self.duration_sec)
                q.text(","); q.breakable()
                q.text("duration_nsec = ");
                q.text("%#x" % self.duration_nsec)
                q.text(","); q.breakable()
                q.text("priority = ");
                q.text("%#x" % self.priority)
                q.text(","); q.breakable()
                q.text("idle_timeout = ");
                q.text("%#x" % self.idle_timeout)
                q.text(","); q.breakable()
                q.text("hard_timeout = ");
                q.text("%#x" % self.hard_timeout)
                q.text(","); q.breakable()
                q.text("cookie = ");
                q.text("%#x" % self.cookie)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.pp(self.instructions)
            q.breakable()
        q.text('}')

class group_desc_stats_entry(object):

    def __init__(self, type=None, group_id=None, buckets=None):
        if type != None:
            self.type = type
        else:
            self.type = 0
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if buckets != None:
            self.buckets = buckets
        else:
            self.buckets = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append(struct.pack("!B", self.type))
        packed.append('\x00' * 1)
        packed.append(struct.pack("!L", self.group_id))
        packed.append(util.pack_list(self.buckets))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = group_desc_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _length = reader.read("!H")[0]
        obj.type = reader.read("!B")[0]
        reader.skip(1)
        obj.group_id = reader.read("!L")[0]
        obj.buckets = common.unpack_list_bucket(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.type != other.type: return False
        if self.group_id != other.group_id: return False
        if self.buckets != other.buckets: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_desc_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("type = ");
                q.text("%#x" % self.type)
                q.text(","); q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("buckets = ");
                q.pp(self.buckets)
            q.breakable()
        q.text('}')

class group_stats_entry(object):

    def __init__(self, group_id=None, ref_count=None, packet_count=None, byte_count=None, bucket_stats=None):
        if group_id != None:
            self.group_id = group_id
        else:
            self.group_id = 0
        if ref_count != None:
            self.ref_count = ref_count
        else:
            self.ref_count = 0
        if packet_count != None:
            self.packet_count = packet_count
        else:
            self.packet_count = 0
        if byte_count != None:
            self.byte_count = byte_count
        else:
            self.byte_count = 0
        if bucket_stats != None:
            self.bucket_stats = bucket_stats
        else:
            self.bucket_stats = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 0
        packed.append('\x00' * 2)
        packed.append(struct.pack("!L", self.group_id))
        packed.append(struct.pack("!L", self.ref_count))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.packet_count))
        packed.append(struct.pack("!Q", self.byte_count))
        packed.append(util.pack_list(self.bucket_stats))
        length = sum([len(x) for x in packed])
        packed[0] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = group_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _length = reader.read("!H")[0]
        reader.skip(2)
        obj.group_id = reader.read("!L")[0]
        obj.ref_count = reader.read("!L")[0]
        reader.skip(4)
        obj.packet_count = reader.read("!Q")[0]
        obj.byte_count = reader.read("!Q")[0]
        obj.bucket_stats = loxi.generic_util.unpack_list(reader, common.bucket_counter.unpack)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.group_id != other.group_id: return False
        if self.ref_count != other.ref_count: return False
        if self.packet_count != other.packet_count: return False
        if self.byte_count != other.byte_count: return False
        if self.bucket_stats != other.bucket_stats: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("group_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("group_id = ");
                q.text("%#x" % self.group_id)
                q.text(","); q.breakable()
                q.text("ref_count = ");
                q.text("%#x" % self.ref_count)
                q.text(","); q.breakable()
                q.text("packet_count = ");
                q.text("%#x" % self.packet_count)
                q.text(","); q.breakable()
                q.text("byte_count = ");
                q.text("%#x" % self.byte_count)
                q.text(","); q.breakable()
                q.text("bucket_stats = ");
                q.pp(self.bucket_stats)
            q.breakable()
        q.text('}')

class match_v3(object):
    type = 1

    def __init__(self, oxm_list=None):
        if oxm_list != None:
            self.oxm_list = oxm_list
        else:
            self.oxm_list = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for length at index 1
        packed.append(util.pack_list(self.oxm_list))
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        packed.append('\x00' * ((length + 7)/8*8 - length))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = match_v3()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _length = reader.read("!H")[0]
        obj.oxm_list = oxm.unpack_list(reader.slice(_length-4))
        reader.skip((_length + 7)/8*8 - _length)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.oxm_list != other.oxm_list: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("match_v3 {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("oxm_list = ");
                q.pp(self.oxm_list)
            q.breakable()
        q.text('}')

class packet_queue(object):

    def __init__(self, queue_id=None, port=None, properties=None):
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if port != None:
            self.port = port
        else:
            self.port = 0
        if properties != None:
            self.properties = properties
        else:
            self.properties = []
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(util.pack_port_no(self.port))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 2
        packed.append('\x00' * 6)
        packed.append(util.pack_list(self.properties))
        length = sum([len(x) for x in packed])
        packed[2] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = packet_queue()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.queue_id = reader.read("!L")[0]
        obj.port = util.unpack_port_no(reader)
        _len = reader.read("!H")[0]
        reader.skip(6)
        obj.properties = common.unpack_list_queue_prop(reader)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.queue_id != other.queue_id: return False
        if self.port != other.port: return False
        if self.properties != other.properties: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("packet_queue {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("port = ");
                q.text(util.pretty_port(self.port))
                q.text(","); q.breakable()
                q.text("properties = ");
                q.pp(self.properties)
            q.breakable()
        q.text('}')

class port_desc(object):

    def __init__(self, port_no=None, hw_addr=None, name=None, config=None, state=None, curr=None, advertised=None, supported=None, peer=None, curr_speed=None, max_speed=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if hw_addr != None:
            self.hw_addr = hw_addr
        else:
            self.hw_addr = [0,0,0,0,0,0]
        if name != None:
            self.name = name
        else:
            self.name = ""
        if config != None:
            self.config = config
        else:
            self.config = 0
        if state != None:
            self.state = state
        else:
            self.state = 0
        if curr != None:
            self.curr = curr
        else:
            self.curr = 0
        if advertised != None:
            self.advertised = advertised
        else:
            self.advertised = 0
        if supported != None:
            self.supported = supported
        else:
            self.supported = 0
        if peer != None:
            self.peer = peer
        else:
            self.peer = 0
        if curr_speed != None:
            self.curr_speed = curr_speed
        else:
            self.curr_speed = 0
        if max_speed != None:
            self.max_speed = max_speed
        else:
            self.max_speed = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!6B", *self.hw_addr))
        packed.append('\x00' * 2)
        packed.append(struct.pack("!16s", self.name))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.state))
        packed.append(struct.pack("!L", self.curr))
        packed.append(struct.pack("!L", self.advertised))
        packed.append(struct.pack("!L", self.supported))
        packed.append(struct.pack("!L", self.peer))
        packed.append(struct.pack("!L", self.curr_speed))
        packed.append(struct.pack("!L", self.max_speed))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = port_desc()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(4)
        obj.hw_addr = list(reader.read('!6B'))
        reader.skip(2)
        obj.name = reader.read("!16s")[0].rstrip("\x00")
        obj.config = reader.read("!L")[0]
        obj.state = reader.read("!L")[0]
        obj.curr = reader.read("!L")[0]
        obj.advertised = reader.read("!L")[0]
        obj.supported = reader.read("!L")[0]
        obj.peer = reader.read("!L")[0]
        obj.curr_speed = reader.read("!L")[0]
        obj.max_speed = reader.read("!L")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.hw_addr != other.hw_addr: return False
        if self.name != other.name: return False
        if self.config != other.config: return False
        if self.state != other.state: return False
        if self.curr != other.curr: return False
        if self.advertised != other.advertised: return False
        if self.supported != other.supported: return False
        if self.peer != other.peer: return False
        if self.curr_speed != other.curr_speed: return False
        if self.max_speed != other.max_speed: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_desc {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("hw_addr = ");
                q.text(util.pretty_mac(self.hw_addr))
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("state = ");
                q.text("%#x" % self.state)
                q.text(","); q.breakable()
                q.text("curr = ");
                q.text("%#x" % self.curr)
                q.text(","); q.breakable()
                q.text("advertised = ");
                q.text("%#x" % self.advertised)
                q.text(","); q.breakable()
                q.text("supported = ");
                q.text("%#x" % self.supported)
                q.text(","); q.breakable()
                q.text("peer = ");
                q.text("%#x" % self.peer)
                q.text(","); q.breakable()
                q.text("curr_speed = ");
                q.text("%#x" % self.curr_speed)
                q.text(","); q.breakable()
                q.text("max_speed = ");
                q.text("%#x" % self.max_speed)
            q.breakable()
        q.text('}')

class port_stats_entry(object):

    def __init__(self, port_no=None, rx_packets=None, tx_packets=None, rx_bytes=None, tx_bytes=None, rx_dropped=None, tx_dropped=None, rx_errors=None, tx_errors=None, rx_frame_err=None, rx_over_err=None, rx_crc_err=None, collisions=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if rx_packets != None:
            self.rx_packets = rx_packets
        else:
            self.rx_packets = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if rx_bytes != None:
            self.rx_bytes = rx_bytes
        else:
            self.rx_bytes = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if rx_dropped != None:
            self.rx_dropped = rx_dropped
        else:
            self.rx_dropped = 0
        if tx_dropped != None:
            self.tx_dropped = tx_dropped
        else:
            self.tx_dropped = 0
        if rx_errors != None:
            self.rx_errors = rx_errors
        else:
            self.rx_errors = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0
        if rx_frame_err != None:
            self.rx_frame_err = rx_frame_err
        else:
            self.rx_frame_err = 0
        if rx_over_err != None:
            self.rx_over_err = rx_over_err
        else:
            self.rx_over_err = 0
        if rx_crc_err != None:
            self.rx_crc_err = rx_crc_err
        else:
            self.rx_crc_err = 0
        if collisions != None:
            self.collisions = collisions
        else:
            self.collisions = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append('\x00' * 4)
        packed.append(struct.pack("!Q", self.rx_packets))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.rx_bytes))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.rx_dropped))
        packed.append(struct.pack("!Q", self.tx_dropped))
        packed.append(struct.pack("!Q", self.rx_errors))
        packed.append(struct.pack("!Q", self.tx_errors))
        packed.append(struct.pack("!Q", self.rx_frame_err))
        packed.append(struct.pack("!Q", self.rx_over_err))
        packed.append(struct.pack("!Q", self.rx_crc_err))
        packed.append(struct.pack("!Q", self.collisions))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = port_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.port_no = util.unpack_port_no(reader)
        reader.skip(4)
        obj.rx_packets = reader.read("!Q")[0]
        obj.tx_packets = reader.read("!Q")[0]
        obj.rx_bytes = reader.read("!Q")[0]
        obj.tx_bytes = reader.read("!Q")[0]
        obj.rx_dropped = reader.read("!Q")[0]
        obj.tx_dropped = reader.read("!Q")[0]
        obj.rx_errors = reader.read("!Q")[0]
        obj.tx_errors = reader.read("!Q")[0]
        obj.rx_frame_err = reader.read("!Q")[0]
        obj.rx_over_err = reader.read("!Q")[0]
        obj.rx_crc_err = reader.read("!Q")[0]
        obj.collisions = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.rx_packets != other.rx_packets: return False
        if self.tx_packets != other.tx_packets: return False
        if self.rx_bytes != other.rx_bytes: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.rx_dropped != other.rx_dropped: return False
        if self.tx_dropped != other.tx_dropped: return False
        if self.rx_errors != other.rx_errors: return False
        if self.tx_errors != other.tx_errors: return False
        if self.rx_frame_err != other.rx_frame_err: return False
        if self.rx_over_err != other.rx_over_err: return False
        if self.rx_crc_err != other.rx_crc_err: return False
        if self.collisions != other.collisions: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("port_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("rx_packets = ");
                q.text("%#x" % self.rx_packets)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("rx_bytes = ");
                q.text("%#x" % self.rx_bytes)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("rx_dropped = ");
                q.text("%#x" % self.rx_dropped)
                q.text(","); q.breakable()
                q.text("tx_dropped = ");
                q.text("%#x" % self.tx_dropped)
                q.text(","); q.breakable()
                q.text("rx_errors = ");
                q.text("%#x" % self.rx_errors)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
                q.text(","); q.breakable()
                q.text("rx_frame_err = ");
                q.text("%#x" % self.rx_frame_err)
                q.text(","); q.breakable()
                q.text("rx_over_err = ");
                q.text("%#x" % self.rx_over_err)
                q.text(","); q.breakable()
                q.text("rx_crc_err = ");
                q.text("%#x" % self.rx_crc_err)
                q.text(","); q.breakable()
                q.text("collisions = ");
                q.text("%#x" % self.collisions)
            q.breakable()
        q.text('}')

class queue_prop_experimenter(object):
    type = 65535

    def __init__(self, experimenter=None, data=None):
        if experimenter != None:
            self.experimenter = experimenter
        else:
            self.experimenter = 0
        if data != None:
            self.data = data
        else:
            self.data = ''
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        packed.append(struct.pack("!L", self.experimenter))
        packed.append('\x00' * 4)
        packed.append(self.data)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = queue_prop_experimenter()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type = reader.read("!H")[0]
        assert(_type == 65535)
        _len = reader.read("!H")[0]
        reader.skip(4)
        obj.experimenter = reader.read("!L")[0]
        reader.skip(4)
        obj.data = str(reader.read_all())
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.experimenter != other.experimenter: return False
        if self.data != other.data: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_prop_experimenter {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("experimenter = ");
                q.text("%#x" % self.experimenter)
                q.text(","); q.breakable()
                q.text("data = ");
                q.pp(self.data)
            q.breakable()
        q.text('}')

class queue_prop_max_rate(object):
    type = 2

    def __init__(self, rate=None):
        if rate != None:
            self.rate = rate
        else:
            self.rate = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        packed.append(struct.pack("!H", self.rate))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = queue_prop_max_rate()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type = reader.read("!H")[0]
        assert(_type == 2)
        _len = reader.read("!H")[0]
        reader.skip(4)
        obj.rate = reader.read("!H")[0]
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.rate != other.rate: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_prop_max_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("rate = ");
                q.text("%#x" % self.rate)
            q.breakable()
        q.text('}')

class queue_prop_min_rate(object):
    type = 1

    def __init__(self, rate=None):
        if rate != None:
            self.rate = rate
        else:
            self.rate = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!H", self.type))
        packed.append(struct.pack("!H", 0)) # placeholder for len at index 1
        packed.append('\x00' * 4)
        packed.append(struct.pack("!H", self.rate))
        packed.append('\x00' * 6)
        length = sum([len(x) for x in packed])
        packed[1] = struct.pack("!H", length)
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = queue_prop_min_rate()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        _type = reader.read("!H")[0]
        assert(_type == 1)
        _len = reader.read("!H")[0]
        reader.skip(4)
        obj.rate = reader.read("!H")[0]
        reader.skip(6)
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.rate != other.rate: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_prop_min_rate {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("rate = ");
                q.text("%#x" % self.rate)
            q.breakable()
        q.text('}')

class queue_stats_entry(object):

    def __init__(self, port_no=None, queue_id=None, tx_bytes=None, tx_packets=None, tx_errors=None):
        if port_no != None:
            self.port_no = port_no
        else:
            self.port_no = 0
        if queue_id != None:
            self.queue_id = queue_id
        else:
            self.queue_id = 0
        if tx_bytes != None:
            self.tx_bytes = tx_bytes
        else:
            self.tx_bytes = 0
        if tx_packets != None:
            self.tx_packets = tx_packets
        else:
            self.tx_packets = 0
        if tx_errors != None:
            self.tx_errors = tx_errors
        else:
            self.tx_errors = 0
        return

    def pack(self):
        packed = []
        packed.append(util.pack_port_no(self.port_no))
        packed.append(struct.pack("!L", self.queue_id))
        packed.append(struct.pack("!Q", self.tx_bytes))
        packed.append(struct.pack("!Q", self.tx_packets))
        packed.append(struct.pack("!Q", self.tx_errors))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = queue_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.port_no = util.unpack_port_no(reader)
        obj.queue_id = reader.read("!L")[0]
        obj.tx_bytes = reader.read("!Q")[0]
        obj.tx_packets = reader.read("!Q")[0]
        obj.tx_errors = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.port_no != other.port_no: return False
        if self.queue_id != other.queue_id: return False
        if self.tx_bytes != other.tx_bytes: return False
        if self.tx_packets != other.tx_packets: return False
        if self.tx_errors != other.tx_errors: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("queue_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("port_no = ");
                q.text(util.pretty_port(self.port_no))
                q.text(","); q.breakable()
                q.text("queue_id = ");
                q.text("%#x" % self.queue_id)
                q.text(","); q.breakable()
                q.text("tx_bytes = ");
                q.text("%#x" % self.tx_bytes)
                q.text(","); q.breakable()
                q.text("tx_packets = ");
                q.text("%#x" % self.tx_packets)
                q.text(","); q.breakable()
                q.text("tx_errors = ");
                q.text("%#x" % self.tx_errors)
            q.breakable()
        q.text('}')

class table_stats_entry(object):

    def __init__(self, table_id=None, name=None, match=None, wildcards=None, write_actions=None, apply_actions=None, write_setfields=None, apply_setfields=None, metadata_match=None, metadata_write=None, instructions=None, config=None, max_entries=None, active_count=None, lookup_count=None, matched_count=None):
        if table_id != None:
            self.table_id = table_id
        else:
            self.table_id = 0
        if name != None:
            self.name = name
        else:
            self.name = ""
        if match != None:
            self.match = match
        else:
            self.match = util.init_match_bmap()
        if wildcards != None:
            self.wildcards = wildcards
        else:
            self.wildcards = util.init_wc_bmap()
        if write_actions != None:
            self.write_actions = write_actions
        else:
            self.write_actions = 0
        if apply_actions != None:
            self.apply_actions = apply_actions
        else:
            self.apply_actions = 0
        if write_setfields != None:
            self.write_setfields = write_setfields
        else:
            self.write_setfields = 0
        if apply_setfields != None:
            self.apply_setfields = apply_setfields
        else:
            self.apply_setfields = 0
        if metadata_match != None:
            self.metadata_match = metadata_match
        else:
            self.metadata_match = 0
        if metadata_write != None:
            self.metadata_write = metadata_write
        else:
            self.metadata_write = 0
        if instructions != None:
            self.instructions = instructions
        else:
            self.instructions = 0
        if config != None:
            self.config = config
        else:
            self.config = 0
        if max_entries != None:
            self.max_entries = max_entries
        else:
            self.max_entries = 0
        if active_count != None:
            self.active_count = active_count
        else:
            self.active_count = 0
        if lookup_count != None:
            self.lookup_count = lookup_count
        else:
            self.lookup_count = 0
        if matched_count != None:
            self.matched_count = matched_count
        else:
            self.matched_count = 0
        return

    def pack(self):
        packed = []
        packed.append(struct.pack("!B", self.table_id))
        packed.append('\x00' * 7)
        packed.append(struct.pack("!32s", self.name))
        packed.append(util.pack_match_bmap(self.match))
        packed.append(util.pack_wc_bmap(self.wildcards))
        packed.append(struct.pack("!L", self.write_actions))
        packed.append(struct.pack("!L", self.apply_actions))
        packed.append(struct.pack("!Q", self.write_setfields))
        packed.append(struct.pack("!Q", self.apply_setfields))
        packed.append(struct.pack("!Q", self.metadata_match))
        packed.append(struct.pack("!Q", self.metadata_write))
        packed.append(struct.pack("!L", self.instructions))
        packed.append(struct.pack("!L", self.config))
        packed.append(struct.pack("!L", self.max_entries))
        packed.append(struct.pack("!L", self.active_count))
        packed.append(struct.pack("!Q", self.lookup_count))
        packed.append(struct.pack("!Q", self.matched_count))
        return ''.join(packed)

    @staticmethod
    def unpack(buf):
        obj = table_stats_entry()
        if type(buf) == loxi.generic_util.OFReader:
            reader = buf
        else:
            reader = loxi.generic_util.OFReader(buf)
        obj.table_id = reader.read("!B")[0]
        reader.skip(7)
        obj.name = reader.read("!32s")[0].rstrip("\x00")
        obj.match = util.unpack_match_bmap(reader)
        obj.wildcards = util.unpack_wc_bmap(reader)
        obj.write_actions = reader.read("!L")[0]
        obj.apply_actions = reader.read("!L")[0]
        obj.write_setfields = reader.read("!Q")[0]
        obj.apply_setfields = reader.read("!Q")[0]
        obj.metadata_match = reader.read("!Q")[0]
        obj.metadata_write = reader.read("!Q")[0]
        obj.instructions = reader.read("!L")[0]
        obj.config = reader.read("!L")[0]
        obj.max_entries = reader.read("!L")[0]
        obj.active_count = reader.read("!L")[0]
        obj.lookup_count = reader.read("!Q")[0]
        obj.matched_count = reader.read("!Q")[0]
        return obj

    def __eq__(self, other):
        if type(self) != type(other): return False
        if self.table_id != other.table_id: return False
        if self.name != other.name: return False
        if self.match != other.match: return False
        if self.wildcards != other.wildcards: return False
        if self.write_actions != other.write_actions: return False
        if self.apply_actions != other.apply_actions: return False
        if self.write_setfields != other.write_setfields: return False
        if self.apply_setfields != other.apply_setfields: return False
        if self.metadata_match != other.metadata_match: return False
        if self.metadata_write != other.metadata_write: return False
        if self.instructions != other.instructions: return False
        if self.config != other.config: return False
        if self.max_entries != other.max_entries: return False
        if self.active_count != other.active_count: return False
        if self.lookup_count != other.lookup_count: return False
        if self.matched_count != other.matched_count: return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def show(self):
        import loxi.pp
        return loxi.pp.pp(self)

    def pretty_print(self, q):
        q.text("table_stats_entry {")
        with q.group():
            with q.indent(2):
                q.breakable()
                q.text("table_id = ");
                q.text("%#x" % self.table_id)
                q.text(","); q.breakable()
                q.text("name = ");
                q.pp(self.name)
                q.text(","); q.breakable()
                q.text("match = ");
                q.pp(self.match)
                q.text(","); q.breakable()
                q.text("wildcards = ");
                q.pp(self.wildcards)
                q.text(","); q.breakable()
                q.text("write_actions = ");
                q.text("%#x" % self.write_actions)
                q.text(","); q.breakable()
                q.text("apply_actions = ");
                q.text("%#x" % self.apply_actions)
                q.text(","); q.breakable()
                q.text("write_setfields = ");
                q.text("%#x" % self.write_setfields)
                q.text(","); q.breakable()
                q.text("apply_setfields = ");
                q.text("%#x" % self.apply_setfields)
                q.text(","); q.breakable()
                q.text("metadata_match = ");
                q.text("%#x" % self.metadata_match)
                q.text(","); q.breakable()
                q.text("metadata_write = ");
                q.text("%#x" % self.metadata_write)
                q.text(","); q.breakable()
                q.text("instructions = ");
                q.text("%#x" % self.instructions)
                q.text(","); q.breakable()
                q.text("config = ");
                q.text("%#x" % self.config)
                q.text(","); q.breakable()
                q.text("max_entries = ");
                q.text("%#x" % self.max_entries)
                q.text(","); q.breakable()
                q.text("active_count = ");
                q.text("%#x" % self.active_count)
                q.text(","); q.breakable()
                q.text("lookup_count = ");
                q.text("%#x" % self.lookup_count)
                q.text(","); q.breakable()
                q.text("matched_count = ");
                q.text("%#x" % self.matched_count)
            q.breakable()
        q.text('}')


match = match_v3
