// Code generated by protoc-gen-go. DO NOT EDIT.
// source: dmi/hw_events_mgmt_service.proto

package dmi

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type EventIds int32

const (
	EventIds_EVENT_NAME_UNDEFINED EventIds = 0
	// Events from the Transceivers
	EventIds_EVENT_TRANSCEIVER_PLUG_OUT EventIds = 100
	EventIds_EVENT_TRANSCEIVER_PLUG_IN  EventIds = 101
	// The threshold based events on the transceivers should be configured on
	// the port components of that transceiver and not on the transceiver
	// component itself. This is because there could be different thresholds
	// on the different ports of a transceiver (for example for a transceiver of
	// type COMBO_GPON_XGSPON the power thresholds could be different for the
	// GPON and XGSPON ports)
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD               EventIds = 102
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD               EventIds = 103
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD           EventIds = 104
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD           EventIds = 105
	EventIds_EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD               EventIds = 106
	EventIds_EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD               EventIds = 107
	EventIds_EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD              EventIds = 108
	EventIds_EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD              EventIds = 109
	EventIds_EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD              EventIds = 110
	EventIds_EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD              EventIds = 111
	EventIds_EVENT_TRANSCEIVER_FAILURE                               EventIds = 112
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVERED     EventIds = 113
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVERED     EventIds = 114
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVERED EventIds = 115
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVERED EventIds = 116
	EventIds_EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVERED     EventIds = 117
	EventIds_EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVERED     EventIds = 118
	EventIds_EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVERED    EventIds = 119
	EventIds_EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVERED    EventIds = 120
	EventIds_EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVERED    EventIds = 121
	EventIds_EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVERED    EventIds = 122
	EventIds_EVENT_TRANSCEIVER_FAILURE_RECOVERED                     EventIds = 123
	// Events from the PSU
	EventIds_EVENT_PSU_PLUG_OUT          EventIds = 200
	EventIds_EVENT_PSU_PLUG_IN           EventIds = 201
	EventIds_EVENT_PSU_FAILURE           EventIds = 202
	EventIds_EVENT_PSU_FAILURE_RECOVERED EventIds = 203
	// Events for the Fans
	EventIds_EVENT_FAN_FAILURE           EventIds = 300
	EventIds_EVENT_FAN_PLUG_OUT          EventIds = 301
	EventIds_EVENT_FAN_PLUG_IN           EventIds = 302
	EventIds_EVENT_FAN_FAILURE_RECOVERED EventIds = 303
	// Events for the CPUs
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL           EventIds = 400
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_FATAL              EventIds = 401
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED EventIds = 402
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED    EventIds = 403
	EventIds_EVENT_CPU_USAGE_ABOVE_THRESHOLD                EventIds = 404
	EventIds_EVENT_CPU_USAGE_ABOVE_THRESHOLD_RECOVERED      EventIds = 405
	// Events for the complete HW Device
	EventIds_EVENT_HW_DEVICE_RESET                                EventIds = 500
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL           EventIds = 501
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL              EventIds = 502
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED EventIds = 503
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED    EventIds = 504
	EventIds_EVENT_HW_DEVICE_REBOOT                               EventIds = 505
	EventIds_EVENT_HW_TEMPERATURE_SENSOR_FAILED                   EventIds = 506
	EventIds_EVENT_HW_ALL_TEMPERATURE_SENSORS_FAILED              EventIds = 507
	EventIds_EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD                  EventIds = 508
	EventIds_EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD_RECOVERED        EventIds = 509
	EventIds_EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD                EventIds = 510
	EventIds_EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD_RECOVERED      EventIds = 511
	EventIds_EVENT_HW_NTP_SYNC_FAILURE                            EventIds = 512
	EventIds_EVENT_HW_NTP_SYNC_FAILURE_RECOVERED                  EventIds = 513
	// Events for the line cards on the HW Device
	EventIds_EVENT_LINE_CARD_PLUG_OUT EventIds = 600
	EventIds_EVENT_LINE_CARD_PLUG_IN  EventIds = 601
	// Indicates that the a state of a component has changed.
	// The StateChangeInfo message inside the event conveys the old and new states.
	EventIds_EVENT_COMPONENT_ADMIN_STATE_CHANGED   EventIds = 700
	EventIds_EVENT_COMPONENT_OPER_STATE_CHANGED    EventIds = 701
	EventIds_EVENT_COMPONENT_ALARM_STATE_CHANGED   EventIds = 702
	EventIds_EVENT_COMPONENT_USAGE_STATE_CHANGED   EventIds = 703
	EventIds_EVENT_COMPONENT_STANDBY_STATE_CHANGED EventIds = 704
	// Generic event about a component, the payload contains GenericEventInfo in this case
	// Use this event id only for events which do not have already a specific event id
	EventIds_EVENT_COMPONENT_GENERIC_EVENT EventIds = 705
)

var EventIds_name = map[int32]string{
	0:   "EVENT_NAME_UNDEFINED",
	100: "EVENT_TRANSCEIVER_PLUG_OUT",
	101: "EVENT_TRANSCEIVER_PLUG_IN",
	102: "EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD",
	103: "EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD",
	104: "EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD",
	105: "EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD",
	106: "EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD",
	107: "EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD",
	108: "EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD",
	109: "EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD",
	110: "EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD",
	111: "EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD",
	112: "EVENT_TRANSCEIVER_FAILURE",
	113: "EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVERED",
	114: "EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVERED",
	115: "EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVERED",
	116: "EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVERED",
	117: "EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVERED",
	118: "EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVERED",
	119: "EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVERED",
	120: "EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVERED",
	121: "EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVERED",
	122: "EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVERED",
	123: "EVENT_TRANSCEIVER_FAILURE_RECOVERED",
	200: "EVENT_PSU_PLUG_OUT",
	201: "EVENT_PSU_PLUG_IN",
	202: "EVENT_PSU_FAILURE",
	203: "EVENT_PSU_FAILURE_RECOVERED",
	300: "EVENT_FAN_FAILURE",
	301: "EVENT_FAN_PLUG_OUT",
	302: "EVENT_FAN_PLUG_IN",
	303: "EVENT_FAN_FAILURE_RECOVERED",
	400: "EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL",
	401: "EVENT_CPU_TEMPERATURE_ABOVE_FATAL",
	402: "EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED",
	403: "EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED",
	404: "EVENT_CPU_USAGE_ABOVE_THRESHOLD",
	405: "EVENT_CPU_USAGE_ABOVE_THRESHOLD_RECOVERED",
	500: "EVENT_HW_DEVICE_RESET",
	501: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL",
	502: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL",
	503: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED",
	504: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED",
	505: "EVENT_HW_DEVICE_REBOOT",
	506: "EVENT_HW_TEMPERATURE_SENSOR_FAILED",
	507: "EVENT_HW_ALL_TEMPERATURE_SENSORS_FAILED",
	508: "EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD",
	509: "EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD_RECOVERED",
	510: "EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD",
	511: "EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD_RECOVERED",
	512: "EVENT_HW_NTP_SYNC_FAILURE",
	513: "EVENT_HW_NTP_SYNC_FAILURE_RECOVERED",
	600: "EVENT_LINE_CARD_PLUG_OUT",
	601: "EVENT_LINE_CARD_PLUG_IN",
	700: "EVENT_COMPONENT_ADMIN_STATE_CHANGED",
	701: "EVENT_COMPONENT_OPER_STATE_CHANGED",
	702: "EVENT_COMPONENT_ALARM_STATE_CHANGED",
	703: "EVENT_COMPONENT_USAGE_STATE_CHANGED",
	704: "EVENT_COMPONENT_STANDBY_STATE_CHANGED",
	705: "EVENT_COMPONENT_GENERIC_EVENT",
}

var EventIds_value = map[string]int32{
	"EVENT_NAME_UNDEFINED":                                    0,
	"EVENT_TRANSCEIVER_PLUG_OUT":                              100,
	"EVENT_TRANSCEIVER_PLUG_IN":                               101,
	"EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD":               102,
	"EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD":               103,
	"EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD":           104,
	"EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD":           105,
	"EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD":               106,
	"EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD":               107,
	"EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD":              108,
	"EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD":              109,
	"EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD":              110,
	"EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD":              111,
	"EVENT_TRANSCEIVER_FAILURE":                               112,
	"EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVERED":     113,
	"EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVERED":     114,
	"EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVERED": 115,
	"EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVERED": 116,
	"EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVERED":     117,
	"EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVERED":     118,
	"EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVERED":    119,
	"EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVERED":    120,
	"EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVERED":    121,
	"EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVERED":    122,
	"EVENT_TRANSCEIVER_FAILURE_RECOVERED":                     123,
	"EVENT_PSU_PLUG_OUT":                                      200,
	"EVENT_PSU_PLUG_IN":                                       201,
	"EVENT_PSU_FAILURE":                                       202,
	"EVENT_PSU_FAILURE_RECOVERED":                             203,
	"EVENT_FAN_FAILURE":                                       300,
	"EVENT_FAN_PLUG_OUT":                                      301,
	"EVENT_FAN_PLUG_IN":                                       302,
	"EVENT_FAN_FAILURE_RECOVERED":                             303,
	"EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL":                    400,
	"EVENT_CPU_TEMPERATURE_ABOVE_FATAL":                       401,
	"EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED":          402,
	"EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED":             403,
	"EVENT_CPU_USAGE_ABOVE_THRESHOLD":                         404,
	"EVENT_CPU_USAGE_ABOVE_THRESHOLD_RECOVERED":               405,
	"EVENT_HW_DEVICE_RESET":                                   500,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL":              501,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL":                 502,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED":    503,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED":       504,
	"EVENT_HW_DEVICE_REBOOT":                                  505,
	"EVENT_HW_TEMPERATURE_SENSOR_FAILED":                      506,
	"EVENT_HW_ALL_TEMPERATURE_SENSORS_FAILED":                 507,
	"EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD":                     508,
	"EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD_RECOVERED":           509,
	"EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD":                   510,
	"EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD_RECOVERED":         511,
	"EVENT_HW_NTP_SYNC_FAILURE":                               512,
	"EVENT_HW_NTP_SYNC_FAILURE_RECOVERED":                     513,
	"EVENT_LINE_CARD_PLUG_OUT":                                600,
	"EVENT_LINE_CARD_PLUG_IN":                                 601,
	"EVENT_COMPONENT_ADMIN_STATE_CHANGED":                     700,
	"EVENT_COMPONENT_OPER_STATE_CHANGED":                      701,
	"EVENT_COMPONENT_ALARM_STATE_CHANGED":                     702,
	"EVENT_COMPONENT_USAGE_STATE_CHANGED":                     703,
	"EVENT_COMPONENT_STANDBY_STATE_CHANGED":                   704,
	"EVENT_COMPONENT_GENERIC_EVENT":                           705,
}

func (x EventIds) String() string {
	return proto.EnumName(EventIds_name, int32(x))
}

func (EventIds) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{0}
}

type ListEventsResponse_Reason int32

const (
	ListEventsResponse_UNDEFINED_REASON   ListEventsResponse_Reason = 0
	ListEventsResponse_UNKNOWN_DEVICE     ListEventsResponse_Reason = 1
	ListEventsResponse_INTERNAL_ERROR     ListEventsResponse_Reason = 2
	ListEventsResponse_DEVICE_UNREACHABLE ListEventsResponse_Reason = 3
)

var ListEventsResponse_Reason_name = map[int32]string{
	0: "UNDEFINED_REASON",
	1: "UNKNOWN_DEVICE",
	2: "INTERNAL_ERROR",
	3: "DEVICE_UNREACHABLE",
}

var ListEventsResponse_Reason_value = map[string]int32{
	"UNDEFINED_REASON":   0,
	"UNKNOWN_DEVICE":     1,
	"INTERNAL_ERROR":     2,
	"DEVICE_UNREACHABLE": 3,
}

func (x ListEventsResponse_Reason) String() string {
	return proto.EnumName(ListEventsResponse_Reason_name, int32(x))
}

func (ListEventsResponse_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{6, 0}
}

type EventsConfigurationResponse_Reason int32

const (
	EventsConfigurationResponse_UNDEFINED_REASON   EventsConfigurationResponse_Reason = 0
	EventsConfigurationResponse_UNKNOWN_DEVICE     EventsConfigurationResponse_Reason = 1
	EventsConfigurationResponse_INTERNAL_ERROR     EventsConfigurationResponse_Reason = 2
	EventsConfigurationResponse_INVALID_CONFIG     EventsConfigurationResponse_Reason = 3
	EventsConfigurationResponse_DEVICE_UNREACHABLE EventsConfigurationResponse_Reason = 4
)

var EventsConfigurationResponse_Reason_name = map[int32]string{
	0: "UNDEFINED_REASON",
	1: "UNKNOWN_DEVICE",
	2: "INTERNAL_ERROR",
	3: "INVALID_CONFIG",
	4: "DEVICE_UNREACHABLE",
}

var EventsConfigurationResponse_Reason_value = map[string]int32{
	"UNDEFINED_REASON":   0,
	"UNKNOWN_DEVICE":     1,
	"INTERNAL_ERROR":     2,
	"INVALID_CONFIG":     3,
	"DEVICE_UNREACHABLE": 4,
}

func (x EventsConfigurationResponse_Reason) String() string {
	return proto.EnumName(EventsConfigurationResponse_Reason_name, int32(x))
}

func (EventsConfigurationResponse_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{8, 0}
}

type GenericEventInfo_EventSeverity int32

const (
	GenericEventInfo_EVENT_SEVERITY_UNSPECIFIED GenericEventInfo_EventSeverity = 0
	GenericEventInfo_CRITICAL                   GenericEventInfo_EventSeverity = 1
	GenericEventInfo_MAJOR                      GenericEventInfo_EventSeverity = 2
	GenericEventInfo_MINOR                      GenericEventInfo_EventSeverity = 3
	GenericEventInfo_NORMAL                     GenericEventInfo_EventSeverity = 4
	GenericEventInfo_INFO                       GenericEventInfo_EventSeverity = 5
)

var GenericEventInfo_EventSeverity_name = map[int32]string{
	0: "EVENT_SEVERITY_UNSPECIFIED",
	1: "CRITICAL",
	2: "MAJOR",
	3: "MINOR",
	4: "NORMAL",
	5: "INFO",
}

var GenericEventInfo_EventSeverity_value = map[string]int32{
	"EVENT_SEVERITY_UNSPECIFIED": 0,
	"CRITICAL":                   1,
	"MAJOR":                      2,
	"MINOR":                      3,
	"NORMAL":                     4,
	"INFO":                       5,
}

func (x GenericEventInfo_EventSeverity) String() string {
	return proto.EnumName(GenericEventInfo_EventSeverity_name, int32(x))
}

func (GenericEventInfo_EventSeverity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{16, 0}
}

type ValueType struct {
	// For val no multiples of units shall be used.
	// For example, for memory val should be in bytes and not in kilobytes or any
	// other multiple of the unit byte.
	//
	// Types that are valid to be assigned to Val:
	//	*ValueType_IntVal
	//	*ValueType_UintVal
	//	*ValueType_FloatVal
	Val                  isValueType_Val `protobuf_oneof:"val"`
	TypeOfVal            DataValueType   `protobuf:"varint,4,opt,name=typeOfVal,proto3,enum=dmi.DataValueType" json:"typeOfVal,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ValueType) Reset()         { *m = ValueType{} }
func (m *ValueType) String() string { return proto.CompactTextString(m) }
func (*ValueType) ProtoMessage()    {}
func (*ValueType) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{0}
}

func (m *ValueType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValueType.Unmarshal(m, b)
}
func (m *ValueType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValueType.Marshal(b, m, deterministic)
}
func (m *ValueType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueType.Merge(m, src)
}
func (m *ValueType) XXX_Size() int {
	return xxx_messageInfo_ValueType.Size(m)
}
func (m *ValueType) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueType.DiscardUnknown(m)
}

var xxx_messageInfo_ValueType proto.InternalMessageInfo

type isValueType_Val interface {
	isValueType_Val()
}

type ValueType_IntVal struct {
	IntVal int64 `protobuf:"varint,1,opt,name=int_val,json=intVal,proto3,oneof"`
}

type ValueType_UintVal struct {
	UintVal uint64 `protobuf:"varint,2,opt,name=uint_val,json=uintVal,proto3,oneof"`
}

type ValueType_FloatVal struct {
	FloatVal float32 `protobuf:"fixed32,3,opt,name=float_val,json=floatVal,proto3,oneof"`
}

func (*ValueType_IntVal) isValueType_Val() {}

func (*ValueType_UintVal) isValueType_Val() {}

func (*ValueType_FloatVal) isValueType_Val() {}

func (m *ValueType) GetVal() isValueType_Val {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *ValueType) GetIntVal() int64 {
	if x, ok := m.GetVal().(*ValueType_IntVal); ok {
		return x.IntVal
	}
	return 0
}

func (m *ValueType) GetUintVal() uint64 {
	if x, ok := m.GetVal().(*ValueType_UintVal); ok {
		return x.UintVal
	}
	return 0
}

func (m *ValueType) GetFloatVal() float32 {
	if x, ok := m.GetVal().(*ValueType_FloatVal); ok {
		return x.FloatVal
	}
	return 0
}

func (m *ValueType) GetTypeOfVal() DataValueType {
	if m != nil {
		return m.TypeOfVal
	}
	return DataValueType_VALUE_TYPE_UNDEFINED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ValueType) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ValueType_IntVal)(nil),
		(*ValueType_UintVal)(nil),
		(*ValueType_FloatVal)(nil),
	}
}

type WaterMarks struct {
	High                 *ValueType `protobuf:"bytes,1,opt,name=high,proto3" json:"high,omitempty"`
	Low                  *ValueType `protobuf:"bytes,2,opt,name=low,proto3" json:"low,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *WaterMarks) Reset()         { *m = WaterMarks{} }
func (m *WaterMarks) String() string { return proto.CompactTextString(m) }
func (*WaterMarks) ProtoMessage()    {}
func (*WaterMarks) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{1}
}

func (m *WaterMarks) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WaterMarks.Unmarshal(m, b)
}
func (m *WaterMarks) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WaterMarks.Marshal(b, m, deterministic)
}
func (m *WaterMarks) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WaterMarks.Merge(m, src)
}
func (m *WaterMarks) XXX_Size() int {
	return xxx_messageInfo_WaterMarks.Size(m)
}
func (m *WaterMarks) XXX_DiscardUnknown() {
	xxx_messageInfo_WaterMarks.DiscardUnknown(m)
}

var xxx_messageInfo_WaterMarks proto.InternalMessageInfo

func (m *WaterMarks) GetHigh() *ValueType {
	if m != nil {
		return m.High
	}
	return nil
}

func (m *WaterMarks) GetLow() *ValueType {
	if m != nil {
		return m.Low
	}
	return nil
}

type Thresholds struct {
	// Types that are valid to be assigned to Threshold:
	//	*Thresholds_Upper
	//	*Thresholds_Lower
	Threshold            isThresholds_Threshold `protobuf_oneof:"threshold"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Thresholds) Reset()         { *m = Thresholds{} }
func (m *Thresholds) String() string { return proto.CompactTextString(m) }
func (*Thresholds) ProtoMessage()    {}
func (*Thresholds) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{2}
}

func (m *Thresholds) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Thresholds.Unmarshal(m, b)
}
func (m *Thresholds) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Thresholds.Marshal(b, m, deterministic)
}
func (m *Thresholds) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Thresholds.Merge(m, src)
}
func (m *Thresholds) XXX_Size() int {
	return xxx_messageInfo_Thresholds.Size(m)
}
func (m *Thresholds) XXX_DiscardUnknown() {
	xxx_messageInfo_Thresholds.DiscardUnknown(m)
}

var xxx_messageInfo_Thresholds proto.InternalMessageInfo

type isThresholds_Threshold interface {
	isThresholds_Threshold()
}

type Thresholds_Upper struct {
	Upper *WaterMarks `protobuf:"bytes,1,opt,name=upper,proto3,oneof"`
}

type Thresholds_Lower struct {
	Lower *WaterMarks `protobuf:"bytes,2,opt,name=lower,proto3,oneof"`
}

func (*Thresholds_Upper) isThresholds_Threshold() {}

func (*Thresholds_Lower) isThresholds_Threshold() {}

func (m *Thresholds) GetThreshold() isThresholds_Threshold {
	if m != nil {
		return m.Threshold
	}
	return nil
}

func (m *Thresholds) GetUpper() *WaterMarks {
	if x, ok := m.GetThreshold().(*Thresholds_Upper); ok {
		return x.Upper
	}
	return nil
}

func (m *Thresholds) GetLower() *WaterMarks {
	if x, ok := m.GetThreshold().(*Thresholds_Lower); ok {
		return x.Lower
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Thresholds) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Thresholds_Upper)(nil),
		(*Thresholds_Lower)(nil),
	}
}

type ThresholdInformation struct {
	ObservedValue        *ValueType  `protobuf:"bytes,1,opt,name=observed_value,json=observedValue,proto3" json:"observed_value,omitempty"`
	Thresholds           *Thresholds `protobuf:"bytes,2,opt,name=thresholds,proto3" json:"thresholds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ThresholdInformation) Reset()         { *m = ThresholdInformation{} }
func (m *ThresholdInformation) String() string { return proto.CompactTextString(m) }
func (*ThresholdInformation) ProtoMessage()    {}
func (*ThresholdInformation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{3}
}

func (m *ThresholdInformation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThresholdInformation.Unmarshal(m, b)
}
func (m *ThresholdInformation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThresholdInformation.Marshal(b, m, deterministic)
}
func (m *ThresholdInformation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThresholdInformation.Merge(m, src)
}
func (m *ThresholdInformation) XXX_Size() int {
	return xxx_messageInfo_ThresholdInformation.Size(m)
}
func (m *ThresholdInformation) XXX_DiscardUnknown() {
	xxx_messageInfo_ThresholdInformation.DiscardUnknown(m)
}

var xxx_messageInfo_ThresholdInformation proto.InternalMessageInfo

func (m *ThresholdInformation) GetObservedValue() *ValueType {
	if m != nil {
		return m.ObservedValue
	}
	return nil
}

func (m *ThresholdInformation) GetThresholds() *Thresholds {
	if m != nil {
		return m.Thresholds
	}
	return nil
}

type EventCfg struct {
	EventId      EventIds `protobuf:"varint,1,opt,name=event_id,json=eventId,proto3,enum=dmi.EventIds" json:"event_id,omitempty"`
	IsConfigured bool     `protobuf:"varint,2,opt,name=is_configured,json=isConfigured,proto3" json:"is_configured,omitempty"`
	// Optional threshold values, applicable only for some specific events
	// If an event needs thresholds but the user does not pass the thresholds here, the Device Manager implementations
	// could choose to use defaults applicable for the specific component (recommended) or return an error for such
	// an EventConfigurationRequest with reason as INVALID_CONFIG
	Thresholds *Thresholds `protobuf:"bytes,3,opt,name=thresholds,proto3" json:"thresholds,omitempty"`
	// For events which can be configured on a particular component this id can be used to identify the component
	// For e.g. for events of the transceivers
	ComponentUuid        *Uuid    `protobuf:"bytes,4,opt,name=component_uuid,json=componentUuid,proto3" json:"component_uuid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventCfg) Reset()         { *m = EventCfg{} }
func (m *EventCfg) String() string { return proto.CompactTextString(m) }
func (*EventCfg) ProtoMessage()    {}
func (*EventCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{4}
}

func (m *EventCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventCfg.Unmarshal(m, b)
}
func (m *EventCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventCfg.Marshal(b, m, deterministic)
}
func (m *EventCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventCfg.Merge(m, src)
}
func (m *EventCfg) XXX_Size() int {
	return xxx_messageInfo_EventCfg.Size(m)
}
func (m *EventCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_EventCfg.DiscardUnknown(m)
}

var xxx_messageInfo_EventCfg proto.InternalMessageInfo

func (m *EventCfg) GetEventId() EventIds {
	if m != nil {
		return m.EventId
	}
	return EventIds_EVENT_NAME_UNDEFINED
}

func (m *EventCfg) GetIsConfigured() bool {
	if m != nil {
		return m.IsConfigured
	}
	return false
}

func (m *EventCfg) GetThresholds() *Thresholds {
	if m != nil {
		return m.Thresholds
	}
	return nil
}

func (m *EventCfg) GetComponentUuid() *Uuid {
	if m != nil {
		return m.ComponentUuid
	}
	return nil
}

type EventsCfg struct {
	Items                []*EventCfg `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EventsCfg) Reset()         { *m = EventsCfg{} }
func (m *EventsCfg) String() string { return proto.CompactTextString(m) }
func (*EventsCfg) ProtoMessage()    {}
func (*EventsCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{5}
}

func (m *EventsCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsCfg.Unmarshal(m, b)
}
func (m *EventsCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsCfg.Marshal(b, m, deterministic)
}
func (m *EventsCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsCfg.Merge(m, src)
}
func (m *EventsCfg) XXX_Size() int {
	return xxx_messageInfo_EventsCfg.Size(m)
}
func (m *EventsCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsCfg.DiscardUnknown(m)
}

var xxx_messageInfo_EventsCfg proto.InternalMessageInfo

func (m *EventsCfg) GetItems() []*EventCfg {
	if m != nil {
		return m.Items
	}
	return nil
}

type ListEventsResponse struct {
	Status               Status                    `protobuf:"varint,1,opt,name=status,proto3,enum=dmi.Status" json:"status,omitempty"`
	Reason               ListEventsResponse_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=dmi.ListEventsResponse_Reason" json:"reason,omitempty"`
	Events               *EventsCfg                `protobuf:"bytes,3,opt,name=events,proto3" json:"events,omitempty"`
	ReasonDetail         string                    `protobuf:"bytes,4,opt,name=reason_detail,json=reasonDetail,proto3" json:"reason_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ListEventsResponse) Reset()         { *m = ListEventsResponse{} }
func (m *ListEventsResponse) String() string { return proto.CompactTextString(m) }
func (*ListEventsResponse) ProtoMessage()    {}
func (*ListEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{6}
}

func (m *ListEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEventsResponse.Unmarshal(m, b)
}
func (m *ListEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEventsResponse.Marshal(b, m, deterministic)
}
func (m *ListEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEventsResponse.Merge(m, src)
}
func (m *ListEventsResponse) XXX_Size() int {
	return xxx_messageInfo_ListEventsResponse.Size(m)
}
func (m *ListEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEventsResponse proto.InternalMessageInfo

func (m *ListEventsResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNDEFINED_STATUS
}

func (m *ListEventsResponse) GetReason() ListEventsResponse_Reason {
	if m != nil {
		return m.Reason
	}
	return ListEventsResponse_UNDEFINED_REASON
}

func (m *ListEventsResponse) GetEvents() *EventsCfg {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *ListEventsResponse) GetReasonDetail() string {
	if m != nil {
		return m.ReasonDetail
	}
	return ""
}

type EventsConfigurationRequest struct {
	DeviceUuid *Uuid `protobuf:"bytes,1,opt,name=device_uuid,json=deviceUuid,proto3" json:"device_uuid,omitempty"`
	// Types that are valid to be assigned to Operation:
	//	*EventsConfigurationRequest_Changes
	//	*EventsConfigurationRequest_ResetToDefault
	Operation            isEventsConfigurationRequest_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *EventsConfigurationRequest) Reset()         { *m = EventsConfigurationRequest{} }
func (m *EventsConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*EventsConfigurationRequest) ProtoMessage()    {}
func (*EventsConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{7}
}

func (m *EventsConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsConfigurationRequest.Unmarshal(m, b)
}
func (m *EventsConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsConfigurationRequest.Marshal(b, m, deterministic)
}
func (m *EventsConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsConfigurationRequest.Merge(m, src)
}
func (m *EventsConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_EventsConfigurationRequest.Size(m)
}
func (m *EventsConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EventsConfigurationRequest proto.InternalMessageInfo

func (m *EventsConfigurationRequest) GetDeviceUuid() *Uuid {
	if m != nil {
		return m.DeviceUuid
	}
	return nil
}

type isEventsConfigurationRequest_Operation interface {
	isEventsConfigurationRequest_Operation()
}

type EventsConfigurationRequest_Changes struct {
	Changes *EventsCfg `protobuf:"bytes,2,opt,name=changes,proto3,oneof"`
}

type EventsConfigurationRequest_ResetToDefault struct {
	ResetToDefault bool `protobuf:"varint,3,opt,name=reset_to_default,json=resetToDefault,proto3,oneof"`
}

func (*EventsConfigurationRequest_Changes) isEventsConfigurationRequest_Operation() {}

func (*EventsConfigurationRequest_ResetToDefault) isEventsConfigurationRequest_Operation() {}

func (m *EventsConfigurationRequest) GetOperation() isEventsConfigurationRequest_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *EventsConfigurationRequest) GetChanges() *EventsCfg {
	if x, ok := m.GetOperation().(*EventsConfigurationRequest_Changes); ok {
		return x.Changes
	}
	return nil
}

func (m *EventsConfigurationRequest) GetResetToDefault() bool {
	if x, ok := m.GetOperation().(*EventsConfigurationRequest_ResetToDefault); ok {
		return x.ResetToDefault
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EventsConfigurationRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EventsConfigurationRequest_Changes)(nil),
		(*EventsConfigurationRequest_ResetToDefault)(nil),
	}
}

type EventsConfigurationResponse struct {
	Status               Status                             `protobuf:"varint,1,opt,name=status,proto3,enum=dmi.Status" json:"status,omitempty"`
	Reason               EventsConfigurationResponse_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=dmi.EventsConfigurationResponse_Reason" json:"reason,omitempty"`
	ReasonDetail         string                             `protobuf:"bytes,3,opt,name=reason_detail,json=reasonDetail,proto3" json:"reason_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *EventsConfigurationResponse) Reset()         { *m = EventsConfigurationResponse{} }
func (m *EventsConfigurationResponse) String() string { return proto.CompactTextString(m) }
func (*EventsConfigurationResponse) ProtoMessage()    {}
func (*EventsConfigurationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{8}
}

func (m *EventsConfigurationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsConfigurationResponse.Unmarshal(m, b)
}
func (m *EventsConfigurationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsConfigurationResponse.Marshal(b, m, deterministic)
}
func (m *EventsConfigurationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsConfigurationResponse.Merge(m, src)
}
func (m *EventsConfigurationResponse) XXX_Size() int {
	return xxx_messageInfo_EventsConfigurationResponse.Size(m)
}
func (m *EventsConfigurationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsConfigurationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EventsConfigurationResponse proto.InternalMessageInfo

func (m *EventsConfigurationResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNDEFINED_STATUS
}

func (m *EventsConfigurationResponse) GetReason() EventsConfigurationResponse_Reason {
	if m != nil {
		return m.Reason
	}
	return EventsConfigurationResponse_UNDEFINED_REASON
}

func (m *EventsConfigurationResponse) GetReasonDetail() string {
	if m != nil {
		return m.ReasonDetail
	}
	return ""
}

type EventMetaData struct {
	DeviceUuid *Uuid `protobuf:"bytes,1,opt,name=device_uuid,json=deviceUuid,proto3" json:"device_uuid,omitempty"`
	// uuid of the component
	ComponentUuid        *Uuid    `protobuf:"bytes,2,opt,name=component_uuid,json=componentUuid,proto3" json:"component_uuid,omitempty"`
	ComponentName        string   `protobuf:"bytes,3,opt,name=component_name,json=componentName,proto3" json:"component_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventMetaData) Reset()         { *m = EventMetaData{} }
func (m *EventMetaData) String() string { return proto.CompactTextString(m) }
func (*EventMetaData) ProtoMessage()    {}
func (*EventMetaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{9}
}

func (m *EventMetaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventMetaData.Unmarshal(m, b)
}
func (m *EventMetaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventMetaData.Marshal(b, m, deterministic)
}
func (m *EventMetaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventMetaData.Merge(m, src)
}
func (m *EventMetaData) XXX_Size() int {
	return xxx_messageInfo_EventMetaData.Size(m)
}
func (m *EventMetaData) XXX_DiscardUnknown() {
	xxx_messageInfo_EventMetaData.DiscardUnknown(m)
}

var xxx_messageInfo_EventMetaData proto.InternalMessageInfo

func (m *EventMetaData) GetDeviceUuid() *Uuid {
	if m != nil {
		return m.DeviceUuid
	}
	return nil
}

func (m *EventMetaData) GetComponentUuid() *Uuid {
	if m != nil {
		return m.ComponentUuid
	}
	return nil
}

func (m *EventMetaData) GetComponentName() string {
	if m != nil {
		return m.ComponentName
	}
	return ""
}

type AdminStateChange struct {
	Old                  ComponentAdminState `protobuf:"varint,1,opt,name=old,proto3,enum=dmi.ComponentAdminState" json:"old,omitempty"`
	New                  ComponentAdminState `protobuf:"varint,2,opt,name=new,proto3,enum=dmi.ComponentAdminState" json:"new,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *AdminStateChange) Reset()         { *m = AdminStateChange{} }
func (m *AdminStateChange) String() string { return proto.CompactTextString(m) }
func (*AdminStateChange) ProtoMessage()    {}
func (*AdminStateChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{10}
}

func (m *AdminStateChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdminStateChange.Unmarshal(m, b)
}
func (m *AdminStateChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdminStateChange.Marshal(b, m, deterministic)
}
func (m *AdminStateChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminStateChange.Merge(m, src)
}
func (m *AdminStateChange) XXX_Size() int {
	return xxx_messageInfo_AdminStateChange.Size(m)
}
func (m *AdminStateChange) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminStateChange.DiscardUnknown(m)
}

var xxx_messageInfo_AdminStateChange proto.InternalMessageInfo

func (m *AdminStateChange) GetOld() ComponentAdminState {
	if m != nil {
		return m.Old
	}
	return ComponentAdminState_COMP_ADMIN_STATE_UNDEFINED
}

func (m *AdminStateChange) GetNew() ComponentAdminState {
	if m != nil {
		return m.New
	}
	return ComponentAdminState_COMP_ADMIN_STATE_UNDEFINED
}

type OperStateChange struct {
	Old                  ComponentOperState `protobuf:"varint,1,opt,name=old,proto3,enum=dmi.ComponentOperState" json:"old,omitempty"`
	New                  ComponentOperState `protobuf:"varint,2,opt,name=new,proto3,enum=dmi.ComponentOperState" json:"new,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *OperStateChange) Reset()         { *m = OperStateChange{} }
func (m *OperStateChange) String() string { return proto.CompactTextString(m) }
func (*OperStateChange) ProtoMessage()    {}
func (*OperStateChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{11}
}

func (m *OperStateChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperStateChange.Unmarshal(m, b)
}
func (m *OperStateChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperStateChange.Marshal(b, m, deterministic)
}
func (m *OperStateChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperStateChange.Merge(m, src)
}
func (m *OperStateChange) XXX_Size() int {
	return xxx_messageInfo_OperStateChange.Size(m)
}
func (m *OperStateChange) XXX_DiscardUnknown() {
	xxx_messageInfo_OperStateChange.DiscardUnknown(m)
}

var xxx_messageInfo_OperStateChange proto.InternalMessageInfo

func (m *OperStateChange) GetOld() ComponentOperState {
	if m != nil {
		return m.Old
	}
	return ComponentOperState_COMP_OPER_STATE_UNDEFINED
}

func (m *OperStateChange) GetNew() ComponentOperState {
	if m != nil {
		return m.New
	}
	return ComponentOperState_COMP_OPER_STATE_UNDEFINED
}

type AlarmStateChange struct {
	Old                  ComponentAlarmState `protobuf:"varint,1,opt,name=old,proto3,enum=dmi.ComponentAlarmState" json:"old,omitempty"`
	New                  ComponentAlarmState `protobuf:"varint,2,opt,name=new,proto3,enum=dmi.ComponentAlarmState" json:"new,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *AlarmStateChange) Reset()         { *m = AlarmStateChange{} }
func (m *AlarmStateChange) String() string { return proto.CompactTextString(m) }
func (*AlarmStateChange) ProtoMessage()    {}
func (*AlarmStateChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{12}
}

func (m *AlarmStateChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlarmStateChange.Unmarshal(m, b)
}
func (m *AlarmStateChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlarmStateChange.Marshal(b, m, deterministic)
}
func (m *AlarmStateChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlarmStateChange.Merge(m, src)
}
func (m *AlarmStateChange) XXX_Size() int {
	return xxx_messageInfo_AlarmStateChange.Size(m)
}
func (m *AlarmStateChange) XXX_DiscardUnknown() {
	xxx_messageInfo_AlarmStateChange.DiscardUnknown(m)
}

var xxx_messageInfo_AlarmStateChange proto.InternalMessageInfo

func (m *AlarmStateChange) GetOld() ComponentAlarmState {
	if m != nil {
		return m.Old
	}
	return ComponentAlarmState_COMP_ALARM_STATE_UNDEFINED
}

func (m *AlarmStateChange) GetNew() ComponentAlarmState {
	if m != nil {
		return m.New
	}
	return ComponentAlarmState_COMP_ALARM_STATE_UNDEFINED
}

type UsageStateChange struct {
	Old                  ComponentUsageState `protobuf:"varint,1,opt,name=old,proto3,enum=dmi.ComponentUsageState" json:"old,omitempty"`
	New                  ComponentUsageState `protobuf:"varint,2,opt,name=new,proto3,enum=dmi.ComponentUsageState" json:"new,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *UsageStateChange) Reset()         { *m = UsageStateChange{} }
func (m *UsageStateChange) String() string { return proto.CompactTextString(m) }
func (*UsageStateChange) ProtoMessage()    {}
func (*UsageStateChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{13}
}

func (m *UsageStateChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UsageStateChange.Unmarshal(m, b)
}
func (m *UsageStateChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UsageStateChange.Marshal(b, m, deterministic)
}
func (m *UsageStateChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UsageStateChange.Merge(m, src)
}
func (m *UsageStateChange) XXX_Size() int {
	return xxx_messageInfo_UsageStateChange.Size(m)
}
func (m *UsageStateChange) XXX_DiscardUnknown() {
	xxx_messageInfo_UsageStateChange.DiscardUnknown(m)
}

var xxx_messageInfo_UsageStateChange proto.InternalMessageInfo

func (m *UsageStateChange) GetOld() ComponentUsageState {
	if m != nil {
		return m.Old
	}
	return ComponentUsageState_COMP_USAGE_STATE_UNDEFINED
}

func (m *UsageStateChange) GetNew() ComponentUsageState {
	if m != nil {
		return m.New
	}
	return ComponentUsageState_COMP_USAGE_STATE_UNDEFINED
}

type StandbyStateChange struct {
	Old                  ComponentStandbyState `protobuf:"varint,1,opt,name=old,proto3,enum=dmi.ComponentStandbyState" json:"old,omitempty"`
	New                  ComponentStandbyState `protobuf:"varint,2,opt,name=new,proto3,enum=dmi.ComponentStandbyState" json:"new,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *StandbyStateChange) Reset()         { *m = StandbyStateChange{} }
func (m *StandbyStateChange) String() string { return proto.CompactTextString(m) }
func (*StandbyStateChange) ProtoMessage()    {}
func (*StandbyStateChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{14}
}

func (m *StandbyStateChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandbyStateChange.Unmarshal(m, b)
}
func (m *StandbyStateChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandbyStateChange.Marshal(b, m, deterministic)
}
func (m *StandbyStateChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandbyStateChange.Merge(m, src)
}
func (m *StandbyStateChange) XXX_Size() int {
	return xxx_messageInfo_StandbyStateChange.Size(m)
}
func (m *StandbyStateChange) XXX_DiscardUnknown() {
	xxx_messageInfo_StandbyStateChange.DiscardUnknown(m)
}

var xxx_messageInfo_StandbyStateChange proto.InternalMessageInfo

func (m *StandbyStateChange) GetOld() ComponentStandbyState {
	if m != nil {
		return m.Old
	}
	return ComponentStandbyState_COMP_STANDBY_STATE_UNDEFINED
}

func (m *StandbyStateChange) GetNew() ComponentStandbyState {
	if m != nil {
		return m.New
	}
	return ComponentStandbyState_COMP_STANDBY_STATE_UNDEFINED
}

type StateChangeInfo struct {
	// Types that are valid to be assigned to StateChange:
	//	*StateChangeInfo_AdminStateChange
	//	*StateChangeInfo_OperStateChange
	//	*StateChangeInfo_AlarmStateChange
	//	*StateChangeInfo_UsageStateChange
	//	*StateChangeInfo_StandbyStateChange
	StateChange          isStateChangeInfo_StateChange `protobuf_oneof:"state_change"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *StateChangeInfo) Reset()         { *m = StateChangeInfo{} }
func (m *StateChangeInfo) String() string { return proto.CompactTextString(m) }
func (*StateChangeInfo) ProtoMessage()    {}
func (*StateChangeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{15}
}

func (m *StateChangeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateChangeInfo.Unmarshal(m, b)
}
func (m *StateChangeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateChangeInfo.Marshal(b, m, deterministic)
}
func (m *StateChangeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateChangeInfo.Merge(m, src)
}
func (m *StateChangeInfo) XXX_Size() int {
	return xxx_messageInfo_StateChangeInfo.Size(m)
}
func (m *StateChangeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_StateChangeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_StateChangeInfo proto.InternalMessageInfo

type isStateChangeInfo_StateChange interface {
	isStateChangeInfo_StateChange()
}

type StateChangeInfo_AdminStateChange struct {
	AdminStateChange *AdminStateChange `protobuf:"bytes,1,opt,name=admin_state_change,json=adminStateChange,proto3,oneof"`
}

type StateChangeInfo_OperStateChange struct {
	OperStateChange *OperStateChange `protobuf:"bytes,2,opt,name=oper_state_change,json=operStateChange,proto3,oneof"`
}

type StateChangeInfo_AlarmStateChange struct {
	AlarmStateChange *AlarmStateChange `protobuf:"bytes,3,opt,name=alarm_state_change,json=alarmStateChange,proto3,oneof"`
}

type StateChangeInfo_UsageStateChange struct {
	UsageStateChange *UsageStateChange `protobuf:"bytes,4,opt,name=usage_state_change,json=usageStateChange,proto3,oneof"`
}

type StateChangeInfo_StandbyStateChange struct {
	StandbyStateChange *StandbyStateChange `protobuf:"bytes,5,opt,name=standby_state_change,json=standbyStateChange,proto3,oneof"`
}

func (*StateChangeInfo_AdminStateChange) isStateChangeInfo_StateChange() {}

func (*StateChangeInfo_OperStateChange) isStateChangeInfo_StateChange() {}

func (*StateChangeInfo_AlarmStateChange) isStateChangeInfo_StateChange() {}

func (*StateChangeInfo_UsageStateChange) isStateChangeInfo_StateChange() {}

func (*StateChangeInfo_StandbyStateChange) isStateChangeInfo_StateChange() {}

func (m *StateChangeInfo) GetStateChange() isStateChangeInfo_StateChange {
	if m != nil {
		return m.StateChange
	}
	return nil
}

func (m *StateChangeInfo) GetAdminStateChange() *AdminStateChange {
	if x, ok := m.GetStateChange().(*StateChangeInfo_AdminStateChange); ok {
		return x.AdminStateChange
	}
	return nil
}

func (m *StateChangeInfo) GetOperStateChange() *OperStateChange {
	if x, ok := m.GetStateChange().(*StateChangeInfo_OperStateChange); ok {
		return x.OperStateChange
	}
	return nil
}

func (m *StateChangeInfo) GetAlarmStateChange() *AlarmStateChange {
	if x, ok := m.GetStateChange().(*StateChangeInfo_AlarmStateChange); ok {
		return x.AlarmStateChange
	}
	return nil
}

func (m *StateChangeInfo) GetUsageStateChange() *UsageStateChange {
	if x, ok := m.GetStateChange().(*StateChangeInfo_UsageStateChange); ok {
		return x.UsageStateChange
	}
	return nil
}

func (m *StateChangeInfo) GetStandbyStateChange() *StandbyStateChange {
	if x, ok := m.GetStateChange().(*StateChangeInfo_StandbyStateChange); ok {
		return x.StandbyStateChange
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StateChangeInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StateChangeInfo_AdminStateChange)(nil),
		(*StateChangeInfo_OperStateChange)(nil),
		(*StateChangeInfo_AlarmStateChange)(nil),
		(*StateChangeInfo_UsageStateChange)(nil),
		(*StateChangeInfo_StandbyStateChange)(nil),
	}
}

type GenericEventInfo struct {
	Message              string                         `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	MessageCode          string                         `protobuf:"bytes,2,opt,name=message_code,json=messageCode,proto3" json:"message_code,omitempty"`
	Severity             GenericEventInfo_EventSeverity `protobuf:"varint,3,opt,name=severity,proto3,enum=dmi.GenericEventInfo_EventSeverity" json:"severity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *GenericEventInfo) Reset()         { *m = GenericEventInfo{} }
func (m *GenericEventInfo) String() string { return proto.CompactTextString(m) }
func (*GenericEventInfo) ProtoMessage()    {}
func (*GenericEventInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{16}
}

func (m *GenericEventInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenericEventInfo.Unmarshal(m, b)
}
func (m *GenericEventInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenericEventInfo.Marshal(b, m, deterministic)
}
func (m *GenericEventInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenericEventInfo.Merge(m, src)
}
func (m *GenericEventInfo) XXX_Size() int {
	return xxx_messageInfo_GenericEventInfo.Size(m)
}
func (m *GenericEventInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GenericEventInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GenericEventInfo proto.InternalMessageInfo

func (m *GenericEventInfo) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *GenericEventInfo) GetMessageCode() string {
	if m != nil {
		return m.MessageCode
	}
	return ""
}

func (m *GenericEventInfo) GetSeverity() GenericEventInfo_EventSeverity {
	if m != nil {
		return m.Severity
	}
	return GenericEventInfo_EVENT_SEVERITY_UNSPECIFIED
}

type Event struct {
	EventMetadata *EventMetaData       `protobuf:"bytes,1,opt,name=event_metadata,json=eventMetadata,proto3" json:"event_metadata,omitempty"`
	EventId       EventIds             `protobuf:"varint,2,opt,name=event_id,json=eventId,proto3,enum=dmi.EventIds" json:"event_id,omitempty"`
	RaisedTs      *timestamp.Timestamp `protobuf:"bytes,3,opt,name=raised_ts,json=raisedTs,proto3" json:"raised_ts,omitempty"`
	// Optional threshold information for an event
	ThresholdInfo *ThresholdInformation `protobuf:"bytes,4,opt,name=threshold_info,json=thresholdInfo,proto3" json:"threshold_info,omitempty"`
	// Any additional info regarding the event
	AddInfo              string            `protobuf:"bytes,5,opt,name=add_info,json=addInfo,proto3" json:"add_info,omitempty"`
	StateChangeInfo      *StateChangeInfo  `protobuf:"bytes,6,opt,name=state_change_info,json=stateChangeInfo,proto3" json:"state_change_info,omitempty"`
	GenericEventInfo     *GenericEventInfo `protobuf:"bytes,7,opt,name=generic_event_info,json=genericEventInfo,proto3" json:"generic_event_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{17}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetEventMetadata() *EventMetaData {
	if m != nil {
		return m.EventMetadata
	}
	return nil
}

func (m *Event) GetEventId() EventIds {
	if m != nil {
		return m.EventId
	}
	return EventIds_EVENT_NAME_UNDEFINED
}

func (m *Event) GetRaisedTs() *timestamp.Timestamp {
	if m != nil {
		return m.RaisedTs
	}
	return nil
}

func (m *Event) GetThresholdInfo() *ThresholdInformation {
	if m != nil {
		return m.ThresholdInfo
	}
	return nil
}

func (m *Event) GetAddInfo() string {
	if m != nil {
		return m.AddInfo
	}
	return ""
}

func (m *Event) GetStateChangeInfo() *StateChangeInfo {
	if m != nil {
		return m.StateChangeInfo
	}
	return nil
}

func (m *Event) GetGenericEventInfo() *GenericEventInfo {
	if m != nil {
		return m.GenericEventInfo
	}
	return nil
}

func init() {
	proto.RegisterEnum("dmi.EventIds", EventIds_name, EventIds_value)
	proto.RegisterEnum("dmi.ListEventsResponse_Reason", ListEventsResponse_Reason_name, ListEventsResponse_Reason_value)
	proto.RegisterEnum("dmi.EventsConfigurationResponse_Reason", EventsConfigurationResponse_Reason_name, EventsConfigurationResponse_Reason_value)
	proto.RegisterEnum("dmi.GenericEventInfo_EventSeverity", GenericEventInfo_EventSeverity_name, GenericEventInfo_EventSeverity_value)
	proto.RegisterType((*ValueType)(nil), "dmi.ValueType")
	proto.RegisterType((*WaterMarks)(nil), "dmi.WaterMarks")
	proto.RegisterType((*Thresholds)(nil), "dmi.Thresholds")
	proto.RegisterType((*ThresholdInformation)(nil), "dmi.ThresholdInformation")
	proto.RegisterType((*EventCfg)(nil), "dmi.EventCfg")
	proto.RegisterType((*EventsCfg)(nil), "dmi.EventsCfg")
	proto.RegisterType((*ListEventsResponse)(nil), "dmi.ListEventsResponse")
	proto.RegisterType((*EventsConfigurationRequest)(nil), "dmi.EventsConfigurationRequest")
	proto.RegisterType((*EventsConfigurationResponse)(nil), "dmi.EventsConfigurationResponse")
	proto.RegisterType((*EventMetaData)(nil), "dmi.EventMetaData")
	proto.RegisterType((*AdminStateChange)(nil), "dmi.AdminStateChange")
	proto.RegisterType((*OperStateChange)(nil), "dmi.OperStateChange")
	proto.RegisterType((*AlarmStateChange)(nil), "dmi.AlarmStateChange")
	proto.RegisterType((*UsageStateChange)(nil), "dmi.UsageStateChange")
	proto.RegisterType((*StandbyStateChange)(nil), "dmi.StandbyStateChange")
	proto.RegisterType((*StateChangeInfo)(nil), "dmi.StateChangeInfo")
	proto.RegisterType((*GenericEventInfo)(nil), "dmi.GenericEventInfo")
	proto.RegisterType((*Event)(nil), "dmi.Event")
}

func init() { proto.RegisterFile("dmi/hw_events_mgmt_service.proto", fileDescriptor_8962d785556e9979) }

var fileDescriptor_8962d785556e9979 = []byte{
	// 2184 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x5b, 0x73, 0xdb, 0xc6,
	0x15, 0x16, 0x05, 0x51, 0x12, 0x8f, 0x24, 0x1a, 0xde, 0x51, 0x6c, 0x59, 0xae, 0x6d, 0x85, 0x4e,
	0x62, 0x59, 0xb5, 0x49, 0x47, 0x76, 0xed, 0x7a, 0xf2, 0x90, 0x40, 0x20, 0x24, 0xa2, 0x26, 0x01,
	0xcd, 0x12, 0xa4, 0xea, 0x3e, 0x04, 0x03, 0x0b, 0x4b, 0x0a, 0x31, 0x01, 0x30, 0x00, 0x28, 0x55,
	0xed, 0x4c, 0xa7, 0x7d, 0xea, 0xf4, 0xad, 0x97, 0xf4, 0xa9, 0x9d, 0xfe, 0x82, 0xa6, 0xfd, 0x03,
	0xe9, 0xed, 0xad, 0x97, 0x3f, 0xd0, 0xfc, 0x88, 0xbe, 0xf5, 0x9e, 0xde, 0x06, 0xbb, 0x20, 0x01,
	0x82, 0x37, 0x79, 0xa6, 0x6f, 0xc4, 0x39, 0xdf, 0xf9, 0xbe, 0xb3, 0x7b, 0xce, 0x5e, 0xb8, 0xb0,
	0x65, 0xda, 0x56, 0xe9, 0xe4, 0x4c, 0x27, 0xa7, 0xc4, 0x09, 0x7c, 0xdd, 0x6e, 0xdb, 0x81, 0xee,
	0x13, 0xef, 0xd4, 0x3a, 0x26, 0xc5, 0xae, 0xe7, 0x06, 0x2e, 0xe2, 0x4c, 0xdb, 0xda, 0xbc, 0x1c,
	0xc2, 0x8e, 0x5d, 0xdb, 0x76, 0x1d, 0x9f, 0xd9, 0x37, 0x57, 0x59, 0x64, 0xf4, 0x75, 0xab, 0xed,
	0xba, 0xed, 0x0e, 0x29, 0xd1, 0xaf, 0x17, 0xbd, 0x56, 0x29, 0xb0, 0x6c, 0xe2, 0x07, 0x86, 0xdd,
	0x8d, 0x00, 0xd7, 0xd3, 0x00, 0x62, 0x77, 0x83, 0x73, 0xe6, 0x2c, 0xfc, 0x28, 0x03, 0xb9, 0xa6,
	0xd1, 0xe9, 0x11, 0xed, 0xbc, 0x4b, 0xd0, 0x35, 0x58, 0xb2, 0x9c, 0x40, 0x3f, 0x35, 0x3a, 0x1b,
	0x99, 0xad, 0xcc, 0x36, 0x57, 0x99, 0xc3, 0x8b, 0x96, 0x13, 0x34, 0x8d, 0x0e, 0xba, 0x0e, 0xcb,
	0xbd, 0xbe, 0x6f, 0x7e, 0x2b, 0xb3, 0xbd, 0x50, 0x99, 0xc3, 0x4b, 0xbd, 0xc8, 0x79, 0x03, 0x72,
	0xad, 0x8e, 0x6b, 0x30, 0x2f, 0xb7, 0x95, 0xd9, 0x9e, 0xaf, 0xcc, 0xe1, 0x65, 0x6a, 0x0a, 0xdd,
	0x0f, 0x20, 0x17, 0x9c, 0x77, 0x89, 0xda, 0x6a, 0x1a, 0x9d, 0x8d, 0x85, 0xad, 0xcc, 0x76, 0x7e,
	0x17, 0x15, 0x4d, 0xdb, 0x2a, 0x96, 0x8d, 0xc0, 0x18, 0xa8, 0xe3, 0x18, 0xb4, 0x97, 0x05, 0xee,
	0xd4, 0xe8, 0x14, 0x30, 0xc0, 0x91, 0x11, 0x10, 0xaf, 0x66, 0x78, 0x2f, 0x7d, 0x54, 0x80, 0x85,
	0x13, 0xab, 0x7d, 0x42, 0x53, 0x5b, 0xd9, 0xcd, 0x53, 0x86, 0x38, 0x9a, 0xfa, 0xd0, 0x16, 0x70,
	0x1d, 0xf7, 0x8c, 0x66, 0x38, 0x0a, 0x09, 0x5d, 0x85, 0x97, 0x00, 0xda, 0x89, 0x47, 0xfc, 0x13,
	0xb7, 0x63, 0xfa, 0xe8, 0x0e, 0x64, 0x7b, 0xdd, 0x2e, 0xf1, 0x22, 0xd2, 0x4b, 0x34, 0x22, 0xd6,
	0xac, 0xcc, 0x61, 0xe6, 0x0f, 0x81, 0x1d, 0xf7, 0x8c, 0x78, 0x11, 0xf5, 0x38, 0x20, 0xf5, 0xef,
	0xad, 0x40, 0x2e, 0xe8, 0xf3, 0x17, 0xbe, 0x01, 0xeb, 0x03, 0x31, 0xd9, 0x69, 0xb9, 0x9e, 0x6d,
	0x04, 0x96, 0xeb, 0xa0, 0x2f, 0x40, 0xde, 0x7d, 0x11, 0x56, 0x9b, 0x98, 0xe1, 0x9c, 0xf5, 0xc8,
	0x84, 0x41, 0xad, 0xf5, 0x51, 0xd4, 0x84, 0x4a, 0x00, 0x03, 0x6e, 0x7f, 0x28, 0x93, 0x78, 0x48,
	0x38, 0x01, 0x29, 0x7c, 0x92, 0x81, 0x65, 0x29, 0x6c, 0x30, 0xb1, 0xd5, 0x46, 0xdb, 0xb0, 0x4c,
	0x9b, 0x4d, 0xb7, 0x4c, 0x2a, 0x97, 0xdf, 0x5d, 0xa3, 0xb1, 0x14, 0x20, 0x9b, 0x3e, 0x5e, 0x22,
	0xec, 0x17, 0xba, 0x0d, 0x6b, 0x96, 0xaf, 0x1f, 0xbb, 0x4e, 0xcb, 0x6a, 0xf7, 0x3c, 0x62, 0x52,
	0xa9, 0x65, 0xbc, 0x6a, 0xf9, 0xe2, 0xc0, 0x96, 0x4a, 0x86, 0x9b, 0x99, 0x0c, 0x7a, 0x00, 0xf9,
	0x63, 0xd7, 0xee, 0xba, 0x4e, 0x98, 0x43, 0xaf, 0x67, 0x99, 0xb4, 0x17, 0x56, 0x76, 0x73, 0x34,
	0xa8, 0xd1, 0xb3, 0x4c, 0xbc, 0x36, 0x00, 0x84, 0x9f, 0x85, 0x07, 0x90, 0xa3, 0xc9, 0xf9, 0x61,
	0xfa, 0xb7, 0x21, 0x6b, 0x05, 0xc4, 0xf6, 0x37, 0x32, 0x5b, 0xdc, 0xf6, 0x4a, 0x32, 0x77, 0xb1,
	0xd5, 0xc6, 0xcc, 0x57, 0xf8, 0xc9, 0x3c, 0xa0, 0xaa, 0xe5, 0x07, 0x2c, 0x0c, 0x13, 0xbf, 0xeb,
	0x3a, 0x3e, 0x41, 0xb7, 0x61, 0xd1, 0x0f, 0x8c, 0xa0, 0xe7, 0x47, 0x03, 0x5f, 0xa1, 0xc1, 0x75,
	0x6a, 0xc2, 0x91, 0x0b, 0x3d, 0x86, 0x45, 0x8f, 0x18, 0xbe, 0xeb, 0xd0, 0xe1, 0xe6, 0x77, 0x6f,
	0x52, 0xd0, 0x28, 0x5b, 0x11, 0x53, 0x14, 0x8e, 0xd0, 0xe8, 0x2d, 0x58, 0x64, 0x8b, 0x38, 0x9a,
	0x84, 0x7c, 0x9c, 0x59, 0x98, 0x38, 0x8e, 0xbc, 0xe1, 0xac, 0xb2, 0x08, 0xdd, 0x24, 0x81, 0x61,
	0xb1, 0xa5, 0x90, 0xc3, 0xab, 0xcc, 0x58, 0xa6, 0xb6, 0xc2, 0xfb, 0xb0, 0xc8, 0xe8, 0xd1, 0x3a,
	0xf0, 0x0d, 0xa5, 0x2c, 0xed, 0xcb, 0x8a, 0x54, 0xd6, 0xb1, 0x24, 0xd4, 0x55, 0x85, 0x9f, 0x43,
	0x08, 0xf2, 0x0d, 0xe5, 0x99, 0xa2, 0x1e, 0x29, 0x7a, 0x59, 0x6a, 0xca, 0xa2, 0xc4, 0x67, 0x42,
	0x9b, 0xac, 0x68, 0x12, 0x56, 0x84, 0xaa, 0x2e, 0x61, 0xac, 0x62, 0x7e, 0x1e, 0x5d, 0x01, 0xc4,
	0xfc, 0x7a, 0x43, 0xc1, 0x92, 0x20, 0x56, 0x84, 0xbd, 0xaa, 0xc4, 0x73, 0x85, 0x8f, 0x33, 0xb0,
	0x19, 0xa5, 0x16, 0x95, 0x92, 0x76, 0x24, 0x26, 0x1f, 0xf6, 0x88, 0x1f, 0xa0, 0x1d, 0x58, 0x31,
	0x49, 0xb8, 0x07, 0xb1, 0x02, 0x65, 0xd2, 0x05, 0x02, 0xe6, 0x0d, 0x7f, 0xa3, 0x1d, 0x58, 0x3a,
	0x3e, 0x31, 0x9c, 0x36, 0xf1, 0x87, 0xd6, 0xdb, 0x60, 0xe0, 0xe1, 0x0e, 0x11, 0x01, 0xd0, 0x0e,
	0xf0, 0x1e, 0xf1, 0x49, 0xa0, 0x07, 0xae, 0x6e, 0x92, 0x96, 0xd1, 0xeb, 0x04, 0x74, 0xb6, 0x96,
	0x2b, 0x73, 0x38, 0x4f, 0x3d, 0x9a, 0x5b, 0x66, 0xf6, 0x70, 0x05, 0xb9, 0x5d, 0xc2, 0xf2, 0x2a,
	0xfc, 0x78, 0x1e, 0xae, 0x8f, 0xcd, 0xf7, 0x55, 0x2a, 0xfb, 0x6e, 0xaa, 0xb2, 0x77, 0x92, 0x89,
	0x8e, 0xa3, 0x4d, 0x97, 0x78, 0xa4, 0x74, 0xdc, 0x98, 0xd2, 0x79, 0xff, 0xa7, 0xd2, 0x51, 0x5b,
	0x53, 0xa8, 0xca, 0x65, 0x5d, 0x54, 0x95, 0x7d, 0xf9, 0x80, 0xe7, 0x26, 0x94, 0x73, 0xa1, 0xf0,
	0x51, 0x06, 0xd6, 0xe8, 0x38, 0x6a, 0x24, 0x30, 0xc2, 0xed, 0xf4, 0x95, 0x2a, 0x38, 0xba, 0x22,
	0xe7, 0xa7, 0xaf, 0x48, 0xf4, 0x66, 0x32, 0xc2, 0x31, 0x6c, 0x12, 0xcd, 0x44, 0x0c, 0x53, 0x0c,
	0x9b, 0x14, 0x3e, 0x00, 0x5e, 0x30, 0x6d, 0xcb, 0x09, 0xeb, 0x40, 0x44, 0xda, 0x03, 0x68, 0x07,
	0x38, 0xb7, 0xd3, 0xdf, 0x79, 0x36, 0xa8, 0x82, 0xd8, 0x0f, 0x8a, 0xc1, 0x38, 0x04, 0x85, 0x58,
	0x87, 0x9c, 0x45, 0xd5, 0x9a, 0x82, 0x75, 0xc8, 0x59, 0xa1, 0x0d, 0x97, 0xd4, 0x2e, 0xf1, 0x92,
	0x52, 0x77, 0x93, 0x52, 0x57, 0x87, 0xc3, 0x07, 0x58, 0xa6, 0x74, 0x37, 0xa9, 0x34, 0x19, 0x1a,
	0x0a, 0x85, 0x83, 0xea, 0x18, 0x9e, 0x7d, 0xe1, 0x41, 0x0d, 0xc0, 0x17, 0x18, 0x54, 0x02, 0x1b,
	0x69, 0x35, 0x7c, 0xa3, 0x4d, 0x2e, 0xaa, 0x15, 0x83, 0x67, 0x6b, 0x25, 0xb1, 0xa1, 0x56, 0x17,
	0x50, 0x3d, 0x30, 0x1c, 0xf3, 0xc5, 0x79, 0x52, 0xed, 0x5e, 0x52, 0x6d, 0x73, 0x98, 0x21, 0x09,
	0x67, 0x7a, 0xf7, 0x92, 0x7a, 0x53, 0xd1, 0xa1, 0xe2, 0xb7, 0x39, 0xb8, 0x94, 0xd0, 0x0a, 0x4f,
	0x46, 0x24, 0x01, 0x32, 0xc2, 0xca, 0xea, 0xe1, 0x9a, 0x25, 0x3a, 0xdb, 0x38, 0xa2, 0xf6, 0x7d,
	0x8d, 0x12, 0xa6, 0x3b, 0xaa, 0x32, 0x87, 0x79, 0x23, 0xdd, 0x65, 0x7b, 0x70, 0x39, 0xdc, 0x3c,
	0x86, 0x59, 0x58, 0x57, 0xaf, 0x53, 0x96, 0x54, 0xaf, 0x54, 0xe6, 0xf0, 0x25, 0x37, 0xd5, 0x3e,
	0x61, 0x2a, 0x61, 0x3d, 0x86, 0x49, 0xb8, 0x64, 0x2a, 0xa9, 0x3e, 0xa0, 0xa9, 0xa4, 0x7b, 0x43,
	0x02, 0xd4, 0x0b, 0xa7, 0x7a, 0x98, 0x66, 0x21, 0x41, 0x93, 0x2e, 0x71, 0x48, 0xd3, 0x4b, 0x97,
	0xfd, 0x19, 0xac, 0xfb, 0x6c, 0x06, 0x87, 0x89, 0xb2, 0x94, 0xe8, 0x6a, 0x7f, 0xbf, 0x4b, 0xd5,
	0xaf, 0x32, 0x87, 0x91, 0x3f, 0x62, 0xdd, 0xcb, 0xc3, 0x6a, 0x92, 0xa4, 0xf0, 0x59, 0x06, 0xf8,
	0x03, 0xe2, 0x10, 0xcf, 0x3a, 0x66, 0xd7, 0x80, 0xb0, 0x14, 0x1b, 0xb0, 0x64, 0x13, 0x3f, 0xcc,
	0x83, 0xce, 0x7f, 0x0e, 0xf7, 0x3f, 0xd1, 0xeb, 0xb0, 0x1a, 0xfd, 0xd4, 0x8f, 0x5d, 0x93, 0x4d,
	0x6c, 0x0e, 0xaf, 0x44, 0x36, 0xd1, 0x35, 0x09, 0x7a, 0x17, 0x96, 0x7d, 0x72, 0x4a, 0x3c, 0x2b,
	0x38, 0xa7, 0x53, 0x96, 0xdf, 0xbd, 0x4d, 0x53, 0x4c, 0xab, 0xb0, 0xed, 0xb7, 0x1e, 0x41, 0xf1,
	0x20, 0xa8, 0x60, 0x45, 0x3b, 0x5a, 0xdf, 0x85, 0x6e, 0xc2, 0xa6, 0xd4, 0x94, 0x14, 0x4d, 0xaf,
	0x4b, 0x4d, 0x09, 0xcb, 0xda, 0x73, 0xbd, 0xa1, 0xd4, 0x0f, 0x25, 0x51, 0xde, 0x97, 0xa5, 0x32,
	0x3f, 0x87, 0x56, 0x61, 0x59, 0xc4, 0xb2, 0x26, 0x8b, 0x42, 0x95, 0xcf, 0xa0, 0x1c, 0x64, 0x6b,
	0xc2, 0x97, 0xe8, 0x46, 0x1a, 0xfe, 0x94, 0x15, 0x15, 0xf3, 0x1c, 0x02, 0x58, 0x54, 0x54, 0x5c,
	0x13, 0xaa, 0xfc, 0x02, 0x5a, 0x86, 0x05, 0x59, 0xd9, 0x57, 0xf9, 0x6c, 0xe1, 0x3b, 0x1c, 0x64,
	0xa9, 0x16, 0x7a, 0x0a, 0x79, 0x76, 0x37, 0xb2, 0x49, 0x60, 0x98, 0x46, 0x60, 0x44, 0x9d, 0x87,
	0xe2, 0x93, 0xa2, 0xbf, 0xc3, 0xe2, 0x35, 0xd2, 0xff, 0x0c, 0x81, 0x43, 0xd7, 0xaa, 0xf9, 0xa9,
	0xd7, 0xaa, 0x27, 0x90, 0xf3, 0x0c, 0xcb, 0x27, 0xa6, 0x3e, 0xb8, 0x2b, 0x6c, 0x16, 0xd9, 0xed,
	0xbc, 0xd8, 0xbf, 0x9d, 0x17, 0xb5, 0xfe, 0xf5, 0x1d, 0x2f, 0x33, 0xb0, 0xe6, 0xa3, 0xf7, 0x20,
	0x3f, 0xb8, 0x47, 0xe9, 0x96, 0xd3, 0x72, 0xa3, 0x2e, 0xba, 0x36, 0x7c, 0xdd, 0x4a, 0xdc, 0x30,
	0xf1, 0x5a, 0x90, 0xb4, 0xa2, 0x6b, 0xb0, 0x6c, 0x98, 0x51, 0x6c, 0x96, 0xd5, 0xd4, 0x30, 0x99,
	0xeb, 0x3d, 0xb8, 0x9c, 0x6c, 0x09, 0x86, 0x59, 0x4c, 0xac, 0x98, 0xd4, 0x4a, 0xc5, 0x97, 0xfc,
	0xd4, 0xd2, 0x15, 0x01, 0xb5, 0x59, 0x75, 0xf5, 0x68, 0x26, 0x42, 0x8a, 0xa5, 0x44, 0xa3, 0xa7,
	0x8b, 0x8f, 0xf9, 0x76, 0xca, 0xb2, 0xf3, 0xe9, 0x7a, 0x74, 0x55, 0x95, 0x4d, 0x1f, 0x6d, 0xc0,
	0x3a, 0x2b, 0xb9, 0x22, 0xd4, 0xc2, 0x23, 0x2f, 0x3a, 0x4b, 0xf9, 0xb9, 0xb8, 0x19, 0x34, 0x2c,
	0x28, 0x75, 0x51, 0x92, 0x9b, 0x12, 0xd6, 0x0f, 0xab, 0x8d, 0x03, 0x5d, 0x6d, 0x68, 0xbc, 0x89,
	0x6e, 0xc0, 0xb5, 0x09, 0x7e, 0x59, 0xe1, 0x09, 0xba, 0x0f, 0x77, 0x47, 0xdd, 0x4d, 0xb5, 0xaa,
	0x09, 0x07, 0x92, 0x2e, 0xec, 0xa9, 0x4d, 0x49, 0xd7, 0x2a, 0x58, 0xaa, 0x57, 0xd4, 0x6a, 0x99,
	0x6f, 0x4d, 0x87, 0xef, 0x49, 0x55, 0xf5, 0x28, 0x01, 0x6f, 0xa3, 0xb7, 0xe1, 0xfe, 0x28, 0x5c,
	0x93, 0x6a, 0x87, 0x12, 0x16, 0xb4, 0x06, 0x1e, 0x55, 0x38, 0x99, 0x1d, 0x92, 0x56, 0xb1, 0xc6,
	0x27, 0x25, 0x36, 0x30, 0x0e, 0x6d, 0x69, 0x85, 0x0f, 0xa6, 0xc3, 0xd3, 0xec, 0x2f, 0x51, 0x11,
	0x76, 0x46, 0xe1, 0xf8, 0xcb, 0xfa, 0xa1, 0x7a, 0x24, 0xe1, 0x11, 0xfa, 0xce, 0x0c, 0x7c, 0x9a,
	0xdf, 0x1e, 0x8f, 0xd7, 0x26, 0xf1, 0x3b, 0x33, 0xf0, 0x69, 0x7e, 0x77, 0x7c, 0x03, 0xec, 0x0b,
	0x72, 0xb5, 0x81, 0x25, 0xbe, 0x8b, 0x9e, 0xc0, 0xc3, 0x0b, 0x37, 0x80, 0x8e, 0x25, 0x51, 0x6d,
	0x4a, 0x58, 0x2a, 0xf3, 0x1f, 0x4e, 0x0f, 0x4c, 0xa5, 0x91, 0x08, 0xf4, 0xd0, 0x3b, 0xf0, 0xe4,
	0x95, 0x9a, 0x22, 0x11, 0xec, 0xcf, 0x0e, 0x9e, 0xac, 0x1c, 0x8c, 0x4f, 0x79, 0x42, 0xa3, 0x24,
	0x02, 0x7b, 0xd3, 0x03, 0x27, 0x2b, 0x9e, 0xa2, 0x2f, 0xc2, 0xa3, 0x8b, 0x37, 0x4f, 0x22, 0xf2,
	0x6c, 0x46, 0xe4, 0x64, 0xcd, 0xaf, 0x8e, 0x8f, 0xd4, 0x66, 0x6b, 0x9e, 0xcf, 0x88, 0x9c, 0xac,
	0xf9, 0x35, 0x74, 0x07, 0x6e, 0x4f, 0x6c, 0xb2, 0x04, 0xf0, 0xeb, 0xe8, 0x2a, 0x20, 0x06, 0x3c,
	0xac, 0x37, 0xe2, 0x6d, 0xea, 0xb7, 0x19, 0x74, 0x05, 0x2e, 0xa7, 0x1c, 0xb2, 0xc2, 0xff, 0x2e,
	0x65, 0xef, 0xb7, 0xed, 0xef, 0x33, 0x68, 0x0b, 0xae, 0x8f, 0xd8, 0x13, 0x4a, 0x7f, 0x48, 0x44,
	0xee, 0x0b, 0xca, 0x20, 0xf2, 0xa7, 0xf3, 0x71, 0x0a, 0xa1, 0x7d, 0x90, 0xc2, 0xc7, 0xf3, 0xc3,
	0x01, 0xfd, 0x14, 0x7e, 0x36, 0x1f, 0x4b, 0x25, 0x88, 0x12, 0x52, 0x3f, 0x9f, 0x47, 0x77, 0xe1,
	0x0d, 0x86, 0x10, 0x0f, 0x1b, 0x63, 0x5a, 0x79, 0x70, 0x1a, 0x7f, 0x97, 0x43, 0x6f, 0xc1, 0xeb,
	0xd3, 0xa0, 0xfb, 0x82, 0x26, 0x54, 0xf9, 0xef, 0x71, 0xe8, 0x21, 0x14, 0x2f, 0x42, 0x99, 0xc8,
	0xe3, 0xfb, 0x1c, 0x7a, 0x00, 0x9f, 0x9f, 0x49, 0x9e, 0x88, 0xf8, 0x01, 0x87, 0xde, 0x80, 0x5b,
	0x71, 0x44, 0xa3, 0x3e, 0x6e, 0xd7, 0xff, 0x88, 0x43, 0xc5, 0xfe, 0x96, 0x39, 0x11, 0x95, 0x60,
	0xfd, 0x21, 0x87, 0x36, 0xe1, 0x35, 0x86, 0xaf, 0x1c, 0x45, 0x7f, 0xed, 0x74, 0x2c, 0xd5, 0x25,
	0x8d, 0xff, 0x33, 0x87, 0x4a, 0xfd, 0xfd, 0x2b, 0xf6, 0x4d, 0x99, 0xb1, 0xbf, 0x70, 0xe8, 0x1e,
	0xdc, 0x99, 0x1d, 0xc0, 0xe6, 0xed, 0xaf, 0x1c, 0x7a, 0xda, 0xef, 0xe1, 0x8b, 0xd0, 0x27, 0xb2,
	0xfe, 0x1b, 0x87, 0x1e, 0xc3, 0xdb, 0x17, 0x14, 0x4a, 0xc4, 0xfd, 0x9d, 0x43, 0xd7, 0xe1, 0xca,
	0xe8, 0x68, 0xf7, 0x54, 0x55, 0xe3, 0xff, 0xc1, 0xa1, 0x3b, 0x50, 0x18, 0x38, 0x93, 0x6c, 0x75,
	0x49, 0xa9, 0xab, 0x6c, 0x8d, 0x48, 0x65, 0xfe, 0x9f, 0xc3, 0xc3, 0x14, 0xaa, 0xd5, 0x31, 0xe0,
	0x7a, 0x1f, 0xfd, 0x19, 0x87, 0xb6, 0xfb, 0x0b, 0x2e, 0xd4, 0x94, 0xeb, 0xcf, 0x26, 0xd4, 0xee,
	0x5f, 0x1c, 0xda, 0xed, 0x1f, 0xa8, 0x53, 0x91, 0x89, 0x11, 0xfd, 0x9b, 0x43, 0x3b, 0xf0, 0xe6,
	0x20, 0xa6, 0x26, 0xd5, 0x54, 0xfc, 0x7c, 0x02, 0xff, 0x7f, 0x38, 0xf4, 0x08, 0x4a, 0x17, 0xc2,
	0x26, 0x14, 0xfe, 0xcb, 0xa1, 0x9b, 0xfd, 0x53, 0xa9, 0x72, 0xa4, 0x2b, 0xda, 0xa1, 0x5e, 0x7f,
	0xae, 0x88, 0x83, 0x45, 0xfa, 0xcd, 0x85, 0xa1, 0xf1, 0xa5, 0xfd, 0x09, 0xa6, 0x6f, 0x2d, 0xa0,
	0x1b, 0xb0, 0xc1, 0x90, 0x55, 0x59, 0x91, 0x74, 0x51, 0xc0, 0xe5, 0x78, 0x51, 0xff, 0x71, 0x01,
	0x7d, 0x0e, 0xae, 0x8e, 0x75, 0xcb, 0x0a, 0xff, 0x69, 0x42, 0x46, 0x54, 0x6b, 0x87, 0xaa, 0x42,
	0xcf, 0x81, 0x72, 0x4d, 0x56, 0xf4, 0xba, 0x26, 0x68, 0x92, 0x2e, 0x56, 0x04, 0xe5, 0x40, 0x2a,
	0xf3, 0x9f, 0x64, 0xe3, 0x3a, 0xc6, 0x48, 0xf5, 0x50, 0xc2, 0x29, 0xe0, 0x2f, 0xb2, 0x63, 0x29,
	0xab, 0x02, 0xae, 0xa5, 0x90, 0xbf, 0x1c, 0x8b, 0x64, 0x33, 0x37, 0x8c, 0xfc, 0x55, 0x36, 0xae,
	0x47, 0x8c, 0xac, 0x6b, 0x82, 0x52, 0xde, 0x7b, 0x9e, 0xc2, 0xfe, 0x3a, 0x8b, 0x0a, 0x70, 0x23,
	0x8d, 0x3d, 0x90, 0x14, 0x09, 0xcb, 0xa2, 0x4e, 0xed, 0xfc, 0x6f, 0xb2, 0xbb, 0x7f, 0xca, 0xc0,
	0x0d, 0xc5, 0x08, 0xac, 0x53, 0xc2, 0xde, 0x7c, 0x6a, 0x86, 0x63, 0xb4, 0x89, 0x4d, 0xff, 0x64,
	0xd0, 0x17, 0x77, 0xf4, 0x18, 0x20, 0x7e, 0xe8, 0x43, 0xec, 0x19, 0xb3, 0x62, 0x78, 0xe6, 0x99,
	0xe1, 0x11, 0xb9, 0xbc, 0x79, 0x75, 0xc2, 0x53, 0x20, 0x7a, 0x1f, 0xae, 0x35, 0xba, 0xa6, 0x11,
	0x90, 0x31, 0x8f, 0x49, 0xe8, 0xd6, 0xe4, 0x67, 0x26, 0xfa, 0xda, 0xb6, 0xb9, 0x35, 0xeb, 0x1d,
	0x0a, 0x3d, 0x82, 0xd5, 0x7a, 0xe0, 0x11, 0xc3, 0x8e, 0x32, 0xbb, 0x32, 0xf2, 0x7f, 0x41, 0xb2,
	0xbb, 0xc1, 0xf9, 0x26, 0xc4, 0x4c, 0x0f, 0x32, 0x7b, 0xef, 0x7c, 0xe5, 0x69, 0xdb, 0x0a, 0x4e,
	0x7a, 0x2f, 0x8a, 0xc7, 0xae, 0x5d, 0x72, 0xbb, 0xc4, 0x39, 0x76, 0x3d, 0xb3, 0xc4, 0x5e, 0x7e,
	0xee, 0xdb, 0x83, 0xd1, 0xdf, 0xb7, 0x9c, 0x80, 0x78, 0x2d, 0xe3, 0x98, 0x94, 0x4e, 0x1f, 0x96,
	0xda, 0x6e, 0xc9, 0xb4, 0xad, 0x17, 0x8b, 0x94, 0xfa, 0xe1, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff,
	0x70, 0xec, 0xeb, 0x17, 0xa1, 0x18, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// NativeEventsManagementServiceClient is the client API for NativeEventsManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NativeEventsManagementServiceClient interface {
	// List the supported events for the passed device
	ListEvents(ctx context.Context, in *HardwareID, opts ...grpc.CallOption) (*ListEventsResponse, error)
	// Updates the configuration of the list of events in the request
	// The default behavior of the device is to report all the supported events
	// This configuration is persisted across reboots of the device or the device manager
	UpdateEventsConfiguration(ctx context.Context, in *EventsConfigurationRequest, opts ...grpc.CallOption) (*EventsConfigurationResponse, error)
	// Initiate the server streaming of the events
	StreamEvents(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (NativeEventsManagementService_StreamEventsClient, error)
}

type nativeEventsManagementServiceClient struct {
	cc *grpc.ClientConn
}

func NewNativeEventsManagementServiceClient(cc *grpc.ClientConn) NativeEventsManagementServiceClient {
	return &nativeEventsManagementServiceClient{cc}
}

func (c *nativeEventsManagementServiceClient) ListEvents(ctx context.Context, in *HardwareID, opts ...grpc.CallOption) (*ListEventsResponse, error) {
	out := new(ListEventsResponse)
	err := c.cc.Invoke(ctx, "/dmi.NativeEventsManagementService/ListEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nativeEventsManagementServiceClient) UpdateEventsConfiguration(ctx context.Context, in *EventsConfigurationRequest, opts ...grpc.CallOption) (*EventsConfigurationResponse, error) {
	out := new(EventsConfigurationResponse)
	err := c.cc.Invoke(ctx, "/dmi.NativeEventsManagementService/UpdateEventsConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nativeEventsManagementServiceClient) StreamEvents(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (NativeEventsManagementService_StreamEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_NativeEventsManagementService_serviceDesc.Streams[0], "/dmi.NativeEventsManagementService/StreamEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &nativeEventsManagementServiceStreamEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type NativeEventsManagementService_StreamEventsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type nativeEventsManagementServiceStreamEventsClient struct {
	grpc.ClientStream
}

func (x *nativeEventsManagementServiceStreamEventsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// NativeEventsManagementServiceServer is the server API for NativeEventsManagementService service.
type NativeEventsManagementServiceServer interface {
	// List the supported events for the passed device
	ListEvents(context.Context, *HardwareID) (*ListEventsResponse, error)
	// Updates the configuration of the list of events in the request
	// The default behavior of the device is to report all the supported events
	// This configuration is persisted across reboots of the device or the device manager
	UpdateEventsConfiguration(context.Context, *EventsConfigurationRequest) (*EventsConfigurationResponse, error)
	// Initiate the server streaming of the events
	StreamEvents(*empty.Empty, NativeEventsManagementService_StreamEventsServer) error
}

// UnimplementedNativeEventsManagementServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNativeEventsManagementServiceServer struct {
}

func (*UnimplementedNativeEventsManagementServiceServer) ListEvents(ctx context.Context, req *HardwareID) (*ListEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvents not implemented")
}
func (*UnimplementedNativeEventsManagementServiceServer) UpdateEventsConfiguration(ctx context.Context, req *EventsConfigurationRequest) (*EventsConfigurationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEventsConfiguration not implemented")
}
func (*UnimplementedNativeEventsManagementServiceServer) StreamEvents(req *empty.Empty, srv NativeEventsManagementService_StreamEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamEvents not implemented")
}

func RegisterNativeEventsManagementServiceServer(s *grpc.Server, srv NativeEventsManagementServiceServer) {
	s.RegisterService(&_NativeEventsManagementService_serviceDesc, srv)
}

func _NativeEventsManagementService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HardwareID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NativeEventsManagementServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dmi.NativeEventsManagementService/ListEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NativeEventsManagementServiceServer).ListEvents(ctx, req.(*HardwareID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NativeEventsManagementService_UpdateEventsConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventsConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NativeEventsManagementServiceServer).UpdateEventsConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dmi.NativeEventsManagementService/UpdateEventsConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NativeEventsManagementServiceServer).UpdateEventsConfiguration(ctx, req.(*EventsConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NativeEventsManagementService_StreamEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(empty.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(NativeEventsManagementServiceServer).StreamEvents(m, &nativeEventsManagementServiceStreamEventsServer{stream})
}

type NativeEventsManagementService_StreamEventsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type nativeEventsManagementServiceStreamEventsServer struct {
	grpc.ServerStream
}

func (x *nativeEventsManagementServiceStreamEventsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

var _NativeEventsManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "dmi.NativeEventsManagementService",
	HandlerType: (*NativeEventsManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEvents",
			Handler:    _NativeEventsManagementService_ListEvents_Handler,
		},
		{
			MethodName: "UpdateEventsConfiguration",
			Handler:    _NativeEventsManagementService_UpdateEventsConfiguration_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamEvents",
			Handler:       _NativeEventsManagementService_StreamEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "dmi/hw_events_mgmt_service.proto",
}
