// Code generated by protoc-gen-go. DO NOT EDIT.
// source: dmi/hw.proto

package dmi

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ComponentType int32

const (
	ComponentType_COMPONENT_TYPE_UNDEFINED    ComponentType = 0
	ComponentType_COMPONENT_TYPE_UNKNOWN      ComponentType = 1
	ComponentType_COMPONENT_TYPE_CHASSIS      ComponentType = 2
	ComponentType_COMPONENT_TYPE_BACKPLANE    ComponentType = 3
	ComponentType_COMPONENT_TYPE_CONTAINER    ComponentType = 4
	ComponentType_COMPONENT_TYPE_POWER_SUPPLY ComponentType = 5
	ComponentType_COMPONENT_TYPE_FAN          ComponentType = 6
	ComponentType_COMPONENT_TYPE_SENSOR       ComponentType = 7
	ComponentType_COMPONENT_TYPE_MODULE       ComponentType = 8
	ComponentType_COMPONENT_TYPE_PORT         ComponentType = 9
	ComponentType_COMPONENT_TYPE_CPU          ComponentType = 10
	ComponentType_COMPONENT_TYPE_BATTERY      ComponentType = 11
	ComponentType_COMPONENT_TYPE_STORAGE      ComponentType = 12
	ComponentType_COMPONENT_TYPE_MEMORY       ComponentType = 13
	// A component of type "TRANSCEIVER" could have 0 or more components of type "PORT" as children.
	ComponentType_COMPONENT_TYPE_TRANSCEIVER ComponentType = 14
)

var ComponentType_name = map[int32]string{
	0:  "COMPONENT_TYPE_UNDEFINED",
	1:  "COMPONENT_TYPE_UNKNOWN",
	2:  "COMPONENT_TYPE_CHASSIS",
	3:  "COMPONENT_TYPE_BACKPLANE",
	4:  "COMPONENT_TYPE_CONTAINER",
	5:  "COMPONENT_TYPE_POWER_SUPPLY",
	6:  "COMPONENT_TYPE_FAN",
	7:  "COMPONENT_TYPE_SENSOR",
	8:  "COMPONENT_TYPE_MODULE",
	9:  "COMPONENT_TYPE_PORT",
	10: "COMPONENT_TYPE_CPU",
	11: "COMPONENT_TYPE_BATTERY",
	12: "COMPONENT_TYPE_STORAGE",
	13: "COMPONENT_TYPE_MEMORY",
	14: "COMPONENT_TYPE_TRANSCEIVER",
}

var ComponentType_value = map[string]int32{
	"COMPONENT_TYPE_UNDEFINED":    0,
	"COMPONENT_TYPE_UNKNOWN":      1,
	"COMPONENT_TYPE_CHASSIS":      2,
	"COMPONENT_TYPE_BACKPLANE":    3,
	"COMPONENT_TYPE_CONTAINER":    4,
	"COMPONENT_TYPE_POWER_SUPPLY": 5,
	"COMPONENT_TYPE_FAN":          6,
	"COMPONENT_TYPE_SENSOR":       7,
	"COMPONENT_TYPE_MODULE":       8,
	"COMPONENT_TYPE_PORT":         9,
	"COMPONENT_TYPE_CPU":          10,
	"COMPONENT_TYPE_BATTERY":      11,
	"COMPONENT_TYPE_STORAGE":      12,
	"COMPONENT_TYPE_MEMORY":       13,
	"COMPONENT_TYPE_TRANSCEIVER":  14,
}

func (x ComponentType) String() string {
	return proto.EnumName(ComponentType_name, int32(x))
}

func (ComponentType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{0}
}

type ComponentAdminState int32

const (
	ComponentAdminState_COMP_ADMIN_STATE_UNDEFINED     ComponentAdminState = 0
	ComponentAdminState_COMP_ADMIN_STATE_UNKNOWN       ComponentAdminState = 1
	ComponentAdminState_COMP_ADMIN_STATE_LOCKED        ComponentAdminState = 2
	ComponentAdminState_COMP_ADMIN_STATE_SHUTTING_DOWN ComponentAdminState = 3
	ComponentAdminState_COMP_ADMIN_STATE_UNLOCKED      ComponentAdminState = 4
	// Indicates that the component is in a prohibited administrative state, meaning operations are not allowed.
	// Typically used to enforce security or policy restrictions.
	ComponentAdminState_COMP_ADMIN_STATE_ISOLATED ComponentAdminState = 6
	// Indicates that the component is administratively isolated from the rest of the system.
	// Used when a component must be separated for maintenance, troubleshooting, or security reasons.
	ComponentAdminState_COMP_ADMIN_STATE_PROHIBITED ComponentAdminState = 5
)

var ComponentAdminState_name = map[int32]string{
	0: "COMP_ADMIN_STATE_UNDEFINED",
	1: "COMP_ADMIN_STATE_UNKNOWN",
	2: "COMP_ADMIN_STATE_LOCKED",
	3: "COMP_ADMIN_STATE_SHUTTING_DOWN",
	4: "COMP_ADMIN_STATE_UNLOCKED",
	6: "COMP_ADMIN_STATE_ISOLATED",
	5: "COMP_ADMIN_STATE_PROHIBITED",
}

var ComponentAdminState_value = map[string]int32{
	"COMP_ADMIN_STATE_UNDEFINED":     0,
	"COMP_ADMIN_STATE_UNKNOWN":       1,
	"COMP_ADMIN_STATE_LOCKED":        2,
	"COMP_ADMIN_STATE_SHUTTING_DOWN": 3,
	"COMP_ADMIN_STATE_UNLOCKED":      4,
	"COMP_ADMIN_STATE_ISOLATED":      6,
	"COMP_ADMIN_STATE_PROHIBITED":    5,
}

func (x ComponentAdminState) String() string {
	return proto.EnumName(ComponentAdminState_name, int32(x))
}

func (ComponentAdminState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{1}
}

type ComponentOperState int32

const (
	ComponentOperState_COMP_OPER_STATE_UNDEFINED ComponentOperState = 0
	ComponentOperState_COMP_OPER_STATE_UNKNOWN   ComponentOperState = 1
	ComponentOperState_COMP_OPER_STATE_DISABLED  ComponentOperState = 2
	ComponentOperState_COMP_OPER_STATE_ENABLED   ComponentOperState = 3
	ComponentOperState_COMP_OPER_STATE_TESTING   ComponentOperState = 4
	// Indicates that the component is operating normally.
	ComponentOperState_COMP_OPER_STATE_NORMAL ComponentOperState = 5
	// Indicates that the component is currently being configured.
	ComponentOperState_COMP_OPER_STATE_CONFIGURING ComponentOperState = 6
	// Indicates that the component is automatically loading configuration or software.
	ComponentOperState_COMP_OPER_STATE_AUTOMATIC_LOADING ComponentOperState = 7
	// Indicates that the component has encountered a failure.
	ComponentOperState_COMP_OPER_STATE_FAILED ComponentOperState = 8
	// Indicates that the component is temporarily shut down.
	// The component is in a high temperature shutdown state due to exceeding safe operating temperature limits.
	ComponentOperState_COMP_OPER_STATE_HIGH_TEMP_SHUTDOWN ComponentOperState = 9
	// Indicates that the component is manually shut down.
	ComponentOperState_COMP_OPER_STATE_MANUAL_SHUTDOWN ComponentOperState = 10
	// Indicates that the component is shut down to save power.
	ComponentOperState_COMP_OPER_STATE_POWER_SAVING_SHUTDOWN ComponentOperState = 11
	// Indicates that the component's type does not match the expected type.
	ComponentOperState_COMP_OPER_STATE_TYPE_MISMATCH ComponentOperState = 12
)

var ComponentOperState_name = map[int32]string{
	0:  "COMP_OPER_STATE_UNDEFINED",
	1:  "COMP_OPER_STATE_UNKNOWN",
	2:  "COMP_OPER_STATE_DISABLED",
	3:  "COMP_OPER_STATE_ENABLED",
	4:  "COMP_OPER_STATE_TESTING",
	5:  "COMP_OPER_STATE_NORMAL",
	6:  "COMP_OPER_STATE_CONFIGURING",
	7:  "COMP_OPER_STATE_AUTOMATIC_LOADING",
	8:  "COMP_OPER_STATE_FAILED",
	9:  "COMP_OPER_STATE_HIGH_TEMP_SHUTDOWN",
	10: "COMP_OPER_STATE_MANUAL_SHUTDOWN",
	11: "COMP_OPER_STATE_POWER_SAVING_SHUTDOWN",
	12: "COMP_OPER_STATE_TYPE_MISMATCH",
}

var ComponentOperState_value = map[string]int32{
	"COMP_OPER_STATE_UNDEFINED":             0,
	"COMP_OPER_STATE_UNKNOWN":               1,
	"COMP_OPER_STATE_DISABLED":              2,
	"COMP_OPER_STATE_ENABLED":               3,
	"COMP_OPER_STATE_TESTING":               4,
	"COMP_OPER_STATE_NORMAL":                5,
	"COMP_OPER_STATE_CONFIGURING":           6,
	"COMP_OPER_STATE_AUTOMATIC_LOADING":     7,
	"COMP_OPER_STATE_FAILED":                8,
	"COMP_OPER_STATE_HIGH_TEMP_SHUTDOWN":    9,
	"COMP_OPER_STATE_MANUAL_SHUTDOWN":       10,
	"COMP_OPER_STATE_POWER_SAVING_SHUTDOWN": 11,
	"COMP_OPER_STATE_TYPE_MISMATCH":         12,
}

func (x ComponentOperState) String() string {
	return proto.EnumName(ComponentOperState_name, int32(x))
}

func (ComponentOperState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{2}
}

type ComponentUsageState int32

const (
	ComponentUsageState_COMP_USAGE_STATE_UNDEFINED ComponentUsageState = 0
	ComponentUsageState_COMP_USAGE_STATE_UNKNOWN   ComponentUsageState = 1
	ComponentUsageState_COMP_USAGE_STATE_IDLE      ComponentUsageState = 2
	ComponentUsageState_COMP_USAGE_STATE_ACTIVE    ComponentUsageState = 3
	ComponentUsageState_COMP_USAGE_STATE_BUSY      ComponentUsageState = 4
)

var ComponentUsageState_name = map[int32]string{
	0: "COMP_USAGE_STATE_UNDEFINED",
	1: "COMP_USAGE_STATE_UNKNOWN",
	2: "COMP_USAGE_STATE_IDLE",
	3: "COMP_USAGE_STATE_ACTIVE",
	4: "COMP_USAGE_STATE_BUSY",
}

var ComponentUsageState_value = map[string]int32{
	"COMP_USAGE_STATE_UNDEFINED": 0,
	"COMP_USAGE_STATE_UNKNOWN":   1,
	"COMP_USAGE_STATE_IDLE":      2,
	"COMP_USAGE_STATE_ACTIVE":    3,
	"COMP_USAGE_STATE_BUSY":      4,
}

func (x ComponentUsageState) String() string {
	return proto.EnumName(ComponentUsageState_name, int32(x))
}

func (ComponentUsageState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{3}
}

type ComponentAlarmState int32

const (
	ComponentAlarmState_COMP_ALARM_STATE_UNDEFINED     ComponentAlarmState = 0
	ComponentAlarmState_COMP_ALARM_STATE_UNKNOWN       ComponentAlarmState = 1
	ComponentAlarmState_COMP_ALARM_STATE_UNDER_REPAIR  ComponentAlarmState = 2
	ComponentAlarmState_COMP_ALARM_STATE_CRITICAL      ComponentAlarmState = 3
	ComponentAlarmState_COMP_ALARM_STATE_MAJOR         ComponentAlarmState = 4
	ComponentAlarmState_COMP_ALARM_STATE_MINOR         ComponentAlarmState = 5
	ComponentAlarmState_COMP_ALARM_STATE_WARNING       ComponentAlarmState = 6
	ComponentAlarmState_COMP_ALARM_STATE_INDETERMINATE ComponentAlarmState = 7
)

var ComponentAlarmState_name = map[int32]string{
	0: "COMP_ALARM_STATE_UNDEFINED",
	1: "COMP_ALARM_STATE_UNKNOWN",
	2: "COMP_ALARM_STATE_UNDER_REPAIR",
	3: "COMP_ALARM_STATE_CRITICAL",
	4: "COMP_ALARM_STATE_MAJOR",
	5: "COMP_ALARM_STATE_MINOR",
	6: "COMP_ALARM_STATE_WARNING",
	7: "COMP_ALARM_STATE_INDETERMINATE",
}

var ComponentAlarmState_value = map[string]int32{
	"COMP_ALARM_STATE_UNDEFINED":     0,
	"COMP_ALARM_STATE_UNKNOWN":       1,
	"COMP_ALARM_STATE_UNDER_REPAIR":  2,
	"COMP_ALARM_STATE_CRITICAL":      3,
	"COMP_ALARM_STATE_MAJOR":         4,
	"COMP_ALARM_STATE_MINOR":         5,
	"COMP_ALARM_STATE_WARNING":       6,
	"COMP_ALARM_STATE_INDETERMINATE": 7,
}

func (x ComponentAlarmState) String() string {
	return proto.EnumName(ComponentAlarmState_name, int32(x))
}

func (ComponentAlarmState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{4}
}

type ComponentStandbyState int32

const (
	ComponentStandbyState_COMP_STANDBY_STATE_UNDEFINED         ComponentStandbyState = 0
	ComponentStandbyState_COMP_STANDBY_STATE_UNKNOWN           ComponentStandbyState = 1
	ComponentStandbyState_COMP_STANDBY_STATE_HOT               ComponentStandbyState = 2
	ComponentStandbyState_COMP_STANDBY_STATE_COLD              ComponentStandbyState = 3
	ComponentStandbyState_COMP_STANDBY_STATE_PROVIDING_SERVICE ComponentStandbyState = 4
)

var ComponentStandbyState_name = map[int32]string{
	0: "COMP_STANDBY_STATE_UNDEFINED",
	1: "COMP_STANDBY_STATE_UNKNOWN",
	2: "COMP_STANDBY_STATE_HOT",
	3: "COMP_STANDBY_STATE_COLD",
	4: "COMP_STANDBY_STATE_PROVIDING_SERVICE",
}

var ComponentStandbyState_value = map[string]int32{
	"COMP_STANDBY_STATE_UNDEFINED":         0,
	"COMP_STANDBY_STATE_UNKNOWN":           1,
	"COMP_STANDBY_STATE_HOT":               2,
	"COMP_STANDBY_STATE_COLD":              3,
	"COMP_STANDBY_STATE_PROVIDING_SERVICE": 4,
}

func (x ComponentStandbyState) String() string {
	return proto.EnumName(ComponentStandbyState_name, int32(x))
}

func (ComponentStandbyState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{5}
}

type DataValueType int32

const (
	DataValueType_VALUE_TYPE_UNDEFINED   DataValueType = 0
	DataValueType_VALUE_TYPE_OTHER       DataValueType = 1
	DataValueType_VALUE_TYPE_UNKNOWN     DataValueType = 2
	DataValueType_VALUE_TYPE_VOLTS_AC    DataValueType = 3
	DataValueType_VALUE_TYPE_VOLTS_DC    DataValueType = 4
	DataValueType_VALUE_TYPE_AMPERES     DataValueType = 5
	DataValueType_VALUE_TYPE_WATTS       DataValueType = 6
	DataValueType_VALUE_TYPE_HERTZ       DataValueType = 7
	DataValueType_VALUE_TYPE_CELSIUS     DataValueType = 8
	DataValueType_VALUE_TYPE_PERCENT_RH  DataValueType = 9
	DataValueType_VALUE_TYPE_RPM         DataValueType = 10
	DataValueType_VALUE_TYPE_CMM         DataValueType = 11
	DataValueType_VALUE_TYPE_TRUTH_VALUE DataValueType = 12
	DataValueType_VALUE_TYPE_PERCENT     DataValueType = 13
	DataValueType_VALUE_TYPE_METERS      DataValueType = 14
	DataValueType_VALUE_TYPE_BYTES       DataValueType = 15
	DataValueType_VALUE_TYPE_DBM         DataValueType = 16
)

var DataValueType_name = map[int32]string{
	0:  "VALUE_TYPE_UNDEFINED",
	1:  "VALUE_TYPE_OTHER",
	2:  "VALUE_TYPE_UNKNOWN",
	3:  "VALUE_TYPE_VOLTS_AC",
	4:  "VALUE_TYPE_VOLTS_DC",
	5:  "VALUE_TYPE_AMPERES",
	6:  "VALUE_TYPE_WATTS",
	7:  "VALUE_TYPE_HERTZ",
	8:  "VALUE_TYPE_CELSIUS",
	9:  "VALUE_TYPE_PERCENT_RH",
	10: "VALUE_TYPE_RPM",
	11: "VALUE_TYPE_CMM",
	12: "VALUE_TYPE_TRUTH_VALUE",
	13: "VALUE_TYPE_PERCENT",
	14: "VALUE_TYPE_METERS",
	15: "VALUE_TYPE_BYTES",
	16: "VALUE_TYPE_DBM",
}

var DataValueType_value = map[string]int32{
	"VALUE_TYPE_UNDEFINED":   0,
	"VALUE_TYPE_OTHER":       1,
	"VALUE_TYPE_UNKNOWN":     2,
	"VALUE_TYPE_VOLTS_AC":    3,
	"VALUE_TYPE_VOLTS_DC":    4,
	"VALUE_TYPE_AMPERES":     5,
	"VALUE_TYPE_WATTS":       6,
	"VALUE_TYPE_HERTZ":       7,
	"VALUE_TYPE_CELSIUS":     8,
	"VALUE_TYPE_PERCENT_RH":  9,
	"VALUE_TYPE_RPM":         10,
	"VALUE_TYPE_CMM":         11,
	"VALUE_TYPE_TRUTH_VALUE": 12,
	"VALUE_TYPE_PERCENT":     13,
	"VALUE_TYPE_METERS":      14,
	"VALUE_TYPE_BYTES":       15,
	"VALUE_TYPE_DBM":         16,
}

func (x DataValueType) String() string {
	return proto.EnumName(DataValueType_name, int32(x))
}

func (DataValueType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{6}
}

type ValueScale int32

const (
	ValueScale_VALUE_SCALE_UNDEFINED ValueScale = 0
	ValueScale_VALUE_SCALE_YOCTO     ValueScale = 1
	ValueScale_VALUE_SCALE_ZEPTO     ValueScale = 2
	ValueScale_VALUE_SCALE_ATTO      ValueScale = 3
	ValueScale_VALUE_SCALE_FEMTO     ValueScale = 4
	ValueScale_VALUE_SCALE_PICO      ValueScale = 5
	ValueScale_VALUE_SCALE_NANO      ValueScale = 6
	ValueScale_VALUE_SCALE_MICRO     ValueScale = 7
	ValueScale_VALUE_SCALE_MILLI     ValueScale = 8
	ValueScale_VALUE_SCALE_UNITS     ValueScale = 9
	ValueScale_VALUE_SCALE_KILO      ValueScale = 10
	ValueScale_VALUE_SCALE_MEGA      ValueScale = 11
	ValueScale_VALUE_SCALE_GIGA      ValueScale = 12
	ValueScale_VALUE_SCALE_TERA      ValueScale = 13
	ValueScale_VALUE_SCALE_PETA      ValueScale = 14
	ValueScale_VALUE_SCALE_EXA       ValueScale = 15
	ValueScale_VALUE_SCALE_ZETTA     ValueScale = 16
	ValueScale_VALUE_SCALE_YOTTA     ValueScale = 17
)

var ValueScale_name = map[int32]string{
	0:  "VALUE_SCALE_UNDEFINED",
	1:  "VALUE_SCALE_YOCTO",
	2:  "VALUE_SCALE_ZEPTO",
	3:  "VALUE_SCALE_ATTO",
	4:  "VALUE_SCALE_FEMTO",
	5:  "VALUE_SCALE_PICO",
	6:  "VALUE_SCALE_NANO",
	7:  "VALUE_SCALE_MICRO",
	8:  "VALUE_SCALE_MILLI",
	9:  "VALUE_SCALE_UNITS",
	10: "VALUE_SCALE_KILO",
	11: "VALUE_SCALE_MEGA",
	12: "VALUE_SCALE_GIGA",
	13: "VALUE_SCALE_TERA",
	14: "VALUE_SCALE_PETA",
	15: "VALUE_SCALE_EXA",
	16: "VALUE_SCALE_ZETTA",
	17: "VALUE_SCALE_YOTTA",
}

var ValueScale_value = map[string]int32{
	"VALUE_SCALE_UNDEFINED": 0,
	"VALUE_SCALE_YOCTO":     1,
	"VALUE_SCALE_ZEPTO":     2,
	"VALUE_SCALE_ATTO":      3,
	"VALUE_SCALE_FEMTO":     4,
	"VALUE_SCALE_PICO":      5,
	"VALUE_SCALE_NANO":      6,
	"VALUE_SCALE_MICRO":     7,
	"VALUE_SCALE_MILLI":     8,
	"VALUE_SCALE_UNITS":     9,
	"VALUE_SCALE_KILO":      10,
	"VALUE_SCALE_MEGA":      11,
	"VALUE_SCALE_GIGA":      12,
	"VALUE_SCALE_TERA":      13,
	"VALUE_SCALE_PETA":      14,
	"VALUE_SCALE_EXA":       15,
	"VALUE_SCALE_ZETTA":     16,
	"VALUE_SCALE_YOTTA":     17,
}

func (x ValueScale) String() string {
	return proto.EnumName(ValueScale_name, int32(x))
}

func (ValueScale) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{7}
}

type SensorStatus int32

const (
	SensorStatus_SENSOR_STATUS_UNDEFINED      SensorStatus = 0
	SensorStatus_SENSOR_STATUS_OK             SensorStatus = 1
	SensorStatus_SENSOR_STATUS_UNAVAILABLE    SensorStatus = 2
	SensorStatus_SENSOR_STATUS_NONOPERATIONAL SensorStatus = 3
)

var SensorStatus_name = map[int32]string{
	0: "SENSOR_STATUS_UNDEFINED",
	1: "SENSOR_STATUS_OK",
	2: "SENSOR_STATUS_UNAVAILABLE",
	3: "SENSOR_STATUS_NONOPERATIONAL",
}

var SensorStatus_value = map[string]int32{
	"SENSOR_STATUS_UNDEFINED":      0,
	"SENSOR_STATUS_OK":             1,
	"SENSOR_STATUS_UNAVAILABLE":    2,
	"SENSOR_STATUS_NONOPERATIONAL": 3,
}

func (x SensorStatus) String() string {
	return proto.EnumName(SensorStatus_name, int32(x))
}

func (SensorStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{8}
}

type TransceiverType int32

const (
	TransceiverType_TYPE_UNDEFINED    TransceiverType = 0
	TransceiverType_ETHERNET          TransceiverType = 1
	TransceiverType_GPON              TransceiverType = 2
	TransceiverType_XGPON             TransceiverType = 3
	TransceiverType_XGSPON            TransceiverType = 4
	TransceiverType_CPON              TransceiverType = 5
	TransceiverType_NG_PON2           TransceiverType = 6
	TransceiverType_EPON              TransceiverType = 7
	TransceiverType_COMBO_GPON_XGSPON TransceiverType = 8
	TransceiverType_TYPE_NOT_DETECTED TransceiverType = 255
)

var TransceiverType_name = map[int32]string{
	0:   "TYPE_UNDEFINED",
	1:   "ETHERNET",
	2:   "GPON",
	3:   "XGPON",
	4:   "XGSPON",
	5:   "CPON",
	6:   "NG_PON2",
	7:   "EPON",
	8:   "COMBO_GPON_XGSPON",
	255: "TYPE_NOT_DETECTED",
}

var TransceiverType_value = map[string]int32{
	"TYPE_UNDEFINED":    0,
	"ETHERNET":          1,
	"GPON":              2,
	"XGPON":             3,
	"XGSPON":            4,
	"CPON":              5,
	"NG_PON2":           6,
	"EPON":              7,
	"COMBO_GPON_XGSPON": 8,
	"TYPE_NOT_DETECTED": 255,
}

func (x TransceiverType) String() string {
	return proto.EnumName(TransceiverType_name, int32(x))
}

func (TransceiverType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{9}
}

type PortComponentAttributes_ConnectorType int32

const (
	PortComponentAttributes_CONNECTOR_TYPE_UNDEFINED PortComponentAttributes_ConnectorType = 0
	PortComponentAttributes_RJ45                     PortComponentAttributes_ConnectorType = 1
	PortComponentAttributes_FIBER_LC                 PortComponentAttributes_ConnectorType = 2
	PortComponentAttributes_FIBER_SC_PC              PortComponentAttributes_ConnectorType = 3
	PortComponentAttributes_FIBER_MPO                PortComponentAttributes_ConnectorType = 4
	PortComponentAttributes_RS232                    PortComponentAttributes_ConnectorType = 5
)

var PortComponentAttributes_ConnectorType_name = map[int32]string{
	0: "CONNECTOR_TYPE_UNDEFINED",
	1: "RJ45",
	2: "FIBER_LC",
	3: "FIBER_SC_PC",
	4: "FIBER_MPO",
	5: "RS232",
}

var PortComponentAttributes_ConnectorType_value = map[string]int32{
	"CONNECTOR_TYPE_UNDEFINED": 0,
	"RJ45":                     1,
	"FIBER_LC":                 2,
	"FIBER_SC_PC":              3,
	"FIBER_MPO":                4,
	"RS232":                    5,
}

func (x PortComponentAttributes_ConnectorType) String() string {
	return proto.EnumName(PortComponentAttributes_ConnectorType_name, int32(x))
}

func (PortComponentAttributes_ConnectorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{5, 0}
}

type PortComponentAttributes_Speed int32

const (
	PortComponentAttributes_SPEED_UNDEFINED PortComponentAttributes_Speed = 0
	PortComponentAttributes_DYNAMIC         PortComponentAttributes_Speed = 1
	PortComponentAttributes_GIGABIT_1       PortComponentAttributes_Speed = 2
	PortComponentAttributes_GIGABIT_10      PortComponentAttributes_Speed = 3
	PortComponentAttributes_GIGABIT_25      PortComponentAttributes_Speed = 4
	PortComponentAttributes_GIGABIT_40      PortComponentAttributes_Speed = 5
	PortComponentAttributes_GIGABIT_100     PortComponentAttributes_Speed = 6
	PortComponentAttributes_GIGABIT_400     PortComponentAttributes_Speed = 7
	PortComponentAttributes_MEGABIT_2500    PortComponentAttributes_Speed = 8
	PortComponentAttributes_MEGABIT_1250    PortComponentAttributes_Speed = 9
)

var PortComponentAttributes_Speed_name = map[int32]string{
	0: "SPEED_UNDEFINED",
	1: "DYNAMIC",
	2: "GIGABIT_1",
	3: "GIGABIT_10",
	4: "GIGABIT_25",
	5: "GIGABIT_40",
	6: "GIGABIT_100",
	7: "GIGABIT_400",
	8: "MEGABIT_2500",
	9: "MEGABIT_1250",
}

var PortComponentAttributes_Speed_value = map[string]int32{
	"SPEED_UNDEFINED": 0,
	"DYNAMIC":         1,
	"GIGABIT_1":       2,
	"GIGABIT_10":      3,
	"GIGABIT_25":      4,
	"GIGABIT_40":      5,
	"GIGABIT_100":     6,
	"GIGABIT_400":     7,
	"MEGABIT_2500":    8,
	"MEGABIT_1250":    9,
}

func (x PortComponentAttributes_Speed) String() string {
	return proto.EnumName(PortComponentAttributes_Speed_name, int32(x))
}

func (PortComponentAttributes_Speed) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{5, 1}
}

type PortComponentAttributes_Protocol int32

const (
	PortComponentAttributes_PROTOCOL_UNDEFINED PortComponentAttributes_Protocol = 0
	PortComponentAttributes_ETHERNET           PortComponentAttributes_Protocol = 1
	PortComponentAttributes_GPON               PortComponentAttributes_Protocol = 2
	PortComponentAttributes_XGPON              PortComponentAttributes_Protocol = 3
	PortComponentAttributes_XGSPON             PortComponentAttributes_Protocol = 4
	PortComponentAttributes_GFAST              PortComponentAttributes_Protocol = 5
	PortComponentAttributes_SERIAL             PortComponentAttributes_Protocol = 6
	PortComponentAttributes_EPON               PortComponentAttributes_Protocol = 7
	PortComponentAttributes_BITS               PortComponentAttributes_Protocol = 8
)

var PortComponentAttributes_Protocol_name = map[int32]string{
	0: "PROTOCOL_UNDEFINED",
	1: "ETHERNET",
	2: "GPON",
	3: "XGPON",
	4: "XGSPON",
	5: "GFAST",
	6: "SERIAL",
	7: "EPON",
	8: "BITS",
}

var PortComponentAttributes_Protocol_value = map[string]int32{
	"PROTOCOL_UNDEFINED": 0,
	"ETHERNET":           1,
	"GPON":               2,
	"XGPON":              3,
	"XGSPON":             4,
	"GFAST":              5,
	"SERIAL":             6,
	"EPON":               7,
	"BITS":               8,
}

func (x PortComponentAttributes_Protocol) String() string {
	return proto.EnumName(PortComponentAttributes_Protocol_name, int32(x))
}

func (PortComponentAttributes_Protocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{5, 2}
}

type PsuComponentAttributes_SupportedVoltage int32

const (
	PsuComponentAttributes_SUPPORTED_VOLTAGE_UNDEFINED PsuComponentAttributes_SupportedVoltage = 0
	PsuComponentAttributes_V48                         PsuComponentAttributes_SupportedVoltage = 1
	PsuComponentAttributes_V230                        PsuComponentAttributes_SupportedVoltage = 2
	PsuComponentAttributes_V115                        PsuComponentAttributes_SupportedVoltage = 3
)

var PsuComponentAttributes_SupportedVoltage_name = map[int32]string{
	0: "SUPPORTED_VOLTAGE_UNDEFINED",
	1: "V48",
	2: "V230",
	3: "V115",
}

var PsuComponentAttributes_SupportedVoltage_value = map[string]int32{
	"SUPPORTED_VOLTAGE_UNDEFINED": 0,
	"V48":                         1,
	"V230":                        2,
	"V115":                        3,
}

func (x PsuComponentAttributes_SupportedVoltage) String() string {
	return proto.EnumName(PsuComponentAttributes_SupportedVoltage_name, int32(x))
}

func (PsuComponentAttributes_SupportedVoltage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{11, 0}
}

type TransceiverComponentsAttributes_FormFactor int32

const (
	TransceiverComponentsAttributes_FORM_FACTOR_UNKNOWN TransceiverComponentsAttributes_FormFactor = 0
	TransceiverComponentsAttributes_QSFP                TransceiverComponentsAttributes_FormFactor = 1
	TransceiverComponentsAttributes_QSFP_PLUS           TransceiverComponentsAttributes_FormFactor = 2
	TransceiverComponentsAttributes_QSFP28              TransceiverComponentsAttributes_FormFactor = 3
	TransceiverComponentsAttributes_SFP                 TransceiverComponentsAttributes_FormFactor = 4
	TransceiverComponentsAttributes_SFP_PLUS            TransceiverComponentsAttributes_FormFactor = 5
	TransceiverComponentsAttributes_XFP                 TransceiverComponentsAttributes_FormFactor = 6
	TransceiverComponentsAttributes_CFP4                TransceiverComponentsAttributes_FormFactor = 7
	TransceiverComponentsAttributes_CFP2                TransceiverComponentsAttributes_FormFactor = 8
	TransceiverComponentsAttributes_CPAK                TransceiverComponentsAttributes_FormFactor = 9
	TransceiverComponentsAttributes_X2                  TransceiverComponentsAttributes_FormFactor = 10
	TransceiverComponentsAttributes_OTHER               TransceiverComponentsAttributes_FormFactor = 11
	TransceiverComponentsAttributes_CFP                 TransceiverComponentsAttributes_FormFactor = 12
	TransceiverComponentsAttributes_CFP2_ACO            TransceiverComponentsAttributes_FormFactor = 13
	TransceiverComponentsAttributes_CFP2_DCO            TransceiverComponentsAttributes_FormFactor = 14
	TransceiverComponentsAttributes_QSFP_DD             TransceiverComponentsAttributes_FormFactor = 15
)

var TransceiverComponentsAttributes_FormFactor_name = map[int32]string{
	0:  "FORM_FACTOR_UNKNOWN",
	1:  "QSFP",
	2:  "QSFP_PLUS",
	3:  "QSFP28",
	4:  "SFP",
	5:  "SFP_PLUS",
	6:  "XFP",
	7:  "CFP4",
	8:  "CFP2",
	9:  "CPAK",
	10: "X2",
	11: "OTHER",
	12: "CFP",
	13: "CFP2_ACO",
	14: "CFP2_DCO",
	15: "QSFP_DD",
}

var TransceiverComponentsAttributes_FormFactor_value = map[string]int32{
	"FORM_FACTOR_UNKNOWN": 0,
	"QSFP":                1,
	"QSFP_PLUS":           2,
	"QSFP28":              3,
	"SFP":                 4,
	"SFP_PLUS":            5,
	"XFP":                 6,
	"CFP4":                7,
	"CFP2":                8,
	"CPAK":                9,
	"X2":                  10,
	"OTHER":               11,
	"CFP":                 12,
	"CFP2_ACO":            13,
	"CFP2_DCO":            14,
	"QSFP_DD":             15,
}

func (x TransceiverComponentsAttributes_FormFactor) String() string {
	return proto.EnumName(TransceiverComponentsAttributes_FormFactor_name, int32(x))
}

func (TransceiverComponentsAttributes_FormFactor) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{12, 0}
}

type Uuid struct {
	Uuid                 string   `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Uuid) Reset()         { *m = Uuid{} }
func (m *Uuid) String() string { return proto.CompactTextString(m) }
func (*Uuid) ProtoMessage()    {}
func (*Uuid) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{0}
}

func (m *Uuid) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Uuid.Unmarshal(m, b)
}
func (m *Uuid) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Uuid.Marshal(b, m, deterministic)
}
func (m *Uuid) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Uuid.Merge(m, src)
}
func (m *Uuid) XXX_Size() int {
	return xxx_messageInfo_Uuid.Size(m)
}
func (m *Uuid) XXX_DiscardUnknown() {
	xxx_messageInfo_Uuid.DiscardUnknown(m)
}

var xxx_messageInfo_Uuid proto.InternalMessageInfo

func (m *Uuid) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

type HardwareID struct {
	Uuid                 *Uuid    `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HardwareID) Reset()         { *m = HardwareID{} }
func (m *HardwareID) String() string { return proto.CompactTextString(m) }
func (*HardwareID) ProtoMessage()    {}
func (*HardwareID) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{1}
}

func (m *HardwareID) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HardwareID.Unmarshal(m, b)
}
func (m *HardwareID) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HardwareID.Marshal(b, m, deterministic)
}
func (m *HardwareID) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HardwareID.Merge(m, src)
}
func (m *HardwareID) XXX_Size() int {
	return xxx_messageInfo_HardwareID.Size(m)
}
func (m *HardwareID) XXX_DiscardUnknown() {
	xxx_messageInfo_HardwareID.DiscardUnknown(m)
}

var xxx_messageInfo_HardwareID proto.InternalMessageInfo

func (m *HardwareID) GetUuid() *Uuid {
	if m != nil {
		return m.Uuid
	}
	return nil
}

type Uri struct {
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Uri) Reset()         { *m = Uri{} }
func (m *Uri) String() string { return proto.CompactTextString(m) }
func (*Uri) ProtoMessage()    {}
func (*Uri) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{2}
}

func (m *Uri) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Uri.Unmarshal(m, b)
}
func (m *Uri) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Uri.Marshal(b, m, deterministic)
}
func (m *Uri) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Uri.Merge(m, src)
}
func (m *Uri) XXX_Size() int {
	return xxx_messageInfo_Uri.Size(m)
}
func (m *Uri) XXX_DiscardUnknown() {
	xxx_messageInfo_Uri.DiscardUnknown(m)
}

var xxx_messageInfo_Uri proto.InternalMessageInfo

func (m *Uri) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

type ComponentState struct {
	StateLastChanged     *timestamp.Timestamp  `protobuf:"bytes,1,opt,name=state_last_changed,json=stateLastChanged,proto3" json:"state_last_changed,omitempty"`
	AdminState           ComponentAdminState   `protobuf:"varint,2,opt,name=admin_state,json=adminState,proto3,enum=dmi.ComponentAdminState" json:"admin_state,omitempty"`
	OperState            ComponentOperState    `protobuf:"varint,3,opt,name=oper_state,json=operState,proto3,enum=dmi.ComponentOperState" json:"oper_state,omitempty"`
	UsageState           ComponentUsageState   `protobuf:"varint,4,opt,name=usage_state,json=usageState,proto3,enum=dmi.ComponentUsageState" json:"usage_state,omitempty"`
	AlarmState           ComponentAlarmState   `protobuf:"varint,5,opt,name=alarm_state,json=alarmState,proto3,enum=dmi.ComponentAlarmState" json:"alarm_state,omitempty"`
	StandbyState         ComponentStandbyState `protobuf:"varint,6,opt,name=standby_state,json=standbyState,proto3,enum=dmi.ComponentStandbyState" json:"standby_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ComponentState) Reset()         { *m = ComponentState{} }
func (m *ComponentState) String() string { return proto.CompactTextString(m) }
func (*ComponentState) ProtoMessage()    {}
func (*ComponentState) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{3}
}

func (m *ComponentState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComponentState.Unmarshal(m, b)
}
func (m *ComponentState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComponentState.Marshal(b, m, deterministic)
}
func (m *ComponentState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComponentState.Merge(m, src)
}
func (m *ComponentState) XXX_Size() int {
	return xxx_messageInfo_ComponentState.Size(m)
}
func (m *ComponentState) XXX_DiscardUnknown() {
	xxx_messageInfo_ComponentState.DiscardUnknown(m)
}

var xxx_messageInfo_ComponentState proto.InternalMessageInfo

func (m *ComponentState) GetStateLastChanged() *timestamp.Timestamp {
	if m != nil {
		return m.StateLastChanged
	}
	return nil
}

func (m *ComponentState) GetAdminState() ComponentAdminState {
	if m != nil {
		return m.AdminState
	}
	return ComponentAdminState_COMP_ADMIN_STATE_UNDEFINED
}

func (m *ComponentState) GetOperState() ComponentOperState {
	if m != nil {
		return m.OperState
	}
	return ComponentOperState_COMP_OPER_STATE_UNDEFINED
}

func (m *ComponentState) GetUsageState() ComponentUsageState {
	if m != nil {
		return m.UsageState
	}
	return ComponentUsageState_COMP_USAGE_STATE_UNDEFINED
}

func (m *ComponentState) GetAlarmState() ComponentAlarmState {
	if m != nil {
		return m.AlarmState
	}
	return ComponentAlarmState_COMP_ALARM_STATE_UNDEFINED
}

func (m *ComponentState) GetStandbyState() ComponentStandbyState {
	if m != nil {
		return m.StandbyState
	}
	return ComponentStandbyState_COMP_STANDBY_STATE_UNDEFINED
}

type ComponentSensorData struct {
	Value           int32                `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	Type            DataValueType        `protobuf:"varint,2,opt,name=type,proto3,enum=dmi.DataValueType" json:"type,omitempty"`
	Scale           ValueScale           `protobuf:"varint,3,opt,name=scale,proto3,enum=dmi.ValueScale" json:"scale,omitempty"`
	Precision       int32                `protobuf:"varint,4,opt,name=precision,proto3" json:"precision,omitempty"`
	Status          SensorStatus         `protobuf:"varint,5,opt,name=status,proto3,enum=dmi.SensorStatus" json:"status,omitempty"`
	UnitsDisplay    string               `protobuf:"bytes,6,opt,name=units_display,json=unitsDisplay,proto3" json:"units_display,omitempty"`
	Timestamp       *timestamp.Timestamp `protobuf:"bytes,7,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	ValueUpdateRate uint32               `protobuf:"varint,8,opt,name=value_update_rate,json=valueUpdateRate,proto3" json:"value_update_rate,omitempty"`
	// data_type can be of the string representation of MetricNames or something else as well
	DataType             string   `protobuf:"bytes,9,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ComponentSensorData) Reset()         { *m = ComponentSensorData{} }
func (m *ComponentSensorData) String() string { return proto.CompactTextString(m) }
func (*ComponentSensorData) ProtoMessage()    {}
func (*ComponentSensorData) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{4}
}

func (m *ComponentSensorData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComponentSensorData.Unmarshal(m, b)
}
func (m *ComponentSensorData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComponentSensorData.Marshal(b, m, deterministic)
}
func (m *ComponentSensorData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComponentSensorData.Merge(m, src)
}
func (m *ComponentSensorData) XXX_Size() int {
	return xxx_messageInfo_ComponentSensorData.Size(m)
}
func (m *ComponentSensorData) XXX_DiscardUnknown() {
	xxx_messageInfo_ComponentSensorData.DiscardUnknown(m)
}

var xxx_messageInfo_ComponentSensorData proto.InternalMessageInfo

func (m *ComponentSensorData) GetValue() int32 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *ComponentSensorData) GetType() DataValueType {
	if m != nil {
		return m.Type
	}
	return DataValueType_VALUE_TYPE_UNDEFINED
}

func (m *ComponentSensorData) GetScale() ValueScale {
	if m != nil {
		return m.Scale
	}
	return ValueScale_VALUE_SCALE_UNDEFINED
}

func (m *ComponentSensorData) GetPrecision() int32 {
	if m != nil {
		return m.Precision
	}
	return 0
}

func (m *ComponentSensorData) GetStatus() SensorStatus {
	if m != nil {
		return m.Status
	}
	return SensorStatus_SENSOR_STATUS_UNDEFINED
}

func (m *ComponentSensorData) GetUnitsDisplay() string {
	if m != nil {
		return m.UnitsDisplay
	}
	return ""
}

func (m *ComponentSensorData) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *ComponentSensorData) GetValueUpdateRate() uint32 {
	if m != nil {
		return m.ValueUpdateRate
	}
	return 0
}

func (m *ComponentSensorData) GetDataType() string {
	if m != nil {
		return m.DataType
	}
	return ""
}

type PortComponentAttributes struct {
	ConnectorType PortComponentAttributes_ConnectorType `protobuf:"varint,1,opt,name=connector_type,json=connectorType,proto3,enum=dmi.PortComponentAttributes_ConnectorType" json:"connector_type,omitempty"`
	Speed         PortComponentAttributes_Speed         `protobuf:"varint,2,opt,name=speed,proto3,enum=dmi.PortComponentAttributes_Speed" json:"speed,omitempty"`
	Protocol      PortComponentAttributes_Protocol      `protobuf:"varint,3,opt,name=protocol,proto3,enum=dmi.PortComponentAttributes_Protocol" json:"protocol,omitempty"`
	PhysicalLabel string                                `protobuf:"bytes,4,opt,name=physical_label,json=physicalLabel,proto3" json:"physical_label,omitempty"`
	// The mapping_label can be used to map ports between the DMI interface and other systems like VOLTHA
	// The value of the mapping_label should be exactly the same as generated for the same port by the other
	// system
	MappingLabel         string       `protobuf:"bytes,5,opt,name=mapping_label,json=mappingLabel,proto3" json:"mapping_label,omitempty"`
	PonIdConfig          *PonIdConfig `protobuf:"bytes,6,opt,name=pon_id_config,json=ponIdConfig,proto3" json:"pon_id_config,omitempty"`
	SpeedAutonegotiation bool         `protobuf:"varint,7,opt,name=speed_autonegotiation,json=speedAutonegotiation,proto3" json:"speed_autonegotiation,omitempty"`
	Distance             *PonDistance `protobuf:"bytes,8,opt,name=distance,proto3" json:"distance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PortComponentAttributes) Reset()         { *m = PortComponentAttributes{} }
func (m *PortComponentAttributes) String() string { return proto.CompactTextString(m) }
func (*PortComponentAttributes) ProtoMessage()    {}
func (*PortComponentAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{5}
}

func (m *PortComponentAttributes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PortComponentAttributes.Unmarshal(m, b)
}
func (m *PortComponentAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PortComponentAttributes.Marshal(b, m, deterministic)
}
func (m *PortComponentAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortComponentAttributes.Merge(m, src)
}
func (m *PortComponentAttributes) XXX_Size() int {
	return xxx_messageInfo_PortComponentAttributes.Size(m)
}
func (m *PortComponentAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_PortComponentAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_PortComponentAttributes proto.InternalMessageInfo

func (m *PortComponentAttributes) GetConnectorType() PortComponentAttributes_ConnectorType {
	if m != nil {
		return m.ConnectorType
	}
	return PortComponentAttributes_CONNECTOR_TYPE_UNDEFINED
}

func (m *PortComponentAttributes) GetSpeed() PortComponentAttributes_Speed {
	if m != nil {
		return m.Speed
	}
	return PortComponentAttributes_SPEED_UNDEFINED
}

func (m *PortComponentAttributes) GetProtocol() PortComponentAttributes_Protocol {
	if m != nil {
		return m.Protocol
	}
	return PortComponentAttributes_PROTOCOL_UNDEFINED
}

func (m *PortComponentAttributes) GetPhysicalLabel() string {
	if m != nil {
		return m.PhysicalLabel
	}
	return ""
}

func (m *PortComponentAttributes) GetMappingLabel() string {
	if m != nil {
		return m.MappingLabel
	}
	return ""
}

func (m *PortComponentAttributes) GetPonIdConfig() *PonIdConfig {
	if m != nil {
		return m.PonIdConfig
	}
	return nil
}

func (m *PortComponentAttributes) GetSpeedAutonegotiation() bool {
	if m != nil {
		return m.SpeedAutonegotiation
	}
	return false
}

func (m *PortComponentAttributes) GetDistance() *PonDistance {
	if m != nil {
		return m.Distance
	}
	return nil
}

type PonDistance struct {
	//
	// The ITU-T G.987.x series of Recommendations addresses the linear extent parameters of XG-PON
	// using the single concept of fibre distance. An ONU is characterized by its fibre distance, and for
	// each pair of ONUs on the same OLT PON interface, the differential fibre distance is the difference
	// between the two individual fibre distances. Each specific PMD layer parameter set contains a
	// provision to support a specific maximum fibre distance. The XG-PON TC layer specification
	// contains a provision to support specific ranges of maximum fibre distance and maximum
	// differential fibre distance. These ranges can be configurable for a given system. One can expect that
	// for each XG-PON deployment, the configured TC layer maximum fibre distance will match the
	// maximum fibre distance supported by the selected PMD layer parameter set.
	MaxDistance             uint32   `protobuf:"varint,1,opt,name=max_distance,json=maxDistance,proto3" json:"max_distance,omitempty"`
	MaxDifferentialDistance uint32   `protobuf:"varint,2,opt,name=max_differential_distance,json=maxDifferentialDistance,proto3" json:"max_differential_distance,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *PonDistance) Reset()         { *m = PonDistance{} }
func (m *PonDistance) String() string { return proto.CompactTextString(m) }
func (*PonDistance) ProtoMessage()    {}
func (*PonDistance) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{6}
}

func (m *PonDistance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PonDistance.Unmarshal(m, b)
}
func (m *PonDistance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PonDistance.Marshal(b, m, deterministic)
}
func (m *PonDistance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PonDistance.Merge(m, src)
}
func (m *PonDistance) XXX_Size() int {
	return xxx_messageInfo_PonDistance.Size(m)
}
func (m *PonDistance) XXX_DiscardUnknown() {
	xxx_messageInfo_PonDistance.DiscardUnknown(m)
}

var xxx_messageInfo_PonDistance proto.InternalMessageInfo

func (m *PonDistance) GetMaxDistance() uint32 {
	if m != nil {
		return m.MaxDistance
	}
	return 0
}

func (m *PonDistance) GetMaxDifferentialDistance() uint32 {
	if m != nil {
		return m.MaxDifferentialDistance
	}
	return 0
}

type PortComponentChangeAttributes struct {
	PonIdConfig          *PonIdConfig `protobuf:"bytes,1,opt,name=pon_id_config,json=ponIdConfig,proto3" json:"pon_id_config,omitempty"`
	Distance             *PonDistance `protobuf:"bytes,2,opt,name=distance,proto3" json:"distance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PortComponentChangeAttributes) Reset()         { *m = PortComponentChangeAttributes{} }
func (m *PortComponentChangeAttributes) String() string { return proto.CompactTextString(m) }
func (*PortComponentChangeAttributes) ProtoMessage()    {}
func (*PortComponentChangeAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{7}
}

func (m *PortComponentChangeAttributes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PortComponentChangeAttributes.Unmarshal(m, b)
}
func (m *PortComponentChangeAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PortComponentChangeAttributes.Marshal(b, m, deterministic)
}
func (m *PortComponentChangeAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortComponentChangeAttributes.Merge(m, src)
}
func (m *PortComponentChangeAttributes) XXX_Size() int {
	return xxx_messageInfo_PortComponentChangeAttributes.Size(m)
}
func (m *PortComponentChangeAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_PortComponentChangeAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_PortComponentChangeAttributes proto.InternalMessageInfo

func (m *PortComponentChangeAttributes) GetPonIdConfig() *PonIdConfig {
	if m != nil {
		return m.PonIdConfig
	}
	return nil
}

func (m *PortComponentChangeAttributes) GetDistance() *PonDistance {
	if m != nil {
		return m.Distance
	}
	return nil
}

type TransceiverComponentChangeAttributes struct {
	TransType            TransceiverType `protobuf:"varint,1,opt,name=trans_type,json=transType,proto3,enum=dmi.TransceiverType" json:"trans_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *TransceiverComponentChangeAttributes) Reset()         { *m = TransceiverComponentChangeAttributes{} }
func (m *TransceiverComponentChangeAttributes) String() string { return proto.CompactTextString(m) }
func (*TransceiverComponentChangeAttributes) ProtoMessage()    {}
func (*TransceiverComponentChangeAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{8}
}

func (m *TransceiverComponentChangeAttributes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransceiverComponentChangeAttributes.Unmarshal(m, b)
}
func (m *TransceiverComponentChangeAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransceiverComponentChangeAttributes.Marshal(b, m, deterministic)
}
func (m *TransceiverComponentChangeAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransceiverComponentChangeAttributes.Merge(m, src)
}
func (m *TransceiverComponentChangeAttributes) XXX_Size() int {
	return xxx_messageInfo_TransceiverComponentChangeAttributes.Size(m)
}
func (m *TransceiverComponentChangeAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_TransceiverComponentChangeAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_TransceiverComponentChangeAttributes proto.InternalMessageInfo

func (m *TransceiverComponentChangeAttributes) GetTransType() TransceiverType {
	if m != nil {
		return m.TransType
	}
	return TransceiverType_TYPE_UNDEFINED
}

type PonIdConfig struct {
	// The pon_id and pon_id_transmit_periodicity attributes are valid only for ports of type GPON, XGPON and XGSPON
	// For GPON pon_id is a 7 byte value
	// For XGS-PON, it's a 32 bit value, should be encoded in the first 4 bytes of pon_id in network byte order
	PonId                    []byte   `protobuf:"bytes,1,opt,name=pon_id,json=ponId,proto3" json:"pon_id,omitempty"`
	PonIdTransmitPeriodicity uint32   `protobuf:"varint,2,opt,name=pon_id_transmit_periodicity,json=ponIdTransmitPeriodicity,proto3" json:"pon_id_transmit_periodicity,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *PonIdConfig) Reset()         { *m = PonIdConfig{} }
func (m *PonIdConfig) String() string { return proto.CompactTextString(m) }
func (*PonIdConfig) ProtoMessage()    {}
func (*PonIdConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{9}
}

func (m *PonIdConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PonIdConfig.Unmarshal(m, b)
}
func (m *PonIdConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PonIdConfig.Marshal(b, m, deterministic)
}
func (m *PonIdConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PonIdConfig.Merge(m, src)
}
func (m *PonIdConfig) XXX_Size() int {
	return xxx_messageInfo_PonIdConfig.Size(m)
}
func (m *PonIdConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PonIdConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PonIdConfig proto.InternalMessageInfo

func (m *PonIdConfig) GetPonId() []byte {
	if m != nil {
		return m.PonId
	}
	return nil
}

func (m *PonIdConfig) GetPonIdTransmitPeriodicity() uint32 {
	if m != nil {
		return m.PonIdTransmitPeriodicity
	}
	return 0
}

type ContainerComponentAttributes struct {
	PhysicalLabel        string   `protobuf:"bytes,1,opt,name=physical_label,json=physicalLabel,proto3" json:"physical_label,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContainerComponentAttributes) Reset()         { *m = ContainerComponentAttributes{} }
func (m *ContainerComponentAttributes) String() string { return proto.CompactTextString(m) }
func (*ContainerComponentAttributes) ProtoMessage()    {}
func (*ContainerComponentAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{10}
}

func (m *ContainerComponentAttributes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContainerComponentAttributes.Unmarshal(m, b)
}
func (m *ContainerComponentAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContainerComponentAttributes.Marshal(b, m, deterministic)
}
func (m *ContainerComponentAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerComponentAttributes.Merge(m, src)
}
func (m *ContainerComponentAttributes) XXX_Size() int {
	return xxx_messageInfo_ContainerComponentAttributes.Size(m)
}
func (m *ContainerComponentAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerComponentAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerComponentAttributes proto.InternalMessageInfo

func (m *ContainerComponentAttributes) GetPhysicalLabel() string {
	if m != nil {
		return m.PhysicalLabel
	}
	return ""
}

type PsuComponentAttributes struct {
	SupportedVoltage     PsuComponentAttributes_SupportedVoltage `protobuf:"varint,1,opt,name=supported_voltage,json=supportedVoltage,proto3,enum=dmi.PsuComponentAttributes_SupportedVoltage" json:"supported_voltage,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *PsuComponentAttributes) Reset()         { *m = PsuComponentAttributes{} }
func (m *PsuComponentAttributes) String() string { return proto.CompactTextString(m) }
func (*PsuComponentAttributes) ProtoMessage()    {}
func (*PsuComponentAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{11}
}

func (m *PsuComponentAttributes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PsuComponentAttributes.Unmarshal(m, b)
}
func (m *PsuComponentAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PsuComponentAttributes.Marshal(b, m, deterministic)
}
func (m *PsuComponentAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PsuComponentAttributes.Merge(m, src)
}
func (m *PsuComponentAttributes) XXX_Size() int {
	return xxx_messageInfo_PsuComponentAttributes.Size(m)
}
func (m *PsuComponentAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_PsuComponentAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_PsuComponentAttributes proto.InternalMessageInfo

func (m *PsuComponentAttributes) GetSupportedVoltage() PsuComponentAttributes_SupportedVoltage {
	if m != nil {
		return m.SupportedVoltage
	}
	return PsuComponentAttributes_SUPPORTED_VOLTAGE_UNDEFINED
}

type TransceiverComponentsAttributes struct {
	FormFactor TransceiverComponentsAttributes_FormFactor `protobuf:"varint,1,opt,name=form_factor,json=formFactor,proto3,enum=dmi.TransceiverComponentsAttributes_FormFactor" json:"form_factor,omitempty"`
	TransType  TransceiverType                            `protobuf:"varint,2,opt,name=trans_type,json=transType,proto3,enum=dmi.TransceiverType" json:"trans_type,omitempty"`
	// The maximum reach that can be achieved by this transceiver
	MaxDistance      uint32     `protobuf:"varint,3,opt,name=max_distance,json=maxDistance,proto3" json:"max_distance,omitempty"`
	MaxDistanceScale ValueScale `protobuf:"varint,4,opt,name=max_distance_scale,json=maxDistanceScale,proto3,enum=dmi.ValueScale" json:"max_distance_scale,omitempty"`
	// The receive and transmit wavelengths that the transeiver operates on
	RxWavelength    []uint32   `protobuf:"varint,5,rep,packed,name=rx_wavelength,json=rxWavelength,proto3" json:"rx_wavelength,omitempty"`
	TxWavelength    []uint32   `protobuf:"varint,6,rep,packed,name=tx_wavelength,json=txWavelength,proto3" json:"tx_wavelength,omitempty"`
	WavelengthScale ValueScale `protobuf:"varint,7,opt,name=wavelength_scale,json=wavelengthScale,proto3,enum=dmi.ValueScale" json:"wavelength_scale,omitempty"`
	// The tx powers on the transceiver; the value type of tx_power should be dBm.
	// Note: When there are multiple rx/tx wavelengths and powers
	// each of the corresponding ones should be aligned on the same index of the array
	TxPower              []int32    `protobuf:"varint,8,rep,packed,name=tx_power,json=txPower,proto3" json:"tx_power,omitempty"`
	TxPowerScale         ValueScale `protobuf:"varint,9,opt,name=tx_power_scale,json=txPowerScale,proto3,enum=dmi.ValueScale" json:"tx_power_scale,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *TransceiverComponentsAttributes) Reset()         { *m = TransceiverComponentsAttributes{} }
func (m *TransceiverComponentsAttributes) String() string { return proto.CompactTextString(m) }
func (*TransceiverComponentsAttributes) ProtoMessage()    {}
func (*TransceiverComponentsAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{12}
}

func (m *TransceiverComponentsAttributes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransceiverComponentsAttributes.Unmarshal(m, b)
}
func (m *TransceiverComponentsAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransceiverComponentsAttributes.Marshal(b, m, deterministic)
}
func (m *TransceiverComponentsAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransceiverComponentsAttributes.Merge(m, src)
}
func (m *TransceiverComponentsAttributes) XXX_Size() int {
	return xxx_messageInfo_TransceiverComponentsAttributes.Size(m)
}
func (m *TransceiverComponentsAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_TransceiverComponentsAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_TransceiverComponentsAttributes proto.InternalMessageInfo

func (m *TransceiverComponentsAttributes) GetFormFactor() TransceiverComponentsAttributes_FormFactor {
	if m != nil {
		return m.FormFactor
	}
	return TransceiverComponentsAttributes_FORM_FACTOR_UNKNOWN
}

func (m *TransceiverComponentsAttributes) GetTransType() TransceiverType {
	if m != nil {
		return m.TransType
	}
	return TransceiverType_TYPE_UNDEFINED
}

func (m *TransceiverComponentsAttributes) GetMaxDistance() uint32 {
	if m != nil {
		return m.MaxDistance
	}
	return 0
}

func (m *TransceiverComponentsAttributes) GetMaxDistanceScale() ValueScale {
	if m != nil {
		return m.MaxDistanceScale
	}
	return ValueScale_VALUE_SCALE_UNDEFINED
}

func (m *TransceiverComponentsAttributes) GetRxWavelength() []uint32 {
	if m != nil {
		return m.RxWavelength
	}
	return nil
}

func (m *TransceiverComponentsAttributes) GetTxWavelength() []uint32 {
	if m != nil {
		return m.TxWavelength
	}
	return nil
}

func (m *TransceiverComponentsAttributes) GetWavelengthScale() ValueScale {
	if m != nil {
		return m.WavelengthScale
	}
	return ValueScale_VALUE_SCALE_UNDEFINED
}

func (m *TransceiverComponentsAttributes) GetTxPower() []int32 {
	if m != nil {
		return m.TxPower
	}
	return nil
}

func (m *TransceiverComponentsAttributes) GetTxPowerScale() ValueScale {
	if m != nil {
		return m.TxPowerScale
	}
	return ValueScale_VALUE_SCALE_UNDEFINED
}

type Component struct {
	// The name of a component uniquely identifies a component within the hardware
	Name        string        `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Class       ComponentType `protobuf:"varint,2,opt,name=class,proto3,enum=dmi.ComponentType" json:"class,omitempty"`
	Description string        `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The name of the parent of this component, empty string("") in case of the root component
	Parent       string       `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	ParentRelPos int32        `protobuf:"varint,5,opt,name=parent_rel_pos,json=parentRelPos,proto3" json:"parent_rel_pos,omitempty"`
	Children     []*Component `protobuf:"bytes,6,rep,name=children,proto3" json:"children,omitempty"`
	HardwareRev  string       `protobuf:"bytes,7,opt,name=hardware_rev,json=hardwareRev,proto3" json:"hardware_rev,omitempty"`
	FirmwareRev  string       `protobuf:"bytes,8,opt,name=firmware_rev,json=firmwareRev,proto3" json:"firmware_rev,omitempty"`
	SoftwareRev  string       `protobuf:"bytes,9,opt,name=software_rev,json=softwareRev,proto3" json:"software_rev,omitempty"`
	SerialNum    string       `protobuf:"bytes,10,opt,name=serial_num,json=serialNum,proto3" json:"serial_num,omitempty"`
	MfgName      string       `protobuf:"bytes,11,opt,name=mfg_name,json=mfgName,proto3" json:"mfg_name,omitempty"`
	// Apart from the definition of this attribute as defined in RFC 8348, implementations could choose to carry
	// the manufacturer's part number in this attribute.
	ModelName string               `protobuf:"bytes,12,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	Alias     string               `protobuf:"bytes,13,opt,name=alias,proto3" json:"alias,omitempty"`
	AssetId   string               `protobuf:"bytes,14,opt,name=asset_id,json=assetId,proto3" json:"asset_id,omitempty"`
	IsFru     bool                 `protobuf:"varint,15,opt,name=is_fru,json=isFru,proto3" json:"is_fru,omitempty"`
	MfgDate   *timestamp.Timestamp `protobuf:"bytes,16,opt,name=mfg_date,json=mfgDate,proto3" json:"mfg_date,omitempty"`
	Uri       *Uri                 `protobuf:"bytes,17,opt,name=uri,proto3" json:"uri,omitempty"`
	// The uuid of the component uniquely identifies the component across the entire system
	Uuid       *Uuid                  `protobuf:"bytes,18,opt,name=uuid,proto3" json:"uuid,omitempty"`
	State      *ComponentState        `protobuf:"bytes,19,opt,name=state,proto3" json:"state,omitempty"`
	SensorData []*ComponentSensorData `protobuf:"bytes,20,rep,name=sensor_data,json=sensorData,proto3" json:"sensor_data,omitempty"`
	// The attribute 'specific' can be populated for components where more details are required by the users of the DMI interface
	//
	// Types that are valid to be assigned to Specific:
	//	*Component_PortAttr
	//	*Component_ContainerAttr
	//	*Component_PsuAttr
	//	*Component_TransceiverAttr
	Specific             isComponent_Specific `protobuf_oneof:"specific"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Component) Reset()         { *m = Component{} }
func (m *Component) String() string { return proto.CompactTextString(m) }
func (*Component) ProtoMessage()    {}
func (*Component) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{13}
}

func (m *Component) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Component.Unmarshal(m, b)
}
func (m *Component) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Component.Marshal(b, m, deterministic)
}
func (m *Component) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Component.Merge(m, src)
}
func (m *Component) XXX_Size() int {
	return xxx_messageInfo_Component.Size(m)
}
func (m *Component) XXX_DiscardUnknown() {
	xxx_messageInfo_Component.DiscardUnknown(m)
}

var xxx_messageInfo_Component proto.InternalMessageInfo

func (m *Component) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Component) GetClass() ComponentType {
	if m != nil {
		return m.Class
	}
	return ComponentType_COMPONENT_TYPE_UNDEFINED
}

func (m *Component) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Component) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Component) GetParentRelPos() int32 {
	if m != nil {
		return m.ParentRelPos
	}
	return 0
}

func (m *Component) GetChildren() []*Component {
	if m != nil {
		return m.Children
	}
	return nil
}

func (m *Component) GetHardwareRev() string {
	if m != nil {
		return m.HardwareRev
	}
	return ""
}

func (m *Component) GetFirmwareRev() string {
	if m != nil {
		return m.FirmwareRev
	}
	return ""
}

func (m *Component) GetSoftwareRev() string {
	if m != nil {
		return m.SoftwareRev
	}
	return ""
}

func (m *Component) GetSerialNum() string {
	if m != nil {
		return m.SerialNum
	}
	return ""
}

func (m *Component) GetMfgName() string {
	if m != nil {
		return m.MfgName
	}
	return ""
}

func (m *Component) GetModelName() string {
	if m != nil {
		return m.ModelName
	}
	return ""
}

func (m *Component) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *Component) GetAssetId() string {
	if m != nil {
		return m.AssetId
	}
	return ""
}

func (m *Component) GetIsFru() bool {
	if m != nil {
		return m.IsFru
	}
	return false
}

func (m *Component) GetMfgDate() *timestamp.Timestamp {
	if m != nil {
		return m.MfgDate
	}
	return nil
}

func (m *Component) GetUri() *Uri {
	if m != nil {
		return m.Uri
	}
	return nil
}

func (m *Component) GetUuid() *Uuid {
	if m != nil {
		return m.Uuid
	}
	return nil
}

func (m *Component) GetState() *ComponentState {
	if m != nil {
		return m.State
	}
	return nil
}

func (m *Component) GetSensorData() []*ComponentSensorData {
	if m != nil {
		return m.SensorData
	}
	return nil
}

type isComponent_Specific interface {
	isComponent_Specific()
}

type Component_PortAttr struct {
	PortAttr *PortComponentAttributes `protobuf:"bytes,50,opt,name=port_attr,json=portAttr,proto3,oneof"`
}

type Component_ContainerAttr struct {
	ContainerAttr *ContainerComponentAttributes `protobuf:"bytes,51,opt,name=container_attr,json=containerAttr,proto3,oneof"`
}

type Component_PsuAttr struct {
	PsuAttr *PsuComponentAttributes `protobuf:"bytes,52,opt,name=psu_attr,json=psuAttr,proto3,oneof"`
}

type Component_TransceiverAttr struct {
	TransceiverAttr *TransceiverComponentsAttributes `protobuf:"bytes,53,opt,name=transceiver_attr,json=transceiverAttr,proto3,oneof"`
}

func (*Component_PortAttr) isComponent_Specific() {}

func (*Component_ContainerAttr) isComponent_Specific() {}

func (*Component_PsuAttr) isComponent_Specific() {}

func (*Component_TransceiverAttr) isComponent_Specific() {}

func (m *Component) GetSpecific() isComponent_Specific {
	if m != nil {
		return m.Specific
	}
	return nil
}

func (m *Component) GetPortAttr() *PortComponentAttributes {
	if x, ok := m.GetSpecific().(*Component_PortAttr); ok {
		return x.PortAttr
	}
	return nil
}

func (m *Component) GetContainerAttr() *ContainerComponentAttributes {
	if x, ok := m.GetSpecific().(*Component_ContainerAttr); ok {
		return x.ContainerAttr
	}
	return nil
}

func (m *Component) GetPsuAttr() *PsuComponentAttributes {
	if x, ok := m.GetSpecific().(*Component_PsuAttr); ok {
		return x.PsuAttr
	}
	return nil
}

func (m *Component) GetTransceiverAttr() *TransceiverComponentsAttributes {
	if x, ok := m.GetSpecific().(*Component_TransceiverAttr); ok {
		return x.TransceiverAttr
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Component) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Component_PortAttr)(nil),
		(*Component_ContainerAttr)(nil),
		(*Component_PsuAttr)(nil),
		(*Component_TransceiverAttr)(nil),
	}
}

type Hardware struct {
	LastChange *timestamp.Timestamp `protobuf:"bytes,1,opt,name=last_change,json=lastChange,proto3" json:"last_change,omitempty"`
	// Each HW has one parent/root and all other components are children of this
	// The class of the root component would be set as UNDEFINED
	Root *Component `protobuf:"bytes,2,opt,name=root,proto3" json:"root,omitempty"`
	// TODO: Authentication?
	// Timestamp at which the hardware last booted
	LastBooted           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=last_booted,json=lastBooted,proto3" json:"last_booted,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Hardware) Reset()         { *m = Hardware{} }
func (m *Hardware) String() string { return proto.CompactTextString(m) }
func (*Hardware) ProtoMessage()    {}
func (*Hardware) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{14}
}

func (m *Hardware) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Hardware.Unmarshal(m, b)
}
func (m *Hardware) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Hardware.Marshal(b, m, deterministic)
}
func (m *Hardware) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Hardware.Merge(m, src)
}
func (m *Hardware) XXX_Size() int {
	return xxx_messageInfo_Hardware.Size(m)
}
func (m *Hardware) XXX_DiscardUnknown() {
	xxx_messageInfo_Hardware.DiscardUnknown(m)
}

var xxx_messageInfo_Hardware proto.InternalMessageInfo

func (m *Hardware) GetLastChange() *timestamp.Timestamp {
	if m != nil {
		return m.LastChange
	}
	return nil
}

func (m *Hardware) GetRoot() *Component {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *Hardware) GetLastBooted() *timestamp.Timestamp {
	if m != nil {
		return m.LastBooted
	}
	return nil
}

// The attributes of a component which are modifiable from the client side
type ModifiableComponent struct {
	// The name has to be unique for each component within the hardware and implementations need to
	// ascertain this when modifying the name
	Name         string              `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Class        ComponentType       `protobuf:"varint,2,opt,name=class,proto3,enum=dmi.ComponentType" json:"class,omitempty"`
	Parent       *Component          `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	ParentRelPos int32               `protobuf:"varint,4,opt,name=parent_rel_pos,json=parentRelPos,proto3" json:"parent_rel_pos,omitempty"`
	Alias        string              `protobuf:"bytes,5,opt,name=alias,proto3" json:"alias,omitempty"`
	AssetId      string              `protobuf:"bytes,6,opt,name=asset_id,json=assetId,proto3" json:"asset_id,omitempty"`
	Uri          *Uri                `protobuf:"bytes,7,opt,name=uri,proto3" json:"uri,omitempty"`
	AdminState   ComponentAdminState `protobuf:"varint,8,opt,name=admin_state,json=adminState,proto3,enum=dmi.ComponentAdminState" json:"admin_state,omitempty"`
	// The attribute 'specific' can be populated for specific class of components
	//
	// Types that are valid to be assigned to Specific:
	//	*ModifiableComponent_PortAttr
	//	*ModifiableComponent_TrxAttr
	Specific             isModifiableComponent_Specific `protobuf_oneof:"specific"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ModifiableComponent) Reset()         { *m = ModifiableComponent{} }
func (m *ModifiableComponent) String() string { return proto.CompactTextString(m) }
func (*ModifiableComponent) ProtoMessage()    {}
func (*ModifiableComponent) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{15}
}

func (m *ModifiableComponent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifiableComponent.Unmarshal(m, b)
}
func (m *ModifiableComponent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifiableComponent.Marshal(b, m, deterministic)
}
func (m *ModifiableComponent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifiableComponent.Merge(m, src)
}
func (m *ModifiableComponent) XXX_Size() int {
	return xxx_messageInfo_ModifiableComponent.Size(m)
}
func (m *ModifiableComponent) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifiableComponent.DiscardUnknown(m)
}

var xxx_messageInfo_ModifiableComponent proto.InternalMessageInfo

func (m *ModifiableComponent) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ModifiableComponent) GetClass() ComponentType {
	if m != nil {
		return m.Class
	}
	return ComponentType_COMPONENT_TYPE_UNDEFINED
}

func (m *ModifiableComponent) GetParent() *Component {
	if m != nil {
		return m.Parent
	}
	return nil
}

func (m *ModifiableComponent) GetParentRelPos() int32 {
	if m != nil {
		return m.ParentRelPos
	}
	return 0
}

func (m *ModifiableComponent) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *ModifiableComponent) GetAssetId() string {
	if m != nil {
		return m.AssetId
	}
	return ""
}

func (m *ModifiableComponent) GetUri() *Uri {
	if m != nil {
		return m.Uri
	}
	return nil
}

func (m *ModifiableComponent) GetAdminState() ComponentAdminState {
	if m != nil {
		return m.AdminState
	}
	return ComponentAdminState_COMP_ADMIN_STATE_UNDEFINED
}

type isModifiableComponent_Specific interface {
	isModifiableComponent_Specific()
}

type ModifiableComponent_PortAttr struct {
	PortAttr *PortComponentChangeAttributes `protobuf:"bytes,50,opt,name=port_attr,json=portAttr,proto3,oneof"`
}

type ModifiableComponent_TrxAttr struct {
	TrxAttr *TransceiverComponentChangeAttributes `protobuf:"bytes,51,opt,name=trx_attr,json=trxAttr,proto3,oneof"`
}

func (*ModifiableComponent_PortAttr) isModifiableComponent_Specific() {}

func (*ModifiableComponent_TrxAttr) isModifiableComponent_Specific() {}

func (m *ModifiableComponent) GetSpecific() isModifiableComponent_Specific {
	if m != nil {
		return m.Specific
	}
	return nil
}

func (m *ModifiableComponent) GetPortAttr() *PortComponentChangeAttributes {
	if x, ok := m.GetSpecific().(*ModifiableComponent_PortAttr); ok {
		return x.PortAttr
	}
	return nil
}

func (m *ModifiableComponent) GetTrxAttr() *TransceiverComponentChangeAttributes {
	if x, ok := m.GetSpecific().(*ModifiableComponent_TrxAttr); ok {
		return x.TrxAttr
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ModifiableComponent) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ModifiableComponent_PortAttr)(nil),
		(*ModifiableComponent_TrxAttr)(nil),
	}
}

func init() {
	proto.RegisterEnum("dmi.ComponentType", ComponentType_name, ComponentType_value)
	proto.RegisterEnum("dmi.ComponentAdminState", ComponentAdminState_name, ComponentAdminState_value)
	proto.RegisterEnum("dmi.ComponentOperState", ComponentOperState_name, ComponentOperState_value)
	proto.RegisterEnum("dmi.ComponentUsageState", ComponentUsageState_name, ComponentUsageState_value)
	proto.RegisterEnum("dmi.ComponentAlarmState", ComponentAlarmState_name, ComponentAlarmState_value)
	proto.RegisterEnum("dmi.ComponentStandbyState", ComponentStandbyState_name, ComponentStandbyState_value)
	proto.RegisterEnum("dmi.DataValueType", DataValueType_name, DataValueType_value)
	proto.RegisterEnum("dmi.ValueScale", ValueScale_name, ValueScale_value)
	proto.RegisterEnum("dmi.SensorStatus", SensorStatus_name, SensorStatus_value)
	proto.RegisterEnum("dmi.TransceiverType", TransceiverType_name, TransceiverType_value)
	proto.RegisterEnum("dmi.PortComponentAttributes_ConnectorType", PortComponentAttributes_ConnectorType_name, PortComponentAttributes_ConnectorType_value)
	proto.RegisterEnum("dmi.PortComponentAttributes_Speed", PortComponentAttributes_Speed_name, PortComponentAttributes_Speed_value)
	proto.RegisterEnum("dmi.PortComponentAttributes_Protocol", PortComponentAttributes_Protocol_name, PortComponentAttributes_Protocol_value)
	proto.RegisterEnum("dmi.PsuComponentAttributes_SupportedVoltage", PsuComponentAttributes_SupportedVoltage_name, PsuComponentAttributes_SupportedVoltage_value)
	proto.RegisterEnum("dmi.TransceiverComponentsAttributes_FormFactor", TransceiverComponentsAttributes_FormFactor_name, TransceiverComponentsAttributes_FormFactor_value)
	proto.RegisterType((*Uuid)(nil), "dmi.Uuid")
	proto.RegisterType((*HardwareID)(nil), "dmi.HardwareID")
	proto.RegisterType((*Uri)(nil), "dmi.Uri")
	proto.RegisterType((*ComponentState)(nil), "dmi.ComponentState")
	proto.RegisterType((*ComponentSensorData)(nil), "dmi.ComponentSensorData")
	proto.RegisterType((*PortComponentAttributes)(nil), "dmi.PortComponentAttributes")
	proto.RegisterType((*PonDistance)(nil), "dmi.PonDistance")
	proto.RegisterType((*PortComponentChangeAttributes)(nil), "dmi.PortComponentChangeAttributes")
	proto.RegisterType((*TransceiverComponentChangeAttributes)(nil), "dmi.TransceiverComponentChangeAttributes")
	proto.RegisterType((*PonIdConfig)(nil), "dmi.PonIdConfig")
	proto.RegisterType((*ContainerComponentAttributes)(nil), "dmi.ContainerComponentAttributes")
	proto.RegisterType((*PsuComponentAttributes)(nil), "dmi.PsuComponentAttributes")
	proto.RegisterType((*TransceiverComponentsAttributes)(nil), "dmi.TransceiverComponentsAttributes")
	proto.RegisterType((*Component)(nil), "dmi.Component")
	proto.RegisterType((*Hardware)(nil), "dmi.Hardware")
	proto.RegisterType((*ModifiableComponent)(nil), "dmi.ModifiableComponent")
}

func init() { proto.RegisterFile("dmi/hw.proto", fileDescriptor_d7c33d745c4ab367) }

var fileDescriptor_d7c33d745c4ab367 = []byte{
	// 3060 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x59, 0xcd, 0x8e, 0xdb, 0xc8,
	0xf1, 0xb7, 0xbe, 0xa5, 0x92, 0x66, 0xa6, 0xa7, 0xfd, 0x35, 0xfe, 0x5a, 0xdb, 0x5a, 0x7b, 0x61,
	0xcf, 0x7f, 0x77, 0x66, 0x3c, 0xb6, 0xff, 0xf0, 0xee, 0x62, 0x11, 0x50, 0x14, 0x35, 0xe2, 0x5a,
	0x22, 0xb9, 0x4d, 0x6a, 0xec, 0xd9, 0x1c, 0x08, 0x8e, 0x44, 0x8d, 0x09, 0x48, 0xa2, 0x40, 0x52,
	0xe3, 0x31, 0x90, 0x53, 0x92, 0x7b, 0x9e, 0x20, 0xb7, 0x45, 0x90, 0x53, 0x0e, 0x41, 0x8e, 0x39,
	0x04, 0x08, 0x72, 0xcc, 0x03, 0xe4, 0x19, 0x72, 0xc8, 0x21, 0x0f, 0x90, 0xa0, 0xbb, 0x49, 0x8a,
	0xa2, 0x68, 0xaf, 0x17, 0xc8, 0xad, 0xbb, 0xea, 0x57, 0xd5, 0xd5, 0x55, 0xd5, 0xd5, 0x5d, 0x24,
	0x34, 0x46, 0x53, 0x67, 0xff, 0xcd, 0xdb, 0xbd, 0xb9, 0xe7, 0x06, 0x2e, 0x2e, 0x8c, 0xa6, 0xce,
	0xcd, 0xbb, 0x67, 0xae, 0x7b, 0x36, 0xb1, 0xf7, 0x19, 0xe9, 0x74, 0x31, 0xde, 0x0f, 0x9c, 0xa9,
	0xed, 0x07, 0xd6, 0x74, 0xce, 0x51, 0xcd, 0x9b, 0x50, 0x1c, 0x2c, 0x9c, 0x11, 0xc6, 0x50, 0x5c,
	0x2c, 0x9c, 0xd1, 0x4e, 0xee, 0x5e, 0xee, 0x51, 0x8d, 0xb0, 0x71, 0xf3, 0xff, 0x00, 0xba, 0x96,
	0x37, 0x7a, 0x6b, 0x79, 0xb6, 0xdc, 0xc6, 0x77, 0x12, 0x88, 0xfa, 0x61, 0x6d, 0x6f, 0x34, 0x75,
	0xf6, 0xa8, 0x68, 0x08, 0xbe, 0x0e, 0x85, 0x81, 0xe7, 0x60, 0x04, 0x85, 0x85, 0xe7, 0x84, 0x6a,
	0xe8, 0xb0, 0xf9, 0xeb, 0x02, 0x6c, 0x8a, 0xee, 0x74, 0xee, 0xce, 0xec, 0x59, 0xa0, 0x07, 0x56,
	0x60, 0xe3, 0x2e, 0x60, 0x9f, 0x0e, 0xcc, 0x89, 0xe5, 0x07, 0xe6, 0xf0, 0x8d, 0x35, 0x3b, 0xb3,
	0x23, 0xc5, 0x37, 0xf7, 0xb8, 0xc9, 0x7b, 0x91, 0xc9, 0x7b, 0x46, 0x64, 0x32, 0x41, 0x4c, 0xaa,
	0x67, 0xf9, 0x81, 0xc8, 0x65, 0xf0, 0x97, 0x50, 0xb7, 0x46, 0x53, 0x67, 0x66, 0x32, 0xce, 0x4e,
	0xfe, 0x5e, 0xee, 0xd1, 0xe6, 0xe1, 0x0e, 0xb3, 0x2d, 0x5e, 0x53, 0xa0, 0x00, 0xb6, 0x30, 0x01,
	0x2b, 0x1e, 0xe3, 0xff, 0x07, 0x70, 0xe7, 0xb6, 0x17, 0x4a, 0x16, 0x98, 0xe4, 0xf5, 0x55, 0x49,
	0x75, 0x6e, 0x7b, 0x5c, 0xb0, 0xe6, 0x46, 0x43, 0xba, 0xe4, 0xc2, 0xb7, 0xce, 0xec, 0x50, 0xb0,
	0x98, 0xb5, 0xe4, 0x80, 0x02, 0xc2, 0x25, 0x17, 0xf1, 0x98, 0x59, 0x3b, 0xb1, 0xbc, 0x69, 0x28,
	0x5a, 0xca, 0xb4, 0x96, 0x02, 0x22, 0x6b, 0xe3, 0x31, 0xfe, 0x19, 0x6c, 0xf8, 0x81, 0x35, 0x1b,
	0x9d, 0xbe, 0x0b, 0x85, 0xcb, 0x4c, 0xf8, 0xe6, 0xaa, 0xb0, 0xce, 0x21, 0x5c, 0xbc, 0xe1, 0x27,
	0x66, 0xcd, 0x7f, 0xe6, 0xe1, 0xf2, 0x12, 0x67, 0xcf, 0x7c, 0xd7, 0x6b, 0x5b, 0x81, 0x85, 0xaf,
	0x40, 0xe9, 0xdc, 0x9a, 0x2c, 0x6c, 0xe6, 0xfe, 0x12, 0xe1, 0x13, 0xfc, 0x19, 0x14, 0x83, 0x77,
	0xf3, 0xc8, 0xa1, 0x98, 0xad, 0x42, 0xe1, 0xc7, 0x94, 0x6b, 0xbc, 0x9b, 0xdb, 0x84, 0xf1, 0xf1,
	0x43, 0x28, 0xf9, 0x43, 0x6b, 0x12, 0xf9, 0x6f, 0x8b, 0x01, 0x19, 0x48, 0xa7, 0x64, 0xc2, 0xb9,
	0xf8, 0x36, 0xd4, 0xe6, 0x9e, 0x3d, 0x74, 0x7c, 0xc7, 0x9d, 0x31, 0x8f, 0x95, 0xc8, 0x92, 0x80,
	0x1f, 0x43, 0x99, 0xee, 0x69, 0xe1, 0x87, 0x1e, 0xd9, 0x66, 0x5a, 0xb8, 0x8d, 0x3a, 0x63, 0x90,
	0x10, 0x80, 0x3f, 0x85, 0x8d, 0xc5, 0xcc, 0x09, 0x7c, 0x73, 0xe4, 0xf8, 0xf3, 0x89, 0xf5, 0x8e,
	0xb9, 0xa1, 0x46, 0x1a, 0x8c, 0xd8, 0xe6, 0x34, 0xfc, 0x02, 0x6a, 0x71, 0x9a, 0xef, 0x54, 0x7e,
	0x34, 0xab, 0x96, 0x60, 0xbc, 0x0b, 0xdb, 0x6c, 0xff, 0xe6, 0x62, 0x3e, 0xa2, 0xf9, 0xe9, 0x51,
	0x4f, 0x57, 0xef, 0xe5, 0x1e, 0x6d, 0x90, 0x2d, 0xc6, 0x18, 0x30, 0x3a, 0xa1, 0x11, 0xb9, 0x05,
	0xb5, 0x91, 0x15, 0x58, 0x26, 0xf3, 0x53, 0x8d, 0x99, 0x51, 0xa5, 0x04, 0xea, 0x9d, 0xe6, 0xbf,
	0xca, 0x70, 0x5d, 0x73, 0xbd, 0x60, 0x19, 0xd6, 0x20, 0xf0, 0x9c, 0xd3, 0x45, 0x60, 0xfb, 0xf8,
	0x3b, 0xd8, 0x1c, 0xba, 0xb3, 0x99, 0x3d, 0x0c, 0x5c, 0x8f, 0x4b, 0xe7, 0xd8, 0xb6, 0x77, 0xd9,
	0xb6, 0xdf, 0x23, 0xb5, 0x27, 0x46, 0x22, 0xcc, 0xfb, 0x1b, 0xc3, 0xe4, 0x14, 0xbf, 0x80, 0x92,
	0x3f, 0xb7, 0xed, 0x51, 0x18, 0xaf, 0xe6, 0x07, 0x35, 0xe9, 0x14, 0x49, 0xb8, 0x00, 0x16, 0xa0,
	0xca, 0x5c, 0x32, 0x74, 0x27, 0x61, 0x0c, 0x1f, 0x7e, 0x50, 0x58, 0x0b, 0xc1, 0x24, 0x16, 0xc3,
	0x0f, 0x61, 0x73, 0xfe, 0xe6, 0x9d, 0xef, 0x0c, 0xad, 0x89, 0x39, 0xb1, 0x4e, 0xed, 0x09, 0x8b,
	0x70, 0x8d, 0x6c, 0x44, 0xd4, 0x1e, 0x25, 0xd2, 0xd0, 0x4d, 0xad, 0xf9, 0xdc, 0x99, 0x9d, 0x85,
	0xa8, 0x12, 0x0f, 0x5d, 0x48, 0xe4, 0xa0, 0x67, 0xb0, 0x31, 0x77, 0x67, 0xa6, 0x33, 0x32, 0x87,
	0xee, 0x6c, 0xec, 0x9c, 0xb1, 0xf8, 0xd6, 0x0f, 0x51, 0x68, 0xd3, 0x4c, 0x1e, 0x89, 0x8c, 0x4e,
	0xea, 0xf3, 0xe5, 0x04, 0x3f, 0x85, 0xab, 0x6c, 0x37, 0xa6, 0xb5, 0x08, 0xdc, 0x99, 0x7d, 0xe6,
	0x06, 0x8e, 0x15, 0xd0, 0x54, 0xa3, 0xc1, 0xaf, 0x92, 0x2b, 0x8c, 0x29, 0xac, 0xf2, 0xf0, 0xe7,
	0x50, 0x1d, 0x39, 0xf4, 0x88, 0x0c, 0x79, 0x88, 0x13, 0xab, 0xb4, 0x43, 0x3a, 0x89, 0x11, 0xcd,
	0x39, 0x6c, 0xac, 0x44, 0x00, 0xdf, 0x86, 0x1d, 0x51, 0x55, 0x14, 0x49, 0x34, 0x54, 0x62, 0x1a,
	0x27, 0x9a, 0x64, 0x0e, 0x94, 0xb6, 0xd4, 0x91, 0x15, 0xa9, 0x8d, 0x2e, 0xe1, 0x2a, 0x14, 0xc9,
	0xb7, 0xcf, 0x9e, 0xa3, 0x1c, 0x6e, 0x40, 0xb5, 0x23, 0xb7, 0x24, 0x62, 0xf6, 0x44, 0x94, 0xc7,
	0x5b, 0x50, 0xe7, 0x33, 0x5d, 0x34, 0x35, 0x11, 0x15, 0xf0, 0x06, 0xd4, 0x38, 0xa1, 0xaf, 0xa9,
	0xa8, 0x88, 0x6b, 0x50, 0x22, 0xfa, 0xe1, 0xd3, 0x43, 0x54, 0x6a, 0xfe, 0x21, 0x07, 0x25, 0x16,
	0x2a, 0x7c, 0x19, 0xb6, 0x74, 0x4d, 0x92, 0xda, 0x2b, 0x2b, 0xd4, 0xa1, 0xd2, 0x3e, 0x51, 0x84,
	0xbe, 0x2c, 0xa2, 0x1c, 0xd5, 0x72, 0x24, 0x1f, 0x09, 0x2d, 0xd9, 0x30, 0x9f, 0xa0, 0x3c, 0xde,
	0x04, 0x88, 0xa7, 0x07, 0xa8, 0x90, 0x9c, 0x1f, 0x3e, 0x47, 0xc5, 0xe4, 0xfc, 0xd9, 0x01, 0x2a,
	0x51, 0xab, 0x96, 0xf8, 0x03, 0x54, 0x4e, 0x12, 0x9e, 0x1d, 0x1c, 0xa0, 0x0a, 0x46, 0xd0, 0xe8,
	0x4b, 0x91, 0x86, 0x83, 0x03, 0x54, 0x4d, 0x52, 0x9e, 0x1c, 0x3e, 0x3f, 0x40, 0xb5, 0xe6, 0x2f,
	0xa0, 0x1a, 0x65, 0x07, 0xbe, 0x06, 0x58, 0x23, 0xaa, 0xa1, 0x8a, 0x6a, 0x6f, 0xc5, 0xea, 0x06,
	0x54, 0x25, 0xa3, 0x2b, 0x11, 0x45, 0x32, 0x50, 0x8e, 0x7a, 0xe9, 0x48, 0x53, 0x15, 0x94, 0xa7,
	0xfb, 0x7e, 0xcd, 0x86, 0x05, 0x0c, 0x50, 0x7e, 0x7d, 0xa4, 0xd3, 0x31, 0x73, 0xc7, 0x51, 0x47,
	0xd0, 0x0d, 0x54, 0xa2, 0x64, 0x5d, 0x22, 0xb2, 0xd0, 0x43, 0x65, 0x2a, 0x27, 0x51, 0x40, 0x85,
	0x8e, 0x5a, 0xb2, 0xa1, 0xa3, 0x6a, 0x73, 0x02, 0xf5, 0x44, 0xe4, 0xf0, 0x7d, 0x68, 0x4c, 0xad,
	0x0b, 0x33, 0x8e, 0x70, 0x8e, 0x1d, 0xe2, 0xfa, 0xd4, 0xba, 0x88, 0x21, 0x5f, 0xc1, 0x0d, 0x0e,
	0x19, 0x8f, 0x6d, 0xcf, 0x9e, 0x05, 0x8e, 0x35, 0x59, 0xe2, 0xf3, 0x0c, 0x7f, 0x9d, 0xe1, 0x97,
	0xfc, 0x48, 0xb6, 0xf9, 0xab, 0x1c, 0xdc, 0x59, 0x39, 0x22, 0xfc, 0x42, 0x4a, 0x9c, 0xf2, 0xb5,
	0x4c, 0xce, 0x7d, 0x4c, 0x26, 0x27, 0x93, 0x32, 0xff, 0xa3, 0x49, 0xf9, 0x73, 0x78, 0x60, 0x78,
	0xd6, 0xcc, 0x1f, 0xda, 0xce, 0xb9, 0xed, 0xbd, 0xdf, 0x96, 0xa7, 0x00, 0x01, 0xc5, 0x25, 0xab,
	0xcd, 0x15, 0xa6, 0x37, 0x21, 0xce, 0xea, 0x4a, 0x8d, 0xe1, 0x58, 0x09, 0x1b, 0x32, 0x87, 0xc6,
	0x96, 0x5d, 0x85, 0x32, 0xdf, 0x0f, 0x93, 0x6f, 0x90, 0x12, 0x33, 0x1b, 0x7f, 0x03, 0xb7, 0xc2,
	0x6d, 0x32, 0xc9, 0xa9, 0x13, 0x98, 0x73, 0xdb, 0x73, 0xdc, 0x91, 0x33, 0x74, 0x82, 0x77, 0xa1,
	0x1b, 0x77, 0x18, 0xd6, 0x08, 0x01, 0xda, 0x92, 0xdf, 0x94, 0xe0, 0xb6, 0xe8, 0xce, 0x02, 0xcb,
	0x99, 0x25, 0xec, 0x4f, 0x58, 0xbe, 0x5e, 0x5b, 0x72, 0x19, 0xb5, 0xa5, 0xf9, 0xb7, 0x1c, 0x5c,
	0xd3, 0xfc, 0x45, 0x96, 0x86, 0x13, 0xd8, 0xf6, 0x17, 0xf3, 0xb9, 0xeb, 0x05, 0xf6, 0xc8, 0x3c,
	0x77, 0x27, 0x81, 0x75, 0x16, 0xb9, 0xe0, 0x73, 0xee, 0xda, 0x4c, 0xb9, 0x3d, 0x3d, 0x12, 0x3a,
	0xe6, 0x32, 0x04, 0xf9, 0x29, 0x4a, 0x53, 0x03, 0x94, 0x46, 0xe1, 0xbb, 0x70, 0x4b, 0x1f, 0x68,
	0x9a, 0x4a, 0x0c, 0xa9, 0x6d, 0x1e, 0xab, 0x3d, 0x43, 0x38, 0x5a, 0xad, 0x0c, 0x15, 0x28, 0x1c,
	0x3f, 0x7b, 0xc1, 0x93, 0xff, 0xf8, 0xf0, 0xe9, 0x01, 0xca, 0xb3, 0xd1, 0x93, 0x27, 0xcf, 0x51,
	0xa1, 0xf9, 0xc7, 0x12, 0xdc, 0xcd, 0x8a, 0xa8, 0x9f, 0xd8, 0x90, 0x06, 0xf5, 0xb1, 0xeb, 0x4d,
	0xcd, 0xb1, 0x45, 0x6b, 0x51, 0xb8, 0x95, 0xfd, 0x74, 0x34, 0xb3, 0x44, 0xf7, 0x3a, 0xae, 0x37,
	0xed, 0x30, 0x31, 0x02, 0xe3, 0x78, 0x9c, 0x4a, 0x8f, 0xfc, 0x47, 0xa5, 0xc7, 0xda, 0x01, 0x2b,
	0xac, 0x1f, 0xb0, 0x6f, 0x00, 0x27, 0x21, 0x26, 0x7f, 0x29, 0x14, 0xb3, 0x5f, 0x0a, 0x28, 0x21,
	0xc9, 0x28, 0xf4, 0xc2, 0xf0, 0x2e, 0xcc, 0xb7, 0xd6, 0xb9, 0x3d, 0xb1, 0x67, 0x67, 0xc1, 0x9b,
	0x9d, 0xd2, 0xbd, 0xc2, 0xa3, 0x0d, 0xd2, 0xf0, 0x2e, 0x5e, 0xc5, 0x34, 0x0a, 0x0a, 0x56, 0x40,
	0x65, 0x0e, 0x0a, 0x92, 0xa0, 0xaf, 0x00, 0x2d, 0x11, 0xa1, 0x19, 0x95, 0x6c, 0x33, 0xb6, 0x96,
	0x40, 0x6e, 0xc5, 0x0d, 0xa8, 0x06, 0x17, 0xe6, 0xdc, 0x7d, 0x6b, 0x7b, 0x3b, 0xd5, 0x7b, 0x85,
	0x47, 0x25, 0x52, 0x09, 0x2e, 0x34, 0x3a, 0xc5, 0xcf, 0x61, 0x33, 0x62, 0x85, 0x4a, 0x6b, 0xd9,
	0x4a, 0x1b, 0xa1, 0x04, 0x9b, 0x35, 0xff, 0x9e, 0x03, 0x58, 0x46, 0x02, 0x5f, 0x87, 0xcb, 0x1d,
	0x95, 0xf4, 0xcd, 0x8e, 0xc0, 0xae, 0x92, 0x81, 0xf2, 0x52, 0x51, 0x5f, 0x29, 0xfc, 0x0e, 0xf9,
	0x4e, 0xef, 0x68, 0xbc, 0xbc, 0xd3, 0x91, 0xa9, 0xf5, 0x06, 0x3a, 0xca, 0xd3, 0x52, 0x48, 0xa7,
	0x87, 0x2f, 0x50, 0x81, 0xa6, 0x13, 0xc5, 0x14, 0x69, 0x65, 0x8d, 0x21, 0x25, 0x4a, 0x7e, 0xdd,
	0xd1, 0x78, 0xa9, 0x14, 0x3b, 0xda, 0x33, 0x5e, 0x2a, 0xc5, 0x8e, 0x76, 0x88, 0xaa, 0x6c, 0xa4,
	0x09, 0x2f, 0x51, 0x0d, 0x97, 0x21, 0xff, 0xfa, 0x10, 0x01, 0xad, 0xb3, 0x2a, 0x2d, 0xcb, 0xa8,
	0x4e, 0x25, 0xc5, 0x8e, 0x86, 0x1a, 0x54, 0x21, 0xc5, 0x9b, 0x82, 0xa8, 0xa2, 0x8d, 0x78, 0xd6,
	0x16, 0x55, 0xb4, 0x49, 0x2f, 0x1f, 0x66, 0x50, 0xbb, 0x8d, 0xb6, 0x9a, 0xff, 0xa8, 0x40, 0x2d,
	0x4e, 0x37, 0xda, 0x48, 0xcc, 0xac, 0xa9, 0x1d, 0x35, 0x12, 0x74, 0x8c, 0x1f, 0x41, 0x69, 0x38,
	0xb1, 0x7c, 0x7f, 0xe5, 0x39, 0x19, 0x8b, 0xb0, 0xcc, 0xe2, 0x00, 0x7c, 0x0f, 0xea, 0x23, 0xdb,
	0x1f, 0x7a, 0xce, 0x9c, 0xdd, 0xdf, 0x05, 0xa6, 0x24, 0x49, 0xc2, 0xd7, 0xa0, 0x3c, 0xb7, 0x68,
	0x39, 0x0e, 0x5f, 0x19, 0xe1, 0x0c, 0x3f, 0x80, 0x4d, 0x3e, 0x32, 0x3d, 0x7b, 0x62, 0xce, 0x5d,
	0xfe, 0x98, 0x2c, 0x91, 0x06, 0xa7, 0x12, 0x7b, 0xa2, 0xb9, 0x3e, 0xde, 0x85, 0xea, 0xf0, 0x8d,
	0x33, 0x19, 0x79, 0xf6, 0x8c, 0x65, 0x4a, 0xfd, 0x70, 0x73, 0xd5, 0x18, 0x12, 0xf3, 0x69, 0x86,
	0xbf, 0x09, 0xdb, 0x1f, 0xd3, 0xb3, 0xcf, 0x59, 0xc6, 0xd4, 0x48, 0x3d, 0xa2, 0x11, 0xfb, 0x9c,
	0x42, 0xc6, 0x8e, 0x37, 0x8d, 0x21, 0x55, 0x0e, 0x89, 0x68, 0x21, 0xc4, 0x77, 0xc7, 0x41, 0x0c,
	0xe1, 0x2f, 0xc5, 0x7a, 0x44, 0xa3, 0x90, 0x3b, 0x00, 0xbe, 0xed, 0xd1, 0xeb, 0x67, 0xb6, 0x98,
	0xee, 0x00, 0x03, 0xd4, 0x38, 0x45, 0x59, 0x4c, 0x69, 0x06, 0x4e, 0xc7, 0x67, 0x26, 0xf3, 0x6a,
	0x9d, 0x31, 0x2b, 0xd3, 0xf1, 0x99, 0x42, 0x1d, 0x7b, 0x07, 0x60, 0xea, 0x8e, 0xec, 0x09, 0x67,
	0x36, 0xb8, 0x24, 0xa3, 0x30, 0xf6, 0x15, 0x28, 0x59, 0x13, 0xc7, 0xf2, 0x77, 0x36, 0x18, 0x87,
	0x4f, 0xa8, 0x3e, 0xcb, 0xf7, 0xed, 0x80, 0xd6, 0xf2, 0x4d, 0xae, 0x8f, 0xcd, 0xe5, 0x11, 0x2d,
	0xf2, 0x8e, 0x6f, 0x8e, 0xbd, 0xc5, 0xce, 0x16, 0x7b, 0x39, 0x95, 0x1c, 0xbf, 0xe3, 0x2d, 0xf0,
	0x73, 0x6e, 0x01, 0x7d, 0xfa, 0xee, 0xa0, 0x1f, 0x7d, 0x4f, 0x53, 0xeb, 0xda, 0xf4, 0x85, 0x7c,
	0x93, 0xf7, 0x82, 0xdb, 0x4c, 0xa2, 0xca, 0x1b, 0x46, 0xcf, 0x61, 0x5d, 0x61, 0xdc, 0x4d, 0xe2,
	0xcc, 0x6e, 0x12, 0x3f, 0x86, 0x12, 0x6f, 0x73, 0x2e, 0x33, 0xfe, 0xe5, 0xb5, 0x36, 0x27, 0xa0,
	0xbd, 0x45, 0xd4, 0x54, 0xf9, 0xac, 0x55, 0xa0, 0xf6, 0x59, 0x3b, 0x57, 0x58, 0x54, 0x53, 0x4d,
	0xd5, 0xb2, 0xdf, 0x21, 0xe0, 0x2f, 0x7b, 0x9f, 0xaf, 0xa1, 0x46, 0xab, 0xb7, 0x69, 0x05, 0x81,
	0xb7, 0x73, 0xc8, 0x56, 0xba, 0xfd, 0xa1, 0xd7, 0x6f, 0xf7, 0x12, 0xa9, 0x52, 0x01, 0x4a, 0xc1,
	0xdf, 0xb2, 0x67, 0x3c, 0xbf, 0xba, 0xb8, 0x86, 0xa7, 0x4c, 0xc3, 0xfd, 0x70, 0xe9, 0xf7, 0xdf,
	0x6a, 0xdd, 0x4b, 0xec, 0xfd, 0xce, 0xf9, 0x4c, 0xd7, 0x0b, 0xa8, 0xce, 0xfd, 0x05, 0xd7, 0xf2,
	0x8c, 0x69, 0xb9, 0xf5, 0x81, 0xbb, 0xa9, 0x7b, 0x89, 0x54, 0xe6, 0xfe, 0x82, 0x49, 0x7e, 0x07,
	0x28, 0x58, 0x16, 0x69, 0xae, 0xe1, 0x39, 0xd3, 0xf0, 0xe0, 0x63, 0xae, 0x84, 0xee, 0x25, 0xb2,
	0x95, 0x90, 0xa7, 0x8c, 0x16, 0x40, 0xd5, 0x9f, 0xdb, 0x43, 0x67, 0xec, 0x0c, 0x9b, 0xbf, 0xcf,
	0x41, 0x35, 0xfa, 0x06, 0x80, 0xbf, 0x86, 0x7a, 0xa2, 0x61, 0xff, 0x88, 0x7e, 0x1d, 0x26, 0x71,
	0xab, 0x8e, 0x9b, 0x50, 0xf4, 0x5c, 0x37, 0x08, 0x5f, 0x35, 0xe9, 0x53, 0xc7, 0x78, 0xf1, 0x02,
	0xa7, 0xae, 0x1b, 0xd8, 0x23, 0x76, 0xfa, 0x3f, 0x62, 0x81, 0x16, 0x43, 0x37, 0xff, 0x52, 0x80,
	0xcb, 0x7d, 0x77, 0xe4, 0x8c, 0x1d, 0xeb, 0x74, 0x62, 0xff, 0xaf, 0x0a, 0xd2, 0x67, 0x71, 0xb9,
	0x29, 0x64, 0x1a, 0xfe, 0xfe, 0xf2, 0x53, 0xcc, 0x28, 0x3f, 0xf1, 0x81, 0x2c, 0xbd, 0xef, 0x40,
	0x96, 0x57, 0x0f, 0x64, 0x78, 0x84, 0x2a, 0x59, 0x47, 0x28, 0xf5, 0xed, 0xa3, 0xfa, 0x13, 0xbe,
	0x7d, 0x08, 0xeb, 0x89, 0x9f, 0xd1, 0x33, 0xa6, 0xdf, 0x91, 0x2b, 0xe9, 0xdf, 0x81, 0x6a, 0xe0,
	0x5d, 0x24, 0x13, 0xff, 0xf1, 0x7b, 0x13, 0x2e, 0x43, 0x51, 0x25, 0xf0, 0x2e, 0xd2, 0xd9, 0xb6,
	0xfb, 0xa7, 0x02, 0xed, 0xb2, 0x12, 0x51, 0xe0, 0x5d, 0x56, 0x5f, 0x53, 0x15, 0x49, 0x31, 0xd6,
	0xbb, 0xac, 0x9b, 0x70, 0x6d, 0x8d, 0xcb, 0x6f, 0xcf, 0x5c, 0x06, 0x4f, 0xec, 0x0a, 0xba, 0x2e,
	0xd3, 0x0b, 0x74, 0x5d, 0x6b, 0x4b, 0x10, 0x5f, 0x6a, 0x3d, 0x41, 0x91, 0x50, 0x21, 0x83, 0x2b,
	0xaa, 0x8a, 0x21, 0xc8, 0x8a, 0x44, 0x50, 0x91, 0x3e, 0xf0, 0x52, 0x5c, 0x4d, 0x7d, 0x45, 0x1b,
	0xba, 0x81, 0xa6, 0xf5, 0x4e, 0x50, 0x89, 0xb6, 0x3e, 0x29, 0x40, 0x47, 0x50, 0x50, 0x19, 0xdf,
	0x80, 0xab, 0x29, 0xba, 0x2e, 0x29, 0xba, 0x4a, 0x50, 0x25, 0x83, 0xd5, 0x57, 0xdb, 0x83, 0x9e,
	0x84, 0xaa, 0xf4, 0x75, 0xb0, 0xb6, 0x1c, 0x31, 0x50, 0x2d, 0x63, 0x19, 0x51, 0x1b, 0x20, 0xc8,
	0xd8, 0x77, 0x4b, 0x30, 0x0c, 0x89, 0x9c, 0xa0, 0x7a, 0x06, 0x4f, 0x37, 0x54, 0x22, 0x1c, 0x49,
	0xa8, 0x91, 0x65, 0x83, 0xd4, 0x57, 0xc9, 0x09, 0xda, 0xc0, 0x9f, 0xc0, 0xcd, 0x14, 0xcb, 0x20,
	0x82, 0xa2, 0x8b, 0x92, 0x7c, 0x2c, 0x11, 0xb4, 0xb9, 0xfb, 0xef, 0x5c, 0xe2, 0xd3, 0xd2, 0x32,
	0xe3, 0x22, 0x39, 0x53, 0x68, 0xf7, 0x65, 0xc5, 0xd4, 0x0d, 0xc1, 0x58, 0x0d, 0x5f, 0xe8, 0xe8,
	0x14, 0x3f, 0x0a, 0xe0, 0x2d, 0xb8, 0xbe, 0xc6, 0xed, 0xa9, 0xe2, 0x4b, 0xa9, 0x8d, 0xf2, 0xb8,
	0x09, 0x9f, 0xac, 0x31, 0xf5, 0xee, 0xc0, 0x30, 0x64, 0xe5, 0xc8, 0x6c, 0x53, 0x05, 0x05, 0x7c,
	0x07, 0x6e, 0x64, 0xa8, 0x0f, 0x55, 0x14, 0x33, 0xd9, 0xb2, 0xae, 0xf6, 0x04, 0x43, 0x6a, 0xa3,
	0x72, 0x14, 0xe7, 0x15, 0xb6, 0x46, 0xd4, 0xae, 0xdc, 0x92, 0x29, 0xa0, 0xb4, 0xfb, 0xd7, 0x02,
	0xe0, 0xf5, 0x2f, 0x85, 0xb1, 0x5a, 0x55, 0xa3, 0x49, 0xb1, 0xb6, 0xe7, 0x68, 0x57, 0x2b, 0xec,
	0x68, 0xcb, 0x91, 0x43, 0x12, 0xcc, 0xb6, 0xac, 0x0b, 0xad, 0x1e, 0xdb, 0x73, 0x86, 0xa8, 0xa4,
	0x70, 0x66, 0x21, 0x8b, 0x69, 0x48, 0x3a, 0x75, 0x07, 0x2a, 0x46, 0x71, 0x4f, 0x32, 0x15, 0x95,
	0xf4, 0x85, 0x1e, 0x2a, 0xc5, 0xfb, 0x4c, 0xf0, 0x44, 0x55, 0xe9, 0xc8, 0x47, 0x03, 0x42, 0x85,
	0xcb, 0xf8, 0x21, 0xdc, 0x4f, 0x03, 0x84, 0x81, 0xa1, 0xf6, 0x05, 0x43, 0x16, 0xcd, 0x9e, 0x2a,
	0xb4, 0x29, 0xac, 0x92, 0xb5, 0x46, 0x47, 0x90, 0xa9, 0x71, 0x55, 0xfc, 0x19, 0x34, 0xd3, 0xbc,
	0xae, 0x7c, 0xd4, 0x35, 0x0d, 0xa9, 0xaf, 0xb1, 0xb0, 0xb1, 0x88, 0xd5, 0xf0, 0xa7, 0x70, 0x37,
	0x8d, 0xeb, 0x0b, 0xca, 0x40, 0xe8, 0x2d, 0x41, 0x80, 0x1f, 0xc3, 0xc3, 0x34, 0x28, 0x3c, 0x81,
	0xc2, 0x31, 0x8d, 0x7e, 0x0c, 0xad, 0xe3, 0xfb, 0x70, 0x67, 0xcd, 0x29, 0x2c, 0xb3, 0x65, 0xbd,
	0x2f, 0x18, 0x62, 0x17, 0x35, 0x76, 0x7f, 0x97, 0xcc, 0xdd, 0xe5, 0x67, 0xdb, 0x38, 0x77, 0x07,
	0x3a, 0x6d, 0xe0, 0xde, 0x9f, 0xbb, 0xab, 0xfc, 0x28, 0x90, 0xe1, 0x61, 0x5a, 0xe1, 0xca, 0xed,
	0x9e, 0x94, 0x88, 0x62, 0x92, 0x25, 0x88, 0x86, 0x7c, 0x4c, 0x4b, 0x4f, 0x96, 0x5c, 0x6b, 0xa0,
	0x9f, 0xa0, 0xe2, 0xee, 0x6f, 0x92, 0xdf, 0x6f, 0x97, 0x1f, 0x89, 0x97, 0x87, 0xac, 0x27, 0x90,
	0xfe, 0x87, 0x0e, 0xd9, 0x0a, 0x3f, 0x32, 0x34, 0xf2, 0x50, 0x5a, 0x9a, 0x98, 0x44, 0xd2, 0x04,
	0x99, 0xa0, 0xfc, 0xf2, 0x9c, 0x24, 0x20, 0x22, 0x91, 0x0d, 0x59, 0x14, 0x7a, 0xa8, 0x10, 0xc7,
	0x3d, 0xc9, 0xee, 0x0b, 0xdf, 0xaa, 0x24, 0x91, 0x77, 0x2b, 0x3c, 0x59, 0x51, 0x09, 0x2a, 0x65,
	0xda, 0xf5, 0x4a, 0x20, 0x0a, 0x4f, 0xba, 0xf8, 0x7c, 0x27, 0xb8, 0xb2, 0xd2, 0x96, 0x0c, 0x89,
	0xf4, 0x65, 0x45, 0x30, 0x24, 0x54, 0xd9, 0xfd, 0x73, 0x0e, 0xae, 0x66, 0x7e, 0xf9, 0xc6, 0xf7,
	0xe0, 0x36, 0x93, 0xd6, 0x0d, 0x41, 0x69, 0xb7, 0x4e, 0x32, 0xbc, 0x12, 0x79, 0x2d, 0x8d, 0x48,
	0xdd, 0x1e, 0x29, 0x7e, 0x57, 0x35, 0x12, 0x11, 0x5c, 0xe5, 0x89, 0x6a, 0x8f, 0x9e, 0xc3, 0x47,
	0xf0, 0x20, 0x83, 0xa9, 0x11, 0xf5, 0x58, 0x6e, 0xb3, 0xec, 0x94, 0xc8, 0xb1, 0x2c, 0x4a, 0xa8,
	0xb8, 0xfb, 0xdb, 0x02, 0x6c, 0xac, 0x7c, 0x52, 0xc7, 0x3b, 0x70, 0xe5, 0x58, 0xe8, 0x0d, 0xa4,
	0xf5, 0x8b, 0xee, 0x0a, 0xa0, 0x04, 0x87, 0xb7, 0x6a, 0x39, 0x7a, 0x05, 0xac, 0xe0, 0xb9, 0xf1,
	0x79, 0x7a, 0x67, 0x24, 0xe8, 0xc7, 0x6a, 0xcf, 0xd0, 0x4d, 0x41, 0x44, 0x85, 0x4c, 0x46, 0x5b,
	0x44, 0xc5, 0x94, 0x26, 0xa1, 0xaf, 0x49, 0x44, 0xa2, 0x6d, 0xe4, 0xea, 0xba, 0xaf, 0x04, 0xc3,
	0xd0, 0x51, 0x39, 0x45, 0xed, 0x4a, 0xc4, 0xf8, 0x1e, 0x55, 0x52, 0x3a, 0x44, 0xa9, 0xa7, 0xcb,
	0x03, 0x1d, 0x55, 0x69, 0x4e, 0x27, 0xe8, 0x9a, 0x44, 0x44, 0x7a, 0x8d, 0x90, 0x2e, 0xaa, 0x61,
	0x0c, 0x9b, 0x09, 0x16, 0xd1, 0xfa, 0x08, 0x52, 0x34, 0xb1, 0xdf, 0xe7, 0xf7, 0x56, 0x82, 0x66,
	0x90, 0x81, 0xd1, 0x35, 0x19, 0x01, 0x35, 0x52, 0xcb, 0x86, 0xea, 0xd1, 0x06, 0xbe, 0x0a, 0xdb,
	0x09, 0x7a, 0x9f, 0x66, 0x8e, 0x8e, 0x36, 0x53, 0xb6, 0xb7, 0x4e, 0x0c, 0x49, 0x47, 0x5b, 0xa9,
	0x45, 0xdb, 0xad, 0x3e, 0x42, 0xbb, 0x3f, 0x14, 0x00, 0x96, 0x3d, 0xfc, 0x72, 0x1b, 0xba, 0x28,
	0xf4, 0x56, 0xa3, 0x13, 0x2f, 0xc5, 0x59, 0x27, 0xaa, 0x68, 0xa8, 0x28, 0x97, 0x26, 0x7f, 0x2f,
	0x69, 0x86, 0x8a, 0xf2, 0x4b, 0x0b, 0x38, 0x59, 0x30, 0x0c, 0x15, 0x15, 0xd2, 0xe0, 0x8e, 0xd4,
	0x37, 0x54, 0x54, 0x4c, 0x83, 0x35, 0x59, 0x54, 0x93, 0x61, 0xe1, 0x54, 0x45, 0x50, 0x54, 0x54,
	0x4e, 0xab, 0xe8, 0xcb, 0x22, 0x51, 0x51, 0x65, 0x9d, 0xdc, 0xeb, 0xc9, 0xa8, 0x9a, 0x26, 0x0f,
	0x14, 0xd9, 0xd0, 0x51, 0x2d, 0xad, 0xfa, 0xa5, 0xdc, 0x53, 0x11, 0xa4, 0xa9, 0x7d, 0xe9, 0x48,
	0x40, 0xf5, 0x34, 0xf5, 0x48, 0x3e, 0x12, 0x50, 0x23, 0x4d, 0x35, 0x24, 0x22, 0xa0, 0x8d, 0xb5,
	0x8d, 0x48, 0x86, 0x80, 0x36, 0xf1, 0x65, 0xd8, 0x4a, 0x52, 0xa5, 0xd7, 0x02, 0xda, 0x5a, 0xf7,
	0x9b, 0x61, 0x08, 0x08, 0xad, 0x7b, 0x99, 0x92, 0xb7, 0x77, 0x7f, 0x99, 0x83, 0x46, 0xf2, 0x57,
	0x11, 0x3d, 0x9e, 0xfc, 0x61, 0xc5, 0xce, 0xde, 0x40, 0x4f, 0x1f, 0xa4, 0x55, 0xa6, 0xfa, 0x12,
	0xe5, 0x68, 0x89, 0x4b, 0x8b, 0x08, 0xc7, 0x82, 0xdc, 0xa3, 0x97, 0x2b, 0xca, 0xd3, 0x72, 0xb2,
	0xca, 0x56, 0x54, 0x85, 0x5e, 0x29, 0x82, 0x21, 0xab, 0x0a, 0x2d, 0x82, 0xbb, 0x3f, 0xe4, 0x60,
	0x2b, 0xf5, 0xad, 0x8c, 0xe6, 0xd4, 0xda, 0x39, 0xfe, 0x89, 0x9f, 0xbf, 0xd9, 0x87, 0x1a, 0x55,
	0x41, 0x25, 0x5c, 0x87, 0x8a, 0x72, 0x64, 0x6a, 0xaa, 0x72, 0xb8, 0xf2, 0xf9, 0xfb, 0x2a, 0x6c,
	0x8b, 0x6a, 0xbf, 0xa5, 0x9a, 0x54, 0xd8, 0x0c, 0xe5, 0xaa, 0xf8, 0x1a, 0x6c, 0xb3, 0xa5, 0x15,
	0xd5, 0x30, 0x69, 0xcd, 0x14, 0xe9, 0x8b, 0xe5, 0x3f, 0xb9, 0xd6, 0xd7, 0xdf, 0x7f, 0x79, 0xe6,
	0x04, 0x6f, 0x16, 0xa7, 0x7b, 0x43, 0x77, 0xba, 0xef, 0xce, 0xed, 0xd9, 0xd0, 0xf5, 0x46, 0xfb,
	0x23, 0xfb, 0xdc, 0x19, 0xda, 0x5f, 0x4c, 0xad, 0x99, 0x75, 0x66, 0x4f, 0xed, 0x59, 0xf0, 0x85,
	0x33, 0x0b, 0x6c, 0x6f, 0x6c, 0x0d, 0xed, 0xfd, 0xf3, 0xa7, 0xfb, 0x67, 0xee, 0xfe, 0x68, 0xea,
	0x9c, 0x96, 0x59, 0xff, 0xf5, 0xf4, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x6b, 0xb1, 0xa0, 0x6b,
	0x66, 0x1e, 0x00, 0x00,
}
