

dmi/commons.protodmi*?
Status
UNDEFINED_STATUS 
	OK_STATUS
ERROR_STATUS*?
LogLevel	
TRACE 	
DEBUG
INFO
WARN	
ERRORB;Z9github.com/opencord/device-management-interface/v3/go/dmiJ
  

  

 P
	
 P

 
T
  2H Common structures used across the different Device Management services



 

  

  

  

 	

 	

 	

 


 


 


 
Log Level





 

 	

 



	

















	


bproto3
/
google/protobuf/timestamp.protogoogle.protobuf";
	Timestamp
seconds (Rseconds
nanos (RnanosB~
com.google.protobufBTimestampProtoPZ+github.com/golang/protobuf/ptypes/timestampGPBGoogle.Protobuf.WellKnownTypesJ-
 

 2 Protocol Buffers - Google's data interchange format
 Copyright 2008 Google Inc.  All rights reserved.
 https://developers.google.com/protocol-buffers/

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are
 met:

     * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above
 copyright notice, this list of conditions and the following disclaimer
 in the documentation and/or other materials provided with the
 distribution.
     * Neither the name of Google Inc. nor the names of its
 contributors may be used to endorse or promote products derived from
 this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


  

" ;
	
%" ;

# 
	
# 

$ B
	
$ B

% ,
	
% ,

& /
	
& /

' "
	

' "

( !
	
$( !

 |  A Timestamp represents a point in time independent of any time zone or local
 calendar, encoded as a count of seconds and fractions of seconds at
 nanosecond resolution. The count is relative to an epoch at UTC midnight on
 January 1, 1970, in the proleptic Gregorian calendar which extends the
 Gregorian calendar backwards to year one.

 All minutes are 60 seconds long. Leap seconds are "smeared" so that no leap
 second table is needed for interpretation, using a [24-hour linear
 smear](https://developers.google.com/time/smear).

 The range is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z. By
 restricting to that range, we ensure that we can convert to and from [RFC
 3339](https://www.ietf.org/rfc/rfc3339.txt) date strings.

 # Examples

 Example 1: Compute Timestamp from POSIX `time()`.

     Timestamp timestamp;
     timestamp.set_seconds(time(NULL));
     timestamp.set_nanos(0);

 Example 2: Compute Timestamp from POSIX `gettimeofday()`.

     struct timeval tv;
     gettimeofday(&tv, NULL);

     Timestamp timestamp;
     timestamp.set_seconds(tv.tv_sec);
     timestamp.set_nanos(tv.tv_usec * 1000);

 Example 3: Compute Timestamp from Win32 `GetSystemTimeAsFileTime()`.

     FILETIME ft;
     GetSystemTimeAsFileTime(&ft);
     UINT64 ticks = (((UINT64)ft.dwHighDateTime) << 32) | ft.dwLowDateTime;

     // A Windows tick is 100 nanoseconds. Windows epoch 1601-01-01T00:00:00Z
     // is 11644473600 seconds before Unix epoch 1970-01-01T00:00:00Z.
     Timestamp timestamp;
     timestamp.set_seconds((INT64) ((ticks / 10000000) - 11644473600LL));
     timestamp.set_nanos((INT32) ((ticks % 10000000) * 100));

 Example 4: Compute Timestamp from Java `System.currentTimeMillis()`.

     long millis = System.currentTimeMillis();

     Timestamp timestamp = Timestamp.newBuilder().setSeconds(millis / 1000)
         .setNanos((int) ((millis % 1000) * 1000000)).build();


 Example 5: Compute Timestamp from current time in Python.

     timestamp = Timestamp()
     timestamp.GetCurrentTime()

 # JSON Mapping

 In JSON format, the Timestamp type is encoded as a string in the
 [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format. That is, the
 format is "{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z"
 where {year} is always expressed using four digits while {month}, {day},
 {hour}, {min}, and {sec} are zero-padded to two digits each. The fractional
 seconds, which can go up to 9 digits (i.e. up to 1 nanosecond resolution),
 are optional. The "Z" suffix indicates the timezone ("UTC"); the timezone
 is required. A proto3 JSON serializer should always use UTC (as indicated by
 "Z") when printing the Timestamp type and a proto3 JSON parser should be
 able to accept both UTC and other timezones (as indicated by an offset).

 For example, "2017-01-15T01:30:15.01Z" encodes 15.01 seconds past
 01:30 UTC on January 15, 2017.

 In JavaScript, one can convert a Date object to this format using the
 standard [toISOString()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString)
 method. In Python, a standard `datetime.datetime` object can be converted
 to this format using [`strftime`](https://docs.python.org/2/library/time.html#time.strftime)
 with the time format spec '%Y-%m-%dT%H:%M:%S.%fZ'. Likewise, in Java, one
 can use the Joda Time's [`ISODateTimeFormat.dateTime()`](
 http://www.joda.org/joda-time/apidocs/org/joda/time/format/ISODateTimeFormat.html#dateTime%2D%2D
 ) to obtain a formatter capable of generating timestamps in this format.





 |

   Represents seconds of UTC time since Unix epoch
 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
 9999-12-31T23:59:59Z inclusive.


  |

  

  

  

  Non-negative fractions of a second at nanosecond resolution. Negative
 second values with fractions must still have non-negative nanos values
 that count forward in time. Must be from 0 to 999,999,999
 inclusive.


 

 

 

 bproto3

dmi/hw.protodmigoogle/protobuf/timestamp.proto"
Uuid
uuid (	Ruuid"+

HardwareID
uuid (2	.dmi.UuidRuuid"
Uri
uri (	Ruri"
ComponentStateH
state_last_changed (2.google.protobuf.TimestampRstateLastChanged9
admin_state (2.dmi.ComponentAdminStateR
adminState6

oper_state (2.dmi.ComponentOperStateR	operState9
usage_state (2.dmi.ComponentUsageStateR
usageState9
alarm_state (2.dmi.ComponentAlarmStateR
alarmState?

standby_state (2.dmi.ComponentStandbyStateRstandbyState"
ComponentSensorData
value (Rvalue&
type (2.dmi.DataValueTypeRtype%
scale (2.dmi.ValueScaleRscale
	precision (R	precision)
status (2.dmi.SensorStatusRstatus#

units_display (	RunitsDisplay8
	timestamp (2.google.protobuf.TimestampR	timestamp*
value_update_rate (
RvalueUpdateRate
	data_type	 (	RdataType"
PortComponentAttributesQ
connector_type (2*.dmi.PortComponentAttributes.ConnectorTypeR
connectorType8
speed (2".dmi.PortComponentAttributes.SpeedRspeedA
protocol (2%.dmi.PortComponentAttributes.ProtocolRprotocol%
physical_label (	R
physicalLabel#

mapping_label (	RmappingLabel4

pon_id_config (2.dmi.PonIdConfigRponIdConfig3
speed_autonegotiation (RspeedAutonegotiation,
distance (2.dmi.PonDistanceRdistance"p

ConnectorType
CONNECTOR_TYPE_UNDEFINED 
RJ45
FIBER_LC
FIBER_SC_PC
	FIBER_MPO	
RS232"
Speed
SPEED_UNDEFINED 
DYNAMIC
	GIGABIT_1

GIGABIT_10

GIGABIT_25

GIGABIT_40
GIGABIT_100
GIGABIT_400
MEGABIT_2500
MEGABIT_1250	"|
Protocol
PROTOCOL_UNDEFINED 
ETHERNET
GPON	
XGPON

XGSPON	
GFAST

SERIAL
EPON
BITS"l
PonDistance!
max_distance (
RmaxDistance:
max_differential_distance (
RmaxDifferentialDistance"
PortComponentChangeAttributes4

pon_id_config (2.dmi.PonIdConfigRponIdConfig,
distance (2.dmi.PonDistanceRdistance"[
$TransceiverComponentChangeAttributes3

trans_type (2.dmi.TransceiverTypeR	transType"c
PonIdConfig
pon_id (RponId=
pon_id_transmit_periodicity (
RponIdTransmitPeriodicity"E
ContainerComponentAttributes%
physical_label (	R
physicalLabel"
PsuComponentAttributesY
supported_voltage (2,.dmi.PsuComponentAttributes.SupportedVoltageRsupportedVoltage"P
SupportedVoltage
SUPPORTED_VOLTAGE_UNDEFINED 
V48
V230
V115"
TransceiverComponentsAttributesP
form_factor (2/.dmi.TransceiverComponentsAttributes.FormFactorR
formFactor3

trans_type (2.dmi.TransceiverTypeR	transType!
max_distance (
RmaxDistance=
max_distance_scale (2.dmi.ValueScaleRmaxDistanceScale#

rx_wavelength (
RrxWavelength#

tx_wavelength (
RtxWavelength:
wavelength_scale (2.dmi.ValueScaleRwavelengthScale
tx_power (RtxPower5
tx_power_scale	 (2.dmi.ValueScaleRtxPowerScale"

FormFactor
FORM_FACTOR_UNKNOWN 
QSFP
	QSFP_PLUS

QSFP28
SFP
SFP_PLUS
XFP
CFP4
CFP2
CPAK	
X2
	
OTHER
CFP
CFP2_ACO

CFP2_DCO
QSFP_DD"
	Component
name (	Rname(
class (2.dmi.ComponentTypeRclass 
description (	Rdescription
parent (	Rparent$
parent_rel_pos (RparentRelPos*
children (2.dmi.ComponentRchildren!
hardware_rev (	RhardwareRev!
firmware_rev (	RfirmwareRev!
software_rev	 (	RsoftwareRev

serial_num
 (	R	serialNum
mfg_name (	RmfgName

model_name (	R	modelName
alias
 (	Ralias
asset_id (	RassetId
is_fru (RisFru5
mfg_date (2.google.protobuf.TimestampRmfgDate
uri (2.dmi.UriRuri
uuid (2	.dmi.UuidRuuid)
state (2.dmi.ComponentStateRstate9
sensor_data (2.dmi.ComponentSensorDataR
sensorData;
	port_attr2 (2.dmi.PortComponentAttributesH RportAttrJ
container_attr3 (2!.dmi.ContainerComponentAttributesH R
containerAttr8
psu_attr4 (2.dmi.PsuComponentAttributesH RpsuAttrQ
transceiver_attr5 (2$.dmi.TransceiverComponentsAttributesH RtransceiverAttrB

specific"
Hardware;
last_change (2.google.protobuf.TimestampR
lastChange"
root (2.dmi.ComponentRroot;
last_booted (2.google.protobuf.TimestampR
lastBooted"
ModifiableComponent
name (	Rname(
class (2.dmi.ComponentTypeRclass&
parent (2.dmi.ComponentRparent$
parent_rel_pos (RparentRelPos
alias (	Ralias
asset_id (	RassetId
uri (2.dmi.UriRuri9
admin_state (2.dmi.ComponentAdminStateR
adminStateA
	port_attr2 (2".dmi.PortComponentChangeAttributesH RportAttrF
trx_attr3 (2).dmi.TransceiverComponentChangeAttributesH RtrxAttrB

specific*

ComponentType
COMPONENT_TYPE_UNDEFINED 
COMPONENT_TYPE_UNKNOWN
COMPONENT_TYPE_CHASSIS
COMPONENT_TYPE_BACKPLANE
COMPONENT_TYPE_CONTAINER
COMPONENT_TYPE_POWER_SUPPLY
COMPONENT_TYPE_FAN
COMPONENT_TYPE_SENSOR
COMPONENT_TYPE_MODULE
COMPONENT_TYPE_PORT	
COMPONENT_TYPE_CPU

COMPONENT_TYPE_BATTERY
COMPONENT_TYPE_STORAGE
COMPONENT_TYPE_MEMORY

COMPONENT_TYPE_TRANSCEIVER*
ComponentAdminState
COMP_ADMIN_STATE_UNDEFINED 
COMP_ADMIN_STATE_UNKNOWN
COMP_ADMIN_STATE_LOCKED"
COMP_ADMIN_STATE_SHUTTING_DOWN
COMP_ADMIN_STATE_UNLOCKED
COMP_ADMIN_STATE_ISOLATED
COMP_ADMIN_STATE_PROHIBITED*
ComponentOperState
COMP_OPER_STATE_UNDEFINED 
COMP_OPER_STATE_UNKNOWN
COMP_OPER_STATE_DISABLED
COMP_OPER_STATE_ENABLED
COMP_OPER_STATE_TESTING
COMP_OPER_STATE_NORMAL
COMP_OPER_STATE_CONFIGURING%
!COMP_OPER_STATE_AUTOMATIC_LOADING
COMP_OPER_STATE_FAILED&
"COMP_OPER_STATE_HIGH_TEMP_SHUTDOWN	#
COMP_OPER_STATE_MANUAL_SHUTDOWN
)
%COMP_OPER_STATE_POWER_SAVING_SHUTDOWN!
COMP_OPER_STATE_TYPE_MISMATCH*
ComponentUsageState
COMP_USAGE_STATE_UNDEFINED 
COMP_USAGE_STATE_UNKNOWN
COMP_USAGE_STATE_IDLE
COMP_USAGE_STATE_ACTIVE
COMP_USAGE_STATE_BUSY*
ComponentAlarmState
COMP_ALARM_STATE_UNDEFINED 
COMP_ALARM_STATE_UNKNOWN!
COMP_ALARM_STATE_UNDER_REPAIR
COMP_ALARM_STATE_CRITICAL
COMP_ALARM_STATE_MAJOR
COMP_ALARM_STATE_MINOR
COMP_ALARM_STATE_WARNING"
COMP_ALARM_STATE_INDETERMINATE*
ComponentStandbyState 
COMP_STANDBY_STATE_UNDEFINED 
COMP_STANDBY_STATE_UNKNOWN
COMP_STANDBY_STATE_HOT
COMP_STANDBY_STATE_COLD(
$COMP_STANDBY_STATE_PROVIDING_SERVICE*

DataValueType
VALUE_TYPE_UNDEFINED 
VALUE_TYPE_OTHER
VALUE_TYPE_UNKNOWN
VALUE_TYPE_VOLTS_AC
VALUE_TYPE_VOLTS_DC
VALUE_TYPE_AMPERES
VALUE_TYPE_WATTS
VALUE_TYPE_HERTZ
VALUE_TYPE_CELSIUS
VALUE_TYPE_PERCENT_RH	
VALUE_TYPE_RPM

VALUE_TYPE_CMM
VALUE_TYPE_TRUTH_VALUE
VALUE_TYPE_PERCENT

VALUE_TYPE_METERS
VALUE_TYPE_BYTES
VALUE_TYPE_DBM*

ValueScale
VALUE_SCALE_UNDEFINED 
VALUE_SCALE_YOCTO
VALUE_SCALE_ZEPTO
VALUE_SCALE_ATTO
VALUE_SCALE_FEMTO
VALUE_SCALE_PICO
VALUE_SCALE_NANO
VALUE_SCALE_MICRO
VALUE_SCALE_MILLI
VALUE_SCALE_UNITS	
VALUE_SCALE_KILO

VALUE_SCALE_MEGA
VALUE_SCALE_GIGA
VALUE_SCALE_TERA

VALUE_SCALE_PETA
VALUE_SCALE_EXA
VALUE_SCALE_ZETTA
VALUE_SCALE_YOTTA*
SensorStatus
SENSOR_STATUS_UNDEFINED 
SENSOR_STATUS_OK
SENSOR_STATUS_UNAVAILABLE 
SENSOR_STATUS_NONOPERATIONAL*
TransceiverType
TYPE_UNDEFINED 
ETHERNET
GPON	
XGPON

XGSPON
CPON
NG_PON2
EPON
COMBO_GPON_XGSPON
TYPE_NOT_DETECTEDB;Z9github.com/opencord/device-management-interface/v3/go/dmiJ
  

  

 P
	
 P

 
	
  )
i
 	 2] The model used to represent a HW is based on RFC8348 (https://tools.ietf.org/html/rfc8348)



 	

  


  
	

  



  


  




 





 

 


 

 	

 


 




 

 

 


 

 


  &


 

  !

  

   

 

 

 

 

 

 

 !

 

  

 !

 

  

 $

 

 "#

 

 

 

 

 

 

 

 

 

 	

 	

 	

 
 

 
 

 
 

 ! 

 !

 !

 " 

 "

 "

 
#

 
#

 
#
m
 %$` A component of type "TRANSCEIVER" could have 0 or more components of type "PORT" as children.


 %

 %!#


( 4


(

 )#

 )

 )!"

*!

*

* 

+ 

+

+

,'

,"

,%&

-"

-

- !

0" Indicates that the component is in a prohibited administrative state, meaning operations are not allowed.
 Typically used to enforce security or policy restrictions.


0

0 !

3$ Indicates that the component is administratively isolated from the rest of the system.
 Used when a component must be separated for maintenance, troubleshooting, or security reasons.


3

3"#


6 M


6

 7"

 7

 7 !

8 

8

8

9!

9

9 

: 

:

:

; 

;

;
C
=6 Indicates that the component is operating normally.


=

=
K
?$> Indicates that the component is currently being configured.


?

?"#
`
A*S Indicates that the component is automatically loading configuration or software.


A%

A()
G
C: Indicates that the component has encountered a failure.


C

C

	F* Indicates that the component is temporarily shut down.
 The component is in a high temperature shutdown state due to exceeding safe operating temperature limits.


	F&

	F()
C

H)6 Indicates that the component is manually shut down.



H#


H&(
H
J/; Indicates that the component is shut down to save power.


J)

J,.
U
L'H Indicates that the component's type does not match the expected type.


L!

L$&


O U


O

 P#

 P

 P!"

Q!

Q

Q 

R

R

R

S 

S

S

T

T

T


W `


W

 X#

 X

 X!"

Y!

Y

Y 

Z%

Z!

Z#$

["

[

[ !

\

\

\

]

]

]

^!

^

^ 

_'

_"

_%&


b h


b

 c%

 c 

 c#$

d#

d

d!"

e

e

e

f 

f

f

g-

g(

g+,


j q


j

 k5

 kj

 k

 k0

 k34

l(

lk5

l

l#

l&'

m&

ml(

m

m!

m$%

n(

nm&

n

n#

n&'

o(

on(

o

o#

o&'

p,

po(

p

p'

p*+

s 


s

 t

 t

 t

u

u

u

v

v

v

w

w

w

x

x

x

y

y

y

z

z

z

{

{

{

|

|

|

	}

	}

	}


~


~


~







 
































 



 

 

 

















































	

	

	























































 



  

 

 







"



 !

%

 

#$

	 

	

	 

	 

	 

	

	

	

	

	

	

	

		

	

	

	


	


	

	

	

	

	

	

	

	

	

	" Add more here


	

	

		

		

		

 



 

 

 	

 


 

























	



























,





'

*+

!

,






 
g
Y data_type can be of the string representation of MetricNames or something else as well


!








 



 

 	

  %

   

  #$

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 



	

 

 

 

















































	

	

	



	

 

 

 

















































 %

 

 

  

 #$



%

	




























 The mapping_label can be used to map ports between the DMI interface and other systems like VOLTHA
 The value of the mapping_label should be exactly the same as generated for the same port by the other
 system











"







 !
_
#"QOnly valid for ethernet type port components. True if enabled, false otherwise.


"



	

!"
E
"7Pon max distance and max differential reach distance.


#







 



 
 The ITU-T G.987.x series of Recommendations addresses the linear extent parameters of XG-PON
 using the single concept of fibre distance. An ONU is characterized by its fibre distance, and for
 each pair of ONUs on the same OLT PON interface, the differential fibre distance is the difference
 between the two individual fibre distances. Each specific PMD layer parameter set contains a
 provision to support a specific maximum fibre distance. The XG-PON TC layer specification
 contains a provision to support specific ranges of maximum fibre distance and maximum
 differential fibre distance. These ranges can be configurable for a given system. One can expect that
 for each XG-PON deployment, the configured TC layer maximum fibre distance will match the
 maximum fibre distance supported by the selected PMD layer parameter set.
"JDistance in kilometers the maximum logical distance on an ONU on the PON


 

 


 

 
T
)"F maximum distance between the closest ONU to the farthest ONU in km.







$

'(

 

%

 "

 '

 

 

  !
E
"7Pon max distance and max differential reach distance.


"







 

,

 #

 .

 

 

 !"

	 

	

	  The pon_id and pon_id_transmit_periodicity attributes are valid only for ports of type GPON, XGPON and XGSPON
 For GPON pon_id is a 7 byte value
 For XGS-PON, it's a 32 bit value, should be encoded in the first 4 bytes of pon_id in network byte order


	 

	 	

	 


	 
A
	+"3 The value is in seconds and defaults to 1 second


	

	


	&

	)*


 


$


 


 %


 



 


 

 



 

 	

  (

  #

  &'

 

 

 

 

 

 

 

 

 

 +

 

 

 &

 )*

 

'

 

 	

   

  

  

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 	

 	

 	

 


 



 



 

 

 

 

 

 

 


 


 


 

 

 

 

 

 

 

 

 

 

 

#







!"
K
= The maximum reach that can be achieved by this transceiver


#








&





!

$%
U
&G The receive and transmit wavelengths that the transeiver operates on







!

$%

&






!

$%

$

&





"#

  The tx powers on the transceiver; the value type of tx_power should be dBm.
 Note: When there are multiple rx/tx wavelengths and powers
 each of the corresponding ones should be aligned on the same index of the array











"

 





 !


 



\

 N The name of a component uniquely identifies a component within the hardware



 


 



 


 































i

[ The name of the parent of this component, empty string("") in case of the root component






















	









$












"#





$












































	


	


	



	


	























 Apart from the definition of this attribute as defined in RFC 8348, implementations could choose to carry
 the manufacturer's part number in this attribute.






























































	





,








&


)+





,









e

W The uuid of the component uniquely identifies the component across the entire system









	




















2






 


!,


/1


 } The attribute 'specific' can be populated for components where more details are required by the users of the DMI interface



 



/





 )


,.


9


$


%3


68


-





'


*,


>


'


(8


;=

 



 .

 

 

 )

 ,-

 Each HW has one parent/root and all other components are children of this
 The class of the root component would be set as UNDEFINED


.






T
.F TODO: Authentication?
 Timestamp at which the hardware last booted






)

,-
X
 J The attributes of a component which are modifiable from the client side




  The name has to be unique for each component within the hardware and implementations need to
 ascertain this when modifying the name


 

 


 

 

























	






































(





#

&'
]
 M The attribute 'specific' can be populated for specific class of components


 


5

%

&/

24

	;

	,

	-5

	8:bproto3

google/protobuf/empty.protogoogle.protobuf"
EmptyBv
com.google.protobufB
EmptyProtoPZ'github.com/golang/protobuf/ptypes/emptyGPBGoogle.Protobuf.WellKnownTypesJ
 3

 2 Protocol Buffers - Google's data interchange format
 Copyright 2008 Google Inc.  All rights reserved.
 https://developers.google.com/protocol-buffers/

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are
 met:

     * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above
 copyright notice, this list of conditions and the following disclaimer
 in the documentation and/or other materials provided with the
 distribution.
     * Neither the name of Google Inc. nor the names of its
 contributors may be used to endorse or promote products derived from
 this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


  

" ;
	
%" ;

# >
	
# >

$ ,
	
$ ,

% +
	
% +

& "
	

& "

' !
	
$' !

( 
	
( 

 3  A generic empty message that you can re-use to avoid defining duplicated
 empty messages in your APIs. A typical example is to use it as the request
 or the response type of an API method. For instance:

     service Foo {
       rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);
     }

 The JSON representation for `Empty` is empty JSON object `{}`.



 3
bproto3

 dmi/hw_events_mgmt_service.protodmidmi/commons.protodmi/hw.protogoogle/protobuf/timestamp.protogoogle/protobuf/empty.proto"
	ValueType
int_val (H RintVal
uint_val (H RuintVal
	float_val (H RfloatVal0
	typeOfVal (2.dmi.DataValueTypeR	typeOfValB
val"R

WaterMarks"
high (2.dmi.ValueTypeRhigh 
low (2.dmi.ValueTypeRlow"k

Thresholds'
upper (2.dmi.WaterMarksH Rupper'
lower (2.dmi.WaterMarksH RlowerB
	threshold"~
ThresholdInformation5
observed_value (2.dmi.ValueTypeR
observedValue/

thresholds (2.dmi.ThresholdsR
thresholds"
EventCfg(
event_id (2
.dmi.EventIdsReventId#

is_configured (RisConfigured/

thresholds (2.dmi.ThresholdsR
thresholds0
component_uuid (2	.dmi.UuidR
componentUuid"0
	EventsCfg#
items (2
.dmi.EventCfgRitems"
ListEventsResponse#
status (2.dmi.StatusRstatus6
reason (2.dmi.ListEventsResponse.ReasonRreason&
events (2.dmi.EventsCfgRevents#

reason_detail (	RreasonDetail"^
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
DEVICE_UNREACHABLE"
EventsConfigurationRequest*
device_uuid (2	.dmi.UuidR
deviceUuid*
changes (2.dmi.EventsCfgH Rchanges*
reset_to_default (H RresetToDefaultB
	operation"
EventsConfigurationResponse#
status (2.dmi.StatusRstatus?
reason (2'.dmi.EventsConfigurationResponse.ReasonRreason#

reason_detail (	RreasonDetail"r
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
INVALID_CONFIG
DEVICE_UNREACHABLE"

EventMetaData*
device_uuid (2	.dmi.UuidR
deviceUuid0
component_uuid (2	.dmi.UuidR
componentUuid%
component_name (	R
componentName"j
AdminStateChange*
old (2.dmi.ComponentAdminStateRold*
new (2.dmi.ComponentAdminStateRnew"g
OperStateChange)
old (2.dmi.ComponentOperStateRold)
new (2.dmi.ComponentOperStateRnew"j
AlarmStateChange*
old (2.dmi.ComponentAlarmStateRold*
new (2.dmi.ComponentAlarmStateRnew"j
UsageStateChange*
old (2.dmi.ComponentUsageStateRold*
new (2.dmi.ComponentUsageStateRnew"p
StandbyStateChange,
old (2.dmi.ComponentStandbyStateRold,
new (2.dmi.ComponentStandbyStateRnew"
StateChangeInfoE
admin_state_change (2.dmi.AdminStateChangeH RadminStateChangeB
oper_state_change (2.dmi.OperStateChangeH RoperStateChangeE
alarm_state_change (2.dmi.AlarmStateChangeH RalarmStateChangeE
usage_state_change (2.dmi.UsageStateChangeH RusageStateChangeK
standby_state_change (2.dmi.StandbyStateChangeH RstandbyStateChangeB
state_change"
GenericEventInfo
message (	Rmessage!
message_code (	RmessageCode?
severity (2#.dmi.GenericEventInfo.EventSeverityRseverity"i

EventSeverity
EVENT_SEVERITY_UNSPECIFIED 
CRITICAL	
MAJOR	
MINOR

NORMAL
INFO"
Event9
event_metadata (2.dmi.EventMetaDataR
eventMetadata(
event_id (2
.dmi.EventIdsReventId7
	raised_ts (2.google.protobuf.TimestampRraisedTs@
threshold_info (2.dmi.ThresholdInformationR
thresholdInfo
add_info (	RaddInfo@
state_change_info (2.dmi.StateChangeInfoRstateChangeInfoC
generic_event_info (2.dmi.GenericEventInfoRgenericEventInfo*
EventIds
EVENT_NAME_UNDEFINED 
EVENT_TRANSCEIVER_PLUG_OUTd
EVENT_TRANSCEIVER_PLUG_INe-
)EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLDf-
)EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLDg1
-EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLDh1
-EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLDi-
)EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLDj-
)EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLDk.
*EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLDl.
*EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLDm.
*EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLDn.
*EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLDo
EVENT_TRANSCEIVER_FAILUREp7
3EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVEREDq7
3EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVEREDr;
7EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVEREDs;
7EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVEREDt7
3EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVEREDu7
3EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVEREDv8
4EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVEREDw8
4EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVEREDx8
4EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVEREDy8
4EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVEREDz'
#EVENT_TRANSCEIVER_FAILURE_RECOVERED{
EVENT_PSU_PLUG_OUT
EVENT_PSU_PLUG_IN
EVENT_PSU_FAILURE 
EVENT_PSU_FAILURE_RECOVERED
EVENT_FAN_FAILURE
EVENT_FAN_PLUG_OUT
EVENT_FAN_PLUG_IN 
EVENT_FAN_FAILURE_RECOVERED)
$EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL&
!EVENT_CPU_TEMPERATURE_ABOVE_FATAL3
.EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED0
+EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED$
EVENT_CPU_USAGE_ABOVE_THRESHOLD.
)EVENT_CPU_USAGE_ABOVE_THRESHOLD_RECOVERED
EVENT_HW_DEVICE_RESET/
*EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL,
'EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL9
4EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED6
1EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED
EVENT_HW_DEVICE_REBOOT'
"EVENT_HW_TEMPERATURE_SENSOR_FAILED,
'EVENT_HW_ALL_TEMPERATURE_SENSORS_FAILED(
#EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD2
-EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD_RECOVERED*
%EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD4
/EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD_RECOVERED
EVENT_HW_NTP_SYNC_FAILURE(
#EVENT_HW_NTP_SYNC_FAILURE_RECOVERED
EVENT_LINE_CARD_PLUG_OUT
EVENT_LINE_CARD_PLUG_IN(
#EVENT_COMPONENT_ADMIN_STATE_CHANGED'
"EVENT_COMPONENT_OPER_STATE_CHANGED(
#EVENT_COMPONENT_ALARM_STATE_CHANGED(
#EVENT_COMPONENT_USAGE_STATE_CHANGED*
%EVENT_COMPONENT_STANDBY_STATE_CHANGED"
EVENT_COMPONENT_GENERIC_EVENT2
NativeEventsManagementService6

ListEvents.dmi.HardwareID.dmi.ListEventsResponse^
UpdateEventsConfiguration.dmi.EventsConfigurationRequest .dmi.EventsConfigurationResponse4
StreamEvents.google.protobuf.Empty
.dmi.Event0B;Z9github.com/opencord/device-management-interface/v3/go/dmiJQ
  

  

 P
	
 P

 
	
  
	
 
	
 )
	
 %
E
  b29 Management of Events and protos for encoding of Events



 

  


  


  

,
 % Events from the Transceivers


 

 !$

 $

 

  #

 4 The threshold based events on the transceivers should be configured on
 the port components of that transceiver and not on the transceiver
 component itself. This is because there could be different thresholds
 on the different ports of a transceiver (for example for a transceiver of
 type COMBO_GPON_XGSPON the power thresholds could be different for the
 GPON and XGSPON ports)


 -

 03

 4

 -

 03

 8

 1

 47

 8

 1

 47

 4

 -

 03

 4

 -

 03

 	5

 	.

 	14

 
5

 
.

 
14

  5

  .

  14

 !5

 !.

 !14

 
"$

 
"

 
" #

 #>

 #7

 #:=

 $>

 $7

 $:=

 %B

 %;

 %>A

 &B

 &;

 &>A

 '>

 '7

 ':=

 (>

 (7

 (:=

 )?

 )8

 );>

 *?

 *8

 *;>

 +?

 +8

 +;>

 ,?

 ,8

 ,;>

 -.

 -'

 -*-
#
 0 Events from the PSU


 0

 0

 1

 1

 1

 2

 2

 2

 3&

 3

 3"%
#
 6 Events for the Fans


 6

 6

 7

 7

 7

 8

 8

 8

  9&

  9

  9"%
#
 !</ Events for the CPUs


 !<(

 !<+.

 "=,

 "=%

 "=(+

 #>9

 #>2

 #>58

 $?6

 $?/

 $?25

 %@*

 %@#

 %@&)

 &A4

 &A-

 &A03
1
 'D $ Events for the complete HW Device


 'D

 'D

 (E5

 (E.

 (E14

 )F2

 )F+

 )F.1

 *G?

 *G8

 *G;>

 +H<

 +H5

 +H8;

 ,I!

 ,I

 ,I 

 -J-

 -J&

 -J),

 .K2

 .K+

 .K.1

 /L.

 /L'

 /L*-

 0M8

 0M1

 0M47

 1N0

 1N)

 1N,/

 2O:

 2O3

 2O69

 3P$

 3P

 3P #

 4Q.

 4Q'

 4Q*-
:
 5T#- Events for the line cards on the HW Device


 5T

 5T"

 6U"

 6U

 6U!

 7Y. Indicates that the a state of a component has changed.
 The StateChangeInfo message inside the event conveys the old and new states.


 7Y'

 7Y*-

 8Z-

 8Z&

 8Z),

 9[.

 9['

 9[*-

 :\.

 :\'

 :\*-

 ;]0

 ;])

 ;],/

 <`( Generic event about a component, the payload contains GenericEventInfo in this case
 Use this event id only for events which do not have already a specific event id
" More to be added


 <`!

 <`$'


 d o


 d

  hl For val no multiples of units shall be used.
 For example, for memory val should be in bytes and not in kilobytes or any
 other multiple of the unit byte.


  h


  i

  i

  i

  i

 j

 j

 j

 j

 k

 k

 k

 k

 n 

 nl

 n

 n

 n


q t


q

 r

 rq

 r

 r

 r

s

sr

s

s

s


v {


v

 wz

 w


 x

 x

 x

 x

y

y

y

y

} 


}

 ~!

 ~}

 ~

 ~

 ~ 



~!







 



 

 

 

 


 







	



 Optional threshold values, applicable only for some specific events
 If an event needs thresholds but the user does not pass the thresholds here, the Device Manager implementations
 could choose to use defaults applicable for the specific component (recommended) or return an error for such
 an EventConfigurationRequest with reason as INVALID_CONFIG










 For events which can be configured on a particular component this id can be used to identify the component
 For e.g. for events of the transceivers






	



 



  

 

 


 

 

 



 

 	

  

  

  

 

 

 

 

 

 

 

 

 

 

 

 


 

 

































 

"

 

 $

 

 	

 

 

 










"






 !

 

#

 

 	

  

  

  

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 


 

 























	 

	

	 

	 

	 

	 	

	 
&
	 uuid of the component


	

	

		

	

	

	

	


	

	


 





  


 


 


 


 


 


 










 



 

 

 

 

 











 



  

 

 

 

 

 

 








 





  


 


 


 


 


 


 










 



 "

 

 

 

  !

"

"





 !

 



 

 


 0

 

 +

 ./

.



)

,-

0



+

./

0



+

./

4



/

23

 


'
 " Human-readable message


 

 


 

 
9
"+ Related events should have the same code











 

 	

  '

  "

  %&

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 
-
" Severity of the event       










 



 %

 

 

  

 #$



%








,





'

*+
<
,. Optional threshold information for an event


,



'

*+
`
* Any additional info regarding the event
"& Stringified JSON with extra details


,







1
*"# Only set for state change events






%

()
F
,"8 Only set for event_id = EVENT_COMPONENT_GENERIC_EVENT


*



'

*+

  

 %
@
  ;2 List the supported events for the passed device


  

  

  '9

 c Updates the configuration of the list of events in the request
 The default behavior of the device is to report all the supported events
 This configuration is persisted across reboots of the device or the device manager


 !

 "<

 Fa
<
 B. Initiate the server streaming of the events


 

 *

 4:

 ;@bproto3

dmi/hw_management_service.protodmidmi/commons.protodmi/hw.protogoogle/protobuf/empty.proto"F
PhysicalInventoryRequest*
device_uuid (2	.dmi.UuidR
deviceUuid"
PhysicalInventoryResponse#
status (2.dmi.StatusRstatus=
reason (2%.dmi.PhysicalInventoryResponse.ReasonRreason+
	inventory (2
.dmi.HardwareR	inventory#

reason_detail (	RreasonDetail"^
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
DEVICE_UNREACHABLE"
HWComponentInfoGetRequest*
device_uuid (2	.dmi.UuidR
deviceUuid0
component_uuid (2	.dmi.UuidR
componentUuid%
component_name (	R
componentName"
HWComponentInfoGetResponse#
status (2.dmi.StatusRstatus>
reason (2&.dmi.HWComponentInfoGetResponse.ReasonRreason,
	component (2.dmi.ComponentR	component#

reason_detail (	RreasonDetail"u
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
UNKNOWN_COMPONENT
INTERNAL_ERROR
DEVICE_UNREACHABLE"
HWComponentInfoSetRequest*
device_uuid (2	.dmi.UuidR
deviceUuid0
component_uuid (2	.dmi.UuidR
componentUuid%
component_name (	R
componentName2
changes (2.dmi.ModifiableComponentRchanges"
HWComponentInfoSetResponse#
status (2.dmi.StatusRstatus>
reason (2&.dmi.HWComponentInfoSetResponse.ReasonRreason#

reason_detail (	RreasonDetail"
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
UNKNOWN_COMPONENT
INVALID_PARAMS
INTERNAL_ERROR
DEVICE_UNREACHABLE
SET_UNSUPPORTED"
StartManagingDeviceResponse#
status (2.dmi.StatusRstatus?
reason (2'.dmi.StartManagingDeviceResponse.ReasonRreason*
device_uuid (2	.dmi.UuidR
deviceUuid#

reason_detail (	RreasonDetail"
Reason
UNDEFINED_REASON 
DEVICE_ALREADY_MANAGED!
OPERATION_ALREADY_IN_PROGRESS
INVALID_PARAMS
INTERNAL_ERROR
AUTHENTICATION_FAILURE
INCOMPATIBLE_DEVICE"/
StopManagingDeviceRequest
name (	Rname"
StopManagingDeviceResponse#
status (2.dmi.StatusRstatus>
reason (2&.dmi.StopManagingDeviceResponse.ReasonRreason#

reason_detail (	RreasonDetail"J
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
DEVICE_UNREACHABLE"m
ManagedDeviceInfo,
info (2.dmi.ModifiableComponentRinfo*
device_uuid (2	.dmi.UuidR
deviceUuid"
ManagedDevicesResponse#
status (2.dmi.StatusRstatus:
reason (2".dmi.ManagedDevicesResponse.ReasonRreason0
devices (2.dmi.ManagedDeviceInfoRdevices"2
Reason
UNDEFINED_REASON 
INTERNAL_ERROR"
SetLoggingEndpointRequest*
device_uuid (2	.dmi.UuidR
deviceUuid)
logging_endpoint (	RloggingEndpoint)
logging_protocol (	RloggingProtocol"
SetRemoteEndpointResponse#
status (2.dmi.StatusRstatus=
reason (2%.dmi.SetRemoteEndpointResponse.ReasonRreason#

reason_detail (	RreasonDetail"
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
LOGGING_ENDPOINT_ERROR#
LOGGING_ENDPOINT_PROTOCOL_ERROR
MSGBUS_ENDPOINT_ERROR
DEVICE_UNREACHABLE"
GetLoggingEndpointResponse#
status (2.dmi.StatusRstatus>
reason (2&.dmi.GetLoggingEndpointResponse.ReasonRreason)
logging_endpoint (	RloggingEndpoint)
logging_protocol (	RloggingProtocol#

reason_detail (	RreasonDetail"^
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
DEVICE_UNREACHABLE"C
SetMsgBusEndpointRequest'
msgbus_endpoint (	RmsgbusEndpoint"
GetMsgBusEndpointResponse#
status (2.dmi.StatusRstatus=
reason (2%.dmi.GetMsgBusEndpointResponse.ReasonRreason'
msgbus_endpoint (	RmsgbusEndpoint#

reason_detail (	RreasonDetail"J
Reason
UNDEFINED_REASON 
INTERNAL_ERROR
DEVICE_UNREACHABLE"Y
EntitiesLogLevel)
logLevel (2
.dmi.LogLevelRlogLevel
entities (	Rentities"u
SetLogLevelRequest*
device_uuid (2	.dmi.UuidR
deviceUuid3
	loglevels (2.dmi.EntitiesLogLevelR	loglevels"
SetLogLevelResponse*
device_uuid (2	.dmi.UuidR
deviceUuid#
status (2.dmi.StatusRstatus7
reason (2.dmi.SetLogLevelResponse.ReasonRreason#

reason_detail (	RreasonDetail"v
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
UNKNOWN_LOG_ENTITY
DEVICE_UNREACHABLE"\
GetLogLevelRequest*
device_uuid (2	.dmi.UuidR
deviceUuid
entities (	Rentities"
GetLogLevelResponse*
device_uuid (2	.dmi.UuidR
deviceUuid3
	logLevels (2.dmi.EntitiesLogLevelR	logLevels#
status (2.dmi.StatusRstatus7
reason (2.dmi.GetLogLevelResponse.ReasonRreason#

reason_detail (	RreasonDetail"v
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
UNKNOWN_LOG_ENTITY
DEVICE_UNREACHABLE"H
GetLoggableEntitiesRequest*
device_uuid (2	.dmi.UuidR
deviceUuid";
SetDmLogLevelRequest#
level (2
.dmi.LogLevelRlevel"
SetDmLogLevelResponse#
status (2.dmi.StatusRstatus9
reason (2!.dmi.SetDmLogLevelResponse.ReasonRreason#

reason_detail (	RreasonDetail"I
Reason
UNDEFINED_REASON 
INTERNAL_ERROR
UNKNOWN_LOG_LEVEL"
GetDmLogLevelRequest"
GetDmLogLevelResponse#
level (2
.dmi.LogLevelRlevel#
status (2.dmi.StatusRstatus9
reason (2!.dmi.GetDmLogLevelResponse.ReasonRreason#

reason_detail (	RreasonDetail"2
Reason
UNDEFINED_REASON 
INTERNAL_ERROR"<
	Heartbeat/
heartbeat_signature (RheartbeatSignature"A
RebootDeviceRequest*
device_uuid (2	.dmi.UuidR
deviceUuid"
RebootDeviceResponse#
status (2.dmi.StatusRstatus8
reason (2 .dmi.RebootDeviceResponse.ReasonRreason#

reason_detail (	RreasonDetail"y
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
DEVICE_UNREACHABLE
DEVICE_IN_WRONG_STATE"
DisableHWComponentRequest*
device_uuid (2	.dmi.UuidR
deviceUuid0
component_uuid (2	.dmi.UuidR
componentUuid%
component_name (	R
componentName"
DisableHWComponentResponse#
status (2.dmi.StatusRstatus>
reason (2&.dmi.DisableHWComponentResponse.ReasonRreason#

reason_detail (	RreasonDetail"
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
UNKNOWN_COMPONENT
INTERNAL_ERROR
DEVICE_UNREACHABLE
DISABLE_UNSUPPORTED
INVALID_PARAMS"
ResetHWComponentRequest*
device_uuid (2	.dmi.UuidR
deviceUuid0
component_uuid (2	.dmi.UuidR
componentUuid%
component_name (	R
componentName"
ResetHWComponentResponse#
status (2.dmi.StatusRstatus<
reason (2$.dmi.ResetHWComponentResponse.ReasonRreason#

reason_detail (	RreasonDetail"
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
UNKNOWN_COMPONENT
INTERNAL_ERROR
DEVICE_UNREACHABLE
RESET_UNSUPPORTED
INVALID_PARAMS"
EnableHWComponentRequest*
device_uuid (2	.dmi.UuidR
deviceUuid0
component_uuid (2	.dmi.UuidR
componentUuid%
component_name (	R
componentName"
EnableHWComponentResponse#
status (2.dmi.StatusRstatus=
reason (2%.dmi.EnableHWComponentResponse.ReasonRreason#

reason_detail (	RreasonDetail"
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
UNKNOWN_COMPONENT
INTERNAL_ERROR
DEVICE_UNREACHABLE
ENABLE_UNSUPPORTED
INVALID_PARAMS2
NativeHWManagementServiceS
StartManagingDevice.dmi.ModifiableComponent .dmi.StartManagingDeviceResponse0U
StopManagingDevice.dmi.StopManagingDeviceRequest.dmi.StopManagingDeviceResponseH
GetManagedDevices.google.protobuf.Empty.dmi.ManagedDevicesResponseW
GetPhysicalInventory.dmi.PhysicalInventoryRequest.dmi.PhysicalInventoryResponse0W
GetHWComponentInfo.dmi.HWComponentInfoGetRequest.dmi.HWComponentInfoGetResponse0U
SetHWComponentInfo.dmi.HWComponentInfoSetRequest.dmi.HWComponentInfoSetResponseT
SetLoggingEndpoint.dmi.SetLoggingEndpointRequest.dmi.SetRemoteEndpointResponseF
GetLoggingEndpoint.dmi.HardwareID.dmi.GetLoggingEndpointResponseR
SetMsgBusEndpoint.dmi.SetMsgBusEndpointRequest.dmi.SetRemoteEndpointResponseK
GetMsgBusEndpoint.google.protobuf.Empty.dmi.GetMsgBusEndpointResponseP
GetLoggableEntities.dmi.GetLoggableEntitiesRequest.dmi.GetLogLevelResponse@
SetLogLevel.dmi.SetLogLevelRequest.dmi.SetLogLevelResponse@
GetLogLevel.dmi.GetLogLevelRequest.dmi.GetLogLevelResponse8
HeartbeatCheck.google.protobuf.Empty.dmi.HeartbeatC
RebootDevice.dmi.RebootDeviceRequest.dmi.RebootDeviceResponseF

SetDmLogLevel.dmi.SetDmLogLevelRequest.dmi.SetDmLogLevelResponseF

GetDmLogLevel.dmi.GetDmLogLevelRequest.dmi.GetDmLogLevelResponseU
DisableHWComponent.dmi.DisableHWComponentRequest.dmi.DisableHWComponentResponseO
ResetHWComponent.dmi.ResetHWComponentRequest.dmi.ResetHWComponentResponseR
EnableHWComponent.dmi.EnableHWComponentRequest.dmi.EnableHWComponentResponseB;Z9github.com/opencord/device-management-interface/v3/go/dmiJ
  

  

 P
	
 P

 
	
  
	
 
	
 %
J
  
2> Protos for the management of a hardware and it's components



  

  

  "

  

  	

  


 


!

 

 	

  

  

  

 

 

 

 

 

 

 

 

 

 

 

 


 

 























 It is recommended that upstream components/users of the DMI interface
 do not really interpret/parse the reson_detail, but rather use it for
 display purposes to the end user or use it for logging the error












 #


!

  

  #

  

  	

  

!

! 

!

!	

!

"

"!

"


"

"


% 1


%"

 &,

 &	

  '

  '

  '

 (

 (

 (

 )

 )

 )

 *

 *

 *

 +

 +

 +

 -

 -,

 -


 -

 -

.

.-

.


.

.

/

/.

/

/

/

0

0/

0


0

0


3 8


3!

 4

 43#

 4

 4	

 4

5

54

5

5	

5

6

65

6


6

6

7$

76

7

7

7"#


: G


:"

 ;C

 ;	

  <

  <

  <

 =

 =

 =

 >

 >

 >

 ?

 ?

 ?

 @

 @

 @

 A

 A

 A

 B

 B

 B

 D

 DC

 D


 D

 D

E

ED

E


E

E

F

FE

F


F

F


I _


I#

 JZ

 J	

  K

  K

  K

 N# DEVICE_ALREADY_MANAGED is returned when StartManagingDevice is called again for the same name AFTER a previously
 successful StartManagingDevice operation


 N

 N!"

 Q* OPERATION_ALREADY_IN_PROGRESS is returned when StartManagingDevice is called again for the same name BEFORE
 a previous StartManagingDevice operation has completed


 Q%

 Q()

 R

 R

 R

 S

 S

 S

 V# AUTHENTICATION_FAILURE is returned when the device management software/server is not able to connect to the underlying
 hardware because of authentication failures


 V

 V!"

 Y  INCOMPATIBLE_DEVICE is returned when there is a mismatch between the device management software/server and the underlying
 hardware


 Y

 Y

 [

 [Z

 [


 [

 [

\

\[

\


\

\

]

]\

]

]	

]

^

^]

^


^

^


a c


a!

 b

 ba#

 b


 b

 b


e q


e"
v
 hmh The only case in which an error is expected is if the name of the
 device to be stopped is not found


 h	

  i

  i

  i

 j

 j

 j
{
 ll DEVICE_UNREACHABLE is to be returned when the device manager cannot reach the device and stop managing it


 l

 l

 n

 nm

 n


 n

 n

o

on

o


o

o

p

po

p


p

p


	s v


	s

	 t!

	 ts

	 t

	 t

	 t 

	u

	ut!

	u

	u	

	u


x 



x


 y|


 y	


  z


  z


  z


 {


 {


 {


 }


 }|


 }



 }


 }


~


~}


~



~


~


+









&


)*

 

!

 

 #

 

 	

 

 










 

 








 

!

 

 	

  

  

  

 

 

 

 

 

 

 #

 

 !"

 ,

 '

 *+

 "

 

  !

 

 

 

 

 

 


 

 
























 


"


 


 	


  


  


  


 


 


 


 


 


 


 


 


 


 


 


 



 


 


















 















 


 















 











 

 

 

 "

 


 

 

 

!

 

 	

  

  

  

 

 

 

 

 

 

 

 

 


 

 


































 



 

 

 

 


 

!








 

 



 

 

 

 	

 

,






'

*+

 



 

 	

  

  

  

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 	

 


































 



 

 

 

 	

 

!








 

 



 

 	

  

  

  

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 	

 

,






'

*+



,






























 

"

 

 $

 

 	

 

 



 

 

 

 


 

 



 

 	

  

  

  

 

 

 

 

 

 

 

 

 


 

 























 



 



 

 	

  

  

  

 

 

 

 

 

 

 


 


































 



 $

 

 

 

 "#

 



 

 

 

 	

 

 



 

 	

  

  

  

 

 

 

 

 

 

 

 

 

 ""z This reason would be returned by the Device Manager if doing the reboot could lead the device to an inconsistent state.


 

  !

 

 

 


 

 























  Request to disable a hardware component on a device.
 At least one of component_name or component_uuid must be provided, along with device_uuid.


!
R
 D UUID of the device containing the component to disable (required)


 #

 

 	

 
k
] UUID of the component to disable (optional, but either this or component_name must be set)






	


k
] Name of the component to disable (optional, but either this or component_uuid must be set)










5
 ' Response for DisableHWComponent RPC.


"

 

 	

  

  

  

 

 

 

 

 

 

 

 

 

 

 

 
<
  ", Disabling this component is not supported


 

 
E
 "5 Neither component_name nor component_uuid provided


 

 
G
 9 Indicates whether the operation was successful or not.


 

 


 

 
+
 Reason for failure, if any










>
0 Human-readable details for logging or display











  Request to reset a hardware component on a device.
 At least one of component_name or component_uuid must be provided, along with device_uuid.



P
 B UUID of the device containing the component to reset (required)


 !

 

 	

 
i
[ UUID of the component to reset (optional, but either this or component_name must be set)






	


i
[ Name of the component to reset (optional, but either this or component_uuid must be set)










3
  % Response for ResetHWComponent RPC.


  

  

  	

   

   

   

  

  

  

  

  

  

  

  

  

  

  

  
<
  ", Resetting this component is not supported


  

  
E
  "5 Neither component_name nor component_uuid provided


  

  
G
  9 Indicates whether the operation was successful or not.


  

  


  

  
+
  Reason for failure, if any


 

 


 

 
>
 0 Human-readable details for logging or display


 

 


 

 

!  Request to enable a hardware component on a device.
 At least one of component_name or component_uuid must be provided, along with device_uuid.


! 
Q
! C UUID of the device containing the component to enable (required)


! "

! 

! 	

! 
j
!\ UUID of the component to enable (optional, but either this or component_name must be set)


!

!

!	

!
j
!\ Name of the component to enable (optional, but either this or component_uuid must be set)


!

!


!

!
4
" & Response for EnableHWComponent RPC.


"!

" 

" 	

"  

"  

"  

" 

" 

" 

" 

" 

" 

" 

" 

" 

" 

" 

" 
;
" "+ Enabling this component is not supported


" 

" 
E
" "5 Neither component_name nor component_uuid provided


" 

" 
G
" 9 Indicates whether the operation was successful or not.


" 

" 


" 

" 
+
" Reason for failure, if any


"

"


"

"
>
"0 Human-readable details for logging or display


"

"


"

"

  

 !

  ] Initializes context for a device and sets up required states
 In the call to StartManagingDevice, the fields of ModifiableComponent which are relevant
 and their meanings in this context is mentioned below:
 name = The unique name that needs to be assigned to this hardware;
 class = COMPONENT_TYPE_UNDEFINED;
 parent = nil;
 alias = Optional;
 asset_id = Optional;
 uri = IP Address of the Hardware;


  

  /

  9?

  @[

 Z Stop management of a device and clean up any context and caches for that device
 This rpc can be called at any time, even before the StartManagingDevice operation
 has completed, and should be able to cleanup.


 

 4

 >X
V
 QH Returns an object containing a list of devices managed by this entity


 

 /

 9O
;
 a- Get the HW inventory details of the Device


 

 5

 ?E

 F_
=
 a/ Get the details of a particular HW component


 

 4

 >D

 E_
B
 Z4 Sets the permissible attributes of a HW component


 

 4

 >X
C
 Y5 Sets the location to which logs need to be shipped


 

 4

 >W
Q
 KC Gets the configured location to which the logs are being shipped


 

 %

 /I
]
 WO Sets the location of the Message Bus to which events and metrics are shipped


 

 2

 <U
_
 	TQ Gets the configured location to which the events and metrics are being shipped


 	

 	/

 	9R

 
U Gets the entities of a device on which log can be configured. A few are expected, like OS, PON Management etc.
 In general an entity is any item within an hardware system that can emit logs, e.g. service, process, subsystem,
 interface, package etc.


 


 
6

 
@S

 E Sets the log level of the device, for each given entity to a certain level.
 If only one EntitiesLogLevel is provided for the device and that request contains only a log level with
 no entity in the list it's assumed that the caller wants to set that level for all the entities.


 

 &

 0C

 E Gets the configured log level for a certain entity on a certain device.
 If no entity is specified in the request all the entities with their log level should be returned.


 

 &

 0C
-
 
B Performs the heartbeat check


 


 
,

 
7@
2
 H$ Performs the reboot of the device


 

 (

 2F
@
 K2 Sets the log level of the Device Manager itself


 

 *

 4I
J
 K< Gets the log level at which the Device Manager is running


 

 *

 4I
;
 Z- Disables a hardware component on a device.


 

 4

 >X
9
 T+ Resets a hardware component on a device.


 

 0

 :R
:
 W, Enables a hardware component on a device.


 

 2

 <Ubproto3
E
!dmi/hw_metrics_mgmt_service.protodmidmi/commons.protodmi/hw.protogoogle/protobuf/empty.proto"
MetricConfig-
	metric_id (2.dmi.MetricNamesRmetricId#

is_configured (RisConfigured#

poll_interval (
RpollInterval"<

MetricsConfig+
metrics (2.dmi.MetricConfigRmetrics"
ListMetricsResponse#
status (2.dmi.StatusRstatus7
reason (2.dmi.ListMetricsResponse.ReasonRreason,
metrics (2.dmi.MetricsConfigRmetrics#

reason_detail (	RreasonDetail"^
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
DEVICE_UNREACHABLE"
MetricsConfigurationRequest*
device_uuid (2	.dmi.UuidR
deviceUuid.
changes (2.dmi.MetricsConfigH Rchanges*
reset_to_default (H RresetToDefaultB
	operation"
MetricsConfigurationResponse#
status (2.dmi.StatusRstatus@
reason (2(.dmi.MetricsConfigurationResponse.ReasonRreason#

reason_detail (	RreasonDetail"
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
POLL_INTERVAL_UNSUPPORTED
INVALID_METRIC
DEVICE_UNREACHABLE"
MetricMetaData*
device_uuid (2	.dmi.UuidR
deviceUuid0
component_uuid (2	.dmi.UuidR
componentUuid%
component_name (	R
componentName"
Metric-
	metric_id (2.dmi.MetricNamesRmetricId<
metric_metadata (2.dmi.MetricMetaDataRmetricMetadata.
value (2.dmi.ComponentSensorDataRvalue"s
GetMetricRequest0
	meta_data (2.dmi.MetricMetaDataRmetaData-
	metric_id (2.dmi.MetricNamesRmetricId"
GetMetricResponse#
status (2.dmi.StatusRstatus5
reason (2.dmi.GetMetricResponse.ReasonRreason#
metric (2.dmi.MetricRmetric#

reason_detail (	RreasonDetail"
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
UNKNOWN_COMPONENT
INTERNAL_ERROR
INVALID_METRIC
DEVICE_UNREACHABLE*
MetricNames
METRIC_NAME_UNDEFINED 
METRIC_FAN_SPEED
METRIC_CPU_TEMPd
METRIC_CPU_USAGE_PERCENTAGEe
METRIC_TRANSCEIVER_TEMP
METRIC_TRANSCEIVER_VOLTAGE
METRIC_TRANSCEIVER_BIAS 
METRIC_TRANSCEIVER_RX_POWER 
METRIC_TRANSCEIVER_TX_POWER"
METRIC_TRANSCEIVER_WAVELENGTH'
"METRIC_TRANSCEIVER_XGSPON_TX_POWER
METRIC_DISK_TEMP
METRIC_DISK_CAPACITY
METRIC_DISK_USAGE!
METRIC_DISK_USAGE_PERCENTAGE&
!METRIC_DISK_READ_WRITE_PERCENTAGE(
#METRIC_DISK_FAULTY_CELLS_PERCENTAGE
METRIC_RAM_TEMP
METRIC_RAM_CAPACITY
METRIC_RAM_USAGE 
METRIC_RAM_USAGE_PERCENTAGE
METRIC_POWER_MAX
METRIC_POWER_USAGE"
METRIC_POWER_USAGE_PERCENTAGE"
METRIC_INNER_SURROUNDING_TEMP2
NativeMetricsManagementService8
ListMetrics.dmi.HardwareID.dmi.ListMetricsResponsea
UpdateMetricsConfiguration .dmi.MetricsConfigurationRequest!.dmi.MetricsConfigurationResponse:
	GetMetric.dmi.GetMetricRequest.dmi.GetMetricResponse6

StreamMetrics.google.protobuf.Empty.dmi.Metric0B;Z9github.com/opencord/device-management-interface/v3/go/dmiJ.
  

  

 P
	
 P

 
	
  
	
 
	
 %

  62 The model used to represent the event data on the SensorData of a component as described
 in RFC8348 (https://tools.ietf.org/html/rfc8348)
2; Management of Metrics and protos for encoding of Metrics



 

  

  

  
#
  FAN related metrics


 

 
#
  CPU related metrics


 

 

 &

 

 "%
+
 " Transceiver related metrics


 

 !

 %

 

 !$

 "

 

 !

 &

 

 "%

 &

 

 "%

 	(

 	!

 	$'

 
-

 
&

 
),
$
 " Disk related metrics


 "

 "

 #

 #

 #

 
$

 
$

 
$

 %'

 % 

 %#&

 &,

 &%

 &(+

 '.

 ''

 '*-
#
 * RAM related metrics


 *

 *

 +

 +

 +

 ,

 ,

 ,

 -&

 -

 -"%
%
 0 Power related metrics


 0

 0

 1

 1

 1

 2(

 2!

 2$'
'
 5( Chassis related metrics


 5!

 5$'


 8 @


 8

  9

  98

  9

  9

  9
Y
 ;L Whether the device manager is collecting and reporting this metric or not


 ;9

 ;

 ;	

 ;

 ? Number of seconds between two consecutive polls of the particular metric
 Each device manager implemenation could have it's per metric default poll frequency which
 can be requested to be changed using this value


 ?;

 ?


 ?

 ?


B D


B

 C&

 C

 C


 C!

 C$%


F Q


F

 GL

 G	

  H

  H

  H

 I

 I

 I

 J

 J

 J

 K

 K

 K

 M

 ML

 M


 M

 M

N

NM

N


N

N

O

ON

O

O

O

P

PO

P


P

P


S Y


S#

 T

 TS%

 T

 T	

 T

 UX

 U


V"

V

V

V !

W"

W

W


W !


[ g


[$

 \c

 \	

  ]

  ]

  ]

 ^

 ^

 ^

 _

 _

 _

 `&

 `!

 `$%

 a

 a

 a

 b

 b

 b

 d

 dc

 d


 d

 d

e

ed

e


e

e

f

fe

f


f

f


i n


i

 j

 ji

 j

 j	

 j
%
l uuid of the component


lj

l

l	

l

m

ml

m


m

m

s w The Metrics are conveyed to external systems either by submitting them on a message bus or using gRPC server streaming.
 The topic to which are Metrics are submitted would be configured as startup
 configuration of the components



s

 t

 ts

 t

 t

 t

u'

ut

u

u"

u%&

v"

vu'

v

v

v !


y |


y

 z!

 zy

 z

 z

 z 

{

{z!

{

{

{

~ 


~

 

 	

  

  

  

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 

 


 

 


































  

 &

  = List the supported metrics for the passed device.
 This would be the first call that you make to know about the metrics that a particular device supports and
 then use the UpdateMetricsConfiguration API to monitor only the required metrics.


  

  

  (;

 f Updates the configuration of the list of metrics in the request
 Acts upon single metric configuration, collection of a single metric can be started/stopped
 by changing its configuration.

 This configuration is persisted across restart of the device or the device manager


 "

 #>

 Hd
7
 ?) Get the instantenous value of a metric


 

 "

 ,=
=
 D/ Initiate the server streaming of the metrics


 

 +

 5;

 <Bbproto3

dmi/sw_image.protodmidmi/commons.proto"G
ImageVersion

image_name (	R	imageName
version (	Rversion"
ImageInformation'
image (2.dmi.ImageVersionRimage0
image_install_script (	RimageInstallScript
	image_url (	RimageUrl
	sha256sum (	R	sha256sum"
ImageStatus#
status (2.dmi.StatusRstatus/
reason (2.dmi.ImageStatus.ReasonRreason1
state (2.dmi.ImageStatus.ImageStateRstate 
description (	Rdescription#

reason_detail (	RreasonDetail"

ImageState
UNDEFINED_STATE 

COPYING_IMAGE
INSTALLING_IMAGE
COMMITTING_IMAGE
REBOOTING_DEVICE
UPGRADE_COMPLETE
UPGRADE_FAILED
ACTIVATION_COMPLETE
ACTIVATION_FAILED"
Reason
UNDEFINED_REASON 
ERROR_IN_REQUEST
INTERNAL_ERROR
DEVICE_IN_WRONG_STATE

INVALID_IMAGE
WRONG_IMAGE_CHECKSUM!
OPERATION_ALREADY_IN_PROGRESS
UNKNOWN_DEVICE
DEVICE_NOT_REACHABLEB;Z9github.com/opencord/device-management-interface/v3/go/dmiJ
  <

  

 P
	
 P

 
	
  
C
 	 27 Protos for modeling a software image and it's status



 	

  


  
	

  



  


  


 

 


 


 

 


 




 

 

 

 

 

$ Script used by the device specific managers to install the image.
 Script must be included in the object downloaded from the image_url









"#

 Location of the image and installation script, authentication (user/pass) if any should be in the url string
 The image_url would contain the protocol, credentials, the IP address/DNS of the server and the path of the file
 e.g. sftp://download_user:download_pass@192.168.0.1:22/images/image1


$







=
0 SHA-256 sum of the image (sha256sum on Linux)












 <




 &

 	

  " Initial state


  

  
@
 "1 Downloading the image on the standby partition


 

 
?
 "0 Installing the image on the standby partition


 

 
M
  "> Committing the image and marking it as the active partition


  

  
&
 !" Rebooting the device


 !

 !
B
 ""3 Image upgrade on the standby partition completed


 "

 "
?
 #"0 Image upgrade on the standby partition failed


 #

 #
,
 $ " Image activation completed


 $

 $
)
 %" Image activation failed


 %

 %

(4

(	

 )

 )

 )

*

*

*

+

+

+

,"

,

, !

-

-

-

.!

.

. 

/*

/%

/()

0

0

0

3! The DM implementations should have retry mechanisms (timeout values dependant on specific implementations)
 and even after those if the operation cannot be completed/reached then return error with reason as DEVICE_NOT_REACHABLE


3

3 

 6

 64

 6


 6

 6

7

76

7


7

7

8

87

8

8

8
v
:i description contains more information about the current state of the procedure and is device dependant


:8

:


:

:

;

;:

;


;

;bproto3
R
dmi/sw_management_service.protodmidmi/commons.protodmi/hw.protodmi/sw_image.proto"
SoftwareVersionInformation:
active_versions (2.dmi.ImageVersionRactiveVersions<
standby_versions (2.dmi.ImageVersionRstandbyVersions"
%GetSoftwareVersionInformationResponse#
status (2.dmi.StatusRstatusI
reason (21.dmi.GetSoftwareVersionInformationResponse.ReasonRreason3
info (2.dmi.SoftwareVersionInformationRinfo#

reason_detail (	RreasonDetail"^
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
DEVICE_UNREACHABLE"x
DownloadImageRequest*
device_uuid (2	.dmi.UuidR
deviceUuid4

image_info (2.dmi.ImageInformationR	imageInfo"Z

ConfigRequest*
device_uuid (2	.dmi.UuidR
deviceUuid

config_url (	R	configUrl"
ConfigResponse#
status (2.dmi.StatusRstatus2
reason (2.dmi.ConfigResponse.ReasonRreason#

reason_detail (	RreasonDetail"
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
ERROR_FETCHING_CONFIG
INVALID_CONFIG!
OPERATION_ALREADY_IN_PROGRESS
DEVICE_UNREACHABLE"F
StartupConfigInfoRequest*
device_uuid (2	.dmi.UuidR
deviceUuid"
StartupConfigInfoResponse#
status (2.dmi.StatusRstatus=
reason (2%.dmi.StartupConfigInfoResponse.ReasonRreason

config_url (	R	configUrl
version (	Rversion#

reason_detail (	RreasonDetail"^
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
DEVICE_UNREACHABLE"g
UploadDebugInfoRequest*
device_uuid (2	.dmi.UuidR
deviceUuid!
location_url (	RlocationUrl"
UploadDebugInfoStatus*
device_uuid (2	.dmi.UuidR
deviceUuid?
status (2'.dmi.UploadDebugInfoStatus.UploadStatusRstatus)
percent_uploaded (RpercentUploaded9
reason (2!.dmi.UploadDebugInfoStatus.ReasonRreason!
location_url (	RlocationUrl
	file_name (	RfileName"U
UploadStatus
UNDEFINED_UPLOAD_STATUS 
COMPLETE
IN_PROGRESS	
ERROR"
Reason
UNDEFINED_REASON 
UNKNOWN_DEVICE
INTERNAL_ERROR
DEVICE_NOT_REACHABLE
REMOTE_LOCATION_UNREACHABLE%
!REMOTE_LOCATION_PERMISSION_DENIED
ERROR_DURING_UPLOAD
DEVICE_BUSY
ERROR_IN_REQUEST
DEVICE_IN_WRONG_STATE	!
OPERATION_ALREADY_IN_PROGRESS
2
NativeSoftwareManagementServiceQ
GetSoftwareVersion.dmi.HardwareID*.dmi.GetSoftwareVersionInformationResponse>

DownloadImage.dmi.DownloadImageRequest.dmi.ImageStatus04

ActivateImage.dmi.HardwareID.dmi.ImageStatus0;
RevertToStandbyImage.dmi.HardwareID.dmi.ImageStatus0G
UpdateStartupConfiguration.dmi.ConfigRequest.dmi.ConfigResponse0\
GetStartupConfigurationInfo.dmi.StartupConfigInfoRequest.dmi.StartupConfigInfoResponseL
UploadDebugInfo.dmi.UploadDebugInfoRequest.dmi.UploadDebugInfoStatus0B;Z9github.com/opencord/device-management-interface/v3/go/dmiJ;
  

  

 P
	
 P

 
	
  
	
 
	
 

  2 The software management concept described here is aligned with WT-383a3 (Revision: 06 April 2020).
 In particular Section 11 Software management
 TODO check model
28 Protos for managing the software on a hardware device



 "

  .

  

  


  )

  ,-

 /

 

 


 *

 -.


 


-

 

 	

  

  

  

 

 

 

 

 

 

 

 

 

 

 

 


 

 












(





#

&'



(









! $


!

 "

 "!

 "

 "	

 "

#$

#"

#

#

#"#


& ,


&

 '

 '&

 '

 '	

 '

+ Location of the configuration file, authentication (user/pass) if any should be in the url string
 The config_url would contain the protocol, credentials, the IP address/DNS of the server and the path of the file
 e.g. sftp://download_user:download_pass@192.168.0.1:22/OLT-configs/config-v1.2.3.xml


+'

+


+

+


. ;


.

 /7

 /	

  0

  0

  0

 1

 1

 1

 2

 2

 2

 3"

 3

 3 !

 4

 4

 4

 5*

 5%

 5()

 6

 6

 6

 8

 87

 8


 8

 8

9

98

9


9

9

:

:9

:


:

:


= ?


= 

 >

 >="

 >

 >	

 >


A R


A!

 BG

 B	

  C

  C

  C

 D

 D

 D

 E

 E

 E

 F

 F

 F

 H

 HG

 H


 H

 H

I

IH

I


I

I

M The config_url is an optional attribute, the device manager could return the location from
 where the config was downloaded. Also it would not be present/empty for a fresh device into which the
 startup config would have been installed in the factory.


MI

M


M

M

P The version of the startup configuration. It is recommended to use semVer, but the DM implementations
 and operators could choose any other format as well.


PM

P


P

P

Q

QP

Q


Q

Q


T [


T

 U

 UT 

 U

 U	

 U

Z location_url is the remote location where the information needed for troubleshooting should be uploaded.
 Authentication (user/pass) if any should be in the location_url string
 The locaion_url would contain the protocol, credentials, the IP address/DNS of the server and the path of the directory
 e.g. sftp://upload_user:upload_pass@192.168.0.1:22/hw_debug_info/


ZU

Z


Z

Z

^ s Implementations would be expected to stream multiple UploadDebugInfoStatus indicating the progress of the upload



^

 _

 _^

 _

 _	

 _

 af

 a	

  b$

  b

  b"#

 c

 c

 c

 d

 d

 d

 e

 e

 e

h

hf

h

h

h

n percent_uploaded is the percentage of the upload that is done
 should be a value between 0 and 100 when status is IN_PROGRESS
 should be 100 when status is COMPLETE
 can be set to -1 if the device manager implementations cannot support
 the progress percentage


nh

n	

n


n

p

p	

 q

 q

 q

r

r

r

s

s

s

v! The DM implementations should have retry mechanisms (timeout values dependant on specific implementations)
 and even after those if the operation cannot be completed/reached then return error with reason as DEVICE_NOT_REACHABLE


v

v 

w(

w#

w&'

x.

x)

x,-

y 

y

y

z

z

z
3
|$ wrong location_url in the request


|

|

	}"

	}

	} !


~+


~%


~(*
9
"+ reason specifies why the status is ERROR






















 file_name is the file at location_url where the debug information was uploaded.
 Implementations need to ensure that file_name is unique at the remote location.
 file_name to be shared in the response stream when the upload begins.











  

 '
V
  VH Get the software version information of the Active and Standby images


  

  %

  /T
v
 Hh Downloads and installs the image in the standby partition, returns the status/progress of the Install


 

 *

 4:

 ;F

 > Activates and runs the OLT with the image in the standby partition. If things are fine this image will
 henceforth be marked as the Active Partition. The old working image would remain on the Standby partition.
 Any possibly required (sub-)steps like "commit" are left to the "Device Manager"


 

  

 *0

 1<

 E Marks the image in the Standby as Active and reboots the device, so that it boots from that image which was in the standby.
 This API is to be used if operator wants to go back to the previous software


 

 '

 17

 8C
{
 Qm This API can be used to let the devices pickup their properitary configuration which they need at startup.


 "

 #0

 :@

 AO
|
 an This API can be used to retrieve information about the current startup configuration that a device is using


 #

 $<

 F_

 Vw This API can be used to upload to a remote location, information useful for troubleshooting problems on the hardware


 

 .

 8>

 ?Tbproto3