# Build Variable Descriptions

This page documents all the configuration variables that can be set in a [POD
config](install.md#pod-config), [scenario](install.md#scenarios), or
[profile_manifests](https://github.com/opencord/platform-install/tree/master/profile_manifests).

These variables are used in and apply to the following repositories:

- [cord](https://github.com/opencord/cord) (aka "build" when checked out)
- [maas](https://github.com/opencord/maas)
- [platform-install](https://github.com/opencord/platform-install)

## addresspool_public_cidr

CIDR address for Public AddressPool

## addresspool_public_hwaddr_prefix

MAC address prefix for Public AddressPool

## addresspool_vsg_cidr

CIDR address for vSG AddressPool

## addresspool_vsg_hwaddr_prefix

MAC address prefix for vSG AddressPool

## apt_cacher_name

DNS name for the apt-cacher-ng server used by compute nodes and LXC containers
on head node.

## apt_cacher_port

Port number used for apt-cacher-ng.

## apt_ssl_sites

APT package sources are on HTTPS servers.  These bypass apt-cacher-ng, which
can't proxy SSL connections.

## build_cord_dir

Directory on the `build` node that the `cord` directory (root directory checked
out by `repo`) is copied to.

## build_docker_tag

Tag applied to all built (and downloaded standalone) Docker images.

## carrierethernet_domainid_prefix

Domain ID prefix added to TOSCA that is used to configure the E-CORD
CarrierEthernet app.

## ca_digest

Name of the digest (aka "hash") algorithm used when creating CA SSL
certificates.

## ca_im_days

Length of time in days that an Intermediate Certificate Authority cert will be
valid for.

## ca_im_phrase

The passphrase (password) used to encrypt the Intermediate Certificate
Authority's private key.

## ca_im_subj

The subject (name in the certificate) of the Intermediate Certificate
Authority.

## ca_root_days

Length of time in days that the Root Certificate Authority cert will be valid
for.

## ca_root_phrase

The passphrase (password) used to encrypt the Root Certificate Authority's
private key. Default is for this to be autogenerated by the password lookup in
ansible and stored in [credentials_dir](#credentials_dir).

## ca_root_subj

The subject (name in the certificate) of the Root Certificate Authority.

## ca_size

Size of the keys used in generating the CA certificates, in bits.

## cert_days

Length of times that a standard server/client certificate will be valid for

## cert_digest

Name of the digest (aka "hash") algorithm used when creating SSL certificates.

## cert_size

Size of the keys used in generating the server/client certificates, in bits.

## charm_versions

List of Juju charms and the versions used.

## client_certs

List of client SSL certificates to generate

## cloudlab_extrafs

Filesystem device to use for extra space when on CloudLab

## cloudlab_links

Symbolic links to create to use the extra space that is mounted when using
CloudLab

## computenode_fabric_interfaces

List of possible VTN external interfaces on the compute node that connect to
the fabric, for setting up OpenStack with the VTN ML2 plugin.

## config_cord_dir

Location of the `cord` directory on the config node. See also
[build_cord_dir](#build_cord_dir).

## config_cord_profile_dir

Location of the `cord_profile` directory on the config node.

## cord_config_app_version

Version of the CORD config ONOS app to use

## cord_in_a_box

Used to determine if this is a Cord-in-a-Box virtual pod installation

## cord_vtn_app_version

Version of the CORD VTN ONOS app to use

## credentials_dir

The location of the `credentials_dir` directory on the head node

## delete_cord_profile_dir

Boolean value, whether or not to delete the `cord_profile` directory when
tearing down XOS on a pod

## deploy_docker_registry

DNS name or IP address of the Docker Registry

## deploy_docker_tag

Tag used to identify which docker images to use when performing a deployment.

## deployment_flavors

Names of OpenStack "flavors" of VM's that can be deployed.

## deployment_type

Deployment type, used in XOS to identify the type of deployment.

## dhcpd_subnets

Used to configure the DHCP server used in OpenCloud and other non-MaaS
deployments.

## dns_check_domain

Domaing to check when performing the prerequisite check.

## dns_check_record

DNS record returned when [dns_check_domain](#dns_check_domain) is looked up for
DNS resolution prerequisite check.

## dns_search

Which domain suffixes to search for hosts in (non-MaaS)

## dns_servers

IP addresses of DNS servers

## dns_ttl

Time-to-live for DNS entries when using NSD (non-MaaS)

## docker_apt_repo

Name of the Docker APT repo to install Docker from

## docker_opts

Options to provide to Docker to configure the

## dpdk_lcore_mask

DPDK option to set which CPU cores to use. More documentation at:
[http://docs.openvswitch.org/en/latest/intro/install/dpdk/#setup-ovs](http://docs.openvswitch.org/en/latest/intro/install/dpdk/#setup-ovs)

## dpdk_socket_memory

DPDK option concerning memory allocation.

## enabled_gui_extensions

List of GUI extensions enabled and loaded into the Web UI

## epc_blueprint

Name of the blueprint to use with the [M-CORD](/profiles/mcord/) EPC service.

## epc_sync_objects

List of instances to wait for when testing the EPC service.

## fabric_interfaces

External VTN interfaces connected to the fabric switches.

## fabric_net_interfaces

Physical interfaces connected to the VTN fabric network switches.

## fabric_network_cfg_json

Filename of the JSON file  used to configure the Fabric ONOS.

## gerrit_changesets

List of gerrit

## gui_api_endpoint

Partial URI to the API endpoint used by the GUI to contact the XOS API

## gui_background

Backgrund image used behind login screen when logging into XOS.

## gui_favicon

Favicon used in URL bar for XOS web UI.

## gui_logo

Logo used in XOS web UI.

## gui_payoff

Text below the Logo in the XOS web UI.

## gui_project_name

Name of the type of POD being deployed, shown in XOS UI.

## gui_routes

Links given in the top-level of the XOS web UI to specific objects, to feature
them in the sidebar.

## gui_websocket

URI path used by XOS web UI for the websocket connection.

## gw_port

Port on the XOS ws container for XOS UI connections

## head_cord_dir

Location on the headnode where the `cord` directory is copied.

## head_cord_profile_dir

Location on the headnode where the `cord_profile` directory is copied.

## head_credentials_dir

Location on the headnode where the `credentials` diretory is copied.

## head_lxd_list

List of LXD containers (for Juju/OpenStack) to create.

## head_mavenrepo_dir

Location on the headnode to create the `mavenrepo` directory, which contains
the docker-compose.yml file for the Maven repo docker container that serves up
ONOS Apps to the ONOS instances on the headnode.

## head_onos_cord_dir

Location on the headnode to create the `onos_cord` directory, which contains
configuration and the docker-compose.yml file for starting the ONOS instance
that runs the VTN app.

## head_onos_fabric_dir

Location on the headnode to create the `onos_fabric` directory, which contains
configuration and the docker-compose.yml file for starting the ONOS instance
that runs the Fabric app.

## head_xos_admin_pass

Contains the XOS admin password, used for loading TOSCA into XOS.  Can't use
the standard [xos_admin_pass](#xosadminpass) as these playbooks are run from a
context (like the MaaS provisioning container) where they may not have access
to the same file with the password.

## headnode_dns

DNS Name of the headnode on the system, used to configure NSD DNS aliases.

## headnode_fabric_bridge

Name of the fabric bridge interface on the head node.

## headnode_nat_interface

Network interface on the head node that is connected to the internet.  NAT is
performed on this interface giving the other nodes on the network access
(mainly for nodes on the management network).

## hugepages

DPDK setting to control memory allocation.

## image_dir

Directory to download OpenStack glance images into on the head node.

## juju_config_path

Path to Juju configuration file.

## keystone_admin_password

Password for OpenStack Keystone `admin` user.

## kvm_check

Whether or not to perform a check for processor virtualization features
required for the KVM hypervisor to work.

## log4j_port

Port used by ONOS containers for sending log4j logging messages to ElasticStack.

## logging_host

Hostname (or IP) for the ElasticStack logging host machine.

## management_net_bridge

Name of the management bridge interface on head and compute nodes.

## management_net_cidr

CIDR of the head node management network that connects between the OpenStack
LXC containers and compute nodes.

## management_net_interfaces

List of physical interfaces on a node connected to the management network.
These are bonded together into `mgmtbond`.

## mcord_ng40_license_email

Email address used when licensing the [NG40 tester software](profiles/mcord/installation_guide.md#ng40-vtester-m-cord-license).

## mcord_ng40_login

Login used with the [NG40 tester software](profiles/mcord/installation_guide.md#ng40-vtester-m-cord-license).

## mcord_ng40_password

Password used with the [NG40 tester software](profiles/mcord/installation_guide.md#ng40-vtester-m-cord-license).

## min_memtotal_mb

Minimum amount of memory to allow for a full virtual POD to be built with.

## min_processor_vcpus

Minimum number of CPU's to allow for a full virtual POD to be built with.

## nsd_conf

Path to the `nsd.conf` file for configuring the NSD authoritative nameserver.

## nsd_group

Group used by the NSD nameserver.

## nsd_ip

IP address of the NSD nameserver. Usually this is set to the loopback address,
as Unbound runs on the external interfaces.

## nsd_port

Port that NSD will listen on.

## nsd_zones

Configuration of DNS Zones that NSD provides authoritative DNS lookups for.

## nsd_zonesdir

Directory where DNS Zone files are kept for NSD.

## onos_cord_port

Port used for SSH connections to the `ONOS CORD` instance.

## onos_debug_appnames

Names of ONOS Apps loaded to change the logging level on for debugging purposes.

## onos_debug_level

The logging level (`INFO`, `DEBUG`, `TRACE`, etc.) to set ONOS Apps listed in
[onos_debug_appnames](#onos_debug_appnames).

## onos_docker_image

Name of the docker image used to bring up ONOS containers.

## onos_log_level

Default logging level ONOS should log at.

## onos_mavenrepo_url

URL for the mavenrepo deployed as a part of the POD, where ONOS instances will
download apps from.

## physical_node_list

List of physical nodes to set up in DNS.

## pki_dir

Location where SSL certificates are generated on the `config` node. Contains
subdirectories for root and intermediate CA certificates.

## pmd_cpu_mask

DPDK setting for CPU pinning.

## pod_sshkey_name

Name of the SSH key generated to be used by the pod, specifically for logging
into instance VM's that are brought up.

## profile_library

The name of the profile-specific onboarding TOSCA file.

## pull_docker_registry

DNS Name or IP of the Docker Registry to pull images from.

## pull_docker_tag

Tag for pulling Docker images.

## repo_checksum

Checksum of the [repo](https://code.google.com/archive/p/git-repo/) download.

## repo_dl_url

URL of `repo` to download.

## repo_manifest_url

URL of Gerrit manifest repository that `repo` fetches it's list of git
repositories from.

## requests_ca_bundle

When using python's requests module, name of the CA certificate bundle file to
use to validate SSL certificates.

## run_dist_upgrade

Whether or not to run `apt-get dist-upgrrade` on a system in the course of
setting it up.

## server_certs

List of SSL certificates to generate for server use.

## site_humanname

Human readable name to use for the CORD site.

## site_name

Machine readable name to use for the CORD site. This should be one word,
without spaces.

## site_suffix

The DNS suffix applied to all machines created for this site. Must be a valid
DNS name.

## ssh_ca_phrase

The passphrase used to encrypt the Root CA key when creating a SSL hierarchy.

## ssh_client_genkeys

Names of SSH Client keys to generate and sign by the SSH CA.

## ssh_host_genkeys

Names of SSH Host keys to generatte and sign by the SSH CA.

## ssh_keysize

Size in bits of SSH keys to generate

## ssh_keytype

The key type of the SSH keys.  `rsa` is used currently, may change this as
support for newer key algorithms is added to the underlying platform.

## ssh_pki_dir

Directory where SSH keys are generated.

## ssl_cert_subj_prefix

SSL certificate prefix substring to use when generating certificates.

## test_networks

List of OpenStack Neutron networks to check for.  Currently only used in the
`test-mcord-base` role.

## test_ports

List of OpenStack Neutron network ports on VM's to check for.  Currently only
used in the `test-mcord-base` role.

## test_services

List of active OpenStack Nova VM instances to check for.  Currently only used
in the `test-mcord-base` role.

## trust_store_pw

Java KeyStore password used for encrypting SSL certificates.  This currently
doesn't contain any secure certificates, just the generated CA
root/intermediate certificates for validation of SSL connections.

## unbound_conf

Path for the Unbound recursive DNS resolver configuration file.

## unbound_group

Group name used by Unbound server.

## unbound_listen_zones

Toggle for listening on first IP address listed in the [nsd_zones](#nsdzones) list.

## unbound_listen_all

Whether Unbound should listen on all available network interfaces.

## unbound_listen_on_default

Whether Unbound should listen on the default gateway interface (as known to Ansible).

## use_addresspool_public

Toggle whether to create the Public AddressPool NAT interface

## use_addresspool_vsg

Toggle whether to create the VSG AddressPool NAT interface

## use_apt_cache

Enables the use of `apt-cacher-ng` to cache APT packages on Head/LXC/Compute nodes.

## use_elasticstack

Enables elasticstack (aka `ELK`) for log aggregation

## use_dpdk

Enable DPDK in OpenStack Nova and Neutron

## use_fabric

Start and use ONOS in a container to manage fabric switches

## use_maas

Use MaaS to manage compute nodes and switches.

## use_openstack

Bring up and use OpenStack to manage VM's.

## use_redis

Use redis as a message bus inside XOS.

## use_vtn

Use the ONOS VTN app to manage networks for virtual instances.

## use_vtn_net_fabric

Whether to enable the VTN FABRIC network.

## use_vtn_net_management_host

Whether to enable the VTN MANAGEMENT_HOST network.

## vcpu_pin_set

DPDK setting to specify CPU pinning.

## vsg_test_ping_target

DNS name of the server to ping when running the vSG portion of the
[pod-test](install_virtual.md#test-vsg).

## vtn_integration_bridge_interface

Which network interface is added to the `br-int` integration bridge by VTN when
setting up OpenVSwitch on compute nodes.

## vtn_net_management_host_hwaddr_prefix

MAC address prefix for interfaces on the VTN MANAGEMENT_HOST network.

## vtn_net_management_host_cidr

CIDR for the MANAGEMENT_HOST VTN network.

## vtn_net_management_host_interface


## vtn_net_management_host_range_xos_high

Last IP address to assign as a part of the management_hosts VTN network.

## vtn_net_management_host_range_xos_low

First IP address to assign as a part of the management_hosts VTN network.

## vtn_net_management_local_cidr

CIDR for the management_local VTN network. Used for local networking on compute nodes.

## vtn_net_public_cidr

CIDR for the PUBLIC VTN network.

## vtn_net_public_hwaddr_prefix

MAC address prefix for interfaces on the VTN PUBLIC network.

## xos_admin_first

First name of the XOS Admin user

## xos_admin_last

Last tname of the XOS Admin user

## xos_admin_pass

Password of the XOS Admin user (autogenerated by default)

## xos_admin_user

Username (email) of the XOS Admin user

## xos_bootstrap_ui_port

Port to connect to to bootstrap the XOS interface.

## xos_chameleon_port

Port used by Chameleon in XOS.

## xos_db_name

XOS Postgres database name

## xos_db_password

XOS Postgres database password.

## xos_db_username

XOS Postgres database username.

## xos_dir

Path of XOS directory within Docker containers.

## xos_docker_networks

Name of networks created in Docker for XOS containers.

## xos_gui_service_graph_constraints

Textual set of constraints that controls how the service graph is displayed in
the GUI. [Guide for writing
constraints](xos-gui/developer/service_graph.md#define-the-position-of-the-services-in-the-graph).

## xos_images

List of OpenStack Glance images in QCOW2 format that are downloaded.

## xos_other_templates

List of templates to generate when creating the `cord_profile` directory.

## xos_services

List of XOS services to load, including the name, path and whether SSH keypairs
should be included for the services.

## xos_tosca_config_templates

List of XOS tosca templates to load that make up the service graph of a
profile.

## xos_new_tosca_config_templates

List of XOS tosca templates to load that make up the service graph of a
profile. Deprecated, see: [xos_tosca_config_templates](#xostoscaconfigtemplates)

## xos_tosca_url

URL for the XOS TOSCA API endpoint

## xos_ui_port

XOS Web UI port to use for API access.

## xos_users

List of additional users to create in XOS, in addition to
[xos_admin_user](#xosadminuser).

