# Summary

* [Guide Overview](README.md)
* [Terminology](terminology.md)
* [Building and Installing CORD](install.md)
    * [POD Quickstarts](quickstarts.md)
    * [Installing a Virtual POD (CiaB)](install_virtual.md)
    * [Installing a Physical POD](install_physical.md)
        * [Basic Configuration](appendix_basic_config.md)
        * [Network Settings](appendix_network_settings.md)
        * [Connecting to Upstream Networks](vrouter.md)
        * [Container Images](appendix_images.md)
        * [vSG Configuration](appendix_vsg.md)
    * [Troubleshooting and Build Internals](troubleshooting.md)
    * [Building Docker Images](build_images.md)
    * [Build System Config Glossary](build_glossary.md)
* [Operating and Managing CORD](operate/README.md)
    * [Powering Up a POD](operate/power_up.md)
    * [XOS Internals](xos/xos_internals.md)
    * [REST API](operate/rest_apis.md)
    * [TOSCA](xos-tosca/README.md)
* [Defining Models in CORD](xos/README.md)
    * [XOS Support for Models](xos/dev/xproto.md)
    * [Core Models](xos/core_models.md)
    * [Security Policies](xos/security_policies.md)
    * [Writing Synchronizers](xos/dev/synchronizers.md)
        * [Design Guidelines](xos/dev/sync_arch.md)
        * [Implementation Details](xos/dev/sync_impl.md)
    * [Migrating Models to 4.0](xos/migrate_4.0.md)
* [Developing for CORD](develop.md)
    * [Getting the Source Code](getting_the_code.md)
    * [Workflow: Mock Configuration](xos/dev/workflow_mock_single.md)
    * [Workflow: Local](xos/dev/workflow_local.md)
    * [Workflow: Virtual POD](xos/dev/workflow_pod.md)
    * [Example Service](xos/example_service.md)
    * [Bootstrapping data in XOS](platform-install/bootstrap_models_in_xos.md)
    * [Configuring XOS](xos/modules/xosconfig.md)
    * [GUI Development](xos-gui/developer/README.md)
        * [Quickstart](xos-gui/developer/quickstart.md)
        * [Service Graph](xos-gui/developer/service_graph.md)
        * [GUI Extensions](xos-gui/developer/gui_extensions.md)
        * [GUI Internals](xos-gui/architecture/README.md)
            * [Module Strucure](xos-gui/architecture/gui-modules.md)
            * [Data Sources](xos-gui/architecture/data-sources.md)
        * [Tests](xos-gui/developer/tests.md)
    * [Unit Tests](xos/dev/unittest.md)
* [Testing CORD](cord-tester/README.md)
    * [Running Tests](cord-tester/running.md)
    * [Test Environment](cord-tester/qa_testsetup.md)
* [Service Profiles](service-profiles.md)
    * [R-CORD](profiles/rcord/README.md)
    * [E-CORD](profiles/ecord/README.md)
        * [Overview](profiles/ecord/overview.md)
        * [Installation](profiles/ecord/installation_guide.md)
        * [Developers](profiles/ecord/dev_guide.md)
        * [Troubleshooting](profiles/ecord/troubleshooting.md)
        * [CFM Configuration](profiles/ecord/cfm.md)
    * [M-CORD](profiles/mcord/README.md)
        * [Overview](profiles/mcord/overview.md)
        * [Installation](profiles/mcord/installation_guide.md)
        * [Developers](profiles/mcord/dev_guide.md)
        * [Troubleshooting](profiles/mcord/troubleshooting.md)
* [Release Notes](release-notes/sd-dot-one.md)

