
# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


# -*- text -*-
##
## admin.sql -- MySQL commands for creating the RADIUS user.
##
##	WARNING: You should change 'localhost' and 'radpass'
##		 to something else.  Also update raddb/sql.conf
##		 with the new RADIUS password.
##
##	$Id: 5c91384c0991ea9614b7c798a1ab4c89ca227115 $

#
#  Create default administrator for RADIUS
#
CREATE USER 'radius'@'localhost';
SET PASSWORD FOR 'radius'@'localhost' = PASSWORD('radpass');

# The server can read any table in SQL
GRANT ALL ON radius.* TO 'radius'@'localhost' identified by 'radpass';
GRANT ALL ON radius.* TO 'radius'@'radsrvr' identified by 'radpass';

# The server can write to the accounting and post-auth logging table.
#
#  i.e.
#GRANT ALL on radius.radacct TO 'radius'@'localhost' identified by 'radpass';
#GRANT ALL on radius.radacct TO 'radius'@'radsrvr' identified by 'radpass';
