/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.global.orchestration.cli.commands;

import com.google.common.collect.Lists;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;

import org.onosproject.cli.AbstractShellCommand;
import org.opencord.ce.api.models.EvcConnId;
import org.opencord.ce.api.services.MetroOrchestrationService;

import java.util.List;

/**
 * CLI command for removing a list of Ethernet Virtual Connections.
 */

@Command(scope = "onos", name = "ce-evc-remove", description = "Carrier Ethernet specific EVC removal command")
public class CarrierEthernetRemoveEvcCommand extends AbstractShellCommand {

    @Argument(index = 0, name = "argEvcIdList",
            description = "EVC ID List", required = true, multiValued = true)
    List<String> argEvcConnIdList = Lists.newArrayList();

    @Override
    protected void execute() {
        MetroOrchestrationService ceManager = get(MetroOrchestrationService.class);
        argEvcConnIdList.forEach(id -> {
            EvcConnId evcId = EvcConnId.of(id);
            if (ceManager.evcMap().containsKey(evcId)) {
                ceManager.removeEvc(evcId);
                print("Removed EVC %s", evcId.toString());
            } else {
                print("EVC %s doesn't exist", evcId.toString());
            }
        });
    }
}