/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.api.services.channel;

import org.opencord.ce.api.services.MetroNetworkVirtualNodeService;

import java.util.Set;

/**
 * Service used by the southbound components of the global ONOS to listen for EVCs setup.
 */
public interface ControlChannelListenerService {

    void addListener(MetroNetworkVirtualNodeService listener);

    void removeListener(MetroNetworkVirtualNodeService listener);

    Set<MetroNetworkVirtualNodeService> listeners();
}
