/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.opencord.ce.local.fabric;

import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;

/**
 * Configuration for single switch CORD fabric manager for Carrier Ethernet services.
 */
public class CarrierEthernetFabricConfig extends Config<ApplicationId> {
    private static final int DEFAULT_PORT = 8181;
    private static final String DEFAULT_USERNAME = "onos";
    private static final String DEFAULT_PASSWORD = "rocks";

    private static final String PUBLIC_IP = "publicIp";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String DEVICE_ID = "deviceId";

    @Override
    public boolean isValid() {
        return hasOnlyFields(PUBLIC_IP, PORT, USERNAME, PASSWORD, DEVICE_ID) &&
                publicIp() != null &&
                deviceId() != null;
    }

    public IpAddress publicIp() {
        String ip = get(PUBLIC_IP, null);
        try {
            return IpAddress.valueOf(ip);
        } catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Integer port() {
        String port = get(PORT, String.valueOf(DEFAULT_PORT));
        try {
            return Integer.valueOf(port);
        } catch (NumberFormatException e) {
            return DEFAULT_PORT;
        }
    }

    public String username() {
        return get(USERNAME, String.valueOf(DEFAULT_USERNAME));
    }

    public String password() {
        return get(PASSWORD, String.valueOf(DEFAULT_PASSWORD));
    }

    public DeviceId deviceId() {
        String did = get(DEVICE_ID, null);
        try {
            return DeviceId.deviceId(did);
        } catch (IllegalArgumentException e) {
            return null;
        }
    }
}
