/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.api.services.channel;


import org.apache.commons.lang3.tuple.Pair;
import org.onlab.packet.IpAddress;
import org.onosproject.net.domain.DomainId;

import javax.ws.rs.client.Client;

/**
 * Service to control local and remote domain endpoints.
 */
public interface ConnectionService {

    /**
     * Gets the ip of the local (ONOS cluster) instance in charge of handling the communication
     * with the specified domain.
     *
     * @param domainId domain identifier
     * @return ip address of the local instance
     */
    IpAddress getLocalMasterIp(String domainId);

    /**
     * Gets the ip of the remote (ONOS cluster) instance in charge of
     * handling the communication with the local cluster.
     *
     * @param domainId domain identifier of the remote cluster
     * @return the ip address of the remote instance
     */
    IpAddress getRemoteMasterIp(String domainId);

    /**
     * Gets the connection info for the specified domain.
     *
     * @param domainId target domain ID
     * @return pair of http client object and destination IP address
     */
    Pair<Client, IpAddress> getConnectionInfo(DomainId domainId);
}
