/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.api.services.virtualprovider;


import org.onosproject.net.DeviceId;
import org.onosproject.net.domain.DomainId;

import java.util.Objects;

import static com.google.common.base.MoreObjects.toStringHelper;

/**
 * Default implementation of a domain device.
 */
public class DefaultDomainVirtualDevice implements DomainVirtualDevice {
    private final DeviceId deviceId;
    private final DomainId domainId;

    public DefaultDomainVirtualDevice(DeviceId deviceId, DomainId domainId) {
        this.deviceId = deviceId;
        this.domainId = domainId;
    }

    @Override
    public DeviceId deviceId() {
        return deviceId;
    }

    @Override
    public DomainId domainId() {
        return domainId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), deviceId, domainId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDomainVirtualDevice) {
            final DefaultDomainVirtualDevice other = (DefaultDomainVirtualDevice) obj;
            return  Objects.equals(this.deviceId, other.deviceId()) &&
                    Objects.equals(this.domainId, other.domainId());

        }
        return false;
    }

    @Override
    public String toString() {
        return toStringHelper(this)
                .add("deviceId", deviceId.toString())
                .add("domainId", domainId)
                .toString();
    }
}
