/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.global.virtualdomain.config;

import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;

/**
 * Global XoS endpoint containing all information from XOS.
 */
public class XosEndPointConfig extends Config<ApplicationId> {

    private static final String USERNAME = "username";
    private static final String PASSWD = "password";
    private static final String ENDPOINT = "endpoint";

    /**
     * Gets the enpoint from the Configuration.
     * @return a class containing all the info to connect
     */
    public XosEndPoint xos() {
        String endpoint = node.get(ENDPOINT).asText();
        String username = node.get(USERNAME).asText();
        String password = node.get(PASSWD).asText();
        return new XosEndPoint(endpoint, username, password);
    }

    public static class XosEndPoint {
        private String endpoint;
        private String username;
        private String password;

        public XosEndPoint(String endpoint, String username,
                           String password) {
            this.endpoint = endpoint;
            this.username = username;
            this.password = password;
        }

        public String endpoint() {
            return endpoint;
        }

        public String username() {
            return username;
        }

        public String password() {
            return password;
        }

    }

}
