/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.global.orchestration.cli.commands;

import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.opencord.ce.api.services.MetroOrchestrationService;

/**
 * CLI command for removing a single Ethernet Virtual Connection.
 */

@Command(scope = "onos", name = "ce-evc-remove-all", description = "Carrier Ethernet all EVC removal command")
public class CarrierEthernetRemoveEvcAllCommand extends AbstractShellCommand {

    @Override
    protected void execute() {
        MetroOrchestrationService ceManager = get(MetroOrchestrationService.class);
        final int size = ceManager.evcMap().size();
        if (size == 0) {
            print("No EVCs were found");
        } else {
            ceManager.removeAllEvcs();
            print("Removed all %d EVCs", size);
        }
    }
}